import java.io
import java.lang
import java.util
import opennlp.tools.chunker
import opennlp.tools.namefind
import opennlp.tools.postag
import opennlp.tools.sentdetect
import opennlp.tools.tokenize
import opennlp.tools.util
import org.cogroo.dictionary
import org.cogroo.text
import org.cogroo.tools.featurizer
import typing



class Analyzer:
    def analyze(self, document: org.cogroo.text.Document) -> None: ...

class ComponentFactoryI:
    def createContractionFinder(self) -> Analyzer: ...
    def createFeaturizer(self) -> Analyzer: ...
    def createNameFinder(self) -> Analyzer: ...
    def createPOSTagger(self) -> Analyzer: ...
    def createPipe(self) -> Analyzer: ...
    def createSentenceDetector(self) -> Analyzer: ...
    def createTokenizer(self) -> Analyzer: ...

class InitializationException(java.lang.RuntimeException):
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...

class Chunker(Analyzer):
    def __init__(self, chunkerME: opennlp.tools.chunker.ChunkerME): ...
    def analyze(self, document: org.cogroo.text.Document) -> None: ...

class ComponentFactory(ComponentFactoryI):
    @typing.overload
    @staticmethod
    def create(inputStream: java.io.InputStream) -> 'ComponentFactory': ...
    @typing.overload
    @staticmethod
    def create(locale: java.util.Locale) -> 'ComponentFactory': ...
    def createChunker(self) -> Analyzer: ...
    def createContractionFinder(self) -> Analyzer: ...
    def createFeaturizer(self) -> Analyzer: ...
    def createHeadFinder(self) -> Analyzer: ...
    def createLemmatizer(self) -> Analyzer: ...
    def createNameFinder(self) -> Analyzer: ...
    def createPOSTagger(self) -> Analyzer: ...
    def createPipe(self) -> Analyzer: ...
    def createSentenceDetector(self) -> Analyzer: ...
    def createShallowParser(self) -> Analyzer: ...
    def createTokenizer(self) -> Analyzer: ...

class ContractionFinder(Analyzer):
    def __init__(self, nameFinderME: opennlp.tools.namefind.NameFinderME): ...
    def analyze(self, document: org.cogroo.text.Document) -> None: ...

class Featurizer(Analyzer):
    def __init__(self, featurizerME: org.cogroo.tools.featurizer.FeaturizerME): ...
    def analyze(self, document: org.cogroo.text.Document) -> None: ...

class HeadFinder(Analyzer):
    def __init__(self, chunkerME: opennlp.tools.chunker.ChunkerME): ...
    def analyze(self, document: org.cogroo.text.Document) -> None: ...

class Lemmatizer(Analyzer):
    def __init__(self, lemmaDictionary: org.cogroo.dictionary.LemmaDictionary): ...
    def analyze(self, document: org.cogroo.text.Document) -> None: ...

class NameFinder(Analyzer):
    def __init__(self, nameFinderME: opennlp.tools.namefind.NameFinderME): ...
    def analyze(self, document: org.cogroo.text.Document) -> None: ...

class POSTagger(Analyzer):
    def __init__(self, pOSTaggerME: opennlp.tools.postag.POSTaggerME): ...
    def analyze(self, document: org.cogroo.text.Document) -> None: ...
    @staticmethod
    def createSpanList(stringArray: typing.List[str], stringArray2: typing.List[str]) -> java.util.List[opennlp.tools.util.Span]: ...

class Pipe(Analyzer):
    def __init__(self): ...
    def add(self, analyzer: Analyzer) -> None: ...
    def analyze(self, document: org.cogroo.text.Document) -> None: ...

class SentenceDetector(Analyzer):
    def __init__(self, sentenceDetectorME: opennlp.tools.sentdetect.SentenceDetectorME): ...
    def analyze(self, document: org.cogroo.text.Document) -> None: ...

class ShallowParser(Analyzer):
    def __init__(self, chunkerME: opennlp.tools.chunker.ChunkerME): ...
    def analyze(self, document: org.cogroo.text.Document) -> None: ...

class Tokenizer(Analyzer):
    def __init__(self, tokenizerME: opennlp.tools.tokenize.TokenizerME): ...
    def analyze(self, document: org.cogroo.text.Document) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("org.cogroo.analyzer")``.

    Analyzer: typing.Type[Analyzer]
    Chunker: typing.Type[Chunker]
    ComponentFactory: typing.Type[ComponentFactory]
    ComponentFactoryI: typing.Type[ComponentFactoryI]
    ContractionFinder: typing.Type[ContractionFinder]
    Featurizer: typing.Type[Featurizer]
    HeadFinder: typing.Type[HeadFinder]
    InitializationException: typing.Type[InitializationException]
    Lemmatizer: typing.Type[Lemmatizer]
    NameFinder: typing.Type[NameFinder]
    POSTagger: typing.Type[POSTagger]
    Pipe: typing.Type[Pipe]
    SentenceDetector: typing.Type[SentenceDetector]
    ShallowParser: typing.Type[ShallowParser]
    Tokenizer: typing.Type[Tokenizer]
