import java.io
import java.lang
import java.net
import java.util
import org.apache.log4j
import org.apache.log4j.or_
import typing



class AppenderAttachable:
    def addAppender(self, appender: org.apache.log4j.Appender) -> None: ...
    def getAllAppenders(self) -> java.util.Enumeration: ...
    def getAppender(self, string: str) -> org.apache.log4j.Appender: ...
    def isAttached(self, appender: org.apache.log4j.Appender) -> bool: ...
    def removeAllAppenders(self) -> None: ...
    @typing.overload
    def removeAppender(self, string: str) -> None: ...
    @typing.overload
    def removeAppender(self, appender: org.apache.log4j.Appender) -> None: ...

class Configurator:
    INHERITED: typing.ClassVar[str] = ...
    NULL: typing.ClassVar[str] = ...
    @typing.overload
    def doConfigure(self, inputStream: java.io.InputStream, loggerRepository: 'LoggerRepository') -> None: ...
    @typing.overload
    def doConfigure(self, uRL: java.net.URL, loggerRepository: 'LoggerRepository') -> None: ...

class ErrorCode:
    GENERIC_FAILURE: typing.ClassVar[int] = ...
    WRITE_FAILURE: typing.ClassVar[int] = ...
    FLUSH_FAILURE: typing.ClassVar[int] = ...
    CLOSE_FAILURE: typing.ClassVar[int] = ...
    FILE_OPEN_FAILURE: typing.ClassVar[int] = ...
    MISSING_LAYOUT: typing.ClassVar[int] = ...
    ADDRESS_PARSE_FAILURE: typing.ClassVar[int] = ...

class HierarchyEventListener:
    def addAppenderEvent(self, category: org.apache.log4j.Category, appender: org.apache.log4j.Appender) -> None: ...
    def removeAppenderEvent(self, category: org.apache.log4j.Category, appender: org.apache.log4j.Appender) -> None: ...

class LocationInfo(java.io.Serializable):
    fullInfo: str = ...
    NA: typing.ClassVar[str] = ...
    NA_LOCATION_INFO: typing.ClassVar['LocationInfo'] = ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, string4: str): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable, string: str): ...
    def getClassName(self) -> str: ...
    def getFileName(self) -> str: ...
    def getLineNumber(self) -> str: ...
    def getMethodName(self) -> str: ...

class LoggerFactory:
    def makeNewLoggerInstance(self, string: str) -> org.apache.log4j.Logger: ...

class LoggerRepository:
    def addHierarchyEventListener(self, hierarchyEventListener: HierarchyEventListener) -> None: ...
    def emitNoAppenderWarning(self, category: org.apache.log4j.Category) -> None: ...
    def exists(self, string: str) -> org.apache.log4j.Logger: ...
    def fireAddAppenderEvent(self, category: org.apache.log4j.Category, appender: org.apache.log4j.Appender) -> None: ...
    def getCurrentCategories(self) -> java.util.Enumeration: ...
    def getCurrentLoggers(self) -> java.util.Enumeration: ...
    @typing.overload
    def getLogger(self, string: str) -> org.apache.log4j.Logger: ...
    @typing.overload
    def getLogger(self, string: str, loggerFactory: LoggerFactory) -> org.apache.log4j.Logger: ...
    def getRootLogger(self) -> org.apache.log4j.Logger: ...
    def getThreshold(self) -> org.apache.log4j.Level: ...
    def isDisabled(self, int: int) -> bool: ...
    def resetConfiguration(self) -> None: ...
    @typing.overload
    def setThreshold(self, string: str) -> None: ...
    @typing.overload
    def setThreshold(self, level: org.apache.log4j.Level) -> None: ...
    def shutdown(self) -> None: ...

class LoggingEvent(java.io.Serializable):
    fqnOfCategoryClass: str = ...
    categoryName: str = ...
    level: org.apache.log4j.Priority = ...
    timeStamp: int = ...
    @typing.overload
    def __init__(self, string: str, category: org.apache.log4j.Category, long: int, level: org.apache.log4j.Level, object: typing.Any, string2: str, throwableInformation: 'ThrowableInformation', string3: str, locationInfo: LocationInfo, map: typing.Union[java.util.Map, typing.Mapping]): ...
    @typing.overload
    def __init__(self, string: str, category: org.apache.log4j.Category, long: int, priority: org.apache.log4j.Priority, object: typing.Any, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, category: org.apache.log4j.Category, priority: org.apache.log4j.Priority, object: typing.Any, throwable: java.lang.Throwable): ...
    def getFQNOfLoggerClass(self) -> str: ...
    def getLevel(self) -> org.apache.log4j.Level: ...
    def getLocationInformation(self) -> LocationInfo: ...
    def getLogger(self) -> org.apache.log4j.Category: ...
    def getLoggerName(self) -> str: ...
    def getMDC(self, string: str) -> typing.Any: ...
    def getMDCCopy(self) -> None: ...
    def getMessage(self) -> typing.Any: ...
    def getNDC(self) -> str: ...
    def getProperties(self) -> java.util.Map: ...
    def getProperty(self, string: str) -> str: ...
    def getPropertyKeySet(self) -> java.util.Set: ...
    def getRenderedMessage(self) -> str: ...
    @staticmethod
    def getStartTime() -> int: ...
    def getThreadName(self) -> str: ...
    def getThrowableInformation(self) -> 'ThrowableInformation': ...
    def getThrowableStrRep(self) -> typing.List[str]: ...
    def getTimeStamp(self) -> int: ...
    def locationInformationExists(self) -> bool: ...
    def removeProperty(self, string: str) -> typing.Any: ...
    def setProperty(self, string: str, string2: str) -> None: ...

class NOPLogger(org.apache.log4j.Logger):
    def __init__(self, nOPLoggerRepository: 'NOPLoggerRepository', string: str): ...
    def addAppender(self, appender: org.apache.log4j.Appender) -> None: ...
    def assertLog(self, boolean: bool, string: str) -> None: ...
    def callAppenders(self, loggingEvent: LoggingEvent) -> None: ...
    @typing.overload
    def debug(self, object: typing.Any) -> None: ...
    @typing.overload
    def debug(self, object: typing.Any, throwable: java.lang.Throwable) -> None: ...
    @typing.overload
    def error(self, object: typing.Any) -> None: ...
    @typing.overload
    def error(self, object: typing.Any, throwable: java.lang.Throwable) -> None: ...
    @typing.overload
    def fatal(self, object: typing.Any) -> None: ...
    @typing.overload
    def fatal(self, object: typing.Any, throwable: java.lang.Throwable) -> None: ...
    def getAllAppenders(self) -> java.util.Enumeration: ...
    def getAppender(self, string: str) -> org.apache.log4j.Appender: ...
    def getChainedPriority(self) -> org.apache.log4j.Priority: ...
    def getEffectiveLevel(self) -> org.apache.log4j.Level: ...
    def getResourceBundle(self) -> java.util.ResourceBundle: ...
    @typing.overload
    def info(self, object: typing.Any) -> None: ...
    @typing.overload
    def info(self, object: typing.Any, throwable: java.lang.Throwable) -> None: ...
    def isAttached(self, appender: org.apache.log4j.Appender) -> bool: ...
    def isDebugEnabled(self) -> bool: ...
    def isEnabledFor(self, priority: org.apache.log4j.Priority) -> bool: ...
    def isInfoEnabled(self) -> bool: ...
    def isTraceEnabled(self) -> bool: ...
    @typing.overload
    def l7dlog(self, priority: org.apache.log4j.Priority, string: str, objectArray: typing.List[typing.Any], throwable: java.lang.Throwable) -> None: ...
    @typing.overload
    def l7dlog(self, priority: org.apache.log4j.Priority, string: str, throwable: java.lang.Throwable) -> None: ...
    @typing.overload
    def log(self, string: str, priority: org.apache.log4j.Priority, object: typing.Any, throwable: java.lang.Throwable) -> None: ...
    @typing.overload
    def log(self, priority: org.apache.log4j.Priority, object: typing.Any) -> None: ...
    @typing.overload
    def log(self, priority: org.apache.log4j.Priority, object: typing.Any, throwable: java.lang.Throwable) -> None: ...
    def removeAllAppenders(self) -> None: ...
    @typing.overload
    def removeAppender(self, string: str) -> None: ...
    @typing.overload
    def removeAppender(self, appender: org.apache.log4j.Appender) -> None: ...
    def setLevel(self, level: org.apache.log4j.Level) -> None: ...
    def setPriority(self, priority: org.apache.log4j.Priority) -> None: ...
    def setResourceBundle(self, resourceBundle: java.util.ResourceBundle) -> None: ...
    @typing.overload
    def trace(self, object: typing.Any) -> None: ...
    @typing.overload
    def trace(self, object: typing.Any, throwable: java.lang.Throwable) -> None: ...
    @typing.overload
    def warn(self, object: typing.Any) -> None: ...
    @typing.overload
    def warn(self, object: typing.Any, throwable: java.lang.Throwable) -> None: ...

class OptionHandler:
    def activateOptions(self) -> None: ...

class RendererSupport:
    def getRendererMap(self) -> org.apache.log4j.or_.RendererMap: ...
    def setRenderer(self, class_: typing.Type, objectRenderer: org.apache.log4j.or_.ObjectRenderer) -> None: ...

class RepositorySelector:
    def getLoggerRepository(self) -> LoggerRepository: ...

class RootCategory(org.apache.log4j.Logger):
    def __init__(self, level: org.apache.log4j.Level): ...
    def getChainedLevel(self) -> org.apache.log4j.Level: ...
    def setLevel(self, level: org.apache.log4j.Level) -> None: ...
    @typing.overload
    def setPriority(self, level: org.apache.log4j.Level) -> None: ...
    @typing.overload
    def setPriority(self, priority: org.apache.log4j.Priority) -> None: ...

class RootLogger(org.apache.log4j.Logger):
    def __init__(self, level: org.apache.log4j.Level): ...
    def getChainedLevel(self) -> org.apache.log4j.Level: ...
    def setLevel(self, level: org.apache.log4j.Level) -> None: ...

class ThrowableInformation(java.io.Serializable):
    @typing.overload
    def __init__(self, stringArray: typing.List[str]): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable, category: org.apache.log4j.Category): ...
    def getThrowable(self) -> java.lang.Throwable: ...
    def getThrowableStrRep(self) -> typing.List[str]: ...

class ThrowableRenderer:
    def doRender(self, throwable: java.lang.Throwable) -> typing.List[str]: ...

class ThrowableRendererSupport:
    def getThrowableRenderer(self) -> ThrowableRenderer: ...
    def setThrowableRenderer(self, throwableRenderer: ThrowableRenderer) -> None: ...

class TriggeringEventEvaluator:
    def isTriggeringEvent(self, loggingEvent: LoggingEvent) -> bool: ...

class DefaultRepositorySelector(RepositorySelector):
    def __init__(self, loggerRepository: LoggerRepository): ...
    def getLoggerRepository(self) -> LoggerRepository: ...

class ErrorHandler(OptionHandler):
    @typing.overload
    def error(self, string: str) -> None: ...
    @typing.overload
    def error(self, string: str, exception: java.lang.Exception, int: int) -> None: ...
    @typing.overload
    def error(self, string: str, exception: java.lang.Exception, int: int, loggingEvent: LoggingEvent) -> None: ...
    def setAppender(self, appender: org.apache.log4j.Appender) -> None: ...
    def setBackupAppender(self, appender: org.apache.log4j.Appender) -> None: ...
    def setLogger(self, logger: org.apache.log4j.Logger) -> None: ...

class Filter(OptionHandler):
    next: 'Filter' = ...
    DENY: typing.ClassVar[int] = ...
    NEUTRAL: typing.ClassVar[int] = ...
    ACCEPT: typing.ClassVar[int] = ...
    def __init__(self): ...
    def activateOptions(self) -> None: ...
    def decide(self, loggingEvent: LoggingEvent) -> int: ...
    def getNext(self) -> 'Filter': ...
    def setNext(self, filter: 'Filter') -> None: ...

class NOPLoggerRepository(LoggerRepository):
    def __init__(self): ...
    def addHierarchyEventListener(self, hierarchyEventListener: HierarchyEventListener) -> None: ...
    def emitNoAppenderWarning(self, category: org.apache.log4j.Category) -> None: ...
    def exists(self, string: str) -> org.apache.log4j.Logger: ...
    def fireAddAppenderEvent(self, category: org.apache.log4j.Category, appender: org.apache.log4j.Appender) -> None: ...
    def getCurrentCategories(self) -> java.util.Enumeration: ...
    def getCurrentLoggers(self) -> java.util.Enumeration: ...
    @typing.overload
    def getLogger(self, string: str) -> org.apache.log4j.Logger: ...
    @typing.overload
    def getLogger(self, string: str, loggerFactory: LoggerFactory) -> org.apache.log4j.Logger: ...
    def getRootLogger(self) -> org.apache.log4j.Logger: ...
    def getThreshold(self) -> org.apache.log4j.Level: ...
    def isDisabled(self, int: int) -> bool: ...
    def resetConfiguration(self) -> None: ...
    @typing.overload
    def setThreshold(self, string: str) -> None: ...
    @typing.overload
    def setThreshold(self, level: org.apache.log4j.Level) -> None: ...
    def shutdown(self) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("org.apache.log4j.spi")``.

    AppenderAttachable: typing.Type[AppenderAttachable]
    Configurator: typing.Type[Configurator]
    DefaultRepositorySelector: typing.Type[DefaultRepositorySelector]
    ErrorCode: typing.Type[ErrorCode]
    ErrorHandler: typing.Type[ErrorHandler]
    Filter: typing.Type[Filter]
    HierarchyEventListener: typing.Type[HierarchyEventListener]
    LocationInfo: typing.Type[LocationInfo]
    LoggerFactory: typing.Type[LoggerFactory]
    LoggerRepository: typing.Type[LoggerRepository]
    LoggingEvent: typing.Type[LoggingEvent]
    NOPLogger: typing.Type[NOPLogger]
    NOPLoggerRepository: typing.Type[NOPLoggerRepository]
    OptionHandler: typing.Type[OptionHandler]
    RendererSupport: typing.Type[RendererSupport]
    RepositorySelector: typing.Type[RepositorySelector]
    RootCategory: typing.Type[RootCategory]
    RootLogger: typing.Type[RootLogger]
    ThrowableInformation: typing.Type[ThrowableInformation]
    ThrowableRenderer: typing.Type[ThrowableRenderer]
    ThrowableRendererSupport: typing.Type[ThrowableRendererSupport]
    TriggeringEventEvaluator: typing.Type[TriggeringEventEvaluator]
