import java.io
import java.lang
import java.net
import java.util
import org.apache.log4j.chainsaw
import org.apache.log4j.config
import org.apache.log4j.helpers
import org.apache.log4j.jdbc
import org.apache.log4j.jmx
import org.apache.log4j.lf5
import org.apache.log4j.net
import org.apache.log4j.nt
import org.apache.log4j.or_
import org.apache.log4j.pattern
import org.apache.log4j.rewrite
import org.apache.log4j.spi
import org.apache.log4j.varia
import org.apache.log4j.xml
import typing



class Appender:
    def addFilter(self, filter: org.apache.log4j.spi.Filter) -> None: ...
    def clearFilters(self) -> None: ...
    def close(self) -> None: ...
    def doAppend(self, loggingEvent: org.apache.log4j.spi.LoggingEvent) -> None: ...
    def getErrorHandler(self) -> org.apache.log4j.spi.ErrorHandler: ...
    def getFilter(self) -> org.apache.log4j.spi.Filter: ...
    def getLayout(self) -> 'Layout': ...
    def getName(self) -> str: ...
    def requiresLayout(self) -> bool: ...
    def setErrorHandler(self, errorHandler: org.apache.log4j.spi.ErrorHandler) -> None: ...
    def setLayout(self, layout: 'Layout') -> None: ...
    def setName(self, string: str) -> None: ...

class BasicConfigurator:
    @typing.overload
    @staticmethod
    def configure() -> None: ...
    @typing.overload
    @staticmethod
    def configure(appender: Appender) -> None: ...
    @staticmethod
    def resetConfiguration() -> None: ...

class Category(org.apache.log4j.spi.AppenderAttachable):
    def addAppender(self, appender: Appender) -> None: ...
    def assertLog(self, boolean: bool, string: str) -> None: ...
    def callAppenders(self, loggingEvent: org.apache.log4j.spi.LoggingEvent) -> None: ...
    @typing.overload
    def debug(self, object: typing.Any) -> None: ...
    @typing.overload
    def debug(self, object: typing.Any, throwable: java.lang.Throwable) -> None: ...
    @typing.overload
    def error(self, object: typing.Any) -> None: ...
    @typing.overload
    def error(self, object: typing.Any, throwable: java.lang.Throwable) -> None: ...
    @staticmethod
    def exists(string: str) -> 'Logger': ...
    @typing.overload
    def fatal(self, object: typing.Any) -> None: ...
    @typing.overload
    def fatal(self, object: typing.Any, throwable: java.lang.Throwable) -> None: ...
    def getAdditivity(self) -> bool: ...
    def getAllAppenders(self) -> java.util.Enumeration: ...
    def getAppender(self, string: str) -> Appender: ...
    def getChainedPriority(self) -> 'Priority': ...
    @staticmethod
    def getCurrentCategories() -> java.util.Enumeration: ...
    @staticmethod
    def getDefaultHierarchy() -> org.apache.log4j.spi.LoggerRepository: ...
    def getEffectiveLevel(self) -> 'Level': ...
    def getHierarchy(self) -> org.apache.log4j.spi.LoggerRepository: ...
    @typing.overload
    @staticmethod
    def getInstance(class_: typing.Type) -> 'Category': ...
    @typing.overload
    @staticmethod
    def getInstance(string: str) -> 'Category': ...
    def getLevel(self) -> 'Level': ...
    def getLoggerRepository(self) -> org.apache.log4j.spi.LoggerRepository: ...
    def getName(self) -> str: ...
    def getParent(self) -> 'Category': ...
    def getPriority(self) -> 'Level': ...
    def getResourceBundle(self) -> java.util.ResourceBundle: ...
    @staticmethod
    def getRoot() -> 'Category': ...
    @typing.overload
    def info(self, object: typing.Any) -> None: ...
    @typing.overload
    def info(self, object: typing.Any, throwable: java.lang.Throwable) -> None: ...
    def isAttached(self, appender: Appender) -> bool: ...
    def isDebugEnabled(self) -> bool: ...
    def isEnabledFor(self, priority: 'Priority') -> bool: ...
    def isInfoEnabled(self) -> bool: ...
    @typing.overload
    def l7dlog(self, priority: 'Priority', string: str, objectArray: typing.List[typing.Any], throwable: java.lang.Throwable) -> None: ...
    @typing.overload
    def l7dlog(self, priority: 'Priority', string: str, throwable: java.lang.Throwable) -> None: ...
    @typing.overload
    def log(self, string: str, priority: 'Priority', object: typing.Any, throwable: java.lang.Throwable) -> None: ...
    @typing.overload
    def log(self, priority: 'Priority', object: typing.Any) -> None: ...
    @typing.overload
    def log(self, priority: 'Priority', object: typing.Any, throwable: java.lang.Throwable) -> None: ...
    def removeAllAppenders(self) -> None: ...
    @typing.overload
    def removeAppender(self, string: str) -> None: ...
    @typing.overload
    def removeAppender(self, appender: Appender) -> None: ...
    def setAdditivity(self, boolean: bool) -> None: ...
    def setLevel(self, level: 'Level') -> None: ...
    def setPriority(self, priority: 'Priority') -> None: ...
    def setResourceBundle(self, resourceBundle: java.util.ResourceBundle) -> None: ...
    @staticmethod
    def shutdown() -> None: ...
    @typing.overload
    def warn(self, object: typing.Any) -> None: ...
    @typing.overload
    def warn(self, object: typing.Any, throwable: java.lang.Throwable) -> None: ...

class DefaultThrowableRenderer(org.apache.log4j.spi.ThrowableRenderer):
    def __init__(self): ...
    def doRender(self, throwable: java.lang.Throwable) -> typing.List[str]: ...
    @staticmethod
    def render(throwable: java.lang.Throwable) -> typing.List[str]: ...

class EnhancedThrowableRenderer(org.apache.log4j.spi.ThrowableRenderer):
    def __init__(self): ...
    def doRender(self, throwable: java.lang.Throwable) -> typing.List[str]: ...

class Hierarchy(org.apache.log4j.spi.LoggerRepository, org.apache.log4j.spi.RendererSupport, org.apache.log4j.spi.ThrowableRendererSupport):
    def __init__(self, logger: 'Logger'): ...
    def addHierarchyEventListener(self, hierarchyEventListener: org.apache.log4j.spi.HierarchyEventListener) -> None: ...
    def addRenderer(self, class_: typing.Type, objectRenderer: org.apache.log4j.or_.ObjectRenderer) -> None: ...
    def clear(self) -> None: ...
    def emitNoAppenderWarning(self, category: Category) -> None: ...
    def exists(self, string: str) -> 'Logger': ...
    def fireAddAppenderEvent(self, category: Category, appender: Appender) -> None: ...
    def getCurrentCategories(self) -> java.util.Enumeration: ...
    def getCurrentLoggers(self) -> java.util.Enumeration: ...
    @typing.overload
    def getLogger(self, string: str) -> 'Logger': ...
    @typing.overload
    def getLogger(self, string: str, loggerFactory: org.apache.log4j.spi.LoggerFactory) -> 'Logger': ...
    def getRendererMap(self) -> org.apache.log4j.or_.RendererMap: ...
    def getRootLogger(self) -> 'Logger': ...
    def getThreshold(self) -> 'Level': ...
    def getThrowableRenderer(self) -> org.apache.log4j.spi.ThrowableRenderer: ...
    def isDisabled(self, int: int) -> bool: ...
    def overrideAsNeeded(self, string: str) -> None: ...
    def resetConfiguration(self) -> None: ...
    def setDisableOverride(self, string: str) -> None: ...
    def setRenderer(self, class_: typing.Type, objectRenderer: org.apache.log4j.or_.ObjectRenderer) -> None: ...
    @typing.overload
    def setThreshold(self, string: str) -> None: ...
    @typing.overload
    def setThreshold(self, level: 'Level') -> None: ...
    def setThrowableRenderer(self, throwableRenderer: org.apache.log4j.spi.ThrowableRenderer) -> None: ...
    def shutdown(self) -> None: ...

class Layout(org.apache.log4j.spi.OptionHandler):
    LINE_SEP: typing.ClassVar[str] = ...
    LINE_SEP_LEN: typing.ClassVar[int] = ...
    def __init__(self): ...
    def format(self, loggingEvent: org.apache.log4j.spi.LoggingEvent) -> str: ...
    def getContentType(self) -> str: ...
    def getFooter(self) -> str: ...
    def getHeader(self) -> str: ...
    def ignoresThrowable(self) -> bool: ...

class LogManager:
    DEFAULT_CONFIGURATION_FILE: typing.ClassVar[str] = ...
    DEFAULT_CONFIGURATION_KEY: typing.ClassVar[str] = ...
    CONFIGURATOR_CLASS_KEY: typing.ClassVar[str] = ...
    DEFAULT_INIT_OVERRIDE_KEY: typing.ClassVar[str] = ...
    def __init__(self): ...
    @staticmethod
    def exists(string: str) -> 'Logger': ...
    @staticmethod
    def getCurrentLoggers() -> java.util.Enumeration: ...
    @typing.overload
    @staticmethod
    def getLogger(class_: typing.Type) -> 'Logger': ...
    @typing.overload
    @staticmethod
    def getLogger(string: str) -> 'Logger': ...
    @typing.overload
    @staticmethod
    def getLogger(string: str, loggerFactory: org.apache.log4j.spi.LoggerFactory) -> 'Logger': ...
    @staticmethod
    def getLoggerRepository() -> org.apache.log4j.spi.LoggerRepository: ...
    @staticmethod
    def getRootLogger() -> 'Logger': ...
    @staticmethod
    def resetConfiguration() -> None: ...
    @staticmethod
    def setRepositorySelector(repositorySelector: org.apache.log4j.spi.RepositorySelector, object: typing.Any) -> None: ...
    @staticmethod
    def shutdown() -> None: ...

class LogXF:
    @typing.overload
    @staticmethod
    def entering(logger: 'Logger', string: str, string2: str) -> None: ...
    @typing.overload
    @staticmethod
    def entering(logger: 'Logger', string: str, string2: str, object: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def entering(logger: 'Logger', string: str, string2: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def entering(logger: 'Logger', string: str, string2: str, string3: str) -> None: ...
    @typing.overload
    @staticmethod
    def exiting(logger: 'Logger', string: str, string2: str) -> None: ...
    @typing.overload
    @staticmethod
    def exiting(logger: 'Logger', string: str, string2: str, object: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def exiting(logger: 'Logger', string: str, string2: str, string3: str) -> None: ...
    @staticmethod
    def throwing(logger: 'Logger', string: str, string2: str, throwable: java.lang.Throwable) -> None: ...

class MDC:
    @staticmethod
    def clear() -> None: ...
    @staticmethod
    def get(string: str) -> typing.Any: ...
    @staticmethod
    def getContext() -> java.util.Hashtable: ...
    @staticmethod
    def put(string: str, object: typing.Any) -> None: ...
    @staticmethod
    def remove(string: str) -> None: ...

class NDC:
    @staticmethod
    def clear() -> None: ...
    @staticmethod
    def cloneStack() -> java.util.Stack: ...
    @staticmethod
    def get() -> str: ...
    @staticmethod
    def getDepth() -> int: ...
    @staticmethod
    def inherit(stack: java.util.Stack) -> None: ...
    @staticmethod
    def peek() -> str: ...
    @staticmethod
    def pop() -> str: ...
    @staticmethod
    def push(string: str) -> None: ...
    @staticmethod
    def remove() -> None: ...
    @staticmethod
    def setMaxDepth(int: int) -> None: ...

class Priority:
    OFF_INT: typing.ClassVar[int] = ...
    FATAL_INT: typing.ClassVar[int] = ...
    ERROR_INT: typing.ClassVar[int] = ...
    WARN_INT: typing.ClassVar[int] = ...
    INFO_INT: typing.ClassVar[int] = ...
    DEBUG_INT: typing.ClassVar[int] = ...
    ALL_INT: typing.ClassVar[int] = ...
    FATAL: typing.ClassVar['Priority'] = ...
    ERROR: typing.ClassVar['Priority'] = ...
    WARN: typing.ClassVar['Priority'] = ...
    INFO: typing.ClassVar['Priority'] = ...
    DEBUG: typing.ClassVar['Priority'] = ...
    def equals(self, object: typing.Any) -> bool: ...
    @staticmethod
    def getAllPossiblePriorities() -> typing.List['Priority']: ...
    def getSyslogEquivalent(self) -> int: ...
    def isGreaterOrEqual(self, priority: 'Priority') -> bool: ...
    def toInt(self) -> int: ...
    @typing.overload
    @staticmethod
    def toPriority(int: int) -> 'Priority': ...
    @typing.overload
    @staticmethod
    def toPriority(int: int, priority: 'Priority') -> 'Priority': ...
    @typing.overload
    @staticmethod
    def toPriority(string: str) -> 'Priority': ...
    @typing.overload
    @staticmethod
    def toPriority(string: str, priority: 'Priority') -> 'Priority': ...
    def toString(self) -> str: ...

class PropertyConfigurator(org.apache.log4j.spi.Configurator):
    LOGGER_FACTORY_KEY: typing.ClassVar[str] = ...
    def __init__(self): ...
    @typing.overload
    @staticmethod
    def configure(inputStream: java.io.InputStream) -> None: ...
    @typing.overload
    @staticmethod
    def configure(string: str) -> None: ...
    @typing.overload
    @staticmethod
    def configure(uRL: java.net.URL) -> None: ...
    @typing.overload
    @staticmethod
    def configure(properties: java.util.Properties) -> None: ...
    @typing.overload
    @staticmethod
    def configureAndWatch(string: str) -> None: ...
    @typing.overload
    @staticmethod
    def configureAndWatch(string: str, long: int) -> None: ...
    @typing.overload
    def doConfigure(self, inputStream: java.io.InputStream, loggerRepository: org.apache.log4j.spi.LoggerRepository) -> None: ...
    @typing.overload
    def doConfigure(self, string: str, loggerRepository: org.apache.log4j.spi.LoggerRepository) -> None: ...
    @typing.overload
    def doConfigure(self, uRL: java.net.URL, loggerRepository: org.apache.log4j.spi.LoggerRepository) -> None: ...
    @typing.overload
    def doConfigure(self, properties: java.util.Properties, loggerRepository: org.apache.log4j.spi.LoggerRepository) -> None: ...

class TTCCLayout(org.apache.log4j.helpers.DateLayout):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    def format(self, loggingEvent: org.apache.log4j.spi.LoggingEvent) -> str: ...
    def getCategoryPrefixing(self) -> bool: ...
    def getContextPrinting(self) -> bool: ...
    def getThreadPrinting(self) -> bool: ...
    def ignoresThrowable(self) -> bool: ...
    def setCategoryPrefixing(self, boolean: bool) -> None: ...
    def setContextPrinting(self, boolean: bool) -> None: ...
    def setThreadPrinting(self, boolean: bool) -> None: ...

class AppenderSkeleton(Appender, org.apache.log4j.spi.OptionHandler):
    def __init__(self): ...
    def activateOptions(self) -> None: ...
    def addFilter(self, filter: org.apache.log4j.spi.Filter) -> None: ...
    def clearFilters(self) -> None: ...
    def doAppend(self, loggingEvent: org.apache.log4j.spi.LoggingEvent) -> None: ...
    def finalize(self) -> None: ...
    def getErrorHandler(self) -> org.apache.log4j.spi.ErrorHandler: ...
    def getFilter(self) -> org.apache.log4j.spi.Filter: ...
    def getFirstFilter(self) -> org.apache.log4j.spi.Filter: ...
    def getLayout(self) -> Layout: ...
    def getName(self) -> str: ...
    def getThreshold(self) -> Priority: ...
    def isAsSevereAsThreshold(self, priority: Priority) -> bool: ...
    def setErrorHandler(self, errorHandler: org.apache.log4j.spi.ErrorHandler) -> None: ...
    def setLayout(self, layout: Layout) -> None: ...
    def setName(self, string: str) -> None: ...
    def setThreshold(self, priority: Priority) -> None: ...

class EnhancedPatternLayout(Layout):
    DEFAULT_CONVERSION_PATTERN: typing.ClassVar[str] = ...
    TTCC_CONVERSION_PATTERN: typing.ClassVar[str] = ...
    PATTERN_RULE_REGISTRY: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    def activateOptions(self) -> None: ...
    def format(self, loggingEvent: org.apache.log4j.spi.LoggingEvent) -> str: ...
    def getConversionPattern(self) -> str: ...
    def ignoresThrowable(self) -> bool: ...
    def setConversionPattern(self, string: str) -> None: ...

class HTMLLayout(Layout):
    LOCATION_INFO_OPTION: typing.ClassVar[str] = ...
    TITLE_OPTION: typing.ClassVar[str] = ...
    def __init__(self): ...
    def activateOptions(self) -> None: ...
    def format(self, loggingEvent: org.apache.log4j.spi.LoggingEvent) -> str: ...
    def getContentType(self) -> str: ...
    def getFooter(self) -> str: ...
    def getHeader(self) -> str: ...
    def getLocationInfo(self) -> bool: ...
    def getTitle(self) -> str: ...
    def ignoresThrowable(self) -> bool: ...
    def setLocationInfo(self, boolean: bool) -> None: ...
    def setTitle(self, string: str) -> None: ...

class Level(Priority, java.io.Serializable):
    TRACE_INT: typing.ClassVar[int] = ...
    OFF: typing.ClassVar['Level'] = ...
    FATAL: typing.ClassVar['Level'] = ...
    ERROR: typing.ClassVar['Level'] = ...
    WARN: typing.ClassVar['Level'] = ...
    INFO: typing.ClassVar['Level'] = ...
    DEBUG: typing.ClassVar['Level'] = ...
    TRACE: typing.ClassVar['Level'] = ...
    ALL: typing.ClassVar['Level'] = ...
    @typing.overload
    @staticmethod
    def toLevel(int: int) -> 'Level': ...
    @typing.overload
    @staticmethod
    def toLevel(int: int, level: 'Level') -> 'Level': ...
    @typing.overload
    @staticmethod
    def toLevel(string: str) -> 'Level': ...
    @typing.overload
    @staticmethod
    def toLevel(string: str, level: 'Level') -> 'Level': ...

class LogMF(LogXF):
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, boolean: bool) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, byte: int) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, char: str) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, double: float) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, float: float) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, int: int) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, object: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, object: typing.Any, object2: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, object: typing.Any, object2: typing.Any, object3: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, object: typing.Any, object2: typing.Any, object3: typing.Any, object4: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, long: int) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, short: int) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', throwable: java.lang.Throwable, string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def error(logger: 'Logger', string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def error(logger: 'Logger', throwable: java.lang.Throwable, string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def fatal(logger: 'Logger', string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def fatal(logger: 'Logger', throwable: java.lang.Throwable, string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, boolean: bool) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, byte: int) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, char: str) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, double: float) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, float: float) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, int: int) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, object: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, object: typing.Any, object2: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, object: typing.Any, object2: typing.Any, object3: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, object: typing.Any, object2: typing.Any, object3: typing.Any, object4: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, long: int) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, short: int) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', throwable: java.lang.Throwable, string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, boolean: bool) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, byte: int) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, char: str) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, double: float) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, float: float) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, int: int) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, object: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, object: typing.Any, object2: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, object: typing.Any, object2: typing.Any, object3: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, object: typing.Any, object2: typing.Any, object3: typing.Any, object4: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, long: int) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, short: int) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, throwable: java.lang.Throwable, string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, boolean: bool) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, byte: int) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, char: str) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, double: float) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, float: float) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, int: int) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, object: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, object: typing.Any, object2: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, object: typing.Any, object2: typing.Any, object3: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, object: typing.Any, object2: typing.Any, object3: typing.Any, object4: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, long: int) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, short: int) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, throwable: java.lang.Throwable, string: str, string2: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, boolean: bool) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, byte: int) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, char: str) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, double: float) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, float: float) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, int: int) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, object: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, object: typing.Any, object2: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, object: typing.Any, object2: typing.Any, object3: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, object: typing.Any, object2: typing.Any, object3: typing.Any, object4: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, long: int) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, short: int) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', throwable: java.lang.Throwable, string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, boolean: bool) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, byte: int) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, char: str) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, double: float) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, float: float) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, int: int) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, object: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, object: typing.Any, object2: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, object: typing.Any, object2: typing.Any, object3: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, object: typing.Any, object2: typing.Any, object3: typing.Any, object4: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, long: int) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, short: int) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', throwable: java.lang.Throwable, string: str, objectArray: typing.List[typing.Any]) -> None: ...

class LogSF(LogXF):
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, boolean: bool) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, byte: int) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, char: str) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, double: float) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, float: float) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, int: int) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, object: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, object: typing.Any, object2: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, object: typing.Any, object2: typing.Any, object3: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, object: typing.Any, object2: typing.Any, object3: typing.Any, object4: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, long: int) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', string: str, short: int) -> None: ...
    @typing.overload
    @staticmethod
    def debug(logger: 'Logger', throwable: java.lang.Throwable, string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def error(logger: 'Logger', string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def error(logger: 'Logger', throwable: java.lang.Throwable, string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def fatal(logger: 'Logger', string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def fatal(logger: 'Logger', throwable: java.lang.Throwable, string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, boolean: bool) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, byte: int) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, char: str) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, double: float) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, float: float) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, int: int) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, object: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, object: typing.Any, object2: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, object: typing.Any, object2: typing.Any, object3: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, object: typing.Any, object2: typing.Any, object3: typing.Any, object4: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, long: int) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', string: str, short: int) -> None: ...
    @typing.overload
    @staticmethod
    def info(logger: 'Logger', throwable: java.lang.Throwable, string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, boolean: bool) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, byte: int) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, char: str) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, double: float) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, float: float) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, int: int) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, object: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, object: typing.Any, object2: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, object: typing.Any, object2: typing.Any, object3: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, object: typing.Any, object2: typing.Any, object3: typing.Any, object4: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, long: int) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, string: str, short: int) -> None: ...
    @typing.overload
    @staticmethod
    def log(logger: 'Logger', level: Level, throwable: java.lang.Throwable, string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, boolean: bool) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, byte: int) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, char: str) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, double: float) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, float: float) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, int: int) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, object: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, object: typing.Any, object2: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, object: typing.Any, object2: typing.Any, object3: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, object: typing.Any, object2: typing.Any, object3: typing.Any, object4: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, long: int) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, string: str, string2: str, short: int) -> None: ...
    @typing.overload
    @staticmethod
    def logrb(logger: 'Logger', level: Level, throwable: java.lang.Throwable, string: str, string2: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, boolean: bool) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, byte: int) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, char: str) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, double: float) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, float: float) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, int: int) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, object: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, object: typing.Any, object2: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, object: typing.Any, object2: typing.Any, object3: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, object: typing.Any, object2: typing.Any, object3: typing.Any, object4: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, long: int) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', string: str, short: int) -> None: ...
    @typing.overload
    @staticmethod
    def trace(logger: 'Logger', throwable: java.lang.Throwable, string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, boolean: bool) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, byte: int) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, char: str) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, double: float) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, float: float) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, int: int) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, object: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, object: typing.Any, object2: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, object: typing.Any, object2: typing.Any, object3: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, object: typing.Any, object2: typing.Any, object3: typing.Any, object4: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, objectArray: typing.List[typing.Any]) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, long: int) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', string: str, short: int) -> None: ...
    @typing.overload
    @staticmethod
    def warn(logger: 'Logger', throwable: java.lang.Throwable, string: str, objectArray: typing.List[typing.Any]) -> None: ...

class Logger(Category):
    @typing.overload
    @staticmethod
    def getLogger(class_: typing.Type) -> 'Logger': ...
    @typing.overload
    @staticmethod
    def getLogger(string: str) -> 'Logger': ...
    @typing.overload
    @staticmethod
    def getLogger(string: str, loggerFactory: org.apache.log4j.spi.LoggerFactory) -> 'Logger': ...
    @staticmethod
    def getRootLogger() -> 'Logger': ...
    def isTraceEnabled(self) -> bool: ...
    @typing.overload
    def trace(self, object: typing.Any) -> None: ...
    @typing.overload
    def trace(self, object: typing.Any, throwable: java.lang.Throwable) -> None: ...

class PatternLayout(Layout):
    DEFAULT_CONVERSION_PATTERN: typing.ClassVar[str] = ...
    TTCC_CONVERSION_PATTERN: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    def activateOptions(self) -> None: ...
    def format(self, loggingEvent: org.apache.log4j.spi.LoggingEvent) -> str: ...
    def getConversionPattern(self) -> str: ...
    def ignoresThrowable(self) -> bool: ...
    def setConversionPattern(self, string: str) -> None: ...

class SimpleLayout(Layout):
    def __init__(self): ...
    def activateOptions(self) -> None: ...
    def format(self, loggingEvent: org.apache.log4j.spi.LoggingEvent) -> str: ...
    def ignoresThrowable(self) -> bool: ...

class AsyncAppender(AppenderSkeleton, org.apache.log4j.spi.AppenderAttachable):
    DEFAULT_BUFFER_SIZE: typing.ClassVar[int] = ...
    def __init__(self): ...
    def addAppender(self, appender: Appender) -> None: ...
    def append(self, loggingEvent: org.apache.log4j.spi.LoggingEvent) -> None: ...
    def close(self) -> None: ...
    def getAllAppenders(self) -> java.util.Enumeration: ...
    def getAppender(self, string: str) -> Appender: ...
    def getBlocking(self) -> bool: ...
    def getBufferSize(self) -> int: ...
    def getLocationInfo(self) -> bool: ...
    def isAttached(self, appender: Appender) -> bool: ...
    def removeAllAppenders(self) -> None: ...
    @typing.overload
    def removeAppender(self, string: str) -> None: ...
    @typing.overload
    def removeAppender(self, appender: Appender) -> None: ...
    def requiresLayout(self) -> bool: ...
    def setBlocking(self, boolean: bool) -> None: ...
    def setBufferSize(self, int: int) -> None: ...
    def setLocationInfo(self, boolean: bool) -> None: ...

class WriterAppender(AppenderSkeleton):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, layout: Layout, outputStream: java.io.OutputStream): ...
    @typing.overload
    def __init__(self, layout: Layout, writer: java.io.Writer): ...
    def activateOptions(self) -> None: ...
    def append(self, loggingEvent: org.apache.log4j.spi.LoggingEvent) -> None: ...
    def close(self) -> None: ...
    def getEncoding(self) -> str: ...
    def getImmediateFlush(self) -> bool: ...
    def requiresLayout(self) -> bool: ...
    def setEncoding(self, string: str) -> None: ...
    def setErrorHandler(self, errorHandler: org.apache.log4j.spi.ErrorHandler) -> None: ...
    def setImmediateFlush(self, boolean: bool) -> None: ...
    def setWriter(self, writer: java.io.Writer) -> None: ...

class ConsoleAppender(WriterAppender):
    SYSTEM_OUT: typing.ClassVar[str] = ...
    SYSTEM_ERR: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, layout: Layout): ...
    @typing.overload
    def __init__(self, layout: Layout, string: str): ...
    def activateOptions(self) -> None: ...
    def getFollow(self) -> bool: ...
    def getTarget(self) -> str: ...
    def setFollow(self, boolean: bool) -> None: ...
    def setTarget(self, string: str) -> None: ...

class FileAppender(WriterAppender):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, layout: Layout, string: str): ...
    @typing.overload
    def __init__(self, layout: Layout, string: str, boolean: bool): ...
    @typing.overload
    def __init__(self, layout: Layout, string: str, boolean: bool, boolean2: bool, int: int): ...
    def activateOptions(self) -> None: ...
    def getAppend(self) -> bool: ...
    def getBufferSize(self) -> int: ...
    def getBufferedIO(self) -> bool: ...
    def getFile(self) -> str: ...
    def setAppend(self, boolean: bool) -> None: ...
    def setBufferSize(self, int: int) -> None: ...
    def setBufferedIO(self, boolean: bool) -> None: ...
    @typing.overload
    def setFile(self, string: str, boolean: bool, boolean2: bool, int: int) -> None: ...
    @typing.overload
    def setFile(self, string: str) -> None: ...

class DailyRollingFileAppender(FileAppender):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, layout: Layout, string: str, string2: str): ...
    def activateOptions(self) -> None: ...
    def getDatePattern(self) -> str: ...
    def setDatePattern(self, string: str) -> None: ...

class RollingFileAppender(FileAppender):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, layout: Layout, string: str): ...
    @typing.overload
    def __init__(self, layout: Layout, string: str, boolean: bool): ...
    def getMaxBackupIndex(self) -> int: ...
    def getMaximumFileSize(self) -> int: ...
    def rollOver(self) -> None: ...
    @typing.overload
    def setFile(self, string: str, boolean: bool, boolean2: bool, int: int) -> None: ...
    @typing.overload
    def setFile(self, string: str) -> None: ...
    def setMaxBackupIndex(self, int: int) -> None: ...
    def setMaxFileSize(self, string: str) -> None: ...
    def setMaximumFileSize(self, long: int) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("org.apache.log4j")``.

    Appender: typing.Type[Appender]
    AppenderSkeleton: typing.Type[AppenderSkeleton]
    AsyncAppender: typing.Type[AsyncAppender]
    BasicConfigurator: typing.Type[BasicConfigurator]
    Category: typing.Type[Category]
    ConsoleAppender: typing.Type[ConsoleAppender]
    DailyRollingFileAppender: typing.Type[DailyRollingFileAppender]
    DefaultThrowableRenderer: typing.Type[DefaultThrowableRenderer]
    EnhancedPatternLayout: typing.Type[EnhancedPatternLayout]
    EnhancedThrowableRenderer: typing.Type[EnhancedThrowableRenderer]
    FileAppender: typing.Type[FileAppender]
    HTMLLayout: typing.Type[HTMLLayout]
    Hierarchy: typing.Type[Hierarchy]
    Layout: typing.Type[Layout]
    Level: typing.Type[Level]
    LogMF: typing.Type[LogMF]
    LogManager: typing.Type[LogManager]
    LogSF: typing.Type[LogSF]
    LogXF: typing.Type[LogXF]
    Logger: typing.Type[Logger]
    MDC: typing.Type[MDC]
    NDC: typing.Type[NDC]
    PatternLayout: typing.Type[PatternLayout]
    Priority: typing.Type[Priority]
    PropertyConfigurator: typing.Type[PropertyConfigurator]
    RollingFileAppender: typing.Type[RollingFileAppender]
    SimpleLayout: typing.Type[SimpleLayout]
    TTCCLayout: typing.Type[TTCCLayout]
    WriterAppender: typing.Type[WriterAppender]
    chainsaw: org.apache.log4j.chainsaw.__module_protocol__
    config: org.apache.log4j.config.__module_protocol__
    helpers: org.apache.log4j.helpers.__module_protocol__
    jdbc: org.apache.log4j.jdbc.__module_protocol__
    jmx: org.apache.log4j.jmx.__module_protocol__
    lf5: org.apache.log4j.lf5.__module_protocol__
    net: org.apache.log4j.net.__module_protocol__
    nt: org.apache.log4j.nt.__module_protocol__
    or_: org.apache.log4j.or_.__module_protocol__
    pattern: org.apache.log4j.pattern.__module_protocol__
    rewrite: org.apache.log4j.rewrite.__module_protocol__
    spi: org.apache.log4j.spi.__module_protocol__
    varia: org.apache.log4j.varia.__module_protocol__
    xml: org.apache.log4j.xml.__module_protocol__
