/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.headfinder;

import opennlp.tools.util.SequenceValidator;
import org.cogroo.tools.chunker2.TokenTag;

public class HeadFinderSequenceValidator
implements SequenceValidator<TokenTag> {
    public boolean validSequence(int i, TokenTag[] inputSequence, String[] outcomesSequence, String outcome) {
        int size = inputSequence.length;
        String[] chunkTags = new String[size];
        String[] posTags = new String[size];
        String[] lexemes = new String[size];
        TokenTag.extract(inputSequence, lexemes, posTags, chunkTags);
        if (this.isBoundary(chunkTags[i])) {
            return true;
        }
        boolean isHead = this.isHead(outcome);
        if (chunkTags[i].equals("O") && isHead) {
            return false;
        }
        if (this.isIntermediate(chunkTags[i]) && isHead) {
            boolean foundBoundary = false;
            for (int j = i - 1; j >= 0 && !foundBoundary; --j) {
                if (this.isHead(outcomesSequence[j])) {
                    return false;
                }
                foundBoundary = this.isBoundary(chunkTags[j]);
            }
        }
        return true;
    }

    private boolean isIntermediate(String tag) {
        return tag.startsWith("I-");
    }

    private boolean isBoundary(String tag) {
        return tag.startsWith("B-");
    }

    private boolean isHead(String outcome) {
        return !outcome.equals("O");
    }
}

