/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.featurizer;

import java.io.IOException;
import java.util.Map;
import opennlp.tools.util.model.ArtifactSerializer;
import org.cogroo.dictionary.FeatureDictionary;
import org.cogroo.dictionary.impl.FSADictionary;
import org.cogroo.dictionary.impl.FSAFeatureDictionary;
import org.cogroo.tools.featurizer.FeaturizerFactory;
import org.cogroo.util.serializers.ByteArraySerializer;

public class FSAFeaturizerFactory
extends FeaturizerFactory {
    private static final String FSA_POSDICT_SUF = "fsa_data";
    private static final String FSA_DICT_INFO_SUF = "fsa_info";
    private static final String FSA_POSDICT = "feat_dict.fsa_data";
    private static final String FSA_DICT_INFO = "feat_dict.fsa_info";
    private byte[] dictInfo;
    private byte[] dictData;
    private FeatureDictionary fsaFeatureDictionary;

    public FSAFeaturizerFactory() {
    }

    public FSAFeaturizerFactory(FeatureDictionary featureDictionary, String cgFlags) {
        super(null, cgFlags);
    }

    @Override
    protected void init(FeatureDictionary featureDictionary, String cgFlags) {
        super.init(featureDictionary, cgFlags);
        String path = System.getProperty("fsa.dict");
        if (path == null) {
            throw new IllegalArgumentException("The property fsa.dict is missing! -Dfsa.dict=path");
        }
        try {
            this.dictInfo = FSADictionary.getFSADictionaryInfo(path);
            this.dictData = FSADictionary.getFSADictionaryData(path);
            this.fsaFeatureDictionary = FSAFeatureDictionary.create(this.dictData, this.dictInfo);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The file is not a FSA dictionary!", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not open the FSA dictionary or the .info file", e);
        }
    }

    @Override
    protected FeatureDictionary loadFeatureDictionary() {
        Object obj;
        if (this.fsaFeatureDictionary == null && this.artifactProvider != null && (obj = this.artifactProvider.getArtifact(FSA_POSDICT)) != null) {
            byte[] data = (byte[])this.artifactProvider.getArtifact(FSA_POSDICT);
            byte[] info = (byte[])this.artifactProvider.getArtifact(FSA_DICT_INFO);
            try {
                this.fsaFeatureDictionary = FSAFeatureDictionary.create(data, info);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("The file is not a FSA dictionary!", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not open the FSA dictionary or the .info file", e);
            }
        }
        return this.fsaFeatureDictionary;
    }

    @Override
    public Map<String, ArtifactSerializer> createArtifactSerializersMap() {
        Map<String, ArtifactSerializer> serializers = super.createArtifactSerializersMap();
        serializers.put(FSA_POSDICT_SUF, new ByteArraySerializer());
        serializers.put(FSA_DICT_INFO_SUF, new ByteArraySerializer());
        return serializers;
    }

    @Override
    public Map<String, Object> createArtifactMap() {
        Map<String, Object> artifactMap = super.createArtifactMap();
        artifactMap.put(FSA_POSDICT, this.dictData);
        artifactMap.put(FSA_DICT_INFO, this.dictInfo);
        return artifactMap;
    }
}

