/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.chunker2;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import opennlp.tools.ml.BeamSearch;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.SequenceTrainer;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.SequenceClassificationModel;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Sequence;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.Span;
import opennlp.tools.util.TrainingParameters;
import org.cogroo.tools.chunker2.ChunkSample;
import org.cogroo.tools.chunker2.ChunkSampleSequenceStream;
import org.cogroo.tools.chunker2.Chunker;
import org.cogroo.tools.chunker2.ChunkerContextGenerator;
import org.cogroo.tools.chunker2.ChunkerEventStream;
import org.cogroo.tools.chunker2.ChunkerFactory;
import org.cogroo.tools.chunker2.ChunkerModel;
import org.cogroo.tools.chunker2.TokenTag;

public class ChunkerME
implements Chunker {
    public static final int DEFAULT_BEAM_SIZE = 10;
    private Sequence bestSequence;
    protected SequenceClassificationModel<TokenTag> model;
    private ChunkerContextGenerator contextGenerator;
    private SequenceValidator<TokenTag> sequenceValidator;

    @Deprecated
    private ChunkerME(ChunkerModel model, int beamSize, SequenceValidator<TokenTag> sequenceValidator, ChunkerContextGenerator contextGenerator) {
        this.sequenceValidator = sequenceValidator;
        this.contextGenerator = contextGenerator;
        this.model = model.getChunkerSequenceModel() != null ? model.getChunkerSequenceModel() : new BeamSearch<TokenTag>(beamSize, model.getChunkerModel(), 0);
    }

    @Deprecated
    public ChunkerME(ChunkerModel model, int beamSize) {
        this.contextGenerator = model.getFactory().getContextGenerator();
        this.sequenceValidator = model.getFactory().getSequenceValidator();
        this.model = model.getChunkerSequenceModel() != null ? model.getChunkerSequenceModel() : new BeamSearch<TokenTag>(beamSize, model.getChunkerModel(), 0);
    }

    public ChunkerME(ChunkerModel model) {
        this(model, 10);
    }

    @Override
    public String[] chunk(String[] toks, String[] tags) {
        TokenTag[] tuples = TokenTag.create(toks, tags);
        return this.chunk(tuples);
    }

    @Override
    public Span[] chunkAsSpans(String[] toks, String[] tags) {
        TokenTag[] tuples = TokenTag.create(toks, tags);
        return this.chunkAsSpans(tuples);
    }

    @Override
    public Sequence[] topKSequences(String[] sentence, String[] tags) {
        TokenTag[] tuples = TokenTag.create(sentence, tags);
        return this.topKSequences(tuples);
    }

    @Override
    public Sequence[] topKSequences(String[] sentence, String[] tags, double minSequenceScore) {
        TokenTag[] tuples = TokenTag.create(sentence, tags);
        return this.topKSequences(tuples, minSequenceScore);
    }

    public String[] chunk(TokenTag[] toks) {
        this.bestSequence = this.model.bestSequence((TokenTag[])toks, new Object[0], this.contextGenerator, this.sequenceValidator);
        List<String> c = this.bestSequence.getOutcomes();
        return c.toArray(new String[c.size()]);
    }

    public Span[] chunkAsSpans(TokenTag[] toks) {
        String[] preds = this.chunk(toks);
        String[] sentence = TokenTag.extractTokens(toks);
        String[] tags = TokenTag.extractTags(toks);
        return ChunkSample.phrasesAsSpanList(sentence, tags, preds);
    }

    public Sequence[] topKSequences(TokenTag[] sentence) {
        return this.model.bestSequences(10, (TokenTag[])sentence, new Object[0], this.contextGenerator, this.sequenceValidator);
    }

    public Sequence[] topKSequences(TokenTag[] sentence, double minSequenceScore) {
        return this.model.bestSequences(10, (TokenTag[])sentence, new Object[0], minSequenceScore, this.contextGenerator, this.sequenceValidator);
    }

    public void probs(double[] probs) {
        this.bestSequence.getProbs(probs);
    }

    public double[] probs() {
        return this.bestSequence.getProbs();
    }

    public static ChunkerModel train(String lang, ObjectStream<ChunkSample> in, TrainingParameters mlParams, ChunkerFactory factory) throws IOException {
        String beamSizeString = mlParams.getSettings().get("BeamSize");
        int beamSize = 10;
        if (beamSizeString != null) {
            beamSize = Integer.parseInt(beamSizeString);
        }
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        TrainerFactory.TrainerType trainerType = TrainerFactory.getTrainerType(mlParams.getSettings());
        MaxentModel chunkerModel = null;
        SequenceClassificationModel<String> seqChunkerModel = null;
        if (TrainerFactory.TrainerType.EVENT_MODEL_TRAINER.equals((Object)trainerType)) {
            ChunkerEventStream es = new ChunkerEventStream(in, factory.getContextGenerator());
            EventTrainer trainer = TrainerFactory.getEventTrainer(mlParams.getSettings(), manifestInfoEntries);
            chunkerModel = trainer.train(es);
        } else if (TrainerFactory.TrainerType.SEQUENCE_TRAINER.equals((Object)trainerType)) {
            SequenceTrainer trainer = TrainerFactory.getSequenceModelTrainer(mlParams.getSettings(), manifestInfoEntries);
            ChunkSampleSequenceStream ss = new ChunkSampleSequenceStream(in, factory.getContextGenerator());
            seqChunkerModel = trainer.train(ss);
        } else {
            throw new IllegalArgumentException("Trainer type is not supported: " + (Object)((Object)trainerType));
        }
        if (chunkerModel != null) {
            return new ChunkerModel(lang, chunkerModel, beamSize, manifestInfoEntries, factory);
        }
        return new ChunkerModel(lang, seqChunkerModel, manifestInfoEntries, factory);
    }
}

