/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.checker.rules.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cogroo.entities.Sentence;
import org.cogroo.entities.impl.ChunkTag;
import org.cogroo.entities.impl.MorphologicalTag;
import org.cogroo.entities.impl.SyntacticTag;
import org.cogroo.tools.checker.rules.model.Composition;
import org.cogroo.tools.checker.rules.model.Element;
import org.cogroo.tools.checker.rules.model.Mask;
import org.cogroo.tools.checker.rules.model.Operator;
import org.cogroo.tools.checker.rules.model.PatternElement;
import org.cogroo.tools.checker.rules.model.Reference;
import org.cogroo.tools.checker.rules.model.Rule;
import org.cogroo.tools.checker.rules.model.Suggestion;
import org.cogroo.tools.checker.rules.model.TagMask;

public class RuleUtils {
    private static final Map<String, String> TAGS;

    public static Map<RuleInfo, String> getRuleAsString(Rule rule) {
        HashMap<RuleInfo, String> map = new HashMap<RuleInfo, String>();
        map.put(RuleInfo.METHOD, RuleUtils.getMethodAsString(rule));
        map.put(RuleInfo.TYPE, RuleUtils.getTypeAsString(rule));
        map.put(RuleInfo.GROUP, RuleUtils.getGroupAsString(rule));
        map.put(RuleInfo.MESSAGE, RuleUtils.getMessageAsString(rule));
        map.put(RuleInfo.SHORTMESSAGE, RuleUtils.getShortMessageAsString(rule));
        map.put(RuleInfo.PATTERN, RuleUtils.getPatternAsString(rule));
        map.put(RuleInfo.BOUNDARIES, RuleUtils.getBoundariesAsString(rule));
        map.put(RuleInfo.SUGGESTIONS, RuleUtils.getSuggestionsAsString(rule));
        return map;
    }

    public static String getMethodAsString(Rule rule) {
        return rule.getMethod().value();
    }

    public static String getTypeAsString(Rule rule) {
        return rule.getType();
    }

    public static String getGroupAsString(Rule rule) {
        return rule.getGroup();
    }

    public static String getMessageAsString(Rule rule) {
        return rule.getMessage();
    }

    public static String getShortMessageAsString(Rule rule) {
        return rule.getShortMessage();
    }

    public static String getPatternAsString(Rule rule) {
        StringBuilder sb = new StringBuilder();
        for (PatternElement patternElement : rule.getPattern().getPatternElement()) {
            sb.append(RuleUtils.getPatternElementAsString(patternElement));
            sb.append(" ");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static String getPatternElementAsString(PatternElement patternElement) {
        if (patternElement.getElement() != null) {
            return RuleUtils.getElementAsString(patternElement.getElement());
        }
        if (patternElement.getComposition() != null) {
            return RuleUtils.getCompositionAsString(patternElement.getComposition());
        }
        return "NULL";
    }

    private static String getCompositionAsString(Composition composition) {
        if (composition.getAnd() != null) {
            return RuleUtils.getOperatorAsString(composition.getAnd(), " & ");
        }
        if (composition.getOr() != null) {
            return RuleUtils.getOperatorAsString(composition.getOr(), " | ");
        }
        return "NULL";
    }

    private static String getOperatorAsString(Operator operator, String op) {
        int i;
        List<PatternElement> peList = operator.getPatternElement();
        StringBuilder sb = new StringBuilder();
        sb.append("( ");
        for (i = 0; i < peList.size() - 1; ++i) {
            sb.append(RuleUtils.getPatternElementAsString(peList.get(i)) + op);
        }
        sb.append(RuleUtils.getPatternElementAsString(peList.get(i)) + ") ");
        return sb.toString();
    }

    public static String getElementAsString(Element element) {
        int masks;
        StringBuilder sb = new StringBuilder();
        if (element.isNegated() != null && element.isNegated().booleanValue()) {
            sb.append("~");
        }
        if ((masks = element.getMask().size()) > 1) {
            sb.append("(");
        }
        int maskCounter = 0;
        for (Mask mask : element.getMask()) {
            if (mask.getLexemeMask() != null) {
                sb.append("\"").append(mask.getLexemeMask()).append("\"");
            } else if (mask.getPrimitiveMask() != null) {
                sb.append("{").append(mask.getPrimitiveMask()).append("}");
            } else if (mask.getTagMask() != null) {
                sb.append(RuleUtils.getTagMaskAsString(mask.getTagMask()));
            } else if (mask.getTagReference() != null) {
                sb.append(RuleUtils.getTagReferenceAsString(mask.getTagReference()));
            }
            if (maskCounter < masks - 1) {
                sb.append("|");
            }
            ++maskCounter;
        }
        if (masks > 1) {
            sb.append(")");
        }
        return sb.toString();
    }

    public static String getTagReferenceAsString(Reference tagRef) {
        StringBuilder sb = new StringBuilder();
        String index = Long.toString(tagRef.getIndex());
        sb.append("( ref[" + index + "] ");
        tagRef.getProperty();
        for (Reference.Property prop : tagRef.getProperty()) {
            sb.append((Object)((Object)prop) + " ");
        }
        sb.append(")");
        return sb.toString();
    }

    public static String getTagMaskAsString(TagMask tagMask) {
        StringBuilder sb = new StringBuilder();
        if (tagMask.getSyntacticFunction() != null) {
            sb.append(tagMask.getSyntacticFunction().value()).append("_");
        }
        if (tagMask.getClazz() != null) {
            sb.append(tagMask.getClazz().value()).append("_");
        }
        if (tagMask.getGender() != null) {
            sb.append(tagMask.getGender().value()).append("_");
        }
        if (tagMask.getNumber() != null) {
            sb.append(tagMask.getNumber().value()).append("_");
        }
        if (tagMask.getCase() != null) {
            sb.append(tagMask.getCase().value()).append("_");
        }
        if (tagMask.getPerson() != null) {
            sb.append(tagMask.getPerson().value()).append("_");
        }
        if (tagMask.getTense() != null) {
            sb.append(tagMask.getTense().value()).append("_");
        }
        if (tagMask.getMood() != null) {
            sb.append(tagMask.getMood().value()).append("_");
        }
        if (tagMask.getPunctuation() != null) {
            sb.append(tagMask.getPunctuation().value()).append("_");
        }
        return sb.toString();
    }

    public static String getBoundariesAsString(Rule rule) {
        return rule.getBoundaries().getLower() + " " + rule.getBoundaries().getUpper();
    }

    public static String getSuggestionsAsString(Rule rule) {
        StringBuilder sb = new StringBuilder();
        if (rule.getSuggestion().isEmpty()) {
            sb.append("none");
        }
        for (Suggestion suggestion : rule.getSuggestion()) {
            if (!suggestion.getReplace().isEmpty()) {
                sb.append("Replace: ");
            }
            for (Suggestion.Replace replace : suggestion.getReplace()) {
                sb.append(replace.getIndex());
                sb.append(" <=> ");
                if (replace.getLexeme() != null) {
                    sb.append("\"");
                    sb.append(replace.getLexeme());
                    sb.append("\"");
                } else if (replace.getTagReference() != null) {
                    sb.append(replace.getTagReference().getIndex());
                    sb.append("_");
                    sb.append(RuleUtils.getTagMaskAsString(replace.getTagReference().getTagMask()));
                }
                sb.append("|");
            }
            sb = RuleUtils.removeLastVerticalBar(sb);
            if (!suggestion.getReplaceMapping().isEmpty()) {
                sb.append("Replace Mapping: ");
            }
            for (Suggestion.ReplaceMapping replaceMapping : suggestion.getReplaceMapping()) {
                sb.append(replaceMapping.getIndex());
                sb.append(" ");
                sb.append(replaceMapping.getKey());
                sb.append(" => ");
                sb.append(replaceMapping.getValue());
                sb.append("|");
            }
            sb = RuleUtils.removeLastVerticalBar(sb);
            if (!suggestion.getSwap().isEmpty()) {
                sb.append("Swap: ");
            }
            for (Suggestion.Swap swap : suggestion.getSwap()) {
                sb.append(swap.getA());
                sb.append(" <=> ");
                sb.append(swap.getB());
                sb.append("|");
            }
            sb = RuleUtils.removeLastVerticalBar(sb);
            sb.append("\n");
        }
        return sb.toString();
    }

    private static StringBuilder removeLastVerticalBar(StringBuilder sb) {
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '|') {
            return sb.deleteCharAt(sb.length() - 1);
        }
        return sb;
    }

    public static TagMask createTagMaskFromReference(Reference ref, MorphologicalTag mTag, ChunkTag cTag, SyntacticTag sTag) {
        TagMask t = new TagMask();
        if (mTag == null) {
            return t;
        }
        for (Reference.Property p : ref.getProperty()) {
            switch (p) {
                case CLASS: {
                    t.setClazz(mTag.getClazzE());
                    break;
                }
                case GENDER: {
                    if (TagMask.Gender.NEUTRAL == mTag.getGenderE()) break;
                    t.setGender(mTag.getGenderE());
                    break;
                }
                case NUMBER: {
                    if (TagMask.Number.NEUTRAL == mTag.getNumberE()) break;
                    t.setNumber(mTag.getNumberE());
                    break;
                }
                case PERSON: {
                    t.setPerson(mTag.getPersonE());
                    break;
                }
                case SYNTACTIC_FUNCTION: {
                    t.setSyntacticFunction(TagMask.SyntacticFunction.fromValue(sTag.toVerboseString()));
                    break;
                }
                case CHUNK_FUNCTION: {
                    t.setChunkFunction(TagMask.ChunkFunction.fromValue(cTag.toVerboseString()));
                    break;
                }
            }
        }
        return t;
    }

    public static TagMask createTagMaskFromReference(Reference ref, Sentence sent, int refPos) {
        int pos = refPos + (int)ref.getIndex();
        if (pos >= 0 && pos < sent.getTokens().size()) {
            MorphologicalTag mTag = sent.getTokens().get(pos).getMorphologicalTag();
            ChunkTag cTag = sent.getTokens().get(pos).getChunkTag();
            SyntacticTag sTag = sent.getTokens().get(pos).getSyntacticTag();
            return RuleUtils.createTagMaskFromReference(ref, mTag, cTag, sTag);
        }
        return new TagMask();
    }

    public static TagMask createTagMaskFromReferenceSyntatic(Reference ref, Sentence sent, int refPos) {
        int pos = refPos + (int)ref.getIndex();
        if (pos >= 0 && pos < sent.getSyntacticChunks().size()) {
            MorphologicalTag mTag = sent.getSyntacticChunks().get(pos).getMorphologicalTag();
            SyntacticTag sTag = sent.getSyntacticChunks().get(pos).getSyntacticTag();
            return RuleUtils.createTagMaskFromReference(ref, mTag, null, sTag);
        }
        return new TagMask();
    }

    public static void completeMissingParts(TagMask tagMask, MorphologicalTag tag) {
        if (tagMask.getCase() == null) {
            tagMask.setCase(tag.getCase());
        }
        if (tagMask.getClazz() == null) {
            tagMask.setClazz(tag.getClazzE());
        }
        if (tagMask.getGender() == null) {
            tagMask.setGender(tag.getGenderE());
        }
        if (tagMask.getMood() == null) {
            tagMask.setMood(tag.getMood());
        }
        if (tagMask.getNumber() == null) {
            tagMask.setNumber(tag.getNumberE());
        }
        if (tagMask.getPerson() == null) {
            tagMask.setPerson(tag.getPersonE());
        }
        if (tagMask.getPunctuation() == null) {
            tagMask.setPunctuation(tag.getPunctuation());
        }
        if (tagMask.getTense() == null) {
            tagMask.setTense(tag.getTense());
        }
        if (tagMask.getPunctuation() == null) {
            tagMask.setPunctuation(tag.getPunctuation());
        }
    }

    public static String translate(String ori) {
        if (TAGS.containsKey(ori)) {
            return TAGS.get(ori);
        }
        return ori;
    }

    public static String useCasedString(String replaceable, String replacement) {
        String replacementCased = replacement;
        if (replacement.length() > 1) {
            replacementCased = Character.isUpperCase(replaceable.charAt(0)) ? Character.toUpperCase(replacement.charAt(0)) + replacement.substring(1) : Character.toLowerCase(replacement.charAt(0)) + replacement.substring(1);
        } else if (replacement.length() == 1) {
            replacementCased = Character.isUpperCase(replaceable.charAt(0)) ? String.valueOf(Character.toUpperCase(replacement.charAt(0))) : String.valueOf(Character.toLowerCase(replacement.charAt(0)));
        }
        return replacementCased;
    }

    static {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("n", "substantivo");
        tags.put("prop", "substantivo pr\u00f3prio");
        tags.put("adj", "adjetivo");
        tags.put("n-adj", "substantivo");
        tags.put("v-fin", "verbo");
        tags.put("v-inf", "verbo");
        tags.put("v-pcp", "verbo");
        tags.put("v-ger", "verbo");
        tags.put("art", "artigo");
        tags.put("pron-det", "pronome");
        tags.put("pron-pers", "pronome");
        tags.put("pron-indp", "pronome");
        tags.put("adv", "adv\u00e9rbio");
        tags.put("num", "numeral");
        tags.put("prp", "preposi\u00e7\u00e3o");
        tags.put("intj", "interjei\u00e7\u00e3o");
        tags.put("conj-s", "conjun\u00e7\u00e3o");
        tags.put("conj-c", "conjun\u00e7\u00e3o");
        TAGS = Collections.unmodifiableMap(tags);
    }

    public static enum RuleInfo {
        METHOD,
        TYPE,
        GROUP,
        MESSAGE,
        SHORTMESSAGE,
        PATTERN,
        BOUNDARIES,
        SUGGESTIONS;

    }
}

