/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.checker.rules.applier;

import java.util.List;
import org.cogroo.tools.checker.RuleDefinition;
import org.cogroo.tools.checker.RuleType;
import org.cogroo.tools.checker.rules.model.Example;
import org.cogroo.tools.checker.rules.model.Pattern;
import org.cogroo.tools.checker.rules.model.Rule;
import org.cogroo.tools.checker.rules.util.RuleUtils;

public class XMLRuleDefinition
implements RuleDefinition {
    private final String id;
    private final String category;
    private final String group;
    private final String message;
    private final String shortMessage;
    private final List<Example> examples;
    private final Rule.Method method;
    private final String description;
    private final Pattern pattern;

    public XMLRuleDefinition(String prefix, Rule rule) {
        this.id = prefix + rule.getId();
        this.category = rule.getType();
        this.group = rule.getGroup();
        this.method = rule.getMethod();
        this.message = rule.getMessage();
        this.shortMessage = rule.getShortMessage();
        this.examples = rule.getExample();
        this.description = RuleUtils.getPatternAsString(rule);
        this.pattern = rule.getPattern();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getShortMessage() {
        return this.shortMessage;
    }

    @Override
    public List<Example> getExamples() {
        return this.examples;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public RuleType getRuleType() {
        RuleType t;
        switch (this.method) {
            case PHRASE_LOCAL: {
                t = RuleType.XML_PHRASE_LOCAL;
                break;
            }
            case SUBJECT_VERB: {
                t = RuleType.XML_SUBJECT_VERB;
                break;
            }
            default: {
                t = RuleType.XML_GENERAL;
            }
        }
        return t;
    }

    @Override
    public boolean isXMLBased() {
        return true;
    }
}

