/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.text.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.cogroo.text.tree.TreeElement;

public class Node
extends TreeElement
implements Serializable {
    private static final long serialVersionUID = 5419391069465738001L;
    private List<TreeElement> elems = new ArrayList<TreeElement>();

    public void addElement(TreeElement element) {
        this.elems.add(element);
    }

    public TreeElement[] getElements() {
        return this.elems.toArray(new TreeElement[this.elems.size()]);
    }

    public List<TreeElement> getElems() {
        return this.elems;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.getLevel(); ++i) {
            sb.append("=");
        }
        sb.append(this.getSyntacticTag());
        if (this.getMorphologicalTag() != null) {
            sb.append(this.getMorphologicalTag());
        }
        sb.append("\n");
        for (TreeElement element : this.elems) {
            sb.append(element.toString());
        }
        return sb.toString();
    }

    @Override
    public String toSyntaxTree() {
        return "[" + this.getSyntacticTag() + " " + this.toSyntaxTree(this.getElements()) + "]";
    }

    @Override
    public String toTreebank() {
        return "(" + this.getSyntacticTag() + " " + this.toTreebank(this.getElements()) + ")";
    }

    private String toSyntaxTree(TreeElement[] elements) {
        StringBuilder sb = new StringBuilder();
        for (TreeElement treeElement : elements) {
            sb.append(treeElement.toSyntaxTree() + " ");
        }
        return sb.toString();
    }

    private String toTreebank(TreeElement[] elements) {
        StringBuilder sb = new StringBuilder();
        for (TreeElement treeElement : elements) {
            sb.append(treeElement.toTreebank() + " ");
        }
        return sb.toString();
    }
}

