/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.dictionary.impl;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.WordData;
import opennlp.tools.util.Cache;
import org.cogroo.dictionary.FeatureDictionary;
import org.cogroo.tools.featurizer.WordTag;
import org.cogroo.util.ByteArrayUtil;

public class FSAFeatureDictionary
implements FeatureDictionary,
Iterable<WordTag> {
    private DictionaryLookup dictLookup;
    private final Cache cache = new Cache(500);

    public FSAFeatureDictionary(DictionaryLookup dictLookup) {
        this.dictLookup = dictLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] lookup(WordTag key) {
        if (key == null) {
            return null;
        }
        String[] arr = (String[])this.cache.get(key);
        if (arr != null) {
            return arr;
        }
        DictionaryLookup dictionaryLookup = this.dictLookup;
        synchronized (dictionaryLookup) {
            List<WordData> data = this.dictLookup.lookup(key.getWord());
            if (data.size() > 0) {
                String prefix = key.getPostag() + "#";
                ArrayList<String> tags = new ArrayList<String>(data.size());
                for (int i = 0; i < data.size(); ++i) {
                    String completeTag = data.get(i).getTag().toString();
                    if (!completeTag.startsWith(prefix) && key.getPostag() != null) continue;
                    tags.add(completeTag.substring(completeTag.indexOf("#") + 1));
                }
                return tags.toArray(new String[tags.size()]);
            }
        }
        return null;
    }

    @Override
    public String[] getFeatures(String word, String pos) {
        return this.lookup(new WordTag(word, pos));
    }

    public static FeatureDictionary create(String path) throws IllegalArgumentException, IOException {
        FileInputStream fsaData = new FileInputStream(path);
        FileInputStream featuresData = new FileInputStream(Dictionary.getExpectedFeaturesName(path));
        return FSAFeatureDictionary.create(fsaData, featuresData);
    }

    public static byte[] getFSADictionaryInfo(String path) throws IOException {
        FileInputStream featuresData = new FileInputStream(Dictionary.getExpectedFeaturesName(path));
        return ByteArrayUtil.toByteArray(featuresData);
    }

    public static byte[] getFSADictionaryData(String path) throws IOException {
        FileInputStream featuresData = new FileInputStream(path);
        return ByteArrayUtil.toByteArray(featuresData);
    }

    public static FeatureDictionary create(InputStream fsaData, InputStream featuresData) throws IllegalArgumentException, IOException {
        DictionaryLookup dictLookup = new DictionaryLookup(Dictionary.readAndClose(fsaData, featuresData));
        return new FSAFeatureDictionary(dictLookup);
    }

    public static FeatureDictionary create(byte[] dictData, byte[] dictInfo) throws IllegalArgumentException, IOException {
        return FSAFeatureDictionary.create(new ByteArrayInputStream(dictData), new ByteArrayInputStream(dictInfo));
    }

    public static void main(String[] args) throws IllegalArgumentException, IOException {
        long start = System.nanoTime();
        FSAFeatureDictionary td = (FSAFeatureDictionary)FSAFeatureDictionary.create("../lang/pt_br/cogroo-res/fsa_dictionaries/featurizer/pt_br_feats.dict");
        System.out.println("Loading time [" + (System.nanoTime() - start) / 1000000L + "ms]");
        Scanner kb = new Scanner(System.in);
        System.out.print("Enter a query: ");
        String input = kb.nextLine();
        while (!input.equals("q")) {
            String[] parts;
            if (input.equals("0")) {
                input = "casa";
            }
            if ((parts = input.split("\\s+")).length == 2) {
                System.out.println(Arrays.toString(td.getFeatures(parts[0], parts[1])));
            } else {
                System.out.println("invalid... enter a space separated word + postag");
            }
            System.out.print("Enter a query: ");
            input = kb.nextLine();
        }
    }

    @Override
    public Iterator<WordTag> iterator() {
        return new IteratorWrapper(this.dictLookup.iterator());
    }

    public static FeatureDictionary createFromResources(String path) throws IllegalArgumentException, IOException {
        InputStream dic = FSAFeatureDictionary.class.getResourceAsStream(path);
        InputStream info = FSAFeatureDictionary.class.getResourceAsStream(Dictionary.getExpectedFeaturesName(path));
        FeatureDictionary fsa = FSAFeatureDictionary.create(dic, info);
        dic.close();
        info.close();
        return fsa;
    }

    private static class IteratorWrapper
    implements Iterator<WordTag> {
        private final Iterator<WordData> innerIterator;

        public IteratorWrapper(Iterator<WordData> iterator) {
            this.innerIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.innerIterator.hasNext();
        }

        @Override
        public WordTag next() {
            WordData wd = this.innerIterator.next();
            if (wd != null) {
                String completeTag = wd.getTag().toString();
                return new WordTag(wd.getWord().toString(), completeTag.substring(completeTag.indexOf("#") + 1));
            }
            return null;
        }

        @Override
        public void remove() {
            this.innerIterator.remove();
        }
    }
}

