/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.cmdline.dictionary;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.util.StringList;
import org.cogroo.ContractionUtility;
import org.cogroo.cmdline.dictionary.AbbreviationDictionaryBuilderParams;

public class AbbreviationDictionaryBuilderTool
extends BasicCmdLineTool {
    @Override
    public String getShortDescription() {
        return "builds a new dictionary";
    }

    @Override
    public String getHelp() {
        return this.getBasicHelp((Class<?>)Params.class);
    }

    @Override
    public void run(String[] args) {
        Params params = this.validateAndParseParams(args, Params.class);
        File dictOutFile = params.getOutputFile();
        CmdLineUtil.checkOutputFile("dictionary output file", dictOutFile);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dictOutFile);
            Dictionary dict = this.create(ContractionUtility.getContractionSet());
            dict.serialize(out);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage());
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException iOException) {}
        }
    }

    private Dictionary create(Set<String> contractionSet) {
        Dictionary d = new Dictionary(false);
        for (String contraction : contractionSet) {
            d.put(new StringList(contraction));
        }
        return d;
    }

    static interface Params
    extends AbbreviationDictionaryBuilderParams {
    }
}

