/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.analyzer;

import java.util.ArrayList;
import java.util.List;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.util.Span;
import org.cogroo.analyzer.Analyzer;
import org.cogroo.text.Chunk;
import org.cogroo.text.Document;
import org.cogroo.text.Sentence;
import org.cogroo.text.Token;
import org.cogroo.text.impl.ChunkImpl;
import org.cogroo.tools.chunker2.ChunkerME;
import org.cogroo.util.TextUtils;

public class Chunker
implements Analyzer {
    private ChunkerME chunker;

    public Chunker(ChunkerME chunker) {
        this.chunker = chunker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze(Document document) {
        List<Sentence> sentences = document.getSentences();
        for (Sentence sentence : sentences) {
            Span[] chunksSpans;
            String[] chunkTags;
            List<Token> tokens = sentence.getTokens();
            String[] tags = new String[tokens.size()];
            for (int i = 0; i < tokens.size(); ++i) {
                tags[i] = tokens.get(i).getPOSTag();
            }
            String[] tokensString = TextUtils.tokensToString(tokens);
            ArrayList<Chunk> chunks = new ArrayList<Chunk>();
            ChunkerME chunkerME = this.chunker;
            synchronized (chunkerME) {
                chunkTags = this.chunker.chunk(tokensString, tags);
            }
            for (int i = 0; i < chunkTags.length; ++i) {
                tokens.get(i).setChunkTag(chunkTags[i]);
            }
            for (Span span : chunksSpans = ChunkSample.phrasesAsSpanList(tokensString, tags, chunkTags)) {
                ChunkImpl chunk = new ChunkImpl(span.getType(), span.getStart(), span.getEnd(), sentence);
                chunks.add(chunk);
            }
            sentence.setChunks(chunks);
        }
    }
}

