﻿
#Область ОбработчикиСобытийФормы

Процедура ПриОткрытии()
	
	Если Не ПустаяСтрока(ПараметрЗапуска) Тогда
		ОбработатьПараметрыЗапуска(ПараметрЗапуска);
	КонецЕсли;
	
КонецПроцедуры

#КонецОбласти

#Область ОбработчикиКомандФормы

Процедура СравнитьНажатие(Элемент)
	СравнениеСпискаФайлов(ПервыйФайл, ВторойФайл);
КонецПроцедуры

#КонецОбласти

#Область ОбработчикиСобытийЭлементовШапкиФормы

Процедура ПервыйФайлНачалоВыбора(Элемент, СтандартнаяОбработка)
	НачалоВыбораФайла(Элемент, СтандартнаяОбработка, РежимДиалогаВыбораФайла.Открытие);
КонецПроцедуры

Процедура ВторойФайлНачалоВыбора(Элемент, СтандартнаяОбработка)
	НачалоВыбораФайла(Элемент, СтандартнаяОбработка, РежимДиалогаВыбораФайла.Открытие);
КонецПроцедуры

#КонецОбласти

#Область СлужебныеПроцедурыИФункции

Процедура СравнениеСпискаФайлов(ПервыйФайл, ВторойФайл, Результат = "")
	
	Перем ПервыйСписокФайлов, ВторойСписокФайлов, ЗаписываемРезультатВФайл;
	
	ПервыйСписокФайлов = ПрочитатьСписокФайлов(ПервыйФайл);
	Если ПервыйСписокФайлов.Количество() = 0 Тогда
		ПервыйСписокФайлов.Добавить(ПервыйФайл);
	КонецЕсли;
	
	ВторойСписокФайлов = ПрочитатьСписокФайлов(ВторойФайл);
	Если ВторойСписокФайлов.Количество() = 0 Тогда
		ВторойСписокФайлов.Добавить(ВторойФайл);
	КонецЕсли;
	
	Если ПервыйСписокФайлов.Количество() <> ВторойСписокФайлов.Количество() Тогда
		Предупреждение("Количество файлов в списках различается");
		Возврат;
	КонецЕсли;
	
	УказанФайлРезультат = Не ПустаяСтрока(Результат);
	Если УказанФайлРезультат Тогда
		ЗаписьТекста = Новый ЗаписьТекста(Результат, , , Ложь);
	КонецЕсли;
	
	Счетчик = 0;
	ВсеФайлыСовпали = Истина;
	
	Пока Счетчик < ПервыйСписокФайлов.Количество() Цикл
		
		ПервыйФайлДляСравнения = ПервыйСписокФайлов[Счетчик];
		ВторойФайлДляСравнения = ВторойСписокФайлов[Счетчик];
		
		Если ФайлыСходятся(ПервыйФайлДляСравнения, ВторойФайлДляСравнения, Не УказанФайлРезультат) Тогда
			
			Если УказанФайлРезультат Тогда
				ЗаписьТекста.ЗаписатьСтроку(ПервыйФайлДляСравнения);
			КонецЕсли;
			
		Иначе
			ВсеФайлыСовпали = Ложь;
		КонецЕсли;
		
		Счетчик = Счетчик + 1;
		
	КонецЦикла;
	
	Если УказанФайлРезультат Тогда
		ЗаписьТекста.Закрыть();
	КонецЕсли;
	
	Если ВсеФайлыСовпали И Не УказанФайлРезультат Тогда
		Предупреждение("Все файлы сходятся");
	КонецЕсли;
	
КонецПроцедуры

Функция ФайлыСходятся(ПервыйФайл, ВторойФайл, ПоказыватьРазличия)
	
	ОбъектПервыйФайл = Новый Файл(ПервыйФайл);
	Если ОбъектПервыйФайл.Расширение = ".xml" Тогда
		ПервыйФайлДляСравнения = ПолучитьИмяВременногоФайла("mxl");
		СохранитьТабличныйДокументВФайл(ПервыйФайл, ПервыйФайлДляСравнения);
		УдалитьПервыйФайл = Истина;
	Иначе
		ПервыйФайлДляСравнения = ПервыйФайл;
		УдалитьПервыйФайл = Ложь;
	КонецЕсли;
	
	ОбъектВторойФайл = Новый Файл(ВторойФайл);
	Если ОбъектВторойФайл.Расширение = ".xml" Тогда
		ВторойФайлДляСравнения = ПолучитьИмяВременногоФайла("mxl");
		СохранитьТабличныйДокументВФайл(ВторойФайл, ВторойФайлДляСравнения);
		УдалитьВторойФайл = Истина;
	Иначе
		ВторойФайлДляСравнения = ПервыйФайл;
		УдалитьВторойФайл = Ложь;
	КонецЕсли;
	
	СравнениеФайлов = Новый СравнениеФайлов;
	СравнениеФайлов.ПервыйФайл = ПервыйФайлДляСравнения;
	СравнениеФайлов.ВторойФайл = ВторойФайлДляСравнения;
	СравнениеФайлов.СпособСравнения = СпособСравненияФайлов.ТабличныйДокумент;
	СравнениеФайлов.ИгнорироватьПустоеПространство = Истина;
	
	ФайлыСовпали = СравнениеФайлов.Сравнить();
	
	Если Не ФайлыСовпали И ПоказыватьРазличия Тогда
		СравнениеФайлов.ПоказатьРазличияМодально();
	КонецЕсли;
	
	Если УдалитьПервыйФайл Тогда
		УдалитьФайлы(ПервыйФайлДляСравнения);
	КонецЕсли;
	
	Если УдалитьВторойФайл Тогда
		УдалитьФайлы(ВторойФайлДляСравнения);
	КонецЕсли;
	
	Возврат ФайлыСовпали;
	
КонецФункции

Процедура СохранитьТабличныйДокументВФайл(Знач ФайлXml, Знач ФайлMxl)
	
	ЧтениеXML =  Новый ЧтениеXML;
	ЧтениеXML.ОткрытьФайл(ФайлXml);
	ТабДок = СериализаторXDTO.ПрочитатьXML(ЧтениеXML, Тип("ТабличныйДокумент"));
	ТабДок.Записать(ФайлMxl);
	
КонецПроцедуры

Функция ПрочитатьСписокФайлов(ИмяФайла)
	
	Массив = Новый Массив;
	ОбъектФайл = Новый Файл(ИмяФайла);
	
	Если ОбъектФайл.Расширение <> ".txt" Тогда
		Возврат Массив;
	КонецЕсли;
	
	ЧтениеТекста = Новый ЧтениеТекста(ИмяФайла, КодировкаТекста.UTF8);
	
	СтрокаТекста = ЧтениеТекста.ПрочитатьСтроку();
	Пока СтрокаТекста <> Неопределено Цикл
		Массив.Добавить(СтрокаТекста);
		СтрокаТекста = ЧтениеТекста.ПрочитатьСтроку();
	КонецЦикла;
	
	ЧтениеТекста.Закрыть();
	
	Возврат Массив;
	
КонецФункции

Процедура НачалоВыбораФайла(Элемент, СтандартнаяОбработка, РежимДиалога)
	
	СтандартнаяОбработка = Ложь;
	
	ДиалогВыбораФайла = Новый ДиалогВыбораФайла(РежимДиалога);
	
	Если ЗначениеЗаполнено(Элемент.Значение) Тогда
		
		Файл = Новый Файл(Элемент.Значение);
		ДиалогВыбораФайла.Каталог = Файл.Путь;
		
	КонецЕсли;
	
	ДиалогВыбораФайла.Заголовок = "Выберите файл";
		
	Если ДиалогВыбораФайла.Выбрать() Тогда
		Элемент.Значение = ДиалогВыбораФайла.ПолноеИмяФайла;
	КонецЕсли;
	
КонецПроцедуры

Процедура ОбработатьПараметрыЗапуска(ПараметрЗапуска)
	
	Параметры = РазобратьПараметрыЗапуска(ПараметрЗапуска);
	
	ПервыйФайл = Параметры.First;
	ВторойФайл = Параметры.Second;
	
	Если Параметры.Свойство("Result") Тогда
		Результат = Параметры.Result;
	КонецЕсли;
	
	СравнениеСпискаФайлов(ПервыйФайл, ВторойФайл, Результат);
	ЗавершитьРаботуСистемы(Ложь);
	
КонецПроцедуры

Функция РазобратьПараметрыЗапуска(СтрокаПараметров)
	
	МассивПараметров = СтрРазделить(СтрокаПараметров, ";", Ложь);
	
	Структура = Новый Структура;
	
	Для Каждого Элемент Из МассивПараметров Цикл
		
		КлючПараметр = СтрРазделить(Элемент, "=", Ложь);
		Структура.Вставить(ТРег(СокрЛП(КлючПараметр[0])), СокрЛП(КлючПараметр[1]));
		
	КонецЦикла;
	
	Возврат Структура;
	
КонецФункции

#КонецОбласти
