# PytorchDeepML


This library is a wrapper around pytorch and useful for solving image classification and semantic
segmentation problems.

### Features
1. Easy to use wrapper around pytorch so that you can focus on training and
   validating your model.

2. Integrates with Tensorboard to use it to monitor metrics while model trains.

3. Quickly visualize your model's predictions.


# Installation

Before installing **deepml**, it is recommended to refer [pytorch](https://pytorch.org/) official page for **torch** installation.

### Pypi

```bash
pip install deepml
```


# Examples
Check out the below google colaboratory notebook examples:

1. [Image Regression](https://colab.research.google.com/github/sagar-rathod/PytorchDeepML/blob/master/examples/Image_Regression_Example.ipynb).
2. [Image Classification](https://colab.research.google.com/github/sagar-rathod/PytorchDeepML/blob/master/examples/Image_Classification_Example.ipynb).
3. Semantic Segmentation. [Coming Soon]


# Contributing
If you find a bug or have a feature request, file an issue at https://github.com/sagar-rathod/PytorchDeepML/issues
