# coding: utf-8

"""
  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.

  Licensed under the Apache License, Version 2.0 (the "License").
  You may not use this file except in compliance with the License.
  A copy of the License is located at

      http://www.apache.org/licenses/LICENSE-2.0

  or in the "license" file accompanying this file. This file is distributed
  on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
  express or implied. See the License for the specific language governing
  permissions and limitations under the License.
"""


"""
    ProductAdvertisingAPI

    https://webservices.amazon.com/paapi5/documentation/index.html  # noqa: E501
"""


import pprint
import re  # noqa: F401

import six

from .price import Price  # noqa: F401,E501
from .variation_dimension import VariationDimension  # noqa: F401,E501


class VariationSummary(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'page_count': 'int',
        'price': 'Price',
        'variation_count': 'int',
        'variation_dimensions': 'list[VariationDimension]'
    }

    attribute_map = {
        'page_count': 'PageCount',
        'price': 'Price',
        'variation_count': 'VariationCount',
        'variation_dimensions': 'VariationDimensions'
    }

    def __init__(self, page_count=None, price=None, variation_count=None, variation_dimensions=None):  # noqa: E501
        """VariationSummary - a model defined in Swagger"""  # noqa: E501

        self._page_count = None
        self._price = None
        self._variation_count = None
        self._variation_dimensions = None
        self.discriminator = None

        if page_count is not None:
            self.page_count = page_count
        if price is not None:
            self.price = price
        if variation_count is not None:
            self.variation_count = variation_count
        if variation_dimensions is not None:
            self.variation_dimensions = variation_dimensions

    @property
    def page_count(self):
        """Gets the page_count of this VariationSummary.  # noqa: E501


        :return: The page_count of this VariationSummary.  # noqa: E501
        :rtype: int
        """
        return self._page_count

    @page_count.setter
    def page_count(self, page_count):
        """Sets the page_count of this VariationSummary.


        :param page_count: The page_count of this VariationSummary.  # noqa: E501
        :type: int
        """

        self._page_count = page_count

    @property
    def price(self):
        """Gets the price of this VariationSummary.  # noqa: E501


        :return: The price of this VariationSummary.  # noqa: E501
        :rtype: Price
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this VariationSummary.


        :param price: The price of this VariationSummary.  # noqa: E501
        :type: Price
        """

        self._price = price

    @property
    def variation_count(self):
        """Gets the variation_count of this VariationSummary.  # noqa: E501


        :return: The variation_count of this VariationSummary.  # noqa: E501
        :rtype: int
        """
        return self._variation_count

    @variation_count.setter
    def variation_count(self, variation_count):
        """Sets the variation_count of this VariationSummary.


        :param variation_count: The variation_count of this VariationSummary.  # noqa: E501
        :type: int
        """

        self._variation_count = variation_count

    @property
    def variation_dimensions(self):
        """Gets the variation_dimensions of this VariationSummary.  # noqa: E501


        :return: The variation_dimensions of this VariationSummary.  # noqa: E501
        :rtype: list[VariationDimension]
        """
        return self._variation_dimensions

    @variation_dimensions.setter
    def variation_dimensions(self, variation_dimensions):
        """Sets the variation_dimensions of this VariationSummary.


        :param variation_dimensions: The variation_dimensions of this VariationSummary.  # noqa: E501
        :type: list[VariationDimension]
        """

        self._variation_dimensions = variation_dimensions

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(VariationSummary, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VariationSummary):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
