# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['flask_jeroboam']

package_data = \
{'': ['*']}

install_requires = \
['Flask>=2.1.3,<3.0.0', 'pydantic>=1.10.2,<2.0.0']

setup_kwargs = {
    'name': 'flask-jeroboam',
    'version': '0.0.3a0',
    'description': 'Bringing FastAPI Developer experience to Flask.',
    'long_description': '<div align="center">\n    <img\n        src="https://github.com/jcbianic/flask-jeroboam/blob/main/docs/_static/jeroboam_logo_with_text.png"\n        width="400px"\n        alt="jeroboam-logo">\n    </img>\n</div>\n<h1 align="center">Flask-Jeroboam</h1>\n\n<div align="center">\n\n<i>Flask-Jeroboam is a Flask extension modeled after FastAPI. It uses Pydantic to provide easy-to-configure data validation in request parsing and response serialization.</i>\n\n[![PyPI](https://img.shields.io/pypi/v/flask-jeroboam.svg)][pypi_]\n[![Python Version](https://img.shields.io/pypi/pyversions/flask-jeroboam)][python version]\n[![License](https://img.shields.io/github/license/jcbianic/flask-jeroboam?color=green)][license]\n[![Commit](https://img.shields.io/github/last-commit/jcbianic/flask-jeroboam?color=green)][commit]\n\n[![Read the documentation at https://flask-jeroboam.readthedocs.io/](https://img.shields.io/readthedocs/flask-jeroboam/latest.svg?label=Read%20the%20Docs)][read the docs]\n[![Maintainability](https://api.codeclimate.com/v1/badges/181b7355cee7b1316893/maintainability)](https://img.shields.io/codeclimate/maintainability/jcbianic/flask-jeroboam?color=green)\n[![Test Coverage](https://api.codeclimate.com/v1/badges/181b7355cee7b1316893/test_coverage)](https://img.shields.io/codeclimate/coverage/jcbianic/flask-jeroboam?color=green)\n[![Tests](https://github.com/jcbianic/flask-jeroboam/workflows/Tests/badge.svg)][tests]\n[![Black](https://img.shields.io/badge/code%20style-black-000000.svg)][black]\n\n[pypi_]: https://pypi.org/project/flask-jeroboam/\n[status]: https://pypi.org/project/flask-jeroboam/\n[python version]: https://pypi.org/project/flask-jeroboam\n[read the docs]: https://flask-jeroboam.readthedocs.io/\n[tests]: https://github.com/jcbianic/flask-jeroboam/actions?workflow=Tests\n[codecov]: https://app.codecov.io/gh/jcbianic/flask-jeroboam\n[pre-commit]: https://github.com/pre-commit/pre-commit\n[black]: https://github.com/psf/black\n[commit]: https://img.shields.io/github/last-commit/jcbianic/flask-jeroboam\n\n</div>\n\n---\n\n**Documentation**: [https://flask-jeroboam.readthedocs.io/](https://flask-jeroboam.readthedocs.io/)\n\n**Source Code**: [https://github.com/jcbianic/flask-jeroboam](https://github.com/jcbianic/flask-jeroboam)\n\n---\n\nFlask-Jeroboam is a thin layer on top of Flask to make request parsing, response serialization and auto-documentation as smooth and easy as in FastAPI.\n\nIts main features are:\n\n- Request parsing based on typed annotations of endpoint arguments\n- Response serialization facilitation\n- (Planned) OpenAPI auto-Documentation based on the latters\n\n## How to install\n\nYou can install _flask-jeroboam_ via [pip] or any other tool wired to [PyPI]:\n\n```console\n$ pip install flask-jeroboam\n```\n\n## How to use\n\n### A toy example\n\n_Flask-Jeroboam_ subclasses both Flask and Blueprint classes. This means that the **Jeroboam** and **APIBlueprint** will behave exactly like their Flask counterparts unless you activate their extra behaviors.\n\n```python\nfrom flask-jeroboam import Jeroboam\n\napp = Jeroboam()\n\n@app.get("ping")\ndef ping():\n    return "pong"\n```\n\nThis toy example would work exactly like a regular Flask app. You would start your server just like with Flask. `flask run` would do perfectly fine here.\n\nThen hitting the endpoint with `curl localhost:5000/ping` would return the text response `pong`.\n\nLet\'s try a more significant and relevant example and build a simplified endpoint to retrieve a list of wines, we are wine-themed afterall.\n\n### Searching for wines\n\nLet\'s consider an endpoint meant to provide search capability onto a wine repository. It takes three arguments from the query string, feed them into a CRUD function `get_wines` that return a list of wines as well as the total count of wines matching the query.\nAdditionnaly, this particular endpoint only need to return the name of the cuvee and the appellation and discard any other informations. Let\'s take a look at what it might look like with _Flask-Jeroboam_:\n\n```python\nfrom flask_jeroboam import Jeroboam, Parser, Serializer\n\napp = Jeroboam(__name__)\n\nclass PaginatedSearch(Parser):\n    page: int = Field(default=1)\n    per_page: int = Field(default=10)\n    search: Optional[str]\n\nclass WineOut(Serializer):\n    cuvee: str\n    appellation: str\n\nclass WineListOut(Serializer):\n    wines: WineOut\n    count: int\n    total_count: int\n\n@app.get("/wines", response_model=WineListOut)\ndef read_wine_list(wine_search: PaginatedSearch):\n    wines, total_count = get_wines(wine_search)\n    return {"wines": wines, "count": len(wines), "total_count": total_count}\n\n\nif __name__ == "__main__":\n    app.run()\n```\n\nOnce you\'ve started your server, then hitting the endpoint with `curl "localhost:5000/wines?page=1&per_page=2&search=Champagne"` would return something like:\n\n```json\n{\n  "wines": [\n    {\n      "appellation": "Champagne",\n      "cuvee": "Brut - Blanc de Blancs"\n    },\n    {\n      "appellation": "Champagne",\n      "cuvee": "Grande Cuvée - 170ème Edition"\n    }\n  ],\n  "count": 2,\n  "total_count": 3\n}\n```\n\nSee the documentation on more advanced usage: [https://flask-jeroboam.readthedocs.io/](https://flask-jeroboam.readthedocs.io/)\n\n## Motivation\n\n[FastAPI] has been rapidly gaining ground in Python Web Development since its inception in late 2018 ([1][survey]). It is indeed an amazing framework with killer documentation. Besides best-in-class performance, it brings a very compelling API for request parsing and response serialization that speed up API development and provide an incredibly smooth Developer Experience.\n\nAlthough trying to reproduce [FastAPI] [Starlette]-based performance in another framework like [Flask] would be rather hard and non-sensical, its API for defining endpoints is fair game. There are some excellent Flask extensions dealing with request parsing, response serialization, and auto-documentation, but nothing _exactly_ like [FastAPI]. That is what I started exploring with **Flask-Jeroboam**.\n\n[survey]: https://lp.jetbrains.com/python-developers-survey-2021/#FrameworksLibraries\n[ref#1]: https://testdriven.io/blog/moving-from-flask-to-fastapi/\n[ref#2]: https://developer.vonage.com/blog/21/08/10/the-ultimate-face-off-flask-vs-fastapi\n[ref#3]: https://towardsdatascience.com/understanding-flask-vs-fastapi-web-framework-fe12bb58ee75\n\n## A word on performance\n\nOne thing **Flask-Jeroboam** won\'t give you is performance improvement. Underneath Flask, werkzeug still handles the heavy lifting of a wsgi, so transitioning to **Flask-Jeroboam** won\'t speed up your app. Please remember that FastAPI\'s performance comes from Starlette, not FastAPI itself.\n\n## Intended audience\n\nThe intended audience of **Flask-Jeroboam** is Flask developers who find FastAPI very attractive but also have excellent reasons to stick to Flask.\n\n## About the name of the project\n\nA **Jeroboam** is a large bottle, or flask, containing either 3 or 6 liters of wines depending on the region of production. They are mainly used for fine wines destined to aging because they provide better condition for doing so. Their ratio between the volume of wine it contains and the surface of exchange between the wine and the air is more favorable and slows donw the oxidation reaction. Theses containers also take longer to cool down or warm up leading to less thermal violence to the wine during conservation.\n\nIn other words they are more durable flasks for fine wines. The intention is to hold this promise for APIs.\n\nThe wine-themed name is a tribute to the Bordeaux-based wine tech startup where the development of this package started.\n\n## License\n\nDistributed under the terms of the [MIT license][license], **Flask-Jeroboam** is free and open source software.\n\n## Issues\n\nIf you encounter any problems, please [file an issue] along with a detailed description.\n\n## Credits\n\nThe main inspiration for this project comes from [@tiangolo]\'s [FastAPI].\n[Flask] and [pydantic] are the two direct dependencies and do most of the work.\nI used [@cjolowicz]\'s [Hypermodern Python Cookiecutter] template to generate this project.\n\n[@cjolowicz]: https://github.com/cjolowicz\n[@tiangolo]: https://github.com/tiangolo\n[fastapi]: https://fastapi.tiangolo.com/\n[starlette]: https://www.starlette.io/\n[flask]: https://flask.palletsprojects.com/\n[pydantic]: https://pydantic-docs.helpmanual.io/\n[pypi]: https://pypi.org/\n[hypermodern python cookiecutter]: https://github.com/cjolowicz/cookiecutter-hypermodern-python\n[file an issue]: https://github.com/jcbianic/flask-jeroboam/issues\n[pip]: https://pip.pypa.io/\n\n<!-- github-only -->\n\n[license]: https://github.com/jcbianic/flask-jeroboam/blob/main/LICENSE\n[contributor guide]: https://github.com/jcbianic/flask-jeroboam/blob/main/CONTRIBUTING.md\n[command-line reference]: https://flask-jeroboam.readthedocs.io/en/latest/usage.html\n',
    'author': 'Jean-Christophe Bianic',
    'author_email': 'jc.bianic@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/jcbianic/flask-jeroboam',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8.1,<4.0.0',
}


setup(**setup_kwargs)
