#!/usr/bin/env python
from setuptools import setup
setup(
  name = 'cs.fileutils',
  description = 'convenience functions and classes for files and filenames/pathnames',
  author = 'Cameron Simpson',
  author_email = 'cs@cskk.id.au',
  version = '20200318',
  url = 'https://bitbucket.org/cameron_simpson/css/commits/all',
  classifiers = ['Programming Language :: Python', 'Programming Language :: Python :: 2', 'Programming Language :: Python :: 3', 'Development Status :: 4 - Beta', 'Intended Audience :: Developers', 'Operating System :: OS Independent', 'Topic :: Software Development :: Libraries :: Python Modules', 'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)'],
  include_package_data = True,
  install_requires = ['cs.buffer', 'cs.deco', 'cs.env', 'cs.filestate', 'cs.lex', 'cs.logutils', 'cs.pfx', 'cs.py3', 'cs.range', 'cs.result', 'cs.threads', 'cs.timeutils'],
  keywords = ['python2', 'python3'],
  license = 'GNU General Public License v3 or later (GPLv3+)',
  long_description = '*Latest release 20200318*:\nNew findup(path,test) generator to walk up a file tree.\n\nAssorted convenience functions for files and filenames/pathnames.\n\n## Function `abspath_from_file(path, from_file)`\n\nReturn the absolute path of `path` with respect to `from_file`,\nas one might do for an include file.\n\n## Class `BackedFile(ReadMixin)`\n\nA RawIOBase duck type\nwhich uses a backing file for initial data\nand writes new data to a front scratch file.\n\n### Method `BackedFile.__init__(self, back_file, dirpath=None)`\n\nInitialise the BackedFile using `back_file` for the backing data.\n\n## Class `BackedFile_TestMethods`\n\nMixin for testing subclasses of BackedFile.\nTests self.backed_fp.\n\n## Function `compare(f1, f2, mode=\'rb\')`\n\nCompare the contents of two file-like objects `f1` and `f2` for equality.\n\nIf `f1` or `f2` is a string, open the named file using `mode`\n(default: "rb").\n\n## Function `copy_data(fpin, fpout, nbytes, rsize=None)`\n\nCopy `nbytes` of data from `fpin` to `fpout`,\nreturn the number of bytes copied.\n\nParameters:\n* `nbytes`: number of bytes to copy.\n  If `None`, copy until EOF.\n* `rsize`: read size, default `DEFAULT_READSIZE`.\n\n## Function `datafrom(arg, *a, **kw)`\n\nGeneral purpose reader for files yielding data from `offset`.\n\n*WARNING*: this function might move the file pointer.\n\nParameters:\n* `f`: the file from which to read data; if a string, the file\n  is opened with mode="rb"; if an int, treated as an OS file\n  descriptor; otherwise presumed to be a file-like object.\n  If that object has a `.fileno()` method, treat that as an\n  OS file descriptor and use it.\n* `offset`: starting offset for the data\n* `maxlength`: optional maximum amount of data to yield\n* `readsize`: read size, default DEFAULT_READSIZE.\n\nFor file-like objects, the read1 method is used in preference\nto read if available. The file pointer is briefly moved during\nfetches.\n\n## Function `datafrom_fd(fd, offset=None, readsize=None, aligned=True, maxlength=None)`\n\nGeneral purpose reader for file descriptors yielding data from `offset`.\nThis does not move the file descriptor position.\n\nParameters:\n* `fd`: the file descriptor from which to read.\n* `offset`: the offset from which to read.\n  If omitted, use the current file descriptor position.\n* `readsize`: the read size, default: `DEFAULT_READSIZE`\n* `aligned`: if true (the default), the first read is sized\n  to align the new offset with a multiple of `readsize`.\n* `maxlength`: if specified yield no more than this many bytes of data.\n\n## Function `file_based(*da, **dkw)`\n\nA decorator which caches a value obtained from a file.\n\nIn addition to all the keyword arguments for `@cs.deco.cachedmethod`,\nthis decorator also accepts the following arguments:\n* `attr_name`: the name for the associated attribute, used as\n  the basis for the internal cache value attribute\n* `filename`: the filename to monitor.\n  Default from the `._{attr_name}__filename attribute.\n  This value will be passed to the method as the `filename` keyword\n  parameter.\n* `poll_delay`: delay between file polls, default `DEFAULT_POLL_INTERVAL`.\n* `sig_func`: signature function used to encapsulate the relevant\n  information about the file; default\n  cs.filestate.FileState({filename}).\n\nIf the decorated function raises OSError with errno == ENOENT,\nthis returns None. Other exceptions are reraised.\n\n## Function `file_data(fp, nbytes=None, rsize=None)`\n\nRead `nbytes` of data from `fp` and yield the chunks as read.\n\nParameters:\n* `nbytes`: number of bytes to read; if None read until EOF.\n* `rsize`: read size, default DEFAULT_READSIZE.\n\n## Function `file_property(*da, **dkw)`\n\nA property whose value reloads if a file changes.\n\n## Function `files_property(func)`\n\nA property whose value reloads if any of a list of files changes.\n\nNote: this is just the default mode for `make_files_property`.\n\n`func` accepts the file path and returns the new value.\nThe underlying attribute name is \'_\' + func.__name__,\nthe default from make_files_property().\nThe attribute {attr_name}_lock controls access to the property.\nThe attributes {attr_name}_filestates and {attr_name}_paths track the\nassociated file states.\nThe attribute {attr_name}_lastpoll tracks the last poll time.\n\nThe decorated function is passed the current list of files\nand returns the new list of files and the associated value.\nOne example use would be a configuration file with recurive\ninclude operations; the inner function would parse the first\nfile in the list, and the parse would accumulate this filename\nand those of any included files so that they can be monitored,\ntriggering a fresh parse if one changes.\n\nExample:\n\n    class C(object):\n      def __init__(self):\n        self._foo_path = \'.foorc\'\n      @files_property\n      def foo(self,paths):\n        new_paths, result = parse(paths[0])\n        return new_paths, result\n\nThe load function is called on the first access and on every\naccess thereafter where an associated file\'s `FileState` has\nchanged and the time since the last successful load exceeds\nthe poll_rate (1s). An attempt at avoiding races is made by\nignoring reloads that raise exceptions and ignoring reloads\nwhere files that were stat()ed during the change check have\nchanged state after the load.\n\n## Function `findup(path, test, first=False)`\n\nTest the pathname `abspath(path)` and each of its ancestors\nagainst the callable `test`,\nyielding paths satisfying the test.\n\nIf `first` is true (default `False`)\nthis function always yields exactly one value,\neither the first path satisfying the test or `None`.\nThis mode supports a use such as:\n\n    matched_path = next(findup(path, test, first=True))\n    # post condition: matched_path will be `None` on no match\n    # otherwise the first matching path\n\n## Function `lines_of(fp, partials=None)`\n\nGenerator yielding lines from a file until EOF.\nIntended for file-like objects that lack a line iteration API.\n\n## Function `lockfile(path, ext=None, poll_interval=None, timeout=None, runstate=None)`\n\nA context manager which takes and holds a lock file.\n\nParameters:\n* `path`: the base associated with the lock file.\n* `ext`: the extension to the base used to construct the lock file name.\n  Default: ".lock"\n* `timeout`: maximum time to wait before failing.\n  Default: `None` (wait forever).\n* `poll_interval`: polling frequency when timeout is not 0.\n* `runstate`: optional RunState duck instance supporting cancellation.\n\n## Function `longpath(path, environ=None, prefixes=None)`\n\nReturn `path` with prefixes and environment variables substituted.\nThe converse of shortpath().\n\n## Function `make_files_property(attr_name=None, unset_object=None, poll_rate=1.0)`\n\nConstruct a decorator that watches multiple associated files.\n\nParameters:\n* `attr_name`: the underlying attribute, default: `\'_\'+func.__name__`\n* `unset_object`: the sentinel value for "uninitialised", default: `None`\n* `poll_rate`: how often in seconds to poll the file for changes,\n  default from `DEFAULT_POLL_INTERVAL`: `1.0`\n\nThe attribute {attr_name}_lock controls access to the property.\nThe attributes {attr_name}_filestates and {attr_name}_paths track the\nassociated files\' state.\nThe attribute {attr_name}_lastpoll tracks the last poll time.\n\nThe decorated function is passed the current list of files\nand returns the new list of files and the associated value.\n\nOne example use would be a configuration file with recursive\ninclude operations; the inner function would parse the first\nfile in the list, and the parse would accumulate this filename\nand those of any included files so that they can be monitored,\ntriggering a fresh parse if one changes.\n\nExample:\n\n    class C(object):\n      def __init__(self):\n        self._foo_path = \'.foorc\'\n      @files_property\n      def foo(self,paths):\n        new_paths, result = parse(paths[0])\n        return new_paths, result\n\nThe load function is called on the first access and on every\naccess thereafter where an associated file\'s `FileState` has\nchanged and the time since the last successful load exceeds\nthe `poll_rate`.\n\nAn attempt at avoiding races is made by\nignoring reloads that raise exceptions and ignoring reloads\nwhere files that were `os.stat`()ed during the change check have\nchanged state after the load.\n\n## Function `makelockfile(path, ext=None, poll_interval=None, timeout=None, runstate=None)`\n\nCreate a lockfile and return its path.\n\nThe lockfile can be removed with os.remove.\nThis is the core functionality supporting the lockfile()\ncontext manager.\n\nParamaters:\n* `path`: the base associated with the lock file,\n  often the filesystem object whose access is being managed.\n* `ext`: the extension to the base used to construct the lockfile name.\n  Default: ".lock"\n* `timeout`: maximum time to wait before failing.\n  Default: `None` (wait forever).\n  Note that zero is an accepted value\n  and requires the lock to succeed on the first attempt.\n* `poll_interval`: polling frequency when timeout is not 0.\n* `runstate`: optional RunState duck instance supporting cancellation.\n  Note that if a cancelled RunState is provided\n  no attempt will be made to make the lockfile.\n\n## Function `max_suffix(dirpath, pfx)`\n\nCompute the highest existing numeric suffix\nfor names starting with the prefix `pfx`.\n\nThis is generally used as a starting point for picking a new numeric suffix.\n\n## Function `mkdirn(path, sep=\'\')`\n\nCreate a new directory named `path+sep+n`,\nwhere `n` exceeds any name already present.\n\nParameters:\n* `path`: the basic directory path.\n* `sep`: a separator between `path` and n.\n  Default: ""\n\n## Class `NullFile`\n\nWritable file that discards its input.\n\nNote that this is _not_ an open of `os.devnull`;\nit just discards writes and is not the underlying file descriptor.\n\n### Method `NullFile.__init__(self)`\n\nInitialise the file offset to 0.\n\n## Class `Pathname(builtins.str)`\n\nSubclass of str presenting convenience properties useful for\nformat strings related to file paths.\n\n## Function `poll_file(path, old_state, reload_file, missing_ok=False)`\n\nWatch a file for modification by polling its state as obtained by FileState().\nCall reload_file(path) if the state changes.\nReturn (new_state, reload_file(path)) if the file was modified and was\nunchanged (stable state) beofre and after the reload_file().\nOtherwise return (None, None).\n\nThis may raise an OSError if the `path` cannot be os.stat()ed\nand of course for any exceptions that occur calling `reload_file`.\n\nIf `missing_ok` is true then a failure to os.stat() which\nraises OSError with ENOENT will just return (None, None).\n\n## Function `read_data(fp, nbytes, rsize=None)`\n\nRead `nbytes` of data from `fp`, return the data.\n\nParameters:\n* `nbytes`: number of bytes to copy.\n  If `None`, copy until EOF.\n* `rsize`: read size, default `DEFAULT_READSIZE`.\n\n## Function `read_from(fp, rsize=None, tail_mode=False, tail_delay=None)`\n\nGenerator to present text or data from an open file until EOF.\n\nParameters:\n* `rsize`: read size, default: DEFAULT_READSIZE\n* `tail_mode`: if true, yield an empty chunk at EOF, allowing resumption\n  if the file grows.\n\n## Class `ReadMixin`\n\nUseful read methods to accomodate modes not necessarily available in a class.\n\nNote that this mixin presumes that the attribute `self._lock`\nis a threading.RLock like context manager.\n\nClasses using this mixin should consider overriding the default\n.datafrom method with something more efficient or direct.\n\n## Function `rewrite(filepath, data, mode=\'w\', backup_ext=None, do_rename=False, do_diff=None, empty_ok=False, overwrite_anyway=False)`\n\nRewrite the file `filepath` with data from the file object `data`.\n\nParameters:\n* `empty_ok`: if not true, raise ValueError if the new data are\n  empty.\n  Default: `False`.\n* `overwrite_anyway`: if true (default `False`),\n  skip the content check and overwrite unconditionally.\n* `backup_ext`: if a nonempty string,\n  take a backup of the original at `filepath + backup_ext`.\n* `do_diff`: if not None, call `do_diff(filepath, tempfile)`.\n* `do_rename`: if true (default False),\n  rename the temp file to `filepath`\n  after copying the permission bits.\n  Otherwise (default), copy the tempfile to `filepath`.\n\n## Function `rewrite_cmgr(pathname, mode=\'w\', backup_ext=None, keep_backup=False, do_rename=False, do_diff=None, empty_ok=False, overwrite_anyway=False)`\n\nRewrite a file, presented as a context manager.\n\nParameters:\n* `mode`: file write mode, defaulting to "w" for text.\n* `backup_ext`: backup extension. `None` means no backup.\n  An empty string generates an extension based on the current time.\n* `keep_backup`: keep the backup file even if everything works.\n* `do_rename`: rename the temporary file to the original to update.\n* `do_diff`: call `do_diff(pathname, tempfile)` before commiting.\n* `empty_ok`: do not consider empty output an error.\n* `overwrite_anyway`: do not update the original if the new\n  data are identical.\n\nExample:\n\n    with rewrite_cmgr(pathname, backup_ext=\'\', keep_backup=True) as f:\n       ... write new content to f ...\n\n## Class `RWFileBlockCache`\n\nA scratch file for storing data.\n\n### Method `RWFileBlockCache.__init__(self, pathname=None, dirpath=None, suffix=None, lock=None)`\n\nInitialise the file.\n\nParameters:\n* `pathname`: path of file. If None, create a new file with\n  tempfile.mkstemp using dir=`dirpath` and unlink that file once\n  opened.\n* `dirpath`: location for the file if made by mkstemp as above.\n* `lock`: an object to use as a mutex, allowing sharing with\n  some outer system. A Lock will be allocated if omitted.\n\n## Function `saferename(oldpath, newpath)`\n\nRename a path using os.rename(),\nbut raise an exception if the target path already exists.\nNote: slightly racey.\n\n## Function `seekable(fp)`\n\nTry to test if a filelike object is seekable.\n\nFirst try the `.seekable` method from `IOBase`, otherwise try\ngetting a file descriptor from `fp.fileno` and `os.stat`()ing that,\notherwise return `False`.\n\n## Function `shortpath(path, environ=None, prefixes=None)`\n\nReturn `path` with the first matching leading prefix replaced.\n\nParameters:\n* `environ`: environment mapping if not os.environ\n* `prefixes`: iterable of (prefix, subst) to consider for replacement;\n  each `prefix` is subject to environment variable\n  substitution before consideration\n  The default considers "$HOME/" for replacement by "~/".\n\n## Class `Tee`\n\nAn object with .write, .flush and .close methods\nwhich copies data to multiple output files.\n\n### Method `Tee.__init__(self, *fps)`\n\nInitialise the Tee; any arguments are taken to be output file objects.\n\n## Function `tee(fp, fp2)`\n\nContext manager duplicating .write and .flush from fp to fp2.\n\n## Function `tmpdir()`\n\nReturn the pathname of the default temporary directory for scratch data,\n$TMPDIR or \'/tmp\'.\n\n## Function `tmpdirn(tmp=None)`\n\nMake a new temporary directory with a numeric suffix.\n\n## Function `trysaferename(oldpath, newpath)`\n\nA saferename() that returns True on success, False on failure.\n\n\n\n# Release Log\n\n*Release 20200318*:\nNew findup(path,test) generator to walk up a file tree.\n\n*Release 20191006*:\nAdjust import of cs.deco.cachedmethod.\n\n*Release 20190729*:\ndatafrom_fd: make `offset` optional, defaulting to fd position at call.\n\n*Release 20190617*:\n@file_based: adjust use of @cached from cached(wrap0, **dkw) to cached(**dkw)(wrap0).\n\n*Release 20190101*:\ndatafrom: add maxlength keyword arg, bugfix fd and f.fileno cases.\n\n*Release 20181109*:\nVarious bugfixes for BackedFile.\nUse a file\'s .read1 method if available in some scenarios.\nmakelockfile: accept am optional RunState control parameter, improve some behaviour.\ndatafrom_fd: new optional maxlength parameter limiting the amount of data returned.\ndatafrom_fd: by default, perform an initial read to align all subsequent reads with the readsize.\ndrop fdreader, add datafrom(f, offset, readsize) accepting a file or a file descriptor, expose datafrom_fd.\nReadMixin.datafrom now mandatory. Add ReadMixin.bufferfrom.\nAssorted other improvements, minor bugfixes, documentation improvements.\n\n*Release 20171231.1*:\nTrite DISTINFO fix, no semantic changes.\n\n*Release 20171231*:\nUpdate imports, bump DEFAULT_READSIZE from 8KiB to 128KiB.\n\n*Release 20170608*:\nMove lockfile and the SharedAppend* classes to cs.sharedfile.\nBackedFile internal changes.\n\n*Release 20160918*:\nBackedFile: redo implementation of .front_file to fix resource leak; add .__len__; add methods .spans, .front_spans and .back_spans to return information about front vs back data.\nseek: bugfix: seek should return the new file offset.\nBackedFile does not subclass RawIOBase, it just works like one.\n\n*Release 20160828*:\nUse "install_requires" instead of "requires" in DISTINFO.\nRename maxFilenameSuffix to max_suffix.\nPull in OpenSocket file-like socket wrapper from cs.venti.tcp.\nUpdate for cs.asynchron changes.\n... then move cs.fileutils.OpenSocket into new module cs.socketutils.\nNew Tee class, for copying output to multiple files.\nNullFile class which discards writes (==> no-op for Tee).\nNew class SavingFile to accrue output and move to specified pathname when complete.\nMemory usage improvements.\nPolyfill non-threadsafe implementation of pread if os.pread does not exist.\nNew function seekable() to probe a file for seekability.\nSharedAppendFile: provide new .open(filemode) context manager for allowing direct file output for external users.\nNew function makelockfile() presenting the logic to create a lock file separately from the lockfile context manager.\nAssorted bugfixes and improvements.\n\n*Release 20150116*:\nInitial PyPI release.',
  long_description_content_type = 'text/markdown',
  package_dir = {'': 'lib/python'},
  py_modules = ['cs.fileutils'],
)
