from ..util import Model

from .action_response import ActionResponse

class SuccessResponse(Model, ActionResponse):
	def __init__(self):
		self.__custom_views = None
		self.__info = None
		self.__key_modified = dict()

	def get_custom_views(self):
		return self.__custom_views

	def set_custom_views(self, custom_views):
		self.__custom_views = custom_views
		self.__key_modified["custom_views"] = 1

	def get_info(self):
		return self.__info

	def set_info(self, info):
		self.__info = info
		self.__key_modified["info"] = 1

	def is_key_modified(self, key):
		return self.__key_modified.get(key)

	def set_key_modified(self, modification, key):
		self.__key_modified[key] = modification
