"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decodeParameters = exports.deepParseJson = void 0;
function deepParseJson(x) {
    if (typeof x === 'string') {
        return tryJsonParse(x);
    }
    if (Array.isArray(x)) {
        return x.map(deepParseJson);
    }
    if (x && typeof x === 'object') {
        for (const [key, value] of Object.entries(x)) {
            x[key] = deepParseJson(value);
        }
        return x;
    }
    return x;
}
exports.deepParseJson = deepParseJson;
function tryJsonParse(v) {
    if (typeof (v) !== 'string') {
        return v;
    }
    try {
        return JSON.parse(v);
    }
    catch {
        return v;
    }
}
function decodeParameters(obj) {
    return Object.fromEntries(Object.entries(obj).map(([key, value]) => {
        try {
            return [key, decodeValue(value)];
        }
        catch {
            // if the value cannot be parsed, leave it unchanged
            // this will end up as a string
            return [key, value];
        }
    }));
}
exports.decodeParameters = decodeParameters;
function decodeValue(value) {
    if (value != null && !Array.isArray(value) && typeof value === 'object') {
        if (value.$type === 'ArrayBufferView') {
            return new TextEncoder().encode(value.string);
        }
    }
    return JSON.parse(value);
}
//# sourceMappingURL=data:application/json;base64,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