"use strict";
// This file contains the input and output types for the providers.
// Kept in a separate file for sharing between the handler and the provider constructs.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Status = exports.AssertionType = exports.HTTP_RESOURCE_TYPE = exports.SDK_RESOURCE_TYPE_PREFIX = exports.ASSERT_RESOURCE_TYPE = void 0;
exports.ASSERT_RESOURCE_TYPE = 'Custom::DeployAssert@AssertEquals';
exports.SDK_RESOURCE_TYPE_PREFIX = 'Custom::DeployAssert@SdkCall';
exports.HTTP_RESOURCE_TYPE = 'Custom::DeployAssert@HttpCall';
/**
 * The type of assertion to perform
 */
var AssertionType;
(function (AssertionType) {
    /**
     * Assert that two values are equal
     */
    AssertionType["EQUALS"] = "equals";
    /**
     * The keys and their values must be present in the target but the target
     * can be a superset.
     */
    AssertionType["OBJECT_LIKE"] = "objectLike";
    /**
     * Matches the specified pattern with the array
     * The set of elements must be in the same order as would be found
     */
    AssertionType["ARRAY_WITH"] = "arrayWith";
})(AssertionType || (exports.AssertionType = AssertionType = {}));
/**
 * The status of the assertion
 */
var Status;
(function (Status) {
    /**
     * The assertion passed
     */
    Status["PASS"] = "pass";
    /**
     * The assertion failed
     */
    Status["FAIL"] = "fail";
})(Status || (exports.Status = Status = {}));
//# sourceMappingURL=data:application/json;base64,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