var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __esm = (fn, res) => function __init() {
  return fn && (res = (0, fn[__getOwnPropNames(fn)[0]])(fn = 0)), res;
};
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// ../../aws-cdk-lib/assertions/lib/matcher.ts
var matcher_exports = {};
__export(matcher_exports, {
  MatchResult: () => MatchResult,
  Matcher: () => Matcher
});
function* range(n) {
  for (let i = 0; i < n; i++) {
    yield i;
  }
}
function* enumFirst(xs) {
  let first = true;
  for (const x of xs) {
    yield [first, x];
    first = false;
  }
}
var Matcher, MatchResult;
var init_matcher = __esm({
  "../../aws-cdk-lib/assertions/lib/matcher.ts"() {
    "use strict";
    Matcher = class _Matcher {
      /**
       * Check whether the provided object is a subtype of the `IMatcher`.
       */
      static isMatcher(x) {
        return x && x instanceof _Matcher;
      }
    };
    MatchResult = class {
      constructor(target) {
        this.failuresHere = /* @__PURE__ */ new Map();
        this.captures = /* @__PURE__ */ new Map();
        this.finalized = false;
        this.innerMatchFailures = /* @__PURE__ */ new Map();
        this._hasFailed = false;
        this._failCount = 0;
        this._cost = 0;
        this.target = target;
      }
      /**
       * DEPRECATED
       * @deprecated use recordFailure()
       */
      push(matcher, path, message) {
        return this.recordFailure({ matcher, path, message });
      }
      /**
       * Record a new failure into this result at a specific path.
       */
      recordFailure(failure) {
        const failKey = failure.path.join(".");
        let list = this.failuresHere.get(failKey);
        if (!list) {
          list = [];
          this.failuresHere.set(failKey, list);
        }
        this._failCount += 1;
        this._cost += failure.cost ?? 1;
        list.push(failure);
        this._hasFailed = true;
        return this;
      }
      /** Whether the match is a success */
      get isSuccess() {
        return !this._hasFailed;
      }
      /** Does the result contain any failures. If not, the result is a success */
      hasFailed() {
        return this._hasFailed;
      }
      /** The number of failures */
      get failCount() {
        return this._failCount;
      }
      /** The cost of the failures so far */
      get failCost() {
        return this._cost;
      }
      /**
       * Compose the results of a previous match as a subtree.
       * @param id the id of the parent tree.
       */
      compose(id, inner) {
        if (inner.hasFailed()) {
          this._hasFailed = true;
          this._failCount += inner.failCount;
          this._cost += inner._cost;
          this.innerMatchFailures.set(id, inner);
        }
        inner.captures.forEach((vals, capture) => {
          vals.forEach((value) => this.recordCapture({ capture, value }));
        });
        return this;
      }
      /**
       * Prepare the result to be analyzed.
       * This API *must* be called prior to analyzing these results.
       */
      finished() {
        if (this.finalized) {
          return this;
        }
        if (this.failCount === 0) {
          this.captures.forEach((vals, cap) => cap._captured.push(...vals));
        }
        this.finalized = true;
        return this;
      }
      /**
       * Render the failed match in a presentable way
       *
       * Prefer using `renderMismatch` over this method. It is left for backwards
       * compatibility for test suites that expect it, but `renderMismatch()` will
       * produce better output.
       */
      toHumanStrings() {
        const failures = new Array();
        debugger;
        recurse(this, []);
        return failures.map((r) => {
          const loc = r.path.length === 0 ? "" : ` at /${r.path.join("/")}`;
          return "" + r.message + loc + ` (using ${r.matcher.name} matcher)`;
        });
        function recurse(x, prefix) {
          for (const fail of Array.from(x.failuresHere.values()).flat()) {
            failures.push({
              matcher: fail.matcher,
              message: fail.message,
              path: [...prefix, ...fail.path]
            });
          }
          for (const [key, inner] of x.innerMatchFailures.entries()) {
            recurse(inner, [...prefix, key]);
          }
        }
      }
      /**
       * Do a deep render of the match result, showing the structure mismatches in context
       */
      renderMismatch() {
        if (!this.hasFailed()) {
          return "<match>";
        }
        const parts = new Array();
        const indents = new Array();
        emitFailures(this, "");
        recurse(this);
        return moveMarkersToFront(parts.join("").trimEnd());
        function emit(x) {
          if (x === void 0) {
            debugger;
          }
          parts.push(x.replace(/\n/g, `
${indents.join("")}`));
        }
        function emitFailures(r, path, scrapSet) {
          for (const fail of r.failuresHere.get(path) ?? []) {
            emit(`!! ${fail.message}
`);
          }
          scrapSet?.delete(path);
        }
        function recurse(r) {
          const remainingFailures = new Set(Array.from(r.failuresHere.keys()).filter((x) => x !== ""));
          if (Array.isArray(r.target)) {
            indents.push("  ");
            emit("[\n");
            for (const [first, i] of enumFirst(range(r.target.length))) {
              if (!first) {
                emit(",\n");
              }
              emitFailures(r, `${i}`, remainingFailures);
              const innerMatcher = r.innerMatchFailures.get(`${i}`);
              if (innerMatcher) {
                emitFailures(innerMatcher, "");
                recurseComparingValues(innerMatcher, r.target[i]);
              } else {
                emit(renderAbridged(r.target[i]));
              }
            }
            emitRemaining();
            indents.pop();
            emit("\n]");
            return;
          }
          if (r.target && typeof r.target === "object") {
            indents.push("  ");
            emit("{\n");
            const keys = Array.from(/* @__PURE__ */ new Set([
              ...Object.keys(r.target),
              ...Array.from(remainingFailures)
            ])).sort();
            for (const [first, key] of enumFirst(keys)) {
              if (!first) {
                emit(",\n");
              }
              emitFailures(r, key, remainingFailures);
              const innerMatcher = r.innerMatchFailures.get(key);
              if (innerMatcher) {
                emitFailures(innerMatcher, "");
                emit(`${jsonify(key)}: `);
                recurseComparingValues(innerMatcher, r.target[key]);
              } else {
                emit(`${jsonify(key)}: `);
                emit(renderAbridged(r.target[key]));
              }
            }
            emitRemaining();
            indents.pop();
            emit("\n}");
            return;
          }
          emitRemaining();
          emit(jsonify(r.target));
          function emitRemaining() {
            if (remainingFailures.size > 0) {
              emit("\n");
            }
            for (const key of remainingFailures) {
              emitFailures(r, key);
            }
          }
        }
        function recurseComparingValues(inner, actualValue) {
          if (inner.target === actualValue) {
            return recurse(inner);
          }
          emit(renderAbridged(actualValue));
          emit(" <*> ");
          recurse(inner);
        }
        function renderAbridged(x) {
          if (Array.isArray(x)) {
            switch (x.length) {
              case 0:
                return "[]";
              case 1:
                return `[ ${renderAbridged(x[0])} ]`;
              case 2:
                if (x.every((e) => ["number", "boolean", "string"].includes(typeof e))) {
                  return `[ ${x.map(renderAbridged).join(", ")} ]`;
                }
                return "[ ... ]";
              default:
                return "[ ... ]";
            }
          }
          if (x && typeof x === "object") {
            const keys = Object.keys(x);
            switch (keys.length) {
              case 0:
                return "{}";
              case 1:
                return `{ ${JSON.stringify(keys[0])}: ${renderAbridged(x[keys[0]])} }`;
              default:
                return "{ ... }";
            }
          }
          return jsonify(x);
        }
        function jsonify(x) {
          return JSON.stringify(x) ?? "undefined";
        }
        function moveMarkersToFront(x) {
          const re = /^(\s+)!!/gm;
          return x.replace(re, (_, spaces) => `!!${spaces.substring(0, spaces.length - 2)}`);
        }
      }
      /**
       * Record a capture against in this match result.
       */
      recordCapture(options) {
        let values = this.captures.get(options.capture);
        if (values === void 0) {
          values = [];
        }
        values.push(options.value);
        this.captures.set(options.capture, values);
      }
    };
  }
});

// ../../aws-cdk-lib/assertions/lib/private/matchers/absent.ts
var AbsentMatch;
var init_absent = __esm({
  "../../aws-cdk-lib/assertions/lib/private/matchers/absent.ts"() {
    "use strict";
    init_matcher();
    AbsentMatch = class extends Matcher {
      constructor(name) {
        super();
        this.name = name;
      }
      test(actual) {
        const result = new MatchResult(actual);
        if (actual !== void 0) {
          result.recordFailure({
            matcher: this,
            path: [],
            message: `Received ${actual}, but key should be absent`
          });
        }
        return result;
      }
    };
  }
});

// ../../aws-cdk-lib/assertions/lib/private/sorting.ts
function sortKeyComparator(keyFn) {
  return (a, b) => {
    const ak = keyFn(a);
    const bk = keyFn(b);
    for (let i = 0; i < ak.length && i < bk.length; i++) {
      const av = ak[i];
      const bv = bk[i];
      let diff = 0;
      if (typeof av === "number" && typeof bv === "number") {
        diff = av - bv;
      } else if (typeof av === "string" && typeof bv === "string") {
        diff = av.localeCompare(bv);
      }
      if (diff !== 0) {
        return diff;
      }
    }
    return bk.length - ak.length;
  };
}
var init_sorting = __esm({
  "../../aws-cdk-lib/assertions/lib/private/sorting.ts"() {
    "use strict";
  }
});

// ../../aws-cdk-lib/assertions/lib/private/sparse-matrix.ts
var SparseMatrix;
var init_sparse_matrix = __esm({
  "../../aws-cdk-lib/assertions/lib/private/sparse-matrix.ts"() {
    "use strict";
    SparseMatrix = class {
      constructor() {
        this.matrix = /* @__PURE__ */ new Map();
      }
      get(row, col) {
        return this.matrix.get(row)?.get(col);
      }
      row(row) {
        return Array.from(this.matrix.get(row)?.entries() ?? []);
      }
      set(row, col, value) {
        let r = this.matrix.get(row);
        if (!r) {
          r = /* @__PURE__ */ new Map();
          this.matrix.set(row, r);
        }
        r.set(col, value);
      }
    };
  }
});

// ../../aws-cdk-lib/assertions/lib/private/type.ts
function getType(obj) {
  return Array.isArray(obj) ? "array" : typeof obj;
}
var init_type = __esm({
  "../../aws-cdk-lib/assertions/lib/private/type.ts"() {
    "use strict";
  }
});

// ../../aws-cdk-lib/assertions/lib/match.ts
var match_exports = {};
__export(match_exports, {
  Match: () => Match
});
var Match, LiteralMatch, ArrayMatch, ObjectMatch, SerializedJson, NotMatch, AnyMatch, StringLikeRegexpMatch;
var init_match = __esm({
  "../../aws-cdk-lib/assertions/lib/match.ts"() {
    "use strict";
    init_matcher();
    init_absent();
    init_sorting();
    init_sparse_matrix();
    init_type();
    Match = class {
      /**
       * Use this matcher in the place of a field's value, if the field must not be present.
       */
      static absent() {
        return new AbsentMatch("absent");
      }
      /**
       * Matches the specified pattern with the array found in the same relative path of the target.
       * The set of elements (or matchers) must be in the same order as would be found.
       * @param pattern the pattern to match
       */
      static arrayWith(pattern) {
        return new ArrayMatch("arrayWith", pattern);
      }
      /**
       * Matches the specified pattern with the array found in the same relative path of the target.
       * The set of elements (or matchers) must match exactly and in order.
       * @param pattern the pattern to match
       */
      static arrayEquals(pattern) {
        return new ArrayMatch("arrayEquals", pattern, { subsequence: false });
      }
      /**
       * Deep exact matching of the specified pattern to the target.
       * @param pattern the pattern to match
       */
      static exact(pattern) {
        return new LiteralMatch("exact", pattern, { partialObjects: false });
      }
      /**
       * Matches the specified pattern to an object found in the same relative path of the target.
       * The keys and their values (or matchers) must be present in the target but the target can be a superset.
       * @param pattern the pattern to match
       */
      static objectLike(pattern) {
        return new ObjectMatch("objectLike", pattern);
      }
      /**
       * Matches the specified pattern to an object found in the same relative path of the target.
       * The keys and their values (or matchers) must match exactly with the target.
       * @param pattern the pattern to match
       */
      static objectEquals(pattern) {
        return new ObjectMatch("objectEquals", pattern, { partial: false });
      }
      /**
       * Matches any target which does NOT follow the specified pattern.
       * @param pattern the pattern to NOT match
       */
      static not(pattern) {
        return new NotMatch("not", pattern);
      }
      /**
       * Matches any string-encoded JSON and applies the specified pattern after parsing it.
       * @param pattern the pattern to match after parsing the encoded JSON.
       */
      static serializedJson(pattern) {
        return new SerializedJson("serializedJson", pattern);
      }
      /**
       * Matches any non-null value at the target.
       */
      static anyValue() {
        return new AnyMatch("anyValue");
      }
      /**
       * Matches targets according to a regular expression
       */
      static stringLikeRegexp(pattern) {
        return new StringLikeRegexpMatch("stringLikeRegexp", pattern);
      }
    };
    LiteralMatch = class extends Matcher {
      constructor(name, pattern, options = {}) {
        super();
        this.name = name;
        this.pattern = pattern;
        this.partialObjects = options.partialObjects ?? false;
        if (Matcher.isMatcher(this.pattern)) {
          throw new Error("LiteralMatch cannot directly contain another matcher. Remove the top-level matcher or nest it more deeply.");
        }
      }
      test(actual) {
        if (Array.isArray(this.pattern)) {
          return new ArrayMatch(this.name, this.pattern, { subsequence: false, partialObjects: this.partialObjects }).test(actual);
        }
        if (typeof this.pattern === "object") {
          return new ObjectMatch(this.name, this.pattern, { partial: this.partialObjects }).test(actual);
        }
        const result = new MatchResult(actual);
        if (typeof this.pattern !== typeof actual) {
          result.recordFailure({
            matcher: this,
            path: [],
            message: `Expected type ${typeof this.pattern} but received ${getType(actual)}`
          });
          return result;
        }
        if (actual !== this.pattern) {
          result.recordFailure({
            matcher: this,
            path: [],
            message: `Expected ${this.pattern} but received ${actual}`
          });
        }
        return result;
      }
    };
    ArrayMatch = class extends Matcher {
      constructor(name, pattern, options = {}) {
        super();
        this.name = name;
        this.pattern = pattern;
        this.subsequence = options.subsequence ?? true;
        this.partialObjects = options.partialObjects ?? false;
      }
      test(actual) {
        if (!Array.isArray(actual)) {
          return new MatchResult(actual).recordFailure({
            matcher: this,
            path: [],
            message: `Expected type array but received ${getType(actual)}`
          });
        }
        return this.subsequence ? this.testSubsequence(actual) : this.testFullArray(actual);
      }
      testFullArray(actual) {
        const result = new MatchResult(actual);
        let i = 0;
        for (; i < this.pattern.length && i < actual.length; i++) {
          const patternElement = this.pattern[i];
          const matcher = Matcher.isMatcher(patternElement) ? patternElement : new LiteralMatch(this.name, patternElement, { partialObjects: this.partialObjects });
          const innerResult = matcher.test(actual[i]);
          result.compose(`${i}`, innerResult);
        }
        if (i < this.pattern.length) {
          result.recordFailure({
            matcher: this,
            message: `Not enough elements in array (expecting ${this.pattern.length}, got ${actual.length})`,
            path: [`${i}`]
          });
        }
        if (i < actual.length) {
          result.recordFailure({
            matcher: this,
            message: `Too many elements in array (expecting ${this.pattern.length}, got ${actual.length})`,
            path: [`${i}`]
          });
        }
        return result;
      }
      testSubsequence(actual) {
        const result = new MatchResult(actual);
        let patternIdx = 0;
        let actualIdx = 0;
        const matches = new SparseMatrix();
        while (patternIdx < this.pattern.length && actualIdx < actual.length) {
          const patternElement = this.pattern[patternIdx];
          const matcher = Matcher.isMatcher(patternElement) ? patternElement : new LiteralMatch(this.name, patternElement, { partialObjects: this.partialObjects });
          const matcherName = matcher.name;
          if (matcherName == "absent" || matcherName == "anyValue") {
            throw new Error(`The Matcher ${matcherName}() cannot be nested within arrayWith()`);
          }
          const innerResult = matcher.test(actual[actualIdx]);
          matches.set(patternIdx, actualIdx, innerResult);
          actualIdx++;
          if (innerResult.isSuccess) {
            result.compose(`${actualIdx}`, innerResult);
            patternIdx++;
          }
        }
        if (patternIdx < this.pattern.length) {
          for (let spi = 0; spi < patternIdx; spi++) {
            const foundMatch = matches.row(spi).find(([, r]) => r.isSuccess);
            if (!foundMatch) {
              continue;
            }
            const [index] = foundMatch;
            result.compose(`${index}`, new MatchResult(actual[index]).recordFailure({
              matcher: this,
              message: `arrayWith pattern ${spi} matched here`,
              path: [],
              cost: 0
              // This is an informational message so it would be unfair to assign it cost
            }));
          }
          const failedMatches = matches.row(patternIdx);
          failedMatches.sort(sortKeyComparator(([i, r]) => [r.failCost, i]));
          if (failedMatches.length > 0) {
            const [index, innerResult] = failedMatches[0];
            result.recordFailure({
              matcher: this,
              message: `Could not match arrayWith pattern ${patternIdx}. This is the closest match`,
              path: [`${index}`],
              cost: 0
              //  Informational message
            });
            result.compose(`${index}`, innerResult);
          } else {
            result.recordFailure({
              matcher: this,
              message: `Could not match arrayWith pattern ${patternIdx}. No more elements to try`,
              path: [`${actual.length}`]
            });
          }
        }
        return result;
      }
    };
    ObjectMatch = class extends Matcher {
      constructor(name, pattern, options = {}) {
        super();
        this.name = name;
        this.pattern = pattern;
        this.partial = options.partial ?? true;
      }
      test(actual) {
        if (typeof actual !== "object" || Array.isArray(actual)) {
          return new MatchResult(actual).recordFailure({
            matcher: this,
            path: [],
            message: `Expected type object but received ${getType(actual)}`
          });
        }
        const result = new MatchResult(actual);
        if (!this.partial) {
          for (const a of Object.keys(actual)) {
            if (!(a in this.pattern)) {
              result.recordFailure({
                matcher: this,
                path: [a],
                message: `Unexpected key ${a}`
              });
            }
          }
        }
        for (const [patternKey, patternVal] of Object.entries(this.pattern)) {
          if (!(patternKey in actual) && !(patternVal instanceof AbsentMatch)) {
            result.recordFailure({
              matcher: this,
              path: [patternKey],
              message: `Missing key '${patternKey}'`
            });
            continue;
          }
          const matcher = Matcher.isMatcher(patternVal) ? patternVal : new LiteralMatch(this.name, patternVal, { partialObjects: this.partial });
          const inner = matcher.test(actual[patternKey]);
          result.compose(patternKey, inner);
        }
        return result;
      }
    };
    SerializedJson = class extends Matcher {
      constructor(name, pattern) {
        super();
        this.name = name;
        this.pattern = pattern;
      }
      test(actual) {
        if (getType(actual) !== "string") {
          return new MatchResult(actual).recordFailure({
            matcher: this,
            path: [],
            message: `Expected JSON as a string but found ${getType(actual)}`
          });
        }
        let parsed;
        try {
          parsed = JSON.parse(actual);
        } catch (err) {
          if (err instanceof SyntaxError) {
            return new MatchResult(actual).recordFailure({
              matcher: this,
              path: [],
              message: `Invalid JSON string: ${actual}`
            });
          } else {
            throw err;
          }
        }
        const matcher = Matcher.isMatcher(this.pattern) ? this.pattern : new LiteralMatch(this.name, this.pattern);
        const innerResult = matcher.test(parsed);
        if (innerResult.hasFailed()) {
          innerResult.recordFailure({
            matcher: this,
            path: [],
            message: "Encoded JSON value does not match"
          });
        }
        return innerResult;
      }
    };
    NotMatch = class extends Matcher {
      constructor(name, pattern) {
        super();
        this.name = name;
        this.pattern = pattern;
      }
      test(actual) {
        const matcher = Matcher.isMatcher(this.pattern) ? this.pattern : new LiteralMatch(this.name, this.pattern);
        const innerResult = matcher.test(actual);
        const result = new MatchResult(actual);
        if (innerResult.failCount === 0) {
          result.recordFailure({
            matcher: this,
            path: [],
            message: `Found unexpected match: ${JSON.stringify(actual, void 0, 2)}`
          });
        }
        return result;
      }
    };
    AnyMatch = class extends Matcher {
      constructor(name) {
        super();
        this.name = name;
      }
      test(actual) {
        const result = new MatchResult(actual);
        if (actual == null) {
          result.recordFailure({
            matcher: this,
            path: [],
            message: "Expected a value but found none"
          });
        }
        return result;
      }
    };
    StringLikeRegexpMatch = class extends Matcher {
      constructor(name, pattern) {
        super();
        this.name = name;
        this.pattern = pattern;
      }
      test(actual) {
        const result = new MatchResult(actual);
        const regex = new RegExp(this.pattern, "gm");
        if (typeof actual !== "string") {
          result.recordFailure({
            matcher: this,
            path: [],
            message: `Expected a string, but got '${typeof actual}'`
          });
        }
        if (!regex.test(actual)) {
          result.recordFailure({
            matcher: this,
            path: [],
            message: `String '${actual}' did not match pattern '${this.pattern}'`
          });
        }
        return result;
      }
    };
  }
});

// ../../aws-cdk-lib/assertions/lib/helpers-internal/index.js
var require_helpers_internal = __commonJS({
  "../../aws-cdk-lib/assertions/lib/helpers-internal/index.js"(exports2) {
    "use strict";
    var __createBinding2 = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar2 = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p))
          __createBinding2(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    var _noFold;
    exports2.Match = void 0;
    Object.defineProperty(exports2, _noFold = "Match", { enumerable: true, configurable: true, get: () => (init_match(), __toCommonJS(match_exports)).Match });
    exports2.Matcher = void 0;
    Object.defineProperty(exports2, _noFold = "Matcher", { enumerable: true, configurable: true, get: () => (init_matcher(), __toCommonJS(matcher_exports)).Matcher });
    exports2.MatchResult = void 0;
    Object.defineProperty(exports2, _noFold = "MatchResult", { enumerable: true, configurable: true, get: () => (init_matcher(), __toCommonJS(matcher_exports)).MatchResult });
  }
});

// ../../../node_modules/tslib/tslib.es6.mjs
var tslib_es6_exports = {};
__export(tslib_es6_exports, {
  __addDisposableResource: () => __addDisposableResource,
  __assign: () => __assign,
  __asyncDelegator: () => __asyncDelegator,
  __asyncGenerator: () => __asyncGenerator,
  __asyncValues: () => __asyncValues,
  __await: () => __await,
  __awaiter: () => __awaiter,
  __classPrivateFieldGet: () => __classPrivateFieldGet,
  __classPrivateFieldIn: () => __classPrivateFieldIn,
  __classPrivateFieldSet: () => __classPrivateFieldSet,
  __createBinding: () => __createBinding,
  __decorate: () => __decorate,
  __disposeResources: () => __disposeResources,
  __esDecorate: () => __esDecorate,
  __exportStar: () => __exportStar,
  __extends: () => __extends,
  __generator: () => __generator,
  __importDefault: () => __importDefault,
  __importStar: () => __importStar,
  __makeTemplateObject: () => __makeTemplateObject,
  __metadata: () => __metadata,
  __param: () => __param,
  __propKey: () => __propKey,
  __read: () => __read,
  __rest: () => __rest,
  __runInitializers: () => __runInitializers,
  __setFunctionName: () => __setFunctionName,
  __spread: () => __spread,
  __spreadArray: () => __spreadArray,
  __spreadArrays: () => __spreadArrays,
  __values: () => __values,
  default: () => tslib_es6_default
});
function __extends(d, b) {
  if (typeof b !== "function" && b !== null)
    throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
  extendStatics(d, b);
  function __() {
    this.constructor = d;
  }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}
function __rest(s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
    t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function")
    for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
      if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
        t[p[i]] = s[p[i]];
    }
  return t;
}
function __decorate(decorators, target, key, desc) {
  var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
  if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
  else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
  return c > 3 && r && Object.defineProperty(target, key, r), r;
}
function __param(paramIndex, decorator) {
  return function(target, key) {
    decorator(target, key, paramIndex);
  };
}
function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
}
function __runInitializers(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
}
function __propKey(x) {
  return typeof x === "symbol" ? x : "".concat(x);
}
function __setFunctionName(f, name, prefix) {
  if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
  return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
}
function __metadata(metadataKey, metadataValue) {
  if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}
function __awaiter(thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function(resolve) {
      resolve(value);
    });
  }
  return new (P || (P = Promise))(function(resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }
    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }
    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }
    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
}
function __generator(thisArg, body) {
  var _ = { label: 0, sent: function() {
    if (t[0] & 1) throw t[1];
    return t[1];
  }, trys: [], ops: [] }, f, y, t, g;
  return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() {
    return this;
  }), g;
  function verb(n) {
    return function(v) {
      return step([n, v]);
    };
  }
  function step(op) {
    if (f) throw new TypeError("Generator is already executing.");
    while (g && (g = 0, op[0] && (_ = 0)), _) try {
      if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
      if (y = 0, t) op = [op[0] & 2, t.value];
      switch (op[0]) {
        case 0:
        case 1:
          t = op;
          break;
        case 4:
          _.label++;
          return { value: op[1], done: false };
        case 5:
          _.label++;
          y = op[1];
          op = [0];
          continue;
        case 7:
          op = _.ops.pop();
          _.trys.pop();
          continue;
        default:
          if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
            _ = 0;
            continue;
          }
          if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
            _.label = op[1];
            break;
          }
          if (op[0] === 6 && _.label < t[1]) {
            _.label = t[1];
            t = op;
            break;
          }
          if (t && _.label < t[2]) {
            _.label = t[2];
            _.ops.push(op);
            break;
          }
          if (t[2]) _.ops.pop();
          _.trys.pop();
          continue;
      }
      op = body.call(thisArg, _);
    } catch (e) {
      op = [6, e];
      y = 0;
    } finally {
      f = t = 0;
    }
    if (op[0] & 5) throw op[1];
    return { value: op[0] ? op[1] : void 0, done: true };
  }
}
function __exportStar(m, o) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}
function __values(o) {
  var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
  if (m) return m.call(o);
  if (o && typeof o.length === "number") return {
    next: function() {
      if (o && i >= o.length) o = void 0;
      return { value: o && o[i++], done: !o };
    }
  };
  throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}
function __read(o, n) {
  var m = typeof Symbol === "function" && o[Symbol.iterator];
  if (!m) return o;
  var i = m.call(o), r, ar = [], e;
  try {
    while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
  } catch (error) {
    e = { error };
  } finally {
    try {
      if (r && !r.done && (m = i["return"])) m.call(i);
    } finally {
      if (e) throw e.error;
    }
  }
  return ar;
}
function __spread() {
  for (var ar = [], i = 0; i < arguments.length; i++)
    ar = ar.concat(__read(arguments[i]));
  return ar;
}
function __spreadArrays() {
  for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
  for (var r = Array(s), k = 0, i = 0; i < il; i++)
    for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
      r[k] = a[j];
  return r;
}
function __spreadArray(to, from, pack) {
  if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
    if (ar || !(i in from)) {
      if (!ar) ar = Array.prototype.slice.call(from, 0, i);
      ar[i] = from[i];
    }
  }
  return to.concat(ar || Array.prototype.slice.call(from));
}
function __await(v) {
  return this instanceof __await ? (this.v = v, this) : new __await(v);
}
function __asyncGenerator(thisArg, _arguments, generator) {
  if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
  var g = generator.apply(thisArg, _arguments || []), i, q = [];
  return i = {}, verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function() {
    return this;
  }, i;
  function awaitReturn(f) {
    return function(v) {
      return Promise.resolve(v).then(f, reject);
    };
  }
  function verb(n, f) {
    if (g[n]) {
      i[n] = function(v) {
        return new Promise(function(a, b) {
          q.push([n, v, a, b]) > 1 || resume(n, v);
        });
      };
      if (f) i[n] = f(i[n]);
    }
  }
  function resume(n, v) {
    try {
      step(g[n](v));
    } catch (e) {
      settle(q[0][3], e);
    }
  }
  function step(r) {
    r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r);
  }
  function fulfill(value) {
    resume("next", value);
  }
  function reject(value) {
    resume("throw", value);
  }
  function settle(f, v) {
    if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]);
  }
}
function __asyncDelegator(o) {
  var i, p;
  return i = {}, verb("next"), verb("throw", function(e) {
    throw e;
  }), verb("return"), i[Symbol.iterator] = function() {
    return this;
  }, i;
  function verb(n, f) {
    i[n] = o[n] ? function(v) {
      return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v;
    } : f;
  }
}
function __asyncValues(o) {
  if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
  var m = o[Symbol.asyncIterator], i;
  return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function() {
    return this;
  }, i);
  function verb(n) {
    i[n] = o[n] && function(v) {
      return new Promise(function(resolve, reject) {
        v = o[n](v), settle(resolve, reject, v.done, v.value);
      });
    };
  }
  function settle(resolve, reject, d, v) {
    Promise.resolve(v).then(function(v2) {
      resolve({ value: v2, done: d });
    }, reject);
  }
}
function __makeTemplateObject(cooked, raw) {
  if (Object.defineProperty) {
    Object.defineProperty(cooked, "raw", { value: raw });
  } else {
    cooked.raw = raw;
  }
  return cooked;
}
function __importStar(mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) {
    for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  }
  __setModuleDefault(result, mod);
  return result;
}
function __importDefault(mod) {
  return mod && mod.__esModule ? mod : { default: mod };
}
function __classPrivateFieldGet(receiver, state, kind, f) {
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
  return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}
function __classPrivateFieldSet(receiver, state, value, kind, f) {
  if (kind === "m") throw new TypeError("Private method is not writable");
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
  return kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value), value;
}
function __classPrivateFieldIn(state, receiver) {
  if (receiver === null || typeof receiver !== "object" && typeof receiver !== "function") throw new TypeError("Cannot use 'in' operator on non-object");
  return typeof state === "function" ? receiver === state : state.has(receiver);
}
function __addDisposableResource(env, value, async) {
  if (value !== null && value !== void 0) {
    if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
    var dispose, inner;
    if (async) {
      if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
      dispose = value[Symbol.asyncDispose];
    }
    if (dispose === void 0) {
      if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
      dispose = value[Symbol.dispose];
      if (async) inner = dispose;
    }
    if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
    if (inner) dispose = function() {
      try {
        inner.call(this);
      } catch (e) {
        return Promise.reject(e);
      }
    };
    env.stack.push({ value, dispose, async });
  } else if (async) {
    env.stack.push({ async: true });
  }
  return value;
}
function __disposeResources(env) {
  function fail(e) {
    env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
    env.hasError = true;
  }
  function next() {
    while (env.stack.length) {
      var rec = env.stack.pop();
      try {
        var result = rec.dispose && rec.dispose.call(rec.value);
        if (rec.async) return Promise.resolve(result).then(next, function(e) {
          fail(e);
          return next();
        });
      } catch (e) {
        fail(e);
      }
    }
    if (env.hasError) throw env.error;
  }
  return next();
}
var extendStatics, __assign, __createBinding, __setModuleDefault, _SuppressedError, tslib_es6_default;
var init_tslib_es6 = __esm({
  "../../../node_modules/tslib/tslib.es6.mjs"() {
    extendStatics = function(d, b) {
      extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
        d2.__proto__ = b2;
      } || function(d2, b2) {
        for (var p in b2) if (Object.prototype.hasOwnProperty.call(b2, p)) d2[p] = b2[p];
      };
      return extendStatics(d, b);
    };
    __assign = function() {
      __assign = Object.assign || function __assign2(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
          s = arguments[i];
          for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
      };
      return __assign.apply(this, arguments);
    };
    __createBinding = Object.create ? function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    };
    __setModuleDefault = Object.create ? function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    } : function(o, v) {
      o["default"] = v;
    };
    _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function(error, suppressed, message) {
      var e = new Error(message);
      return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
    };
    tslib_es6_default = {
      __extends,
      __assign,
      __rest,
      __decorate,
      __param,
      __metadata,
      __awaiter,
      __generator,
      __createBinding,
      __exportStar,
      __values,
      __read,
      __spread,
      __spreadArrays,
      __spreadArray,
      __await,
      __asyncGenerator,
      __asyncDelegator,
      __asyncValues,
      __makeTemplateObject,
      __importStar,
      __importDefault,
      __classPrivateFieldGet,
      __classPrivateFieldSet,
      __classPrivateFieldIn,
      __addDisposableResource,
      __disposeResources
    };
  }
});

// ../../../node_modules/@smithy/types/dist-cjs/index.js
var require_dist_cjs = __commonJS({
  "../../../node_modules/@smithy/types/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      AlgorithmId: () => AlgorithmId,
      EndpointURLScheme: () => EndpointURLScheme,
      FieldPosition: () => FieldPosition,
      HttpApiKeyAuthLocation: () => HttpApiKeyAuthLocation,
      HttpAuthLocation: () => HttpAuthLocation,
      IniSectionType: () => IniSectionType,
      RequestHandlerProtocol: () => RequestHandlerProtocol,
      SMITHY_CONTEXT_KEY: () => SMITHY_CONTEXT_KEY,
      getDefaultClientConfiguration: () => getDefaultClientConfiguration,
      resolveDefaultRuntimeConfig: () => resolveDefaultRuntimeConfig
    });
    module2.exports = __toCommonJS2(src_exports);
    var HttpAuthLocation = /* @__PURE__ */ ((HttpAuthLocation2) => {
      HttpAuthLocation2["HEADER"] = "header";
      HttpAuthLocation2["QUERY"] = "query";
      return HttpAuthLocation2;
    })(HttpAuthLocation || {});
    var HttpApiKeyAuthLocation = /* @__PURE__ */ ((HttpApiKeyAuthLocation2) => {
      HttpApiKeyAuthLocation2["HEADER"] = "header";
      HttpApiKeyAuthLocation2["QUERY"] = "query";
      return HttpApiKeyAuthLocation2;
    })(HttpApiKeyAuthLocation || {});
    var EndpointURLScheme = /* @__PURE__ */ ((EndpointURLScheme2) => {
      EndpointURLScheme2["HTTP"] = "http";
      EndpointURLScheme2["HTTPS"] = "https";
      return EndpointURLScheme2;
    })(EndpointURLScheme || {});
    var AlgorithmId = /* @__PURE__ */ ((AlgorithmId2) => {
      AlgorithmId2["MD5"] = "md5";
      AlgorithmId2["CRC32"] = "crc32";
      AlgorithmId2["CRC32C"] = "crc32c";
      AlgorithmId2["SHA1"] = "sha1";
      AlgorithmId2["SHA256"] = "sha256";
      return AlgorithmId2;
    })(AlgorithmId || {});
    var getChecksumConfiguration = /* @__PURE__ */ __name((runtimeConfig) => {
      const checksumAlgorithms = [];
      if (runtimeConfig.sha256 !== void 0) {
        checksumAlgorithms.push({
          algorithmId: () => "sha256",
          checksumConstructor: () => runtimeConfig.sha256
        });
      }
      if (runtimeConfig.md5 != void 0) {
        checksumAlgorithms.push({
          algorithmId: () => "md5",
          checksumConstructor: () => runtimeConfig.md5
        });
      }
      return {
        _checksumAlgorithms: checksumAlgorithms,
        addChecksumAlgorithm(algo) {
          this._checksumAlgorithms.push(algo);
        },
        checksumAlgorithms() {
          return this._checksumAlgorithms;
        }
      };
    }, "getChecksumConfiguration");
    var resolveChecksumRuntimeConfig = /* @__PURE__ */ __name((clientConfig) => {
      const runtimeConfig = {};
      clientConfig.checksumAlgorithms().forEach((checksumAlgorithm) => {
        runtimeConfig[checksumAlgorithm.algorithmId()] = checksumAlgorithm.checksumConstructor();
      });
      return runtimeConfig;
    }, "resolveChecksumRuntimeConfig");
    var getDefaultClientConfiguration = /* @__PURE__ */ __name((runtimeConfig) => {
      return {
        ...getChecksumConfiguration(runtimeConfig)
      };
    }, "getDefaultClientConfiguration");
    var resolveDefaultRuntimeConfig = /* @__PURE__ */ __name((config) => {
      return {
        ...resolveChecksumRuntimeConfig(config)
      };
    }, "resolveDefaultRuntimeConfig");
    var FieldPosition = /* @__PURE__ */ ((FieldPosition2) => {
      FieldPosition2[FieldPosition2["HEADER"] = 0] = "HEADER";
      FieldPosition2[FieldPosition2["TRAILER"] = 1] = "TRAILER";
      return FieldPosition2;
    })(FieldPosition || {});
    var SMITHY_CONTEXT_KEY = "__smithy_context";
    var IniSectionType = /* @__PURE__ */ ((IniSectionType2) => {
      IniSectionType2["PROFILE"] = "profile";
      IniSectionType2["SSO_SESSION"] = "sso-session";
      IniSectionType2["SERVICES"] = "services";
      return IniSectionType2;
    })(IniSectionType || {});
    var RequestHandlerProtocol = /* @__PURE__ */ ((RequestHandlerProtocol2) => {
      RequestHandlerProtocol2["HTTP_0_9"] = "http/0.9";
      RequestHandlerProtocol2["HTTP_1_0"] = "http/1.0";
      RequestHandlerProtocol2["TDS_8_0"] = "tds/8.0";
      return RequestHandlerProtocol2;
    })(RequestHandlerProtocol || {});
  }
});

// ../../../node_modules/@smithy/protocol-http/dist-cjs/index.js
var require_dist_cjs2 = __commonJS({
  "../../../node_modules/@smithy/protocol-http/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      Field: () => Field,
      Fields: () => Fields,
      HttpRequest: () => HttpRequest,
      HttpResponse: () => HttpResponse,
      getHttpHandlerExtensionConfiguration: () => getHttpHandlerExtensionConfiguration,
      isValidHostname: () => isValidHostname,
      resolveHttpHandlerRuntimeConfig: () => resolveHttpHandlerRuntimeConfig
    });
    module2.exports = __toCommonJS2(src_exports);
    var getHttpHandlerExtensionConfiguration = /* @__PURE__ */ __name((runtimeConfig) => {
      let httpHandler = runtimeConfig.httpHandler;
      return {
        setHttpHandler(handler2) {
          httpHandler = handler2;
        },
        httpHandler() {
          return httpHandler;
        },
        updateHttpClientConfig(key, value) {
          httpHandler.updateHttpClientConfig(key, value);
        },
        httpHandlerConfigs() {
          return httpHandler.httpHandlerConfigs();
        }
      };
    }, "getHttpHandlerExtensionConfiguration");
    var resolveHttpHandlerRuntimeConfig = /* @__PURE__ */ __name((httpHandlerExtensionConfiguration) => {
      return {
        httpHandler: httpHandlerExtensionConfiguration.httpHandler()
      };
    }, "resolveHttpHandlerRuntimeConfig");
    var import_types = require_dist_cjs();
    var _Field = class _Field {
      constructor({ name, kind = import_types.FieldPosition.HEADER, values = [] }) {
        this.name = name;
        this.kind = kind;
        this.values = values;
      }
      /**
       * Appends a value to the field.
       *
       * @param value The value to append.
       */
      add(value) {
        this.values.push(value);
      }
      /**
       * Overwrite existing field values.
       *
       * @param values The new field values.
       */
      set(values) {
        this.values = values;
      }
      /**
       * Remove all matching entries from list.
       *
       * @param value Value to remove.
       */
      remove(value) {
        this.values = this.values.filter((v) => v !== value);
      }
      /**
       * Get comma-delimited string.
       *
       * @returns String representation of {@link Field}.
       */
      toString() {
        return this.values.map((v) => v.includes(",") || v.includes(" ") ? `"${v}"` : v).join(", ");
      }
      /**
       * Get string values as a list
       *
       * @returns Values in {@link Field} as a list.
       */
      get() {
        return this.values;
      }
    };
    __name(_Field, "Field");
    var Field = _Field;
    var _Fields = class _Fields {
      constructor({ fields = [], encoding = "utf-8" }) {
        this.entries = {};
        fields.forEach(this.setField.bind(this));
        this.encoding = encoding;
      }
      /**
       * Set entry for a {@link Field} name. The `name`
       * attribute will be used to key the collection.
       *
       * @param field The {@link Field} to set.
       */
      setField(field) {
        this.entries[field.name.toLowerCase()] = field;
      }
      /**
       *  Retrieve {@link Field} entry by name.
       *
       * @param name The name of the {@link Field} entry
       *  to retrieve
       * @returns The {@link Field} if it exists.
       */
      getField(name) {
        return this.entries[name.toLowerCase()];
      }
      /**
       * Delete entry from collection.
       *
       * @param name Name of the entry to delete.
       */
      removeField(name) {
        delete this.entries[name.toLowerCase()];
      }
      /**
       * Helper function for retrieving specific types of fields.
       * Used to grab all headers or all trailers.
       *
       * @param kind {@link FieldPosition} of entries to retrieve.
       * @returns The {@link Field} entries with the specified
       *  {@link FieldPosition}.
       */
      getByType(kind) {
        return Object.values(this.entries).filter((field) => field.kind === kind);
      }
    };
    __name(_Fields, "Fields");
    var Fields = _Fields;
    var _HttpRequest = class _HttpRequest2 {
      constructor(options) {
        this.method = options.method || "GET";
        this.hostname = options.hostname || "localhost";
        this.port = options.port;
        this.query = options.query || {};
        this.headers = options.headers || {};
        this.body = options.body;
        this.protocol = options.protocol ? options.protocol.slice(-1) !== ":" ? `${options.protocol}:` : options.protocol : "https:";
        this.path = options.path ? options.path.charAt(0) !== "/" ? `/${options.path}` : options.path : "/";
        this.username = options.username;
        this.password = options.password;
        this.fragment = options.fragment;
      }
      static isInstance(request2) {
        if (!request2)
          return false;
        const req = request2;
        return "method" in req && "protocol" in req && "hostname" in req && "path" in req && typeof req["query"] === "object" && typeof req["headers"] === "object";
      }
      clone() {
        const cloned = new _HttpRequest2({
          ...this,
          headers: { ...this.headers }
        });
        if (cloned.query)
          cloned.query = cloneQuery(cloned.query);
        return cloned;
      }
    };
    __name(_HttpRequest, "HttpRequest");
    var HttpRequest = _HttpRequest;
    function cloneQuery(query) {
      return Object.keys(query).reduce((carry, paramName) => {
        const param = query[paramName];
        return {
          ...carry,
          [paramName]: Array.isArray(param) ? [...param] : param
        };
      }, {});
    }
    __name(cloneQuery, "cloneQuery");
    var _HttpResponse = class _HttpResponse {
      constructor(options) {
        this.statusCode = options.statusCode;
        this.reason = options.reason;
        this.headers = options.headers || {};
        this.body = options.body;
      }
      static isInstance(response) {
        if (!response)
          return false;
        const resp = response;
        return typeof resp.statusCode === "number" && typeof resp.headers === "object";
      }
    };
    __name(_HttpResponse, "HttpResponse");
    var HttpResponse = _HttpResponse;
    function isValidHostname(hostname) {
      const hostPattern = /^[a-z0-9][a-z0-9\.\-]*[a-z0-9]$/;
      return hostPattern.test(hostname);
    }
    __name(isValidHostname, "isValidHostname");
  }
});

// ../../../node_modules/@aws-sdk/middleware-host-header/dist-cjs/index.js
var require_dist_cjs3 = __commonJS({
  "../../../node_modules/@aws-sdk/middleware-host-header/dist-cjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getHostHeaderPlugin = exports2.hostHeaderMiddlewareOptions = exports2.hostHeaderMiddleware = exports2.resolveHostHeaderConfig = void 0;
    var protocol_http_1 = require_dist_cjs2();
    function resolveHostHeaderConfig(input) {
      return input;
    }
    exports2.resolveHostHeaderConfig = resolveHostHeaderConfig;
    var hostHeaderMiddleware = (options) => (next) => async (args) => {
      if (!protocol_http_1.HttpRequest.isInstance(args.request))
        return next(args);
      const { request: request2 } = args;
      const { handlerProtocol = "" } = options.requestHandler.metadata || {};
      if (handlerProtocol.indexOf("h2") >= 0 && !request2.headers[":authority"]) {
        delete request2.headers["host"];
        request2.headers[":authority"] = "";
      } else if (!request2.headers["host"]) {
        let host = request2.hostname;
        if (request2.port != null)
          host += `:${request2.port}`;
        request2.headers["host"] = host;
      }
      return next(args);
    };
    exports2.hostHeaderMiddleware = hostHeaderMiddleware;
    exports2.hostHeaderMiddlewareOptions = {
      name: "hostHeaderMiddleware",
      step: "build",
      priority: "low",
      tags: ["HOST"],
      override: true
    };
    var getHostHeaderPlugin = (options) => ({
      applyToStack: (clientStack) => {
        clientStack.add((0, exports2.hostHeaderMiddleware)(options), exports2.hostHeaderMiddlewareOptions);
      }
    });
    exports2.getHostHeaderPlugin = getHostHeaderPlugin;
  }
});

// ../../../node_modules/@aws-sdk/middleware-logger/dist-cjs/loggerMiddleware.js
var require_loggerMiddleware = __commonJS({
  "../../../node_modules/@aws-sdk/middleware-logger/dist-cjs/loggerMiddleware.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getLoggerPlugin = exports2.loggerMiddlewareOptions = exports2.loggerMiddleware = void 0;
    var loggerMiddleware = () => (next, context) => async (args) => {
      var _a, _b;
      try {
        const response = await next(args);
        const { clientName, commandName, logger, dynamoDbDocumentClientOptions = {} } = context;
        const { overrideInputFilterSensitiveLog, overrideOutputFilterSensitiveLog } = dynamoDbDocumentClientOptions;
        const inputFilterSensitiveLog = overrideInputFilterSensitiveLog !== null && overrideInputFilterSensitiveLog !== void 0 ? overrideInputFilterSensitiveLog : context.inputFilterSensitiveLog;
        const outputFilterSensitiveLog = overrideOutputFilterSensitiveLog !== null && overrideOutputFilterSensitiveLog !== void 0 ? overrideOutputFilterSensitiveLog : context.outputFilterSensitiveLog;
        const { $metadata, ...outputWithoutMetadata } = response.output;
        (_a = logger === null || logger === void 0 ? void 0 : logger.info) === null || _a === void 0 ? void 0 : _a.call(logger, {
          clientName,
          commandName,
          input: inputFilterSensitiveLog(args.input),
          output: outputFilterSensitiveLog(outputWithoutMetadata),
          metadata: $metadata
        });
        return response;
      } catch (error) {
        const { clientName, commandName, logger, dynamoDbDocumentClientOptions = {} } = context;
        const { overrideInputFilterSensitiveLog } = dynamoDbDocumentClientOptions;
        const inputFilterSensitiveLog = overrideInputFilterSensitiveLog !== null && overrideInputFilterSensitiveLog !== void 0 ? overrideInputFilterSensitiveLog : context.inputFilterSensitiveLog;
        (_b = logger === null || logger === void 0 ? void 0 : logger.error) === null || _b === void 0 ? void 0 : _b.call(logger, {
          clientName,
          commandName,
          input: inputFilterSensitiveLog(args.input),
          error,
          metadata: error.$metadata
        });
        throw error;
      }
    };
    exports2.loggerMiddleware = loggerMiddleware;
    exports2.loggerMiddlewareOptions = {
      name: "loggerMiddleware",
      tags: ["LOGGER"],
      step: "initialize",
      override: true
    };
    var getLoggerPlugin = (options) => ({
      applyToStack: (clientStack) => {
        clientStack.add((0, exports2.loggerMiddleware)(), exports2.loggerMiddlewareOptions);
      }
    });
    exports2.getLoggerPlugin = getLoggerPlugin;
  }
});

// ../../../node_modules/@aws-sdk/middleware-logger/dist-cjs/index.js
var require_dist_cjs4 = __commonJS({
  "../../../node_modules/@aws-sdk/middleware-logger/dist-cjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_loggerMiddleware(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/middleware-recursion-detection/dist-cjs/index.js
var require_dist_cjs5 = __commonJS({
  "../../../node_modules/@aws-sdk/middleware-recursion-detection/dist-cjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getRecursionDetectionPlugin = exports2.addRecursionDetectionMiddlewareOptions = exports2.recursionDetectionMiddleware = void 0;
    var protocol_http_1 = require_dist_cjs2();
    var TRACE_ID_HEADER_NAME = "X-Amzn-Trace-Id";
    var ENV_LAMBDA_FUNCTION_NAME = "AWS_LAMBDA_FUNCTION_NAME";
    var ENV_TRACE_ID = "_X_AMZN_TRACE_ID";
    var recursionDetectionMiddleware = (options) => (next) => async (args) => {
      const { request: request2 } = args;
      if (!protocol_http_1.HttpRequest.isInstance(request2) || options.runtime !== "node" || request2.headers.hasOwnProperty(TRACE_ID_HEADER_NAME)) {
        return next(args);
      }
      const functionName = process.env[ENV_LAMBDA_FUNCTION_NAME];
      const traceId = process.env[ENV_TRACE_ID];
      const nonEmptyString = (str) => typeof str === "string" && str.length > 0;
      if (nonEmptyString(functionName) && nonEmptyString(traceId)) {
        request2.headers[TRACE_ID_HEADER_NAME] = traceId;
      }
      return next({
        ...args,
        request: request2
      });
    };
    exports2.recursionDetectionMiddleware = recursionDetectionMiddleware;
    exports2.addRecursionDetectionMiddlewareOptions = {
      step: "build",
      tags: ["RECURSION_DETECTION"],
      name: "recursionDetectionMiddleware",
      override: true,
      priority: "low"
    };
    var getRecursionDetectionPlugin = (options) => ({
      applyToStack: (clientStack) => {
        clientStack.add((0, exports2.recursionDetectionMiddleware)(options), exports2.addRecursionDetectionMiddlewareOptions);
      }
    });
    exports2.getRecursionDetectionPlugin = getRecursionDetectionPlugin;
  }
});

// ../../../node_modules/@smithy/property-provider/dist-cjs/index.js
var require_dist_cjs6 = __commonJS({
  "../../../node_modules/@smithy/property-provider/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      CredentialsProviderError: () => CredentialsProviderError,
      ProviderError: () => ProviderError,
      TokenProviderError: () => TokenProviderError,
      chain: () => chain,
      fromStatic: () => fromStatic,
      memoize: () => memoize
    });
    module2.exports = __toCommonJS2(src_exports);
    var _ProviderError = class _ProviderError2 extends Error {
      constructor(message, tryNextLink = true) {
        super(message);
        this.tryNextLink = tryNextLink;
        this.name = "ProviderError";
        Object.setPrototypeOf(this, _ProviderError2.prototype);
      }
      static from(error, tryNextLink = true) {
        return Object.assign(new this(error.message, tryNextLink), error);
      }
    };
    __name(_ProviderError, "ProviderError");
    var ProviderError = _ProviderError;
    var _CredentialsProviderError = class _CredentialsProviderError2 extends ProviderError {
      constructor(message, tryNextLink = true) {
        super(message, tryNextLink);
        this.tryNextLink = tryNextLink;
        this.name = "CredentialsProviderError";
        Object.setPrototypeOf(this, _CredentialsProviderError2.prototype);
      }
    };
    __name(_CredentialsProviderError, "CredentialsProviderError");
    var CredentialsProviderError = _CredentialsProviderError;
    var _TokenProviderError = class _TokenProviderError2 extends ProviderError {
      constructor(message, tryNextLink = true) {
        super(message, tryNextLink);
        this.tryNextLink = tryNextLink;
        this.name = "TokenProviderError";
        Object.setPrototypeOf(this, _TokenProviderError2.prototype);
      }
    };
    __name(_TokenProviderError, "TokenProviderError");
    var TokenProviderError = _TokenProviderError;
    var chain = /* @__PURE__ */ __name((...providers) => async () => {
      if (providers.length === 0) {
        throw new ProviderError("No providers in chain");
      }
      let lastProviderError;
      for (const provider of providers) {
        try {
          const credentials = await provider();
          return credentials;
        } catch (err) {
          lastProviderError = err;
          if (err == null ? void 0 : err.tryNextLink) {
            continue;
          }
          throw err;
        }
      }
      throw lastProviderError;
    }, "chain");
    var fromStatic = /* @__PURE__ */ __name((staticValue) => () => Promise.resolve(staticValue), "fromStatic");
    var memoize = /* @__PURE__ */ __name((provider, isExpired, requiresRefresh) => {
      let resolved;
      let pending;
      let hasResult;
      let isConstant = false;
      const coalesceProvider = /* @__PURE__ */ __name(async () => {
        if (!pending) {
          pending = provider();
        }
        try {
          resolved = await pending;
          hasResult = true;
          isConstant = false;
        } finally {
          pending = void 0;
        }
        return resolved;
      }, "coalesceProvider");
      if (isExpired === void 0) {
        return async (options) => {
          if (!hasResult || (options == null ? void 0 : options.forceRefresh)) {
            resolved = await coalesceProvider();
          }
          return resolved;
        };
      }
      return async (options) => {
        if (!hasResult || (options == null ? void 0 : options.forceRefresh)) {
          resolved = await coalesceProvider();
        }
        if (isConstant) {
          return resolved;
        }
        if (requiresRefresh && !requiresRefresh(resolved)) {
          isConstant = true;
          return resolved;
        }
        if (isExpired(resolved)) {
          await coalesceProvider();
          return resolved;
        }
        return resolved;
      };
    }, "memoize");
  }
});

// ../../../node_modules/@smithy/util-middleware/dist-cjs/index.js
var require_dist_cjs7 = __commonJS({
  "../../../node_modules/@smithy/util-middleware/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      getSmithyContext: () => getSmithyContext,
      normalizeProvider: () => normalizeProvider
    });
    module2.exports = __toCommonJS2(src_exports);
    var import_types = require_dist_cjs();
    var getSmithyContext = /* @__PURE__ */ __name((context) => context[import_types.SMITHY_CONTEXT_KEY] || (context[import_types.SMITHY_CONTEXT_KEY] = {}), "getSmithyContext");
    var normalizeProvider = /* @__PURE__ */ __name((input) => {
      if (typeof input === "function")
        return input;
      const promisified = Promise.resolve(input);
      return () => promisified;
    }, "normalizeProvider");
  }
});

// ../../../node_modules/@smithy/is-array-buffer/dist-cjs/index.js
var require_dist_cjs8 = __commonJS({
  "../../../node_modules/@smithy/is-array-buffer/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      isArrayBuffer: () => isArrayBuffer
    });
    module2.exports = __toCommonJS2(src_exports);
    var isArrayBuffer = /* @__PURE__ */ __name((arg) => typeof ArrayBuffer === "function" && arg instanceof ArrayBuffer || Object.prototype.toString.call(arg) === "[object ArrayBuffer]", "isArrayBuffer");
  }
});

// ../../../node_modules/@smithy/util-buffer-from/dist-cjs/index.js
var require_dist_cjs9 = __commonJS({
  "../../../node_modules/@smithy/util-buffer-from/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      fromArrayBuffer: () => fromArrayBuffer,
      fromString: () => fromString
    });
    module2.exports = __toCommonJS2(src_exports);
    var import_is_array_buffer = require_dist_cjs8();
    var import_buffer = require("buffer");
    var fromArrayBuffer = /* @__PURE__ */ __name((input, offset = 0, length = input.byteLength - offset) => {
      if (!(0, import_is_array_buffer.isArrayBuffer)(input)) {
        throw new TypeError(`The "input" argument must be ArrayBuffer. Received type ${typeof input} (${input})`);
      }
      return import_buffer.Buffer.from(input, offset, length);
    }, "fromArrayBuffer");
    var fromString = /* @__PURE__ */ __name((input, encoding) => {
      if (typeof input !== "string") {
        throw new TypeError(`The "input" argument must be of type string. Received type ${typeof input} (${input})`);
      }
      return encoding ? import_buffer.Buffer.from(input, encoding) : import_buffer.Buffer.from(input);
    }, "fromString");
  }
});

// ../../../node_modules/@smithy/util-utf8/dist-cjs/index.js
var require_dist_cjs10 = __commonJS({
  "../../../node_modules/@smithy/util-utf8/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      fromUtf8: () => fromUtf8,
      toUint8Array: () => toUint8Array,
      toUtf8: () => toUtf8
    });
    module2.exports = __toCommonJS2(src_exports);
    var import_util_buffer_from = require_dist_cjs9();
    var fromUtf8 = /* @__PURE__ */ __name((input) => {
      const buf = (0, import_util_buffer_from.fromString)(input, "utf8");
      return new Uint8Array(buf.buffer, buf.byteOffset, buf.byteLength / Uint8Array.BYTES_PER_ELEMENT);
    }, "fromUtf8");
    var toUint8Array = /* @__PURE__ */ __name((data) => {
      if (typeof data === "string") {
        return fromUtf8(data);
      }
      if (ArrayBuffer.isView(data)) {
        return new Uint8Array(data.buffer, data.byteOffset, data.byteLength / Uint8Array.BYTES_PER_ELEMENT);
      }
      return new Uint8Array(data);
    }, "toUint8Array");
    var toUtf8 = /* @__PURE__ */ __name((input) => {
      if (typeof input === "string") {
        return input;
      }
      if (typeof input !== "object" || typeof input.byteOffset !== "number" || typeof input.byteLength !== "number") {
        throw new Error("@smithy/util-utf8: toUtf8 encoder function only accepts string | Uint8Array.");
      }
      return (0, import_util_buffer_from.fromArrayBuffer)(input.buffer, input.byteOffset, input.byteLength).toString("utf8");
    }, "toUtf8");
  }
});

// ../../../node_modules/@smithy/util-hex-encoding/dist-cjs/index.js
var require_dist_cjs11 = __commonJS({
  "../../../node_modules/@smithy/util-hex-encoding/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      fromHex: () => fromHex,
      toHex: () => toHex
    });
    module2.exports = __toCommonJS2(src_exports);
    var SHORT_TO_HEX = {};
    var HEX_TO_SHORT = {};
    for (let i = 0; i < 256; i++) {
      let encodedByte = i.toString(16).toLowerCase();
      if (encodedByte.length === 1) {
        encodedByte = `0${encodedByte}`;
      }
      SHORT_TO_HEX[i] = encodedByte;
      HEX_TO_SHORT[encodedByte] = i;
    }
    function fromHex(encoded) {
      if (encoded.length % 2 !== 0) {
        throw new Error("Hex encoded strings must have an even number length");
      }
      const out = new Uint8Array(encoded.length / 2);
      for (let i = 0; i < encoded.length; i += 2) {
        const encodedByte = encoded.slice(i, i + 2).toLowerCase();
        if (encodedByte in HEX_TO_SHORT) {
          out[i / 2] = HEX_TO_SHORT[encodedByte];
        } else {
          throw new Error(`Cannot decode unrecognized sequence ${encodedByte} as hexadecimal`);
        }
      }
      return out;
    }
    __name(fromHex, "fromHex");
    function toHex(bytes) {
      let out = "";
      for (let i = 0; i < bytes.byteLength; i++) {
        out += SHORT_TO_HEX[bytes[i]];
      }
      return out;
    }
    __name(toHex, "toHex");
  }
});

// ../../../node_modules/@smithy/util-uri-escape/dist-cjs/index.js
var require_dist_cjs12 = __commonJS({
  "../../../node_modules/@smithy/util-uri-escape/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      escapeUri: () => escapeUri,
      escapeUriPath: () => escapeUriPath
    });
    module2.exports = __toCommonJS2(src_exports);
    var escapeUri = /* @__PURE__ */ __name((uri) => (
      // AWS percent-encodes some extra non-standard characters in a URI
      encodeURIComponent(uri).replace(/[!'()*]/g, hexEncode)
    ), "escapeUri");
    var hexEncode = /* @__PURE__ */ __name((c) => `%${c.charCodeAt(0).toString(16).toUpperCase()}`, "hexEncode");
    var escapeUriPath = /* @__PURE__ */ __name((uri) => uri.split("/").map(escapeUri).join("/"), "escapeUriPath");
  }
});

// ../../../node_modules/@smithy/signature-v4/dist-cjs/index.js
var require_dist_cjs13 = __commonJS({
  "../../../node_modules/@smithy/signature-v4/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      SignatureV4: () => SignatureV4,
      clearCredentialCache: () => clearCredentialCache,
      createScope: () => createScope,
      getCanonicalHeaders: () => getCanonicalHeaders,
      getCanonicalQuery: () => getCanonicalQuery,
      getPayloadHash: () => getPayloadHash,
      getSigningKey: () => getSigningKey,
      moveHeadersToQuery: () => moveHeadersToQuery,
      prepareRequest: () => prepareRequest
    });
    module2.exports = __toCommonJS2(src_exports);
    var import_util_middleware = require_dist_cjs7();
    var import_util_utf84 = require_dist_cjs10();
    var ALGORITHM_QUERY_PARAM = "X-Amz-Algorithm";
    var CREDENTIAL_QUERY_PARAM = "X-Amz-Credential";
    var AMZ_DATE_QUERY_PARAM = "X-Amz-Date";
    var SIGNED_HEADERS_QUERY_PARAM = "X-Amz-SignedHeaders";
    var EXPIRES_QUERY_PARAM = "X-Amz-Expires";
    var SIGNATURE_QUERY_PARAM = "X-Amz-Signature";
    var TOKEN_QUERY_PARAM = "X-Amz-Security-Token";
    var AUTH_HEADER = "authorization";
    var AMZ_DATE_HEADER = AMZ_DATE_QUERY_PARAM.toLowerCase();
    var DATE_HEADER = "date";
    var GENERATED_HEADERS = [AUTH_HEADER, AMZ_DATE_HEADER, DATE_HEADER];
    var SIGNATURE_HEADER = SIGNATURE_QUERY_PARAM.toLowerCase();
    var SHA256_HEADER = "x-amz-content-sha256";
    var TOKEN_HEADER = TOKEN_QUERY_PARAM.toLowerCase();
    var ALWAYS_UNSIGNABLE_HEADERS = {
      authorization: true,
      "cache-control": true,
      connection: true,
      expect: true,
      from: true,
      "keep-alive": true,
      "max-forwards": true,
      pragma: true,
      referer: true,
      te: true,
      trailer: true,
      "transfer-encoding": true,
      upgrade: true,
      "user-agent": true,
      "x-amzn-trace-id": true
    };
    var PROXY_HEADER_PATTERN = /^proxy-/;
    var SEC_HEADER_PATTERN = /^sec-/;
    var ALGORITHM_IDENTIFIER = "AWS4-HMAC-SHA256";
    var EVENT_ALGORITHM_IDENTIFIER = "AWS4-HMAC-SHA256-PAYLOAD";
    var UNSIGNED_PAYLOAD = "UNSIGNED-PAYLOAD";
    var MAX_CACHE_SIZE = 50;
    var KEY_TYPE_IDENTIFIER = "aws4_request";
    var MAX_PRESIGNED_TTL = 60 * 60 * 24 * 7;
    var import_util_hex_encoding = require_dist_cjs11();
    var import_util_utf8 = require_dist_cjs10();
    var signingKeyCache = {};
    var cacheQueue = [];
    var createScope = /* @__PURE__ */ __name((shortDate, region, service) => `${shortDate}/${region}/${service}/${KEY_TYPE_IDENTIFIER}`, "createScope");
    var getSigningKey = /* @__PURE__ */ __name(async (sha256Constructor, credentials, shortDate, region, service) => {
      const credsHash = await hmac(sha256Constructor, credentials.secretAccessKey, credentials.accessKeyId);
      const cacheKey = `${shortDate}:${region}:${service}:${(0, import_util_hex_encoding.toHex)(credsHash)}:${credentials.sessionToken}`;
      if (cacheKey in signingKeyCache) {
        return signingKeyCache[cacheKey];
      }
      cacheQueue.push(cacheKey);
      while (cacheQueue.length > MAX_CACHE_SIZE) {
        delete signingKeyCache[cacheQueue.shift()];
      }
      let key = `AWS4${credentials.secretAccessKey}`;
      for (const signable of [shortDate, region, service, KEY_TYPE_IDENTIFIER]) {
        key = await hmac(sha256Constructor, key, signable);
      }
      return signingKeyCache[cacheKey] = key;
    }, "getSigningKey");
    var clearCredentialCache = /* @__PURE__ */ __name(() => {
      cacheQueue.length = 0;
      Object.keys(signingKeyCache).forEach((cacheKey) => {
        delete signingKeyCache[cacheKey];
      });
    }, "clearCredentialCache");
    var hmac = /* @__PURE__ */ __name((ctor, secret, data) => {
      const hash = new ctor(secret);
      hash.update((0, import_util_utf8.toUint8Array)(data));
      return hash.digest();
    }, "hmac");
    var getCanonicalHeaders = /* @__PURE__ */ __name(({ headers }, unsignableHeaders, signableHeaders) => {
      const canonical = {};
      for (const headerName of Object.keys(headers).sort()) {
        if (headers[headerName] == void 0) {
          continue;
        }
        const canonicalHeaderName = headerName.toLowerCase();
        if (canonicalHeaderName in ALWAYS_UNSIGNABLE_HEADERS || (unsignableHeaders == null ? void 0 : unsignableHeaders.has(canonicalHeaderName)) || PROXY_HEADER_PATTERN.test(canonicalHeaderName) || SEC_HEADER_PATTERN.test(canonicalHeaderName)) {
          if (!signableHeaders || signableHeaders && !signableHeaders.has(canonicalHeaderName)) {
            continue;
          }
        }
        canonical[canonicalHeaderName] = headers[headerName].trim().replace(/\s+/g, " ");
      }
      return canonical;
    }, "getCanonicalHeaders");
    var import_util_uri_escape = require_dist_cjs12();
    var getCanonicalQuery = /* @__PURE__ */ __name(({ query = {} }) => {
      const keys = [];
      const serialized = {};
      for (const key of Object.keys(query).sort()) {
        if (key.toLowerCase() === SIGNATURE_HEADER) {
          continue;
        }
        keys.push(key);
        const value = query[key];
        if (typeof value === "string") {
          serialized[key] = `${(0, import_util_uri_escape.escapeUri)(key)}=${(0, import_util_uri_escape.escapeUri)(value)}`;
        } else if (Array.isArray(value)) {
          serialized[key] = value.slice(0).reduce(
            (encoded, value2) => encoded.concat([`${(0, import_util_uri_escape.escapeUri)(key)}=${(0, import_util_uri_escape.escapeUri)(value2)}`]),
            []
          ).sort().join("&");
        }
      }
      return keys.map((key) => serialized[key]).filter((serialized2) => serialized2).join("&");
    }, "getCanonicalQuery");
    var import_is_array_buffer = require_dist_cjs8();
    var import_util_utf82 = require_dist_cjs10();
    var getPayloadHash = /* @__PURE__ */ __name(async ({ headers, body }, hashConstructor) => {
      for (const headerName of Object.keys(headers)) {
        if (headerName.toLowerCase() === SHA256_HEADER) {
          return headers[headerName];
        }
      }
      if (body == void 0) {
        return "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
      } else if (typeof body === "string" || ArrayBuffer.isView(body) || (0, import_is_array_buffer.isArrayBuffer)(body)) {
        const hashCtor = new hashConstructor();
        hashCtor.update((0, import_util_utf82.toUint8Array)(body));
        return (0, import_util_hex_encoding.toHex)(await hashCtor.digest());
      }
      return UNSIGNED_PAYLOAD;
    }, "getPayloadHash");
    var import_util_utf83 = require_dist_cjs10();
    var _HeaderFormatter = class _HeaderFormatter {
      format(headers) {
        const chunks = [];
        for (const headerName of Object.keys(headers)) {
          const bytes = (0, import_util_utf83.fromUtf8)(headerName);
          chunks.push(Uint8Array.from([bytes.byteLength]), bytes, this.formatHeaderValue(headers[headerName]));
        }
        const out = new Uint8Array(chunks.reduce((carry, bytes) => carry + bytes.byteLength, 0));
        let position = 0;
        for (const chunk of chunks) {
          out.set(chunk, position);
          position += chunk.byteLength;
        }
        return out;
      }
      formatHeaderValue(header) {
        switch (header.type) {
          case "boolean":
            return Uint8Array.from([
              header.value ? 0 : 1
              /* boolFalse */
            ]);
          case "byte":
            return Uint8Array.from([2, header.value]);
          case "short":
            const shortView = new DataView(new ArrayBuffer(3));
            shortView.setUint8(
              0,
              3
              /* short */
            );
            shortView.setInt16(1, header.value, false);
            return new Uint8Array(shortView.buffer);
          case "integer":
            const intView = new DataView(new ArrayBuffer(5));
            intView.setUint8(
              0,
              4
              /* integer */
            );
            intView.setInt32(1, header.value, false);
            return new Uint8Array(intView.buffer);
          case "long":
            const longBytes = new Uint8Array(9);
            longBytes[0] = 5;
            longBytes.set(header.value.bytes, 1);
            return longBytes;
          case "binary":
            const binView = new DataView(new ArrayBuffer(3 + header.value.byteLength));
            binView.setUint8(
              0,
              6
              /* byteArray */
            );
            binView.setUint16(1, header.value.byteLength, false);
            const binBytes = new Uint8Array(binView.buffer);
            binBytes.set(header.value, 3);
            return binBytes;
          case "string":
            const utf8Bytes = (0, import_util_utf83.fromUtf8)(header.value);
            const strView = new DataView(new ArrayBuffer(3 + utf8Bytes.byteLength));
            strView.setUint8(
              0,
              7
              /* string */
            );
            strView.setUint16(1, utf8Bytes.byteLength, false);
            const strBytes = new Uint8Array(strView.buffer);
            strBytes.set(utf8Bytes, 3);
            return strBytes;
          case "timestamp":
            const tsBytes = new Uint8Array(9);
            tsBytes[0] = 8;
            tsBytes.set(Int64.fromNumber(header.value.valueOf()).bytes, 1);
            return tsBytes;
          case "uuid":
            if (!UUID_PATTERN.test(header.value)) {
              throw new Error(`Invalid UUID received: ${header.value}`);
            }
            const uuidBytes = new Uint8Array(17);
            uuidBytes[0] = 9;
            uuidBytes.set((0, import_util_hex_encoding.fromHex)(header.value.replace(/\-/g, "")), 1);
            return uuidBytes;
        }
      }
    };
    __name(_HeaderFormatter, "HeaderFormatter");
    var HeaderFormatter = _HeaderFormatter;
    var UUID_PATTERN = /^[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$/;
    var _Int64 = class _Int642 {
      constructor(bytes) {
        this.bytes = bytes;
        if (bytes.byteLength !== 8) {
          throw new Error("Int64 buffers must be exactly 8 bytes");
        }
      }
      static fromNumber(number) {
        if (number > 9223372036854776e3 || number < -9223372036854776e3) {
          throw new Error(`${number} is too large (or, if negative, too small) to represent as an Int64`);
        }
        const bytes = new Uint8Array(8);
        for (let i = 7, remaining = Math.abs(Math.round(number)); i > -1 && remaining > 0; i--, remaining /= 256) {
          bytes[i] = remaining;
        }
        if (number < 0) {
          negate(bytes);
        }
        return new _Int642(bytes);
      }
      /**
       * Called implicitly by infix arithmetic operators.
       */
      valueOf() {
        const bytes = this.bytes.slice(0);
        const negative = bytes[0] & 128;
        if (negative) {
          negate(bytes);
        }
        return parseInt((0, import_util_hex_encoding.toHex)(bytes), 16) * (negative ? -1 : 1);
      }
      toString() {
        return String(this.valueOf());
      }
    };
    __name(_Int64, "Int64");
    var Int64 = _Int64;
    function negate(bytes) {
      for (let i = 0; i < 8; i++) {
        bytes[i] ^= 255;
      }
      for (let i = 7; i > -1; i--) {
        bytes[i]++;
        if (bytes[i] !== 0)
          break;
      }
    }
    __name(negate, "negate");
    var hasHeader = /* @__PURE__ */ __name((soughtHeader, headers) => {
      soughtHeader = soughtHeader.toLowerCase();
      for (const headerName of Object.keys(headers)) {
        if (soughtHeader === headerName.toLowerCase()) {
          return true;
        }
      }
      return false;
    }, "hasHeader");
    var cloneRequest = /* @__PURE__ */ __name(({ headers, query, ...rest }) => ({
      ...rest,
      headers: { ...headers },
      query: query ? cloneQuery(query) : void 0
    }), "cloneRequest");
    var cloneQuery = /* @__PURE__ */ __name((query) => Object.keys(query).reduce((carry, paramName) => {
      const param = query[paramName];
      return {
        ...carry,
        [paramName]: Array.isArray(param) ? [...param] : param
      };
    }, {}), "cloneQuery");
    var moveHeadersToQuery = /* @__PURE__ */ __name((request2, options = {}) => {
      var _a;
      const { headers, query = {} } = typeof request2.clone === "function" ? request2.clone() : cloneRequest(request2);
      for (const name of Object.keys(headers)) {
        const lname = name.toLowerCase();
        if (lname.slice(0, 6) === "x-amz-" && !((_a = options.unhoistableHeaders) == null ? void 0 : _a.has(lname))) {
          query[name] = headers[name];
          delete headers[name];
        }
      }
      return {
        ...request2,
        headers,
        query
      };
    }, "moveHeadersToQuery");
    var prepareRequest = /* @__PURE__ */ __name((request2) => {
      request2 = typeof request2.clone === "function" ? request2.clone() : cloneRequest(request2);
      for (const headerName of Object.keys(request2.headers)) {
        if (GENERATED_HEADERS.indexOf(headerName.toLowerCase()) > -1) {
          delete request2.headers[headerName];
        }
      }
      return request2;
    }, "prepareRequest");
    var iso8601 = /* @__PURE__ */ __name((time) => toDate(time).toISOString().replace(/\.\d{3}Z$/, "Z"), "iso8601");
    var toDate = /* @__PURE__ */ __name((time) => {
      if (typeof time === "number") {
        return new Date(time * 1e3);
      }
      if (typeof time === "string") {
        if (Number(time)) {
          return new Date(Number(time) * 1e3);
        }
        return new Date(time);
      }
      return time;
    }, "toDate");
    var _SignatureV4 = class _SignatureV4 {
      constructor({
        applyChecksum,
        credentials,
        region,
        service,
        sha256,
        uriEscapePath = true
      }) {
        this.headerFormatter = new HeaderFormatter();
        this.service = service;
        this.sha256 = sha256;
        this.uriEscapePath = uriEscapePath;
        this.applyChecksum = typeof applyChecksum === "boolean" ? applyChecksum : true;
        this.regionProvider = (0, import_util_middleware.normalizeProvider)(region);
        this.credentialProvider = (0, import_util_middleware.normalizeProvider)(credentials);
      }
      async presign(originalRequest, options = {}) {
        const {
          signingDate = /* @__PURE__ */ new Date(),
          expiresIn = 3600,
          unsignableHeaders,
          unhoistableHeaders,
          signableHeaders,
          signingRegion,
          signingService
        } = options;
        const credentials = await this.credentialProvider();
        this.validateResolvedCredentials(credentials);
        const region = signingRegion ?? await this.regionProvider();
        const { longDate, shortDate } = formatDate(signingDate);
        if (expiresIn > MAX_PRESIGNED_TTL) {
          return Promise.reject(
            "Signature version 4 presigned URLs must have an expiration date less than one week in the future"
          );
        }
        const scope = createScope(shortDate, region, signingService ?? this.service);
        const request2 = moveHeadersToQuery(prepareRequest(originalRequest), { unhoistableHeaders });
        if (credentials.sessionToken) {
          request2.query[TOKEN_QUERY_PARAM] = credentials.sessionToken;
        }
        request2.query[ALGORITHM_QUERY_PARAM] = ALGORITHM_IDENTIFIER;
        request2.query[CREDENTIAL_QUERY_PARAM] = `${credentials.accessKeyId}/${scope}`;
        request2.query[AMZ_DATE_QUERY_PARAM] = longDate;
        request2.query[EXPIRES_QUERY_PARAM] = expiresIn.toString(10);
        const canonicalHeaders = getCanonicalHeaders(request2, unsignableHeaders, signableHeaders);
        request2.query[SIGNED_HEADERS_QUERY_PARAM] = getCanonicalHeaderList(canonicalHeaders);
        request2.query[SIGNATURE_QUERY_PARAM] = await this.getSignature(
          longDate,
          scope,
          this.getSigningKey(credentials, region, shortDate, signingService),
          this.createCanonicalRequest(request2, canonicalHeaders, await getPayloadHash(originalRequest, this.sha256))
        );
        return request2;
      }
      async sign(toSign, options) {
        if (typeof toSign === "string") {
          return this.signString(toSign, options);
        } else if (toSign.headers && toSign.payload) {
          return this.signEvent(toSign, options);
        } else if (toSign.message) {
          return this.signMessage(toSign, options);
        } else {
          return this.signRequest(toSign, options);
        }
      }
      async signEvent({ headers, payload }, { signingDate = /* @__PURE__ */ new Date(), priorSignature, signingRegion, signingService }) {
        const region = signingRegion ?? await this.regionProvider();
        const { shortDate, longDate } = formatDate(signingDate);
        const scope = createScope(shortDate, region, signingService ?? this.service);
        const hashedPayload = await getPayloadHash({ headers: {}, body: payload }, this.sha256);
        const hash = new this.sha256();
        hash.update(headers);
        const hashedHeaders = (0, import_util_hex_encoding.toHex)(await hash.digest());
        const stringToSign = [
          EVENT_ALGORITHM_IDENTIFIER,
          longDate,
          scope,
          priorSignature,
          hashedHeaders,
          hashedPayload
        ].join("\n");
        return this.signString(stringToSign, { signingDate, signingRegion: region, signingService });
      }
      async signMessage(signableMessage, { signingDate = /* @__PURE__ */ new Date(), signingRegion, signingService }) {
        const promise = this.signEvent(
          {
            headers: this.headerFormatter.format(signableMessage.message.headers),
            payload: signableMessage.message.body
          },
          {
            signingDate,
            signingRegion,
            signingService,
            priorSignature: signableMessage.priorSignature
          }
        );
        return promise.then((signature) => {
          return { message: signableMessage.message, signature };
        });
      }
      async signString(stringToSign, { signingDate = /* @__PURE__ */ new Date(), signingRegion, signingService } = {}) {
        const credentials = await this.credentialProvider();
        this.validateResolvedCredentials(credentials);
        const region = signingRegion ?? await this.regionProvider();
        const { shortDate } = formatDate(signingDate);
        const hash = new this.sha256(await this.getSigningKey(credentials, region, shortDate, signingService));
        hash.update((0, import_util_utf84.toUint8Array)(stringToSign));
        return (0, import_util_hex_encoding.toHex)(await hash.digest());
      }
      async signRequest(requestToSign, {
        signingDate = /* @__PURE__ */ new Date(),
        signableHeaders,
        unsignableHeaders,
        signingRegion,
        signingService
      } = {}) {
        const credentials = await this.credentialProvider();
        this.validateResolvedCredentials(credentials);
        const region = signingRegion ?? await this.regionProvider();
        const request2 = prepareRequest(requestToSign);
        const { longDate, shortDate } = formatDate(signingDate);
        const scope = createScope(shortDate, region, signingService ?? this.service);
        request2.headers[AMZ_DATE_HEADER] = longDate;
        if (credentials.sessionToken) {
          request2.headers[TOKEN_HEADER] = credentials.sessionToken;
        }
        const payloadHash = await getPayloadHash(request2, this.sha256);
        if (!hasHeader(SHA256_HEADER, request2.headers) && this.applyChecksum) {
          request2.headers[SHA256_HEADER] = payloadHash;
        }
        const canonicalHeaders = getCanonicalHeaders(request2, unsignableHeaders, signableHeaders);
        const signature = await this.getSignature(
          longDate,
          scope,
          this.getSigningKey(credentials, region, shortDate, signingService),
          this.createCanonicalRequest(request2, canonicalHeaders, payloadHash)
        );
        request2.headers[AUTH_HEADER] = `${ALGORITHM_IDENTIFIER} Credential=${credentials.accessKeyId}/${scope}, SignedHeaders=${getCanonicalHeaderList(canonicalHeaders)}, Signature=${signature}`;
        return request2;
      }
      createCanonicalRequest(request2, canonicalHeaders, payloadHash) {
        const sortedHeaders = Object.keys(canonicalHeaders).sort();
        return `${request2.method}
${this.getCanonicalPath(request2)}
${getCanonicalQuery(request2)}
${sortedHeaders.map((name) => `${name}:${canonicalHeaders[name]}`).join("\n")}

${sortedHeaders.join(";")}
${payloadHash}`;
      }
      async createStringToSign(longDate, credentialScope, canonicalRequest) {
        const hash = new this.sha256();
        hash.update((0, import_util_utf84.toUint8Array)(canonicalRequest));
        const hashedRequest = await hash.digest();
        return `${ALGORITHM_IDENTIFIER}
${longDate}
${credentialScope}
${(0, import_util_hex_encoding.toHex)(hashedRequest)}`;
      }
      getCanonicalPath({ path }) {
        if (this.uriEscapePath) {
          const normalizedPathSegments = [];
          for (const pathSegment of path.split("/")) {
            if ((pathSegment == null ? void 0 : pathSegment.length) === 0)
              continue;
            if (pathSegment === ".")
              continue;
            if (pathSegment === "..") {
              normalizedPathSegments.pop();
            } else {
              normalizedPathSegments.push(pathSegment);
            }
          }
          const normalizedPath = `${(path == null ? void 0 : path.startsWith("/")) ? "/" : ""}${normalizedPathSegments.join("/")}${normalizedPathSegments.length > 0 && (path == null ? void 0 : path.endsWith("/")) ? "/" : ""}`;
          const doubleEncoded = (0, import_util_uri_escape.escapeUri)(normalizedPath);
          return doubleEncoded.replace(/%2F/g, "/");
        }
        return path;
      }
      async getSignature(longDate, credentialScope, keyPromise, canonicalRequest) {
        const stringToSign = await this.createStringToSign(longDate, credentialScope, canonicalRequest);
        const hash = new this.sha256(await keyPromise);
        hash.update((0, import_util_utf84.toUint8Array)(stringToSign));
        return (0, import_util_hex_encoding.toHex)(await hash.digest());
      }
      getSigningKey(credentials, region, shortDate, service) {
        return getSigningKey(this.sha256, credentials, shortDate, region, service || this.service);
      }
      validateResolvedCredentials(credentials) {
        if (typeof credentials !== "object" || // @ts-expect-error: Property 'accessKeyId' does not exist on type 'object'.ts(2339)
        typeof credentials.accessKeyId !== "string" || // @ts-expect-error: Property 'secretAccessKey' does not exist on type 'object'.ts(2339)
        typeof credentials.secretAccessKey !== "string") {
          throw new Error("Resolved credential object is not valid");
        }
      }
    };
    __name(_SignatureV4, "SignatureV4");
    var SignatureV4 = _SignatureV4;
    var formatDate = /* @__PURE__ */ __name((now) => {
      const longDate = iso8601(now).replace(/[\-:]/g, "");
      return {
        longDate,
        shortDate: longDate.slice(0, 8)
      };
    }, "formatDate");
    var getCanonicalHeaderList = /* @__PURE__ */ __name((headers) => Object.keys(headers).sort().join(";"), "getCanonicalHeaderList");
  }
});

// ../../../node_modules/@aws-sdk/middleware-signing/dist-cjs/awsAuthConfiguration.js
var require_awsAuthConfiguration = __commonJS({
  "../../../node_modules/@aws-sdk/middleware-signing/dist-cjs/awsAuthConfiguration.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveSigV4AuthConfig = exports2.resolveAwsAuthConfig = void 0;
    var property_provider_1 = require_dist_cjs6();
    var signature_v4_1 = require_dist_cjs13();
    var util_middleware_1 = require_dist_cjs7();
    var CREDENTIAL_EXPIRE_WINDOW = 3e5;
    var resolveAwsAuthConfig = (input) => {
      const normalizedCreds = input.credentials ? normalizeCredentialProvider(input.credentials) : input.credentialDefaultProvider(input);
      const { signingEscapePath = true, systemClockOffset = input.systemClockOffset || 0, sha256 } = input;
      let signer;
      if (input.signer) {
        signer = (0, util_middleware_1.normalizeProvider)(input.signer);
      } else if (input.regionInfoProvider) {
        signer = () => (0, util_middleware_1.normalizeProvider)(input.region)().then(async (region) => [
          await input.regionInfoProvider(region, {
            useFipsEndpoint: await input.useFipsEndpoint(),
            useDualstackEndpoint: await input.useDualstackEndpoint()
          }) || {},
          region
        ]).then(([regionInfo, region]) => {
          const { signingRegion, signingService } = regionInfo;
          input.signingRegion = input.signingRegion || signingRegion || region;
          input.signingName = input.signingName || signingService || input.serviceId;
          const params = {
            ...input,
            credentials: normalizedCreds,
            region: input.signingRegion,
            service: input.signingName,
            sha256,
            uriEscapePath: signingEscapePath
          };
          const SignerCtor = input.signerConstructor || signature_v4_1.SignatureV4;
          return new SignerCtor(params);
        });
      } else {
        signer = async (authScheme) => {
          authScheme = Object.assign({}, {
            name: "sigv4",
            signingName: input.signingName || input.defaultSigningName,
            signingRegion: await (0, util_middleware_1.normalizeProvider)(input.region)(),
            properties: {}
          }, authScheme);
          const signingRegion = authScheme.signingRegion;
          const signingService = authScheme.signingName;
          input.signingRegion = input.signingRegion || signingRegion;
          input.signingName = input.signingName || signingService || input.serviceId;
          const params = {
            ...input,
            credentials: normalizedCreds,
            region: input.signingRegion,
            service: input.signingName,
            sha256,
            uriEscapePath: signingEscapePath
          };
          const SignerCtor = input.signerConstructor || signature_v4_1.SignatureV4;
          return new SignerCtor(params);
        };
      }
      return {
        ...input,
        systemClockOffset,
        signingEscapePath,
        credentials: normalizedCreds,
        signer
      };
    };
    exports2.resolveAwsAuthConfig = resolveAwsAuthConfig;
    var resolveSigV4AuthConfig = (input) => {
      const normalizedCreds = input.credentials ? normalizeCredentialProvider(input.credentials) : input.credentialDefaultProvider(input);
      const { signingEscapePath = true, systemClockOffset = input.systemClockOffset || 0, sha256 } = input;
      let signer;
      if (input.signer) {
        signer = (0, util_middleware_1.normalizeProvider)(input.signer);
      } else {
        signer = (0, util_middleware_1.normalizeProvider)(new signature_v4_1.SignatureV4({
          credentials: normalizedCreds,
          region: input.region,
          service: input.signingName,
          sha256,
          uriEscapePath: signingEscapePath
        }));
      }
      return {
        ...input,
        systemClockOffset,
        signingEscapePath,
        credentials: normalizedCreds,
        signer
      };
    };
    exports2.resolveSigV4AuthConfig = resolveSigV4AuthConfig;
    var normalizeCredentialProvider = (credentials) => {
      if (typeof credentials === "function") {
        return (0, property_provider_1.memoize)(credentials, (credentials2) => credentials2.expiration !== void 0 && credentials2.expiration.getTime() - Date.now() < CREDENTIAL_EXPIRE_WINDOW, (credentials2) => credentials2.expiration !== void 0);
      }
      return (0, util_middleware_1.normalizeProvider)(credentials);
    };
  }
});

// ../../../node_modules/@aws-sdk/middleware-signing/dist-cjs/utils/getSkewCorrectedDate.js
var require_getSkewCorrectedDate = __commonJS({
  "../../../node_modules/@aws-sdk/middleware-signing/dist-cjs/utils/getSkewCorrectedDate.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getSkewCorrectedDate = void 0;
    var getSkewCorrectedDate = (systemClockOffset) => new Date(Date.now() + systemClockOffset);
    exports2.getSkewCorrectedDate = getSkewCorrectedDate;
  }
});

// ../../../node_modules/@aws-sdk/middleware-signing/dist-cjs/utils/isClockSkewed.js
var require_isClockSkewed = __commonJS({
  "../../../node_modules/@aws-sdk/middleware-signing/dist-cjs/utils/isClockSkewed.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.isClockSkewed = void 0;
    var getSkewCorrectedDate_1 = require_getSkewCorrectedDate();
    var isClockSkewed = (clockTime, systemClockOffset) => Math.abs((0, getSkewCorrectedDate_1.getSkewCorrectedDate)(systemClockOffset).getTime() - clockTime) >= 3e5;
    exports2.isClockSkewed = isClockSkewed;
  }
});

// ../../../node_modules/@aws-sdk/middleware-signing/dist-cjs/utils/getUpdatedSystemClockOffset.js
var require_getUpdatedSystemClockOffset = __commonJS({
  "../../../node_modules/@aws-sdk/middleware-signing/dist-cjs/utils/getUpdatedSystemClockOffset.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getUpdatedSystemClockOffset = void 0;
    var isClockSkewed_1 = require_isClockSkewed();
    var getUpdatedSystemClockOffset = (clockTime, currentSystemClockOffset) => {
      const clockTimeInMs = Date.parse(clockTime);
      if ((0, isClockSkewed_1.isClockSkewed)(clockTimeInMs, currentSystemClockOffset)) {
        return clockTimeInMs - Date.now();
      }
      return currentSystemClockOffset;
    };
    exports2.getUpdatedSystemClockOffset = getUpdatedSystemClockOffset;
  }
});

// ../../../node_modules/@aws-sdk/middleware-signing/dist-cjs/awsAuthMiddleware.js
var require_awsAuthMiddleware = __commonJS({
  "../../../node_modules/@aws-sdk/middleware-signing/dist-cjs/awsAuthMiddleware.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getSigV4AuthPlugin = exports2.getAwsAuthPlugin = exports2.awsAuthMiddlewareOptions = exports2.awsAuthMiddleware = void 0;
    var protocol_http_1 = require_dist_cjs2();
    var getSkewCorrectedDate_1 = require_getSkewCorrectedDate();
    var getUpdatedSystemClockOffset_1 = require_getUpdatedSystemClockOffset();
    var awsAuthMiddleware = (options) => (next, context) => async function(args) {
      var _a, _b, _c, _d;
      if (!protocol_http_1.HttpRequest.isInstance(args.request))
        return next(args);
      const authScheme = (_c = (_b = (_a = context.endpointV2) === null || _a === void 0 ? void 0 : _a.properties) === null || _b === void 0 ? void 0 : _b.authSchemes) === null || _c === void 0 ? void 0 : _c[0];
      const multiRegionOverride = (authScheme === null || authScheme === void 0 ? void 0 : authScheme.name) === "sigv4a" ? (_d = authScheme === null || authScheme === void 0 ? void 0 : authScheme.signingRegionSet) === null || _d === void 0 ? void 0 : _d.join(",") : void 0;
      const signer = await options.signer(authScheme);
      const output = await next({
        ...args,
        request: await signer.sign(args.request, {
          signingDate: (0, getSkewCorrectedDate_1.getSkewCorrectedDate)(options.systemClockOffset),
          signingRegion: multiRegionOverride || context["signing_region"],
          signingService: context["signing_service"]
        })
      }).catch((error) => {
        var _a2;
        const serverTime = (_a2 = error.ServerTime) !== null && _a2 !== void 0 ? _a2 : getDateHeader(error.$response);
        if (serverTime) {
          options.systemClockOffset = (0, getUpdatedSystemClockOffset_1.getUpdatedSystemClockOffset)(serverTime, options.systemClockOffset);
        }
        throw error;
      });
      const dateHeader = getDateHeader(output.response);
      if (dateHeader) {
        options.systemClockOffset = (0, getUpdatedSystemClockOffset_1.getUpdatedSystemClockOffset)(dateHeader, options.systemClockOffset);
      }
      return output;
    };
    exports2.awsAuthMiddleware = awsAuthMiddleware;
    var getDateHeader = (response) => {
      var _a, _b, _c;
      return protocol_http_1.HttpResponse.isInstance(response) ? (_b = (_a = response.headers) === null || _a === void 0 ? void 0 : _a.date) !== null && _b !== void 0 ? _b : (_c = response.headers) === null || _c === void 0 ? void 0 : _c.Date : void 0;
    };
    exports2.awsAuthMiddlewareOptions = {
      name: "awsAuthMiddleware",
      tags: ["SIGNATURE", "AWSAUTH"],
      relation: "after",
      toMiddleware: "retryMiddleware",
      override: true
    };
    var getAwsAuthPlugin = (options) => ({
      applyToStack: (clientStack) => {
        clientStack.addRelativeTo((0, exports2.awsAuthMiddleware)(options), exports2.awsAuthMiddlewareOptions);
      }
    });
    exports2.getAwsAuthPlugin = getAwsAuthPlugin;
    exports2.getSigV4AuthPlugin = exports2.getAwsAuthPlugin;
  }
});

// ../../../node_modules/@aws-sdk/middleware-signing/dist-cjs/index.js
var require_dist_cjs14 = __commonJS({
  "../../../node_modules/@aws-sdk/middleware-signing/dist-cjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_awsAuthConfiguration(), exports2);
    tslib_1.__exportStar(require_awsAuthMiddleware(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/middleware-user-agent/dist-cjs/configurations.js
var require_configurations = __commonJS({
  "../../../node_modules/@aws-sdk/middleware-user-agent/dist-cjs/configurations.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveUserAgentConfig = void 0;
    function resolveUserAgentConfig(input) {
      return {
        ...input,
        customUserAgent: typeof input.customUserAgent === "string" ? [[input.customUserAgent]] : input.customUserAgent
      };
    }
    exports2.resolveUserAgentConfig = resolveUserAgentConfig;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/aws/partitions.json
var require_partitions = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/aws/partitions.json"(exports2, module2) {
    module2.exports = {
      partitions: [{
        id: "aws",
        outputs: {
          dnsSuffix: "amazonaws.com",
          dualStackDnsSuffix: "api.aws",
          implicitGlobalRegion: "us-east-1",
          name: "aws",
          supportsDualStack: true,
          supportsFIPS: true
        },
        regionRegex: "^(us|eu|ap|sa|ca|me|af|il)\\-\\w+\\-\\d+$",
        regions: {
          "af-south-1": {
            description: "Africa (Cape Town)"
          },
          "ap-east-1": {
            description: "Asia Pacific (Hong Kong)"
          },
          "ap-northeast-1": {
            description: "Asia Pacific (Tokyo)"
          },
          "ap-northeast-2": {
            description: "Asia Pacific (Seoul)"
          },
          "ap-northeast-3": {
            description: "Asia Pacific (Osaka)"
          },
          "ap-south-1": {
            description: "Asia Pacific (Mumbai)"
          },
          "ap-south-2": {
            description: "Asia Pacific (Hyderabad)"
          },
          "ap-southeast-1": {
            description: "Asia Pacific (Singapore)"
          },
          "ap-southeast-2": {
            description: "Asia Pacific (Sydney)"
          },
          "ap-southeast-3": {
            description: "Asia Pacific (Jakarta)"
          },
          "ap-southeast-4": {
            description: "Asia Pacific (Melbourne)"
          },
          "aws-global": {
            description: "AWS Standard global region"
          },
          "ca-central-1": {
            description: "Canada (Central)"
          },
          "eu-central-1": {
            description: "Europe (Frankfurt)"
          },
          "eu-central-2": {
            description: "Europe (Zurich)"
          },
          "eu-north-1": {
            description: "Europe (Stockholm)"
          },
          "eu-south-1": {
            description: "Europe (Milan)"
          },
          "eu-south-2": {
            description: "Europe (Spain)"
          },
          "eu-west-1": {
            description: "Europe (Ireland)"
          },
          "eu-west-2": {
            description: "Europe (London)"
          },
          "eu-west-3": {
            description: "Europe (Paris)"
          },
          "il-central-1": {
            description: "Israel (Tel Aviv)"
          },
          "me-central-1": {
            description: "Middle East (UAE)"
          },
          "me-south-1": {
            description: "Middle East (Bahrain)"
          },
          "sa-east-1": {
            description: "South America (Sao Paulo)"
          },
          "us-east-1": {
            description: "US East (N. Virginia)"
          },
          "us-east-2": {
            description: "US East (Ohio)"
          },
          "us-west-1": {
            description: "US West (N. California)"
          },
          "us-west-2": {
            description: "US West (Oregon)"
          }
        }
      }, {
        id: "aws-cn",
        outputs: {
          dnsSuffix: "amazonaws.com.cn",
          dualStackDnsSuffix: "api.amazonwebservices.com.cn",
          implicitGlobalRegion: "cn-northwest-1",
          name: "aws-cn",
          supportsDualStack: true,
          supportsFIPS: true
        },
        regionRegex: "^cn\\-\\w+\\-\\d+$",
        regions: {
          "aws-cn-global": {
            description: "AWS China global region"
          },
          "cn-north-1": {
            description: "China (Beijing)"
          },
          "cn-northwest-1": {
            description: "China (Ningxia)"
          }
        }
      }, {
        id: "aws-us-gov",
        outputs: {
          dnsSuffix: "amazonaws.com",
          dualStackDnsSuffix: "api.aws",
          implicitGlobalRegion: "us-gov-west-1",
          name: "aws-us-gov",
          supportsDualStack: true,
          supportsFIPS: true
        },
        regionRegex: "^us\\-gov\\-\\w+\\-\\d+$",
        regions: {
          "aws-us-gov-global": {
            description: "AWS GovCloud (US) global region"
          },
          "us-gov-east-1": {
            description: "AWS GovCloud (US-East)"
          },
          "us-gov-west-1": {
            description: "AWS GovCloud (US-West)"
          }
        }
      }, {
        id: "aws-iso",
        outputs: {
          dnsSuffix: "c2s.ic.gov",
          dualStackDnsSuffix: "c2s.ic.gov",
          implicitGlobalRegion: "us-iso-east-1",
          name: "aws-iso",
          supportsDualStack: false,
          supportsFIPS: true
        },
        regionRegex: "^us\\-iso\\-\\w+\\-\\d+$",
        regions: {
          "aws-iso-global": {
            description: "AWS ISO (US) global region"
          },
          "us-iso-east-1": {
            description: "US ISO East"
          },
          "us-iso-west-1": {
            description: "US ISO WEST"
          }
        }
      }, {
        id: "aws-iso-b",
        outputs: {
          dnsSuffix: "sc2s.sgov.gov",
          dualStackDnsSuffix: "sc2s.sgov.gov",
          implicitGlobalRegion: "us-isob-east-1",
          name: "aws-iso-b",
          supportsDualStack: false,
          supportsFIPS: true
        },
        regionRegex: "^us\\-isob\\-\\w+\\-\\d+$",
        regions: {
          "aws-iso-b-global": {
            description: "AWS ISOB (US) global region"
          },
          "us-isob-east-1": {
            description: "US ISOB East (Ohio)"
          }
        }
      }, {
        id: "aws-iso-e",
        outputs: {
          dnsSuffix: "cloud.adc-e.uk",
          dualStackDnsSuffix: "cloud.adc-e.uk",
          implicitGlobalRegion: "eu-isoe-west-1",
          name: "aws-iso-e",
          supportsDualStack: false,
          supportsFIPS: true
        },
        regionRegex: "^eu\\-isoe\\-\\w+\\-\\d+$",
        regions: {}
      }, {
        id: "aws-iso-f",
        outputs: {
          dnsSuffix: "csp.hci.ic.gov",
          dualStackDnsSuffix: "csp.hci.ic.gov",
          implicitGlobalRegion: "us-isof-south-1",
          name: "aws-iso-f",
          supportsDualStack: false,
          supportsFIPS: true
        },
        regionRegex: "^us\\-isof\\-\\w+\\-\\d+$",
        regions: {}
      }],
      version: "1.1"
    };
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/aws/partition.js
var require_partition = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/aws/partition.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getUserAgentPrefix = exports2.useDefaultPartitionInfo = exports2.setPartitionInfo = exports2.partition = void 0;
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    var partitions_json_1 = tslib_1.__importDefault(require_partitions());
    var selectedPartitionsInfo = partitions_json_1.default;
    var selectedUserAgentPrefix = "";
    var partition = (value) => {
      const { partitions } = selectedPartitionsInfo;
      for (const partition2 of partitions) {
        const { regions, outputs } = partition2;
        for (const [region, regionData] of Object.entries(regions)) {
          if (region === value) {
            return {
              ...outputs,
              ...regionData
            };
          }
        }
      }
      for (const partition2 of partitions) {
        const { regionRegex, outputs } = partition2;
        if (new RegExp(regionRegex).test(value)) {
          return {
            ...outputs
          };
        }
      }
      const DEFAULT_PARTITION = partitions.find((partition2) => partition2.id === "aws");
      if (!DEFAULT_PARTITION) {
        throw new Error("Provided region was not found in the partition array or regex, and default partition with id 'aws' doesn't exist.");
      }
      return {
        ...DEFAULT_PARTITION.outputs
      };
    };
    exports2.partition = partition;
    var setPartitionInfo = (partitionsInfo, userAgentPrefix = "") => {
      selectedPartitionsInfo = partitionsInfo;
      selectedUserAgentPrefix = userAgentPrefix;
    };
    exports2.setPartitionInfo = setPartitionInfo;
    var useDefaultPartitionInfo = () => {
      (0, exports2.setPartitionInfo)(partitions_json_1.default, "");
    };
    exports2.useDefaultPartitionInfo = useDefaultPartitionInfo;
    var getUserAgentPrefix = () => selectedUserAgentPrefix;
    exports2.getUserAgentPrefix = getUserAgentPrefix;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/isIpAddress.js
var require_isIpAddress = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/isIpAddress.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.isIpAddress = void 0;
    var IP_V4_REGEX = new RegExp(`^(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)(?:\\.(?:25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)){3}$`);
    var isIpAddress = (value) => IP_V4_REGEX.test(value) || value.startsWith("[") && value.endsWith("]");
    exports2.isIpAddress = isIpAddress;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/debug/debugId.js
var require_debugId = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/debug/debugId.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.debugId = void 0;
    exports2.debugId = "endpoints";
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/debug/toDebugString.js
var require_toDebugString = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/debug/toDebugString.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.toDebugString = void 0;
    function toDebugString(input) {
      if (typeof input !== "object" || input == null) {
        return input;
      }
      if ("ref" in input) {
        return `$${toDebugString(input.ref)}`;
      }
      if ("fn" in input) {
        return `${input.fn}(${(input.argv || []).map(toDebugString).join(", ")})`;
      }
      return JSON.stringify(input, null, 2);
    }
    exports2.toDebugString = toDebugString;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/debug/index.js
var require_debug = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/debug/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_debugId(), exports2);
    tslib_1.__exportStar(require_toDebugString(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/types/EndpointError.js
var require_EndpointError = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/types/EndpointError.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.EndpointError = void 0;
    var EndpointError = class extends Error {
      constructor(message) {
        super(message);
        this.name = "EndpointError";
      }
    };
    exports2.EndpointError = EndpointError;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/types/EndpointRuleObject.js
var require_EndpointRuleObject = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/types/EndpointRuleObject.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/types/ErrorRuleObject.js
var require_ErrorRuleObject = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/types/ErrorRuleObject.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/types/RuleSetObject.js
var require_RuleSetObject = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/types/RuleSetObject.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/types/TreeRuleObject.js
var require_TreeRuleObject = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/types/TreeRuleObject.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/types/shared.js
var require_shared = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/types/shared.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/types/index.js
var require_types = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/types/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_EndpointError(), exports2);
    tslib_1.__exportStar(require_EndpointRuleObject(), exports2);
    tslib_1.__exportStar(require_ErrorRuleObject(), exports2);
    tslib_1.__exportStar(require_RuleSetObject(), exports2);
    tslib_1.__exportStar(require_TreeRuleObject(), exports2);
    tslib_1.__exportStar(require_shared(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/isValidHostLabel.js
var require_isValidHostLabel = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/isValidHostLabel.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.isValidHostLabel = void 0;
    var VALID_HOST_LABEL_REGEX = new RegExp(`^(?!.*-$)(?!-)[a-zA-Z0-9-]{1,63}$`);
    var isValidHostLabel = (value, allowSubDomains = false) => {
      if (!allowSubDomains) {
        return VALID_HOST_LABEL_REGEX.test(value);
      }
      const labels = value.split(".");
      for (const label of labels) {
        if (!(0, exports2.isValidHostLabel)(label)) {
          return false;
        }
      }
      return true;
    };
    exports2.isValidHostLabel = isValidHostLabel;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/aws/isVirtualHostableS3Bucket.js
var require_isVirtualHostableS3Bucket = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/aws/isVirtualHostableS3Bucket.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.isVirtualHostableS3Bucket = void 0;
    var isIpAddress_1 = require_isIpAddress();
    var isValidHostLabel_1 = require_isValidHostLabel();
    var isVirtualHostableS3Bucket = (value, allowSubDomains = false) => {
      if (allowSubDomains) {
        for (const label of value.split(".")) {
          if (!(0, exports2.isVirtualHostableS3Bucket)(label)) {
            return false;
          }
        }
        return true;
      }
      if (!(0, isValidHostLabel_1.isValidHostLabel)(value)) {
        return false;
      }
      if (value.length < 3 || value.length > 63) {
        return false;
      }
      if (value !== value.toLowerCase()) {
        return false;
      }
      if ((0, isIpAddress_1.isIpAddress)(value)) {
        return false;
      }
      return true;
    };
    exports2.isVirtualHostableS3Bucket = isVirtualHostableS3Bucket;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/aws/parseArn.js
var require_parseArn = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/aws/parseArn.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.parseArn = void 0;
    var parseArn = (value) => {
      const segments = value.split(":");
      if (segments.length < 6)
        return null;
      const [arn, partition, service, region, accountId, ...resourceId] = segments;
      if (arn !== "arn" || partition === "" || service === "" || resourceId[0] === "")
        return null;
      return {
        partition,
        service,
        region,
        accountId,
        resourceId: resourceId[0].includes("/") ? resourceId[0].split("/") : resourceId
      };
    };
    exports2.parseArn = parseArn;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/aws/index.js
var require_aws = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/aws/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_isVirtualHostableS3Bucket(), exports2);
    tslib_1.__exportStar(require_parseArn(), exports2);
    tslib_1.__exportStar(require_partition(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/booleanEquals.js
var require_booleanEquals = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/booleanEquals.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.booleanEquals = void 0;
    var booleanEquals = (value1, value2) => value1 === value2;
    exports2.booleanEquals = booleanEquals;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/getAttrPathList.js
var require_getAttrPathList = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/getAttrPathList.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getAttrPathList = void 0;
    var types_1 = require_types();
    var getAttrPathList = (path) => {
      const parts = path.split(".");
      const pathList = [];
      for (const part of parts) {
        const squareBracketIndex = part.indexOf("[");
        if (squareBracketIndex !== -1) {
          if (part.indexOf("]") !== part.length - 1) {
            throw new types_1.EndpointError(`Path: '${path}' does not end with ']'`);
          }
          const arrayIndex = part.slice(squareBracketIndex + 1, -1);
          if (Number.isNaN(parseInt(arrayIndex))) {
            throw new types_1.EndpointError(`Invalid array index: '${arrayIndex}' in path: '${path}'`);
          }
          if (squareBracketIndex !== 0) {
            pathList.push(part.slice(0, squareBracketIndex));
          }
          pathList.push(arrayIndex);
        } else {
          pathList.push(part);
        }
      }
      return pathList;
    };
    exports2.getAttrPathList = getAttrPathList;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/getAttr.js
var require_getAttr = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/getAttr.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getAttr = void 0;
    var types_1 = require_types();
    var getAttrPathList_1 = require_getAttrPathList();
    var getAttr = (value, path) => (0, getAttrPathList_1.getAttrPathList)(path).reduce((acc, index) => {
      if (typeof acc !== "object") {
        throw new types_1.EndpointError(`Index '${index}' in '${path}' not found in '${JSON.stringify(value)}'`);
      } else if (Array.isArray(acc)) {
        return acc[parseInt(index)];
      }
      return acc[index];
    }, value);
    exports2.getAttr = getAttr;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/isSet.js
var require_isSet = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/isSet.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.isSet = void 0;
    var isSet = (value) => value != null;
    exports2.isSet = isSet;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/not.js
var require_not = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/not.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.not = void 0;
    var not = (value) => !value;
    exports2.not = not;
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/abort.js
var require_abort = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/abort.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/auth.js
var require_auth = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/auth.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.HttpAuthLocation = void 0;
    var types_1 = require_dist_cjs();
    Object.defineProperty(exports2, "HttpAuthLocation", { enumerable: true, get: function() {
      return types_1.HttpAuthLocation;
    } });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/blob/blob-types.js
var require_blob_types = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/blob/blob-types.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/checksum.js
var require_checksum = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/checksum.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/client.js
var require_client = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/client.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/command.js
var require_command = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/command.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/connection.js
var require_connection = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/connection.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/credentials.js
var require_credentials = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/credentials.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/crypto.js
var require_crypto = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/crypto.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/dns.js
var require_dns = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/dns.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.HostAddressType = void 0;
    var HostAddressType;
    (function(HostAddressType2) {
      HostAddressType2["AAAA"] = "AAAA";
      HostAddressType2["A"] = "A";
    })(HostAddressType = exports2.HostAddressType || (exports2.HostAddressType = {}));
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/encode.js
var require_encode = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/encode.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/endpoint.js
var require_endpoint = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/endpoint.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.EndpointURLScheme = void 0;
    var types_1 = require_dist_cjs();
    Object.defineProperty(exports2, "EndpointURLScheme", { enumerable: true, get: function() {
      return types_1.EndpointURLScheme;
    } });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/eventStream.js
var require_eventStream = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/eventStream.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/extensions/index.js
var require_extensions = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/extensions/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/http.js
var require_http = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/http.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/identity/AnonymousIdentity.js
var require_AnonymousIdentity = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/identity/AnonymousIdentity.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/identity/AwsCredentialIdentity.js
var require_AwsCredentialIdentity = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/identity/AwsCredentialIdentity.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/identity/Identity.js
var require_Identity = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/identity/Identity.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/identity/LoginIdentity.js
var require_LoginIdentity = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/identity/LoginIdentity.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/identity/TokenIdentity.js
var require_TokenIdentity = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/identity/TokenIdentity.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/identity/index.js
var require_identity = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/identity/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_AnonymousIdentity(), exports2);
    tslib_1.__exportStar(require_AwsCredentialIdentity(), exports2);
    tslib_1.__exportStar(require_Identity(), exports2);
    tslib_1.__exportStar(require_LoginIdentity(), exports2);
    tslib_1.__exportStar(require_TokenIdentity(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/logger.js
var require_logger = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/logger.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/middleware.js
var require_middleware = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/middleware.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/pagination.js
var require_pagination = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/pagination.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/profile.js
var require_profile = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/profile.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/request.js
var require_request = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/request.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/response.js
var require_response = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/response.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/retry.js
var require_retry = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/retry.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/serde.js
var require_serde = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/serde.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/shapes.js
var require_shapes = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/shapes.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/signature.js
var require_signature = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/signature.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/stream.js
var require_stream = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/stream.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/token.js
var require_token = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/token.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/transfer.js
var require_transfer = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/transfer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.RequestHandlerProtocol = void 0;
    var types_1 = require_dist_cjs();
    Object.defineProperty(exports2, "RequestHandlerProtocol", { enumerable: true, get: function() {
      return types_1.RequestHandlerProtocol;
    } });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/uri.js
var require_uri = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/uri.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/util.js
var require_util = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/util.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/waiter.js
var require_waiter = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/waiter.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/types/dist-cjs/index.js
var require_dist_cjs15 = __commonJS({
  "../../../node_modules/@aws-sdk/types/dist-cjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_abort(), exports2);
    tslib_1.__exportStar(require_auth(), exports2);
    tslib_1.__exportStar(require_blob_types(), exports2);
    tslib_1.__exportStar(require_checksum(), exports2);
    tslib_1.__exportStar(require_client(), exports2);
    tslib_1.__exportStar(require_command(), exports2);
    tslib_1.__exportStar(require_connection(), exports2);
    tslib_1.__exportStar(require_credentials(), exports2);
    tslib_1.__exportStar(require_crypto(), exports2);
    tslib_1.__exportStar(require_dns(), exports2);
    tslib_1.__exportStar(require_encode(), exports2);
    tslib_1.__exportStar(require_endpoint(), exports2);
    tslib_1.__exportStar(require_eventStream(), exports2);
    tslib_1.__exportStar(require_extensions(), exports2);
    tslib_1.__exportStar(require_http(), exports2);
    tslib_1.__exportStar(require_identity(), exports2);
    tslib_1.__exportStar(require_logger(), exports2);
    tslib_1.__exportStar(require_middleware(), exports2);
    tslib_1.__exportStar(require_pagination(), exports2);
    tslib_1.__exportStar(require_profile(), exports2);
    tslib_1.__exportStar(require_request(), exports2);
    tslib_1.__exportStar(require_response(), exports2);
    tslib_1.__exportStar(require_retry(), exports2);
    tslib_1.__exportStar(require_serde(), exports2);
    tslib_1.__exportStar(require_shapes(), exports2);
    tslib_1.__exportStar(require_signature(), exports2);
    tslib_1.__exportStar(require_stream(), exports2);
    tslib_1.__exportStar(require_token(), exports2);
    tslib_1.__exportStar(require_transfer(), exports2);
    tslib_1.__exportStar(require_uri(), exports2);
    tslib_1.__exportStar(require_util(), exports2);
    tslib_1.__exportStar(require_waiter(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/parseURL.js
var require_parseURL = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/parseURL.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.parseURL = void 0;
    var types_1 = require_dist_cjs15();
    var isIpAddress_1 = require_isIpAddress();
    var DEFAULT_PORTS = {
      [types_1.EndpointURLScheme.HTTP]: 80,
      [types_1.EndpointURLScheme.HTTPS]: 443
    };
    var parseURL = (value) => {
      const whatwgURL = (() => {
        try {
          if (value instanceof URL) {
            return value;
          }
          if (typeof value === "object" && "hostname" in value) {
            const { hostname: hostname2, port, protocol: protocol2 = "", path = "", query = {} } = value;
            const url2 = new URL(`${protocol2}//${hostname2}${port ? `:${port}` : ""}${path}`);
            url2.search = Object.entries(query).map(([k, v]) => `${k}=${v}`).join("&");
            return url2;
          }
          return new URL(value);
        } catch (error) {
          return null;
        }
      })();
      if (!whatwgURL) {
        console.error(`Unable to parse ${JSON.stringify(value)} as a whatwg URL.`);
        return null;
      }
      const urlString = whatwgURL.href;
      const { host, hostname, pathname, protocol, search } = whatwgURL;
      if (search) {
        return null;
      }
      const scheme = protocol.slice(0, -1);
      if (!Object.values(types_1.EndpointURLScheme).includes(scheme)) {
        return null;
      }
      const isIp = (0, isIpAddress_1.isIpAddress)(hostname);
      const inputContainsDefaultPort = urlString.includes(`${host}:${DEFAULT_PORTS[scheme]}`) || typeof value === "string" && value.includes(`${host}:${DEFAULT_PORTS[scheme]}`);
      const authority = `${host}${inputContainsDefaultPort ? `:${DEFAULT_PORTS[scheme]}` : ``}`;
      return {
        scheme,
        authority,
        path: pathname,
        normalizedPath: pathname.endsWith("/") ? pathname : `${pathname}/`,
        isIp
      };
    };
    exports2.parseURL = parseURL;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/stringEquals.js
var require_stringEquals = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/stringEquals.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.stringEquals = void 0;
    var stringEquals = (value1, value2) => value1 === value2;
    exports2.stringEquals = stringEquals;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/substring.js
var require_substring = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/substring.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.substring = void 0;
    var substring = (input, start, stop, reverse) => {
      if (start >= stop || input.length < stop) {
        return null;
      }
      if (!reverse) {
        return input.substring(start, stop);
      }
      return input.substring(input.length - stop, input.length - start);
    };
    exports2.substring = substring;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/uriEncode.js
var require_uriEncode = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/uriEncode.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.uriEncode = void 0;
    var uriEncode = (value) => encodeURIComponent(value).replace(/[!*'()]/g, (c) => `%${c.charCodeAt(0).toString(16).toUpperCase()}`);
    exports2.uriEncode = uriEncode;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/index.js
var require_lib = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.aws = void 0;
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    exports2.aws = tslib_1.__importStar(require_aws());
    tslib_1.__exportStar(require_booleanEquals(), exports2);
    tslib_1.__exportStar(require_getAttr(), exports2);
    tslib_1.__exportStar(require_isSet(), exports2);
    tslib_1.__exportStar(require_isValidHostLabel(), exports2);
    tslib_1.__exportStar(require_not(), exports2);
    tslib_1.__exportStar(require_parseURL(), exports2);
    tslib_1.__exportStar(require_stringEquals(), exports2);
    tslib_1.__exportStar(require_substring(), exports2);
    tslib_1.__exportStar(require_uriEncode(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/evaluateTemplate.js
var require_evaluateTemplate = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/evaluateTemplate.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.evaluateTemplate = void 0;
    var lib_1 = require_lib();
    var evaluateTemplate = (template, options) => {
      const evaluatedTemplateArr = [];
      const templateContext = {
        ...options.endpointParams,
        ...options.referenceRecord
      };
      let currentIndex = 0;
      while (currentIndex < template.length) {
        const openingBraceIndex = template.indexOf("{", currentIndex);
        if (openingBraceIndex === -1) {
          evaluatedTemplateArr.push(template.slice(currentIndex));
          break;
        }
        evaluatedTemplateArr.push(template.slice(currentIndex, openingBraceIndex));
        const closingBraceIndex = template.indexOf("}", openingBraceIndex);
        if (closingBraceIndex === -1) {
          evaluatedTemplateArr.push(template.slice(openingBraceIndex));
          break;
        }
        if (template[openingBraceIndex + 1] === "{" && template[closingBraceIndex + 1] === "}") {
          evaluatedTemplateArr.push(template.slice(openingBraceIndex + 1, closingBraceIndex));
          currentIndex = closingBraceIndex + 2;
        }
        const parameterName = template.substring(openingBraceIndex + 1, closingBraceIndex);
        if (parameterName.includes("#")) {
          const [refName, attrName] = parameterName.split("#");
          evaluatedTemplateArr.push((0, lib_1.getAttr)(templateContext[refName], attrName));
        } else {
          evaluatedTemplateArr.push(templateContext[parameterName]);
        }
        currentIndex = closingBraceIndex + 1;
      }
      return evaluatedTemplateArr.join("");
    };
    exports2.evaluateTemplate = evaluateTemplate;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/getReferenceValue.js
var require_getReferenceValue = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/getReferenceValue.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getReferenceValue = void 0;
    var getReferenceValue = ({ ref }, options) => {
      const referenceRecord = {
        ...options.endpointParams,
        ...options.referenceRecord
      };
      return referenceRecord[ref];
    };
    exports2.getReferenceValue = getReferenceValue;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/evaluateExpression.js
var require_evaluateExpression = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/evaluateExpression.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.evaluateExpression = void 0;
    var types_1 = require_types();
    var callFunction_1 = require_callFunction();
    var evaluateTemplate_1 = require_evaluateTemplate();
    var getReferenceValue_1 = require_getReferenceValue();
    var evaluateExpression = (obj, keyName, options) => {
      if (typeof obj === "string") {
        return (0, evaluateTemplate_1.evaluateTemplate)(obj, options);
      } else if (obj["fn"]) {
        return (0, callFunction_1.callFunction)(obj, options);
      } else if (obj["ref"]) {
        return (0, getReferenceValue_1.getReferenceValue)(obj, options);
      }
      throw new types_1.EndpointError(`'${keyName}': ${String(obj)} is not a string, function or reference.`);
    };
    exports2.evaluateExpression = evaluateExpression;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/callFunction.js
var require_callFunction = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/callFunction.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.callFunction = void 0;
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    var lib = tslib_1.__importStar(require_lib());
    var evaluateExpression_1 = require_evaluateExpression();
    var callFunction = ({ fn, argv }, options) => {
      const evaluatedArgs = argv.map((arg) => ["boolean", "number"].includes(typeof arg) ? arg : (0, evaluateExpression_1.evaluateExpression)(arg, "arg", options));
      return fn.split(".").reduce((acc, key) => acc[key], lib)(...evaluatedArgs);
    };
    exports2.callFunction = callFunction;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/evaluateCondition.js
var require_evaluateCondition = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/evaluateCondition.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.evaluateCondition = void 0;
    var debug_1 = require_debug();
    var types_1 = require_types();
    var callFunction_1 = require_callFunction();
    var evaluateCondition = ({ assign, ...fnArgs }, options) => {
      var _a, _b;
      if (assign && assign in options.referenceRecord) {
        throw new types_1.EndpointError(`'${assign}' is already defined in Reference Record.`);
      }
      const value = (0, callFunction_1.callFunction)(fnArgs, options);
      (_b = (_a = options.logger) === null || _a === void 0 ? void 0 : _a.debug) === null || _b === void 0 ? void 0 : _b.call(_a, debug_1.debugId, `evaluateCondition: ${(0, debug_1.toDebugString)(fnArgs)} = ${(0, debug_1.toDebugString)(value)}`);
      return {
        result: value === "" ? true : !!value,
        ...assign != null && { toAssign: { name: assign, value } }
      };
    };
    exports2.evaluateCondition = evaluateCondition;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/evaluateConditions.js
var require_evaluateConditions = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/evaluateConditions.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.evaluateConditions = void 0;
    var debug_1 = require_debug();
    var evaluateCondition_1 = require_evaluateCondition();
    var evaluateConditions = (conditions = [], options) => {
      var _a, _b;
      const conditionsReferenceRecord = {};
      for (const condition of conditions) {
        const { result, toAssign } = (0, evaluateCondition_1.evaluateCondition)(condition, {
          ...options,
          referenceRecord: {
            ...options.referenceRecord,
            ...conditionsReferenceRecord
          }
        });
        if (!result) {
          return { result };
        }
        if (toAssign) {
          conditionsReferenceRecord[toAssign.name] = toAssign.value;
          (_b = (_a = options.logger) === null || _a === void 0 ? void 0 : _a.debug) === null || _b === void 0 ? void 0 : _b.call(_a, debug_1.debugId, `assign: ${toAssign.name} := ${(0, debug_1.toDebugString)(toAssign.value)}`);
        }
      }
      return { result: true, referenceRecord: conditionsReferenceRecord };
    };
    exports2.evaluateConditions = evaluateConditions;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/getEndpointHeaders.js
var require_getEndpointHeaders = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/getEndpointHeaders.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getEndpointHeaders = void 0;
    var types_1 = require_types();
    var evaluateExpression_1 = require_evaluateExpression();
    var getEndpointHeaders = (headers, options) => Object.entries(headers).reduce((acc, [headerKey, headerVal]) => ({
      ...acc,
      [headerKey]: headerVal.map((headerValEntry) => {
        const processedExpr = (0, evaluateExpression_1.evaluateExpression)(headerValEntry, "Header value entry", options);
        if (typeof processedExpr !== "string") {
          throw new types_1.EndpointError(`Header '${headerKey}' value '${processedExpr}' is not a string`);
        }
        return processedExpr;
      })
    }), {});
    exports2.getEndpointHeaders = getEndpointHeaders;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/getEndpointProperty.js
var require_getEndpointProperty = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/getEndpointProperty.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getEndpointProperty = void 0;
    var types_1 = require_types();
    var evaluateTemplate_1 = require_evaluateTemplate();
    var getEndpointProperties_1 = require_getEndpointProperties();
    var getEndpointProperty = (property, options) => {
      if (Array.isArray(property)) {
        return property.map((propertyEntry) => (0, exports2.getEndpointProperty)(propertyEntry, options));
      }
      switch (typeof property) {
        case "string":
          return (0, evaluateTemplate_1.evaluateTemplate)(property, options);
        case "object":
          if (property === null) {
            throw new types_1.EndpointError(`Unexpected endpoint property: ${property}`);
          }
          return (0, getEndpointProperties_1.getEndpointProperties)(property, options);
        case "boolean":
          return property;
        default:
          throw new types_1.EndpointError(`Unexpected endpoint property type: ${typeof property}`);
      }
    };
    exports2.getEndpointProperty = getEndpointProperty;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/getEndpointProperties.js
var require_getEndpointProperties = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/getEndpointProperties.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getEndpointProperties = void 0;
    var getEndpointProperty_1 = require_getEndpointProperty();
    var getEndpointProperties = (properties, options) => Object.entries(properties).reduce((acc, [propertyKey, propertyVal]) => ({
      ...acc,
      [propertyKey]: (0, getEndpointProperty_1.getEndpointProperty)(propertyVal, options)
    }), {});
    exports2.getEndpointProperties = getEndpointProperties;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/getEndpointUrl.js
var require_getEndpointUrl = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/getEndpointUrl.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getEndpointUrl = void 0;
    var types_1 = require_types();
    var evaluateExpression_1 = require_evaluateExpression();
    var getEndpointUrl = (endpointUrl, options) => {
      const expression = (0, evaluateExpression_1.evaluateExpression)(endpointUrl, "Endpoint URL", options);
      if (typeof expression === "string") {
        try {
          return new URL(expression);
        } catch (error) {
          console.error(`Failed to construct URL with ${expression}`, error);
          throw error;
        }
      }
      throw new types_1.EndpointError(`Endpoint URL must be a string, got ${typeof expression}`);
    };
    exports2.getEndpointUrl = getEndpointUrl;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/evaluateEndpointRule.js
var require_evaluateEndpointRule = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/evaluateEndpointRule.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.evaluateEndpointRule = void 0;
    var debug_1 = require_debug();
    var evaluateConditions_1 = require_evaluateConditions();
    var getEndpointHeaders_1 = require_getEndpointHeaders();
    var getEndpointProperties_1 = require_getEndpointProperties();
    var getEndpointUrl_1 = require_getEndpointUrl();
    var evaluateEndpointRule = (endpointRule, options) => {
      var _a, _b;
      const { conditions, endpoint } = endpointRule;
      const { result, referenceRecord } = (0, evaluateConditions_1.evaluateConditions)(conditions, options);
      if (!result) {
        return;
      }
      const endpointRuleOptions = {
        ...options,
        referenceRecord: { ...options.referenceRecord, ...referenceRecord }
      };
      const { url: url2, properties, headers } = endpoint;
      (_b = (_a = options.logger) === null || _a === void 0 ? void 0 : _a.debug) === null || _b === void 0 ? void 0 : _b.call(_a, debug_1.debugId, `Resolving endpoint from template: ${(0, debug_1.toDebugString)(endpoint)}`);
      return {
        ...headers != void 0 && {
          headers: (0, getEndpointHeaders_1.getEndpointHeaders)(headers, endpointRuleOptions)
        },
        ...properties != void 0 && {
          properties: (0, getEndpointProperties_1.getEndpointProperties)(properties, endpointRuleOptions)
        },
        url: (0, getEndpointUrl_1.getEndpointUrl)(url2, endpointRuleOptions)
      };
    };
    exports2.evaluateEndpointRule = evaluateEndpointRule;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/evaluateErrorRule.js
var require_evaluateErrorRule = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/evaluateErrorRule.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.evaluateErrorRule = void 0;
    var types_1 = require_types();
    var evaluateConditions_1 = require_evaluateConditions();
    var evaluateExpression_1 = require_evaluateExpression();
    var evaluateErrorRule = (errorRule, options) => {
      const { conditions, error } = errorRule;
      const { result, referenceRecord } = (0, evaluateConditions_1.evaluateConditions)(conditions, options);
      if (!result) {
        return;
      }
      throw new types_1.EndpointError((0, evaluateExpression_1.evaluateExpression)(error, "Error", {
        ...options,
        referenceRecord: { ...options.referenceRecord, ...referenceRecord }
      }));
    };
    exports2.evaluateErrorRule = evaluateErrorRule;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/evaluateTreeRule.js
var require_evaluateTreeRule = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/evaluateTreeRule.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.evaluateTreeRule = void 0;
    var evaluateConditions_1 = require_evaluateConditions();
    var evaluateRules_1 = require_evaluateRules();
    var evaluateTreeRule = (treeRule, options) => {
      const { conditions, rules } = treeRule;
      const { result, referenceRecord } = (0, evaluateConditions_1.evaluateConditions)(conditions, options);
      if (!result) {
        return;
      }
      return (0, evaluateRules_1.evaluateRules)(rules, {
        ...options,
        referenceRecord: { ...options.referenceRecord, ...referenceRecord }
      });
    };
    exports2.evaluateTreeRule = evaluateTreeRule;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/evaluateRules.js
var require_evaluateRules = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/evaluateRules.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.evaluateRules = void 0;
    var types_1 = require_types();
    var evaluateEndpointRule_1 = require_evaluateEndpointRule();
    var evaluateErrorRule_1 = require_evaluateErrorRule();
    var evaluateTreeRule_1 = require_evaluateTreeRule();
    var evaluateRules = (rules, options) => {
      for (const rule of rules) {
        if (rule.type === "endpoint") {
          const endpointOrUndefined = (0, evaluateEndpointRule_1.evaluateEndpointRule)(rule, options);
          if (endpointOrUndefined) {
            return endpointOrUndefined;
          }
        } else if (rule.type === "error") {
          (0, evaluateErrorRule_1.evaluateErrorRule)(rule, options);
        } else if (rule.type === "tree") {
          const endpointOrUndefined = (0, evaluateTreeRule_1.evaluateTreeRule)(rule, options);
          if (endpointOrUndefined) {
            return endpointOrUndefined;
          }
        } else {
          throw new types_1.EndpointError(`Unknown endpoint rule: ${rule}`);
        }
      }
      throw new types_1.EndpointError(`Rules evaluation failed`);
    };
    exports2.evaluateRules = evaluateRules;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/index.js
var require_utils = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/utils/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_evaluateRules(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/resolveEndpoint.js
var require_resolveEndpoint = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/resolveEndpoint.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveEndpoint = void 0;
    var debug_1 = require_debug();
    var types_1 = require_types();
    var utils_1 = require_utils();
    var resolveEndpoint = (ruleSetObject, options) => {
      var _a, _b, _c, _d, _e, _f;
      const { endpointParams, logger } = options;
      const { parameters, rules } = ruleSetObject;
      (_b = (_a = options.logger) === null || _a === void 0 ? void 0 : _a.debug) === null || _b === void 0 ? void 0 : _b.call(_a, `${debug_1.debugId} Initial EndpointParams: ${(0, debug_1.toDebugString)(endpointParams)}`);
      const paramsWithDefault = Object.entries(parameters).filter(([, v]) => v.default != null).map(([k, v]) => [k, v.default]);
      if (paramsWithDefault.length > 0) {
        for (const [paramKey, paramDefaultValue] of paramsWithDefault) {
          endpointParams[paramKey] = (_c = endpointParams[paramKey]) !== null && _c !== void 0 ? _c : paramDefaultValue;
        }
      }
      const requiredParams = Object.entries(parameters).filter(([, v]) => v.required).map(([k]) => k);
      for (const requiredParam of requiredParams) {
        if (endpointParams[requiredParam] == null) {
          throw new types_1.EndpointError(`Missing required parameter: '${requiredParam}'`);
        }
      }
      const endpoint = (0, utils_1.evaluateRules)(rules, { endpointParams, logger, referenceRecord: {} });
      if ((_d = options.endpointParams) === null || _d === void 0 ? void 0 : _d.Endpoint) {
        try {
          const givenEndpoint = new URL(options.endpointParams.Endpoint);
          const { protocol, port } = givenEndpoint;
          endpoint.url.protocol = protocol;
          endpoint.url.port = port;
        } catch (e) {
        }
      }
      (_f = (_e = options.logger) === null || _e === void 0 ? void 0 : _e.debug) === null || _f === void 0 ? void 0 : _f.call(_e, `${debug_1.debugId} Resolved endpoint: ${(0, debug_1.toDebugString)(endpoint)}`);
      return endpoint;
    };
    exports2.resolveEndpoint = resolveEndpoint;
  }
});

// ../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/index.js
var require_dist_cjs16 = __commonJS({
  "../../../node_modules/@aws-sdk/util-endpoints/dist-cjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_partition(), exports2);
    tslib_1.__exportStar(require_isIpAddress(), exports2);
    tslib_1.__exportStar(require_resolveEndpoint(), exports2);
    tslib_1.__exportStar(require_types(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/middleware-user-agent/dist-cjs/constants.js
var require_constants = __commonJS({
  "../../../node_modules/@aws-sdk/middleware-user-agent/dist-cjs/constants.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.UA_ESCAPE_CHAR = exports2.UA_VALUE_ESCAPE_REGEX = exports2.UA_NAME_ESCAPE_REGEX = exports2.UA_NAME_SEPARATOR = exports2.SPACE = exports2.X_AMZ_USER_AGENT = exports2.USER_AGENT = void 0;
    exports2.USER_AGENT = "user-agent";
    exports2.X_AMZ_USER_AGENT = "x-amz-user-agent";
    exports2.SPACE = " ";
    exports2.UA_NAME_SEPARATOR = "/";
    exports2.UA_NAME_ESCAPE_REGEX = /[^\!\$\%\&\'\*\+\-\.\^\_\`\|\~\d\w]/g;
    exports2.UA_VALUE_ESCAPE_REGEX = /[^\!\$\%\&\'\*\+\-\.\^\_\`\|\~\d\w\#]/g;
    exports2.UA_ESCAPE_CHAR = "-";
  }
});

// ../../../node_modules/@aws-sdk/middleware-user-agent/dist-cjs/user-agent-middleware.js
var require_user_agent_middleware = __commonJS({
  "../../../node_modules/@aws-sdk/middleware-user-agent/dist-cjs/user-agent-middleware.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getUserAgentPlugin = exports2.getUserAgentMiddlewareOptions = exports2.userAgentMiddleware = void 0;
    var util_endpoints_1 = require_dist_cjs16();
    var protocol_http_1 = require_dist_cjs2();
    var constants_1 = require_constants();
    var userAgentMiddleware = (options) => (next, context) => async (args) => {
      var _a, _b;
      const { request: request2 } = args;
      if (!protocol_http_1.HttpRequest.isInstance(request2))
        return next(args);
      const { headers } = request2;
      const userAgent = ((_a = context === null || context === void 0 ? void 0 : context.userAgent) === null || _a === void 0 ? void 0 : _a.map(escapeUserAgent)) || [];
      const defaultUserAgent = (await options.defaultUserAgentProvider()).map(escapeUserAgent);
      const customUserAgent = ((_b = options === null || options === void 0 ? void 0 : options.customUserAgent) === null || _b === void 0 ? void 0 : _b.map(escapeUserAgent)) || [];
      const prefix = (0, util_endpoints_1.getUserAgentPrefix)();
      const sdkUserAgentValue = (prefix ? [prefix] : []).concat([...defaultUserAgent, ...userAgent, ...customUserAgent]).join(constants_1.SPACE);
      const normalUAValue = [
        ...defaultUserAgent.filter((section) => section.startsWith("aws-sdk-")),
        ...customUserAgent
      ].join(constants_1.SPACE);
      if (options.runtime !== "browser") {
        if (normalUAValue) {
          headers[constants_1.X_AMZ_USER_AGENT] = headers[constants_1.X_AMZ_USER_AGENT] ? `${headers[constants_1.USER_AGENT]} ${normalUAValue}` : normalUAValue;
        }
        headers[constants_1.USER_AGENT] = sdkUserAgentValue;
      } else {
        headers[constants_1.X_AMZ_USER_AGENT] = sdkUserAgentValue;
      }
      return next({
        ...args,
        request: request2
      });
    };
    exports2.userAgentMiddleware = userAgentMiddleware;
    var escapeUserAgent = (userAgentPair) => {
      var _a;
      const name = userAgentPair[0].split(constants_1.UA_NAME_SEPARATOR).map((part) => part.replace(constants_1.UA_NAME_ESCAPE_REGEX, constants_1.UA_ESCAPE_CHAR)).join(constants_1.UA_NAME_SEPARATOR);
      const version2 = (_a = userAgentPair[1]) === null || _a === void 0 ? void 0 : _a.replace(constants_1.UA_VALUE_ESCAPE_REGEX, constants_1.UA_ESCAPE_CHAR);
      const prefixSeparatorIndex = name.indexOf(constants_1.UA_NAME_SEPARATOR);
      const prefix = name.substring(0, prefixSeparatorIndex);
      let uaName = name.substring(prefixSeparatorIndex + 1);
      if (prefix === "api") {
        uaName = uaName.toLowerCase();
      }
      return [prefix, uaName, version2].filter((item) => item && item.length > 0).reduce((acc, item, index) => {
        switch (index) {
          case 0:
            return item;
          case 1:
            return `${acc}/${item}`;
          default:
            return `${acc}#${item}`;
        }
      }, "");
    };
    exports2.getUserAgentMiddlewareOptions = {
      name: "getUserAgentMiddleware",
      step: "build",
      priority: "low",
      tags: ["SET_USER_AGENT", "USER_AGENT"],
      override: true
    };
    var getUserAgentPlugin = (config) => ({
      applyToStack: (clientStack) => {
        clientStack.add((0, exports2.userAgentMiddleware)(config), exports2.getUserAgentMiddlewareOptions);
      }
    });
    exports2.getUserAgentPlugin = getUserAgentPlugin;
  }
});

// ../../../node_modules/@aws-sdk/middleware-user-agent/dist-cjs/index.js
var require_dist_cjs17 = __commonJS({
  "../../../node_modules/@aws-sdk/middleware-user-agent/dist-cjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_configurations(), exports2);
    tslib_1.__exportStar(require_user_agent_middleware(), exports2);
  }
});

// ../../../node_modules/@smithy/util-config-provider/dist-cjs/index.js
var require_dist_cjs18 = __commonJS({
  "../../../node_modules/@smithy/util-config-provider/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      SelectorType: () => SelectorType,
      booleanSelector: () => booleanSelector,
      numberSelector: () => numberSelector
    });
    module2.exports = __toCommonJS2(src_exports);
    var booleanSelector = /* @__PURE__ */ __name((obj, key, type) => {
      if (!(key in obj))
        return void 0;
      if (obj[key] === "true")
        return true;
      if (obj[key] === "false")
        return false;
      throw new Error(`Cannot load ${type} "${key}". Expected "true" or "false", got ${obj[key]}.`);
    }, "booleanSelector");
    var numberSelector = /* @__PURE__ */ __name((obj, key, type) => {
      if (!(key in obj))
        return void 0;
      const numberValue = parseInt(obj[key], 10);
      if (Number.isNaN(numberValue)) {
        throw new TypeError(`Cannot load ${type} '${key}'. Expected number, got '${obj[key]}'.`);
      }
      return numberValue;
    }, "numberSelector");
    var SelectorType = /* @__PURE__ */ ((SelectorType2) => {
      SelectorType2["ENV"] = "env";
      SelectorType2["CONFIG"] = "shared config entry";
      return SelectorType2;
    })(SelectorType || {});
  }
});

// ../../../node_modules/@smithy/config-resolver/dist-cjs/index.js
var require_dist_cjs19 = __commonJS({
  "../../../node_modules/@smithy/config-resolver/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      CONFIG_USE_DUALSTACK_ENDPOINT: () => CONFIG_USE_DUALSTACK_ENDPOINT,
      CONFIG_USE_FIPS_ENDPOINT: () => CONFIG_USE_FIPS_ENDPOINT,
      DEFAULT_USE_DUALSTACK_ENDPOINT: () => DEFAULT_USE_DUALSTACK_ENDPOINT,
      DEFAULT_USE_FIPS_ENDPOINT: () => DEFAULT_USE_FIPS_ENDPOINT,
      ENV_USE_DUALSTACK_ENDPOINT: () => ENV_USE_DUALSTACK_ENDPOINT,
      ENV_USE_FIPS_ENDPOINT: () => ENV_USE_FIPS_ENDPOINT,
      NODE_REGION_CONFIG_FILE_OPTIONS: () => NODE_REGION_CONFIG_FILE_OPTIONS,
      NODE_REGION_CONFIG_OPTIONS: () => NODE_REGION_CONFIG_OPTIONS,
      NODE_USE_DUALSTACK_ENDPOINT_CONFIG_OPTIONS: () => NODE_USE_DUALSTACK_ENDPOINT_CONFIG_OPTIONS,
      NODE_USE_FIPS_ENDPOINT_CONFIG_OPTIONS: () => NODE_USE_FIPS_ENDPOINT_CONFIG_OPTIONS,
      REGION_ENV_NAME: () => REGION_ENV_NAME,
      REGION_INI_NAME: () => REGION_INI_NAME,
      getRegionInfo: () => getRegionInfo,
      resolveCustomEndpointsConfig: () => resolveCustomEndpointsConfig,
      resolveEndpointsConfig: () => resolveEndpointsConfig,
      resolveRegionConfig: () => resolveRegionConfig
    });
    module2.exports = __toCommonJS2(src_exports);
    var import_util_config_provider = require_dist_cjs18();
    var ENV_USE_DUALSTACK_ENDPOINT = "AWS_USE_DUALSTACK_ENDPOINT";
    var CONFIG_USE_DUALSTACK_ENDPOINT = "use_dualstack_endpoint";
    var DEFAULT_USE_DUALSTACK_ENDPOINT = false;
    var NODE_USE_DUALSTACK_ENDPOINT_CONFIG_OPTIONS = {
      environmentVariableSelector: (env) => (0, import_util_config_provider.booleanSelector)(env, ENV_USE_DUALSTACK_ENDPOINT, import_util_config_provider.SelectorType.ENV),
      configFileSelector: (profile) => (0, import_util_config_provider.booleanSelector)(profile, CONFIG_USE_DUALSTACK_ENDPOINT, import_util_config_provider.SelectorType.CONFIG),
      default: false
    };
    var ENV_USE_FIPS_ENDPOINT = "AWS_USE_FIPS_ENDPOINT";
    var CONFIG_USE_FIPS_ENDPOINT = "use_fips_endpoint";
    var DEFAULT_USE_FIPS_ENDPOINT = false;
    var NODE_USE_FIPS_ENDPOINT_CONFIG_OPTIONS = {
      environmentVariableSelector: (env) => (0, import_util_config_provider.booleanSelector)(env, ENV_USE_FIPS_ENDPOINT, import_util_config_provider.SelectorType.ENV),
      configFileSelector: (profile) => (0, import_util_config_provider.booleanSelector)(profile, CONFIG_USE_FIPS_ENDPOINT, import_util_config_provider.SelectorType.CONFIG),
      default: false
    };
    var import_util_middleware = require_dist_cjs7();
    var resolveCustomEndpointsConfig = /* @__PURE__ */ __name((input) => {
      const { endpoint, urlParser } = input;
      return {
        ...input,
        tls: input.tls ?? true,
        endpoint: (0, import_util_middleware.normalizeProvider)(typeof endpoint === "string" ? urlParser(endpoint) : endpoint),
        isCustomEndpoint: true,
        useDualstackEndpoint: (0, import_util_middleware.normalizeProvider)(input.useDualstackEndpoint ?? false)
      };
    }, "resolveCustomEndpointsConfig");
    var getEndpointFromRegion = /* @__PURE__ */ __name(async (input) => {
      const { tls = true } = input;
      const region = await input.region();
      const dnsHostRegex = new RegExp(/^([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]{0,61}[a-zA-Z0-9])$/);
      if (!dnsHostRegex.test(region)) {
        throw new Error("Invalid region in client config");
      }
      const useDualstackEndpoint = await input.useDualstackEndpoint();
      const useFipsEndpoint = await input.useFipsEndpoint();
      const { hostname } = await input.regionInfoProvider(region, { useDualstackEndpoint, useFipsEndpoint }) ?? {};
      if (!hostname) {
        throw new Error("Cannot resolve hostname from client config");
      }
      return input.urlParser(`${tls ? "https:" : "http:"}//${hostname}`);
    }, "getEndpointFromRegion");
    var resolveEndpointsConfig = /* @__PURE__ */ __name((input) => {
      const useDualstackEndpoint = (0, import_util_middleware.normalizeProvider)(input.useDualstackEndpoint ?? false);
      const { endpoint, useFipsEndpoint, urlParser } = input;
      return {
        ...input,
        tls: input.tls ?? true,
        endpoint: endpoint ? (0, import_util_middleware.normalizeProvider)(typeof endpoint === "string" ? urlParser(endpoint) : endpoint) : () => getEndpointFromRegion({ ...input, useDualstackEndpoint, useFipsEndpoint }),
        isCustomEndpoint: !!endpoint,
        useDualstackEndpoint
      };
    }, "resolveEndpointsConfig");
    var REGION_ENV_NAME = "AWS_REGION";
    var REGION_INI_NAME = "region";
    var NODE_REGION_CONFIG_OPTIONS = {
      environmentVariableSelector: (env) => env[REGION_ENV_NAME],
      configFileSelector: (profile) => profile[REGION_INI_NAME],
      default: () => {
        throw new Error("Region is missing");
      }
    };
    var NODE_REGION_CONFIG_FILE_OPTIONS = {
      preferredFile: "credentials"
    };
    var isFipsRegion = /* @__PURE__ */ __name((region) => typeof region === "string" && (region.startsWith("fips-") || region.endsWith("-fips")), "isFipsRegion");
    var getRealRegion = /* @__PURE__ */ __name((region) => isFipsRegion(region) ? ["fips-aws-global", "aws-fips"].includes(region) ? "us-east-1" : region.replace(/fips-(dkr-|prod-)?|-fips/, "") : region, "getRealRegion");
    var resolveRegionConfig = /* @__PURE__ */ __name((input) => {
      const { region, useFipsEndpoint } = input;
      if (!region) {
        throw new Error("Region is missing");
      }
      return {
        ...input,
        region: async () => {
          if (typeof region === "string") {
            return getRealRegion(region);
          }
          const providedRegion = await region();
          return getRealRegion(providedRegion);
        },
        useFipsEndpoint: async () => {
          const providedRegion = typeof region === "string" ? region : await region();
          if (isFipsRegion(providedRegion)) {
            return true;
          }
          return typeof useFipsEndpoint !== "function" ? Promise.resolve(!!useFipsEndpoint) : useFipsEndpoint();
        }
      };
    }, "resolveRegionConfig");
    var getHostnameFromVariants = /* @__PURE__ */ __name((variants = [], { useFipsEndpoint, useDualstackEndpoint }) => {
      var _a;
      return (_a = variants.find(
        ({ tags }) => useFipsEndpoint === tags.includes("fips") && useDualstackEndpoint === tags.includes("dualstack")
      )) == null ? void 0 : _a.hostname;
    }, "getHostnameFromVariants");
    var getResolvedHostname = /* @__PURE__ */ __name((resolvedRegion, { regionHostname, partitionHostname }) => regionHostname ? regionHostname : partitionHostname ? partitionHostname.replace("{region}", resolvedRegion) : void 0, "getResolvedHostname");
    var getResolvedPartition = /* @__PURE__ */ __name((region, { partitionHash }) => Object.keys(partitionHash || {}).find((key) => partitionHash[key].regions.includes(region)) ?? "aws", "getResolvedPartition");
    var getResolvedSigningRegion = /* @__PURE__ */ __name((hostname, { signingRegion, regionRegex, useFipsEndpoint }) => {
      if (signingRegion) {
        return signingRegion;
      } else if (useFipsEndpoint) {
        const regionRegexJs = regionRegex.replace("\\\\", "\\").replace(/^\^/g, "\\.").replace(/\$$/g, "\\.");
        const regionRegexmatchArray = hostname.match(regionRegexJs);
        if (regionRegexmatchArray) {
          return regionRegexmatchArray[0].slice(1, -1);
        }
      }
    }, "getResolvedSigningRegion");
    var getRegionInfo = /* @__PURE__ */ __name((region, {
      useFipsEndpoint = false,
      useDualstackEndpoint = false,
      signingService,
      regionHash,
      partitionHash
    }) => {
      var _a, _b, _c, _d, _e;
      const partition = getResolvedPartition(region, { partitionHash });
      const resolvedRegion = region in regionHash ? region : ((_a = partitionHash[partition]) == null ? void 0 : _a.endpoint) ?? region;
      const hostnameOptions = { useFipsEndpoint, useDualstackEndpoint };
      const regionHostname = getHostnameFromVariants((_b = regionHash[resolvedRegion]) == null ? void 0 : _b.variants, hostnameOptions);
      const partitionHostname = getHostnameFromVariants((_c = partitionHash[partition]) == null ? void 0 : _c.variants, hostnameOptions);
      const hostname = getResolvedHostname(resolvedRegion, { regionHostname, partitionHostname });
      if (hostname === void 0) {
        throw new Error(`Endpoint resolution failed for: ${{ resolvedRegion, useFipsEndpoint, useDualstackEndpoint }}`);
      }
      const signingRegion = getResolvedSigningRegion(hostname, {
        signingRegion: (_d = regionHash[resolvedRegion]) == null ? void 0 : _d.signingRegion,
        regionRegex: partitionHash[partition].regionRegex,
        useFipsEndpoint
      });
      return {
        partition,
        signingService,
        hostname,
        ...signingRegion && { signingRegion },
        ...((_e = regionHash[resolvedRegion]) == null ? void 0 : _e.signingService) && {
          signingService: regionHash[resolvedRegion].signingService
        }
      };
    }, "getRegionInfo");
  }
});

// ../../../node_modules/@smithy/middleware-content-length/dist-cjs/index.js
var require_dist_cjs20 = __commonJS({
  "../../../node_modules/@smithy/middleware-content-length/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      contentLengthMiddleware: () => contentLengthMiddleware,
      contentLengthMiddlewareOptions: () => contentLengthMiddlewareOptions,
      getContentLengthPlugin: () => getContentLengthPlugin
    });
    module2.exports = __toCommonJS2(src_exports);
    var import_protocol_http = require_dist_cjs2();
    var CONTENT_LENGTH_HEADER = "content-length";
    function contentLengthMiddleware(bodyLengthChecker) {
      return (next) => async (args) => {
        const request2 = args.request;
        if (import_protocol_http.HttpRequest.isInstance(request2)) {
          const { body, headers } = request2;
          if (body && Object.keys(headers).map((str) => str.toLowerCase()).indexOf(CONTENT_LENGTH_HEADER) === -1) {
            try {
              const length = bodyLengthChecker(body);
              request2.headers = {
                ...request2.headers,
                [CONTENT_LENGTH_HEADER]: String(length)
              };
            } catch (error) {
            }
          }
        }
        return next({
          ...args,
          request: request2
        });
      };
    }
    __name(contentLengthMiddleware, "contentLengthMiddleware");
    var contentLengthMiddlewareOptions = {
      step: "build",
      tags: ["SET_CONTENT_LENGTH", "CONTENT_LENGTH"],
      name: "contentLengthMiddleware",
      override: true
    };
    var getContentLengthPlugin = /* @__PURE__ */ __name((options) => ({
      applyToStack: (clientStack) => {
        clientStack.add(contentLengthMiddleware(options.bodyLengthChecker), contentLengthMiddlewareOptions);
      }
    }), "getContentLengthPlugin");
  }
});

// ../../../node_modules/@smithy/shared-ini-file-loader/dist-cjs/getHomeDir.js
var require_getHomeDir = __commonJS({
  "../../../node_modules/@smithy/shared-ini-file-loader/dist-cjs/getHomeDir.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getHomeDir = void 0;
    var os_1 = require("os");
    var path_1 = require("path");
    var homeDirCache = {};
    var getHomeDirCacheKey = () => {
      if (process && process.geteuid) {
        return `${process.geteuid()}`;
      }
      return "DEFAULT";
    };
    var getHomeDir2 = () => {
      const { HOME, USERPROFILE, HOMEPATH, HOMEDRIVE = `C:${path_1.sep}` } = process.env;
      if (HOME)
        return HOME;
      if (USERPROFILE)
        return USERPROFILE;
      if (HOMEPATH)
        return `${HOMEDRIVE}${HOMEPATH}`;
      const homeDirCacheKey = getHomeDirCacheKey();
      if (!homeDirCache[homeDirCacheKey])
        homeDirCache[homeDirCacheKey] = (0, os_1.homedir)();
      return homeDirCache[homeDirCacheKey];
    };
    exports2.getHomeDir = getHomeDir2;
  }
});

// ../../../node_modules/@smithy/shared-ini-file-loader/dist-cjs/getSSOTokenFilepath.js
var require_getSSOTokenFilepath = __commonJS({
  "../../../node_modules/@smithy/shared-ini-file-loader/dist-cjs/getSSOTokenFilepath.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getSSOTokenFilepath = void 0;
    var crypto_1 = require("crypto");
    var path_1 = require("path");
    var getHomeDir_1 = require_getHomeDir();
    var getSSOTokenFilepath2 = (id) => {
      const hasher = (0, crypto_1.createHash)("sha1");
      const cacheName = hasher.update(id).digest("hex");
      return (0, path_1.join)((0, getHomeDir_1.getHomeDir)(), ".aws", "sso", "cache", `${cacheName}.json`);
    };
    exports2.getSSOTokenFilepath = getSSOTokenFilepath2;
  }
});

// ../../../node_modules/@smithy/shared-ini-file-loader/dist-cjs/getSSOTokenFromFile.js
var require_getSSOTokenFromFile = __commonJS({
  "../../../node_modules/@smithy/shared-ini-file-loader/dist-cjs/getSSOTokenFromFile.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getSSOTokenFromFile = void 0;
    var fs_1 = require("fs");
    var getSSOTokenFilepath_1 = require_getSSOTokenFilepath();
    var { readFile } = fs_1.promises;
    var getSSOTokenFromFile2 = async (id) => {
      const ssoTokenFilepath = (0, getSSOTokenFilepath_1.getSSOTokenFilepath)(id);
      const ssoTokenText = await readFile(ssoTokenFilepath, "utf8");
      return JSON.parse(ssoTokenText);
    };
    exports2.getSSOTokenFromFile = getSSOTokenFromFile2;
  }
});

// ../../../node_modules/@smithy/shared-ini-file-loader/dist-cjs/slurpFile.js
var require_slurpFile = __commonJS({
  "../../../node_modules/@smithy/shared-ini-file-loader/dist-cjs/slurpFile.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.slurpFile = void 0;
    var fs_1 = require("fs");
    var { readFile } = fs_1.promises;
    var filePromisesHash = {};
    var slurpFile = (path, options) => {
      if (!filePromisesHash[path] || (options === null || options === void 0 ? void 0 : options.ignoreCache)) {
        filePromisesHash[path] = readFile(path, "utf8");
      }
      return filePromisesHash[path];
    };
    exports2.slurpFile = slurpFile;
  }
});

// ../../../node_modules/@smithy/shared-ini-file-loader/dist-cjs/index.js
var require_dist_cjs21 = __commonJS({
  "../../../node_modules/@smithy/shared-ini-file-loader/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __reExport = (target, mod, secondTarget) => (__copyProps2(target, mod, "default"), secondTarget && __copyProps2(secondTarget, mod, "default"));
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      CONFIG_PREFIX_SEPARATOR: () => CONFIG_PREFIX_SEPARATOR,
      DEFAULT_PROFILE: () => DEFAULT_PROFILE,
      ENV_PROFILE: () => ENV_PROFILE,
      getProfileName: () => getProfileName,
      loadSharedConfigFiles: () => loadSharedConfigFiles,
      loadSsoSessionData: () => loadSsoSessionData,
      parseKnownFiles: () => parseKnownFiles
    });
    module2.exports = __toCommonJS2(src_exports);
    __reExport(src_exports, require_getHomeDir(), module2.exports);
    var ENV_PROFILE = "AWS_PROFILE";
    var DEFAULT_PROFILE = "default";
    var getProfileName = /* @__PURE__ */ __name((init) => init.profile || process.env[ENV_PROFILE] || DEFAULT_PROFILE, "getProfileName");
    __reExport(src_exports, require_getSSOTokenFilepath(), module2.exports);
    __reExport(src_exports, require_getSSOTokenFromFile(), module2.exports);
    var import_types = require_dist_cjs();
    var getConfigData = /* @__PURE__ */ __name((data) => Object.entries(data).filter(([key]) => {
      const indexOfSeparator = key.indexOf(CONFIG_PREFIX_SEPARATOR);
      if (indexOfSeparator === -1) {
        return false;
      }
      return Object.values(import_types.IniSectionType).includes(key.substring(0, indexOfSeparator));
    }).reduce(
      (acc, [key, value]) => {
        const indexOfSeparator = key.indexOf(CONFIG_PREFIX_SEPARATOR);
        const updatedKey = key.substring(0, indexOfSeparator) === import_types.IniSectionType.PROFILE ? key.substring(indexOfSeparator + 1) : key;
        acc[updatedKey] = value;
        return acc;
      },
      {
        // Populate default profile, if present.
        ...data.default && { default: data.default }
      }
    ), "getConfigData");
    var import_path = require("path");
    var import_getHomeDir = require_getHomeDir();
    var ENV_CONFIG_PATH = "AWS_CONFIG_FILE";
    var getConfigFilepath = /* @__PURE__ */ __name(() => process.env[ENV_CONFIG_PATH] || (0, import_path.join)((0, import_getHomeDir.getHomeDir)(), ".aws", "config"), "getConfigFilepath");
    var import_getHomeDir2 = require_getHomeDir();
    var ENV_CREDENTIALS_PATH = "AWS_SHARED_CREDENTIALS_FILE";
    var getCredentialsFilepath = /* @__PURE__ */ __name(() => process.env[ENV_CREDENTIALS_PATH] || (0, import_path.join)((0, import_getHomeDir2.getHomeDir)(), ".aws", "credentials"), "getCredentialsFilepath");
    var prefixKeyRegex = /^([\w-]+)\s(["'])?([\w-@\+\.%:/]+)\2$/;
    var profileNameBlockList = ["__proto__", "profile __proto__"];
    var parseIni = /* @__PURE__ */ __name((iniData) => {
      const map = {};
      let currentSection;
      let currentSubSection;
      for (const iniLine of iniData.split(/\r?\n/)) {
        const trimmedLine = iniLine.split(/(^|\s)[;#]/)[0].trim();
        const isSection = trimmedLine[0] === "[" && trimmedLine[trimmedLine.length - 1] === "]";
        if (isSection) {
          currentSection = void 0;
          currentSubSection = void 0;
          const sectionName = trimmedLine.substring(1, trimmedLine.length - 1);
          const matches = prefixKeyRegex.exec(sectionName);
          if (matches) {
            const [, prefix, , name] = matches;
            if (Object.values(import_types.IniSectionType).includes(prefix)) {
              currentSection = [prefix, name].join(CONFIG_PREFIX_SEPARATOR);
            }
          } else {
            currentSection = sectionName;
          }
          if (profileNameBlockList.includes(sectionName)) {
            throw new Error(`Found invalid profile name "${sectionName}"`);
          }
        } else if (currentSection) {
          const indexOfEqualsSign = trimmedLine.indexOf("=");
          if (![0, -1].includes(indexOfEqualsSign)) {
            const [name, value] = [
              trimmedLine.substring(0, indexOfEqualsSign).trim(),
              trimmedLine.substring(indexOfEqualsSign + 1).trim()
            ];
            if (value === "") {
              currentSubSection = name;
            } else {
              if (currentSubSection && iniLine.trimStart() === iniLine) {
                currentSubSection = void 0;
              }
              map[currentSection] = map[currentSection] || {};
              const key = currentSubSection ? [currentSubSection, name].join(CONFIG_PREFIX_SEPARATOR) : name;
              map[currentSection][key] = value;
            }
          }
        }
      }
      return map;
    }, "parseIni");
    var import_slurpFile = require_slurpFile();
    var swallowError = /* @__PURE__ */ __name(() => ({}), "swallowError");
    var CONFIG_PREFIX_SEPARATOR = ".";
    var loadSharedConfigFiles = /* @__PURE__ */ __name(async (init = {}) => {
      const { filepath = getCredentialsFilepath(), configFilepath = getConfigFilepath() } = init;
      const parsedFiles = await Promise.all([
        (0, import_slurpFile.slurpFile)(configFilepath, {
          ignoreCache: init.ignoreCache
        }).then(parseIni).then(getConfigData).catch(swallowError),
        (0, import_slurpFile.slurpFile)(filepath, {
          ignoreCache: init.ignoreCache
        }).then(parseIni).catch(swallowError)
      ]);
      return {
        configFile: parsedFiles[0],
        credentialsFile: parsedFiles[1]
      };
    }, "loadSharedConfigFiles");
    var getSsoSessionData = /* @__PURE__ */ __name((data) => Object.entries(data).filter(([key]) => key.startsWith(import_types.IniSectionType.SSO_SESSION + CONFIG_PREFIX_SEPARATOR)).reduce((acc, [key, value]) => ({ ...acc, [key.substring(key.indexOf(CONFIG_PREFIX_SEPARATOR) + 1)]: value }), {}), "getSsoSessionData");
    var import_slurpFile2 = require_slurpFile();
    var swallowError2 = /* @__PURE__ */ __name(() => ({}), "swallowError");
    var loadSsoSessionData = /* @__PURE__ */ __name(async (init = {}) => (0, import_slurpFile2.slurpFile)(init.configFilepath ?? getConfigFilepath()).then(parseIni).then(getSsoSessionData).catch(swallowError2), "loadSsoSessionData");
    var mergeConfigFiles = /* @__PURE__ */ __name((...files) => {
      const merged = {};
      for (const file of files) {
        for (const [key, values] of Object.entries(file)) {
          if (merged[key] !== void 0) {
            Object.assign(merged[key], values);
          } else {
            merged[key] = values;
          }
        }
      }
      return merged;
    }, "mergeConfigFiles");
    var parseKnownFiles = /* @__PURE__ */ __name(async (init) => {
      const parsedFiles = await loadSharedConfigFiles(init);
      return mergeConfigFiles(parsedFiles.configFile, parsedFiles.credentialsFile);
    }, "parseKnownFiles");
  }
});

// ../../../node_modules/@smithy/node-config-provider/dist-cjs/index.js
var require_dist_cjs22 = __commonJS({
  "../../../node_modules/@smithy/node-config-provider/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      loadConfig: () => loadConfig
    });
    module2.exports = __toCommonJS2(src_exports);
    var import_property_provider = require_dist_cjs6();
    var fromEnv = /* @__PURE__ */ __name((envVarSelector) => async () => {
      try {
        const config = envVarSelector(process.env);
        if (config === void 0) {
          throw new Error();
        }
        return config;
      } catch (e) {
        throw new import_property_provider.CredentialsProviderError(
          e.message || `Cannot load config from environment variables with getter: ${envVarSelector}`
        );
      }
    }, "fromEnv");
    var import_shared_ini_file_loader = require_dist_cjs21();
    var fromSharedConfigFiles = /* @__PURE__ */ __name((configSelector, { preferredFile = "config", ...init } = {}) => async () => {
      const profile = (0, import_shared_ini_file_loader.getProfileName)(init);
      const { configFile, credentialsFile } = await (0, import_shared_ini_file_loader.loadSharedConfigFiles)(init);
      const profileFromCredentials = credentialsFile[profile] || {};
      const profileFromConfig = configFile[profile] || {};
      const mergedProfile = preferredFile === "config" ? { ...profileFromCredentials, ...profileFromConfig } : { ...profileFromConfig, ...profileFromCredentials };
      try {
        const cfgFile = preferredFile === "config" ? configFile : credentialsFile;
        const configValue = configSelector(mergedProfile, cfgFile);
        if (configValue === void 0) {
          throw new Error();
        }
        return configValue;
      } catch (e) {
        throw new import_property_provider.CredentialsProviderError(
          e.message || `Cannot load config for profile ${profile} in SDK configuration files with getter: ${configSelector}`
        );
      }
    }, "fromSharedConfigFiles");
    var isFunction = /* @__PURE__ */ __name((func) => typeof func === "function", "isFunction");
    var fromStatic = /* @__PURE__ */ __name((defaultValue) => isFunction(defaultValue) ? async () => await defaultValue() : (0, import_property_provider.fromStatic)(defaultValue), "fromStatic");
    var loadConfig = /* @__PURE__ */ __name(({ environmentVariableSelector, configFileSelector, default: defaultValue }, configuration = {}) => (0, import_property_provider.memoize)(
      (0, import_property_provider.chain)(
        fromEnv(environmentVariableSelector),
        fromSharedConfigFiles(configFileSelector, configuration),
        fromStatic(defaultValue)
      )
    ), "loadConfig");
  }
});

// ../../../node_modules/@smithy/middleware-endpoint/dist-cjs/adaptors/getEndpointUrlConfig.js
var require_getEndpointUrlConfig = __commonJS({
  "../../../node_modules/@smithy/middleware-endpoint/dist-cjs/adaptors/getEndpointUrlConfig.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getEndpointUrlConfig = void 0;
    var shared_ini_file_loader_1 = require_dist_cjs21();
    var ENV_ENDPOINT_URL = "AWS_ENDPOINT_URL";
    var CONFIG_ENDPOINT_URL = "endpoint_url";
    var getEndpointUrlConfig = (serviceId) => ({
      environmentVariableSelector: (env) => {
        const serviceSuffixParts = serviceId.split(" ").map((w) => w.toUpperCase());
        const serviceEndpointUrl = env[[ENV_ENDPOINT_URL, ...serviceSuffixParts].join("_")];
        if (serviceEndpointUrl)
          return serviceEndpointUrl;
        const endpointUrl = env[ENV_ENDPOINT_URL];
        if (endpointUrl)
          return endpointUrl;
        return void 0;
      },
      configFileSelector: (profile, config) => {
        if (config && profile.services) {
          const servicesSection = config[["services", profile.services].join(shared_ini_file_loader_1.CONFIG_PREFIX_SEPARATOR)];
          if (servicesSection) {
            const servicePrefixParts = serviceId.split(" ").map((w) => w.toLowerCase());
            const endpointUrl2 = servicesSection[[servicePrefixParts.join("_"), CONFIG_ENDPOINT_URL].join(shared_ini_file_loader_1.CONFIG_PREFIX_SEPARATOR)];
            if (endpointUrl2)
              return endpointUrl2;
          }
        }
        const endpointUrl = profile[CONFIG_ENDPOINT_URL];
        if (endpointUrl)
          return endpointUrl;
        return void 0;
      },
      default: void 0
    });
    exports2.getEndpointUrlConfig = getEndpointUrlConfig;
  }
});

// ../../../node_modules/@smithy/middleware-endpoint/dist-cjs/adaptors/getEndpointFromConfig.js
var require_getEndpointFromConfig = __commonJS({
  "../../../node_modules/@smithy/middleware-endpoint/dist-cjs/adaptors/getEndpointFromConfig.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getEndpointFromConfig = void 0;
    var node_config_provider_1 = require_dist_cjs22();
    var getEndpointUrlConfig_1 = require_getEndpointUrlConfig();
    var getEndpointFromConfig = async (serviceId) => (0, node_config_provider_1.loadConfig)((0, getEndpointUrlConfig_1.getEndpointUrlConfig)(serviceId))();
    exports2.getEndpointFromConfig = getEndpointFromConfig;
  }
});

// ../../../node_modules/@smithy/querystring-parser/dist-cjs/index.js
var require_dist_cjs23 = __commonJS({
  "../../../node_modules/@smithy/querystring-parser/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      parseQueryString: () => parseQueryString
    });
    module2.exports = __toCommonJS2(src_exports);
    function parseQueryString(querystring) {
      const query = {};
      querystring = querystring.replace(/^\?/, "");
      if (querystring) {
        for (const pair of querystring.split("&")) {
          let [key, value = null] = pair.split("=");
          key = decodeURIComponent(key);
          if (value) {
            value = decodeURIComponent(value);
          }
          if (!(key in query)) {
            query[key] = value;
          } else if (Array.isArray(query[key])) {
            query[key].push(value);
          } else {
            query[key] = [query[key], value];
          }
        }
      }
      return query;
    }
    __name(parseQueryString, "parseQueryString");
  }
});

// ../../../node_modules/@smithy/url-parser/dist-cjs/index.js
var require_dist_cjs24 = __commonJS({
  "../../../node_modules/@smithy/url-parser/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      parseUrl: () => parseUrl
    });
    module2.exports = __toCommonJS2(src_exports);
    var import_querystring_parser = require_dist_cjs23();
    var parseUrl = /* @__PURE__ */ __name((url2) => {
      if (typeof url2 === "string") {
        return parseUrl(new URL(url2));
      }
      const { hostname, pathname, port, protocol, search } = url2;
      let query;
      if (search) {
        query = (0, import_querystring_parser.parseQueryString)(search);
      }
      return {
        hostname,
        port: port ? parseInt(port) : void 0,
        protocol,
        path: pathname,
        query
      };
    }, "parseUrl");
  }
});

// ../../../node_modules/@smithy/middleware-serde/dist-cjs/index.js
var require_dist_cjs25 = __commonJS({
  "../../../node_modules/@smithy/middleware-serde/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      deserializerMiddleware: () => deserializerMiddleware,
      deserializerMiddlewareOption: () => deserializerMiddlewareOption,
      getSerdePlugin: () => getSerdePlugin,
      serializerMiddleware: () => serializerMiddleware,
      serializerMiddlewareOption: () => serializerMiddlewareOption
    });
    module2.exports = __toCommonJS2(src_exports);
    var deserializerMiddleware = /* @__PURE__ */ __name((options, deserializer) => (next, context) => async (args) => {
      const { response } = await next(args);
      try {
        const parsed = await deserializer(response, options);
        return {
          response,
          output: parsed
        };
      } catch (error) {
        Object.defineProperty(error, "$response", {
          value: response
        });
        if (!("$metadata" in error)) {
          const hint = `Deserialization error: to see the raw response, inspect the hidden field {error}.$response on this object.`;
          error.message += "\n  " + hint;
          if (typeof error.$responseBodyText !== "undefined") {
            if (error.$response) {
              error.$response.body = error.$responseBodyText;
            }
          }
        }
        throw error;
      }
    }, "deserializerMiddleware");
    var serializerMiddleware = /* @__PURE__ */ __name((options, serializer) => (next, context) => async (args) => {
      var _a;
      const endpoint = ((_a = context.endpointV2) == null ? void 0 : _a.url) && options.urlParser ? async () => options.urlParser(context.endpointV2.url) : options.endpoint;
      if (!endpoint) {
        throw new Error("No valid endpoint provider available.");
      }
      const request2 = await serializer(args.input, { ...options, endpoint });
      return next({
        ...args,
        request: request2
      });
    }, "serializerMiddleware");
    var deserializerMiddlewareOption = {
      name: "deserializerMiddleware",
      step: "deserialize",
      tags: ["DESERIALIZER"],
      override: true
    };
    var serializerMiddlewareOption = {
      name: "serializerMiddleware",
      step: "serialize",
      tags: ["SERIALIZER"],
      override: true
    };
    function getSerdePlugin(config, serializer, deserializer) {
      return {
        applyToStack: (commandStack) => {
          commandStack.add(deserializerMiddleware(config, deserializer), deserializerMiddlewareOption);
          commandStack.add(serializerMiddleware(config, serializer), serializerMiddlewareOption);
        }
      };
    }
    __name(getSerdePlugin, "getSerdePlugin");
  }
});

// ../../../node_modules/@smithy/middleware-endpoint/dist-cjs/index.js
var require_dist_cjs26 = __commonJS({
  "../../../node_modules/@smithy/middleware-endpoint/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      endpointMiddleware: () => endpointMiddleware,
      endpointMiddlewareOptions: () => endpointMiddlewareOptions,
      getEndpointFromInstructions: () => getEndpointFromInstructions,
      getEndpointPlugin: () => getEndpointPlugin,
      resolveEndpointConfig: () => resolveEndpointConfig,
      resolveParams: () => resolveParams,
      toEndpointV1: () => toEndpointV1
    });
    module2.exports = __toCommonJS2(src_exports);
    var resolveParamsForS3 = /* @__PURE__ */ __name(async (endpointParams) => {
      const bucket = (endpointParams == null ? void 0 : endpointParams.Bucket) || "";
      if (typeof endpointParams.Bucket === "string") {
        endpointParams.Bucket = bucket.replace(/#/g, encodeURIComponent("#")).replace(/\?/g, encodeURIComponent("?"));
      }
      if (isArnBucketName(bucket)) {
        if (endpointParams.ForcePathStyle === true) {
          throw new Error("Path-style addressing cannot be used with ARN buckets");
        }
      } else if (!isDnsCompatibleBucketName(bucket) || bucket.indexOf(".") !== -1 && !String(endpointParams.Endpoint).startsWith("http:") || bucket.toLowerCase() !== bucket || bucket.length < 3) {
        endpointParams.ForcePathStyle = true;
      }
      if (endpointParams.DisableMultiRegionAccessPoints) {
        endpointParams.disableMultiRegionAccessPoints = true;
        endpointParams.DisableMRAP = true;
      }
      return endpointParams;
    }, "resolveParamsForS3");
    var DOMAIN_PATTERN = /^[a-z0-9][a-z0-9\.\-]{1,61}[a-z0-9]$/;
    var IP_ADDRESS_PATTERN = /(\d+\.){3}\d+/;
    var DOTS_PATTERN = /\.\./;
    var isDnsCompatibleBucketName = /* @__PURE__ */ __name((bucketName) => DOMAIN_PATTERN.test(bucketName) && !IP_ADDRESS_PATTERN.test(bucketName) && !DOTS_PATTERN.test(bucketName), "isDnsCompatibleBucketName");
    var isArnBucketName = /* @__PURE__ */ __name((bucketName) => {
      const [arn, partition, service, , , bucket] = bucketName.split(":");
      const isArn = arn === "arn" && bucketName.split(":").length >= 6;
      const isValidArn = Boolean(isArn && partition && service && bucket);
      if (isArn && !isValidArn) {
        throw new Error(`Invalid ARN: ${bucketName} was an invalid ARN.`);
      }
      return isValidArn;
    }, "isArnBucketName");
    var createConfigValueProvider = /* @__PURE__ */ __name((configKey, canonicalEndpointParamKey, config) => {
      const configProvider = /* @__PURE__ */ __name(async () => {
        const configValue = config[configKey] ?? config[canonicalEndpointParamKey];
        if (typeof configValue === "function") {
          return configValue();
        }
        return configValue;
      }, "configProvider");
      if (configKey === "credentialScope" || canonicalEndpointParamKey === "CredentialScope") {
        return async () => {
          const credentials = typeof config.credentials === "function" ? await config.credentials() : config.credentials;
          const configValue = (credentials == null ? void 0 : credentials.credentialScope) ?? (credentials == null ? void 0 : credentials.CredentialScope);
          return configValue;
        };
      }
      if (configKey === "endpoint" || canonicalEndpointParamKey === "endpoint") {
        return async () => {
          const endpoint = await configProvider();
          if (endpoint && typeof endpoint === "object") {
            if ("url" in endpoint) {
              return endpoint.url.href;
            }
            if ("hostname" in endpoint) {
              const { protocol, hostname, port, path } = endpoint;
              return `${protocol}//${hostname}${port ? ":" + port : ""}${path}`;
            }
          }
          return endpoint;
        };
      }
      return configProvider;
    }, "createConfigValueProvider");
    var import_getEndpointFromConfig = require_getEndpointFromConfig();
    var import_url_parser = require_dist_cjs24();
    var toEndpointV1 = /* @__PURE__ */ __name((endpoint) => {
      if (typeof endpoint === "object") {
        if ("url" in endpoint) {
          return (0, import_url_parser.parseUrl)(endpoint.url);
        }
        return endpoint;
      }
      return (0, import_url_parser.parseUrl)(endpoint);
    }, "toEndpointV1");
    var getEndpointFromInstructions = /* @__PURE__ */ __name(async (commandInput, instructionsSupplier, clientConfig, context) => {
      if (!clientConfig.endpoint) {
        const endpointFromConfig = await (0, import_getEndpointFromConfig.getEndpointFromConfig)(clientConfig.serviceId || "");
        if (endpointFromConfig) {
          clientConfig.endpoint = () => Promise.resolve(toEndpointV1(endpointFromConfig));
        }
      }
      const endpointParams = await resolveParams(commandInput, instructionsSupplier, clientConfig);
      if (typeof clientConfig.endpointProvider !== "function") {
        throw new Error("config.endpointProvider is not set.");
      }
      const endpoint = clientConfig.endpointProvider(endpointParams, context);
      return endpoint;
    }, "getEndpointFromInstructions");
    var resolveParams = /* @__PURE__ */ __name(async (commandInput, instructionsSupplier, clientConfig) => {
      var _a;
      const endpointParams = {};
      const instructions = ((_a = instructionsSupplier == null ? void 0 : instructionsSupplier.getEndpointParameterInstructions) == null ? void 0 : _a.call(instructionsSupplier)) || {};
      for (const [name, instruction] of Object.entries(instructions)) {
        switch (instruction.type) {
          case "staticContextParams":
            endpointParams[name] = instruction.value;
            break;
          case "contextParams":
            endpointParams[name] = commandInput[instruction.name];
            break;
          case "clientContextParams":
          case "builtInParams":
            endpointParams[name] = await createConfigValueProvider(instruction.name, name, clientConfig)();
            break;
          default:
            throw new Error("Unrecognized endpoint parameter instruction: " + JSON.stringify(instruction));
        }
      }
      if (Object.keys(instructions).length === 0) {
        Object.assign(endpointParams, clientConfig);
      }
      if (String(clientConfig.serviceId).toLowerCase() === "s3") {
        await resolveParamsForS3(endpointParams);
      }
      return endpointParams;
    }, "resolveParams");
    var import_util_middleware = require_dist_cjs7();
    var endpointMiddleware = /* @__PURE__ */ __name(({
      config,
      instructions
    }) => {
      return (next, context) => async (args) => {
        var _a, _b, _c;
        const endpoint = await getEndpointFromInstructions(
          args.input,
          {
            getEndpointParameterInstructions() {
              return instructions;
            }
          },
          { ...config },
          context
        );
        context.endpointV2 = endpoint;
        context.authSchemes = (_a = endpoint.properties) == null ? void 0 : _a.authSchemes;
        const authScheme = (_b = context.authSchemes) == null ? void 0 : _b[0];
        if (authScheme) {
          context["signing_region"] = authScheme.signingRegion;
          context["signing_service"] = authScheme.signingName;
          const smithyContext = (0, import_util_middleware.getSmithyContext)(context);
          const httpAuthOption = (_c = smithyContext == null ? void 0 : smithyContext.selectedHttpAuthScheme) == null ? void 0 : _c.httpAuthOption;
          if (httpAuthOption) {
            httpAuthOption.signingProperties = Object.assign(
              httpAuthOption.signingProperties || {},
              {
                signing_region: authScheme.signingRegion,
                signingRegion: authScheme.signingRegion,
                signing_service: authScheme.signingName,
                signingName: authScheme.signingName,
                signingRegionSet: authScheme.signingRegionSet
              },
              authScheme.properties
            );
          }
        }
        return next({
          ...args
        });
      };
    }, "endpointMiddleware");
    var import_middleware_serde = require_dist_cjs25();
    var endpointMiddlewareOptions = {
      step: "serialize",
      tags: ["ENDPOINT_PARAMETERS", "ENDPOINT_V2", "ENDPOINT"],
      name: "endpointV2Middleware",
      override: true,
      relation: "before",
      toMiddleware: import_middleware_serde.serializerMiddlewareOption.name
    };
    var getEndpointPlugin = /* @__PURE__ */ __name((config, instructions) => ({
      applyToStack: (clientStack) => {
        clientStack.addRelativeTo(
          endpointMiddleware({
            config,
            instructions
          }),
          endpointMiddlewareOptions
        );
      }
    }), "getEndpointPlugin");
    var resolveEndpointConfig = /* @__PURE__ */ __name((input) => {
      const tls = input.tls ?? true;
      const { endpoint } = input;
      const customEndpointProvider = endpoint != null ? async () => toEndpointV1(await (0, import_util_middleware.normalizeProvider)(endpoint)()) : void 0;
      const isCustomEndpoint = !!endpoint;
      return {
        ...input,
        endpoint: customEndpointProvider,
        tls,
        isCustomEndpoint,
        useDualstackEndpoint: (0, import_util_middleware.normalizeProvider)(input.useDualstackEndpoint ?? false),
        useFipsEndpoint: (0, import_util_middleware.normalizeProvider)(input.useFipsEndpoint ?? false)
      };
    }, "resolveEndpointConfig");
  }
});

// ../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/rng.js
function rng() {
  if (poolPtr > rnds8Pool.length - 16) {
    import_crypto.default.randomFillSync(rnds8Pool);
    poolPtr = 0;
  }
  return rnds8Pool.slice(poolPtr, poolPtr += 16);
}
var import_crypto, rnds8Pool, poolPtr;
var init_rng = __esm({
  "../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/rng.js"() {
    import_crypto = __toESM(require("crypto"));
    rnds8Pool = new Uint8Array(256);
    poolPtr = rnds8Pool.length;
  }
});

// ../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/regex.js
var regex_default;
var init_regex = __esm({
  "../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/regex.js"() {
    regex_default = /^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i;
  }
});

// ../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/validate.js
function validate(uuid) {
  return typeof uuid === "string" && regex_default.test(uuid);
}
var validate_default;
var init_validate = __esm({
  "../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/validate.js"() {
    init_regex();
    validate_default = validate;
  }
});

// ../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/stringify.js
function unsafeStringify(arr, offset = 0) {
  return byteToHex[arr[offset + 0]] + byteToHex[arr[offset + 1]] + byteToHex[arr[offset + 2]] + byteToHex[arr[offset + 3]] + "-" + byteToHex[arr[offset + 4]] + byteToHex[arr[offset + 5]] + "-" + byteToHex[arr[offset + 6]] + byteToHex[arr[offset + 7]] + "-" + byteToHex[arr[offset + 8]] + byteToHex[arr[offset + 9]] + "-" + byteToHex[arr[offset + 10]] + byteToHex[arr[offset + 11]] + byteToHex[arr[offset + 12]] + byteToHex[arr[offset + 13]] + byteToHex[arr[offset + 14]] + byteToHex[arr[offset + 15]];
}
function stringify(arr, offset = 0) {
  const uuid = unsafeStringify(arr, offset);
  if (!validate_default(uuid)) {
    throw TypeError("Stringified UUID is invalid");
  }
  return uuid;
}
var byteToHex, stringify_default;
var init_stringify = __esm({
  "../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/stringify.js"() {
    init_validate();
    byteToHex = [];
    for (let i = 0; i < 256; ++i) {
      byteToHex.push((i + 256).toString(16).slice(1));
    }
    stringify_default = stringify;
  }
});

// ../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/v1.js
function v1(options, buf, offset) {
  let i = buf && offset || 0;
  const b = buf || new Array(16);
  options = options || {};
  let node = options.node || _nodeId;
  let clockseq = options.clockseq !== void 0 ? options.clockseq : _clockseq;
  if (node == null || clockseq == null) {
    const seedBytes = options.random || (options.rng || rng)();
    if (node == null) {
      node = _nodeId = [seedBytes[0] | 1, seedBytes[1], seedBytes[2], seedBytes[3], seedBytes[4], seedBytes[5]];
    }
    if (clockseq == null) {
      clockseq = _clockseq = (seedBytes[6] << 8 | seedBytes[7]) & 16383;
    }
  }
  let msecs = options.msecs !== void 0 ? options.msecs : Date.now();
  let nsecs = options.nsecs !== void 0 ? options.nsecs : _lastNSecs + 1;
  const dt = msecs - _lastMSecs + (nsecs - _lastNSecs) / 1e4;
  if (dt < 0 && options.clockseq === void 0) {
    clockseq = clockseq + 1 & 16383;
  }
  if ((dt < 0 || msecs > _lastMSecs) && options.nsecs === void 0) {
    nsecs = 0;
  }
  if (nsecs >= 1e4) {
    throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");
  }
  _lastMSecs = msecs;
  _lastNSecs = nsecs;
  _clockseq = clockseq;
  msecs += 122192928e5;
  const tl = ((msecs & 268435455) * 1e4 + nsecs) % 4294967296;
  b[i++] = tl >>> 24 & 255;
  b[i++] = tl >>> 16 & 255;
  b[i++] = tl >>> 8 & 255;
  b[i++] = tl & 255;
  const tmh = msecs / 4294967296 * 1e4 & 268435455;
  b[i++] = tmh >>> 8 & 255;
  b[i++] = tmh & 255;
  b[i++] = tmh >>> 24 & 15 | 16;
  b[i++] = tmh >>> 16 & 255;
  b[i++] = clockseq >>> 8 | 128;
  b[i++] = clockseq & 255;
  for (let n = 0; n < 6; ++n) {
    b[i + n] = node[n];
  }
  return buf || unsafeStringify(b);
}
var _nodeId, _clockseq, _lastMSecs, _lastNSecs, v1_default;
var init_v1 = __esm({
  "../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/v1.js"() {
    init_rng();
    init_stringify();
    _lastMSecs = 0;
    _lastNSecs = 0;
    v1_default = v1;
  }
});

// ../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/parse.js
function parse(uuid) {
  if (!validate_default(uuid)) {
    throw TypeError("Invalid UUID");
  }
  let v;
  const arr = new Uint8Array(16);
  arr[0] = (v = parseInt(uuid.slice(0, 8), 16)) >>> 24;
  arr[1] = v >>> 16 & 255;
  arr[2] = v >>> 8 & 255;
  arr[3] = v & 255;
  arr[4] = (v = parseInt(uuid.slice(9, 13), 16)) >>> 8;
  arr[5] = v & 255;
  arr[6] = (v = parseInt(uuid.slice(14, 18), 16)) >>> 8;
  arr[7] = v & 255;
  arr[8] = (v = parseInt(uuid.slice(19, 23), 16)) >>> 8;
  arr[9] = v & 255;
  arr[10] = (v = parseInt(uuid.slice(24, 36), 16)) / 1099511627776 & 255;
  arr[11] = v / 4294967296 & 255;
  arr[12] = v >>> 24 & 255;
  arr[13] = v >>> 16 & 255;
  arr[14] = v >>> 8 & 255;
  arr[15] = v & 255;
  return arr;
}
var parse_default;
var init_parse = __esm({
  "../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/parse.js"() {
    init_validate();
    parse_default = parse;
  }
});

// ../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/v35.js
function stringToBytes(str) {
  str = unescape(encodeURIComponent(str));
  const bytes = [];
  for (let i = 0; i < str.length; ++i) {
    bytes.push(str.charCodeAt(i));
  }
  return bytes;
}
function v35(name, version2, hashfunc) {
  function generateUUID(value, namespace, buf, offset) {
    var _namespace;
    if (typeof value === "string") {
      value = stringToBytes(value);
    }
    if (typeof namespace === "string") {
      namespace = parse_default(namespace);
    }
    if (((_namespace = namespace) === null || _namespace === void 0 ? void 0 : _namespace.length) !== 16) {
      throw TypeError("Namespace must be array-like (16 iterable integer values, 0-255)");
    }
    let bytes = new Uint8Array(16 + value.length);
    bytes.set(namespace);
    bytes.set(value, namespace.length);
    bytes = hashfunc(bytes);
    bytes[6] = bytes[6] & 15 | version2;
    bytes[8] = bytes[8] & 63 | 128;
    if (buf) {
      offset = offset || 0;
      for (let i = 0; i < 16; ++i) {
        buf[offset + i] = bytes[i];
      }
      return buf;
    }
    return unsafeStringify(bytes);
  }
  try {
    generateUUID.name = name;
  } catch (err) {
  }
  generateUUID.DNS = DNS;
  generateUUID.URL = URL2;
  return generateUUID;
}
var DNS, URL2;
var init_v35 = __esm({
  "../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/v35.js"() {
    init_stringify();
    init_parse();
    DNS = "6ba7b810-9dad-11d1-80b4-00c04fd430c8";
    URL2 = "6ba7b811-9dad-11d1-80b4-00c04fd430c8";
  }
});

// ../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/md5.js
function md5(bytes) {
  if (Array.isArray(bytes)) {
    bytes = Buffer.from(bytes);
  } else if (typeof bytes === "string") {
    bytes = Buffer.from(bytes, "utf8");
  }
  return import_crypto2.default.createHash("md5").update(bytes).digest();
}
var import_crypto2, md5_default;
var init_md5 = __esm({
  "../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/md5.js"() {
    import_crypto2 = __toESM(require("crypto"));
    md5_default = md5;
  }
});

// ../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/v3.js
var v3, v3_default;
var init_v3 = __esm({
  "../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/v3.js"() {
    init_v35();
    init_md5();
    v3 = v35("v3", 48, md5_default);
    v3_default = v3;
  }
});

// ../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/native.js
var import_crypto3, native_default;
var init_native = __esm({
  "../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/native.js"() {
    import_crypto3 = __toESM(require("crypto"));
    native_default = {
      randomUUID: import_crypto3.default.randomUUID
    };
  }
});

// ../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/v4.js
function v4(options, buf, offset) {
  if (native_default.randomUUID && !buf && !options) {
    return native_default.randomUUID();
  }
  options = options || {};
  const rnds = options.random || (options.rng || rng)();
  rnds[6] = rnds[6] & 15 | 64;
  rnds[8] = rnds[8] & 63 | 128;
  if (buf) {
    offset = offset || 0;
    for (let i = 0; i < 16; ++i) {
      buf[offset + i] = rnds[i];
    }
    return buf;
  }
  return unsafeStringify(rnds);
}
var v4_default;
var init_v4 = __esm({
  "../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/v4.js"() {
    init_native();
    init_rng();
    init_stringify();
    v4_default = v4;
  }
});

// ../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/sha1.js
function sha1(bytes) {
  if (Array.isArray(bytes)) {
    bytes = Buffer.from(bytes);
  } else if (typeof bytes === "string") {
    bytes = Buffer.from(bytes, "utf8");
  }
  return import_crypto4.default.createHash("sha1").update(bytes).digest();
}
var import_crypto4, sha1_default;
var init_sha1 = __esm({
  "../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/sha1.js"() {
    import_crypto4 = __toESM(require("crypto"));
    sha1_default = sha1;
  }
});

// ../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/v5.js
var v5, v5_default;
var init_v5 = __esm({
  "../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/v5.js"() {
    init_v35();
    init_sha1();
    v5 = v35("v5", 80, sha1_default);
    v5_default = v5;
  }
});

// ../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/nil.js
var nil_default;
var init_nil = __esm({
  "../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/nil.js"() {
    nil_default = "00000000-0000-0000-0000-000000000000";
  }
});

// ../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/version.js
function version(uuid) {
  if (!validate_default(uuid)) {
    throw TypeError("Invalid UUID");
  }
  return parseInt(uuid.slice(14, 15), 16);
}
var version_default;
var init_version = __esm({
  "../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/version.js"() {
    init_validate();
    version_default = version;
  }
});

// ../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/index.js
var esm_node_exports = {};
__export(esm_node_exports, {
  NIL: () => nil_default,
  parse: () => parse_default,
  stringify: () => stringify_default,
  v1: () => v1_default,
  v3: () => v3_default,
  v4: () => v4_default,
  v5: () => v5_default,
  validate: () => validate_default,
  version: () => version_default
});
var init_esm_node = __esm({
  "../../../node_modules/@smithy/middleware-retry/node_modules/uuid/dist/esm-node/index.js"() {
    init_v1();
    init_v3();
    init_v4();
    init_v5();
    init_nil();
    init_version();
    init_validate();
    init_stringify();
    init_parse();
  }
});

// ../../../node_modules/@smithy/service-error-classification/dist-cjs/index.js
var require_dist_cjs27 = __commonJS({
  "../../../node_modules/@smithy/service-error-classification/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      isClockSkewCorrectedError: () => isClockSkewCorrectedError,
      isClockSkewError: () => isClockSkewError,
      isRetryableByTrait: () => isRetryableByTrait,
      isServerError: () => isServerError,
      isThrottlingError: () => isThrottlingError,
      isTransientError: () => isTransientError
    });
    module2.exports = __toCommonJS2(src_exports);
    var CLOCK_SKEW_ERROR_CODES = [
      "AuthFailure",
      "InvalidSignatureException",
      "RequestExpired",
      "RequestInTheFuture",
      "RequestTimeTooSkewed",
      "SignatureDoesNotMatch"
    ];
    var THROTTLING_ERROR_CODES = [
      "BandwidthLimitExceeded",
      "EC2ThrottledException",
      "LimitExceededException",
      "PriorRequestNotComplete",
      "ProvisionedThroughputExceededException",
      "RequestLimitExceeded",
      "RequestThrottled",
      "RequestThrottledException",
      "SlowDown",
      "ThrottledException",
      "Throttling",
      "ThrottlingException",
      "TooManyRequestsException",
      "TransactionInProgressException"
      // DynamoDB
    ];
    var TRANSIENT_ERROR_CODES = ["TimeoutError", "RequestTimeout", "RequestTimeoutException"];
    var TRANSIENT_ERROR_STATUS_CODES = [500, 502, 503, 504];
    var NODEJS_TIMEOUT_ERROR_CODES = ["ECONNRESET", "ECONNREFUSED", "EPIPE", "ETIMEDOUT"];
    var isRetryableByTrait = /* @__PURE__ */ __name((error) => error.$retryable !== void 0, "isRetryableByTrait");
    var isClockSkewError = /* @__PURE__ */ __name((error) => CLOCK_SKEW_ERROR_CODES.includes(error.name), "isClockSkewError");
    var isClockSkewCorrectedError = /* @__PURE__ */ __name((error) => {
      var _a;
      return (_a = error.$metadata) == null ? void 0 : _a.clockSkewCorrected;
    }, "isClockSkewCorrectedError");
    var isThrottlingError = /* @__PURE__ */ __name((error) => {
      var _a, _b;
      return ((_a = error.$metadata) == null ? void 0 : _a.httpStatusCode) === 429 || THROTTLING_ERROR_CODES.includes(error.name) || ((_b = error.$retryable) == null ? void 0 : _b.throttling) == true;
    }, "isThrottlingError");
    var isTransientError = /* @__PURE__ */ __name((error) => {
      var _a;
      return isClockSkewCorrectedError(error) || TRANSIENT_ERROR_CODES.includes(error.name) || NODEJS_TIMEOUT_ERROR_CODES.includes((error == null ? void 0 : error.code) || "") || TRANSIENT_ERROR_STATUS_CODES.includes(((_a = error.$metadata) == null ? void 0 : _a.httpStatusCode) || 0);
    }, "isTransientError");
    var isServerError = /* @__PURE__ */ __name((error) => {
      var _a;
      if (((_a = error.$metadata) == null ? void 0 : _a.httpStatusCode) !== void 0) {
        const statusCode = error.$metadata.httpStatusCode;
        if (500 <= statusCode && statusCode <= 599 && !isTransientError(error)) {
          return true;
        }
        return false;
      }
      return false;
    }, "isServerError");
  }
});

// ../../../node_modules/@smithy/util-retry/dist-cjs/index.js
var require_dist_cjs28 = __commonJS({
  "../../../node_modules/@smithy/util-retry/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      AdaptiveRetryStrategy: () => AdaptiveRetryStrategy,
      ConfiguredRetryStrategy: () => ConfiguredRetryStrategy,
      DEFAULT_MAX_ATTEMPTS: () => DEFAULT_MAX_ATTEMPTS,
      DEFAULT_RETRY_DELAY_BASE: () => DEFAULT_RETRY_DELAY_BASE,
      DEFAULT_RETRY_MODE: () => DEFAULT_RETRY_MODE,
      DefaultRateLimiter: () => DefaultRateLimiter,
      INITIAL_RETRY_TOKENS: () => INITIAL_RETRY_TOKENS,
      INVOCATION_ID_HEADER: () => INVOCATION_ID_HEADER,
      MAXIMUM_RETRY_DELAY: () => MAXIMUM_RETRY_DELAY,
      NO_RETRY_INCREMENT: () => NO_RETRY_INCREMENT,
      REQUEST_HEADER: () => REQUEST_HEADER,
      RETRY_COST: () => RETRY_COST,
      RETRY_MODES: () => RETRY_MODES,
      StandardRetryStrategy: () => StandardRetryStrategy,
      THROTTLING_RETRY_DELAY_BASE: () => THROTTLING_RETRY_DELAY_BASE,
      TIMEOUT_RETRY_COST: () => TIMEOUT_RETRY_COST
    });
    module2.exports = __toCommonJS2(src_exports);
    var RETRY_MODES = /* @__PURE__ */ ((RETRY_MODES2) => {
      RETRY_MODES2["STANDARD"] = "standard";
      RETRY_MODES2["ADAPTIVE"] = "adaptive";
      return RETRY_MODES2;
    })(RETRY_MODES || {});
    var DEFAULT_MAX_ATTEMPTS = 3;
    var DEFAULT_RETRY_MODE = "standard";
    var import_service_error_classification = require_dist_cjs27();
    var _DefaultRateLimiter = class _DefaultRateLimiter {
      constructor(options) {
        this.currentCapacity = 0;
        this.enabled = false;
        this.lastMaxRate = 0;
        this.measuredTxRate = 0;
        this.requestCount = 0;
        this.lastTimestamp = 0;
        this.timeWindow = 0;
        this.beta = (options == null ? void 0 : options.beta) ?? 0.7;
        this.minCapacity = (options == null ? void 0 : options.minCapacity) ?? 1;
        this.minFillRate = (options == null ? void 0 : options.minFillRate) ?? 0.5;
        this.scaleConstant = (options == null ? void 0 : options.scaleConstant) ?? 0.4;
        this.smooth = (options == null ? void 0 : options.smooth) ?? 0.8;
        const currentTimeInSeconds = this.getCurrentTimeInSeconds();
        this.lastThrottleTime = currentTimeInSeconds;
        this.lastTxRateBucket = Math.floor(this.getCurrentTimeInSeconds());
        this.fillRate = this.minFillRate;
        this.maxCapacity = this.minCapacity;
      }
      getCurrentTimeInSeconds() {
        return Date.now() / 1e3;
      }
      async getSendToken() {
        return this.acquireTokenBucket(1);
      }
      async acquireTokenBucket(amount) {
        if (!this.enabled) {
          return;
        }
        this.refillTokenBucket();
        if (amount > this.currentCapacity) {
          const delay = (amount - this.currentCapacity) / this.fillRate * 1e3;
          await new Promise((resolve) => setTimeout(resolve, delay));
        }
        this.currentCapacity = this.currentCapacity - amount;
      }
      refillTokenBucket() {
        const timestamp = this.getCurrentTimeInSeconds();
        if (!this.lastTimestamp) {
          this.lastTimestamp = timestamp;
          return;
        }
        const fillAmount = (timestamp - this.lastTimestamp) * this.fillRate;
        this.currentCapacity = Math.min(this.maxCapacity, this.currentCapacity + fillAmount);
        this.lastTimestamp = timestamp;
      }
      updateClientSendingRate(response) {
        let calculatedRate;
        this.updateMeasuredRate();
        if ((0, import_service_error_classification.isThrottlingError)(response)) {
          const rateToUse = !this.enabled ? this.measuredTxRate : Math.min(this.measuredTxRate, this.fillRate);
          this.lastMaxRate = rateToUse;
          this.calculateTimeWindow();
          this.lastThrottleTime = this.getCurrentTimeInSeconds();
          calculatedRate = this.cubicThrottle(rateToUse);
          this.enableTokenBucket();
        } else {
          this.calculateTimeWindow();
          calculatedRate = this.cubicSuccess(this.getCurrentTimeInSeconds());
        }
        const newRate = Math.min(calculatedRate, 2 * this.measuredTxRate);
        this.updateTokenBucketRate(newRate);
      }
      calculateTimeWindow() {
        this.timeWindow = this.getPrecise(Math.pow(this.lastMaxRate * (1 - this.beta) / this.scaleConstant, 1 / 3));
      }
      cubicThrottle(rateToUse) {
        return this.getPrecise(rateToUse * this.beta);
      }
      cubicSuccess(timestamp) {
        return this.getPrecise(
          this.scaleConstant * Math.pow(timestamp - this.lastThrottleTime - this.timeWindow, 3) + this.lastMaxRate
        );
      }
      enableTokenBucket() {
        this.enabled = true;
      }
      updateTokenBucketRate(newRate) {
        this.refillTokenBucket();
        this.fillRate = Math.max(newRate, this.minFillRate);
        this.maxCapacity = Math.max(newRate, this.minCapacity);
        this.currentCapacity = Math.min(this.currentCapacity, this.maxCapacity);
      }
      updateMeasuredRate() {
        const t = this.getCurrentTimeInSeconds();
        const timeBucket = Math.floor(t * 2) / 2;
        this.requestCount++;
        if (timeBucket > this.lastTxRateBucket) {
          const currentRate = this.requestCount / (timeBucket - this.lastTxRateBucket);
          this.measuredTxRate = this.getPrecise(currentRate * this.smooth + this.measuredTxRate * (1 - this.smooth));
          this.requestCount = 0;
          this.lastTxRateBucket = timeBucket;
        }
      }
      getPrecise(num) {
        return parseFloat(num.toFixed(8));
      }
    };
    __name(_DefaultRateLimiter, "DefaultRateLimiter");
    var DefaultRateLimiter = _DefaultRateLimiter;
    var DEFAULT_RETRY_DELAY_BASE = 100;
    var MAXIMUM_RETRY_DELAY = 20 * 1e3;
    var THROTTLING_RETRY_DELAY_BASE = 500;
    var INITIAL_RETRY_TOKENS = 500;
    var RETRY_COST = 5;
    var TIMEOUT_RETRY_COST = 10;
    var NO_RETRY_INCREMENT = 1;
    var INVOCATION_ID_HEADER = "amz-sdk-invocation-id";
    var REQUEST_HEADER = "amz-sdk-request";
    var getDefaultRetryBackoffStrategy = /* @__PURE__ */ __name(() => {
      let delayBase = DEFAULT_RETRY_DELAY_BASE;
      const computeNextBackoffDelay = /* @__PURE__ */ __name((attempts) => {
        return Math.floor(Math.min(MAXIMUM_RETRY_DELAY, Math.random() * 2 ** attempts * delayBase));
      }, "computeNextBackoffDelay");
      const setDelayBase = /* @__PURE__ */ __name((delay) => {
        delayBase = delay;
      }, "setDelayBase");
      return {
        computeNextBackoffDelay,
        setDelayBase
      };
    }, "getDefaultRetryBackoffStrategy");
    var createDefaultRetryToken = /* @__PURE__ */ __name(({
      retryDelay,
      retryCount,
      retryCost
    }) => {
      const getRetryCount = /* @__PURE__ */ __name(() => retryCount, "getRetryCount");
      const getRetryDelay = /* @__PURE__ */ __name(() => Math.min(MAXIMUM_RETRY_DELAY, retryDelay), "getRetryDelay");
      const getRetryCost = /* @__PURE__ */ __name(() => retryCost, "getRetryCost");
      return {
        getRetryCount,
        getRetryDelay,
        getRetryCost
      };
    }, "createDefaultRetryToken");
    var _StandardRetryStrategy = class _StandardRetryStrategy {
      constructor(maxAttempts) {
        this.maxAttempts = maxAttempts;
        this.mode = "standard";
        this.capacity = INITIAL_RETRY_TOKENS;
        this.retryBackoffStrategy = getDefaultRetryBackoffStrategy();
        this.maxAttemptsProvider = typeof maxAttempts === "function" ? maxAttempts : async () => maxAttempts;
      }
      async acquireInitialRetryToken(retryTokenScope) {
        return createDefaultRetryToken({
          retryDelay: DEFAULT_RETRY_DELAY_BASE,
          retryCount: 0
        });
      }
      async refreshRetryTokenForRetry(token, errorInfo) {
        const maxAttempts = await this.getMaxAttempts();
        if (this.shouldRetry(token, errorInfo, maxAttempts)) {
          const errorType = errorInfo.errorType;
          this.retryBackoffStrategy.setDelayBase(
            errorType === "THROTTLING" ? THROTTLING_RETRY_DELAY_BASE : DEFAULT_RETRY_DELAY_BASE
          );
          const delayFromErrorType = this.retryBackoffStrategy.computeNextBackoffDelay(token.getRetryCount());
          const retryDelay = errorInfo.retryAfterHint ? Math.max(errorInfo.retryAfterHint.getTime() - Date.now() || 0, delayFromErrorType) : delayFromErrorType;
          const capacityCost = this.getCapacityCost(errorType);
          this.capacity -= capacityCost;
          return createDefaultRetryToken({
            retryDelay,
            retryCount: token.getRetryCount() + 1,
            retryCost: capacityCost
          });
        }
        throw new Error("No retry token available");
      }
      recordSuccess(token) {
        this.capacity = Math.max(INITIAL_RETRY_TOKENS, this.capacity + (token.getRetryCost() ?? NO_RETRY_INCREMENT));
      }
      /**
       * @returns the current available retry capacity.
       *
       * This number decreases when retries are executed and refills when requests or retries succeed.
       */
      getCapacity() {
        return this.capacity;
      }
      async getMaxAttempts() {
        try {
          return await this.maxAttemptsProvider();
        } catch (error) {
          console.warn(`Max attempts provider could not resolve. Using default of ${DEFAULT_MAX_ATTEMPTS}`);
          return DEFAULT_MAX_ATTEMPTS;
        }
      }
      shouldRetry(tokenToRenew, errorInfo, maxAttempts) {
        const attempts = tokenToRenew.getRetryCount() + 1;
        return attempts < maxAttempts && this.capacity >= this.getCapacityCost(errorInfo.errorType) && this.isRetryableError(errorInfo.errorType);
      }
      getCapacityCost(errorType) {
        return errorType === "TRANSIENT" ? TIMEOUT_RETRY_COST : RETRY_COST;
      }
      isRetryableError(errorType) {
        return errorType === "THROTTLING" || errorType === "TRANSIENT";
      }
    };
    __name(_StandardRetryStrategy, "StandardRetryStrategy");
    var StandardRetryStrategy = _StandardRetryStrategy;
    var _AdaptiveRetryStrategy = class _AdaptiveRetryStrategy {
      constructor(maxAttemptsProvider, options) {
        this.maxAttemptsProvider = maxAttemptsProvider;
        this.mode = "adaptive";
        const { rateLimiter } = options ?? {};
        this.rateLimiter = rateLimiter ?? new DefaultRateLimiter();
        this.standardRetryStrategy = new StandardRetryStrategy(maxAttemptsProvider);
      }
      async acquireInitialRetryToken(retryTokenScope) {
        await this.rateLimiter.getSendToken();
        return this.standardRetryStrategy.acquireInitialRetryToken(retryTokenScope);
      }
      async refreshRetryTokenForRetry(tokenToRenew, errorInfo) {
        this.rateLimiter.updateClientSendingRate(errorInfo);
        return this.standardRetryStrategy.refreshRetryTokenForRetry(tokenToRenew, errorInfo);
      }
      recordSuccess(token) {
        this.rateLimiter.updateClientSendingRate({});
        this.standardRetryStrategy.recordSuccess(token);
      }
    };
    __name(_AdaptiveRetryStrategy, "AdaptiveRetryStrategy");
    var AdaptiveRetryStrategy = _AdaptiveRetryStrategy;
    var _ConfiguredRetryStrategy = class _ConfiguredRetryStrategy extends StandardRetryStrategy {
      /**
       * @param maxAttempts - the maximum number of retry attempts allowed.
       *                      e.g., if set to 3, then 4 total requests are possible.
       * @param computeNextBackoffDelay - a millisecond delay for each retry or a function that takes the retry attempt
       *                                  and returns the delay.
       *
       * @example exponential backoff.
       * ```js
       * new Client({
       *   retryStrategy: new ConfiguredRetryStrategy(3, (attempt) => attempt ** 2)
       * });
       * ```
       * @example constant delay.
       * ```js
       * new Client({
       *   retryStrategy: new ConfiguredRetryStrategy(3, 2000)
       * });
       * ```
       */
      constructor(maxAttempts, computeNextBackoffDelay = DEFAULT_RETRY_DELAY_BASE) {
        super(typeof maxAttempts === "function" ? maxAttempts : async () => maxAttempts);
        if (typeof computeNextBackoffDelay === "number") {
          this.computeNextBackoffDelay = () => computeNextBackoffDelay;
        } else {
          this.computeNextBackoffDelay = computeNextBackoffDelay;
        }
      }
      async refreshRetryTokenForRetry(tokenToRenew, errorInfo) {
        const token = await super.refreshRetryTokenForRetry(tokenToRenew, errorInfo);
        token.getRetryDelay = () => this.computeNextBackoffDelay(token.getRetryCount());
        return token;
      }
    };
    __name(_ConfiguredRetryStrategy, "ConfiguredRetryStrategy");
    var ConfiguredRetryStrategy = _ConfiguredRetryStrategy;
  }
});

// ../../../node_modules/@smithy/middleware-stack/dist-cjs/index.js
var require_dist_cjs29 = __commonJS({
  "../../../node_modules/@smithy/middleware-stack/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      constructStack: () => constructStack
    });
    module2.exports = __toCommonJS2(src_exports);
    var getAllAliases = /* @__PURE__ */ __name((name, aliases) => {
      const _aliases = [];
      if (name) {
        _aliases.push(name);
      }
      if (aliases) {
        for (const alias of aliases) {
          _aliases.push(alias);
        }
      }
      return _aliases;
    }, "getAllAliases");
    var getMiddlewareNameWithAliases = /* @__PURE__ */ __name((name, aliases) => {
      return `${name || "anonymous"}${aliases && aliases.length > 0 ? ` (a.k.a. ${aliases.join(",")})` : ""}`;
    }, "getMiddlewareNameWithAliases");
    var constructStack = /* @__PURE__ */ __name(() => {
      let absoluteEntries = [];
      let relativeEntries = [];
      let identifyOnResolve = false;
      const entriesNameSet = /* @__PURE__ */ new Set();
      const sort = /* @__PURE__ */ __name((entries) => entries.sort(
        (a, b) => stepWeights[b.step] - stepWeights[a.step] || priorityWeights[b.priority || "normal"] - priorityWeights[a.priority || "normal"]
      ), "sort");
      const removeByName = /* @__PURE__ */ __name((toRemove) => {
        let isRemoved = false;
        const filterCb = /* @__PURE__ */ __name((entry) => {
          const aliases = getAllAliases(entry.name, entry.aliases);
          if (aliases.includes(toRemove)) {
            isRemoved = true;
            for (const alias of aliases) {
              entriesNameSet.delete(alias);
            }
            return false;
          }
          return true;
        }, "filterCb");
        absoluteEntries = absoluteEntries.filter(filterCb);
        relativeEntries = relativeEntries.filter(filterCb);
        return isRemoved;
      }, "removeByName");
      const removeByReference = /* @__PURE__ */ __name((toRemove) => {
        let isRemoved = false;
        const filterCb = /* @__PURE__ */ __name((entry) => {
          if (entry.middleware === toRemove) {
            isRemoved = true;
            for (const alias of getAllAliases(entry.name, entry.aliases)) {
              entriesNameSet.delete(alias);
            }
            return false;
          }
          return true;
        }, "filterCb");
        absoluteEntries = absoluteEntries.filter(filterCb);
        relativeEntries = relativeEntries.filter(filterCb);
        return isRemoved;
      }, "removeByReference");
      const cloneTo = /* @__PURE__ */ __name((toStack) => {
        var _a;
        absoluteEntries.forEach((entry) => {
          toStack.add(entry.middleware, { ...entry });
        });
        relativeEntries.forEach((entry) => {
          toStack.addRelativeTo(entry.middleware, { ...entry });
        });
        (_a = toStack.identifyOnResolve) == null ? void 0 : _a.call(toStack, stack.identifyOnResolve());
        return toStack;
      }, "cloneTo");
      const expandRelativeMiddlewareList = /* @__PURE__ */ __name((from) => {
        const expandedMiddlewareList = [];
        from.before.forEach((entry) => {
          if (entry.before.length === 0 && entry.after.length === 0) {
            expandedMiddlewareList.push(entry);
          } else {
            expandedMiddlewareList.push(...expandRelativeMiddlewareList(entry));
          }
        });
        expandedMiddlewareList.push(from);
        from.after.reverse().forEach((entry) => {
          if (entry.before.length === 0 && entry.after.length === 0) {
            expandedMiddlewareList.push(entry);
          } else {
            expandedMiddlewareList.push(...expandRelativeMiddlewareList(entry));
          }
        });
        return expandedMiddlewareList;
      }, "expandRelativeMiddlewareList");
      const getMiddlewareList = /* @__PURE__ */ __name((debug = false) => {
        const normalizedAbsoluteEntries = [];
        const normalizedRelativeEntries = [];
        const normalizedEntriesNameMap = {};
        absoluteEntries.forEach((entry) => {
          const normalizedEntry = {
            ...entry,
            before: [],
            after: []
          };
          for (const alias of getAllAliases(normalizedEntry.name, normalizedEntry.aliases)) {
            normalizedEntriesNameMap[alias] = normalizedEntry;
          }
          normalizedAbsoluteEntries.push(normalizedEntry);
        });
        relativeEntries.forEach((entry) => {
          const normalizedEntry = {
            ...entry,
            before: [],
            after: []
          };
          for (const alias of getAllAliases(normalizedEntry.name, normalizedEntry.aliases)) {
            normalizedEntriesNameMap[alias] = normalizedEntry;
          }
          normalizedRelativeEntries.push(normalizedEntry);
        });
        normalizedRelativeEntries.forEach((entry) => {
          if (entry.toMiddleware) {
            const toMiddleware = normalizedEntriesNameMap[entry.toMiddleware];
            if (toMiddleware === void 0) {
              if (debug) {
                return;
              }
              throw new Error(
                `${entry.toMiddleware} is not found when adding ${getMiddlewareNameWithAliases(entry.name, entry.aliases)} middleware ${entry.relation} ${entry.toMiddleware}`
              );
            }
            if (entry.relation === "after") {
              toMiddleware.after.push(entry);
            }
            if (entry.relation === "before") {
              toMiddleware.before.push(entry);
            }
          }
        });
        const mainChain = sort(normalizedAbsoluteEntries).map(expandRelativeMiddlewareList).reduce((wholeList, expandedMiddlewareList) => {
          wholeList.push(...expandedMiddlewareList);
          return wholeList;
        }, []);
        return mainChain;
      }, "getMiddlewareList");
      const stack = {
        add: (middleware, options = {}) => {
          const { name, override, aliases: _aliases } = options;
          const entry = {
            step: "initialize",
            priority: "normal",
            middleware,
            ...options
          };
          const aliases = getAllAliases(name, _aliases);
          if (aliases.length > 0) {
            if (aliases.some((alias) => entriesNameSet.has(alias))) {
              if (!override)
                throw new Error(`Duplicate middleware name '${getMiddlewareNameWithAliases(name, _aliases)}'`);
              for (const alias of aliases) {
                const toOverrideIndex = absoluteEntries.findIndex(
                  (entry2) => {
                    var _a;
                    return entry2.name === alias || ((_a = entry2.aliases) == null ? void 0 : _a.some((a) => a === alias));
                  }
                );
                if (toOverrideIndex === -1) {
                  continue;
                }
                const toOverride = absoluteEntries[toOverrideIndex];
                if (toOverride.step !== entry.step || entry.priority !== toOverride.priority) {
                  throw new Error(
                    `"${getMiddlewareNameWithAliases(toOverride.name, toOverride.aliases)}" middleware with ${toOverride.priority} priority in ${toOverride.step} step cannot be overridden by "${getMiddlewareNameWithAliases(name, _aliases)}" middleware with ${entry.priority} priority in ${entry.step} step.`
                  );
                }
                absoluteEntries.splice(toOverrideIndex, 1);
              }
            }
            for (const alias of aliases) {
              entriesNameSet.add(alias);
            }
          }
          absoluteEntries.push(entry);
        },
        addRelativeTo: (middleware, options) => {
          const { name, override, aliases: _aliases } = options;
          const entry = {
            middleware,
            ...options
          };
          const aliases = getAllAliases(name, _aliases);
          if (aliases.length > 0) {
            if (aliases.some((alias) => entriesNameSet.has(alias))) {
              if (!override)
                throw new Error(`Duplicate middleware name '${getMiddlewareNameWithAliases(name, _aliases)}'`);
              for (const alias of aliases) {
                const toOverrideIndex = relativeEntries.findIndex(
                  (entry2) => {
                    var _a;
                    return entry2.name === alias || ((_a = entry2.aliases) == null ? void 0 : _a.some((a) => a === alias));
                  }
                );
                if (toOverrideIndex === -1) {
                  continue;
                }
                const toOverride = relativeEntries[toOverrideIndex];
                if (toOverride.toMiddleware !== entry.toMiddleware || toOverride.relation !== entry.relation) {
                  throw new Error(
                    `"${getMiddlewareNameWithAliases(toOverride.name, toOverride.aliases)}" middleware ${toOverride.relation} "${toOverride.toMiddleware}" middleware cannot be overridden by "${getMiddlewareNameWithAliases(name, _aliases)}" middleware ${entry.relation} "${entry.toMiddleware}" middleware.`
                  );
                }
                relativeEntries.splice(toOverrideIndex, 1);
              }
            }
            for (const alias of aliases) {
              entriesNameSet.add(alias);
            }
          }
          relativeEntries.push(entry);
        },
        clone: () => cloneTo(constructStack()),
        use: (plugin) => {
          plugin.applyToStack(stack);
        },
        remove: (toRemove) => {
          if (typeof toRemove === "string")
            return removeByName(toRemove);
          else
            return removeByReference(toRemove);
        },
        removeByTag: (toRemove) => {
          let isRemoved = false;
          const filterCb = /* @__PURE__ */ __name((entry) => {
            const { tags, name, aliases: _aliases } = entry;
            if (tags && tags.includes(toRemove)) {
              const aliases = getAllAliases(name, _aliases);
              for (const alias of aliases) {
                entriesNameSet.delete(alias);
              }
              isRemoved = true;
              return false;
            }
            return true;
          }, "filterCb");
          absoluteEntries = absoluteEntries.filter(filterCb);
          relativeEntries = relativeEntries.filter(filterCb);
          return isRemoved;
        },
        concat: (from) => {
          var _a;
          const cloned = cloneTo(constructStack());
          cloned.use(from);
          cloned.identifyOnResolve(
            identifyOnResolve || cloned.identifyOnResolve() || (((_a = from.identifyOnResolve) == null ? void 0 : _a.call(from)) ?? false)
          );
          return cloned;
        },
        applyToStack: cloneTo,
        identify: () => {
          return getMiddlewareList(true).map((mw) => {
            const step = mw.step ?? mw.relation + " " + mw.toMiddleware;
            return getMiddlewareNameWithAliases(mw.name, mw.aliases) + " - " + step;
          });
        },
        identifyOnResolve(toggle) {
          if (typeof toggle === "boolean")
            identifyOnResolve = toggle;
          return identifyOnResolve;
        },
        resolve: (handler2, context) => {
          for (const middleware of getMiddlewareList().map((entry) => entry.middleware).reverse()) {
            handler2 = middleware(handler2, context);
          }
          if (identifyOnResolve) {
            console.log(stack.identify());
          }
          return handler2;
        }
      };
      return stack;
    }, "constructStack");
    var stepWeights = {
      initialize: 5,
      serialize: 4,
      build: 3,
      finalizeRequest: 2,
      deserialize: 1
    };
    var priorityWeights = {
      high: 3,
      normal: 2,
      low: 1
    };
  }
});

// ../../../node_modules/@smithy/util-base64/dist-cjs/fromBase64.js
var require_fromBase64 = __commonJS({
  "../../../node_modules/@smithy/util-base64/dist-cjs/fromBase64.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.fromBase64 = void 0;
    var util_buffer_from_1 = require_dist_cjs9();
    var BASE64_REGEX = /^[A-Za-z0-9+/]*={0,2}$/;
    var fromBase642 = (input) => {
      if (input.length * 3 % 4 !== 0) {
        throw new TypeError(`Incorrect padding on base64 string.`);
      }
      if (!BASE64_REGEX.exec(input)) {
        throw new TypeError(`Invalid base64 string.`);
      }
      const buffer = (0, util_buffer_from_1.fromString)(input, "base64");
      return new Uint8Array(buffer.buffer, buffer.byteOffset, buffer.byteLength);
    };
    exports2.fromBase64 = fromBase642;
  }
});

// ../../../node_modules/@smithy/util-base64/dist-cjs/toBase64.js
var require_toBase64 = __commonJS({
  "../../../node_modules/@smithy/util-base64/dist-cjs/toBase64.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.toBase64 = void 0;
    var util_buffer_from_1 = require_dist_cjs9();
    var util_utf8_1 = require_dist_cjs10();
    var toBase642 = (_input) => {
      let input;
      if (typeof _input === "string") {
        input = (0, util_utf8_1.fromUtf8)(_input);
      } else {
        input = _input;
      }
      if (typeof input !== "object" || typeof input.byteOffset !== "number" || typeof input.byteLength !== "number") {
        throw new Error("@smithy/util-base64: toBase64 encoder function only accepts string | Uint8Array.");
      }
      return (0, util_buffer_from_1.fromArrayBuffer)(input.buffer, input.byteOffset, input.byteLength).toString("base64");
    };
    exports2.toBase64 = toBase642;
  }
});

// ../../../node_modules/@smithy/util-base64/dist-cjs/index.js
var require_dist_cjs30 = __commonJS({
  "../../../node_modules/@smithy/util-base64/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __reExport = (target, mod, secondTarget) => (__copyProps2(target, mod, "default"), secondTarget && __copyProps2(secondTarget, mod, "default"));
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    module2.exports = __toCommonJS2(src_exports);
    __reExport(src_exports, require_fromBase64(), module2.exports);
    __reExport(src_exports, require_toBase64(), module2.exports);
  }
});

// ../../../node_modules/@smithy/util-stream/dist-cjs/getAwsChunkedEncodingStream.js
var require_getAwsChunkedEncodingStream = __commonJS({
  "../../../node_modules/@smithy/util-stream/dist-cjs/getAwsChunkedEncodingStream.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getAwsChunkedEncodingStream = void 0;
    var stream_1 = require("stream");
    var getAwsChunkedEncodingStream2 = (readableStream, options) => {
      const { base64Encoder, bodyLengthChecker, checksumAlgorithmFn, checksumLocationName, streamHasher } = options;
      const checksumRequired = base64Encoder !== void 0 && checksumAlgorithmFn !== void 0 && checksumLocationName !== void 0 && streamHasher !== void 0;
      const digest = checksumRequired ? streamHasher(checksumAlgorithmFn, readableStream) : void 0;
      const awsChunkedEncodingStream = new stream_1.Readable({ read: () => {
      } });
      readableStream.on("data", (data) => {
        const length = bodyLengthChecker(data) || 0;
        awsChunkedEncodingStream.push(`${length.toString(16)}\r
`);
        awsChunkedEncodingStream.push(data);
        awsChunkedEncodingStream.push("\r\n");
      });
      readableStream.on("end", async () => {
        awsChunkedEncodingStream.push(`0\r
`);
        if (checksumRequired) {
          const checksum = base64Encoder(await digest);
          awsChunkedEncodingStream.push(`${checksumLocationName}:${checksum}\r
`);
          awsChunkedEncodingStream.push(`\r
`);
        }
        awsChunkedEncodingStream.push(null);
      });
      return awsChunkedEncodingStream;
    };
    exports2.getAwsChunkedEncodingStream = getAwsChunkedEncodingStream2;
  }
});

// ../../../node_modules/@smithy/querystring-builder/dist-cjs/index.js
var require_dist_cjs31 = __commonJS({
  "../../../node_modules/@smithy/querystring-builder/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      buildQueryString: () => buildQueryString
    });
    module2.exports = __toCommonJS2(src_exports);
    var import_util_uri_escape = require_dist_cjs12();
    function buildQueryString(query) {
      const parts = [];
      for (let key of Object.keys(query).sort()) {
        const value = query[key];
        key = (0, import_util_uri_escape.escapeUri)(key);
        if (Array.isArray(value)) {
          for (let i = 0, iLen = value.length; i < iLen; i++) {
            parts.push(`${key}=${(0, import_util_uri_escape.escapeUri)(value[i])}`);
          }
        } else {
          let qsEntry = key;
          if (value || typeof value === "string") {
            qsEntry += `=${(0, import_util_uri_escape.escapeUri)(value)}`;
          }
          parts.push(qsEntry);
        }
      }
      return parts.join("&");
    }
    __name(buildQueryString, "buildQueryString");
  }
});

// ../../../node_modules/@smithy/node-http-handler/dist-cjs/index.js
var require_dist_cjs32 = __commonJS({
  "../../../node_modules/@smithy/node-http-handler/dist-cjs/index.js"(exports2, module2) {
    var __create2 = Object.create;
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __getProtoOf2 = Object.getPrototypeOf;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toESM2 = (mod, isNodeMode, target) => (target = mod != null ? __create2(__getProtoOf2(mod)) : {}, __copyProps2(
      // If the importer is in node compatibility mode or this is not an ESM
      // file that has been converted to a CommonJS file using a Babel-
      // compatible transform (i.e. "__esModule" has not been set), then set
      // "default" to the CommonJS "module.exports" for node compatibility.
      isNodeMode || !mod || !mod.__esModule ? __defProp2(target, "default", { value: mod, enumerable: true }) : target,
      mod
    ));
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      DEFAULT_REQUEST_TIMEOUT: () => DEFAULT_REQUEST_TIMEOUT,
      NodeHttp2Handler: () => NodeHttp2Handler,
      NodeHttpHandler: () => NodeHttpHandler,
      streamCollector: () => streamCollector
    });
    module2.exports = __toCommonJS2(src_exports);
    var import_protocol_http = require_dist_cjs2();
    var import_querystring_builder = require_dist_cjs31();
    var import_http2 = require("http");
    var import_https = require("https");
    var NODEJS_TIMEOUT_ERROR_CODES = ["ECONNRESET", "EPIPE", "ETIMEDOUT"];
    var getTransformedHeaders = /* @__PURE__ */ __name((headers) => {
      const transformedHeaders = {};
      for (const name of Object.keys(headers)) {
        const headerValues = headers[name];
        transformedHeaders[name] = Array.isArray(headerValues) ? headerValues.join(",") : headerValues;
      }
      return transformedHeaders;
    }, "getTransformedHeaders");
    var setConnectionTimeout = /* @__PURE__ */ __name((request2, reject, timeoutInMs = 0) => {
      if (!timeoutInMs) {
        return;
      }
      const timeoutId = setTimeout(() => {
        request2.destroy();
        reject(
          Object.assign(new Error(`Socket timed out without establishing a connection within ${timeoutInMs} ms`), {
            name: "TimeoutError"
          })
        );
      }, timeoutInMs);
      request2.on("socket", (socket) => {
        if (socket.connecting) {
          socket.on("connect", () => {
            clearTimeout(timeoutId);
          });
        } else {
          clearTimeout(timeoutId);
        }
      });
    }, "setConnectionTimeout");
    var setSocketKeepAlive = /* @__PURE__ */ __name((request2, { keepAlive, keepAliveMsecs }) => {
      if (keepAlive !== true) {
        return;
      }
      request2.on("socket", (socket) => {
        socket.setKeepAlive(keepAlive, keepAliveMsecs || 0);
      });
    }, "setSocketKeepAlive");
    var setSocketTimeout = /* @__PURE__ */ __name((request2, reject, timeoutInMs = 0) => {
      request2.setTimeout(timeoutInMs, () => {
        request2.destroy();
        reject(Object.assign(new Error(`Connection timed out after ${timeoutInMs} ms`), { name: "TimeoutError" }));
      });
    }, "setSocketTimeout");
    var import_stream = require("stream");
    var MIN_WAIT_TIME = 1e3;
    async function writeRequestBody(httpRequest, request2, maxContinueTimeoutMs = MIN_WAIT_TIME) {
      const headers = request2.headers ?? {};
      const expect = headers["Expect"] || headers["expect"];
      let timeoutId = -1;
      let hasError = false;
      if (expect === "100-continue") {
        await Promise.race([
          new Promise((resolve) => {
            timeoutId = Number(setTimeout(resolve, Math.max(MIN_WAIT_TIME, maxContinueTimeoutMs)));
          }),
          new Promise((resolve) => {
            httpRequest.on("continue", () => {
              clearTimeout(timeoutId);
              resolve();
            });
            httpRequest.on("error", () => {
              hasError = true;
              clearTimeout(timeoutId);
              resolve();
            });
          })
        ]);
      }
      if (!hasError) {
        writeBody(httpRequest, request2.body);
      }
    }
    __name(writeRequestBody, "writeRequestBody");
    function writeBody(httpRequest, body) {
      if (body instanceof import_stream.Readable) {
        body.pipe(httpRequest);
        return;
      }
      if (body) {
        if (Buffer.isBuffer(body) || typeof body === "string") {
          httpRequest.end(body);
          return;
        }
        const uint8 = body;
        if (typeof uint8 === "object" && uint8.buffer && typeof uint8.byteOffset === "number" && typeof uint8.byteLength === "number") {
          httpRequest.end(Buffer.from(uint8.buffer, uint8.byteOffset, uint8.byteLength));
          return;
        }
        httpRequest.end(Buffer.from(body));
        return;
      }
      httpRequest.end();
    }
    __name(writeBody, "writeBody");
    var DEFAULT_REQUEST_TIMEOUT = 0;
    var _NodeHttpHandler = class _NodeHttpHandler2 {
      constructor(options) {
        this.socketWarningTimestamp = 0;
        this.metadata = { handlerProtocol: "http/1.1" };
        this.configProvider = new Promise((resolve, reject) => {
          if (typeof options === "function") {
            options().then((_options) => {
              resolve(this.resolveDefaultConfig(_options));
            }).catch(reject);
          } else {
            resolve(this.resolveDefaultConfig(options));
          }
        });
      }
      /**
       * @returns the input if it is an HttpHandler of any class,
       * or instantiates a new instance of this handler.
       */
      static create(instanceOrOptions) {
        if (typeof (instanceOrOptions == null ? void 0 : instanceOrOptions.handle) === "function") {
          return instanceOrOptions;
        }
        return new _NodeHttpHandler2(instanceOrOptions);
      }
      /**
       * @internal
       *
       * @param agent - http(s) agent in use by the NodeHttpHandler instance.
       * @returns timestamp of last emitted warning.
       */
      static checkSocketUsage(agent, socketWarningTimestamp) {
        var _a, _b;
        const { sockets, requests, maxSockets } = agent;
        if (typeof maxSockets !== "number" || maxSockets === Infinity) {
          return socketWarningTimestamp;
        }
        const interval = 15e3;
        if (Date.now() - interval < socketWarningTimestamp) {
          return socketWarningTimestamp;
        }
        if (sockets && requests) {
          for (const origin in sockets) {
            const socketsInUse = ((_a = sockets[origin]) == null ? void 0 : _a.length) ?? 0;
            const requestsEnqueued = ((_b = requests[origin]) == null ? void 0 : _b.length) ?? 0;
            if (socketsInUse >= maxSockets && requestsEnqueued >= 2 * maxSockets) {
              console.warn(
                "@smithy/node-http-handler:WARN",
                `socket usage at capacity=${socketsInUse} and ${requestsEnqueued} additional requests are enqueued.`,
                "See https://docs.aws.amazon.com/sdk-for-javascript/v3/developer-guide/node-configuring-maxsockets.html",
                "or increase socketAcquisitionWarningTimeout=(millis) in the NodeHttpHandler config."
              );
              return Date.now();
            }
          }
        }
        return socketWarningTimestamp;
      }
      resolveDefaultConfig(options) {
        const { requestTimeout, connectionTimeout, socketTimeout, httpAgent, httpsAgent } = options || {};
        const keepAlive = true;
        const maxSockets = 50;
        return {
          connectionTimeout,
          requestTimeout: requestTimeout ?? socketTimeout,
          httpAgent: (() => {
            if (httpAgent instanceof import_http2.Agent || typeof (httpAgent == null ? void 0 : httpAgent.destroy) === "function") {
              return httpAgent;
            }
            return new import_http2.Agent({ keepAlive, maxSockets, ...httpAgent });
          })(),
          httpsAgent: (() => {
            if (httpsAgent instanceof import_https.Agent || typeof (httpsAgent == null ? void 0 : httpsAgent.destroy) === "function") {
              return httpsAgent;
            }
            return new import_https.Agent({ keepAlive, maxSockets, ...httpsAgent });
          })()
        };
      }
      destroy() {
        var _a, _b, _c, _d;
        (_b = (_a = this.config) == null ? void 0 : _a.httpAgent) == null ? void 0 : _b.destroy();
        (_d = (_c = this.config) == null ? void 0 : _c.httpsAgent) == null ? void 0 : _d.destroy();
      }
      async handle(request2, { abortSignal } = {}) {
        if (!this.config) {
          this.config = await this.configProvider;
        }
        let socketCheckTimeoutId;
        return new Promise((_resolve, _reject) => {
          let writeRequestBodyPromise = void 0;
          const resolve = /* @__PURE__ */ __name(async (arg) => {
            await writeRequestBodyPromise;
            clearTimeout(socketCheckTimeoutId);
            _resolve(arg);
          }, "resolve");
          const reject = /* @__PURE__ */ __name(async (arg) => {
            await writeRequestBodyPromise;
            _reject(arg);
          }, "reject");
          if (!this.config) {
            throw new Error("Node HTTP request handler config is not resolved");
          }
          if (abortSignal == null ? void 0 : abortSignal.aborted) {
            const abortError = new Error("Request aborted");
            abortError.name = "AbortError";
            reject(abortError);
            return;
          }
          const isSSL = request2.protocol === "https:";
          const agent = isSSL ? this.config.httpsAgent : this.config.httpAgent;
          socketCheckTimeoutId = setTimeout(() => {
            this.socketWarningTimestamp = _NodeHttpHandler2.checkSocketUsage(agent, this.socketWarningTimestamp);
          }, this.config.socketAcquisitionWarningTimeout ?? (this.config.requestTimeout ?? 2e3) + (this.config.connectionTimeout ?? 1e3));
          const queryString = (0, import_querystring_builder.buildQueryString)(request2.query || {});
          let auth = void 0;
          if (request2.username != null || request2.password != null) {
            const username = request2.username ?? "";
            const password = request2.password ?? "";
            auth = `${username}:${password}`;
          }
          let path = request2.path;
          if (queryString) {
            path += `?${queryString}`;
          }
          if (request2.fragment) {
            path += `#${request2.fragment}`;
          }
          const nodeHttpsOptions = {
            headers: request2.headers,
            host: request2.hostname,
            method: request2.method,
            path,
            port: request2.port,
            agent,
            auth
          };
          const requestFunc = isSSL ? import_https.request : import_http2.request;
          const req = requestFunc(nodeHttpsOptions, (res) => {
            const httpResponse = new import_protocol_http.HttpResponse({
              statusCode: res.statusCode || -1,
              reason: res.statusMessage,
              headers: getTransformedHeaders(res.headers),
              body: res
            });
            resolve({ response: httpResponse });
          });
          req.on("error", (err) => {
            if (NODEJS_TIMEOUT_ERROR_CODES.includes(err.code)) {
              reject(Object.assign(err, { name: "TimeoutError" }));
            } else {
              reject(err);
            }
          });
          setConnectionTimeout(req, reject, this.config.connectionTimeout);
          setSocketTimeout(req, reject, this.config.requestTimeout);
          if (abortSignal) {
            abortSignal.onabort = () => {
              req.abort();
              const abortError = new Error("Request aborted");
              abortError.name = "AbortError";
              reject(abortError);
            };
          }
          const httpAgent = nodeHttpsOptions.agent;
          if (typeof httpAgent === "object" && "keepAlive" in httpAgent) {
            setSocketKeepAlive(req, {
              // @ts-expect-error keepAlive is not public on httpAgent.
              keepAlive: httpAgent.keepAlive,
              // @ts-expect-error keepAliveMsecs is not public on httpAgent.
              keepAliveMsecs: httpAgent.keepAliveMsecs
            });
          }
          writeRequestBodyPromise = writeRequestBody(req, request2, this.config.requestTimeout).catch(_reject);
        });
      }
      updateHttpClientConfig(key, value) {
        this.config = void 0;
        this.configProvider = this.configProvider.then((config) => {
          return {
            ...config,
            [key]: value
          };
        });
      }
      httpHandlerConfigs() {
        return this.config ?? {};
      }
    };
    __name(_NodeHttpHandler, "NodeHttpHandler");
    var NodeHttpHandler = _NodeHttpHandler;
    var import_http22 = require("http2");
    var import_http23 = __toESM2(require("http2"));
    var _NodeHttp2ConnectionPool = class _NodeHttp2ConnectionPool {
      constructor(sessions) {
        this.sessions = [];
        this.sessions = sessions ?? [];
      }
      poll() {
        if (this.sessions.length > 0) {
          return this.sessions.shift();
        }
      }
      offerLast(session) {
        this.sessions.push(session);
      }
      contains(session) {
        return this.sessions.includes(session);
      }
      remove(session) {
        this.sessions = this.sessions.filter((s) => s !== session);
      }
      [Symbol.iterator]() {
        return this.sessions[Symbol.iterator]();
      }
      destroy(connection) {
        for (const session of this.sessions) {
          if (session === connection) {
            if (!session.destroyed) {
              session.destroy();
            }
          }
        }
      }
    };
    __name(_NodeHttp2ConnectionPool, "NodeHttp2ConnectionPool");
    var NodeHttp2ConnectionPool = _NodeHttp2ConnectionPool;
    var _NodeHttp2ConnectionManager = class _NodeHttp2ConnectionManager {
      constructor(config) {
        this.sessionCache = /* @__PURE__ */ new Map();
        this.config = config;
        if (this.config.maxConcurrency && this.config.maxConcurrency <= 0) {
          throw new RangeError("maxConcurrency must be greater than zero.");
        }
      }
      lease(requestContext, connectionConfiguration) {
        const url2 = this.getUrlString(requestContext);
        const existingPool = this.sessionCache.get(url2);
        if (existingPool) {
          const existingSession = existingPool.poll();
          if (existingSession && !this.config.disableConcurrency) {
            return existingSession;
          }
        }
        const session = import_http23.default.connect(url2);
        if (this.config.maxConcurrency) {
          session.settings({ maxConcurrentStreams: this.config.maxConcurrency }, (err) => {
            if (err) {
              throw new Error(
                "Fail to set maxConcurrentStreams to " + this.config.maxConcurrency + "when creating new session for " + requestContext.destination.toString()
              );
            }
          });
        }
        session.unref();
        const destroySessionCb = /* @__PURE__ */ __name(() => {
          session.destroy();
          this.deleteSession(url2, session);
        }, "destroySessionCb");
        session.on("goaway", destroySessionCb);
        session.on("error", destroySessionCb);
        session.on("frameError", destroySessionCb);
        session.on("close", () => this.deleteSession(url2, session));
        if (connectionConfiguration.requestTimeout) {
          session.setTimeout(connectionConfiguration.requestTimeout, destroySessionCb);
        }
        const connectionPool = this.sessionCache.get(url2) || new NodeHttp2ConnectionPool();
        connectionPool.offerLast(session);
        this.sessionCache.set(url2, connectionPool);
        return session;
      }
      /**
       * Delete a session from the connection pool.
       * @param authority The authority of the session to delete.
       * @param session The session to delete.
       */
      deleteSession(authority, session) {
        const existingConnectionPool = this.sessionCache.get(authority);
        if (!existingConnectionPool) {
          return;
        }
        if (!existingConnectionPool.contains(session)) {
          return;
        }
        existingConnectionPool.remove(session);
        this.sessionCache.set(authority, existingConnectionPool);
      }
      release(requestContext, session) {
        var _a;
        const cacheKey = this.getUrlString(requestContext);
        (_a = this.sessionCache.get(cacheKey)) == null ? void 0 : _a.offerLast(session);
      }
      destroy() {
        for (const [key, connectionPool] of this.sessionCache) {
          for (const session of connectionPool) {
            if (!session.destroyed) {
              session.destroy();
            }
            connectionPool.remove(session);
          }
          this.sessionCache.delete(key);
        }
      }
      setMaxConcurrentStreams(maxConcurrentStreams) {
        if (this.config.maxConcurrency && this.config.maxConcurrency <= 0) {
          throw new RangeError("maxConcurrentStreams must be greater than zero.");
        }
        this.config.maxConcurrency = maxConcurrentStreams;
      }
      setDisableConcurrentStreams(disableConcurrentStreams) {
        this.config.disableConcurrency = disableConcurrentStreams;
      }
      getUrlString(request2) {
        return request2.destination.toString();
      }
    };
    __name(_NodeHttp2ConnectionManager, "NodeHttp2ConnectionManager");
    var NodeHttp2ConnectionManager = _NodeHttp2ConnectionManager;
    var _NodeHttp2Handler = class _NodeHttp2Handler2 {
      constructor(options) {
        this.metadata = { handlerProtocol: "h2" };
        this.connectionManager = new NodeHttp2ConnectionManager({});
        this.configProvider = new Promise((resolve, reject) => {
          if (typeof options === "function") {
            options().then((opts) => {
              resolve(opts || {});
            }).catch(reject);
          } else {
            resolve(options || {});
          }
        });
      }
      /**
       * @returns the input if it is an HttpHandler of any class,
       * or instantiates a new instance of this handler.
       */
      static create(instanceOrOptions) {
        if (typeof (instanceOrOptions == null ? void 0 : instanceOrOptions.handle) === "function") {
          return instanceOrOptions;
        }
        return new _NodeHttp2Handler2(instanceOrOptions);
      }
      destroy() {
        this.connectionManager.destroy();
      }
      async handle(request2, { abortSignal } = {}) {
        if (!this.config) {
          this.config = await this.configProvider;
          this.connectionManager.setDisableConcurrentStreams(this.config.disableConcurrentStreams || false);
          if (this.config.maxConcurrentStreams) {
            this.connectionManager.setMaxConcurrentStreams(this.config.maxConcurrentStreams);
          }
        }
        const { requestTimeout, disableConcurrentStreams } = this.config;
        return new Promise((_resolve, _reject) => {
          var _a;
          let fulfilled = false;
          let writeRequestBodyPromise = void 0;
          const resolve = /* @__PURE__ */ __name(async (arg) => {
            await writeRequestBodyPromise;
            _resolve(arg);
          }, "resolve");
          const reject = /* @__PURE__ */ __name(async (arg) => {
            await writeRequestBodyPromise;
            _reject(arg);
          }, "reject");
          if (abortSignal == null ? void 0 : abortSignal.aborted) {
            fulfilled = true;
            const abortError = new Error("Request aborted");
            abortError.name = "AbortError";
            reject(abortError);
            return;
          }
          const { hostname, method, port, protocol, query } = request2;
          let auth = "";
          if (request2.username != null || request2.password != null) {
            const username = request2.username ?? "";
            const password = request2.password ?? "";
            auth = `${username}:${password}@`;
          }
          const authority = `${protocol}//${auth}${hostname}${port ? `:${port}` : ""}`;
          const requestContext = { destination: new URL(authority) };
          const session = this.connectionManager.lease(requestContext, {
            requestTimeout: (_a = this.config) == null ? void 0 : _a.sessionTimeout,
            disableConcurrentStreams: disableConcurrentStreams || false
          });
          const rejectWithDestroy = /* @__PURE__ */ __name((err) => {
            if (disableConcurrentStreams) {
              this.destroySession(session);
            }
            fulfilled = true;
            reject(err);
          }, "rejectWithDestroy");
          const queryString = (0, import_querystring_builder.buildQueryString)(query || {});
          let path = request2.path;
          if (queryString) {
            path += `?${queryString}`;
          }
          if (request2.fragment) {
            path += `#${request2.fragment}`;
          }
          const req = session.request({
            ...request2.headers,
            [import_http22.constants.HTTP2_HEADER_PATH]: path,
            [import_http22.constants.HTTP2_HEADER_METHOD]: method
          });
          session.ref();
          req.on("response", (headers) => {
            const httpResponse = new import_protocol_http.HttpResponse({
              statusCode: headers[":status"] || -1,
              headers: getTransformedHeaders(headers),
              body: req
            });
            fulfilled = true;
            resolve({ response: httpResponse });
            if (disableConcurrentStreams) {
              session.close();
              this.connectionManager.deleteSession(authority, session);
            }
          });
          if (requestTimeout) {
            req.setTimeout(requestTimeout, () => {
              req.close();
              const timeoutError = new Error(`Stream timed out because of no activity for ${requestTimeout} ms`);
              timeoutError.name = "TimeoutError";
              rejectWithDestroy(timeoutError);
            });
          }
          if (abortSignal) {
            abortSignal.onabort = () => {
              req.close();
              const abortError = new Error("Request aborted");
              abortError.name = "AbortError";
              rejectWithDestroy(abortError);
            };
          }
          req.on("frameError", (type, code, id) => {
            rejectWithDestroy(new Error(`Frame type id ${type} in stream id ${id} has failed with code ${code}.`));
          });
          req.on("error", rejectWithDestroy);
          req.on("aborted", () => {
            rejectWithDestroy(
              new Error(`HTTP/2 stream is abnormally aborted in mid-communication with result code ${req.rstCode}.`)
            );
          });
          req.on("close", () => {
            session.unref();
            if (disableConcurrentStreams) {
              session.destroy();
            }
            if (!fulfilled) {
              rejectWithDestroy(new Error("Unexpected error: http2 request did not get a response"));
            }
          });
          writeRequestBodyPromise = writeRequestBody(req, request2, requestTimeout);
        });
      }
      updateHttpClientConfig(key, value) {
        this.config = void 0;
        this.configProvider = this.configProvider.then((config) => {
          return {
            ...config,
            [key]: value
          };
        });
      }
      httpHandlerConfigs() {
        return this.config ?? {};
      }
      /**
       * Destroys a session.
       * @param session The session to destroy.
       */
      destroySession(session) {
        if (!session.destroyed) {
          session.destroy();
        }
      }
    };
    __name(_NodeHttp2Handler, "NodeHttp2Handler");
    var NodeHttp2Handler = _NodeHttp2Handler;
    var _Collector = class _Collector extends import_stream.Writable {
      constructor() {
        super(...arguments);
        this.bufferedBytes = [];
      }
      _write(chunk, encoding, callback) {
        this.bufferedBytes.push(chunk);
        callback();
      }
    };
    __name(_Collector, "Collector");
    var Collector = _Collector;
    var streamCollector = /* @__PURE__ */ __name((stream) => new Promise((resolve, reject) => {
      const collector = new Collector();
      stream.pipe(collector);
      stream.on("error", (err) => {
        collector.end();
        reject(err);
      });
      collector.on("error", reject);
      collector.on("finish", function() {
        const bytes = new Uint8Array(Buffer.concat(this.bufferedBytes));
        resolve(bytes);
      });
    }), "streamCollector");
  }
});

// ../../../node_modules/@smithy/util-stream/dist-cjs/sdk-stream-mixin.js
var require_sdk_stream_mixin = __commonJS({
  "../../../node_modules/@smithy/util-stream/dist-cjs/sdk-stream-mixin.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.sdkStreamMixin = void 0;
    var node_http_handler_1 = require_dist_cjs32();
    var util_buffer_from_1 = require_dist_cjs9();
    var stream_1 = require("stream");
    var util_1 = require("util");
    var ERR_MSG_STREAM_HAS_BEEN_TRANSFORMED = "The stream has already been transformed.";
    var sdkStreamMixin2 = (stream) => {
      var _a, _b;
      if (!(stream instanceof stream_1.Readable)) {
        const name = ((_b = (_a = stream === null || stream === void 0 ? void 0 : stream.__proto__) === null || _a === void 0 ? void 0 : _a.constructor) === null || _b === void 0 ? void 0 : _b.name) || stream;
        throw new Error(`Unexpected stream implementation, expect Stream.Readable instance, got ${name}`);
      }
      let transformed = false;
      const transformToByteArray = async () => {
        if (transformed) {
          throw new Error(ERR_MSG_STREAM_HAS_BEEN_TRANSFORMED);
        }
        transformed = true;
        return await (0, node_http_handler_1.streamCollector)(stream);
      };
      return Object.assign(stream, {
        transformToByteArray,
        transformToString: async (encoding) => {
          const buf = await transformToByteArray();
          if (encoding === void 0 || Buffer.isEncoding(encoding)) {
            return (0, util_buffer_from_1.fromArrayBuffer)(buf.buffer, buf.byteOffset, buf.byteLength).toString(encoding);
          } else {
            const decoder2 = new util_1.TextDecoder(encoding);
            return decoder2.decode(buf);
          }
        },
        transformToWebStream: () => {
          if (transformed) {
            throw new Error(ERR_MSG_STREAM_HAS_BEEN_TRANSFORMED);
          }
          if (stream.readableFlowing !== null) {
            throw new Error("The stream has been consumed by other callbacks.");
          }
          if (typeof stream_1.Readable.toWeb !== "function") {
            throw new Error("Readable.toWeb() is not supported. Please make sure you are using Node.js >= 17.0.0, or polyfill is available.");
          }
          transformed = true;
          return stream_1.Readable.toWeb(stream);
        }
      });
    };
    exports2.sdkStreamMixin = sdkStreamMixin2;
  }
});

// ../../../node_modules/@smithy/util-stream/dist-cjs/index.js
var require_dist_cjs33 = __commonJS({
  "../../../node_modules/@smithy/util-stream/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __reExport = (target, mod, secondTarget) => (__copyProps2(target, mod, "default"), secondTarget && __copyProps2(secondTarget, mod, "default"));
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      Uint8ArrayBlobAdapter: () => Uint8ArrayBlobAdapter
    });
    module2.exports = __toCommonJS2(src_exports);
    var import_util_base64 = require_dist_cjs30();
    var import_util_utf8 = require_dist_cjs10();
    function transformToString(payload, encoding = "utf-8") {
      if (encoding === "base64") {
        return (0, import_util_base64.toBase64)(payload);
      }
      return (0, import_util_utf8.toUtf8)(payload);
    }
    __name(transformToString, "transformToString");
    function transformFromString(str, encoding) {
      if (encoding === "base64") {
        return Uint8ArrayBlobAdapter.mutate((0, import_util_base64.fromBase64)(str));
      }
      return Uint8ArrayBlobAdapter.mutate((0, import_util_utf8.fromUtf8)(str));
    }
    __name(transformFromString, "transformFromString");
    var _Uint8ArrayBlobAdapter = class _Uint8ArrayBlobAdapter2 extends Uint8Array {
      /**
       * @param source - such as a string or Stream.
       * @returns a new Uint8ArrayBlobAdapter extending Uint8Array.
       */
      static fromString(source, encoding = "utf-8") {
        switch (typeof source) {
          case "string":
            return transformFromString(source, encoding);
          default:
            throw new Error(`Unsupported conversion from ${typeof source} to Uint8ArrayBlobAdapter.`);
        }
      }
      /**
       * @param source - Uint8Array to be mutated.
       * @returns the same Uint8Array but with prototype switched to Uint8ArrayBlobAdapter.
       */
      static mutate(source) {
        Object.setPrototypeOf(source, _Uint8ArrayBlobAdapter2.prototype);
        return source;
      }
      /**
       * @param encoding - default 'utf-8'.
       * @returns the blob as string.
       */
      transformToString(encoding = "utf-8") {
        return transformToString(this, encoding);
      }
    };
    __name(_Uint8ArrayBlobAdapter, "Uint8ArrayBlobAdapter");
    var Uint8ArrayBlobAdapter = _Uint8ArrayBlobAdapter;
    __reExport(src_exports, require_getAwsChunkedEncodingStream(), module2.exports);
    __reExport(src_exports, require_sdk_stream_mixin(), module2.exports);
  }
});

// ../../../node_modules/@smithy/smithy-client/dist-cjs/index.js
var require_dist_cjs34 = __commonJS({
  "../../../node_modules/@smithy/smithy-client/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      Client: () => Client,
      Command: () => Command,
      LazyJsonString: () => LazyJsonString,
      NoOpLogger: () => NoOpLogger,
      SENSITIVE_STRING: () => SENSITIVE_STRING,
      ServiceException: () => ServiceException,
      StringWrapper: () => StringWrapper,
      _json: () => _json,
      collectBody: () => collectBody,
      convertMap: () => convertMap,
      createAggregatedClient: () => createAggregatedClient,
      dateToUtcString: () => dateToUtcString,
      decorateServiceException: () => decorateServiceException,
      emitWarningIfUnsupportedVersion: () => emitWarningIfUnsupportedVersion,
      expectBoolean: () => expectBoolean,
      expectByte: () => expectByte,
      expectFloat32: () => expectFloat32,
      expectInt: () => expectInt,
      expectInt32: () => expectInt32,
      expectLong: () => expectLong,
      expectNonNull: () => expectNonNull,
      expectNumber: () => expectNumber,
      expectObject: () => expectObject,
      expectShort: () => expectShort,
      expectString: () => expectString,
      expectUnion: () => expectUnion,
      extendedEncodeURIComponent: () => extendedEncodeURIComponent,
      getArrayIfSingleItem: () => getArrayIfSingleItem,
      getDefaultClientConfiguration: () => getDefaultClientConfiguration,
      getDefaultExtensionConfiguration: () => getDefaultExtensionConfiguration,
      getValueFromTextNode: () => getValueFromTextNode,
      handleFloat: () => handleFloat,
      limitedParseDouble: () => limitedParseDouble,
      limitedParseFloat: () => limitedParseFloat,
      limitedParseFloat32: () => limitedParseFloat32,
      loadConfigsForDefaultMode: () => loadConfigsForDefaultMode,
      logger: () => logger,
      map: () => map,
      parseBoolean: () => parseBoolean,
      parseEpochTimestamp: () => parseEpochTimestamp,
      parseRfc3339DateTime: () => parseRfc3339DateTime,
      parseRfc3339DateTimeWithOffset: () => parseRfc3339DateTimeWithOffset,
      parseRfc7231DateTime: () => parseRfc7231DateTime,
      resolveDefaultRuntimeConfig: () => resolveDefaultRuntimeConfig,
      resolvedPath: () => resolvedPath,
      serializeFloat: () => serializeFloat,
      splitEvery: () => splitEvery,
      strictParseByte: () => strictParseByte,
      strictParseDouble: () => strictParseDouble,
      strictParseFloat: () => strictParseFloat,
      strictParseFloat32: () => strictParseFloat32,
      strictParseInt: () => strictParseInt,
      strictParseInt32: () => strictParseInt32,
      strictParseLong: () => strictParseLong,
      strictParseShort: () => strictParseShort,
      take: () => take,
      throwDefaultError: () => throwDefaultError,
      withBaseException: () => withBaseException
    });
    module2.exports = __toCommonJS2(src_exports);
    var _NoOpLogger = class _NoOpLogger {
      trace() {
      }
      debug() {
      }
      info() {
      }
      warn() {
      }
      error() {
      }
    };
    __name(_NoOpLogger, "NoOpLogger");
    var NoOpLogger = _NoOpLogger;
    var import_middleware_stack = require_dist_cjs29();
    var _Client = class _Client {
      constructor(config) {
        this.middlewareStack = (0, import_middleware_stack.constructStack)();
        this.config = config;
      }
      send(command, optionsOrCb, cb) {
        const options = typeof optionsOrCb !== "function" ? optionsOrCb : void 0;
        const callback = typeof optionsOrCb === "function" ? optionsOrCb : cb;
        const handler2 = command.resolveMiddleware(this.middlewareStack, this.config, options);
        if (callback) {
          handler2(command).then(
            (result) => callback(null, result.output),
            (err) => callback(err)
          ).catch(
            // prevent any errors thrown in the callback from triggering an
            // unhandled promise rejection
            () => {
            }
          );
        } else {
          return handler2(command).then((result) => result.output);
        }
      }
      destroy() {
        if (this.config.requestHandler.destroy)
          this.config.requestHandler.destroy();
      }
    };
    __name(_Client, "Client");
    var Client = _Client;
    var import_util_stream = require_dist_cjs33();
    var collectBody = /* @__PURE__ */ __name(async (streamBody = new Uint8Array(), context) => {
      if (streamBody instanceof Uint8Array) {
        return import_util_stream.Uint8ArrayBlobAdapter.mutate(streamBody);
      }
      if (!streamBody) {
        return import_util_stream.Uint8ArrayBlobAdapter.mutate(new Uint8Array());
      }
      const fromContext = context.streamCollector(streamBody);
      return import_util_stream.Uint8ArrayBlobAdapter.mutate(await fromContext);
    }, "collectBody");
    var import_types = require_dist_cjs();
    var _Command = class _Command {
      constructor() {
        this.middlewareStack = (0, import_middleware_stack.constructStack)();
      }
      /**
       * Factory for Command ClassBuilder.
       * @internal
       */
      static classBuilder() {
        return new ClassBuilder();
      }
      /**
       * @internal
       */
      resolveMiddlewareWithContext(clientStack, configuration, options, {
        middlewareFn,
        clientName,
        commandName,
        inputFilterSensitiveLog,
        outputFilterSensitiveLog,
        smithyContext,
        additionalContext,
        CommandCtor
      }) {
        for (const mw of middlewareFn.bind(this)(CommandCtor, clientStack, configuration, options)) {
          this.middlewareStack.use(mw);
        }
        const stack = clientStack.concat(this.middlewareStack);
        const { logger: logger2 } = configuration;
        const handlerExecutionContext = {
          logger: logger2,
          clientName,
          commandName,
          inputFilterSensitiveLog,
          outputFilterSensitiveLog,
          [import_types.SMITHY_CONTEXT_KEY]: {
            ...smithyContext
          },
          ...additionalContext
        };
        const { requestHandler } = configuration;
        return stack.resolve(
          (request2) => requestHandler.handle(request2.request, options || {}),
          handlerExecutionContext
        );
      }
    };
    __name(_Command, "Command");
    var Command = _Command;
    var _ClassBuilder = class _ClassBuilder {
      constructor() {
        this._init = () => {
        };
        this._ep = {};
        this._middlewareFn = () => [];
        this._commandName = "";
        this._clientName = "";
        this._additionalContext = {};
        this._smithyContext = {};
        this._inputFilterSensitiveLog = (_) => _;
        this._outputFilterSensitiveLog = (_) => _;
        this._serializer = null;
        this._deserializer = null;
      }
      /**
       * Optional init callback.
       */
      init(cb) {
        this._init = cb;
      }
      /**
       * Set the endpoint parameter instructions.
       */
      ep(endpointParameterInstructions) {
        this._ep = endpointParameterInstructions;
        return this;
      }
      /**
       * Add any number of middleware.
       */
      m(middlewareSupplier) {
        this._middlewareFn = middlewareSupplier;
        return this;
      }
      /**
       * Set the initial handler execution context Smithy field.
       */
      s(service, operation, smithyContext = {}) {
        this._smithyContext = {
          service,
          operation,
          ...smithyContext
        };
        return this;
      }
      /**
       * Set the initial handler execution context.
       */
      c(additionalContext = {}) {
        this._additionalContext = additionalContext;
        return this;
      }
      /**
       * Set constant string identifiers for the operation.
       */
      n(clientName, commandName) {
        this._clientName = clientName;
        this._commandName = commandName;
        return this;
      }
      /**
       * Set the input and output sensistive log filters.
       */
      f(inputFilter = (_) => _, outputFilter = (_) => _) {
        this._inputFilterSensitiveLog = inputFilter;
        this._outputFilterSensitiveLog = outputFilter;
        return this;
      }
      /**
       * Sets the serializer.
       */
      ser(serializer) {
        this._serializer = serializer;
        return this;
      }
      /**
       * Sets the deserializer.
       */
      de(deserializer) {
        this._deserializer = deserializer;
        return this;
      }
      /**
       * @returns a Command class with the classBuilder properties.
       */
      build() {
        var _a;
        const closure = this;
        let CommandRef;
        return CommandRef = (_a = class extends Command {
          /**
           * @public
           */
          constructor(...[input]) {
            super();
            this.serialize = closure._serializer;
            this.deserialize = closure._deserializer;
            this.input = input ?? {};
            closure._init(this);
          }
          /**
           * @public
           */
          static getEndpointParameterInstructions() {
            return closure._ep;
          }
          /**
           * @internal
           */
          resolveMiddleware(stack, configuration, options) {
            return this.resolveMiddlewareWithContext(stack, configuration, options, {
              CommandCtor: CommandRef,
              middlewareFn: closure._middlewareFn,
              clientName: closure._clientName,
              commandName: closure._commandName,
              inputFilterSensitiveLog: closure._inputFilterSensitiveLog,
              outputFilterSensitiveLog: closure._outputFilterSensitiveLog,
              smithyContext: closure._smithyContext,
              additionalContext: closure._additionalContext
            });
          }
        }, __name(_a, "CommandRef"), _a);
      }
    };
    __name(_ClassBuilder, "ClassBuilder");
    var ClassBuilder = _ClassBuilder;
    var SENSITIVE_STRING = "***SensitiveInformation***";
    var createAggregatedClient = /* @__PURE__ */ __name((commands, Client2) => {
      for (const command of Object.keys(commands)) {
        const CommandCtor = commands[command];
        const methodImpl = /* @__PURE__ */ __name(async function(args, optionsOrCb, cb) {
          const command2 = new CommandCtor(args);
          if (typeof optionsOrCb === "function") {
            this.send(command2, optionsOrCb);
          } else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
              throw new Error(`Expected http options but got ${typeof optionsOrCb}`);
            this.send(command2, optionsOrCb || {}, cb);
          } else {
            return this.send(command2, optionsOrCb);
          }
        }, "methodImpl");
        const methodName = (command[0].toLowerCase() + command.slice(1)).replace(/Command$/, "");
        Client2.prototype[methodName] = methodImpl;
      }
    }, "createAggregatedClient");
    var parseBoolean = /* @__PURE__ */ __name((value) => {
      switch (value) {
        case "true":
          return true;
        case "false":
          return false;
        default:
          throw new Error(`Unable to parse boolean value "${value}"`);
      }
    }, "parseBoolean");
    var expectBoolean = /* @__PURE__ */ __name((value) => {
      if (value === null || value === void 0) {
        return void 0;
      }
      if (typeof value === "number") {
        if (value === 0 || value === 1) {
          logger.warn(stackTraceWarning(`Expected boolean, got ${typeof value}: ${value}`));
        }
        if (value === 0) {
          return false;
        }
        if (value === 1) {
          return true;
        }
      }
      if (typeof value === "string") {
        const lower = value.toLowerCase();
        if (lower === "false" || lower === "true") {
          logger.warn(stackTraceWarning(`Expected boolean, got ${typeof value}: ${value}`));
        }
        if (lower === "false") {
          return false;
        }
        if (lower === "true") {
          return true;
        }
      }
      if (typeof value === "boolean") {
        return value;
      }
      throw new TypeError(`Expected boolean, got ${typeof value}: ${value}`);
    }, "expectBoolean");
    var expectNumber = /* @__PURE__ */ __name((value) => {
      if (value === null || value === void 0) {
        return void 0;
      }
      if (typeof value === "string") {
        const parsed = parseFloat(value);
        if (!Number.isNaN(parsed)) {
          if (String(parsed) !== String(value)) {
            logger.warn(stackTraceWarning(`Expected number but observed string: ${value}`));
          }
          return parsed;
        }
      }
      if (typeof value === "number") {
        return value;
      }
      throw new TypeError(`Expected number, got ${typeof value}: ${value}`);
    }, "expectNumber");
    var MAX_FLOAT = Math.ceil(2 ** 127 * (2 - 2 ** -23));
    var expectFloat32 = /* @__PURE__ */ __name((value) => {
      const expected = expectNumber(value);
      if (expected !== void 0 && !Number.isNaN(expected) && expected !== Infinity && expected !== -Infinity) {
        if (Math.abs(expected) > MAX_FLOAT) {
          throw new TypeError(`Expected 32-bit float, got ${value}`);
        }
      }
      return expected;
    }, "expectFloat32");
    var expectLong = /* @__PURE__ */ __name((value) => {
      if (value === null || value === void 0) {
        return void 0;
      }
      if (Number.isInteger(value) && !Number.isNaN(value)) {
        return value;
      }
      throw new TypeError(`Expected integer, got ${typeof value}: ${value}`);
    }, "expectLong");
    var expectInt = expectLong;
    var expectInt32 = /* @__PURE__ */ __name((value) => expectSizedInt(value, 32), "expectInt32");
    var expectShort = /* @__PURE__ */ __name((value) => expectSizedInt(value, 16), "expectShort");
    var expectByte = /* @__PURE__ */ __name((value) => expectSizedInt(value, 8), "expectByte");
    var expectSizedInt = /* @__PURE__ */ __name((value, size) => {
      const expected = expectLong(value);
      if (expected !== void 0 && castInt(expected, size) !== expected) {
        throw new TypeError(`Expected ${size}-bit integer, got ${value}`);
      }
      return expected;
    }, "expectSizedInt");
    var castInt = /* @__PURE__ */ __name((value, size) => {
      switch (size) {
        case 32:
          return Int32Array.of(value)[0];
        case 16:
          return Int16Array.of(value)[0];
        case 8:
          return Int8Array.of(value)[0];
      }
    }, "castInt");
    var expectNonNull = /* @__PURE__ */ __name((value, location) => {
      if (value === null || value === void 0) {
        if (location) {
          throw new TypeError(`Expected a non-null value for ${location}`);
        }
        throw new TypeError("Expected a non-null value");
      }
      return value;
    }, "expectNonNull");
    var expectObject = /* @__PURE__ */ __name((value) => {
      if (value === null || value === void 0) {
        return void 0;
      }
      if (typeof value === "object" && !Array.isArray(value)) {
        return value;
      }
      const receivedType = Array.isArray(value) ? "array" : typeof value;
      throw new TypeError(`Expected object, got ${receivedType}: ${value}`);
    }, "expectObject");
    var expectString = /* @__PURE__ */ __name((value) => {
      if (value === null || value === void 0) {
        return void 0;
      }
      if (typeof value === "string") {
        return value;
      }
      if (["boolean", "number", "bigint"].includes(typeof value)) {
        logger.warn(stackTraceWarning(`Expected string, got ${typeof value}: ${value}`));
        return String(value);
      }
      throw new TypeError(`Expected string, got ${typeof value}: ${value}`);
    }, "expectString");
    var expectUnion = /* @__PURE__ */ __name((value) => {
      if (value === null || value === void 0) {
        return void 0;
      }
      const asObject = expectObject(value);
      const setKeys = Object.entries(asObject).filter(([, v]) => v != null).map(([k]) => k);
      if (setKeys.length === 0) {
        throw new TypeError(`Unions must have exactly one non-null member. None were found.`);
      }
      if (setKeys.length > 1) {
        throw new TypeError(`Unions must have exactly one non-null member. Keys ${setKeys} were not null.`);
      }
      return asObject;
    }, "expectUnion");
    var strictParseDouble = /* @__PURE__ */ __name((value) => {
      if (typeof value == "string") {
        return expectNumber(parseNumber(value));
      }
      return expectNumber(value);
    }, "strictParseDouble");
    var strictParseFloat = strictParseDouble;
    var strictParseFloat32 = /* @__PURE__ */ __name((value) => {
      if (typeof value == "string") {
        return expectFloat32(parseNumber(value));
      }
      return expectFloat32(value);
    }, "strictParseFloat32");
    var NUMBER_REGEX = /(-?(?:0|[1-9]\d*)(?:\.\d+)?(?:[eE][+-]?\d+)?)|(-?Infinity)|(NaN)/g;
    var parseNumber = /* @__PURE__ */ __name((value) => {
      const matches = value.match(NUMBER_REGEX);
      if (matches === null || matches[0].length !== value.length) {
        throw new TypeError(`Expected real number, got implicit NaN`);
      }
      return parseFloat(value);
    }, "parseNumber");
    var limitedParseDouble = /* @__PURE__ */ __name((value) => {
      if (typeof value == "string") {
        return parseFloatString(value);
      }
      return expectNumber(value);
    }, "limitedParseDouble");
    var handleFloat = limitedParseDouble;
    var limitedParseFloat = limitedParseDouble;
    var limitedParseFloat32 = /* @__PURE__ */ __name((value) => {
      if (typeof value == "string") {
        return parseFloatString(value);
      }
      return expectFloat32(value);
    }, "limitedParseFloat32");
    var parseFloatString = /* @__PURE__ */ __name((value) => {
      switch (value) {
        case "NaN":
          return NaN;
        case "Infinity":
          return Infinity;
        case "-Infinity":
          return -Infinity;
        default:
          throw new Error(`Unable to parse float value: ${value}`);
      }
    }, "parseFloatString");
    var strictParseLong = /* @__PURE__ */ __name((value) => {
      if (typeof value === "string") {
        return expectLong(parseNumber(value));
      }
      return expectLong(value);
    }, "strictParseLong");
    var strictParseInt = strictParseLong;
    var strictParseInt32 = /* @__PURE__ */ __name((value) => {
      if (typeof value === "string") {
        return expectInt32(parseNumber(value));
      }
      return expectInt32(value);
    }, "strictParseInt32");
    var strictParseShort = /* @__PURE__ */ __name((value) => {
      if (typeof value === "string") {
        return expectShort(parseNumber(value));
      }
      return expectShort(value);
    }, "strictParseShort");
    var strictParseByte = /* @__PURE__ */ __name((value) => {
      if (typeof value === "string") {
        return expectByte(parseNumber(value));
      }
      return expectByte(value);
    }, "strictParseByte");
    var stackTraceWarning = /* @__PURE__ */ __name((message) => {
      return String(new TypeError(message).stack || message).split("\n").slice(0, 5).filter((s) => !s.includes("stackTraceWarning")).join("\n");
    }, "stackTraceWarning");
    var logger = {
      warn: console.warn
    };
    var DAYS = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
    var MONTHS = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
    function dateToUtcString(date) {
      const year = date.getUTCFullYear();
      const month = date.getUTCMonth();
      const dayOfWeek = date.getUTCDay();
      const dayOfMonthInt = date.getUTCDate();
      const hoursInt = date.getUTCHours();
      const minutesInt = date.getUTCMinutes();
      const secondsInt = date.getUTCSeconds();
      const dayOfMonthString = dayOfMonthInt < 10 ? `0${dayOfMonthInt}` : `${dayOfMonthInt}`;
      const hoursString = hoursInt < 10 ? `0${hoursInt}` : `${hoursInt}`;
      const minutesString = minutesInt < 10 ? `0${minutesInt}` : `${minutesInt}`;
      const secondsString = secondsInt < 10 ? `0${secondsInt}` : `${secondsInt}`;
      return `${DAYS[dayOfWeek]}, ${dayOfMonthString} ${MONTHS[month]} ${year} ${hoursString}:${minutesString}:${secondsString} GMT`;
    }
    __name(dateToUtcString, "dateToUtcString");
    var RFC3339 = new RegExp(/^(\d{4})-(\d{2})-(\d{2})[tT](\d{2}):(\d{2}):(\d{2})(?:\.(\d+))?[zZ]$/);
    var parseRfc3339DateTime = /* @__PURE__ */ __name((value) => {
      if (value === null || value === void 0) {
        return void 0;
      }
      if (typeof value !== "string") {
        throw new TypeError("RFC-3339 date-times must be expressed as strings");
      }
      const match = RFC3339.exec(value);
      if (!match) {
        throw new TypeError("Invalid RFC-3339 date-time value");
      }
      const [_, yearStr, monthStr, dayStr, hours, minutes, seconds, fractionalMilliseconds] = match;
      const year = strictParseShort(stripLeadingZeroes(yearStr));
      const month = parseDateValue(monthStr, "month", 1, 12);
      const day = parseDateValue(dayStr, "day", 1, 31);
      return buildDate(year, month, day, { hours, minutes, seconds, fractionalMilliseconds });
    }, "parseRfc3339DateTime");
    var RFC3339_WITH_OFFSET = new RegExp(
      /^(\d{4})-(\d{2})-(\d{2})[tT](\d{2}):(\d{2}):(\d{2})(?:\.(\d+))?(([-+]\d{2}\:\d{2})|[zZ])$/
    );
    var parseRfc3339DateTimeWithOffset = /* @__PURE__ */ __name((value) => {
      if (value === null || value === void 0) {
        return void 0;
      }
      if (typeof value !== "string") {
        throw new TypeError("RFC-3339 date-times must be expressed as strings");
      }
      const match = RFC3339_WITH_OFFSET.exec(value);
      if (!match) {
        throw new TypeError("Invalid RFC-3339 date-time value");
      }
      const [_, yearStr, monthStr, dayStr, hours, minutes, seconds, fractionalMilliseconds, offsetStr] = match;
      const year = strictParseShort(stripLeadingZeroes(yearStr));
      const month = parseDateValue(monthStr, "month", 1, 12);
      const day = parseDateValue(dayStr, "day", 1, 31);
      const date = buildDate(year, month, day, { hours, minutes, seconds, fractionalMilliseconds });
      if (offsetStr.toUpperCase() != "Z") {
        date.setTime(date.getTime() - parseOffsetToMilliseconds(offsetStr));
      }
      return date;
    }, "parseRfc3339DateTimeWithOffset");
    var IMF_FIXDATE = new RegExp(
      /^(?:Mon|Tue|Wed|Thu|Fri|Sat|Sun), (\d{2}) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) (\d{4}) (\d{1,2}):(\d{2}):(\d{2})(?:\.(\d+))? GMT$/
    );
    var RFC_850_DATE = new RegExp(
      /^(?:Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|Sunday), (\d{2})-(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)-(\d{2}) (\d{1,2}):(\d{2}):(\d{2})(?:\.(\d+))? GMT$/
    );
    var ASC_TIME = new RegExp(
      /^(?:Mon|Tue|Wed|Thu|Fri|Sat|Sun) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) ( [1-9]|\d{2}) (\d{1,2}):(\d{2}):(\d{2})(?:\.(\d+))? (\d{4})$/
    );
    var parseRfc7231DateTime = /* @__PURE__ */ __name((value) => {
      if (value === null || value === void 0) {
        return void 0;
      }
      if (typeof value !== "string") {
        throw new TypeError("RFC-7231 date-times must be expressed as strings");
      }
      let match = IMF_FIXDATE.exec(value);
      if (match) {
        const [_, dayStr, monthStr, yearStr, hours, minutes, seconds, fractionalMilliseconds] = match;
        return buildDate(
          strictParseShort(stripLeadingZeroes(yearStr)),
          parseMonthByShortName(monthStr),
          parseDateValue(dayStr, "day", 1, 31),
          { hours, minutes, seconds, fractionalMilliseconds }
        );
      }
      match = RFC_850_DATE.exec(value);
      if (match) {
        const [_, dayStr, monthStr, yearStr, hours, minutes, seconds, fractionalMilliseconds] = match;
        return adjustRfc850Year(
          buildDate(parseTwoDigitYear(yearStr), parseMonthByShortName(monthStr), parseDateValue(dayStr, "day", 1, 31), {
            hours,
            minutes,
            seconds,
            fractionalMilliseconds
          })
        );
      }
      match = ASC_TIME.exec(value);
      if (match) {
        const [_, monthStr, dayStr, hours, minutes, seconds, fractionalMilliseconds, yearStr] = match;
        return buildDate(
          strictParseShort(stripLeadingZeroes(yearStr)),
          parseMonthByShortName(monthStr),
          parseDateValue(dayStr.trimLeft(), "day", 1, 31),
          { hours, minutes, seconds, fractionalMilliseconds }
        );
      }
      throw new TypeError("Invalid RFC-7231 date-time value");
    }, "parseRfc7231DateTime");
    var parseEpochTimestamp = /* @__PURE__ */ __name((value) => {
      if (value === null || value === void 0) {
        return void 0;
      }
      let valueAsDouble;
      if (typeof value === "number") {
        valueAsDouble = value;
      } else if (typeof value === "string") {
        valueAsDouble = strictParseDouble(value);
      } else {
        throw new TypeError("Epoch timestamps must be expressed as floating point numbers or their string representation");
      }
      if (Number.isNaN(valueAsDouble) || valueAsDouble === Infinity || valueAsDouble === -Infinity) {
        throw new TypeError("Epoch timestamps must be valid, non-Infinite, non-NaN numerics");
      }
      return new Date(Math.round(valueAsDouble * 1e3));
    }, "parseEpochTimestamp");
    var buildDate = /* @__PURE__ */ __name((year, month, day, time) => {
      const adjustedMonth = month - 1;
      validateDayOfMonth(year, adjustedMonth, day);
      return new Date(
        Date.UTC(
          year,
          adjustedMonth,
          day,
          parseDateValue(time.hours, "hour", 0, 23),
          parseDateValue(time.minutes, "minute", 0, 59),
          // seconds can go up to 60 for leap seconds
          parseDateValue(time.seconds, "seconds", 0, 60),
          parseMilliseconds(time.fractionalMilliseconds)
        )
      );
    }, "buildDate");
    var parseTwoDigitYear = /* @__PURE__ */ __name((value) => {
      const thisYear = (/* @__PURE__ */ new Date()).getUTCFullYear();
      const valueInThisCentury = Math.floor(thisYear / 100) * 100 + strictParseShort(stripLeadingZeroes(value));
      if (valueInThisCentury < thisYear) {
        return valueInThisCentury + 100;
      }
      return valueInThisCentury;
    }, "parseTwoDigitYear");
    var FIFTY_YEARS_IN_MILLIS = 50 * 365 * 24 * 60 * 60 * 1e3;
    var adjustRfc850Year = /* @__PURE__ */ __name((input) => {
      if (input.getTime() - (/* @__PURE__ */ new Date()).getTime() > FIFTY_YEARS_IN_MILLIS) {
        return new Date(
          Date.UTC(
            input.getUTCFullYear() - 100,
            input.getUTCMonth(),
            input.getUTCDate(),
            input.getUTCHours(),
            input.getUTCMinutes(),
            input.getUTCSeconds(),
            input.getUTCMilliseconds()
          )
        );
      }
      return input;
    }, "adjustRfc850Year");
    var parseMonthByShortName = /* @__PURE__ */ __name((value) => {
      const monthIdx = MONTHS.indexOf(value);
      if (monthIdx < 0) {
        throw new TypeError(`Invalid month: ${value}`);
      }
      return monthIdx + 1;
    }, "parseMonthByShortName");
    var DAYS_IN_MONTH = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
    var validateDayOfMonth = /* @__PURE__ */ __name((year, month, day) => {
      let maxDays = DAYS_IN_MONTH[month];
      if (month === 1 && isLeapYear(year)) {
        maxDays = 29;
      }
      if (day > maxDays) {
        throw new TypeError(`Invalid day for ${MONTHS[month]} in ${year}: ${day}`);
      }
    }, "validateDayOfMonth");
    var isLeapYear = /* @__PURE__ */ __name((year) => {
      return year % 4 === 0 && (year % 100 !== 0 || year % 400 === 0);
    }, "isLeapYear");
    var parseDateValue = /* @__PURE__ */ __name((value, type, lower, upper) => {
      const dateVal = strictParseByte(stripLeadingZeroes(value));
      if (dateVal < lower || dateVal > upper) {
        throw new TypeError(`${type} must be between ${lower} and ${upper}, inclusive`);
      }
      return dateVal;
    }, "parseDateValue");
    var parseMilliseconds = /* @__PURE__ */ __name((value) => {
      if (value === null || value === void 0) {
        return 0;
      }
      return strictParseFloat32("0." + value) * 1e3;
    }, "parseMilliseconds");
    var parseOffsetToMilliseconds = /* @__PURE__ */ __name((value) => {
      const directionStr = value[0];
      let direction = 1;
      if (directionStr == "+") {
        direction = 1;
      } else if (directionStr == "-") {
        direction = -1;
      } else {
        throw new TypeError(`Offset direction, ${directionStr}, must be "+" or "-"`);
      }
      const hour = Number(value.substring(1, 3));
      const minute = Number(value.substring(4, 6));
      return direction * (hour * 60 + minute) * 60 * 1e3;
    }, "parseOffsetToMilliseconds");
    var stripLeadingZeroes = /* @__PURE__ */ __name((value) => {
      let idx = 0;
      while (idx < value.length - 1 && value.charAt(idx) === "0") {
        idx++;
      }
      if (idx === 0) {
        return value;
      }
      return value.slice(idx);
    }, "stripLeadingZeroes");
    var _ServiceException = class _ServiceException2 extends Error {
      constructor(options) {
        super(options.message);
        Object.setPrototypeOf(this, _ServiceException2.prototype);
        this.name = options.name;
        this.$fault = options.$fault;
        this.$metadata = options.$metadata;
      }
    };
    __name(_ServiceException, "ServiceException");
    var ServiceException = _ServiceException;
    var decorateServiceException = /* @__PURE__ */ __name((exception, additions = {}) => {
      Object.entries(additions).filter(([, v]) => v !== void 0).forEach(([k, v]) => {
        if (exception[k] == void 0 || exception[k] === "") {
          exception[k] = v;
        }
      });
      const message = exception.message || exception.Message || "UnknownError";
      exception.message = message;
      delete exception.Message;
      return exception;
    }, "decorateServiceException");
    var throwDefaultError = /* @__PURE__ */ __name(({ output, parsedBody, exceptionCtor, errorCode }) => {
      const $metadata = deserializeMetadata(output);
      const statusCode = $metadata.httpStatusCode ? $metadata.httpStatusCode + "" : void 0;
      const response = new exceptionCtor({
        name: (parsedBody == null ? void 0 : parsedBody.code) || (parsedBody == null ? void 0 : parsedBody.Code) || errorCode || statusCode || "UnknownError",
        $fault: "client",
        $metadata
      });
      throw decorateServiceException(response, parsedBody);
    }, "throwDefaultError");
    var withBaseException = /* @__PURE__ */ __name((ExceptionCtor) => {
      return ({ output, parsedBody, errorCode }) => {
        throwDefaultError({ output, parsedBody, exceptionCtor: ExceptionCtor, errorCode });
      };
    }, "withBaseException");
    var deserializeMetadata = /* @__PURE__ */ __name((output) => ({
      httpStatusCode: output.statusCode,
      requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
      extendedRequestId: output.headers["x-amz-id-2"],
      cfId: output.headers["x-amz-cf-id"]
    }), "deserializeMetadata");
    var loadConfigsForDefaultMode = /* @__PURE__ */ __name((mode) => {
      switch (mode) {
        case "standard":
          return {
            retryMode: "standard",
            connectionTimeout: 3100
          };
        case "in-region":
          return {
            retryMode: "standard",
            connectionTimeout: 1100
          };
        case "cross-region":
          return {
            retryMode: "standard",
            connectionTimeout: 3100
          };
        case "mobile":
          return {
            retryMode: "standard",
            connectionTimeout: 3e4
          };
        default:
          return {};
      }
    }, "loadConfigsForDefaultMode");
    var warningEmitted = false;
    var emitWarningIfUnsupportedVersion = /* @__PURE__ */ __name((version2) => {
      if (version2 && !warningEmitted && parseInt(version2.substring(1, version2.indexOf("."))) < 14) {
        warningEmitted = true;
      }
    }, "emitWarningIfUnsupportedVersion");
    var getChecksumConfiguration = /* @__PURE__ */ __name((runtimeConfig) => {
      const checksumAlgorithms = [];
      for (const id in import_types.AlgorithmId) {
        const algorithmId = import_types.AlgorithmId[id];
        if (runtimeConfig[algorithmId] === void 0) {
          continue;
        }
        checksumAlgorithms.push({
          algorithmId: () => algorithmId,
          checksumConstructor: () => runtimeConfig[algorithmId]
        });
      }
      return {
        _checksumAlgorithms: checksumAlgorithms,
        addChecksumAlgorithm(algo) {
          this._checksumAlgorithms.push(algo);
        },
        checksumAlgorithms() {
          return this._checksumAlgorithms;
        }
      };
    }, "getChecksumConfiguration");
    var resolveChecksumRuntimeConfig = /* @__PURE__ */ __name((clientConfig) => {
      const runtimeConfig = {};
      clientConfig.checksumAlgorithms().forEach((checksumAlgorithm) => {
        runtimeConfig[checksumAlgorithm.algorithmId()] = checksumAlgorithm.checksumConstructor();
      });
      return runtimeConfig;
    }, "resolveChecksumRuntimeConfig");
    var getRetryConfiguration = /* @__PURE__ */ __name((runtimeConfig) => {
      let _retryStrategy = runtimeConfig.retryStrategy;
      return {
        setRetryStrategy(retryStrategy) {
          _retryStrategy = retryStrategy;
        },
        retryStrategy() {
          return _retryStrategy;
        }
      };
    }, "getRetryConfiguration");
    var resolveRetryRuntimeConfig = /* @__PURE__ */ __name((retryStrategyConfiguration) => {
      const runtimeConfig = {};
      runtimeConfig.retryStrategy = retryStrategyConfiguration.retryStrategy();
      return runtimeConfig;
    }, "resolveRetryRuntimeConfig");
    var getDefaultExtensionConfiguration = /* @__PURE__ */ __name((runtimeConfig) => {
      return {
        ...getChecksumConfiguration(runtimeConfig),
        ...getRetryConfiguration(runtimeConfig)
      };
    }, "getDefaultExtensionConfiguration");
    var getDefaultClientConfiguration = getDefaultExtensionConfiguration;
    var resolveDefaultRuntimeConfig = /* @__PURE__ */ __name((config) => {
      return {
        ...resolveChecksumRuntimeConfig(config),
        ...resolveRetryRuntimeConfig(config)
      };
    }, "resolveDefaultRuntimeConfig");
    function extendedEncodeURIComponent(str) {
      return encodeURIComponent(str).replace(/[!'()*]/g, function(c) {
        return "%" + c.charCodeAt(0).toString(16).toUpperCase();
      });
    }
    __name(extendedEncodeURIComponent, "extendedEncodeURIComponent");
    var getArrayIfSingleItem = /* @__PURE__ */ __name((mayBeArray) => Array.isArray(mayBeArray) ? mayBeArray : [mayBeArray], "getArrayIfSingleItem");
    var getValueFromTextNode = /* @__PURE__ */ __name((obj) => {
      const textNodeName = "#text";
      for (const key in obj) {
        if (obj.hasOwnProperty(key) && obj[key][textNodeName] !== void 0) {
          obj[key] = obj[key][textNodeName];
        } else if (typeof obj[key] === "object" && obj[key] !== null) {
          obj[key] = getValueFromTextNode(obj[key]);
        }
      }
      return obj;
    }, "getValueFromTextNode");
    var StringWrapper = /* @__PURE__ */ __name(function() {
      const Class = Object.getPrototypeOf(this).constructor;
      const Constructor = Function.bind.apply(String, [null, ...arguments]);
      const instance = new Constructor();
      Object.setPrototypeOf(instance, Class.prototype);
      return instance;
    }, "StringWrapper");
    StringWrapper.prototype = Object.create(String.prototype, {
      constructor: {
        value: StringWrapper,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
    Object.setPrototypeOf(StringWrapper, String);
    var _LazyJsonString = class _LazyJsonString2 extends StringWrapper {
      deserializeJSON() {
        return JSON.parse(super.toString());
      }
      toJSON() {
        return super.toString();
      }
      static fromObject(object) {
        if (object instanceof _LazyJsonString2) {
          return object;
        } else if (object instanceof String || typeof object === "string") {
          return new _LazyJsonString2(object);
        }
        return new _LazyJsonString2(JSON.stringify(object));
      }
    };
    __name(_LazyJsonString, "LazyJsonString");
    var LazyJsonString = _LazyJsonString;
    function map(arg0, arg1, arg2) {
      let target;
      let filter;
      let instructions;
      if (typeof arg1 === "undefined" && typeof arg2 === "undefined") {
        target = {};
        instructions = arg0;
      } else {
        target = arg0;
        if (typeof arg1 === "function") {
          filter = arg1;
          instructions = arg2;
          return mapWithFilter(target, filter, instructions);
        } else {
          instructions = arg1;
        }
      }
      for (const key of Object.keys(instructions)) {
        if (!Array.isArray(instructions[key])) {
          target[key] = instructions[key];
          continue;
        }
        applyInstruction(target, null, instructions, key);
      }
      return target;
    }
    __name(map, "map");
    var convertMap = /* @__PURE__ */ __name((target) => {
      const output = {};
      for (const [k, v] of Object.entries(target || {})) {
        output[k] = [, v];
      }
      return output;
    }, "convertMap");
    var take = /* @__PURE__ */ __name((source, instructions) => {
      const out = {};
      for (const key in instructions) {
        applyInstruction(out, source, instructions, key);
      }
      return out;
    }, "take");
    var mapWithFilter = /* @__PURE__ */ __name((target, filter, instructions) => {
      return map(
        target,
        Object.entries(instructions).reduce(
          (_instructions, [key, value]) => {
            if (Array.isArray(value)) {
              _instructions[key] = value;
            } else {
              if (typeof value === "function") {
                _instructions[key] = [filter, value()];
              } else {
                _instructions[key] = [filter, value];
              }
            }
            return _instructions;
          },
          {}
        )
      );
    }, "mapWithFilter");
    var applyInstruction = /* @__PURE__ */ __name((target, source, instructions, targetKey) => {
      if (source !== null) {
        let instruction = instructions[targetKey];
        if (typeof instruction === "function") {
          instruction = [, instruction];
        }
        const [filter2 = nonNullish, valueFn = pass, sourceKey = targetKey] = instruction;
        if (typeof filter2 === "function" && filter2(source[sourceKey]) || typeof filter2 !== "function" && !!filter2) {
          target[targetKey] = valueFn(source[sourceKey]);
        }
        return;
      }
      let [filter, value] = instructions[targetKey];
      if (typeof value === "function") {
        let _value;
        const defaultFilterPassed = filter === void 0 && (_value = value()) != null;
        const customFilterPassed = typeof filter === "function" && !!filter(void 0) || typeof filter !== "function" && !!filter;
        if (defaultFilterPassed) {
          target[targetKey] = _value;
        } else if (customFilterPassed) {
          target[targetKey] = value();
        }
      } else {
        const defaultFilterPassed = filter === void 0 && value != null;
        const customFilterPassed = typeof filter === "function" && !!filter(value) || typeof filter !== "function" && !!filter;
        if (defaultFilterPassed || customFilterPassed) {
          target[targetKey] = value;
        }
      }
    }, "applyInstruction");
    var nonNullish = /* @__PURE__ */ __name((_) => _ != null, "nonNullish");
    var pass = /* @__PURE__ */ __name((_) => _, "pass");
    var resolvedPath = /* @__PURE__ */ __name((resolvedPath2, input, memberName, labelValueProvider, uriLabel, isGreedyLabel) => {
      if (input != null && input[memberName] !== void 0) {
        const labelValue = labelValueProvider();
        if (labelValue.length <= 0) {
          throw new Error("Empty value provided for input HTTP label: " + memberName + ".");
        }
        resolvedPath2 = resolvedPath2.replace(
          uriLabel,
          isGreedyLabel ? labelValue.split("/").map((segment) => extendedEncodeURIComponent(segment)).join("/") : extendedEncodeURIComponent(labelValue)
        );
      } else {
        throw new Error("No value provided for input HTTP label: " + memberName + ".");
      }
      return resolvedPath2;
    }, "resolvedPath");
    var serializeFloat = /* @__PURE__ */ __name((value) => {
      if (value !== value) {
        return "NaN";
      }
      switch (value) {
        case Infinity:
          return "Infinity";
        case -Infinity:
          return "-Infinity";
        default:
          return value;
      }
    }, "serializeFloat");
    var _json = /* @__PURE__ */ __name((obj) => {
      if (obj == null) {
        return {};
      }
      if (Array.isArray(obj)) {
        return obj.filter((_) => _ != null).map(_json);
      }
      if (typeof obj === "object") {
        const target = {};
        for (const key of Object.keys(obj)) {
          if (obj[key] == null) {
            continue;
          }
          target[key] = _json(obj[key]);
        }
        return target;
      }
      return obj;
    }, "_json");
    function splitEvery(value, delimiter, numDelimiters) {
      if (numDelimiters <= 0 || !Number.isInteger(numDelimiters)) {
        throw new Error("Invalid number of delimiters (" + numDelimiters + ") for splitEvery.");
      }
      const segments = value.split(delimiter);
      if (numDelimiters === 1) {
        return segments;
      }
      const compoundSegments = [];
      let currentSegment = "";
      for (let i = 0; i < segments.length; i++) {
        if (currentSegment === "") {
          currentSegment = segments[i];
        } else {
          currentSegment += delimiter + segments[i];
        }
        if ((i + 1) % numDelimiters === 0) {
          compoundSegments.push(currentSegment);
          currentSegment = "";
        }
      }
      if (currentSegment !== "") {
        compoundSegments.push(currentSegment);
      }
      return compoundSegments;
    }
    __name(splitEvery, "splitEvery");
  }
});

// ../../../node_modules/@smithy/middleware-retry/dist-cjs/isStreamingPayload/isStreamingPayload.js
var require_isStreamingPayload = __commonJS({
  "../../../node_modules/@smithy/middleware-retry/dist-cjs/isStreamingPayload/isStreamingPayload.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.isStreamingPayload = void 0;
    var stream_1 = require("stream");
    var isStreamingPayload = (request2) => (request2 === null || request2 === void 0 ? void 0 : request2.body) instanceof stream_1.Readable || typeof ReadableStream !== "undefined" && (request2 === null || request2 === void 0 ? void 0 : request2.body) instanceof ReadableStream;
    exports2.isStreamingPayload = isStreamingPayload;
  }
});

// ../../../node_modules/@smithy/middleware-retry/dist-cjs/index.js
var require_dist_cjs35 = __commonJS({
  "../../../node_modules/@smithy/middleware-retry/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      AdaptiveRetryStrategy: () => AdaptiveRetryStrategy,
      CONFIG_MAX_ATTEMPTS: () => CONFIG_MAX_ATTEMPTS,
      CONFIG_RETRY_MODE: () => CONFIG_RETRY_MODE,
      ENV_MAX_ATTEMPTS: () => ENV_MAX_ATTEMPTS,
      ENV_RETRY_MODE: () => ENV_RETRY_MODE,
      NODE_MAX_ATTEMPT_CONFIG_OPTIONS: () => NODE_MAX_ATTEMPT_CONFIG_OPTIONS,
      NODE_RETRY_MODE_CONFIG_OPTIONS: () => NODE_RETRY_MODE_CONFIG_OPTIONS,
      StandardRetryStrategy: () => StandardRetryStrategy,
      defaultDelayDecider: () => defaultDelayDecider,
      defaultRetryDecider: () => defaultRetryDecider,
      getOmitRetryHeadersPlugin: () => getOmitRetryHeadersPlugin,
      getRetryAfterHint: () => getRetryAfterHint,
      getRetryPlugin: () => getRetryPlugin,
      omitRetryHeadersMiddleware: () => omitRetryHeadersMiddleware,
      omitRetryHeadersMiddlewareOptions: () => omitRetryHeadersMiddlewareOptions,
      resolveRetryConfig: () => resolveRetryConfig,
      retryMiddleware: () => retryMiddleware,
      retryMiddlewareOptions: () => retryMiddlewareOptions
    });
    module2.exports = __toCommonJS2(src_exports);
    var import_protocol_http = require_dist_cjs2();
    var import_uuid = (init_esm_node(), __toCommonJS(esm_node_exports));
    var import_util_retry = require_dist_cjs28();
    var getDefaultRetryQuota = /* @__PURE__ */ __name((initialRetryTokens, options) => {
      const MAX_CAPACITY = initialRetryTokens;
      const noRetryIncrement = (options == null ? void 0 : options.noRetryIncrement) ?? import_util_retry.NO_RETRY_INCREMENT;
      const retryCost = (options == null ? void 0 : options.retryCost) ?? import_util_retry.RETRY_COST;
      const timeoutRetryCost = (options == null ? void 0 : options.timeoutRetryCost) ?? import_util_retry.TIMEOUT_RETRY_COST;
      let availableCapacity = initialRetryTokens;
      const getCapacityAmount = /* @__PURE__ */ __name((error) => error.name === "TimeoutError" ? timeoutRetryCost : retryCost, "getCapacityAmount");
      const hasRetryTokens = /* @__PURE__ */ __name((error) => getCapacityAmount(error) <= availableCapacity, "hasRetryTokens");
      const retrieveRetryTokens = /* @__PURE__ */ __name((error) => {
        if (!hasRetryTokens(error)) {
          throw new Error("No retry token available");
        }
        const capacityAmount = getCapacityAmount(error);
        availableCapacity -= capacityAmount;
        return capacityAmount;
      }, "retrieveRetryTokens");
      const releaseRetryTokens = /* @__PURE__ */ __name((capacityReleaseAmount) => {
        availableCapacity += capacityReleaseAmount ?? noRetryIncrement;
        availableCapacity = Math.min(availableCapacity, MAX_CAPACITY);
      }, "releaseRetryTokens");
      return Object.freeze({
        hasRetryTokens,
        retrieveRetryTokens,
        releaseRetryTokens
      });
    }, "getDefaultRetryQuota");
    var defaultDelayDecider = /* @__PURE__ */ __name((delayBase, attempts) => Math.floor(Math.min(import_util_retry.MAXIMUM_RETRY_DELAY, Math.random() * 2 ** attempts * delayBase)), "defaultDelayDecider");
    var import_service_error_classification = require_dist_cjs27();
    var defaultRetryDecider = /* @__PURE__ */ __name((error) => {
      if (!error) {
        return false;
      }
      return (0, import_service_error_classification.isRetryableByTrait)(error) || (0, import_service_error_classification.isClockSkewError)(error) || (0, import_service_error_classification.isThrottlingError)(error) || (0, import_service_error_classification.isTransientError)(error);
    }, "defaultRetryDecider");
    var asSdkError = /* @__PURE__ */ __name((error) => {
      if (error instanceof Error)
        return error;
      if (error instanceof Object)
        return Object.assign(new Error(), error);
      if (typeof error === "string")
        return new Error(error);
      return new Error(`AWS SDK error wrapper for ${error}`);
    }, "asSdkError");
    var _StandardRetryStrategy = class _StandardRetryStrategy {
      constructor(maxAttemptsProvider, options) {
        this.maxAttemptsProvider = maxAttemptsProvider;
        this.mode = import_util_retry.RETRY_MODES.STANDARD;
        this.retryDecider = (options == null ? void 0 : options.retryDecider) ?? defaultRetryDecider;
        this.delayDecider = (options == null ? void 0 : options.delayDecider) ?? defaultDelayDecider;
        this.retryQuota = (options == null ? void 0 : options.retryQuota) ?? getDefaultRetryQuota(import_util_retry.INITIAL_RETRY_TOKENS);
      }
      shouldRetry(error, attempts, maxAttempts) {
        return attempts < maxAttempts && this.retryDecider(error) && this.retryQuota.hasRetryTokens(error);
      }
      async getMaxAttempts() {
        let maxAttempts;
        try {
          maxAttempts = await this.maxAttemptsProvider();
        } catch (error) {
          maxAttempts = import_util_retry.DEFAULT_MAX_ATTEMPTS;
        }
        return maxAttempts;
      }
      async retry(next, args, options) {
        let retryTokenAmount;
        let attempts = 0;
        let totalDelay = 0;
        const maxAttempts = await this.getMaxAttempts();
        const { request: request2 } = args;
        if (import_protocol_http.HttpRequest.isInstance(request2)) {
          request2.headers[import_util_retry.INVOCATION_ID_HEADER] = (0, import_uuid.v4)();
        }
        while (true) {
          try {
            if (import_protocol_http.HttpRequest.isInstance(request2)) {
              request2.headers[import_util_retry.REQUEST_HEADER] = `attempt=${attempts + 1}; max=${maxAttempts}`;
            }
            if (options == null ? void 0 : options.beforeRequest) {
              await options.beforeRequest();
            }
            const { response, output } = await next(args);
            if (options == null ? void 0 : options.afterRequest) {
              options.afterRequest(response);
            }
            this.retryQuota.releaseRetryTokens(retryTokenAmount);
            output.$metadata.attempts = attempts + 1;
            output.$metadata.totalRetryDelay = totalDelay;
            return { response, output };
          } catch (e) {
            const err = asSdkError(e);
            attempts++;
            if (this.shouldRetry(err, attempts, maxAttempts)) {
              retryTokenAmount = this.retryQuota.retrieveRetryTokens(err);
              const delayFromDecider = this.delayDecider(
                (0, import_service_error_classification.isThrottlingError)(err) ? import_util_retry.THROTTLING_RETRY_DELAY_BASE : import_util_retry.DEFAULT_RETRY_DELAY_BASE,
                attempts
              );
              const delayFromResponse = getDelayFromRetryAfterHeader(err.$response);
              const delay = Math.max(delayFromResponse || 0, delayFromDecider);
              totalDelay += delay;
              await new Promise((resolve) => setTimeout(resolve, delay));
              continue;
            }
            if (!err.$metadata) {
              err.$metadata = {};
            }
            err.$metadata.attempts = attempts;
            err.$metadata.totalRetryDelay = totalDelay;
            throw err;
          }
        }
      }
    };
    __name(_StandardRetryStrategy, "StandardRetryStrategy");
    var StandardRetryStrategy = _StandardRetryStrategy;
    var getDelayFromRetryAfterHeader = /* @__PURE__ */ __name((response) => {
      if (!import_protocol_http.HttpResponse.isInstance(response))
        return;
      const retryAfterHeaderName = Object.keys(response.headers).find((key) => key.toLowerCase() === "retry-after");
      if (!retryAfterHeaderName)
        return;
      const retryAfter = response.headers[retryAfterHeaderName];
      const retryAfterSeconds = Number(retryAfter);
      if (!Number.isNaN(retryAfterSeconds))
        return retryAfterSeconds * 1e3;
      const retryAfterDate = new Date(retryAfter);
      return retryAfterDate.getTime() - Date.now();
    }, "getDelayFromRetryAfterHeader");
    var _AdaptiveRetryStrategy = class _AdaptiveRetryStrategy extends StandardRetryStrategy {
      constructor(maxAttemptsProvider, options) {
        const { rateLimiter, ...superOptions } = options ?? {};
        super(maxAttemptsProvider, superOptions);
        this.rateLimiter = rateLimiter ?? new import_util_retry.DefaultRateLimiter();
        this.mode = import_util_retry.RETRY_MODES.ADAPTIVE;
      }
      async retry(next, args) {
        return super.retry(next, args, {
          beforeRequest: async () => {
            return this.rateLimiter.getSendToken();
          },
          afterRequest: (response) => {
            this.rateLimiter.updateClientSendingRate(response);
          }
        });
      }
    };
    __name(_AdaptiveRetryStrategy, "AdaptiveRetryStrategy");
    var AdaptiveRetryStrategy = _AdaptiveRetryStrategy;
    var import_util_middleware = require_dist_cjs7();
    var ENV_MAX_ATTEMPTS = "AWS_MAX_ATTEMPTS";
    var CONFIG_MAX_ATTEMPTS = "max_attempts";
    var NODE_MAX_ATTEMPT_CONFIG_OPTIONS = {
      environmentVariableSelector: (env) => {
        const value = env[ENV_MAX_ATTEMPTS];
        if (!value)
          return void 0;
        const maxAttempt = parseInt(value);
        if (Number.isNaN(maxAttempt)) {
          throw new Error(`Environment variable ${ENV_MAX_ATTEMPTS} mast be a number, got "${value}"`);
        }
        return maxAttempt;
      },
      configFileSelector: (profile) => {
        const value = profile[CONFIG_MAX_ATTEMPTS];
        if (!value)
          return void 0;
        const maxAttempt = parseInt(value);
        if (Number.isNaN(maxAttempt)) {
          throw new Error(`Shared config file entry ${CONFIG_MAX_ATTEMPTS} mast be a number, got "${value}"`);
        }
        return maxAttempt;
      },
      default: import_util_retry.DEFAULT_MAX_ATTEMPTS
    };
    var resolveRetryConfig = /* @__PURE__ */ __name((input) => {
      const { retryStrategy } = input;
      const maxAttempts = (0, import_util_middleware.normalizeProvider)(input.maxAttempts ?? import_util_retry.DEFAULT_MAX_ATTEMPTS);
      return {
        ...input,
        maxAttempts,
        retryStrategy: async () => {
          if (retryStrategy) {
            return retryStrategy;
          }
          const retryMode = await (0, import_util_middleware.normalizeProvider)(input.retryMode)();
          if (retryMode === import_util_retry.RETRY_MODES.ADAPTIVE) {
            return new import_util_retry.AdaptiveRetryStrategy(maxAttempts);
          }
          return new import_util_retry.StandardRetryStrategy(maxAttempts);
        }
      };
    }, "resolveRetryConfig");
    var ENV_RETRY_MODE = "AWS_RETRY_MODE";
    var CONFIG_RETRY_MODE = "retry_mode";
    var NODE_RETRY_MODE_CONFIG_OPTIONS = {
      environmentVariableSelector: (env) => env[ENV_RETRY_MODE],
      configFileSelector: (profile) => profile[CONFIG_RETRY_MODE],
      default: import_util_retry.DEFAULT_RETRY_MODE
    };
    var omitRetryHeadersMiddleware = /* @__PURE__ */ __name(() => (next) => async (args) => {
      const { request: request2 } = args;
      if (import_protocol_http.HttpRequest.isInstance(request2)) {
        delete request2.headers[import_util_retry.INVOCATION_ID_HEADER];
        delete request2.headers[import_util_retry.REQUEST_HEADER];
      }
      return next(args);
    }, "omitRetryHeadersMiddleware");
    var omitRetryHeadersMiddlewareOptions = {
      name: "omitRetryHeadersMiddleware",
      tags: ["RETRY", "HEADERS", "OMIT_RETRY_HEADERS"],
      relation: "before",
      toMiddleware: "awsAuthMiddleware",
      override: true
    };
    var getOmitRetryHeadersPlugin = /* @__PURE__ */ __name((options) => ({
      applyToStack: (clientStack) => {
        clientStack.addRelativeTo(omitRetryHeadersMiddleware(), omitRetryHeadersMiddlewareOptions);
      }
    }), "getOmitRetryHeadersPlugin");
    var import_smithy_client = require_dist_cjs34();
    var import_isStreamingPayload = require_isStreamingPayload();
    var retryMiddleware = /* @__PURE__ */ __name((options) => (next, context) => async (args) => {
      var _a;
      let retryStrategy = await options.retryStrategy();
      const maxAttempts = await options.maxAttempts();
      if (isRetryStrategyV2(retryStrategy)) {
        retryStrategy = retryStrategy;
        let retryToken = await retryStrategy.acquireInitialRetryToken(context["partition_id"]);
        let lastError = new Error();
        let attempts = 0;
        let totalRetryDelay = 0;
        const { request: request2 } = args;
        const isRequest = import_protocol_http.HttpRequest.isInstance(request2);
        if (isRequest) {
          request2.headers[import_util_retry.INVOCATION_ID_HEADER] = (0, import_uuid.v4)();
        }
        while (true) {
          try {
            if (isRequest) {
              request2.headers[import_util_retry.REQUEST_HEADER] = `attempt=${attempts + 1}; max=${maxAttempts}`;
            }
            const { response, output } = await next(args);
            retryStrategy.recordSuccess(retryToken);
            output.$metadata.attempts = attempts + 1;
            output.$metadata.totalRetryDelay = totalRetryDelay;
            return { response, output };
          } catch (e) {
            const retryErrorInfo = getRetryErrorInfo(e);
            lastError = asSdkError(e);
            if (isRequest && (0, import_isStreamingPayload.isStreamingPayload)(request2)) {
              (_a = context.logger instanceof import_smithy_client.NoOpLogger ? console : context.logger) == null ? void 0 : _a.warn(
                "An error was encountered in a non-retryable streaming request."
              );
              throw lastError;
            }
            try {
              retryToken = await retryStrategy.refreshRetryTokenForRetry(retryToken, retryErrorInfo);
            } catch (refreshError) {
              if (!lastError.$metadata) {
                lastError.$metadata = {};
              }
              lastError.$metadata.attempts = attempts + 1;
              lastError.$metadata.totalRetryDelay = totalRetryDelay;
              throw lastError;
            }
            attempts = retryToken.getRetryCount();
            const delay = retryToken.getRetryDelay();
            totalRetryDelay += delay;
            await new Promise((resolve) => setTimeout(resolve, delay));
          }
        }
      } else {
        retryStrategy = retryStrategy;
        if (retryStrategy == null ? void 0 : retryStrategy.mode)
          context.userAgent = [...context.userAgent || [], ["cfg/retry-mode", retryStrategy.mode]];
        return retryStrategy.retry(next, args);
      }
    }, "retryMiddleware");
    var isRetryStrategyV2 = /* @__PURE__ */ __name((retryStrategy) => typeof retryStrategy.acquireInitialRetryToken !== "undefined" && typeof retryStrategy.refreshRetryTokenForRetry !== "undefined" && typeof retryStrategy.recordSuccess !== "undefined", "isRetryStrategyV2");
    var getRetryErrorInfo = /* @__PURE__ */ __name((error) => {
      const errorInfo = {
        error,
        errorType: getRetryErrorType(error)
      };
      const retryAfterHint = getRetryAfterHint(error.$response);
      if (retryAfterHint) {
        errorInfo.retryAfterHint = retryAfterHint;
      }
      return errorInfo;
    }, "getRetryErrorInfo");
    var getRetryErrorType = /* @__PURE__ */ __name((error) => {
      if ((0, import_service_error_classification.isThrottlingError)(error))
        return "THROTTLING";
      if ((0, import_service_error_classification.isTransientError)(error))
        return "TRANSIENT";
      if ((0, import_service_error_classification.isServerError)(error))
        return "SERVER_ERROR";
      return "CLIENT_ERROR";
    }, "getRetryErrorType");
    var retryMiddlewareOptions = {
      name: "retryMiddleware",
      tags: ["RETRY"],
      step: "finalizeRequest",
      priority: "high",
      override: true
    };
    var getRetryPlugin = /* @__PURE__ */ __name((options) => ({
      applyToStack: (clientStack) => {
        clientStack.add(retryMiddleware(options), retryMiddlewareOptions);
      }
    }), "getRetryPlugin");
    var getRetryAfterHint = /* @__PURE__ */ __name((response) => {
      if (!import_protocol_http.HttpResponse.isInstance(response))
        return;
      const retryAfterHeaderName = Object.keys(response.headers).find((key) => key.toLowerCase() === "retry-after");
      if (!retryAfterHeaderName)
        return;
      const retryAfter = response.headers[retryAfterHeaderName];
      const retryAfterSeconds = Number(retryAfter);
      if (!Number.isNaN(retryAfterSeconds))
        return new Date(retryAfterSeconds * 1e3);
      const retryAfterDate = new Date(retryAfter);
      return retryAfterDate;
    }, "getRetryAfterHint");
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/endpoint/EndpointParameters.js
var require_EndpointParameters = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/endpoint/EndpointParameters.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveClientEndpointParameters = void 0;
    var resolveClientEndpointParameters = (options) => {
      return {
        ...options,
        useDualstackEndpoint: options.useDualstackEndpoint ?? false,
        useFipsEndpoint: options.useFipsEndpoint ?? false,
        defaultSigningName: "states"
      };
    };
    exports2.resolveClientEndpointParameters = resolveClientEndpointParameters;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/package.json
var require_package = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/package.json"(exports2, module2) {
    module2.exports = {
      name: "@aws-sdk/client-sfn",
      description: "AWS SDK for JavaScript Sfn Client for Node.js, Browser and React Native",
      version: "3.421.0",
      scripts: {
        build: "concurrently 'yarn:build:cjs' 'yarn:build:es' 'yarn:build:types'",
        "build:cjs": "tsc -p tsconfig.cjs.json",
        "build:docs": "typedoc",
        "build:es": "tsc -p tsconfig.es.json",
        "build:include:deps": "lerna run --scope $npm_package_name --include-dependencies build",
        "build:types": "tsc -p tsconfig.types.json",
        "build:types:downlevel": "downlevel-dts dist-types dist-types/ts3.4",
        clean: "rimraf ./dist-* && rimraf *.tsbuildinfo",
        "extract:docs": "api-extractor run --local",
        "generate:client": "node ../../scripts/generate-clients/single-service --solo sfn"
      },
      main: "./dist-cjs/index.js",
      types: "./dist-types/index.d.ts",
      module: "./dist-es/index.js",
      sideEffects: false,
      dependencies: {
        "@aws-crypto/sha256-browser": "3.0.0",
        "@aws-crypto/sha256-js": "3.0.0",
        "@aws-sdk/client-sts": "3.421.0",
        "@aws-sdk/credential-provider-node": "3.421.0",
        "@aws-sdk/middleware-host-header": "3.418.0",
        "@aws-sdk/middleware-logger": "3.418.0",
        "@aws-sdk/middleware-recursion-detection": "3.418.0",
        "@aws-sdk/middleware-signing": "3.418.0",
        "@aws-sdk/middleware-user-agent": "3.418.0",
        "@aws-sdk/region-config-resolver": "3.418.0",
        "@aws-sdk/types": "3.418.0",
        "@aws-sdk/util-endpoints": "3.418.0",
        "@aws-sdk/util-user-agent-browser": "3.418.0",
        "@aws-sdk/util-user-agent-node": "3.418.0",
        "@smithy/config-resolver": "^2.0.10",
        "@smithy/fetch-http-handler": "^2.1.5",
        "@smithy/hash-node": "^2.0.9",
        "@smithy/invalid-dependency": "^2.0.9",
        "@smithy/middleware-content-length": "^2.0.11",
        "@smithy/middleware-endpoint": "^2.0.9",
        "@smithy/middleware-retry": "^2.0.12",
        "@smithy/middleware-serde": "^2.0.9",
        "@smithy/middleware-stack": "^2.0.2",
        "@smithy/node-config-provider": "^2.0.12",
        "@smithy/node-http-handler": "^2.1.5",
        "@smithy/protocol-http": "^3.0.5",
        "@smithy/smithy-client": "^2.1.6",
        "@smithy/types": "^2.3.3",
        "@smithy/url-parser": "^2.0.9",
        "@smithy/util-base64": "^2.0.0",
        "@smithy/util-body-length-browser": "^2.0.0",
        "@smithy/util-body-length-node": "^2.1.0",
        "@smithy/util-defaults-mode-browser": "^2.0.10",
        "@smithy/util-defaults-mode-node": "^2.0.12",
        "@smithy/util-retry": "^2.0.2",
        "@smithy/util-utf8": "^2.0.0",
        tslib: "^2.5.0"
      },
      devDependencies: {
        "@smithy/service-client-documentation-generator": "^2.0.0",
        "@tsconfig/node14": "1.0.3",
        "@types/node": "^14.14.31",
        concurrently: "7.0.0",
        "downlevel-dts": "0.10.1",
        rimraf: "3.0.2",
        typedoc: "0.23.23",
        typescript: "~4.9.5"
      },
      engines: {
        node: ">=14.0.0"
      },
      typesVersions: {
        "<4.0": {
          "dist-types/*": [
            "dist-types/ts3.4/*"
          ]
        }
      },
      files: [
        "dist-*/**"
      ],
      author: {
        name: "AWS SDK for JavaScript Team",
        url: "https://aws.amazon.com/javascript/"
      },
      license: "Apache-2.0",
      browser: {
        "./dist-es/runtimeConfig": "./dist-es/runtimeConfig.browser"
      },
      "react-native": {
        "./dist-es/runtimeConfig": "./dist-es/runtimeConfig.native"
      },
      homepage: "https://github.com/aws/aws-sdk-js-v3/tree/main/clients/client-sfn",
      repository: {
        type: "git",
        url: "https://github.com/aws/aws-sdk-js-v3.git",
        directory: "clients/client-sfn"
      }
    };
  }
});

// ../../../node_modules/@aws-sdk/middleware-sdk-sts/dist-cjs/index.js
var require_dist_cjs36 = __commonJS({
  "../../../node_modules/@aws-sdk/middleware-sdk-sts/dist-cjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveStsAuthConfig = void 0;
    var middleware_signing_1 = require_dist_cjs14();
    var resolveStsAuthConfig = (input, { stsClientCtor }) => (0, middleware_signing_1.resolveAwsAuthConfig)({
      ...input,
      stsClientCtor
    });
    exports2.resolveStsAuthConfig = resolveStsAuthConfig;
  }
});

// ../../../node_modules/@aws-sdk/client-sts/dist-cjs/endpoint/EndpointParameters.js
var require_EndpointParameters2 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sts/dist-cjs/endpoint/EndpointParameters.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveClientEndpointParameters = void 0;
    var resolveClientEndpointParameters = (options) => {
      return {
        ...options,
        useDualstackEndpoint: options.useDualstackEndpoint ?? false,
        useFipsEndpoint: options.useFipsEndpoint ?? false,
        useGlobalEndpoint: options.useGlobalEndpoint ?? false,
        defaultSigningName: "sts"
      };
    };
    exports2.resolveClientEndpointParameters = resolveClientEndpointParameters;
  }
});

// ../../../node_modules/@aws-sdk/client-sts/package.json
var require_package2 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sts/package.json"(exports2, module2) {
    module2.exports = {
      name: "@aws-sdk/client-sts",
      description: "AWS SDK for JavaScript Sts Client for Node.js, Browser and React Native",
      version: "3.421.0",
      scripts: {
        build: "concurrently 'yarn:build:cjs' 'yarn:build:es' 'yarn:build:types'",
        "build:cjs": "tsc -p tsconfig.cjs.json",
        "build:docs": "typedoc",
        "build:es": "tsc -p tsconfig.es.json",
        "build:include:deps": "lerna run --scope $npm_package_name --include-dependencies build",
        "build:types": "tsc -p tsconfig.types.json",
        "build:types:downlevel": "downlevel-dts dist-types dist-types/ts3.4",
        clean: "rimraf ./dist-* && rimraf *.tsbuildinfo",
        "extract:docs": "api-extractor run --local",
        "generate:client": "node ../../scripts/generate-clients/single-service --solo sts",
        test: "yarn test:unit",
        "test:unit": "jest"
      },
      main: "./dist-cjs/index.js",
      types: "./dist-types/index.d.ts",
      module: "./dist-es/index.js",
      sideEffects: false,
      dependencies: {
        "@aws-crypto/sha256-browser": "3.0.0",
        "@aws-crypto/sha256-js": "3.0.0",
        "@aws-sdk/credential-provider-node": "3.421.0",
        "@aws-sdk/middleware-host-header": "3.418.0",
        "@aws-sdk/middleware-logger": "3.418.0",
        "@aws-sdk/middleware-recursion-detection": "3.418.0",
        "@aws-sdk/middleware-sdk-sts": "3.418.0",
        "@aws-sdk/middleware-signing": "3.418.0",
        "@aws-sdk/middleware-user-agent": "3.418.0",
        "@aws-sdk/region-config-resolver": "3.418.0",
        "@aws-sdk/types": "3.418.0",
        "@aws-sdk/util-endpoints": "3.418.0",
        "@aws-sdk/util-user-agent-browser": "3.418.0",
        "@aws-sdk/util-user-agent-node": "3.418.0",
        "@smithy/config-resolver": "^2.0.10",
        "@smithy/fetch-http-handler": "^2.1.5",
        "@smithy/hash-node": "^2.0.9",
        "@smithy/invalid-dependency": "^2.0.9",
        "@smithy/middleware-content-length": "^2.0.11",
        "@smithy/middleware-endpoint": "^2.0.9",
        "@smithy/middleware-retry": "^2.0.12",
        "@smithy/middleware-serde": "^2.0.9",
        "@smithy/middleware-stack": "^2.0.2",
        "@smithy/node-config-provider": "^2.0.12",
        "@smithy/node-http-handler": "^2.1.5",
        "@smithy/protocol-http": "^3.0.5",
        "@smithy/smithy-client": "^2.1.6",
        "@smithy/types": "^2.3.3",
        "@smithy/url-parser": "^2.0.9",
        "@smithy/util-base64": "^2.0.0",
        "@smithy/util-body-length-browser": "^2.0.0",
        "@smithy/util-body-length-node": "^2.1.0",
        "@smithy/util-defaults-mode-browser": "^2.0.10",
        "@smithy/util-defaults-mode-node": "^2.0.12",
        "@smithy/util-retry": "^2.0.2",
        "@smithy/util-utf8": "^2.0.0",
        "fast-xml-parser": "4.2.5",
        tslib: "^2.5.0"
      },
      devDependencies: {
        "@smithy/service-client-documentation-generator": "^2.0.0",
        "@tsconfig/node14": "1.0.3",
        "@types/node": "^14.14.31",
        concurrently: "7.0.0",
        "downlevel-dts": "0.10.1",
        rimraf: "3.0.2",
        typedoc: "0.23.23",
        typescript: "~4.9.5"
      },
      engines: {
        node: ">=14.0.0"
      },
      typesVersions: {
        "<4.0": {
          "dist-types/*": [
            "dist-types/ts3.4/*"
          ]
        }
      },
      files: [
        "dist-*/**"
      ],
      author: {
        name: "AWS SDK for JavaScript Team",
        url: "https://aws.amazon.com/javascript/"
      },
      license: "Apache-2.0",
      browser: {
        "./dist-es/runtimeConfig": "./dist-es/runtimeConfig.browser"
      },
      "react-native": {
        "./dist-es/runtimeConfig": "./dist-es/runtimeConfig.native"
      },
      homepage: "https://github.com/aws/aws-sdk-js-v3/tree/main/clients/client-sts",
      repository: {
        type: "git",
        url: "https://github.com/aws/aws-sdk-js-v3.git",
        directory: "clients/client-sts"
      }
    };
  }
});

// ../../../node_modules/@aws-sdk/client-sts/dist-cjs/models/STSServiceException.js
var require_STSServiceException = __commonJS({
  "../../../node_modules/@aws-sdk/client-sts/dist-cjs/models/STSServiceException.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.STSServiceException = exports2.__ServiceException = void 0;
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "__ServiceException", { enumerable: true, get: function() {
      return smithy_client_1.ServiceException;
    } });
    var STSServiceException = class _STSServiceException extends smithy_client_1.ServiceException {
      constructor(options) {
        super(options);
        Object.setPrototypeOf(this, _STSServiceException.prototype);
      }
    };
    exports2.STSServiceException = STSServiceException;
  }
});

// ../../../node_modules/@aws-sdk/client-sts/dist-cjs/models/models_0.js
var require_models_0 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sts/dist-cjs/models/models_0.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.GetSessionTokenResponseFilterSensitiveLog = exports2.GetFederationTokenResponseFilterSensitiveLog = exports2.AssumeRoleWithWebIdentityResponseFilterSensitiveLog = exports2.AssumeRoleWithWebIdentityRequestFilterSensitiveLog = exports2.AssumeRoleWithSAMLResponseFilterSensitiveLog = exports2.AssumeRoleWithSAMLRequestFilterSensitiveLog = exports2.AssumeRoleResponseFilterSensitiveLog = exports2.CredentialsFilterSensitiveLog = exports2.InvalidAuthorizationMessageException = exports2.IDPCommunicationErrorException = exports2.InvalidIdentityTokenException = exports2.IDPRejectedClaimException = exports2.RegionDisabledException = exports2.PackedPolicyTooLargeException = exports2.MalformedPolicyDocumentException = exports2.ExpiredTokenException = void 0;
    var smithy_client_1 = require_dist_cjs34();
    var STSServiceException_1 = require_STSServiceException();
    var ExpiredTokenException = class _ExpiredTokenException extends STSServiceException_1.STSServiceException {
      constructor(opts) {
        super({
          name: "ExpiredTokenException",
          $fault: "client",
          ...opts
        });
        this.name = "ExpiredTokenException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _ExpiredTokenException.prototype);
      }
    };
    exports2.ExpiredTokenException = ExpiredTokenException;
    var MalformedPolicyDocumentException = class _MalformedPolicyDocumentException extends STSServiceException_1.STSServiceException {
      constructor(opts) {
        super({
          name: "MalformedPolicyDocumentException",
          $fault: "client",
          ...opts
        });
        this.name = "MalformedPolicyDocumentException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _MalformedPolicyDocumentException.prototype);
      }
    };
    exports2.MalformedPolicyDocumentException = MalformedPolicyDocumentException;
    var PackedPolicyTooLargeException = class _PackedPolicyTooLargeException extends STSServiceException_1.STSServiceException {
      constructor(opts) {
        super({
          name: "PackedPolicyTooLargeException",
          $fault: "client",
          ...opts
        });
        this.name = "PackedPolicyTooLargeException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _PackedPolicyTooLargeException.prototype);
      }
    };
    exports2.PackedPolicyTooLargeException = PackedPolicyTooLargeException;
    var RegionDisabledException = class _RegionDisabledException extends STSServiceException_1.STSServiceException {
      constructor(opts) {
        super({
          name: "RegionDisabledException",
          $fault: "client",
          ...opts
        });
        this.name = "RegionDisabledException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _RegionDisabledException.prototype);
      }
    };
    exports2.RegionDisabledException = RegionDisabledException;
    var IDPRejectedClaimException = class _IDPRejectedClaimException extends STSServiceException_1.STSServiceException {
      constructor(opts) {
        super({
          name: "IDPRejectedClaimException",
          $fault: "client",
          ...opts
        });
        this.name = "IDPRejectedClaimException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _IDPRejectedClaimException.prototype);
      }
    };
    exports2.IDPRejectedClaimException = IDPRejectedClaimException;
    var InvalidIdentityTokenException = class _InvalidIdentityTokenException extends STSServiceException_1.STSServiceException {
      constructor(opts) {
        super({
          name: "InvalidIdentityTokenException",
          $fault: "client",
          ...opts
        });
        this.name = "InvalidIdentityTokenException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _InvalidIdentityTokenException.prototype);
      }
    };
    exports2.InvalidIdentityTokenException = InvalidIdentityTokenException;
    var IDPCommunicationErrorException = class _IDPCommunicationErrorException extends STSServiceException_1.STSServiceException {
      constructor(opts) {
        super({
          name: "IDPCommunicationErrorException",
          $fault: "client",
          ...opts
        });
        this.name = "IDPCommunicationErrorException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _IDPCommunicationErrorException.prototype);
      }
    };
    exports2.IDPCommunicationErrorException = IDPCommunicationErrorException;
    var InvalidAuthorizationMessageException = class _InvalidAuthorizationMessageException extends STSServiceException_1.STSServiceException {
      constructor(opts) {
        super({
          name: "InvalidAuthorizationMessageException",
          $fault: "client",
          ...opts
        });
        this.name = "InvalidAuthorizationMessageException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _InvalidAuthorizationMessageException.prototype);
      }
    };
    exports2.InvalidAuthorizationMessageException = InvalidAuthorizationMessageException;
    var CredentialsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.SecretAccessKey && { SecretAccessKey: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.CredentialsFilterSensitiveLog = CredentialsFilterSensitiveLog;
    var AssumeRoleResponseFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.Credentials && { Credentials: (0, exports2.CredentialsFilterSensitiveLog)(obj.Credentials) }
    });
    exports2.AssumeRoleResponseFilterSensitiveLog = AssumeRoleResponseFilterSensitiveLog;
    var AssumeRoleWithSAMLRequestFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.SAMLAssertion && { SAMLAssertion: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.AssumeRoleWithSAMLRequestFilterSensitiveLog = AssumeRoleWithSAMLRequestFilterSensitiveLog;
    var AssumeRoleWithSAMLResponseFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.Credentials && { Credentials: (0, exports2.CredentialsFilterSensitiveLog)(obj.Credentials) }
    });
    exports2.AssumeRoleWithSAMLResponseFilterSensitiveLog = AssumeRoleWithSAMLResponseFilterSensitiveLog;
    var AssumeRoleWithWebIdentityRequestFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.WebIdentityToken && { WebIdentityToken: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.AssumeRoleWithWebIdentityRequestFilterSensitiveLog = AssumeRoleWithWebIdentityRequestFilterSensitiveLog;
    var AssumeRoleWithWebIdentityResponseFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.Credentials && { Credentials: (0, exports2.CredentialsFilterSensitiveLog)(obj.Credentials) }
    });
    exports2.AssumeRoleWithWebIdentityResponseFilterSensitiveLog = AssumeRoleWithWebIdentityResponseFilterSensitiveLog;
    var GetFederationTokenResponseFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.Credentials && { Credentials: (0, exports2.CredentialsFilterSensitiveLog)(obj.Credentials) }
    });
    exports2.GetFederationTokenResponseFilterSensitiveLog = GetFederationTokenResponseFilterSensitiveLog;
    var GetSessionTokenResponseFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.Credentials && { Credentials: (0, exports2.CredentialsFilterSensitiveLog)(obj.Credentials) }
    });
    exports2.GetSessionTokenResponseFilterSensitiveLog = GetSessionTokenResponseFilterSensitiveLog;
  }
});

// ../../../node_modules/fast-xml-parser/src/util.js
var require_util2 = __commonJS({
  "../../../node_modules/fast-xml-parser/src/util.js"(exports2) {
    "use strict";
    var nameStartChar = ":A-Za-z_\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD";
    var nameChar = nameStartChar + "\\-.\\d\\u00B7\\u0300-\\u036F\\u203F-\\u2040";
    var nameRegexp = "[" + nameStartChar + "][" + nameChar + "]*";
    var regexName = new RegExp("^" + nameRegexp + "$");
    var getAllMatches = function(string, regex) {
      const matches = [];
      let match = regex.exec(string);
      while (match) {
        const allmatches = [];
        allmatches.startIndex = regex.lastIndex - match[0].length;
        const len = match.length;
        for (let index = 0; index < len; index++) {
          allmatches.push(match[index]);
        }
        matches.push(allmatches);
        match = regex.exec(string);
      }
      return matches;
    };
    var isName = function(string) {
      const match = regexName.exec(string);
      return !(match === null || typeof match === "undefined");
    };
    exports2.isExist = function(v) {
      return typeof v !== "undefined";
    };
    exports2.isEmptyObject = function(obj) {
      return Object.keys(obj).length === 0;
    };
    exports2.merge = function(target, a, arrayMode) {
      if (a) {
        const keys = Object.keys(a);
        const len = keys.length;
        for (let i = 0; i < len; i++) {
          if (arrayMode === "strict") {
            target[keys[i]] = [a[keys[i]]];
          } else {
            target[keys[i]] = a[keys[i]];
          }
        }
      }
    };
    exports2.getValue = function(v) {
      if (exports2.isExist(v)) {
        return v;
      } else {
        return "";
      }
    };
    exports2.isName = isName;
    exports2.getAllMatches = getAllMatches;
    exports2.nameRegexp = nameRegexp;
  }
});

// ../../../node_modules/fast-xml-parser/src/validator.js
var require_validator = __commonJS({
  "../../../node_modules/fast-xml-parser/src/validator.js"(exports2) {
    "use strict";
    var util = require_util2();
    var defaultOptions = {
      allowBooleanAttributes: false,
      //A tag can have attributes without any value
      unpairedTags: []
    };
    exports2.validate = function(xmlData, options) {
      options = Object.assign({}, defaultOptions, options);
      const tags = [];
      let tagFound = false;
      let reachedRoot = false;
      if (xmlData[0] === "\uFEFF") {
        xmlData = xmlData.substr(1);
      }
      for (let i = 0; i < xmlData.length; i++) {
        if (xmlData[i] === "<" && xmlData[i + 1] === "?") {
          i += 2;
          i = readPI(xmlData, i);
          if (i.err) return i;
        } else if (xmlData[i] === "<") {
          let tagStartPos = i;
          i++;
          if (xmlData[i] === "!") {
            i = readCommentAndCDATA(xmlData, i);
            continue;
          } else {
            let closingTag = false;
            if (xmlData[i] === "/") {
              closingTag = true;
              i++;
            }
            let tagName = "";
            for (; i < xmlData.length && xmlData[i] !== ">" && xmlData[i] !== " " && xmlData[i] !== "	" && xmlData[i] !== "\n" && xmlData[i] !== "\r"; i++) {
              tagName += xmlData[i];
            }
            tagName = tagName.trim();
            if (tagName[tagName.length - 1] === "/") {
              tagName = tagName.substring(0, tagName.length - 1);
              i--;
            }
            if (!validateTagName(tagName)) {
              let msg;
              if (tagName.trim().length === 0) {
                msg = "Invalid space after '<'.";
              } else {
                msg = "Tag '" + tagName + "' is an invalid name.";
              }
              return getErrorObject("InvalidTag", msg, getLineNumberForPosition(xmlData, i));
            }
            const result = readAttributeStr(xmlData, i);
            if (result === false) {
              return getErrorObject("InvalidAttr", "Attributes for '" + tagName + "' have open quote.", getLineNumberForPosition(xmlData, i));
            }
            let attrStr = result.value;
            i = result.index;
            if (attrStr[attrStr.length - 1] === "/") {
              const attrStrStart = i - attrStr.length;
              attrStr = attrStr.substring(0, attrStr.length - 1);
              const isValid = validateAttributeString(attrStr, options);
              if (isValid === true) {
                tagFound = true;
              } else {
                return getErrorObject(isValid.err.code, isValid.err.msg, getLineNumberForPosition(xmlData, attrStrStart + isValid.err.line));
              }
            } else if (closingTag) {
              if (!result.tagClosed) {
                return getErrorObject("InvalidTag", "Closing tag '" + tagName + "' doesn't have proper closing.", getLineNumberForPosition(xmlData, i));
              } else if (attrStr.trim().length > 0) {
                return getErrorObject("InvalidTag", "Closing tag '" + tagName + "' can't have attributes or invalid starting.", getLineNumberForPosition(xmlData, tagStartPos));
              } else {
                const otg = tags.pop();
                if (tagName !== otg.tagName) {
                  let openPos = getLineNumberForPosition(xmlData, otg.tagStartPos);
                  return getErrorObject(
                    "InvalidTag",
                    "Expected closing tag '" + otg.tagName + "' (opened in line " + openPos.line + ", col " + openPos.col + ") instead of closing tag '" + tagName + "'.",
                    getLineNumberForPosition(xmlData, tagStartPos)
                  );
                }
                if (tags.length == 0) {
                  reachedRoot = true;
                }
              }
            } else {
              const isValid = validateAttributeString(attrStr, options);
              if (isValid !== true) {
                return getErrorObject(isValid.err.code, isValid.err.msg, getLineNumberForPosition(xmlData, i - attrStr.length + isValid.err.line));
              }
              if (reachedRoot === true) {
                return getErrorObject("InvalidXml", "Multiple possible root nodes found.", getLineNumberForPosition(xmlData, i));
              } else if (options.unpairedTags.indexOf(tagName) !== -1) {
              } else {
                tags.push({ tagName, tagStartPos });
              }
              tagFound = true;
            }
            for (i++; i < xmlData.length; i++) {
              if (xmlData[i] === "<") {
                if (xmlData[i + 1] === "!") {
                  i++;
                  i = readCommentAndCDATA(xmlData, i);
                  continue;
                } else if (xmlData[i + 1] === "?") {
                  i = readPI(xmlData, ++i);
                  if (i.err) return i;
                } else {
                  break;
                }
              } else if (xmlData[i] === "&") {
                const afterAmp = validateAmpersand(xmlData, i);
                if (afterAmp == -1)
                  return getErrorObject("InvalidChar", "char '&' is not expected.", getLineNumberForPosition(xmlData, i));
                i = afterAmp;
              } else {
                if (reachedRoot === true && !isWhiteSpace(xmlData[i])) {
                  return getErrorObject("InvalidXml", "Extra text at the end", getLineNumberForPosition(xmlData, i));
                }
              }
            }
            if (xmlData[i] === "<") {
              i--;
            }
          }
        } else {
          if (isWhiteSpace(xmlData[i])) {
            continue;
          }
          return getErrorObject("InvalidChar", "char '" + xmlData[i] + "' is not expected.", getLineNumberForPosition(xmlData, i));
        }
      }
      if (!tagFound) {
        return getErrorObject("InvalidXml", "Start tag expected.", 1);
      } else if (tags.length == 1) {
        return getErrorObject("InvalidTag", "Unclosed tag '" + tags[0].tagName + "'.", getLineNumberForPosition(xmlData, tags[0].tagStartPos));
      } else if (tags.length > 0) {
        return getErrorObject("InvalidXml", "Invalid '" + JSON.stringify(tags.map((t) => t.tagName), null, 4).replace(/\r?\n/g, "") + "' found.", { line: 1, col: 1 });
      }
      return true;
    };
    function isWhiteSpace(char) {
      return char === " " || char === "	" || char === "\n" || char === "\r";
    }
    function readPI(xmlData, i) {
      const start = i;
      for (; i < xmlData.length; i++) {
        if (xmlData[i] == "?" || xmlData[i] == " ") {
          const tagname = xmlData.substr(start, i - start);
          if (i > 5 && tagname === "xml") {
            return getErrorObject("InvalidXml", "XML declaration allowed only at the start of the document.", getLineNumberForPosition(xmlData, i));
          } else if (xmlData[i] == "?" && xmlData[i + 1] == ">") {
            i++;
            break;
          } else {
            continue;
          }
        }
      }
      return i;
    }
    function readCommentAndCDATA(xmlData, i) {
      if (xmlData.length > i + 5 && xmlData[i + 1] === "-" && xmlData[i + 2] === "-") {
        for (i += 3; i < xmlData.length; i++) {
          if (xmlData[i] === "-" && xmlData[i + 1] === "-" && xmlData[i + 2] === ">") {
            i += 2;
            break;
          }
        }
      } else if (xmlData.length > i + 8 && xmlData[i + 1] === "D" && xmlData[i + 2] === "O" && xmlData[i + 3] === "C" && xmlData[i + 4] === "T" && xmlData[i + 5] === "Y" && xmlData[i + 6] === "P" && xmlData[i + 7] === "E") {
        let angleBracketsCount = 1;
        for (i += 8; i < xmlData.length; i++) {
          if (xmlData[i] === "<") {
            angleBracketsCount++;
          } else if (xmlData[i] === ">") {
            angleBracketsCount--;
            if (angleBracketsCount === 0) {
              break;
            }
          }
        }
      } else if (xmlData.length > i + 9 && xmlData[i + 1] === "[" && xmlData[i + 2] === "C" && xmlData[i + 3] === "D" && xmlData[i + 4] === "A" && xmlData[i + 5] === "T" && xmlData[i + 6] === "A" && xmlData[i + 7] === "[") {
        for (i += 8; i < xmlData.length; i++) {
          if (xmlData[i] === "]" && xmlData[i + 1] === "]" && xmlData[i + 2] === ">") {
            i += 2;
            break;
          }
        }
      }
      return i;
    }
    var doubleQuote = '"';
    var singleQuote = "'";
    function readAttributeStr(xmlData, i) {
      let attrStr = "";
      let startChar = "";
      let tagClosed = false;
      for (; i < xmlData.length; i++) {
        if (xmlData[i] === doubleQuote || xmlData[i] === singleQuote) {
          if (startChar === "") {
            startChar = xmlData[i];
          } else if (startChar !== xmlData[i]) {
          } else {
            startChar = "";
          }
        } else if (xmlData[i] === ">") {
          if (startChar === "") {
            tagClosed = true;
            break;
          }
        }
        attrStr += xmlData[i];
      }
      if (startChar !== "") {
        return false;
      }
      return {
        value: attrStr,
        index: i,
        tagClosed
      };
    }
    var validAttrStrRegxp = new RegExp(`(\\s*)([^\\s=]+)(\\s*=)?(\\s*(['"])(([\\s\\S])*?)\\5)?`, "g");
    function validateAttributeString(attrStr, options) {
      const matches = util.getAllMatches(attrStr, validAttrStrRegxp);
      const attrNames = {};
      for (let i = 0; i < matches.length; i++) {
        if (matches[i][1].length === 0) {
          return getErrorObject("InvalidAttr", "Attribute '" + matches[i][2] + "' has no space in starting.", getPositionFromMatch(matches[i]));
        } else if (matches[i][3] !== void 0 && matches[i][4] === void 0) {
          return getErrorObject("InvalidAttr", "Attribute '" + matches[i][2] + "' is without value.", getPositionFromMatch(matches[i]));
        } else if (matches[i][3] === void 0 && !options.allowBooleanAttributes) {
          return getErrorObject("InvalidAttr", "boolean attribute '" + matches[i][2] + "' is not allowed.", getPositionFromMatch(matches[i]));
        }
        const attrName = matches[i][2];
        if (!validateAttrName(attrName)) {
          return getErrorObject("InvalidAttr", "Attribute '" + attrName + "' is an invalid name.", getPositionFromMatch(matches[i]));
        }
        if (!attrNames.hasOwnProperty(attrName)) {
          attrNames[attrName] = 1;
        } else {
          return getErrorObject("InvalidAttr", "Attribute '" + attrName + "' is repeated.", getPositionFromMatch(matches[i]));
        }
      }
      return true;
    }
    function validateNumberAmpersand(xmlData, i) {
      let re = /\d/;
      if (xmlData[i] === "x") {
        i++;
        re = /[\da-fA-F]/;
      }
      for (; i < xmlData.length; i++) {
        if (xmlData[i] === ";")
          return i;
        if (!xmlData[i].match(re))
          break;
      }
      return -1;
    }
    function validateAmpersand(xmlData, i) {
      i++;
      if (xmlData[i] === ";")
        return -1;
      if (xmlData[i] === "#") {
        i++;
        return validateNumberAmpersand(xmlData, i);
      }
      let count = 0;
      for (; i < xmlData.length; i++, count++) {
        if (xmlData[i].match(/\w/) && count < 20)
          continue;
        if (xmlData[i] === ";")
          break;
        return -1;
      }
      return i;
    }
    function getErrorObject(code, message, lineNumber) {
      return {
        err: {
          code,
          msg: message,
          line: lineNumber.line || lineNumber,
          col: lineNumber.col
        }
      };
    }
    function validateAttrName(attrName) {
      return util.isName(attrName);
    }
    function validateTagName(tagname) {
      return util.isName(tagname);
    }
    function getLineNumberForPosition(xmlData, index) {
      const lines = xmlData.substring(0, index).split(/\r?\n/);
      return {
        line: lines.length,
        // column number is last line's length + 1, because column numbering starts at 1:
        col: lines[lines.length - 1].length + 1
      };
    }
    function getPositionFromMatch(match) {
      return match.startIndex + match[1].length;
    }
  }
});

// ../../../node_modules/fast-xml-parser/src/xmlparser/OptionsBuilder.js
var require_OptionsBuilder = __commonJS({
  "../../../node_modules/fast-xml-parser/src/xmlparser/OptionsBuilder.js"(exports2) {
    var defaultOptions = {
      preserveOrder: false,
      attributeNamePrefix: "@_",
      attributesGroupName: false,
      textNodeName: "#text",
      ignoreAttributes: true,
      removeNSPrefix: false,
      // remove NS from tag name or attribute name if true
      allowBooleanAttributes: false,
      //a tag can have attributes without any value
      //ignoreRootElement : false,
      parseTagValue: true,
      parseAttributeValue: false,
      trimValues: true,
      //Trim string values of tag and attributes
      cdataPropName: false,
      numberParseOptions: {
        hex: true,
        leadingZeros: true,
        eNotation: true
      },
      tagValueProcessor: function(tagName, val2) {
        return val2;
      },
      attributeValueProcessor: function(attrName, val2) {
        return val2;
      },
      stopNodes: [],
      //nested tags will not be parsed even for errors
      alwaysCreateTextNode: false,
      isArray: () => false,
      commentPropName: false,
      unpairedTags: [],
      processEntities: true,
      htmlEntities: false,
      ignoreDeclaration: false,
      ignorePiTags: false,
      transformTagName: false,
      transformAttributeName: false,
      updateTag: function(tagName, jPath, attrs) {
        return tagName;
      }
      // skipEmptyListItem: false
    };
    var buildOptions = function(options) {
      return Object.assign({}, defaultOptions, options);
    };
    exports2.buildOptions = buildOptions;
    exports2.defaultOptions = defaultOptions;
  }
});

// ../../../node_modules/fast-xml-parser/src/xmlparser/xmlNode.js
var require_xmlNode = __commonJS({
  "../../../node_modules/fast-xml-parser/src/xmlparser/xmlNode.js"(exports2, module2) {
    "use strict";
    var XmlNode = class {
      constructor(tagname) {
        this.tagname = tagname;
        this.child = [];
        this[":@"] = {};
      }
      add(key, val2) {
        if (key === "__proto__") key = "#__proto__";
        this.child.push({ [key]: val2 });
      }
      addChild(node) {
        if (node.tagname === "__proto__") node.tagname = "#__proto__";
        if (node[":@"] && Object.keys(node[":@"]).length > 0) {
          this.child.push({ [node.tagname]: node.child, [":@"]: node[":@"] });
        } else {
          this.child.push({ [node.tagname]: node.child });
        }
      }
    };
    module2.exports = XmlNode;
  }
});

// ../../../node_modules/fast-xml-parser/src/xmlparser/DocTypeReader.js
var require_DocTypeReader = __commonJS({
  "../../../node_modules/fast-xml-parser/src/xmlparser/DocTypeReader.js"(exports2, module2) {
    var util = require_util2();
    function readDocType(xmlData, i) {
      const entities = {};
      if (xmlData[i + 3] === "O" && xmlData[i + 4] === "C" && xmlData[i + 5] === "T" && xmlData[i + 6] === "Y" && xmlData[i + 7] === "P" && xmlData[i + 8] === "E") {
        i = i + 9;
        let angleBracketsCount = 1;
        let hasBody = false, comment = false;
        let exp = "";
        for (; i < xmlData.length; i++) {
          if (xmlData[i] === "<" && !comment) {
            if (hasBody && isEntity(xmlData, i)) {
              i += 7;
              [entityName, val, i] = readEntityExp(xmlData, i + 1);
              if (val.indexOf("&") === -1)
                entities[validateEntityName(entityName)] = {
                  regx: RegExp(`&${entityName};`, "g"),
                  val
                };
            } else if (hasBody && isElement(xmlData, i)) i += 8;
            else if (hasBody && isAttlist(xmlData, i)) i += 8;
            else if (hasBody && isNotation(xmlData, i)) i += 9;
            else if (isComment) comment = true;
            else throw new Error("Invalid DOCTYPE");
            angleBracketsCount++;
            exp = "";
          } else if (xmlData[i] === ">") {
            if (comment) {
              if (xmlData[i - 1] === "-" && xmlData[i - 2] === "-") {
                comment = false;
                angleBracketsCount--;
              }
            } else {
              angleBracketsCount--;
            }
            if (angleBracketsCount === 0) {
              break;
            }
          } else if (xmlData[i] === "[") {
            hasBody = true;
          } else {
            exp += xmlData[i];
          }
        }
        if (angleBracketsCount !== 0) {
          throw new Error(`Unclosed DOCTYPE`);
        }
      } else {
        throw new Error(`Invalid Tag instead of DOCTYPE`);
      }
      return { entities, i };
    }
    function readEntityExp(xmlData, i) {
      let entityName2 = "";
      for (; i < xmlData.length && (xmlData[i] !== "'" && xmlData[i] !== '"'); i++) {
        entityName2 += xmlData[i];
      }
      entityName2 = entityName2.trim();
      if (entityName2.indexOf(" ") !== -1) throw new Error("External entites are not supported");
      const startChar = xmlData[i++];
      let val2 = "";
      for (; i < xmlData.length && xmlData[i] !== startChar; i++) {
        val2 += xmlData[i];
      }
      return [entityName2, val2, i];
    }
    function isComment(xmlData, i) {
      if (xmlData[i + 1] === "!" && xmlData[i + 2] === "-" && xmlData[i + 3] === "-") return true;
      return false;
    }
    function isEntity(xmlData, i) {
      if (xmlData[i + 1] === "!" && xmlData[i + 2] === "E" && xmlData[i + 3] === "N" && xmlData[i + 4] === "T" && xmlData[i + 5] === "I" && xmlData[i + 6] === "T" && xmlData[i + 7] === "Y") return true;
      return false;
    }
    function isElement(xmlData, i) {
      if (xmlData[i + 1] === "!" && xmlData[i + 2] === "E" && xmlData[i + 3] === "L" && xmlData[i + 4] === "E" && xmlData[i + 5] === "M" && xmlData[i + 6] === "E" && xmlData[i + 7] === "N" && xmlData[i + 8] === "T") return true;
      return false;
    }
    function isAttlist(xmlData, i) {
      if (xmlData[i + 1] === "!" && xmlData[i + 2] === "A" && xmlData[i + 3] === "T" && xmlData[i + 4] === "T" && xmlData[i + 5] === "L" && xmlData[i + 6] === "I" && xmlData[i + 7] === "S" && xmlData[i + 8] === "T") return true;
      return false;
    }
    function isNotation(xmlData, i) {
      if (xmlData[i + 1] === "!" && xmlData[i + 2] === "N" && xmlData[i + 3] === "O" && xmlData[i + 4] === "T" && xmlData[i + 5] === "A" && xmlData[i + 6] === "T" && xmlData[i + 7] === "I" && xmlData[i + 8] === "O" && xmlData[i + 9] === "N") return true;
      return false;
    }
    function validateEntityName(name) {
      if (util.isName(name))
        return name;
      else
        throw new Error(`Invalid entity name ${name}`);
    }
    module2.exports = readDocType;
  }
});

// ../../../node_modules/strnum/strnum.js
var require_strnum = __commonJS({
  "../../../node_modules/strnum/strnum.js"(exports2, module2) {
    var hexRegex = /^[-+]?0x[a-fA-F0-9]+$/;
    var numRegex = /^([\-\+])?(0*)(\.[0-9]+([eE]\-?[0-9]+)?|[0-9]+(\.[0-9]+([eE]\-?[0-9]+)?)?)$/;
    if (!Number.parseInt && window.parseInt) {
      Number.parseInt = window.parseInt;
    }
    if (!Number.parseFloat && window.parseFloat) {
      Number.parseFloat = window.parseFloat;
    }
    var consider = {
      hex: true,
      leadingZeros: true,
      decimalPoint: ".",
      eNotation: true
      //skipLike: /regex/
    };
    function toNumber(str, options = {}) {
      options = Object.assign({}, consider, options);
      if (!str || typeof str !== "string") return str;
      let trimmedStr = str.trim();
      if (options.skipLike !== void 0 && options.skipLike.test(trimmedStr)) return str;
      else if (options.hex && hexRegex.test(trimmedStr)) {
        return Number.parseInt(trimmedStr, 16);
      } else {
        const match = numRegex.exec(trimmedStr);
        if (match) {
          const sign = match[1];
          const leadingZeros = match[2];
          let numTrimmedByZeros = trimZeros(match[3]);
          const eNotation = match[4] || match[6];
          if (!options.leadingZeros && leadingZeros.length > 0 && sign && trimmedStr[2] !== ".") return str;
          else if (!options.leadingZeros && leadingZeros.length > 0 && !sign && trimmedStr[1] !== ".") return str;
          else {
            const num = Number(trimmedStr);
            const numStr = "" + num;
            if (numStr.search(/[eE]/) !== -1) {
              if (options.eNotation) return num;
              else return str;
            } else if (eNotation) {
              if (options.eNotation) return num;
              else return str;
            } else if (trimmedStr.indexOf(".") !== -1) {
              if (numStr === "0" && numTrimmedByZeros === "") return num;
              else if (numStr === numTrimmedByZeros) return num;
              else if (sign && numStr === "-" + numTrimmedByZeros) return num;
              else return str;
            }
            if (leadingZeros) {
              if (numTrimmedByZeros === numStr) return num;
              else if (sign + numTrimmedByZeros === numStr) return num;
              else return str;
            }
            if (trimmedStr === numStr) return num;
            else if (trimmedStr === sign + numStr) return num;
            return str;
          }
        } else {
          return str;
        }
      }
    }
    function trimZeros(numStr) {
      if (numStr && numStr.indexOf(".") !== -1) {
        numStr = numStr.replace(/0+$/, "");
        if (numStr === ".") numStr = "0";
        else if (numStr[0] === ".") numStr = "0" + numStr;
        else if (numStr[numStr.length - 1] === ".") numStr = numStr.substr(0, numStr.length - 1);
        return numStr;
      }
      return numStr;
    }
    module2.exports = toNumber;
  }
});

// ../../../node_modules/fast-xml-parser/src/xmlparser/OrderedObjParser.js
var require_OrderedObjParser = __commonJS({
  "../../../node_modules/fast-xml-parser/src/xmlparser/OrderedObjParser.js"(exports2, module2) {
    "use strict";
    var util = require_util2();
    var xmlNode = require_xmlNode();
    var readDocType = require_DocTypeReader();
    var toNumber = require_strnum();
    var regx = "<((!\\[CDATA\\[([\\s\\S]*?)(]]>))|((NAME:)?(NAME))([^>]*)>|((\\/)(NAME)\\s*>))([^<]*)".replace(/NAME/g, util.nameRegexp);
    var OrderedObjParser = class {
      constructor(options) {
        this.options = options;
        this.currentNode = null;
        this.tagsNodeStack = [];
        this.docTypeEntities = {};
        this.lastEntities = {
          "apos": { regex: /&(apos|#39|#x27);/g, val: "'" },
          "gt": { regex: /&(gt|#62|#x3E);/g, val: ">" },
          "lt": { regex: /&(lt|#60|#x3C);/g, val: "<" },
          "quot": { regex: /&(quot|#34|#x22);/g, val: '"' }
        };
        this.ampEntity = { regex: /&(amp|#38|#x26);/g, val: "&" };
        this.htmlEntities = {
          "space": { regex: /&(nbsp|#160);/g, val: " " },
          // "lt" : { regex: /&(lt|#60);/g, val: "<" },
          // "gt" : { regex: /&(gt|#62);/g, val: ">" },
          // "amp" : { regex: /&(amp|#38);/g, val: "&" },
          // "quot" : { regex: /&(quot|#34);/g, val: "\"" },
          // "apos" : { regex: /&(apos|#39);/g, val: "'" },
          "cent": { regex: /&(cent|#162);/g, val: "\xA2" },
          "pound": { regex: /&(pound|#163);/g, val: "\xA3" },
          "yen": { regex: /&(yen|#165);/g, val: "\xA5" },
          "euro": { regex: /&(euro|#8364);/g, val: "\u20AC" },
          "copyright": { regex: /&(copy|#169);/g, val: "\xA9" },
          "reg": { regex: /&(reg|#174);/g, val: "\xAE" },
          "inr": { regex: /&(inr|#8377);/g, val: "\u20B9" }
        };
        this.addExternalEntities = addExternalEntities;
        this.parseXml = parseXml;
        this.parseTextData = parseTextData;
        this.resolveNameSpace = resolveNameSpace;
        this.buildAttributesMap = buildAttributesMap;
        this.isItStopNode = isItStopNode;
        this.replaceEntitiesValue = replaceEntitiesValue;
        this.readStopNodeData = readStopNodeData;
        this.saveTextToParentTag = saveTextToParentTag;
        this.addChild = addChild;
      }
    };
    function addExternalEntities(externalEntities) {
      const entKeys = Object.keys(externalEntities);
      for (let i = 0; i < entKeys.length; i++) {
        const ent = entKeys[i];
        this.lastEntities[ent] = {
          regex: new RegExp("&" + ent + ";", "g"),
          val: externalEntities[ent]
        };
      }
    }
    function parseTextData(val2, tagName, jPath, dontTrim, hasAttributes, isLeafNode, escapeEntities) {
      if (val2 !== void 0) {
        if (this.options.trimValues && !dontTrim) {
          val2 = val2.trim();
        }
        if (val2.length > 0) {
          if (!escapeEntities) val2 = this.replaceEntitiesValue(val2);
          const newval = this.options.tagValueProcessor(tagName, val2, jPath, hasAttributes, isLeafNode);
          if (newval === null || newval === void 0) {
            return val2;
          } else if (typeof newval !== typeof val2 || newval !== val2) {
            return newval;
          } else if (this.options.trimValues) {
            return parseValue(val2, this.options.parseTagValue, this.options.numberParseOptions);
          } else {
            const trimmedVal = val2.trim();
            if (trimmedVal === val2) {
              return parseValue(val2, this.options.parseTagValue, this.options.numberParseOptions);
            } else {
              return val2;
            }
          }
        }
      }
    }
    function resolveNameSpace(tagname) {
      if (this.options.removeNSPrefix) {
        const tags = tagname.split(":");
        const prefix = tagname.charAt(0) === "/" ? "/" : "";
        if (tags[0] === "xmlns") {
          return "";
        }
        if (tags.length === 2) {
          tagname = prefix + tags[1];
        }
      }
      return tagname;
    }
    var attrsRegx = new RegExp(`([^\\s=]+)\\s*(=\\s*(['"])([\\s\\S]*?)\\3)?`, "gm");
    function buildAttributesMap(attrStr, jPath, tagName) {
      if (!this.options.ignoreAttributes && typeof attrStr === "string") {
        const matches = util.getAllMatches(attrStr, attrsRegx);
        const len = matches.length;
        const attrs = {};
        for (let i = 0; i < len; i++) {
          const attrName = this.resolveNameSpace(matches[i][1]);
          let oldVal = matches[i][4];
          let aName = this.options.attributeNamePrefix + attrName;
          if (attrName.length) {
            if (this.options.transformAttributeName) {
              aName = this.options.transformAttributeName(aName);
            }
            if (aName === "__proto__") aName = "#__proto__";
            if (oldVal !== void 0) {
              if (this.options.trimValues) {
                oldVal = oldVal.trim();
              }
              oldVal = this.replaceEntitiesValue(oldVal);
              const newVal = this.options.attributeValueProcessor(attrName, oldVal, jPath);
              if (newVal === null || newVal === void 0) {
                attrs[aName] = oldVal;
              } else if (typeof newVal !== typeof oldVal || newVal !== oldVal) {
                attrs[aName] = newVal;
              } else {
                attrs[aName] = parseValue(
                  oldVal,
                  this.options.parseAttributeValue,
                  this.options.numberParseOptions
                );
              }
            } else if (this.options.allowBooleanAttributes) {
              attrs[aName] = true;
            }
          }
        }
        if (!Object.keys(attrs).length) {
          return;
        }
        if (this.options.attributesGroupName) {
          const attrCollection = {};
          attrCollection[this.options.attributesGroupName] = attrs;
          return attrCollection;
        }
        return attrs;
      }
    }
    var parseXml = function(xmlData) {
      xmlData = xmlData.replace(/\r\n?/g, "\n");
      const xmlObj = new xmlNode("!xml");
      let currentNode = xmlObj;
      let textData = "";
      let jPath = "";
      for (let i = 0; i < xmlData.length; i++) {
        const ch = xmlData[i];
        if (ch === "<") {
          if (xmlData[i + 1] === "/") {
            const closeIndex = findClosingIndex(xmlData, ">", i, "Closing Tag is not closed.");
            let tagName = xmlData.substring(i + 2, closeIndex).trim();
            if (this.options.removeNSPrefix) {
              const colonIndex = tagName.indexOf(":");
              if (colonIndex !== -1) {
                tagName = tagName.substr(colonIndex + 1);
              }
            }
            if (this.options.transformTagName) {
              tagName = this.options.transformTagName(tagName);
            }
            if (currentNode) {
              textData = this.saveTextToParentTag(textData, currentNode, jPath);
            }
            const lastTagName = jPath.substring(jPath.lastIndexOf(".") + 1);
            if (tagName && this.options.unpairedTags.indexOf(tagName) !== -1) {
              throw new Error(`Unpaired tag can not be used as closing tag: </${tagName}>`);
            }
            let propIndex = 0;
            if (lastTagName && this.options.unpairedTags.indexOf(lastTagName) !== -1) {
              propIndex = jPath.lastIndexOf(".", jPath.lastIndexOf(".") - 1);
              this.tagsNodeStack.pop();
            } else {
              propIndex = jPath.lastIndexOf(".");
            }
            jPath = jPath.substring(0, propIndex);
            currentNode = this.tagsNodeStack.pop();
            textData = "";
            i = closeIndex;
          } else if (xmlData[i + 1] === "?") {
            let tagData = readTagExp(xmlData, i, false, "?>");
            if (!tagData) throw new Error("Pi Tag is not closed.");
            textData = this.saveTextToParentTag(textData, currentNode, jPath);
            if (this.options.ignoreDeclaration && tagData.tagName === "?xml" || this.options.ignorePiTags) {
            } else {
              const childNode = new xmlNode(tagData.tagName);
              childNode.add(this.options.textNodeName, "");
              if (tagData.tagName !== tagData.tagExp && tagData.attrExpPresent) {
                childNode[":@"] = this.buildAttributesMap(tagData.tagExp, jPath, tagData.tagName);
              }
              this.addChild(currentNode, childNode, jPath);
            }
            i = tagData.closeIndex + 1;
          } else if (xmlData.substr(i + 1, 3) === "!--") {
            const endIndex = findClosingIndex(xmlData, "-->", i + 4, "Comment is not closed.");
            if (this.options.commentPropName) {
              const comment = xmlData.substring(i + 4, endIndex - 2);
              textData = this.saveTextToParentTag(textData, currentNode, jPath);
              currentNode.add(this.options.commentPropName, [{ [this.options.textNodeName]: comment }]);
            }
            i = endIndex;
          } else if (xmlData.substr(i + 1, 2) === "!D") {
            const result = readDocType(xmlData, i);
            this.docTypeEntities = result.entities;
            i = result.i;
          } else if (xmlData.substr(i + 1, 2) === "![") {
            const closeIndex = findClosingIndex(xmlData, "]]>", i, "CDATA is not closed.") - 2;
            const tagExp = xmlData.substring(i + 9, closeIndex);
            textData = this.saveTextToParentTag(textData, currentNode, jPath);
            if (this.options.cdataPropName) {
              currentNode.add(this.options.cdataPropName, [{ [this.options.textNodeName]: tagExp }]);
            } else {
              let val2 = this.parseTextData(tagExp, currentNode.tagname, jPath, true, false, true);
              if (val2 == void 0) val2 = "";
              currentNode.add(this.options.textNodeName, val2);
            }
            i = closeIndex + 2;
          } else {
            let result = readTagExp(xmlData, i, this.options.removeNSPrefix);
            let tagName = result.tagName;
            let tagExp = result.tagExp;
            let attrExpPresent = result.attrExpPresent;
            let closeIndex = result.closeIndex;
            if (this.options.transformTagName) {
              tagName = this.options.transformTagName(tagName);
            }
            if (currentNode && textData) {
              if (currentNode.tagname !== "!xml") {
                textData = this.saveTextToParentTag(textData, currentNode, jPath, false);
              }
            }
            const lastTag = currentNode;
            if (lastTag && this.options.unpairedTags.indexOf(lastTag.tagname) !== -1) {
              currentNode = this.tagsNodeStack.pop();
              jPath = jPath.substring(0, jPath.lastIndexOf("."));
            }
            if (tagName !== xmlObj.tagname) {
              jPath += jPath ? "." + tagName : tagName;
            }
            if (this.isItStopNode(this.options.stopNodes, jPath, tagName)) {
              let tagContent = "";
              if (tagExp.length > 0 && tagExp.lastIndexOf("/") === tagExp.length - 1) {
                i = result.closeIndex;
              } else if (this.options.unpairedTags.indexOf(tagName) !== -1) {
                i = result.closeIndex;
              } else {
                const result2 = this.readStopNodeData(xmlData, tagName, closeIndex + 1);
                if (!result2) throw new Error(`Unexpected end of ${tagName}`);
                i = result2.i;
                tagContent = result2.tagContent;
              }
              const childNode = new xmlNode(tagName);
              if (tagName !== tagExp && attrExpPresent) {
                childNode[":@"] = this.buildAttributesMap(tagExp, jPath, tagName);
              }
              if (tagContent) {
                tagContent = this.parseTextData(tagContent, tagName, jPath, true, attrExpPresent, true, true);
              }
              jPath = jPath.substr(0, jPath.lastIndexOf("."));
              childNode.add(this.options.textNodeName, tagContent);
              this.addChild(currentNode, childNode, jPath);
            } else {
              if (tagExp.length > 0 && tagExp.lastIndexOf("/") === tagExp.length - 1) {
                if (tagName[tagName.length - 1] === "/") {
                  tagName = tagName.substr(0, tagName.length - 1);
                  tagExp = tagName;
                } else {
                  tagExp = tagExp.substr(0, tagExp.length - 1);
                }
                if (this.options.transformTagName) {
                  tagName = this.options.transformTagName(tagName);
                }
                const childNode = new xmlNode(tagName);
                if (tagName !== tagExp && attrExpPresent) {
                  childNode[":@"] = this.buildAttributesMap(tagExp, jPath, tagName);
                }
                this.addChild(currentNode, childNode, jPath);
                jPath = jPath.substr(0, jPath.lastIndexOf("."));
              } else {
                const childNode = new xmlNode(tagName);
                this.tagsNodeStack.push(currentNode);
                if (tagName !== tagExp && attrExpPresent) {
                  childNode[":@"] = this.buildAttributesMap(tagExp, jPath, tagName);
                }
                this.addChild(currentNode, childNode, jPath);
                currentNode = childNode;
              }
              textData = "";
              i = closeIndex;
            }
          }
        } else {
          textData += xmlData[i];
        }
      }
      return xmlObj.child;
    };
    function addChild(currentNode, childNode, jPath) {
      const result = this.options.updateTag(childNode.tagname, jPath, childNode[":@"]);
      if (result === false) {
      } else if (typeof result === "string") {
        childNode.tagname = result;
        currentNode.addChild(childNode);
      } else {
        currentNode.addChild(childNode);
      }
    }
    var replaceEntitiesValue = function(val2) {
      if (this.options.processEntities) {
        for (let entityName2 in this.docTypeEntities) {
          const entity = this.docTypeEntities[entityName2];
          val2 = val2.replace(entity.regx, entity.val);
        }
        for (let entityName2 in this.lastEntities) {
          const entity = this.lastEntities[entityName2];
          val2 = val2.replace(entity.regex, entity.val);
        }
        if (this.options.htmlEntities) {
          for (let entityName2 in this.htmlEntities) {
            const entity = this.htmlEntities[entityName2];
            val2 = val2.replace(entity.regex, entity.val);
          }
        }
        val2 = val2.replace(this.ampEntity.regex, this.ampEntity.val);
      }
      return val2;
    };
    function saveTextToParentTag(textData, currentNode, jPath, isLeafNode) {
      if (textData) {
        if (isLeafNode === void 0) isLeafNode = Object.keys(currentNode.child).length === 0;
        textData = this.parseTextData(
          textData,
          currentNode.tagname,
          jPath,
          false,
          currentNode[":@"] ? Object.keys(currentNode[":@"]).length !== 0 : false,
          isLeafNode
        );
        if (textData !== void 0 && textData !== "")
          currentNode.add(this.options.textNodeName, textData);
        textData = "";
      }
      return textData;
    }
    function isItStopNode(stopNodes, jPath, currentTagName) {
      const allNodesExp = "*." + currentTagName;
      for (const stopNodePath in stopNodes) {
        const stopNodeExp = stopNodes[stopNodePath];
        if (allNodesExp === stopNodeExp || jPath === stopNodeExp) return true;
      }
      return false;
    }
    function tagExpWithClosingIndex(xmlData, i, closingChar = ">") {
      let attrBoundary;
      let tagExp = "";
      for (let index = i; index < xmlData.length; index++) {
        let ch = xmlData[index];
        if (attrBoundary) {
          if (ch === attrBoundary) attrBoundary = "";
        } else if (ch === '"' || ch === "'") {
          attrBoundary = ch;
        } else if (ch === closingChar[0]) {
          if (closingChar[1]) {
            if (xmlData[index + 1] === closingChar[1]) {
              return {
                data: tagExp,
                index
              };
            }
          } else {
            return {
              data: tagExp,
              index
            };
          }
        } else if (ch === "	") {
          ch = " ";
        }
        tagExp += ch;
      }
    }
    function findClosingIndex(xmlData, str, i, errMsg) {
      const closingIndex = xmlData.indexOf(str, i);
      if (closingIndex === -1) {
        throw new Error(errMsg);
      } else {
        return closingIndex + str.length - 1;
      }
    }
    function readTagExp(xmlData, i, removeNSPrefix, closingChar = ">") {
      const result = tagExpWithClosingIndex(xmlData, i + 1, closingChar);
      if (!result) return;
      let tagExp = result.data;
      const closeIndex = result.index;
      const separatorIndex = tagExp.search(/\s/);
      let tagName = tagExp;
      let attrExpPresent = true;
      if (separatorIndex !== -1) {
        tagName = tagExp.substr(0, separatorIndex).replace(/\s\s*$/, "");
        tagExp = tagExp.substr(separatorIndex + 1);
      }
      if (removeNSPrefix) {
        const colonIndex = tagName.indexOf(":");
        if (colonIndex !== -1) {
          tagName = tagName.substr(colonIndex + 1);
          attrExpPresent = tagName !== result.data.substr(colonIndex + 1);
        }
      }
      return {
        tagName,
        tagExp,
        closeIndex,
        attrExpPresent
      };
    }
    function readStopNodeData(xmlData, tagName, i) {
      const startIndex = i;
      let openTagCount = 1;
      for (; i < xmlData.length; i++) {
        if (xmlData[i] === "<") {
          if (xmlData[i + 1] === "/") {
            const closeIndex = findClosingIndex(xmlData, ">", i, `${tagName} is not closed`);
            let closeTagName = xmlData.substring(i + 2, closeIndex).trim();
            if (closeTagName === tagName) {
              openTagCount--;
              if (openTagCount === 0) {
                return {
                  tagContent: xmlData.substring(startIndex, i),
                  i: closeIndex
                };
              }
            }
            i = closeIndex;
          } else if (xmlData[i + 1] === "?") {
            const closeIndex = findClosingIndex(xmlData, "?>", i + 1, "StopNode is not closed.");
            i = closeIndex;
          } else if (xmlData.substr(i + 1, 3) === "!--") {
            const closeIndex = findClosingIndex(xmlData, "-->", i + 3, "StopNode is not closed.");
            i = closeIndex;
          } else if (xmlData.substr(i + 1, 2) === "![") {
            const closeIndex = findClosingIndex(xmlData, "]]>", i, "StopNode is not closed.") - 2;
            i = closeIndex;
          } else {
            const tagData = readTagExp(xmlData, i, ">");
            if (tagData) {
              const openTagName = tagData && tagData.tagName;
              if (openTagName === tagName && tagData.tagExp[tagData.tagExp.length - 1] !== "/") {
                openTagCount++;
              }
              i = tagData.closeIndex;
            }
          }
        }
      }
    }
    function parseValue(val2, shouldParse, options) {
      if (shouldParse && typeof val2 === "string") {
        const newval = val2.trim();
        if (newval === "true") return true;
        else if (newval === "false") return false;
        else return toNumber(val2, options);
      } else {
        if (util.isExist(val2)) {
          return val2;
        } else {
          return "";
        }
      }
    }
    module2.exports = OrderedObjParser;
  }
});

// ../../../node_modules/fast-xml-parser/src/xmlparser/node2json.js
var require_node2json = __commonJS({
  "../../../node_modules/fast-xml-parser/src/xmlparser/node2json.js"(exports2) {
    "use strict";
    function prettify(node, options) {
      return compress(node, options);
    }
    function compress(arr, options, jPath) {
      let text;
      const compressedObj = {};
      for (let i = 0; i < arr.length; i++) {
        const tagObj = arr[i];
        const property = propName(tagObj);
        let newJpath = "";
        if (jPath === void 0) newJpath = property;
        else newJpath = jPath + "." + property;
        if (property === options.textNodeName) {
          if (text === void 0) text = tagObj[property];
          else text += "" + tagObj[property];
        } else if (property === void 0) {
          continue;
        } else if (tagObj[property]) {
          let val2 = compress(tagObj[property], options, newJpath);
          const isLeaf = isLeafTag(val2, options);
          if (tagObj[":@"]) {
            assignAttributes(val2, tagObj[":@"], newJpath, options);
          } else if (Object.keys(val2).length === 1 && val2[options.textNodeName] !== void 0 && !options.alwaysCreateTextNode) {
            val2 = val2[options.textNodeName];
          } else if (Object.keys(val2).length === 0) {
            if (options.alwaysCreateTextNode) val2[options.textNodeName] = "";
            else val2 = "";
          }
          if (compressedObj[property] !== void 0 && compressedObj.hasOwnProperty(property)) {
            if (!Array.isArray(compressedObj[property])) {
              compressedObj[property] = [compressedObj[property]];
            }
            compressedObj[property].push(val2);
          } else {
            if (options.isArray(property, newJpath, isLeaf)) {
              compressedObj[property] = [val2];
            } else {
              compressedObj[property] = val2;
            }
          }
        }
      }
      if (typeof text === "string") {
        if (text.length > 0) compressedObj[options.textNodeName] = text;
      } else if (text !== void 0) compressedObj[options.textNodeName] = text;
      return compressedObj;
    }
    function propName(obj) {
      const keys = Object.keys(obj);
      for (let i = 0; i < keys.length; i++) {
        const key = keys[i];
        if (key !== ":@") return key;
      }
    }
    function assignAttributes(obj, attrMap, jpath, options) {
      if (attrMap) {
        const keys = Object.keys(attrMap);
        const len = keys.length;
        for (let i = 0; i < len; i++) {
          const atrrName = keys[i];
          if (options.isArray(atrrName, jpath + "." + atrrName, true, true)) {
            obj[atrrName] = [attrMap[atrrName]];
          } else {
            obj[atrrName] = attrMap[atrrName];
          }
        }
      }
    }
    function isLeafTag(obj, options) {
      const { textNodeName } = options;
      const propCount = Object.keys(obj).length;
      if (propCount === 0) {
        return true;
      }
      if (propCount === 1 && (obj[textNodeName] || typeof obj[textNodeName] === "boolean" || obj[textNodeName] === 0)) {
        return true;
      }
      return false;
    }
    exports2.prettify = prettify;
  }
});

// ../../../node_modules/fast-xml-parser/src/xmlparser/XMLParser.js
var require_XMLParser = __commonJS({
  "../../../node_modules/fast-xml-parser/src/xmlparser/XMLParser.js"(exports2, module2) {
    var { buildOptions } = require_OptionsBuilder();
    var OrderedObjParser = require_OrderedObjParser();
    var { prettify } = require_node2json();
    var validator = require_validator();
    var XMLParser = class {
      constructor(options) {
        this.externalEntities = {};
        this.options = buildOptions(options);
      }
      /**
       * Parse XML dats to JS object 
       * @param {string|Buffer} xmlData 
       * @param {boolean|Object} validationOption 
       */
      parse(xmlData, validationOption) {
        if (typeof xmlData === "string") {
        } else if (xmlData.toString) {
          xmlData = xmlData.toString();
        } else {
          throw new Error("XML data is accepted in String or Bytes[] form.");
        }
        if (validationOption) {
          if (validationOption === true) validationOption = {};
          const result = validator.validate(xmlData, validationOption);
          if (result !== true) {
            throw Error(`${result.err.msg}:${result.err.line}:${result.err.col}`);
          }
        }
        const orderedObjParser = new OrderedObjParser(this.options);
        orderedObjParser.addExternalEntities(this.externalEntities);
        const orderedResult = orderedObjParser.parseXml(xmlData);
        if (this.options.preserveOrder || orderedResult === void 0) return orderedResult;
        else return prettify(orderedResult, this.options);
      }
      /**
       * Add Entity which is not by default supported by this library
       * @param {string} key 
       * @param {string} value 
       */
      addEntity(key, value) {
        if (value.indexOf("&") !== -1) {
          throw new Error("Entity value can't have '&'");
        } else if (key.indexOf("&") !== -1 || key.indexOf(";") !== -1) {
          throw new Error("An entity must be set without '&' and ';'. Eg. use '#xD' for '&#xD;'");
        } else if (value === "&") {
          throw new Error("An entity with value '&' is not permitted");
        } else {
          this.externalEntities[key] = value;
        }
      }
    };
    module2.exports = XMLParser;
  }
});

// ../../../node_modules/fast-xml-parser/src/xmlbuilder/orderedJs2Xml.js
var require_orderedJs2Xml = __commonJS({
  "../../../node_modules/fast-xml-parser/src/xmlbuilder/orderedJs2Xml.js"(exports2, module2) {
    var EOL = "\n";
    function toXml(jArray, options) {
      let indentation = "";
      if (options.format && options.indentBy.length > 0) {
        indentation = EOL;
      }
      return arrToStr(jArray, options, "", indentation);
    }
    function arrToStr(arr, options, jPath, indentation) {
      let xmlStr = "";
      let isPreviousElementTag = false;
      for (let i = 0; i < arr.length; i++) {
        const tagObj = arr[i];
        const tagName = propName(tagObj);
        let newJPath = "";
        if (jPath.length === 0) newJPath = tagName;
        else newJPath = `${jPath}.${tagName}`;
        if (tagName === options.textNodeName) {
          let tagText = tagObj[tagName];
          if (!isStopNode(newJPath, options)) {
            tagText = options.tagValueProcessor(tagName, tagText);
            tagText = replaceEntitiesValue(tagText, options);
          }
          if (isPreviousElementTag) {
            xmlStr += indentation;
          }
          xmlStr += tagText;
          isPreviousElementTag = false;
          continue;
        } else if (tagName === options.cdataPropName) {
          if (isPreviousElementTag) {
            xmlStr += indentation;
          }
          xmlStr += `<![CDATA[${tagObj[tagName][0][options.textNodeName]}]]>`;
          isPreviousElementTag = false;
          continue;
        } else if (tagName === options.commentPropName) {
          xmlStr += indentation + `<!--${tagObj[tagName][0][options.textNodeName]}-->`;
          isPreviousElementTag = true;
          continue;
        } else if (tagName[0] === "?") {
          const attStr2 = attr_to_str(tagObj[":@"], options);
          const tempInd = tagName === "?xml" ? "" : indentation;
          let piTextNodeName = tagObj[tagName][0][options.textNodeName];
          piTextNodeName = piTextNodeName.length !== 0 ? " " + piTextNodeName : "";
          xmlStr += tempInd + `<${tagName}${piTextNodeName}${attStr2}?>`;
          isPreviousElementTag = true;
          continue;
        }
        let newIdentation = indentation;
        if (newIdentation !== "") {
          newIdentation += options.indentBy;
        }
        const attStr = attr_to_str(tagObj[":@"], options);
        const tagStart = indentation + `<${tagName}${attStr}`;
        const tagValue = arrToStr(tagObj[tagName], options, newJPath, newIdentation);
        if (options.unpairedTags.indexOf(tagName) !== -1) {
          if (options.suppressUnpairedNode) xmlStr += tagStart + ">";
          else xmlStr += tagStart + "/>";
        } else if ((!tagValue || tagValue.length === 0) && options.suppressEmptyNode) {
          xmlStr += tagStart + "/>";
        } else if (tagValue && tagValue.endsWith(">")) {
          xmlStr += tagStart + `>${tagValue}${indentation}</${tagName}>`;
        } else {
          xmlStr += tagStart + ">";
          if (tagValue && indentation !== "" && (tagValue.includes("/>") || tagValue.includes("</"))) {
            xmlStr += indentation + options.indentBy + tagValue + indentation;
          } else {
            xmlStr += tagValue;
          }
          xmlStr += `</${tagName}>`;
        }
        isPreviousElementTag = true;
      }
      return xmlStr;
    }
    function propName(obj) {
      const keys = Object.keys(obj);
      for (let i = 0; i < keys.length; i++) {
        const key = keys[i];
        if (key !== ":@") return key;
      }
    }
    function attr_to_str(attrMap, options) {
      let attrStr = "";
      if (attrMap && !options.ignoreAttributes) {
        for (let attr in attrMap) {
          let attrVal = options.attributeValueProcessor(attr, attrMap[attr]);
          attrVal = replaceEntitiesValue(attrVal, options);
          if (attrVal === true && options.suppressBooleanAttributes) {
            attrStr += ` ${attr.substr(options.attributeNamePrefix.length)}`;
          } else {
            attrStr += ` ${attr.substr(options.attributeNamePrefix.length)}="${attrVal}"`;
          }
        }
      }
      return attrStr;
    }
    function isStopNode(jPath, options) {
      jPath = jPath.substr(0, jPath.length - options.textNodeName.length - 1);
      let tagName = jPath.substr(jPath.lastIndexOf(".") + 1);
      for (let index in options.stopNodes) {
        if (options.stopNodes[index] === jPath || options.stopNodes[index] === "*." + tagName) return true;
      }
      return false;
    }
    function replaceEntitiesValue(textValue, options) {
      if (textValue && textValue.length > 0 && options.processEntities) {
        for (let i = 0; i < options.entities.length; i++) {
          const entity = options.entities[i];
          textValue = textValue.replace(entity.regex, entity.val);
        }
      }
      return textValue;
    }
    module2.exports = toXml;
  }
});

// ../../../node_modules/fast-xml-parser/src/xmlbuilder/json2xml.js
var require_json2xml = __commonJS({
  "../../../node_modules/fast-xml-parser/src/xmlbuilder/json2xml.js"(exports2, module2) {
    "use strict";
    var buildFromOrderedJs = require_orderedJs2Xml();
    var defaultOptions = {
      attributeNamePrefix: "@_",
      attributesGroupName: false,
      textNodeName: "#text",
      ignoreAttributes: true,
      cdataPropName: false,
      format: false,
      indentBy: "  ",
      suppressEmptyNode: false,
      suppressUnpairedNode: true,
      suppressBooleanAttributes: true,
      tagValueProcessor: function(key, a) {
        return a;
      },
      attributeValueProcessor: function(attrName, a) {
        return a;
      },
      preserveOrder: false,
      commentPropName: false,
      unpairedTags: [],
      entities: [
        { regex: new RegExp("&", "g"), val: "&amp;" },
        //it must be on top
        { regex: new RegExp(">", "g"), val: "&gt;" },
        { regex: new RegExp("<", "g"), val: "&lt;" },
        { regex: new RegExp("'", "g"), val: "&apos;" },
        { regex: new RegExp('"', "g"), val: "&quot;" }
      ],
      processEntities: true,
      stopNodes: [],
      // transformTagName: false,
      // transformAttributeName: false,
      oneListGroup: false
    };
    function Builder(options) {
      this.options = Object.assign({}, defaultOptions, options);
      if (this.options.ignoreAttributes || this.options.attributesGroupName) {
        this.isAttribute = function() {
          return false;
        };
      } else {
        this.attrPrefixLen = this.options.attributeNamePrefix.length;
        this.isAttribute = isAttribute;
      }
      this.processTextOrObjNode = processTextOrObjNode;
      if (this.options.format) {
        this.indentate = indentate;
        this.tagEndChar = ">\n";
        this.newLine = "\n";
      } else {
        this.indentate = function() {
          return "";
        };
        this.tagEndChar = ">";
        this.newLine = "";
      }
    }
    Builder.prototype.build = function(jObj) {
      if (this.options.preserveOrder) {
        return buildFromOrderedJs(jObj, this.options);
      } else {
        if (Array.isArray(jObj) && this.options.arrayNodeName && this.options.arrayNodeName.length > 1) {
          jObj = {
            [this.options.arrayNodeName]: jObj
          };
        }
        return this.j2x(jObj, 0).val;
      }
    };
    Builder.prototype.j2x = function(jObj, level) {
      let attrStr = "";
      let val2 = "";
      for (let key in jObj) {
        if (typeof jObj[key] === "undefined") {
        } else if (jObj[key] === null) {
          if (key[0] === "?") val2 += this.indentate(level) + "<" + key + "?" + this.tagEndChar;
          else val2 += this.indentate(level) + "<" + key + "/" + this.tagEndChar;
        } else if (jObj[key] instanceof Date) {
          val2 += this.buildTextValNode(jObj[key], key, "", level);
        } else if (typeof jObj[key] !== "object") {
          const attr = this.isAttribute(key);
          if (attr) {
            attrStr += this.buildAttrPairStr(attr, "" + jObj[key]);
          } else {
            if (key === this.options.textNodeName) {
              let newval = this.options.tagValueProcessor(key, "" + jObj[key]);
              val2 += this.replaceEntitiesValue(newval);
            } else {
              val2 += this.buildTextValNode(jObj[key], key, "", level);
            }
          }
        } else if (Array.isArray(jObj[key])) {
          const arrLen = jObj[key].length;
          let listTagVal = "";
          for (let j = 0; j < arrLen; j++) {
            const item = jObj[key][j];
            if (typeof item === "undefined") {
            } else if (item === null) {
              if (key[0] === "?") val2 += this.indentate(level) + "<" + key + "?" + this.tagEndChar;
              else val2 += this.indentate(level) + "<" + key + "/" + this.tagEndChar;
            } else if (typeof item === "object") {
              if (this.options.oneListGroup) {
                listTagVal += this.j2x(item, level + 1).val;
              } else {
                listTagVal += this.processTextOrObjNode(item, key, level);
              }
            } else {
              listTagVal += this.buildTextValNode(item, key, "", level);
            }
          }
          if (this.options.oneListGroup) {
            listTagVal = this.buildObjectNode(listTagVal, key, "", level);
          }
          val2 += listTagVal;
        } else {
          if (this.options.attributesGroupName && key === this.options.attributesGroupName) {
            const Ks = Object.keys(jObj[key]);
            const L = Ks.length;
            for (let j = 0; j < L; j++) {
              attrStr += this.buildAttrPairStr(Ks[j], "" + jObj[key][Ks[j]]);
            }
          } else {
            val2 += this.processTextOrObjNode(jObj[key], key, level);
          }
        }
      }
      return { attrStr, val: val2 };
    };
    Builder.prototype.buildAttrPairStr = function(attrName, val2) {
      val2 = this.options.attributeValueProcessor(attrName, "" + val2);
      val2 = this.replaceEntitiesValue(val2);
      if (this.options.suppressBooleanAttributes && val2 === "true") {
        return " " + attrName;
      } else return " " + attrName + '="' + val2 + '"';
    };
    function processTextOrObjNode(object, key, level) {
      const result = this.j2x(object, level + 1);
      if (object[this.options.textNodeName] !== void 0 && Object.keys(object).length === 1) {
        return this.buildTextValNode(object[this.options.textNodeName], key, result.attrStr, level);
      } else {
        return this.buildObjectNode(result.val, key, result.attrStr, level);
      }
    }
    Builder.prototype.buildObjectNode = function(val2, key, attrStr, level) {
      if (val2 === "") {
        if (key[0] === "?") return this.indentate(level) + "<" + key + attrStr + "?" + this.tagEndChar;
        else {
          return this.indentate(level) + "<" + key + attrStr + this.closeTag(key) + this.tagEndChar;
        }
      } else {
        let tagEndExp = "</" + key + this.tagEndChar;
        let piClosingChar = "";
        if (key[0] === "?") {
          piClosingChar = "?";
          tagEndExp = "";
        }
        if (attrStr && val2.indexOf("<") === -1) {
          return this.indentate(level) + "<" + key + attrStr + piClosingChar + ">" + val2 + tagEndExp;
        } else if (this.options.commentPropName !== false && key === this.options.commentPropName && piClosingChar.length === 0) {
          return this.indentate(level) + `<!--${val2}-->` + this.newLine;
        } else {
          return this.indentate(level) + "<" + key + attrStr + piClosingChar + this.tagEndChar + val2 + this.indentate(level) + tagEndExp;
        }
      }
    };
    Builder.prototype.closeTag = function(key) {
      let closeTag = "";
      if (this.options.unpairedTags.indexOf(key) !== -1) {
        if (!this.options.suppressUnpairedNode) closeTag = "/";
      } else if (this.options.suppressEmptyNode) {
        closeTag = "/";
      } else {
        closeTag = `></${key}`;
      }
      return closeTag;
    };
    Builder.prototype.buildTextValNode = function(val2, key, attrStr, level) {
      if (this.options.cdataPropName !== false && key === this.options.cdataPropName) {
        return this.indentate(level) + `<![CDATA[${val2}]]>` + this.newLine;
      } else if (this.options.commentPropName !== false && key === this.options.commentPropName) {
        return this.indentate(level) + `<!--${val2}-->` + this.newLine;
      } else if (key[0] === "?") {
        return this.indentate(level) + "<" + key + attrStr + "?" + this.tagEndChar;
      } else {
        let textValue = this.options.tagValueProcessor(key, val2);
        textValue = this.replaceEntitiesValue(textValue);
        if (textValue === "") {
          return this.indentate(level) + "<" + key + attrStr + this.closeTag(key) + this.tagEndChar;
        } else {
          return this.indentate(level) + "<" + key + attrStr + ">" + textValue + "</" + key + this.tagEndChar;
        }
      }
    };
    Builder.prototype.replaceEntitiesValue = function(textValue) {
      if (textValue && textValue.length > 0 && this.options.processEntities) {
        for (let i = 0; i < this.options.entities.length; i++) {
          const entity = this.options.entities[i];
          textValue = textValue.replace(entity.regex, entity.val);
        }
      }
      return textValue;
    };
    function indentate(level) {
      return this.options.indentBy.repeat(level);
    }
    function isAttribute(name) {
      if (name.startsWith(this.options.attributeNamePrefix)) {
        return name.substr(this.attrPrefixLen);
      } else {
        return false;
      }
    }
    module2.exports = Builder;
  }
});

// ../../../node_modules/fast-xml-parser/src/fxp.js
var require_fxp = __commonJS({
  "../../../node_modules/fast-xml-parser/src/fxp.js"(exports2, module2) {
    "use strict";
    var validator = require_validator();
    var XMLParser = require_XMLParser();
    var XMLBuilder = require_json2xml();
    module2.exports = {
      XMLParser,
      XMLValidator: validator,
      XMLBuilder
    };
  }
});

// ../../../node_modules/@aws-sdk/client-sts/dist-cjs/protocols/Aws_query.js
var require_Aws_query = __commonJS({
  "../../../node_modules/@aws-sdk/client-sts/dist-cjs/protocols/Aws_query.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.de_GetSessionTokenCommand = exports2.de_GetFederationTokenCommand = exports2.de_GetCallerIdentityCommand = exports2.de_GetAccessKeyInfoCommand = exports2.de_DecodeAuthorizationMessageCommand = exports2.de_AssumeRoleWithWebIdentityCommand = exports2.de_AssumeRoleWithSAMLCommand = exports2.de_AssumeRoleCommand = exports2.se_GetSessionTokenCommand = exports2.se_GetFederationTokenCommand = exports2.se_GetCallerIdentityCommand = exports2.se_GetAccessKeyInfoCommand = exports2.se_DecodeAuthorizationMessageCommand = exports2.se_AssumeRoleWithWebIdentityCommand = exports2.se_AssumeRoleWithSAMLCommand = exports2.se_AssumeRoleCommand = void 0;
    var protocol_http_1 = require_dist_cjs2();
    var smithy_client_1 = require_dist_cjs34();
    var fast_xml_parser_1 = require_fxp();
    var models_0_1 = require_models_0();
    var STSServiceException_1 = require_STSServiceException();
    var se_AssumeRoleCommand = async (input, context) => {
      const headers = SHARED_HEADERS;
      let body;
      body = buildFormUrlencodedString({
        ...se_AssumeRoleRequest(input, context),
        Action: "AssumeRole",
        Version: "2011-06-15"
      });
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_AssumeRoleCommand = se_AssumeRoleCommand;
    var se_AssumeRoleWithSAMLCommand = async (input, context) => {
      const headers = SHARED_HEADERS;
      let body;
      body = buildFormUrlencodedString({
        ...se_AssumeRoleWithSAMLRequest(input, context),
        Action: "AssumeRoleWithSAML",
        Version: "2011-06-15"
      });
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_AssumeRoleWithSAMLCommand = se_AssumeRoleWithSAMLCommand;
    var se_AssumeRoleWithWebIdentityCommand = async (input, context) => {
      const headers = SHARED_HEADERS;
      let body;
      body = buildFormUrlencodedString({
        ...se_AssumeRoleWithWebIdentityRequest(input, context),
        Action: "AssumeRoleWithWebIdentity",
        Version: "2011-06-15"
      });
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_AssumeRoleWithWebIdentityCommand = se_AssumeRoleWithWebIdentityCommand;
    var se_DecodeAuthorizationMessageCommand = async (input, context) => {
      const headers = SHARED_HEADERS;
      let body;
      body = buildFormUrlencodedString({
        ...se_DecodeAuthorizationMessageRequest(input, context),
        Action: "DecodeAuthorizationMessage",
        Version: "2011-06-15"
      });
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_DecodeAuthorizationMessageCommand = se_DecodeAuthorizationMessageCommand;
    var se_GetAccessKeyInfoCommand = async (input, context) => {
      const headers = SHARED_HEADERS;
      let body;
      body = buildFormUrlencodedString({
        ...se_GetAccessKeyInfoRequest(input, context),
        Action: "GetAccessKeyInfo",
        Version: "2011-06-15"
      });
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_GetAccessKeyInfoCommand = se_GetAccessKeyInfoCommand;
    var se_GetCallerIdentityCommand = async (input, context) => {
      const headers = SHARED_HEADERS;
      let body;
      body = buildFormUrlencodedString({
        ...se_GetCallerIdentityRequest(input, context),
        Action: "GetCallerIdentity",
        Version: "2011-06-15"
      });
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_GetCallerIdentityCommand = se_GetCallerIdentityCommand;
    var se_GetFederationTokenCommand = async (input, context) => {
      const headers = SHARED_HEADERS;
      let body;
      body = buildFormUrlencodedString({
        ...se_GetFederationTokenRequest(input, context),
        Action: "GetFederationToken",
        Version: "2011-06-15"
      });
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_GetFederationTokenCommand = se_GetFederationTokenCommand;
    var se_GetSessionTokenCommand = async (input, context) => {
      const headers = SHARED_HEADERS;
      let body;
      body = buildFormUrlencodedString({
        ...se_GetSessionTokenRequest(input, context),
        Action: "GetSessionToken",
        Version: "2011-06-15"
      });
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_GetSessionTokenCommand = se_GetSessionTokenCommand;
    var de_AssumeRoleCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_AssumeRoleCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_AssumeRoleResponse(data.AssumeRoleResult, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_AssumeRoleCommand = de_AssumeRoleCommand;
    var de_AssumeRoleCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadQueryErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "ExpiredTokenException":
        case "com.amazonaws.sts#ExpiredTokenException":
          throw await de_ExpiredTokenExceptionRes(parsedOutput, context);
        case "MalformedPolicyDocument":
        case "com.amazonaws.sts#MalformedPolicyDocumentException":
          throw await de_MalformedPolicyDocumentExceptionRes(parsedOutput, context);
        case "PackedPolicyTooLarge":
        case "com.amazonaws.sts#PackedPolicyTooLargeException":
          throw await de_PackedPolicyTooLargeExceptionRes(parsedOutput, context);
        case "RegionDisabledException":
        case "com.amazonaws.sts#RegionDisabledException":
          throw await de_RegionDisabledExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody: parsedBody.Error,
            errorCode
          });
      }
    };
    var de_AssumeRoleWithSAMLCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_AssumeRoleWithSAMLCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_AssumeRoleWithSAMLResponse(data.AssumeRoleWithSAMLResult, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_AssumeRoleWithSAMLCommand = de_AssumeRoleWithSAMLCommand;
    var de_AssumeRoleWithSAMLCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadQueryErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "ExpiredTokenException":
        case "com.amazonaws.sts#ExpiredTokenException":
          throw await de_ExpiredTokenExceptionRes(parsedOutput, context);
        case "IDPRejectedClaim":
        case "com.amazonaws.sts#IDPRejectedClaimException":
          throw await de_IDPRejectedClaimExceptionRes(parsedOutput, context);
        case "InvalidIdentityToken":
        case "com.amazonaws.sts#InvalidIdentityTokenException":
          throw await de_InvalidIdentityTokenExceptionRes(parsedOutput, context);
        case "MalformedPolicyDocument":
        case "com.amazonaws.sts#MalformedPolicyDocumentException":
          throw await de_MalformedPolicyDocumentExceptionRes(parsedOutput, context);
        case "PackedPolicyTooLarge":
        case "com.amazonaws.sts#PackedPolicyTooLargeException":
          throw await de_PackedPolicyTooLargeExceptionRes(parsedOutput, context);
        case "RegionDisabledException":
        case "com.amazonaws.sts#RegionDisabledException":
          throw await de_RegionDisabledExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody: parsedBody.Error,
            errorCode
          });
      }
    };
    var de_AssumeRoleWithWebIdentityCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_AssumeRoleWithWebIdentityCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_AssumeRoleWithWebIdentityResponse(data.AssumeRoleWithWebIdentityResult, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_AssumeRoleWithWebIdentityCommand = de_AssumeRoleWithWebIdentityCommand;
    var de_AssumeRoleWithWebIdentityCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadQueryErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "ExpiredTokenException":
        case "com.amazonaws.sts#ExpiredTokenException":
          throw await de_ExpiredTokenExceptionRes(parsedOutput, context);
        case "IDPCommunicationError":
        case "com.amazonaws.sts#IDPCommunicationErrorException":
          throw await de_IDPCommunicationErrorExceptionRes(parsedOutput, context);
        case "IDPRejectedClaim":
        case "com.amazonaws.sts#IDPRejectedClaimException":
          throw await de_IDPRejectedClaimExceptionRes(parsedOutput, context);
        case "InvalidIdentityToken":
        case "com.amazonaws.sts#InvalidIdentityTokenException":
          throw await de_InvalidIdentityTokenExceptionRes(parsedOutput, context);
        case "MalformedPolicyDocument":
        case "com.amazonaws.sts#MalformedPolicyDocumentException":
          throw await de_MalformedPolicyDocumentExceptionRes(parsedOutput, context);
        case "PackedPolicyTooLarge":
        case "com.amazonaws.sts#PackedPolicyTooLargeException":
          throw await de_PackedPolicyTooLargeExceptionRes(parsedOutput, context);
        case "RegionDisabledException":
        case "com.amazonaws.sts#RegionDisabledException":
          throw await de_RegionDisabledExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody: parsedBody.Error,
            errorCode
          });
      }
    };
    var de_DecodeAuthorizationMessageCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_DecodeAuthorizationMessageCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_DecodeAuthorizationMessageResponse(data.DecodeAuthorizationMessageResult, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_DecodeAuthorizationMessageCommand = de_DecodeAuthorizationMessageCommand;
    var de_DecodeAuthorizationMessageCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadQueryErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "InvalidAuthorizationMessageException":
        case "com.amazonaws.sts#InvalidAuthorizationMessageException":
          throw await de_InvalidAuthorizationMessageExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody: parsedBody.Error,
            errorCode
          });
      }
    };
    var de_GetAccessKeyInfoCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_GetAccessKeyInfoCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_GetAccessKeyInfoResponse(data.GetAccessKeyInfoResult, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_GetAccessKeyInfoCommand = de_GetAccessKeyInfoCommand;
    var de_GetAccessKeyInfoCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadQueryErrorCode(output, parsedOutput.body);
      const parsedBody = parsedOutput.body;
      return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode
      });
    };
    var de_GetCallerIdentityCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_GetCallerIdentityCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_GetCallerIdentityResponse(data.GetCallerIdentityResult, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_GetCallerIdentityCommand = de_GetCallerIdentityCommand;
    var de_GetCallerIdentityCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadQueryErrorCode(output, parsedOutput.body);
      const parsedBody = parsedOutput.body;
      return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode
      });
    };
    var de_GetFederationTokenCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_GetFederationTokenCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_GetFederationTokenResponse(data.GetFederationTokenResult, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_GetFederationTokenCommand = de_GetFederationTokenCommand;
    var de_GetFederationTokenCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadQueryErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "MalformedPolicyDocument":
        case "com.amazonaws.sts#MalformedPolicyDocumentException":
          throw await de_MalformedPolicyDocumentExceptionRes(parsedOutput, context);
        case "PackedPolicyTooLarge":
        case "com.amazonaws.sts#PackedPolicyTooLargeException":
          throw await de_PackedPolicyTooLargeExceptionRes(parsedOutput, context);
        case "RegionDisabledException":
        case "com.amazonaws.sts#RegionDisabledException":
          throw await de_RegionDisabledExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody: parsedBody.Error,
            errorCode
          });
      }
    };
    var de_GetSessionTokenCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_GetSessionTokenCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_GetSessionTokenResponse(data.GetSessionTokenResult, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_GetSessionTokenCommand = de_GetSessionTokenCommand;
    var de_GetSessionTokenCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadQueryErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "RegionDisabledException":
        case "com.amazonaws.sts#RegionDisabledException":
          throw await de_RegionDisabledExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody: parsedBody.Error,
            errorCode
          });
      }
    };
    var de_ExpiredTokenExceptionRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = de_ExpiredTokenException(body.Error, context);
      const exception = new models_0_1.ExpiredTokenException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_IDPCommunicationErrorExceptionRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = de_IDPCommunicationErrorException(body.Error, context);
      const exception = new models_0_1.IDPCommunicationErrorException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_IDPRejectedClaimExceptionRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = de_IDPRejectedClaimException(body.Error, context);
      const exception = new models_0_1.IDPRejectedClaimException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_InvalidAuthorizationMessageExceptionRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = de_InvalidAuthorizationMessageException(body.Error, context);
      const exception = new models_0_1.InvalidAuthorizationMessageException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_InvalidIdentityTokenExceptionRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = de_InvalidIdentityTokenException(body.Error, context);
      const exception = new models_0_1.InvalidIdentityTokenException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_MalformedPolicyDocumentExceptionRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = de_MalformedPolicyDocumentException(body.Error, context);
      const exception = new models_0_1.MalformedPolicyDocumentException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_PackedPolicyTooLargeExceptionRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = de_PackedPolicyTooLargeException(body.Error, context);
      const exception = new models_0_1.PackedPolicyTooLargeException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_RegionDisabledExceptionRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = de_RegionDisabledException(body.Error, context);
      const exception = new models_0_1.RegionDisabledException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var se_AssumeRoleRequest = (input, context) => {
      const entries = {};
      if (input.RoleArn != null) {
        entries["RoleArn"] = input.RoleArn;
      }
      if (input.RoleSessionName != null) {
        entries["RoleSessionName"] = input.RoleSessionName;
      }
      if (input.PolicyArns != null) {
        const memberEntries = se_policyDescriptorListType(input.PolicyArns, context);
        if (input.PolicyArns?.length === 0) {
          entries.PolicyArns = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
          const loc = `PolicyArns.${key}`;
          entries[loc] = value;
        });
      }
      if (input.Policy != null) {
        entries["Policy"] = input.Policy;
      }
      if (input.DurationSeconds != null) {
        entries["DurationSeconds"] = input.DurationSeconds;
      }
      if (input.Tags != null) {
        const memberEntries = se_tagListType(input.Tags, context);
        if (input.Tags?.length === 0) {
          entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
          const loc = `Tags.${key}`;
          entries[loc] = value;
        });
      }
      if (input.TransitiveTagKeys != null) {
        const memberEntries = se_tagKeyListType(input.TransitiveTagKeys, context);
        if (input.TransitiveTagKeys?.length === 0) {
          entries.TransitiveTagKeys = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
          const loc = `TransitiveTagKeys.${key}`;
          entries[loc] = value;
        });
      }
      if (input.ExternalId != null) {
        entries["ExternalId"] = input.ExternalId;
      }
      if (input.SerialNumber != null) {
        entries["SerialNumber"] = input.SerialNumber;
      }
      if (input.TokenCode != null) {
        entries["TokenCode"] = input.TokenCode;
      }
      if (input.SourceIdentity != null) {
        entries["SourceIdentity"] = input.SourceIdentity;
      }
      if (input.ProvidedContexts != null) {
        const memberEntries = se_ProvidedContextsListType(input.ProvidedContexts, context);
        if (input.ProvidedContexts?.length === 0) {
          entries.ProvidedContexts = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
          const loc = `ProvidedContexts.${key}`;
          entries[loc] = value;
        });
      }
      return entries;
    };
    var se_AssumeRoleWithSAMLRequest = (input, context) => {
      const entries = {};
      if (input.RoleArn != null) {
        entries["RoleArn"] = input.RoleArn;
      }
      if (input.PrincipalArn != null) {
        entries["PrincipalArn"] = input.PrincipalArn;
      }
      if (input.SAMLAssertion != null) {
        entries["SAMLAssertion"] = input.SAMLAssertion;
      }
      if (input.PolicyArns != null) {
        const memberEntries = se_policyDescriptorListType(input.PolicyArns, context);
        if (input.PolicyArns?.length === 0) {
          entries.PolicyArns = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
          const loc = `PolicyArns.${key}`;
          entries[loc] = value;
        });
      }
      if (input.Policy != null) {
        entries["Policy"] = input.Policy;
      }
      if (input.DurationSeconds != null) {
        entries["DurationSeconds"] = input.DurationSeconds;
      }
      return entries;
    };
    var se_AssumeRoleWithWebIdentityRequest = (input, context) => {
      const entries = {};
      if (input.RoleArn != null) {
        entries["RoleArn"] = input.RoleArn;
      }
      if (input.RoleSessionName != null) {
        entries["RoleSessionName"] = input.RoleSessionName;
      }
      if (input.WebIdentityToken != null) {
        entries["WebIdentityToken"] = input.WebIdentityToken;
      }
      if (input.ProviderId != null) {
        entries["ProviderId"] = input.ProviderId;
      }
      if (input.PolicyArns != null) {
        const memberEntries = se_policyDescriptorListType(input.PolicyArns, context);
        if (input.PolicyArns?.length === 0) {
          entries.PolicyArns = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
          const loc = `PolicyArns.${key}`;
          entries[loc] = value;
        });
      }
      if (input.Policy != null) {
        entries["Policy"] = input.Policy;
      }
      if (input.DurationSeconds != null) {
        entries["DurationSeconds"] = input.DurationSeconds;
      }
      return entries;
    };
    var se_DecodeAuthorizationMessageRequest = (input, context) => {
      const entries = {};
      if (input.EncodedMessage != null) {
        entries["EncodedMessage"] = input.EncodedMessage;
      }
      return entries;
    };
    var se_GetAccessKeyInfoRequest = (input, context) => {
      const entries = {};
      if (input.AccessKeyId != null) {
        entries["AccessKeyId"] = input.AccessKeyId;
      }
      return entries;
    };
    var se_GetCallerIdentityRequest = (input, context) => {
      const entries = {};
      return entries;
    };
    var se_GetFederationTokenRequest = (input, context) => {
      const entries = {};
      if (input.Name != null) {
        entries["Name"] = input.Name;
      }
      if (input.Policy != null) {
        entries["Policy"] = input.Policy;
      }
      if (input.PolicyArns != null) {
        const memberEntries = se_policyDescriptorListType(input.PolicyArns, context);
        if (input.PolicyArns?.length === 0) {
          entries.PolicyArns = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
          const loc = `PolicyArns.${key}`;
          entries[loc] = value;
        });
      }
      if (input.DurationSeconds != null) {
        entries["DurationSeconds"] = input.DurationSeconds;
      }
      if (input.Tags != null) {
        const memberEntries = se_tagListType(input.Tags, context);
        if (input.Tags?.length === 0) {
          entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
          const loc = `Tags.${key}`;
          entries[loc] = value;
        });
      }
      return entries;
    };
    var se_GetSessionTokenRequest = (input, context) => {
      const entries = {};
      if (input.DurationSeconds != null) {
        entries["DurationSeconds"] = input.DurationSeconds;
      }
      if (input.SerialNumber != null) {
        entries["SerialNumber"] = input.SerialNumber;
      }
      if (input.TokenCode != null) {
        entries["TokenCode"] = input.TokenCode;
      }
      return entries;
    };
    var se_policyDescriptorListType = (input, context) => {
      const entries = {};
      let counter = 1;
      for (const entry of input) {
        if (entry === null) {
          continue;
        }
        const memberEntries = se_PolicyDescriptorType(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
          entries[`member.${counter}.${key}`] = value;
        });
        counter++;
      }
      return entries;
    };
    var se_PolicyDescriptorType = (input, context) => {
      const entries = {};
      if (input.arn != null) {
        entries["arn"] = input.arn;
      }
      return entries;
    };
    var se_ProvidedContext = (input, context) => {
      const entries = {};
      if (input.ProviderArn != null) {
        entries["ProviderArn"] = input.ProviderArn;
      }
      if (input.ContextAssertion != null) {
        entries["ContextAssertion"] = input.ContextAssertion;
      }
      return entries;
    };
    var se_ProvidedContextsListType = (input, context) => {
      const entries = {};
      let counter = 1;
      for (const entry of input) {
        if (entry === null) {
          continue;
        }
        const memberEntries = se_ProvidedContext(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
          entries[`member.${counter}.${key}`] = value;
        });
        counter++;
      }
      return entries;
    };
    var se_Tag = (input, context) => {
      const entries = {};
      if (input.Key != null) {
        entries["Key"] = input.Key;
      }
      if (input.Value != null) {
        entries["Value"] = input.Value;
      }
      return entries;
    };
    var se_tagKeyListType = (input, context) => {
      const entries = {};
      let counter = 1;
      for (const entry of input) {
        if (entry === null) {
          continue;
        }
        entries[`member.${counter}`] = entry;
        counter++;
      }
      return entries;
    };
    var se_tagListType = (input, context) => {
      const entries = {};
      let counter = 1;
      for (const entry of input) {
        if (entry === null) {
          continue;
        }
        const memberEntries = se_Tag(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
          entries[`member.${counter}.${key}`] = value;
        });
        counter++;
      }
      return entries;
    };
    var de_AssumedRoleUser = (output, context) => {
      const contents = {};
      if (output["AssumedRoleId"] !== void 0) {
        contents.AssumedRoleId = (0, smithy_client_1.expectString)(output["AssumedRoleId"]);
      }
      if (output["Arn"] !== void 0) {
        contents.Arn = (0, smithy_client_1.expectString)(output["Arn"]);
      }
      return contents;
    };
    var de_AssumeRoleResponse = (output, context) => {
      const contents = {};
      if (output["Credentials"] !== void 0) {
        contents.Credentials = de_Credentials(output["Credentials"], context);
      }
      if (output["AssumedRoleUser"] !== void 0) {
        contents.AssumedRoleUser = de_AssumedRoleUser(output["AssumedRoleUser"], context);
      }
      if (output["PackedPolicySize"] !== void 0) {
        contents.PackedPolicySize = (0, smithy_client_1.strictParseInt32)(output["PackedPolicySize"]);
      }
      if (output["SourceIdentity"] !== void 0) {
        contents.SourceIdentity = (0, smithy_client_1.expectString)(output["SourceIdentity"]);
      }
      return contents;
    };
    var de_AssumeRoleWithSAMLResponse = (output, context) => {
      const contents = {};
      if (output["Credentials"] !== void 0) {
        contents.Credentials = de_Credentials(output["Credentials"], context);
      }
      if (output["AssumedRoleUser"] !== void 0) {
        contents.AssumedRoleUser = de_AssumedRoleUser(output["AssumedRoleUser"], context);
      }
      if (output["PackedPolicySize"] !== void 0) {
        contents.PackedPolicySize = (0, smithy_client_1.strictParseInt32)(output["PackedPolicySize"]);
      }
      if (output["Subject"] !== void 0) {
        contents.Subject = (0, smithy_client_1.expectString)(output["Subject"]);
      }
      if (output["SubjectType"] !== void 0) {
        contents.SubjectType = (0, smithy_client_1.expectString)(output["SubjectType"]);
      }
      if (output["Issuer"] !== void 0) {
        contents.Issuer = (0, smithy_client_1.expectString)(output["Issuer"]);
      }
      if (output["Audience"] !== void 0) {
        contents.Audience = (0, smithy_client_1.expectString)(output["Audience"]);
      }
      if (output["NameQualifier"] !== void 0) {
        contents.NameQualifier = (0, smithy_client_1.expectString)(output["NameQualifier"]);
      }
      if (output["SourceIdentity"] !== void 0) {
        contents.SourceIdentity = (0, smithy_client_1.expectString)(output["SourceIdentity"]);
      }
      return contents;
    };
    var de_AssumeRoleWithWebIdentityResponse = (output, context) => {
      const contents = {};
      if (output["Credentials"] !== void 0) {
        contents.Credentials = de_Credentials(output["Credentials"], context);
      }
      if (output["SubjectFromWebIdentityToken"] !== void 0) {
        contents.SubjectFromWebIdentityToken = (0, smithy_client_1.expectString)(output["SubjectFromWebIdentityToken"]);
      }
      if (output["AssumedRoleUser"] !== void 0) {
        contents.AssumedRoleUser = de_AssumedRoleUser(output["AssumedRoleUser"], context);
      }
      if (output["PackedPolicySize"] !== void 0) {
        contents.PackedPolicySize = (0, smithy_client_1.strictParseInt32)(output["PackedPolicySize"]);
      }
      if (output["Provider"] !== void 0) {
        contents.Provider = (0, smithy_client_1.expectString)(output["Provider"]);
      }
      if (output["Audience"] !== void 0) {
        contents.Audience = (0, smithy_client_1.expectString)(output["Audience"]);
      }
      if (output["SourceIdentity"] !== void 0) {
        contents.SourceIdentity = (0, smithy_client_1.expectString)(output["SourceIdentity"]);
      }
      return contents;
    };
    var de_Credentials = (output, context) => {
      const contents = {};
      if (output["AccessKeyId"] !== void 0) {
        contents.AccessKeyId = (0, smithy_client_1.expectString)(output["AccessKeyId"]);
      }
      if (output["SecretAccessKey"] !== void 0) {
        contents.SecretAccessKey = (0, smithy_client_1.expectString)(output["SecretAccessKey"]);
      }
      if (output["SessionToken"] !== void 0) {
        contents.SessionToken = (0, smithy_client_1.expectString)(output["SessionToken"]);
      }
      if (output["Expiration"] !== void 0) {
        contents.Expiration = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseRfc3339DateTimeWithOffset)(output["Expiration"]));
      }
      return contents;
    };
    var de_DecodeAuthorizationMessageResponse = (output, context) => {
      const contents = {};
      if (output["DecodedMessage"] !== void 0) {
        contents.DecodedMessage = (0, smithy_client_1.expectString)(output["DecodedMessage"]);
      }
      return contents;
    };
    var de_ExpiredTokenException = (output, context) => {
      const contents = {};
      if (output["message"] !== void 0) {
        contents.message = (0, smithy_client_1.expectString)(output["message"]);
      }
      return contents;
    };
    var de_FederatedUser = (output, context) => {
      const contents = {};
      if (output["FederatedUserId"] !== void 0) {
        contents.FederatedUserId = (0, smithy_client_1.expectString)(output["FederatedUserId"]);
      }
      if (output["Arn"] !== void 0) {
        contents.Arn = (0, smithy_client_1.expectString)(output["Arn"]);
      }
      return contents;
    };
    var de_GetAccessKeyInfoResponse = (output, context) => {
      const contents = {};
      if (output["Account"] !== void 0) {
        contents.Account = (0, smithy_client_1.expectString)(output["Account"]);
      }
      return contents;
    };
    var de_GetCallerIdentityResponse = (output, context) => {
      const contents = {};
      if (output["UserId"] !== void 0) {
        contents.UserId = (0, smithy_client_1.expectString)(output["UserId"]);
      }
      if (output["Account"] !== void 0) {
        contents.Account = (0, smithy_client_1.expectString)(output["Account"]);
      }
      if (output["Arn"] !== void 0) {
        contents.Arn = (0, smithy_client_1.expectString)(output["Arn"]);
      }
      return contents;
    };
    var de_GetFederationTokenResponse = (output, context) => {
      const contents = {};
      if (output["Credentials"] !== void 0) {
        contents.Credentials = de_Credentials(output["Credentials"], context);
      }
      if (output["FederatedUser"] !== void 0) {
        contents.FederatedUser = de_FederatedUser(output["FederatedUser"], context);
      }
      if (output["PackedPolicySize"] !== void 0) {
        contents.PackedPolicySize = (0, smithy_client_1.strictParseInt32)(output["PackedPolicySize"]);
      }
      return contents;
    };
    var de_GetSessionTokenResponse = (output, context) => {
      const contents = {};
      if (output["Credentials"] !== void 0) {
        contents.Credentials = de_Credentials(output["Credentials"], context);
      }
      return contents;
    };
    var de_IDPCommunicationErrorException = (output, context) => {
      const contents = {};
      if (output["message"] !== void 0) {
        contents.message = (0, smithy_client_1.expectString)(output["message"]);
      }
      return contents;
    };
    var de_IDPRejectedClaimException = (output, context) => {
      const contents = {};
      if (output["message"] !== void 0) {
        contents.message = (0, smithy_client_1.expectString)(output["message"]);
      }
      return contents;
    };
    var de_InvalidAuthorizationMessageException = (output, context) => {
      const contents = {};
      if (output["message"] !== void 0) {
        contents.message = (0, smithy_client_1.expectString)(output["message"]);
      }
      return contents;
    };
    var de_InvalidIdentityTokenException = (output, context) => {
      const contents = {};
      if (output["message"] !== void 0) {
        contents.message = (0, smithy_client_1.expectString)(output["message"]);
      }
      return contents;
    };
    var de_MalformedPolicyDocumentException = (output, context) => {
      const contents = {};
      if (output["message"] !== void 0) {
        contents.message = (0, smithy_client_1.expectString)(output["message"]);
      }
      return contents;
    };
    var de_PackedPolicyTooLargeException = (output, context) => {
      const contents = {};
      if (output["message"] !== void 0) {
        contents.message = (0, smithy_client_1.expectString)(output["message"]);
      }
      return contents;
    };
    var de_RegionDisabledException = (output, context) => {
      const contents = {};
      if (output["message"] !== void 0) {
        contents.message = (0, smithy_client_1.expectString)(output["message"]);
      }
      return contents;
    };
    var deserializeMetadata = (output) => ({
      httpStatusCode: output.statusCode,
      requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
      extendedRequestId: output.headers["x-amz-id-2"],
      cfId: output.headers["x-amz-cf-id"]
    });
    var collectBodyString = (streamBody, context) => (0, smithy_client_1.collectBody)(streamBody, context).then((body) => context.utf8Encoder(body));
    var throwDefaultError = (0, smithy_client_1.withBaseException)(STSServiceException_1.STSServiceException);
    var buildHttpRpcRequest = async (context, headers, path, resolvedHostname, body) => {
      const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
      const contents = {
        protocol,
        hostname,
        port,
        method: "POST",
        path: basePath.endsWith("/") ? basePath.slice(0, -1) + path : basePath + path,
        headers
      };
      if (resolvedHostname !== void 0) {
        contents.hostname = resolvedHostname;
      }
      if (body !== void 0) {
        contents.body = body;
      }
      return new protocol_http_1.HttpRequest(contents);
    };
    var SHARED_HEADERS = {
      "content-type": "application/x-www-form-urlencoded"
    };
    var parseBody = (streamBody, context) => collectBodyString(streamBody, context).then((encoded) => {
      if (encoded.length) {
        const parser = new fast_xml_parser_1.XMLParser({
          attributeNamePrefix: "",
          htmlEntities: true,
          ignoreAttributes: false,
          ignoreDeclaration: true,
          parseTagValue: false,
          trimValues: false,
          tagValueProcessor: (_, val2) => val2.trim() === "" && val2.includes("\n") ? "" : void 0
        });
        parser.addEntity("#xD", "\r");
        parser.addEntity("#10", "\n");
        const parsedObj = parser.parse(encoded);
        const textNodeName = "#text";
        const key = Object.keys(parsedObj)[0];
        const parsedObjToReturn = parsedObj[key];
        if (parsedObjToReturn[textNodeName]) {
          parsedObjToReturn[key] = parsedObjToReturn[textNodeName];
          delete parsedObjToReturn[textNodeName];
        }
        return (0, smithy_client_1.getValueFromTextNode)(parsedObjToReturn);
      }
      return {};
    });
    var parseErrorBody = async (errorBody, context) => {
      const value = await parseBody(errorBody, context);
      if (value.Error) {
        value.Error.message = value.Error.message ?? value.Error.Message;
      }
      return value;
    };
    var buildFormUrlencodedString = (formEntries) => Object.entries(formEntries).map(([key, value]) => (0, smithy_client_1.extendedEncodeURIComponent)(key) + "=" + (0, smithy_client_1.extendedEncodeURIComponent)(value)).join("&");
    var loadQueryErrorCode = (output, data) => {
      if (data.Error?.Code !== void 0) {
        return data.Error.Code;
      }
      if (output.statusCode == 404) {
        return "NotFound";
      }
    };
  }
});

// ../../../node_modules/@aws-sdk/client-sts/dist-cjs/commands/AssumeRoleCommand.js
var require_AssumeRoleCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sts/dist-cjs/commands/AssumeRoleCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.AssumeRoleCommand = exports2.$Command = void 0;
    var middleware_signing_1 = require_dist_cjs14();
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var models_0_1 = require_models_0();
    var Aws_query_1 = require_Aws_query();
    var AssumeRoleCommand = class _AssumeRoleCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseGlobalEndpoint: { type: "builtInParams", name: "useGlobalEndpoint" },
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _AssumeRoleCommand.getEndpointParameterInstructions()));
        this.middlewareStack.use((0, middleware_signing_1.getAwsAuthPlugin)(configuration));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "STSClient";
        const commandName = "AssumeRoleCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: models_0_1.AssumeRoleResponseFilterSensitiveLog,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSSecurityTokenServiceV20110615",
            operation: "AssumeRole"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_query_1.se_AssumeRoleCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_query_1.de_AssumeRoleCommand)(output, context);
      }
    };
    exports2.AssumeRoleCommand = AssumeRoleCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sts/dist-cjs/commands/AssumeRoleWithWebIdentityCommand.js
var require_AssumeRoleWithWebIdentityCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sts/dist-cjs/commands/AssumeRoleWithWebIdentityCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.AssumeRoleWithWebIdentityCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var models_0_1 = require_models_0();
    var Aws_query_1 = require_Aws_query();
    var AssumeRoleWithWebIdentityCommand = class _AssumeRoleWithWebIdentityCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseGlobalEndpoint: { type: "builtInParams", name: "useGlobalEndpoint" },
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _AssumeRoleWithWebIdentityCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "STSClient";
        const commandName = "AssumeRoleWithWebIdentityCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: models_0_1.AssumeRoleWithWebIdentityRequestFilterSensitiveLog,
          outputFilterSensitiveLog: models_0_1.AssumeRoleWithWebIdentityResponseFilterSensitiveLog,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSSecurityTokenServiceV20110615",
            operation: "AssumeRoleWithWebIdentity"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_query_1.se_AssumeRoleWithWebIdentityCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_query_1.de_AssumeRoleWithWebIdentityCommand)(output, context);
      }
    };
    exports2.AssumeRoleWithWebIdentityCommand = AssumeRoleWithWebIdentityCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sts/dist-cjs/defaultStsRoleAssumers.js
var require_defaultStsRoleAssumers = __commonJS({
  "../../../node_modules/@aws-sdk/client-sts/dist-cjs/defaultStsRoleAssumers.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.decorateDefaultCredentialProvider = exports2.getDefaultRoleAssumerWithWebIdentity = exports2.getDefaultRoleAssumer = void 0;
    var AssumeRoleCommand_1 = require_AssumeRoleCommand();
    var AssumeRoleWithWebIdentityCommand_1 = require_AssumeRoleWithWebIdentityCommand();
    var ASSUME_ROLE_DEFAULT_REGION = "us-east-1";
    var decorateDefaultRegion = (region) => {
      if (typeof region !== "function") {
        return region === void 0 ? ASSUME_ROLE_DEFAULT_REGION : region;
      }
      return async () => {
        try {
          return await region();
        } catch (e) {
          return ASSUME_ROLE_DEFAULT_REGION;
        }
      };
    };
    var getDefaultRoleAssumer = (stsOptions, stsClientCtor) => {
      let stsClient;
      let closureSourceCreds;
      return async (sourceCreds, params) => {
        closureSourceCreds = sourceCreds;
        if (!stsClient) {
          const { logger, region, requestHandler } = stsOptions;
          stsClient = new stsClientCtor({
            logger,
            credentialDefaultProvider: () => async () => closureSourceCreds,
            region: decorateDefaultRegion(region || stsOptions.region),
            ...requestHandler ? { requestHandler } : {}
          });
        }
        const { Credentials } = await stsClient.send(new AssumeRoleCommand_1.AssumeRoleCommand(params));
        if (!Credentials || !Credentials.AccessKeyId || !Credentials.SecretAccessKey) {
          throw new Error(`Invalid response from STS.assumeRole call with role ${params.RoleArn}`);
        }
        return {
          accessKeyId: Credentials.AccessKeyId,
          secretAccessKey: Credentials.SecretAccessKey,
          sessionToken: Credentials.SessionToken,
          expiration: Credentials.Expiration
        };
      };
    };
    exports2.getDefaultRoleAssumer = getDefaultRoleAssumer;
    var getDefaultRoleAssumerWithWebIdentity = (stsOptions, stsClientCtor) => {
      let stsClient;
      return async (params) => {
        if (!stsClient) {
          const { logger, region, requestHandler } = stsOptions;
          stsClient = new stsClientCtor({
            logger,
            region: decorateDefaultRegion(region || stsOptions.region),
            ...requestHandler ? { requestHandler } : {}
          });
        }
        const { Credentials } = await stsClient.send(new AssumeRoleWithWebIdentityCommand_1.AssumeRoleWithWebIdentityCommand(params));
        if (!Credentials || !Credentials.AccessKeyId || !Credentials.SecretAccessKey) {
          throw new Error(`Invalid response from STS.assumeRoleWithWebIdentity call with role ${params.RoleArn}`);
        }
        return {
          accessKeyId: Credentials.AccessKeyId,
          secretAccessKey: Credentials.SecretAccessKey,
          sessionToken: Credentials.SessionToken,
          expiration: Credentials.Expiration
        };
      };
    };
    exports2.getDefaultRoleAssumerWithWebIdentity = getDefaultRoleAssumerWithWebIdentity;
    var decorateDefaultCredentialProvider = (provider) => (input) => provider({
      roleAssumer: (0, exports2.getDefaultRoleAssumer)(input, input.stsClientCtor),
      roleAssumerWithWebIdentity: (0, exports2.getDefaultRoleAssumerWithWebIdentity)(input, input.stsClientCtor),
      ...input
    });
    exports2.decorateDefaultCredentialProvider = decorateDefaultCredentialProvider;
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-env/dist-cjs/fromEnv.js
var require_fromEnv = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-env/dist-cjs/fromEnv.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.fromEnv = exports2.ENV_EXPIRATION = exports2.ENV_SESSION = exports2.ENV_SECRET = exports2.ENV_KEY = void 0;
    var property_provider_1 = require_dist_cjs6();
    exports2.ENV_KEY = "AWS_ACCESS_KEY_ID";
    exports2.ENV_SECRET = "AWS_SECRET_ACCESS_KEY";
    exports2.ENV_SESSION = "AWS_SESSION_TOKEN";
    exports2.ENV_EXPIRATION = "AWS_CREDENTIAL_EXPIRATION";
    var fromEnv = () => async () => {
      const accessKeyId = process.env[exports2.ENV_KEY];
      const secretAccessKey = process.env[exports2.ENV_SECRET];
      const sessionToken = process.env[exports2.ENV_SESSION];
      const expiry = process.env[exports2.ENV_EXPIRATION];
      if (accessKeyId && secretAccessKey) {
        return {
          accessKeyId,
          secretAccessKey,
          ...sessionToken && { sessionToken },
          ...expiry && { expiration: new Date(expiry) }
        };
      }
      throw new property_provider_1.CredentialsProviderError("Unable to find environment variable credentials.");
    };
    exports2.fromEnv = fromEnv;
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-env/dist-cjs/index.js
var require_dist_cjs37 = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-env/dist-cjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_fromEnv(), exports2);
  }
});

// ../../../node_modules/@smithy/credential-provider-imds/dist-cjs/index.js
var require_dist_cjs38 = __commonJS({
  "../../../node_modules/@smithy/credential-provider-imds/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      DEFAULT_MAX_RETRIES: () => DEFAULT_MAX_RETRIES,
      DEFAULT_TIMEOUT: () => DEFAULT_TIMEOUT,
      ENV_CMDS_AUTH_TOKEN: () => ENV_CMDS_AUTH_TOKEN,
      ENV_CMDS_FULL_URI: () => ENV_CMDS_FULL_URI,
      ENV_CMDS_RELATIVE_URI: () => ENV_CMDS_RELATIVE_URI,
      Endpoint: () => Endpoint,
      fromContainerMetadata: () => fromContainerMetadata,
      fromInstanceMetadata: () => fromInstanceMetadata,
      getInstanceMetadataEndpoint: () => getInstanceMetadataEndpoint,
      httpRequest: () => httpRequest,
      providerConfigFromInit: () => providerConfigFromInit
    });
    module2.exports = __toCommonJS2(src_exports);
    var import_url = require("url");
    var import_property_provider = require_dist_cjs6();
    var import_buffer = require("buffer");
    var import_http2 = require("http");
    function httpRequest(options) {
      return new Promise((resolve, reject) => {
        var _a;
        const req = (0, import_http2.request)({
          method: "GET",
          ...options,
          // Node.js http module doesn't accept hostname with square brackets
          // Refs: https://github.com/nodejs/node/issues/39738
          hostname: (_a = options.hostname) == null ? void 0 : _a.replace(/^\[(.+)\]$/, "$1")
        });
        req.on("error", (err) => {
          reject(Object.assign(new import_property_provider.ProviderError("Unable to connect to instance metadata service"), err));
          req.destroy();
        });
        req.on("timeout", () => {
          reject(new import_property_provider.ProviderError("TimeoutError from instance metadata service"));
          req.destroy();
        });
        req.on("response", (res) => {
          const { statusCode = 400 } = res;
          if (statusCode < 200 || 300 <= statusCode) {
            reject(
              Object.assign(new import_property_provider.ProviderError("Error response received from instance metadata service"), { statusCode })
            );
            req.destroy();
          }
          const chunks = [];
          res.on("data", (chunk) => {
            chunks.push(chunk);
          });
          res.on("end", () => {
            resolve(import_buffer.Buffer.concat(chunks));
            req.destroy();
          });
        });
        req.end();
      });
    }
    __name(httpRequest, "httpRequest");
    var isImdsCredentials = /* @__PURE__ */ __name((arg) => Boolean(arg) && typeof arg === "object" && typeof arg.AccessKeyId === "string" && typeof arg.SecretAccessKey === "string" && typeof arg.Token === "string" && typeof arg.Expiration === "string", "isImdsCredentials");
    var fromImdsCredentials = /* @__PURE__ */ __name((creds) => ({
      accessKeyId: creds.AccessKeyId,
      secretAccessKey: creds.SecretAccessKey,
      sessionToken: creds.Token,
      expiration: new Date(creds.Expiration)
    }), "fromImdsCredentials");
    var DEFAULT_TIMEOUT = 1e3;
    var DEFAULT_MAX_RETRIES = 0;
    var providerConfigFromInit = /* @__PURE__ */ __name(({
      maxRetries = DEFAULT_MAX_RETRIES,
      timeout = DEFAULT_TIMEOUT
    }) => ({ maxRetries, timeout }), "providerConfigFromInit");
    var retry = /* @__PURE__ */ __name((toRetry, maxRetries) => {
      let promise = toRetry();
      for (let i = 0; i < maxRetries; i++) {
        promise = promise.catch(toRetry);
      }
      return promise;
    }, "retry");
    var ENV_CMDS_FULL_URI = "AWS_CONTAINER_CREDENTIALS_FULL_URI";
    var ENV_CMDS_RELATIVE_URI = "AWS_CONTAINER_CREDENTIALS_RELATIVE_URI";
    var ENV_CMDS_AUTH_TOKEN = "AWS_CONTAINER_AUTHORIZATION_TOKEN";
    var fromContainerMetadata = /* @__PURE__ */ __name((init = {}) => {
      const { timeout, maxRetries } = providerConfigFromInit(init);
      return () => retry(async () => {
        const requestOptions = await getCmdsUri();
        const credsResponse = JSON.parse(await requestFromEcsImds(timeout, requestOptions));
        if (!isImdsCredentials(credsResponse)) {
          throw new import_property_provider.CredentialsProviderError("Invalid response received from instance metadata service.");
        }
        return fromImdsCredentials(credsResponse);
      }, maxRetries);
    }, "fromContainerMetadata");
    var requestFromEcsImds = /* @__PURE__ */ __name(async (timeout, options) => {
      if (process.env[ENV_CMDS_AUTH_TOKEN]) {
        options.headers = {
          ...options.headers,
          Authorization: process.env[ENV_CMDS_AUTH_TOKEN]
        };
      }
      const buffer = await httpRequest({
        ...options,
        timeout
      });
      return buffer.toString();
    }, "requestFromEcsImds");
    var CMDS_IP = "169.254.170.2";
    var GREENGRASS_HOSTS = {
      localhost: true,
      "127.0.0.1": true
    };
    var GREENGRASS_PROTOCOLS = {
      "http:": true,
      "https:": true
    };
    var getCmdsUri = /* @__PURE__ */ __name(async () => {
      if (process.env[ENV_CMDS_RELATIVE_URI]) {
        return {
          hostname: CMDS_IP,
          path: process.env[ENV_CMDS_RELATIVE_URI]
        };
      }
      if (process.env[ENV_CMDS_FULL_URI]) {
        const parsed = (0, import_url.parse)(process.env[ENV_CMDS_FULL_URI]);
        if (!parsed.hostname || !(parsed.hostname in GREENGRASS_HOSTS)) {
          throw new import_property_provider.CredentialsProviderError(
            `${parsed.hostname} is not a valid container metadata service hostname`,
            false
          );
        }
        if (!parsed.protocol || !(parsed.protocol in GREENGRASS_PROTOCOLS)) {
          throw new import_property_provider.CredentialsProviderError(
            `${parsed.protocol} is not a valid container metadata service protocol`,
            false
          );
        }
        return {
          ...parsed,
          port: parsed.port ? parseInt(parsed.port, 10) : void 0
        };
      }
      throw new import_property_provider.CredentialsProviderError(
        `The container metadata credential provider cannot be used unless the ${ENV_CMDS_RELATIVE_URI} or ${ENV_CMDS_FULL_URI} environment variable is set`,
        false
      );
    }, "getCmdsUri");
    var _InstanceMetadataV1FallbackError = class _InstanceMetadataV1FallbackError2 extends import_property_provider.CredentialsProviderError {
      constructor(message, tryNextLink = true) {
        super(message, tryNextLink);
        this.tryNextLink = tryNextLink;
        this.name = "InstanceMetadataV1FallbackError";
        Object.setPrototypeOf(this, _InstanceMetadataV1FallbackError2.prototype);
      }
    };
    __name(_InstanceMetadataV1FallbackError, "InstanceMetadataV1FallbackError");
    var InstanceMetadataV1FallbackError = _InstanceMetadataV1FallbackError;
    var import_node_config_provider = require_dist_cjs22();
    var import_url_parser = require_dist_cjs24();
    var Endpoint = /* @__PURE__ */ ((Endpoint2) => {
      Endpoint2["IPv4"] = "http://169.254.169.254";
      Endpoint2["IPv6"] = "http://[fd00:ec2::254]";
      return Endpoint2;
    })(Endpoint || {});
    var ENV_ENDPOINT_NAME = "AWS_EC2_METADATA_SERVICE_ENDPOINT";
    var CONFIG_ENDPOINT_NAME = "ec2_metadata_service_endpoint";
    var ENDPOINT_CONFIG_OPTIONS = {
      environmentVariableSelector: (env) => env[ENV_ENDPOINT_NAME],
      configFileSelector: (profile) => profile[CONFIG_ENDPOINT_NAME],
      default: void 0
    };
    var EndpointMode = /* @__PURE__ */ ((EndpointMode2) => {
      EndpointMode2["IPv4"] = "IPv4";
      EndpointMode2["IPv6"] = "IPv6";
      return EndpointMode2;
    })(EndpointMode || {});
    var ENV_ENDPOINT_MODE_NAME = "AWS_EC2_METADATA_SERVICE_ENDPOINT_MODE";
    var CONFIG_ENDPOINT_MODE_NAME = "ec2_metadata_service_endpoint_mode";
    var ENDPOINT_MODE_CONFIG_OPTIONS = {
      environmentVariableSelector: (env) => env[ENV_ENDPOINT_MODE_NAME],
      configFileSelector: (profile) => profile[CONFIG_ENDPOINT_MODE_NAME],
      default: "IPv4"
      /* IPv4 */
    };
    var getInstanceMetadataEndpoint = /* @__PURE__ */ __name(async () => (0, import_url_parser.parseUrl)(await getFromEndpointConfig() || await getFromEndpointModeConfig()), "getInstanceMetadataEndpoint");
    var getFromEndpointConfig = /* @__PURE__ */ __name(async () => (0, import_node_config_provider.loadConfig)(ENDPOINT_CONFIG_OPTIONS)(), "getFromEndpointConfig");
    var getFromEndpointModeConfig = /* @__PURE__ */ __name(async () => {
      const endpointMode = await (0, import_node_config_provider.loadConfig)(ENDPOINT_MODE_CONFIG_OPTIONS)();
      switch (endpointMode) {
        case "IPv4":
          return "http://169.254.169.254";
        case "IPv6":
          return "http://[fd00:ec2::254]";
        default:
          throw new Error(`Unsupported endpoint mode: ${endpointMode}. Select from ${Object.values(EndpointMode)}`);
      }
    }, "getFromEndpointModeConfig");
    var STATIC_STABILITY_REFRESH_INTERVAL_SECONDS = 5 * 60;
    var STATIC_STABILITY_REFRESH_INTERVAL_JITTER_WINDOW_SECONDS = 5 * 60;
    var STATIC_STABILITY_DOC_URL = "https://docs.aws.amazon.com/sdkref/latest/guide/feature-static-credentials.html";
    var getExtendedInstanceMetadataCredentials = /* @__PURE__ */ __name((credentials, logger) => {
      const refreshInterval = STATIC_STABILITY_REFRESH_INTERVAL_SECONDS + Math.floor(Math.random() * STATIC_STABILITY_REFRESH_INTERVAL_JITTER_WINDOW_SECONDS);
      const newExpiration = new Date(Date.now() + refreshInterval * 1e3);
      logger.warn(
        `Attempting credential expiration extension due to a credential service availability issue. A refresh of these credentials will be attempted after ${new Date(newExpiration)}.
For more information, please visit: ` + STATIC_STABILITY_DOC_URL
      );
      const originalExpiration = credentials.originalExpiration ?? credentials.expiration;
      return {
        ...credentials,
        ...originalExpiration ? { originalExpiration } : {},
        expiration: newExpiration
      };
    }, "getExtendedInstanceMetadataCredentials");
    var staticStabilityProvider = /* @__PURE__ */ __name((provider, options = {}) => {
      const logger = (options == null ? void 0 : options.logger) || console;
      let pastCredentials;
      return async () => {
        let credentials;
        try {
          credentials = await provider();
          if (credentials.expiration && credentials.expiration.getTime() < Date.now()) {
            credentials = getExtendedInstanceMetadataCredentials(credentials, logger);
          }
        } catch (e) {
          if (pastCredentials) {
            logger.warn("Credential renew failed: ", e);
            credentials = getExtendedInstanceMetadataCredentials(pastCredentials, logger);
          } else {
            throw e;
          }
        }
        pastCredentials = credentials;
        return credentials;
      };
    }, "staticStabilityProvider");
    var IMDS_PATH = "/latest/meta-data/iam/security-credentials/";
    var IMDS_TOKEN_PATH = "/latest/api/token";
    var AWS_EC2_METADATA_V1_DISABLED = "AWS_EC2_METADATA_V1_DISABLED";
    var PROFILE_AWS_EC2_METADATA_V1_DISABLED = "ec2_metadata_v1_disabled";
    var X_AWS_EC2_METADATA_TOKEN = "x-aws-ec2-metadata-token";
    var fromInstanceMetadata = /* @__PURE__ */ __name((init = {}) => staticStabilityProvider(getInstanceImdsProvider(init), { logger: init.logger }), "fromInstanceMetadata");
    var getInstanceImdsProvider = /* @__PURE__ */ __name((init) => {
      let disableFetchToken = false;
      const { logger, profile } = init;
      const { timeout, maxRetries } = providerConfigFromInit(init);
      const getCredentials = /* @__PURE__ */ __name(async (maxRetries2, options) => {
        var _a;
        const isImdsV1Fallback = disableFetchToken || ((_a = options.headers) == null ? void 0 : _a[X_AWS_EC2_METADATA_TOKEN]) == null;
        if (isImdsV1Fallback) {
          let fallbackBlockedFromProfile = false;
          let fallbackBlockedFromProcessEnv = false;
          const configValue = await (0, import_node_config_provider.loadConfig)(
            {
              environmentVariableSelector: (env) => {
                const envValue = env[AWS_EC2_METADATA_V1_DISABLED];
                fallbackBlockedFromProcessEnv = !!envValue && envValue !== "false";
                if (envValue === void 0) {
                  throw new import_property_provider.CredentialsProviderError(
                    `${AWS_EC2_METADATA_V1_DISABLED} not set in env, checking config file next.`
                  );
                }
                return fallbackBlockedFromProcessEnv;
              },
              configFileSelector: (profile2) => {
                const profileValue = profile2[PROFILE_AWS_EC2_METADATA_V1_DISABLED];
                fallbackBlockedFromProfile = !!profileValue && profileValue !== "false";
                return fallbackBlockedFromProfile;
              },
              default: false
            },
            {
              profile
            }
          )();
          if (init.ec2MetadataV1Disabled || configValue) {
            const causes = [];
            if (init.ec2MetadataV1Disabled)
              causes.push("credential provider initialization (runtime option ec2MetadataV1Disabled)");
            if (fallbackBlockedFromProfile)
              causes.push(`config file profile (${PROFILE_AWS_EC2_METADATA_V1_DISABLED})`);
            if (fallbackBlockedFromProcessEnv)
              causes.push(`process environment variable (${AWS_EC2_METADATA_V1_DISABLED})`);
            throw new InstanceMetadataV1FallbackError(
              `AWS EC2 Metadata v1 fallback has been blocked by AWS SDK configuration in the following: [${causes.join(
                ", "
              )}].`
            );
          }
        }
        const imdsProfile = (await retry(async () => {
          let profile2;
          try {
            profile2 = await getProfile(options);
          } catch (err) {
            if (err.statusCode === 401) {
              disableFetchToken = false;
            }
            throw err;
          }
          return profile2;
        }, maxRetries2)).trim();
        return retry(async () => {
          let creds;
          try {
            creds = await getCredentialsFromProfile(imdsProfile, options);
          } catch (err) {
            if (err.statusCode === 401) {
              disableFetchToken = false;
            }
            throw err;
          }
          return creds;
        }, maxRetries2);
      }, "getCredentials");
      return async () => {
        const endpoint = await getInstanceMetadataEndpoint();
        if (disableFetchToken) {
          logger == null ? void 0 : logger.debug("AWS SDK Instance Metadata", "using v1 fallback (no token fetch)");
          return getCredentials(maxRetries, { ...endpoint, timeout });
        } else {
          let token;
          try {
            token = (await getMetadataToken({ ...endpoint, timeout })).toString();
          } catch (error) {
            if ((error == null ? void 0 : error.statusCode) === 400) {
              throw Object.assign(error, {
                message: "EC2 Metadata token request returned error"
              });
            } else if (error.message === "TimeoutError" || [403, 404, 405].includes(error.statusCode)) {
              disableFetchToken = true;
            }
            logger == null ? void 0 : logger.debug("AWS SDK Instance Metadata", "using v1 fallback (initial)");
            return getCredentials(maxRetries, { ...endpoint, timeout });
          }
          return getCredentials(maxRetries, {
            ...endpoint,
            headers: {
              [X_AWS_EC2_METADATA_TOKEN]: token
            },
            timeout
          });
        }
      };
    }, "getInstanceImdsProvider");
    var getMetadataToken = /* @__PURE__ */ __name(async (options) => httpRequest({
      ...options,
      path: IMDS_TOKEN_PATH,
      method: "PUT",
      headers: {
        "x-aws-ec2-metadata-token-ttl-seconds": "21600"
      }
    }), "getMetadataToken");
    var getProfile = /* @__PURE__ */ __name(async (options) => (await httpRequest({ ...options, path: IMDS_PATH })).toString(), "getProfile");
    var getCredentialsFromProfile = /* @__PURE__ */ __name(async (profile, options) => {
      const credsResponse = JSON.parse(
        (await httpRequest({
          ...options,
          path: IMDS_PATH + profile
        })).toString()
      );
      if (!isImdsCredentials(credsResponse)) {
        throw new import_property_provider.CredentialsProviderError("Invalid response received from instance metadata service.");
      }
      return fromImdsCredentials(credsResponse);
    }, "getCredentialsFromProfile");
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-ini/dist-cjs/resolveCredentialSource.js
var require_resolveCredentialSource = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-ini/dist-cjs/resolveCredentialSource.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveCredentialSource = void 0;
    var credential_provider_env_1 = require_dist_cjs37();
    var credential_provider_imds_1 = require_dist_cjs38();
    var property_provider_1 = require_dist_cjs6();
    var resolveCredentialSource = (credentialSource, profileName) => {
      const sourceProvidersMap = {
        EcsContainer: credential_provider_imds_1.fromContainerMetadata,
        Ec2InstanceMetadata: credential_provider_imds_1.fromInstanceMetadata,
        Environment: credential_provider_env_1.fromEnv
      };
      if (credentialSource in sourceProvidersMap) {
        return sourceProvidersMap[credentialSource]();
      } else {
        throw new property_provider_1.CredentialsProviderError(`Unsupported credential source in profile ${profileName}. Got ${credentialSource}, expected EcsContainer or Ec2InstanceMetadata or Environment.`);
      }
    };
    exports2.resolveCredentialSource = resolveCredentialSource;
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-ini/dist-cjs/resolveAssumeRoleCredentials.js
var require_resolveAssumeRoleCredentials = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-ini/dist-cjs/resolveAssumeRoleCredentials.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveAssumeRoleCredentials = exports2.isAssumeRoleProfile = void 0;
    var property_provider_1 = require_dist_cjs6();
    var shared_ini_file_loader_1 = require_dist_cjs21();
    var resolveCredentialSource_1 = require_resolveCredentialSource();
    var resolveProfileData_1 = require_resolveProfileData();
    var isAssumeRoleProfile = (arg) => Boolean(arg) && typeof arg === "object" && typeof arg.role_arn === "string" && ["undefined", "string"].indexOf(typeof arg.role_session_name) > -1 && ["undefined", "string"].indexOf(typeof arg.external_id) > -1 && ["undefined", "string"].indexOf(typeof arg.mfa_serial) > -1 && (isAssumeRoleWithSourceProfile(arg) || isAssumeRoleWithProviderProfile(arg));
    exports2.isAssumeRoleProfile = isAssumeRoleProfile;
    var isAssumeRoleWithSourceProfile = (arg) => typeof arg.source_profile === "string" && typeof arg.credential_source === "undefined";
    var isAssumeRoleWithProviderProfile = (arg) => typeof arg.credential_source === "string" && typeof arg.source_profile === "undefined";
    var resolveAssumeRoleCredentials = async (profileName, profiles, options, visitedProfiles = {}) => {
      const data = profiles[profileName];
      if (!options.roleAssumer) {
        throw new property_provider_1.CredentialsProviderError(`Profile ${profileName} requires a role to be assumed, but no role assumption callback was provided.`, false);
      }
      const { source_profile } = data;
      if (source_profile && source_profile in visitedProfiles) {
        throw new property_provider_1.CredentialsProviderError(`Detected a cycle attempting to resolve credentials for profile ${(0, shared_ini_file_loader_1.getProfileName)(options)}. Profiles visited: ` + Object.keys(visitedProfiles).join(", "), false);
      }
      const sourceCredsProvider = source_profile ? (0, resolveProfileData_1.resolveProfileData)(source_profile, profiles, options, {
        ...visitedProfiles,
        [source_profile]: true
      }) : (0, resolveCredentialSource_1.resolveCredentialSource)(data.credential_source, profileName)();
      const params = {
        RoleArn: data.role_arn,
        RoleSessionName: data.role_session_name || `aws-sdk-js-${Date.now()}`,
        ExternalId: data.external_id,
        DurationSeconds: parseInt(data.duration_seconds || "3600", 10)
      };
      const { mfa_serial } = data;
      if (mfa_serial) {
        if (!options.mfaCodeProvider) {
          throw new property_provider_1.CredentialsProviderError(`Profile ${profileName} requires multi-factor authentication, but no MFA code callback was provided.`, false);
        }
        params.SerialNumber = mfa_serial;
        params.TokenCode = await options.mfaCodeProvider(mfa_serial);
      }
      const sourceCreds = await sourceCredsProvider;
      return options.roleAssumer(sourceCreds, params);
    };
    exports2.resolveAssumeRoleCredentials = resolveAssumeRoleCredentials;
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-process/dist-cjs/getValidatedProcessCredentials.js
var require_getValidatedProcessCredentials = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-process/dist-cjs/getValidatedProcessCredentials.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getValidatedProcessCredentials = void 0;
    var getValidatedProcessCredentials = (profileName, data) => {
      if (data.Version !== 1) {
        throw Error(`Profile ${profileName} credential_process did not return Version 1.`);
      }
      if (data.AccessKeyId === void 0 || data.SecretAccessKey === void 0) {
        throw Error(`Profile ${profileName} credential_process returned invalid credentials.`);
      }
      if (data.Expiration) {
        const currentTime = /* @__PURE__ */ new Date();
        const expireTime = new Date(data.Expiration);
        if (expireTime < currentTime) {
          throw Error(`Profile ${profileName} credential_process returned expired credentials.`);
        }
      }
      return {
        accessKeyId: data.AccessKeyId,
        secretAccessKey: data.SecretAccessKey,
        ...data.SessionToken && { sessionToken: data.SessionToken },
        ...data.Expiration && { expiration: new Date(data.Expiration) }
      };
    };
    exports2.getValidatedProcessCredentials = getValidatedProcessCredentials;
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-process/dist-cjs/resolveProcessCredentials.js
var require_resolveProcessCredentials = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-process/dist-cjs/resolveProcessCredentials.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveProcessCredentials = void 0;
    var property_provider_1 = require_dist_cjs6();
    var child_process_1 = require("child_process");
    var util_1 = require("util");
    var getValidatedProcessCredentials_1 = require_getValidatedProcessCredentials();
    var resolveProcessCredentials = async (profileName, profiles) => {
      const profile = profiles[profileName];
      if (profiles[profileName]) {
        const credentialProcess = profile["credential_process"];
        if (credentialProcess !== void 0) {
          const execPromise = (0, util_1.promisify)(child_process_1.exec);
          try {
            const { stdout } = await execPromise(credentialProcess);
            let data;
            try {
              data = JSON.parse(stdout.trim());
            } catch (_a) {
              throw Error(`Profile ${profileName} credential_process returned invalid JSON.`);
            }
            return (0, getValidatedProcessCredentials_1.getValidatedProcessCredentials)(profileName, data);
          } catch (error) {
            throw new property_provider_1.CredentialsProviderError(error.message);
          }
        } else {
          throw new property_provider_1.CredentialsProviderError(`Profile ${profileName} did not contain credential_process.`);
        }
      } else {
        throw new property_provider_1.CredentialsProviderError(`Profile ${profileName} could not be found in shared credentials file.`);
      }
    };
    exports2.resolveProcessCredentials = resolveProcessCredentials;
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-process/dist-cjs/fromProcess.js
var require_fromProcess = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-process/dist-cjs/fromProcess.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.fromProcess = void 0;
    var shared_ini_file_loader_1 = require_dist_cjs21();
    var resolveProcessCredentials_1 = require_resolveProcessCredentials();
    var fromProcess = (init = {}) => async () => {
      const profiles = await (0, shared_ini_file_loader_1.parseKnownFiles)(init);
      return (0, resolveProcessCredentials_1.resolveProcessCredentials)((0, shared_ini_file_loader_1.getProfileName)(init), profiles);
    };
    exports2.fromProcess = fromProcess;
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-process/dist-cjs/index.js
var require_dist_cjs39 = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-process/dist-cjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_fromProcess(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-ini/dist-cjs/resolveProcessCredentials.js
var require_resolveProcessCredentials2 = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-ini/dist-cjs/resolveProcessCredentials.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveProcessCredentials = exports2.isProcessProfile = void 0;
    var credential_provider_process_1 = require_dist_cjs39();
    var isProcessProfile = (arg) => Boolean(arg) && typeof arg === "object" && typeof arg.credential_process === "string";
    exports2.isProcessProfile = isProcessProfile;
    var resolveProcessCredentials = async (options, profile) => (0, credential_provider_process_1.fromProcess)({
      ...options,
      profile
    })();
    exports2.resolveProcessCredentials = resolveProcessCredentials;
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-sso/dist-cjs/isSsoProfile.js
var require_isSsoProfile = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-sso/dist-cjs/isSsoProfile.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.isSsoProfile = void 0;
    var isSsoProfile = (arg) => arg && (typeof arg.sso_start_url === "string" || typeof arg.sso_account_id === "string" || typeof arg.sso_session === "string" || typeof arg.sso_region === "string" || typeof arg.sso_role_name === "string");
    exports2.isSsoProfile = isSsoProfile;
  }
});

// ../../../node_modules/@aws-sdk/client-sso/dist-cjs/endpoint/EndpointParameters.js
var require_EndpointParameters3 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sso/dist-cjs/endpoint/EndpointParameters.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveClientEndpointParameters = void 0;
    var resolveClientEndpointParameters = (options) => {
      return {
        ...options,
        useDualstackEndpoint: options.useDualstackEndpoint ?? false,
        useFipsEndpoint: options.useFipsEndpoint ?? false,
        defaultSigningName: "awsssoportal"
      };
    };
    exports2.resolveClientEndpointParameters = resolveClientEndpointParameters;
  }
});

// ../../../node_modules/@aws-sdk/client-sso/package.json
var require_package3 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sso/package.json"(exports2, module2) {
    module2.exports = {
      name: "@aws-sdk/client-sso",
      description: "AWS SDK for JavaScript Sso Client for Node.js, Browser and React Native",
      version: "3.421.0",
      scripts: {
        build: "concurrently 'yarn:build:cjs' 'yarn:build:es' 'yarn:build:types'",
        "build:cjs": "tsc -p tsconfig.cjs.json",
        "build:docs": "typedoc",
        "build:es": "tsc -p tsconfig.es.json",
        "build:include:deps": "lerna run --scope $npm_package_name --include-dependencies build",
        "build:types": "tsc -p tsconfig.types.json",
        "build:types:downlevel": "downlevel-dts dist-types dist-types/ts3.4",
        clean: "rimraf ./dist-* && rimraf *.tsbuildinfo",
        "extract:docs": "api-extractor run --local",
        "generate:client": "node ../../scripts/generate-clients/single-service --solo sso"
      },
      main: "./dist-cjs/index.js",
      types: "./dist-types/index.d.ts",
      module: "./dist-es/index.js",
      sideEffects: false,
      dependencies: {
        "@aws-crypto/sha256-browser": "3.0.0",
        "@aws-crypto/sha256-js": "3.0.0",
        "@aws-sdk/middleware-host-header": "3.418.0",
        "@aws-sdk/middleware-logger": "3.418.0",
        "@aws-sdk/middleware-recursion-detection": "3.418.0",
        "@aws-sdk/middleware-user-agent": "3.418.0",
        "@aws-sdk/region-config-resolver": "3.418.0",
        "@aws-sdk/types": "3.418.0",
        "@aws-sdk/util-endpoints": "3.418.0",
        "@aws-sdk/util-user-agent-browser": "3.418.0",
        "@aws-sdk/util-user-agent-node": "3.418.0",
        "@smithy/config-resolver": "^2.0.10",
        "@smithy/fetch-http-handler": "^2.1.5",
        "@smithy/hash-node": "^2.0.9",
        "@smithy/invalid-dependency": "^2.0.9",
        "@smithy/middleware-content-length": "^2.0.11",
        "@smithy/middleware-endpoint": "^2.0.9",
        "@smithy/middleware-retry": "^2.0.12",
        "@smithy/middleware-serde": "^2.0.9",
        "@smithy/middleware-stack": "^2.0.2",
        "@smithy/node-config-provider": "^2.0.12",
        "@smithy/node-http-handler": "^2.1.5",
        "@smithy/protocol-http": "^3.0.5",
        "@smithy/smithy-client": "^2.1.6",
        "@smithy/types": "^2.3.3",
        "@smithy/url-parser": "^2.0.9",
        "@smithy/util-base64": "^2.0.0",
        "@smithy/util-body-length-browser": "^2.0.0",
        "@smithy/util-body-length-node": "^2.1.0",
        "@smithy/util-defaults-mode-browser": "^2.0.10",
        "@smithy/util-defaults-mode-node": "^2.0.12",
        "@smithy/util-retry": "^2.0.2",
        "@smithy/util-utf8": "^2.0.0",
        tslib: "^2.5.0"
      },
      devDependencies: {
        "@smithy/service-client-documentation-generator": "^2.0.0",
        "@tsconfig/node14": "1.0.3",
        "@types/node": "^14.14.31",
        concurrently: "7.0.0",
        "downlevel-dts": "0.10.1",
        rimraf: "3.0.2",
        typedoc: "0.23.23",
        typescript: "~4.9.5"
      },
      engines: {
        node: ">=14.0.0"
      },
      typesVersions: {
        "<4.0": {
          "dist-types/*": [
            "dist-types/ts3.4/*"
          ]
        }
      },
      files: [
        "dist-*/**"
      ],
      author: {
        name: "AWS SDK for JavaScript Team",
        url: "https://aws.amazon.com/javascript/"
      },
      license: "Apache-2.0",
      browser: {
        "./dist-es/runtimeConfig": "./dist-es/runtimeConfig.browser"
      },
      "react-native": {
        "./dist-es/runtimeConfig": "./dist-es/runtimeConfig.native"
      },
      homepage: "https://github.com/aws/aws-sdk-js-v3/tree/main/clients/client-sso",
      repository: {
        type: "git",
        url: "https://github.com/aws/aws-sdk-js-v3.git",
        directory: "clients/client-sso"
      }
    };
  }
});

// ../../../node_modules/@aws-sdk/util-user-agent-node/dist-cjs/is-crt-available.js
var require_is_crt_available = __commonJS({
  "../../../node_modules/@aws-sdk/util-user-agent-node/dist-cjs/is-crt-available.js"(exports2, module2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.isCrtAvailable = void 0;
    var isCrtAvailable = () => {
      try {
        if (typeof require === "function" && typeof module2 !== "undefined" && require("aws-crt")) {
          return ["md/crt-avail"];
        }
        return null;
      } catch (e) {
        return null;
      }
    };
    exports2.isCrtAvailable = isCrtAvailable;
  }
});

// ../../../node_modules/@aws-sdk/util-user-agent-node/dist-cjs/index.js
var require_dist_cjs40 = __commonJS({
  "../../../node_modules/@aws-sdk/util-user-agent-node/dist-cjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.defaultUserAgent = exports2.UA_APP_ID_INI_NAME = exports2.UA_APP_ID_ENV_NAME = void 0;
    var node_config_provider_1 = require_dist_cjs22();
    var os_1 = require("os");
    var process_1 = require("process");
    var is_crt_available_1 = require_is_crt_available();
    exports2.UA_APP_ID_ENV_NAME = "AWS_SDK_UA_APP_ID";
    exports2.UA_APP_ID_INI_NAME = "sdk-ua-app-id";
    var defaultUserAgent = ({ serviceId, clientVersion }) => {
      const sections = [
        ["aws-sdk-js", clientVersion],
        ["ua", "2.0"],
        [`os/${(0, os_1.platform)()}`, (0, os_1.release)()],
        ["lang/js"],
        ["md/nodejs", `${process_1.versions.node}`]
      ];
      const crtAvailable = (0, is_crt_available_1.isCrtAvailable)();
      if (crtAvailable) {
        sections.push(crtAvailable);
      }
      if (serviceId) {
        sections.push([`api/${serviceId}`, clientVersion]);
      }
      if (process_1.env.AWS_EXECUTION_ENV) {
        sections.push([`exec-env/${process_1.env.AWS_EXECUTION_ENV}`]);
      }
      const appIdPromise = (0, node_config_provider_1.loadConfig)({
        environmentVariableSelector: (env) => env[exports2.UA_APP_ID_ENV_NAME],
        configFileSelector: (profile) => profile[exports2.UA_APP_ID_INI_NAME],
        default: void 0
      })();
      let resolvedUserAgent = void 0;
      return async () => {
        if (!resolvedUserAgent) {
          const appId = await appIdPromise;
          resolvedUserAgent = appId ? [...sections, [`app/${appId}`]] : [...sections];
        }
        return resolvedUserAgent;
      };
    };
    exports2.defaultUserAgent = defaultUserAgent;
  }
});

// ../../../node_modules/@smithy/hash-node/dist-cjs/index.js
var require_dist_cjs41 = __commonJS({
  "../../../node_modules/@smithy/hash-node/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      Hash: () => Hash
    });
    module2.exports = __toCommonJS2(src_exports);
    var import_util_buffer_from = require_dist_cjs9();
    var import_util_utf8 = require_dist_cjs10();
    var import_buffer = require("buffer");
    var import_crypto5 = require("crypto");
    var _Hash = class _Hash {
      constructor(algorithmIdentifier, secret) {
        this.algorithmIdentifier = algorithmIdentifier;
        this.secret = secret;
        this.reset();
      }
      update(toHash, encoding) {
        this.hash.update((0, import_util_utf8.toUint8Array)(castSourceData(toHash, encoding)));
      }
      digest() {
        return Promise.resolve(this.hash.digest());
      }
      reset() {
        this.hash = this.secret ? (0, import_crypto5.createHmac)(this.algorithmIdentifier, castSourceData(this.secret)) : (0, import_crypto5.createHash)(this.algorithmIdentifier);
      }
    };
    __name(_Hash, "Hash");
    var Hash = _Hash;
    function castSourceData(toCast, encoding) {
      if (import_buffer.Buffer.isBuffer(toCast)) {
        return toCast;
      }
      if (typeof toCast === "string") {
        return (0, import_util_buffer_from.fromString)(toCast, encoding);
      }
      if (ArrayBuffer.isView(toCast)) {
        return (0, import_util_buffer_from.fromArrayBuffer)(toCast.buffer, toCast.byteOffset, toCast.byteLength);
      }
      return (0, import_util_buffer_from.fromArrayBuffer)(toCast);
    }
    __name(castSourceData, "castSourceData");
  }
});

// ../../../node_modules/@smithy/util-body-length-node/dist-cjs/index.js
var require_dist_cjs42 = __commonJS({
  "../../../node_modules/@smithy/util-body-length-node/dist-cjs/index.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      calculateBodyLength: () => calculateBodyLength
    });
    module2.exports = __toCommonJS2(src_exports);
    var import_fs = require("fs");
    var calculateBodyLength = /* @__PURE__ */ __name((body) => {
      if (!body) {
        return 0;
      }
      if (typeof body === "string") {
        return Buffer.byteLength(body);
      } else if (typeof body.byteLength === "number") {
        return body.byteLength;
      } else if (typeof body.size === "number") {
        return body.size;
      } else if (typeof body.start === "number" && typeof body.end === "number") {
        return body.end + 1 - body.start;
      } else if (typeof body.path === "string" || Buffer.isBuffer(body.path)) {
        return (0, import_fs.lstatSync)(body.path).size;
      } else if (typeof body.fd === "number") {
        return (0, import_fs.fstatSync)(body.fd).size;
      }
      throw new Error(`Body Length computation failed for ${body}`);
    }, "calculateBodyLength");
  }
});

// ../../../node_modules/@aws-sdk/client-sso/dist-cjs/endpoint/ruleset.js
var require_ruleset = __commonJS({
  "../../../node_modules/@aws-sdk/client-sso/dist-cjs/endpoint/ruleset.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ruleSet = void 0;
    var q = "required";
    var r = "fn";
    var s = "argv";
    var t = "ref";
    var a = "isSet";
    var b = "tree";
    var c = "error";
    var d = "endpoint";
    var e = "PartitionResult";
    var f = { [q]: false, "type": "String" };
    var g = { [q]: true, "default": false, "type": "Boolean" };
    var h = { [t]: "Endpoint" };
    var i = { [r]: "booleanEquals", [s]: [{ [t]: "UseFIPS" }, true] };
    var j = { [r]: "booleanEquals", [s]: [{ [t]: "UseDualStack" }, true] };
    var k = {};
    var l = { [r]: "booleanEquals", [s]: [true, { [r]: "getAttr", [s]: [{ [t]: e }, "supportsFIPS"] }] };
    var m = { [r]: "booleanEquals", [s]: [true, { [r]: "getAttr", [s]: [{ [t]: e }, "supportsDualStack"] }] };
    var n = [i];
    var o = [j];
    var p = [{ [t]: "Region" }];
    var _data = { version: "1.0", parameters: { Region: f, UseDualStack: g, UseFIPS: g, Endpoint: f }, rules: [{ conditions: [{ [r]: a, [s]: [h] }], type: b, rules: [{ conditions: n, error: "Invalid Configuration: FIPS and custom endpoint are not supported", type: c }, { conditions: o, error: "Invalid Configuration: Dualstack and custom endpoint are not supported", type: c }, { endpoint: { url: h, properties: k, headers: k }, type: d }] }, { conditions: [{ [r]: a, [s]: p }], type: b, rules: [{ conditions: [{ [r]: "aws.partition", [s]: p, assign: e }], type: b, rules: [{ conditions: [i, j], type: b, rules: [{ conditions: [l, m], type: b, rules: [{ endpoint: { url: "https://portal.sso-fips.{Region}.{PartitionResult#dualStackDnsSuffix}", properties: k, headers: k }, type: d }] }, { error: "FIPS and DualStack are enabled, but this partition does not support one or both", type: c }] }, { conditions: n, type: b, rules: [{ conditions: [l], type: b, rules: [{ endpoint: { url: "https://portal.sso-fips.{Region}.{PartitionResult#dnsSuffix}", properties: k, headers: k }, type: d }] }, { error: "FIPS is enabled but this partition does not support FIPS", type: c }] }, { conditions: o, type: b, rules: [{ conditions: [m], type: b, rules: [{ endpoint: { url: "https://portal.sso.{Region}.{PartitionResult#dualStackDnsSuffix}", properties: k, headers: k }, type: d }] }, { error: "DualStack is enabled but this partition does not support DualStack", type: c }] }, { endpoint: { url: "https://portal.sso.{Region}.{PartitionResult#dnsSuffix}", properties: k, headers: k }, type: d }] }] }, { error: "Invalid Configuration: Missing Region", type: c }] };
    exports2.ruleSet = _data;
  }
});

// ../../../node_modules/@aws-sdk/client-sso/dist-cjs/endpoint/endpointResolver.js
var require_endpointResolver = __commonJS({
  "../../../node_modules/@aws-sdk/client-sso/dist-cjs/endpoint/endpointResolver.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.defaultEndpointResolver = void 0;
    var util_endpoints_1 = require_dist_cjs16();
    var ruleset_1 = require_ruleset();
    var defaultEndpointResolver = (endpointParams, context = {}) => {
      return (0, util_endpoints_1.resolveEndpoint)(ruleset_1.ruleSet, {
        endpointParams,
        logger: context.logger
      });
    };
    exports2.defaultEndpointResolver = defaultEndpointResolver;
  }
});

// ../../../node_modules/@aws-sdk/client-sso/dist-cjs/runtimeConfig.shared.js
var require_runtimeConfig_shared = __commonJS({
  "../../../node_modules/@aws-sdk/client-sso/dist-cjs/runtimeConfig.shared.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getRuntimeConfig = void 0;
    var smithy_client_1 = require_dist_cjs34();
    var url_parser_1 = require_dist_cjs24();
    var util_base64_1 = require_dist_cjs30();
    var util_utf8_1 = require_dist_cjs10();
    var endpointResolver_1 = require_endpointResolver();
    var getRuntimeConfig = (config) => ({
      apiVersion: "2019-06-10",
      base64Decoder: config?.base64Decoder ?? util_base64_1.fromBase64,
      base64Encoder: config?.base64Encoder ?? util_base64_1.toBase64,
      disableHostPrefix: config?.disableHostPrefix ?? false,
      endpointProvider: config?.endpointProvider ?? endpointResolver_1.defaultEndpointResolver,
      extensions: config?.extensions ?? [],
      logger: config?.logger ?? new smithy_client_1.NoOpLogger(),
      serviceId: config?.serviceId ?? "SSO",
      urlParser: config?.urlParser ?? url_parser_1.parseUrl,
      utf8Decoder: config?.utf8Decoder ?? util_utf8_1.fromUtf8,
      utf8Encoder: config?.utf8Encoder ?? util_utf8_1.toUtf8
    });
    exports2.getRuntimeConfig = getRuntimeConfig;
  }
});

// ../../../node_modules/@smithy/util-defaults-mode-node/dist-cjs/index.js
var require_dist_cjs43 = __commonJS({
  "../../../node_modules/@smithy/util-defaults-mode-node/dist-cjs/index.js"(exports2, module2) {
    var __create2 = Object.create;
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __getProtoOf2 = Object.getPrototypeOf;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __name = (target, value) => __defProp2(target, "name", { value, configurable: true });
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toESM2 = (mod, isNodeMode, target) => (target = mod != null ? __create2(__getProtoOf2(mod)) : {}, __copyProps2(
      // If the importer is in node compatibility mode or this is not an ESM
      // file that has been converted to a CommonJS file using a Babel-
      // compatible transform (i.e. "__esModule" has not been set), then set
      // "default" to the CommonJS "module.exports" for node compatibility.
      isNodeMode || !mod || !mod.__esModule ? __defProp2(target, "default", { value: mod, enumerable: true }) : target,
      mod
    ));
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var src_exports = {};
    __export2(src_exports, {
      resolveDefaultsModeConfig: () => resolveDefaultsModeConfig
    });
    module2.exports = __toCommonJS2(src_exports);
    var import_config_resolver = require_dist_cjs19();
    var import_node_config_provider = require_dist_cjs22();
    var import_property_provider = require_dist_cjs6();
    var AWS_EXECUTION_ENV = "AWS_EXECUTION_ENV";
    var AWS_REGION_ENV = "AWS_REGION";
    var AWS_DEFAULT_REGION_ENV = "AWS_DEFAULT_REGION";
    var ENV_IMDS_DISABLED = "AWS_EC2_METADATA_DISABLED";
    var DEFAULTS_MODE_OPTIONS = ["in-region", "cross-region", "mobile", "standard", "legacy"];
    var IMDS_REGION_PATH = "/latest/meta-data/placement/region";
    var AWS_DEFAULTS_MODE_ENV = "AWS_DEFAULTS_MODE";
    var AWS_DEFAULTS_MODE_CONFIG = "defaults_mode";
    var NODE_DEFAULTS_MODE_CONFIG_OPTIONS = {
      environmentVariableSelector: (env) => {
        return env[AWS_DEFAULTS_MODE_ENV];
      },
      configFileSelector: (profile) => {
        return profile[AWS_DEFAULTS_MODE_CONFIG];
      },
      default: "legacy"
    };
    var resolveDefaultsModeConfig = /* @__PURE__ */ __name(({
      region = (0, import_node_config_provider.loadConfig)(import_config_resolver.NODE_REGION_CONFIG_OPTIONS),
      defaultsMode = (0, import_node_config_provider.loadConfig)(NODE_DEFAULTS_MODE_CONFIG_OPTIONS)
    } = {}) => (0, import_property_provider.memoize)(async () => {
      const mode = typeof defaultsMode === "function" ? await defaultsMode() : defaultsMode;
      switch (mode == null ? void 0 : mode.toLowerCase()) {
        case "auto":
          return resolveNodeDefaultsModeAuto(region);
        case "in-region":
        case "cross-region":
        case "mobile":
        case "standard":
        case "legacy":
          return Promise.resolve(mode == null ? void 0 : mode.toLocaleLowerCase());
        case void 0:
          return Promise.resolve("legacy");
        default:
          throw new Error(
            `Invalid parameter for "defaultsMode", expect ${DEFAULTS_MODE_OPTIONS.join(", ")}, got ${mode}`
          );
      }
    }), "resolveDefaultsModeConfig");
    var resolveNodeDefaultsModeAuto = /* @__PURE__ */ __name(async (clientRegion) => {
      if (clientRegion) {
        const resolvedRegion = typeof clientRegion === "function" ? await clientRegion() : clientRegion;
        const inferredRegion = await inferPhysicalRegion();
        if (!inferredRegion) {
          return "standard";
        }
        if (resolvedRegion === inferredRegion) {
          return "in-region";
        } else {
          return "cross-region";
        }
      }
      return "standard";
    }, "resolveNodeDefaultsModeAuto");
    var inferPhysicalRegion = /* @__PURE__ */ __name(async () => {
      if (process.env[AWS_EXECUTION_ENV] && (process.env[AWS_REGION_ENV] || process.env[AWS_DEFAULT_REGION_ENV])) {
        return process.env[AWS_REGION_ENV] ?? process.env[AWS_DEFAULT_REGION_ENV];
      }
      if (!process.env[ENV_IMDS_DISABLED]) {
        try {
          const { getInstanceMetadataEndpoint, httpRequest } = await Promise.resolve().then(() => __toESM2(require_dist_cjs38()));
          const endpoint = await getInstanceMetadataEndpoint();
          return (await httpRequest({ ...endpoint, path: IMDS_REGION_PATH })).toString();
        } catch (e) {
        }
      }
    }, "inferPhysicalRegion");
  }
});

// ../../../node_modules/@aws-sdk/client-sso/dist-cjs/runtimeConfig.js
var require_runtimeConfig = __commonJS({
  "../../../node_modules/@aws-sdk/client-sso/dist-cjs/runtimeConfig.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getRuntimeConfig = void 0;
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    var package_json_1 = tslib_1.__importDefault(require_package3());
    var util_user_agent_node_1 = require_dist_cjs40();
    var config_resolver_1 = require_dist_cjs19();
    var hash_node_1 = require_dist_cjs41();
    var middleware_retry_1 = require_dist_cjs35();
    var node_config_provider_1 = require_dist_cjs22();
    var node_http_handler_1 = require_dist_cjs32();
    var util_body_length_node_1 = require_dist_cjs42();
    var util_retry_1 = require_dist_cjs28();
    var runtimeConfig_shared_1 = require_runtimeConfig_shared();
    var smithy_client_1 = require_dist_cjs34();
    var util_defaults_mode_node_1 = require_dist_cjs43();
    var smithy_client_2 = require_dist_cjs34();
    var getRuntimeConfig = (config) => {
      (0, smithy_client_2.emitWarningIfUnsupportedVersion)(process.version);
      const defaultsMode = (0, util_defaults_mode_node_1.resolveDefaultsModeConfig)(config);
      const defaultConfigProvider = () => defaultsMode().then(smithy_client_1.loadConfigsForDefaultMode);
      const clientSharedValues = (0, runtimeConfig_shared_1.getRuntimeConfig)(config);
      return {
        ...clientSharedValues,
        ...config,
        runtime: "node",
        defaultsMode,
        bodyLengthChecker: config?.bodyLengthChecker ?? util_body_length_node_1.calculateBodyLength,
        defaultUserAgentProvider: config?.defaultUserAgentProvider ?? (0, util_user_agent_node_1.defaultUserAgent)({ serviceId: clientSharedValues.serviceId, clientVersion: package_json_1.default.version }),
        maxAttempts: config?.maxAttempts ?? (0, node_config_provider_1.loadConfig)(middleware_retry_1.NODE_MAX_ATTEMPT_CONFIG_OPTIONS),
        region: config?.region ?? (0, node_config_provider_1.loadConfig)(config_resolver_1.NODE_REGION_CONFIG_OPTIONS, config_resolver_1.NODE_REGION_CONFIG_FILE_OPTIONS),
        requestHandler: config?.requestHandler ?? new node_http_handler_1.NodeHttpHandler(defaultConfigProvider),
        retryMode: config?.retryMode ?? (0, node_config_provider_1.loadConfig)({
          ...middleware_retry_1.NODE_RETRY_MODE_CONFIG_OPTIONS,
          default: async () => (await defaultConfigProvider()).retryMode || util_retry_1.DEFAULT_RETRY_MODE
        }),
        sha256: config?.sha256 ?? hash_node_1.Hash.bind(null, "sha256"),
        streamCollector: config?.streamCollector ?? node_http_handler_1.streamCollector,
        useDualstackEndpoint: config?.useDualstackEndpoint ?? (0, node_config_provider_1.loadConfig)(config_resolver_1.NODE_USE_DUALSTACK_ENDPOINT_CONFIG_OPTIONS),
        useFipsEndpoint: config?.useFipsEndpoint ?? (0, node_config_provider_1.loadConfig)(config_resolver_1.NODE_USE_FIPS_ENDPOINT_CONFIG_OPTIONS)
      };
    };
    exports2.getRuntimeConfig = getRuntimeConfig;
  }
});

// ../../../node_modules/@aws-sdk/region-config-resolver/dist-cjs/extensions/index.js
var require_extensions2 = __commonJS({
  "../../../node_modules/@aws-sdk/region-config-resolver/dist-cjs/extensions/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveAwsRegionExtensionConfiguration = exports2.getAwsRegionExtensionConfiguration = void 0;
    var getAwsRegionExtensionConfiguration = (runtimeConfig) => {
      let runtimeConfigRegion = async () => {
        if (runtimeConfig.region === void 0) {
          throw new Error("Region is missing from runtimeConfig");
        }
        const region = runtimeConfig.region;
        if (typeof region === "string") {
          return region;
        }
        return region();
      };
      return {
        setRegion(region) {
          runtimeConfigRegion = region;
        },
        region() {
          return runtimeConfigRegion;
        }
      };
    };
    exports2.getAwsRegionExtensionConfiguration = getAwsRegionExtensionConfiguration;
    var resolveAwsRegionExtensionConfiguration = (awsRegionExtensionConfiguration) => {
      return {
        region: awsRegionExtensionConfiguration.region()
      };
    };
    exports2.resolveAwsRegionExtensionConfiguration = resolveAwsRegionExtensionConfiguration;
  }
});

// ../../../node_modules/@aws-sdk/region-config-resolver/dist-cjs/regionConfig/config.js
var require_config = __commonJS({
  "../../../node_modules/@aws-sdk/region-config-resolver/dist-cjs/regionConfig/config.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.NODE_REGION_CONFIG_FILE_OPTIONS = exports2.NODE_REGION_CONFIG_OPTIONS = exports2.REGION_INI_NAME = exports2.REGION_ENV_NAME = void 0;
    exports2.REGION_ENV_NAME = "AWS_REGION";
    exports2.REGION_INI_NAME = "region";
    exports2.NODE_REGION_CONFIG_OPTIONS = {
      environmentVariableSelector: (env) => env[exports2.REGION_ENV_NAME],
      configFileSelector: (profile) => profile[exports2.REGION_INI_NAME],
      default: () => {
        throw new Error("Region is missing");
      }
    };
    exports2.NODE_REGION_CONFIG_FILE_OPTIONS = {
      preferredFile: "credentials"
    };
  }
});

// ../../../node_modules/@aws-sdk/region-config-resolver/dist-cjs/regionConfig/isFipsRegion.js
var require_isFipsRegion = __commonJS({
  "../../../node_modules/@aws-sdk/region-config-resolver/dist-cjs/regionConfig/isFipsRegion.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.isFipsRegion = void 0;
    var isFipsRegion = (region) => typeof region === "string" && (region.startsWith("fips-") || region.endsWith("-fips"));
    exports2.isFipsRegion = isFipsRegion;
  }
});

// ../../../node_modules/@aws-sdk/region-config-resolver/dist-cjs/regionConfig/getRealRegion.js
var require_getRealRegion = __commonJS({
  "../../../node_modules/@aws-sdk/region-config-resolver/dist-cjs/regionConfig/getRealRegion.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getRealRegion = void 0;
    var isFipsRegion_1 = require_isFipsRegion();
    var getRealRegion = (region) => (0, isFipsRegion_1.isFipsRegion)(region) ? ["fips-aws-global", "aws-fips"].includes(region) ? "us-east-1" : region.replace(/fips-(dkr-|prod-)?|-fips/, "") : region;
    exports2.getRealRegion = getRealRegion;
  }
});

// ../../../node_modules/@aws-sdk/region-config-resolver/dist-cjs/regionConfig/resolveRegionConfig.js
var require_resolveRegionConfig = __commonJS({
  "../../../node_modules/@aws-sdk/region-config-resolver/dist-cjs/regionConfig/resolveRegionConfig.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveRegionConfig = void 0;
    var getRealRegion_1 = require_getRealRegion();
    var isFipsRegion_1 = require_isFipsRegion();
    var resolveRegionConfig = (input) => {
      const { region, useFipsEndpoint } = input;
      if (!region) {
        throw new Error("Region is missing");
      }
      return {
        ...input,
        region: async () => {
          if (typeof region === "string") {
            return (0, getRealRegion_1.getRealRegion)(region);
          }
          const providedRegion = await region();
          return (0, getRealRegion_1.getRealRegion)(providedRegion);
        },
        useFipsEndpoint: async () => {
          const providedRegion = typeof region === "string" ? region : await region();
          if ((0, isFipsRegion_1.isFipsRegion)(providedRegion)) {
            return true;
          }
          return typeof useFipsEndpoint !== "function" ? Promise.resolve(!!useFipsEndpoint) : useFipsEndpoint();
        }
      };
    };
    exports2.resolveRegionConfig = resolveRegionConfig;
  }
});

// ../../../node_modules/@aws-sdk/region-config-resolver/dist-cjs/regionConfig/index.js
var require_regionConfig = __commonJS({
  "../../../node_modules/@aws-sdk/region-config-resolver/dist-cjs/regionConfig/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_config(), exports2);
    tslib_1.__exportStar(require_resolveRegionConfig(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/region-config-resolver/dist-cjs/index.js
var require_dist_cjs44 = __commonJS({
  "../../../node_modules/@aws-sdk/region-config-resolver/dist-cjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_extensions2(), exports2);
    tslib_1.__exportStar(require_regionConfig(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/client-sso/dist-cjs/runtimeExtensions.js
var require_runtimeExtensions = __commonJS({
  "../../../node_modules/@aws-sdk/client-sso/dist-cjs/runtimeExtensions.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveRuntimeExtensions = void 0;
    var region_config_resolver_1 = require_dist_cjs44();
    var protocol_http_1 = require_dist_cjs2();
    var smithy_client_1 = require_dist_cjs34();
    var asPartial = (t) => t;
    var resolveRuntimeExtensions = (runtimeConfig, extensions) => {
      const extensionConfiguration = {
        ...asPartial((0, region_config_resolver_1.getAwsRegionExtensionConfiguration)(runtimeConfig)),
        ...asPartial((0, smithy_client_1.getDefaultExtensionConfiguration)(runtimeConfig)),
        ...asPartial((0, protocol_http_1.getHttpHandlerExtensionConfiguration)(runtimeConfig))
      };
      extensions.forEach((extension) => extension.configure(extensionConfiguration));
      return {
        ...runtimeConfig,
        ...(0, region_config_resolver_1.resolveAwsRegionExtensionConfiguration)(extensionConfiguration),
        ...(0, smithy_client_1.resolveDefaultRuntimeConfig)(extensionConfiguration),
        ...(0, protocol_http_1.resolveHttpHandlerRuntimeConfig)(extensionConfiguration)
      };
    };
    exports2.resolveRuntimeExtensions = resolveRuntimeExtensions;
  }
});

// ../../../node_modules/@aws-sdk/client-sso/dist-cjs/SSOClient.js
var require_SSOClient = __commonJS({
  "../../../node_modules/@aws-sdk/client-sso/dist-cjs/SSOClient.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SSOClient = exports2.__Client = void 0;
    var middleware_host_header_1 = require_dist_cjs3();
    var middleware_logger_1 = require_dist_cjs4();
    var middleware_recursion_detection_1 = require_dist_cjs5();
    var middleware_user_agent_1 = require_dist_cjs17();
    var config_resolver_1 = require_dist_cjs19();
    var middleware_content_length_1 = require_dist_cjs20();
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_retry_1 = require_dist_cjs35();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "__Client", { enumerable: true, get: function() {
      return smithy_client_1.Client;
    } });
    var EndpointParameters_1 = require_EndpointParameters3();
    var runtimeConfig_1 = require_runtimeConfig();
    var runtimeExtensions_1 = require_runtimeExtensions();
    var SSOClient = class extends smithy_client_1.Client {
      constructor(...[configuration]) {
        const _config_0 = (0, runtimeConfig_1.getRuntimeConfig)(configuration || {});
        const _config_1 = (0, EndpointParameters_1.resolveClientEndpointParameters)(_config_0);
        const _config_2 = (0, config_resolver_1.resolveRegionConfig)(_config_1);
        const _config_3 = (0, middleware_endpoint_1.resolveEndpointConfig)(_config_2);
        const _config_4 = (0, middleware_retry_1.resolveRetryConfig)(_config_3);
        const _config_5 = (0, middleware_host_header_1.resolveHostHeaderConfig)(_config_4);
        const _config_6 = (0, middleware_user_agent_1.resolveUserAgentConfig)(_config_5);
        const _config_7 = (0, runtimeExtensions_1.resolveRuntimeExtensions)(_config_6, configuration?.extensions || []);
        super(_config_7);
        this.config = _config_7;
        this.middlewareStack.use((0, middleware_retry_1.getRetryPlugin)(this.config));
        this.middlewareStack.use((0, middleware_content_length_1.getContentLengthPlugin)(this.config));
        this.middlewareStack.use((0, middleware_host_header_1.getHostHeaderPlugin)(this.config));
        this.middlewareStack.use((0, middleware_logger_1.getLoggerPlugin)(this.config));
        this.middlewareStack.use((0, middleware_recursion_detection_1.getRecursionDetectionPlugin)(this.config));
        this.middlewareStack.use((0, middleware_user_agent_1.getUserAgentPlugin)(this.config));
      }
      destroy() {
        super.destroy();
      }
    };
    exports2.SSOClient = SSOClient;
  }
});

// ../../../node_modules/@aws-sdk/client-sso/dist-cjs/models/SSOServiceException.js
var require_SSOServiceException = __commonJS({
  "../../../node_modules/@aws-sdk/client-sso/dist-cjs/models/SSOServiceException.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SSOServiceException = exports2.__ServiceException = void 0;
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "__ServiceException", { enumerable: true, get: function() {
      return smithy_client_1.ServiceException;
    } });
    var SSOServiceException = class _SSOServiceException extends smithy_client_1.ServiceException {
      constructor(options) {
        super(options);
        Object.setPrototypeOf(this, _SSOServiceException.prototype);
      }
    };
    exports2.SSOServiceException = SSOServiceException;
  }
});

// ../../../node_modules/@aws-sdk/client-sso/dist-cjs/models/models_0.js
var require_models_02 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sso/dist-cjs/models/models_0.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.LogoutRequestFilterSensitiveLog = exports2.ListAccountsRequestFilterSensitiveLog = exports2.ListAccountRolesRequestFilterSensitiveLog = exports2.GetRoleCredentialsResponseFilterSensitiveLog = exports2.RoleCredentialsFilterSensitiveLog = exports2.GetRoleCredentialsRequestFilterSensitiveLog = exports2.UnauthorizedException = exports2.TooManyRequestsException = exports2.ResourceNotFoundException = exports2.InvalidRequestException = void 0;
    var smithy_client_1 = require_dist_cjs34();
    var SSOServiceException_1 = require_SSOServiceException();
    var InvalidRequestException = class _InvalidRequestException extends SSOServiceException_1.SSOServiceException {
      constructor(opts) {
        super({
          name: "InvalidRequestException",
          $fault: "client",
          ...opts
        });
        this.name = "InvalidRequestException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _InvalidRequestException.prototype);
      }
    };
    exports2.InvalidRequestException = InvalidRequestException;
    var ResourceNotFoundException = class _ResourceNotFoundException extends SSOServiceException_1.SSOServiceException {
      constructor(opts) {
        super({
          name: "ResourceNotFoundException",
          $fault: "client",
          ...opts
        });
        this.name = "ResourceNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _ResourceNotFoundException.prototype);
      }
    };
    exports2.ResourceNotFoundException = ResourceNotFoundException;
    var TooManyRequestsException = class _TooManyRequestsException extends SSOServiceException_1.SSOServiceException {
      constructor(opts) {
        super({
          name: "TooManyRequestsException",
          $fault: "client",
          ...opts
        });
        this.name = "TooManyRequestsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _TooManyRequestsException.prototype);
      }
    };
    exports2.TooManyRequestsException = TooManyRequestsException;
    var UnauthorizedException = class _UnauthorizedException extends SSOServiceException_1.SSOServiceException {
      constructor(opts) {
        super({
          name: "UnauthorizedException",
          $fault: "client",
          ...opts
        });
        this.name = "UnauthorizedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _UnauthorizedException.prototype);
      }
    };
    exports2.UnauthorizedException = UnauthorizedException;
    var GetRoleCredentialsRequestFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.accessToken && { accessToken: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.GetRoleCredentialsRequestFilterSensitiveLog = GetRoleCredentialsRequestFilterSensitiveLog;
    var RoleCredentialsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.secretAccessKey && { secretAccessKey: smithy_client_1.SENSITIVE_STRING },
      ...obj.sessionToken && { sessionToken: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.RoleCredentialsFilterSensitiveLog = RoleCredentialsFilterSensitiveLog;
    var GetRoleCredentialsResponseFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.roleCredentials && { roleCredentials: (0, exports2.RoleCredentialsFilterSensitiveLog)(obj.roleCredentials) }
    });
    exports2.GetRoleCredentialsResponseFilterSensitiveLog = GetRoleCredentialsResponseFilterSensitiveLog;
    var ListAccountRolesRequestFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.accessToken && { accessToken: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.ListAccountRolesRequestFilterSensitiveLog = ListAccountRolesRequestFilterSensitiveLog;
    var ListAccountsRequestFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.accessToken && { accessToken: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.ListAccountsRequestFilterSensitiveLog = ListAccountsRequestFilterSensitiveLog;
    var LogoutRequestFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.accessToken && { accessToken: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.LogoutRequestFilterSensitiveLog = LogoutRequestFilterSensitiveLog;
  }
});

// ../../../node_modules/@aws-sdk/client-sso/dist-cjs/protocols/Aws_restJson1.js
var require_Aws_restJson1 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sso/dist-cjs/protocols/Aws_restJson1.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.de_LogoutCommand = exports2.de_ListAccountsCommand = exports2.de_ListAccountRolesCommand = exports2.de_GetRoleCredentialsCommand = exports2.se_LogoutCommand = exports2.se_ListAccountsCommand = exports2.se_ListAccountRolesCommand = exports2.se_GetRoleCredentialsCommand = void 0;
    var protocol_http_1 = require_dist_cjs2();
    var smithy_client_1 = require_dist_cjs34();
    var models_0_1 = require_models_02();
    var SSOServiceException_1 = require_SSOServiceException();
    var se_GetRoleCredentialsCommand = async (input, context) => {
      const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
      const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-sso_bearer_token": input.accessToken
      });
      const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}/federation/credentials`;
      const query = (0, smithy_client_1.map)({
        role_name: [, (0, smithy_client_1.expectNonNull)(input.roleName, `roleName`)],
        account_id: [, (0, smithy_client_1.expectNonNull)(input.accountId, `accountId`)]
      });
      let body;
      return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body
      });
    };
    exports2.se_GetRoleCredentialsCommand = se_GetRoleCredentialsCommand;
    var se_ListAccountRolesCommand = async (input, context) => {
      const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
      const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-sso_bearer_token": input.accessToken
      });
      const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}/assignment/roles`;
      const query = (0, smithy_client_1.map)({
        next_token: [, input.nextToken],
        max_result: [() => input.maxResults !== void 0, () => input.maxResults.toString()],
        account_id: [, (0, smithy_client_1.expectNonNull)(input.accountId, `accountId`)]
      });
      let body;
      return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body
      });
    };
    exports2.se_ListAccountRolesCommand = se_ListAccountRolesCommand;
    var se_ListAccountsCommand = async (input, context) => {
      const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
      const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-sso_bearer_token": input.accessToken
      });
      const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}/assignment/accounts`;
      const query = (0, smithy_client_1.map)({
        next_token: [, input.nextToken],
        max_result: [() => input.maxResults !== void 0, () => input.maxResults.toString()]
      });
      let body;
      return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body
      });
    };
    exports2.se_ListAccountsCommand = se_ListAccountsCommand;
    var se_LogoutCommand = async (input, context) => {
      const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
      const headers = (0, smithy_client_1.map)({}, isSerializableHeaderValue, {
        "x-amz-sso_bearer_token": input.accessToken
      });
      const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}/logout`;
      let body;
      return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body
      });
    };
    exports2.se_LogoutCommand = se_LogoutCommand;
    var de_GetRoleCredentialsCommand = async (output, context) => {
      if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetRoleCredentialsCommandError(output, context);
      }
      const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output)
      });
      const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
      const doc = (0, smithy_client_1.take)(data, {
        roleCredentials: smithy_client_1._json
      });
      Object.assign(contents, doc);
      return contents;
    };
    exports2.de_GetRoleCredentialsCommand = de_GetRoleCredentialsCommand;
    var de_GetRoleCredentialsCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "InvalidRequestException":
        case "com.amazonaws.sso#InvalidRequestException":
          throw await de_InvalidRequestExceptionRes(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.sso#ResourceNotFoundException":
          throw await de_ResourceNotFoundExceptionRes(parsedOutput, context);
        case "TooManyRequestsException":
        case "com.amazonaws.sso#TooManyRequestsException":
          throw await de_TooManyRequestsExceptionRes(parsedOutput, context);
        case "UnauthorizedException":
        case "com.amazonaws.sso#UnauthorizedException":
          throw await de_UnauthorizedExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_ListAccountRolesCommand = async (output, context) => {
      if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListAccountRolesCommandError(output, context);
      }
      const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output)
      });
      const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
      const doc = (0, smithy_client_1.take)(data, {
        nextToken: smithy_client_1.expectString,
        roleList: smithy_client_1._json
      });
      Object.assign(contents, doc);
      return contents;
    };
    exports2.de_ListAccountRolesCommand = de_ListAccountRolesCommand;
    var de_ListAccountRolesCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "InvalidRequestException":
        case "com.amazonaws.sso#InvalidRequestException":
          throw await de_InvalidRequestExceptionRes(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.sso#ResourceNotFoundException":
          throw await de_ResourceNotFoundExceptionRes(parsedOutput, context);
        case "TooManyRequestsException":
        case "com.amazonaws.sso#TooManyRequestsException":
          throw await de_TooManyRequestsExceptionRes(parsedOutput, context);
        case "UnauthorizedException":
        case "com.amazonaws.sso#UnauthorizedException":
          throw await de_UnauthorizedExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_ListAccountsCommand = async (output, context) => {
      if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListAccountsCommandError(output, context);
      }
      const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output)
      });
      const data = (0, smithy_client_1.expectNonNull)((0, smithy_client_1.expectObject)(await parseBody(output.body, context)), "body");
      const doc = (0, smithy_client_1.take)(data, {
        accountList: smithy_client_1._json,
        nextToken: smithy_client_1.expectString
      });
      Object.assign(contents, doc);
      return contents;
    };
    exports2.de_ListAccountsCommand = de_ListAccountsCommand;
    var de_ListAccountsCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "InvalidRequestException":
        case "com.amazonaws.sso#InvalidRequestException":
          throw await de_InvalidRequestExceptionRes(parsedOutput, context);
        case "ResourceNotFoundException":
        case "com.amazonaws.sso#ResourceNotFoundException":
          throw await de_ResourceNotFoundExceptionRes(parsedOutput, context);
        case "TooManyRequestsException":
        case "com.amazonaws.sso#TooManyRequestsException":
          throw await de_TooManyRequestsExceptionRes(parsedOutput, context);
        case "UnauthorizedException":
        case "com.amazonaws.sso#UnauthorizedException":
          throw await de_UnauthorizedExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_LogoutCommand = async (output, context) => {
      if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_LogoutCommandError(output, context);
      }
      const contents = (0, smithy_client_1.map)({
        $metadata: deserializeMetadata(output)
      });
      await (0, smithy_client_1.collectBody)(output.body, context);
      return contents;
    };
    exports2.de_LogoutCommand = de_LogoutCommand;
    var de_LogoutCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "InvalidRequestException":
        case "com.amazonaws.sso#InvalidRequestException":
          throw await de_InvalidRequestExceptionRes(parsedOutput, context);
        case "TooManyRequestsException":
        case "com.amazonaws.sso#TooManyRequestsException":
          throw await de_TooManyRequestsExceptionRes(parsedOutput, context);
        case "UnauthorizedException":
        case "com.amazonaws.sso#UnauthorizedException":
          throw await de_UnauthorizedExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var throwDefaultError = (0, smithy_client_1.withBaseException)(SSOServiceException_1.SSOServiceException);
    var de_InvalidRequestExceptionRes = async (parsedOutput, context) => {
      const contents = (0, smithy_client_1.map)({});
      const data = parsedOutput.body;
      const doc = (0, smithy_client_1.take)(data, {
        message: smithy_client_1.expectString
      });
      Object.assign(contents, doc);
      const exception = new models_0_1.InvalidRequestException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents
      });
      return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
    };
    var de_ResourceNotFoundExceptionRes = async (parsedOutput, context) => {
      const contents = (0, smithy_client_1.map)({});
      const data = parsedOutput.body;
      const doc = (0, smithy_client_1.take)(data, {
        message: smithy_client_1.expectString
      });
      Object.assign(contents, doc);
      const exception = new models_0_1.ResourceNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents
      });
      return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
    };
    var de_TooManyRequestsExceptionRes = async (parsedOutput, context) => {
      const contents = (0, smithy_client_1.map)({});
      const data = parsedOutput.body;
      const doc = (0, smithy_client_1.take)(data, {
        message: smithy_client_1.expectString
      });
      Object.assign(contents, doc);
      const exception = new models_0_1.TooManyRequestsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents
      });
      return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
    };
    var de_UnauthorizedExceptionRes = async (parsedOutput, context) => {
      const contents = (0, smithy_client_1.map)({});
      const data = parsedOutput.body;
      const doc = (0, smithy_client_1.take)(data, {
        message: smithy_client_1.expectString
      });
      Object.assign(contents, doc);
      const exception = new models_0_1.UnauthorizedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents
      });
      return (0, smithy_client_1.decorateServiceException)(exception, parsedOutput.body);
    };
    var deserializeMetadata = (output) => ({
      httpStatusCode: output.statusCode,
      requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
      extendedRequestId: output.headers["x-amz-id-2"],
      cfId: output.headers["x-amz-cf-id"]
    });
    var collectBodyString = (streamBody, context) => (0, smithy_client_1.collectBody)(streamBody, context).then((body) => context.utf8Encoder(body));
    var isSerializableHeaderValue = (value) => value !== void 0 && value !== null && value !== "" && (!Object.getOwnPropertyNames(value).includes("length") || value.length != 0) && (!Object.getOwnPropertyNames(value).includes("size") || value.size != 0);
    var parseBody = (streamBody, context) => collectBodyString(streamBody, context).then((encoded) => {
      if (encoded.length) {
        return JSON.parse(encoded);
      }
      return {};
    });
    var parseErrorBody = async (errorBody, context) => {
      const value = await parseBody(errorBody, context);
      value.message = value.message ?? value.Message;
      return value;
    };
    var loadRestJsonErrorCode = (output, data) => {
      const findKey = (object, key) => Object.keys(object).find((k) => k.toLowerCase() === key.toLowerCase());
      const sanitizeErrorCode = (rawValue) => {
        let cleanValue = rawValue;
        if (typeof cleanValue === "number") {
          cleanValue = cleanValue.toString();
        }
        if (cleanValue.indexOf(",") >= 0) {
          cleanValue = cleanValue.split(",")[0];
        }
        if (cleanValue.indexOf(":") >= 0) {
          cleanValue = cleanValue.split(":")[0];
        }
        if (cleanValue.indexOf("#") >= 0) {
          cleanValue = cleanValue.split("#")[1];
        }
        return cleanValue;
      };
      const headerKey = findKey(output.headers, "x-amzn-errortype");
      if (headerKey !== void 0) {
        return sanitizeErrorCode(output.headers[headerKey]);
      }
      if (data.code !== void 0) {
        return sanitizeErrorCode(data.code);
      }
      if (data["__type"] !== void 0) {
        return sanitizeErrorCode(data["__type"]);
      }
    };
  }
});

// ../../../node_modules/@aws-sdk/client-sso/dist-cjs/commands/GetRoleCredentialsCommand.js
var require_GetRoleCredentialsCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sso/dist-cjs/commands/GetRoleCredentialsCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.GetRoleCredentialsCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var models_0_1 = require_models_02();
    var Aws_restJson1_1 = require_Aws_restJson1();
    var GetRoleCredentialsCommand = class _GetRoleCredentialsCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _GetRoleCredentialsCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SSOClient";
        const commandName = "GetRoleCredentialsCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: models_0_1.GetRoleCredentialsRequestFilterSensitiveLog,
          outputFilterSensitiveLog: models_0_1.GetRoleCredentialsResponseFilterSensitiveLog,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "SWBPortalService",
            operation: "GetRoleCredentials"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_restJson1_1.se_GetRoleCredentialsCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_restJson1_1.de_GetRoleCredentialsCommand)(output, context);
      }
    };
    exports2.GetRoleCredentialsCommand = GetRoleCredentialsCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sso/dist-cjs/commands/ListAccountRolesCommand.js
var require_ListAccountRolesCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sso/dist-cjs/commands/ListAccountRolesCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ListAccountRolesCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var models_0_1 = require_models_02();
    var Aws_restJson1_1 = require_Aws_restJson1();
    var ListAccountRolesCommand = class _ListAccountRolesCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _ListAccountRolesCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SSOClient";
        const commandName = "ListAccountRolesCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: models_0_1.ListAccountRolesRequestFilterSensitiveLog,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "SWBPortalService",
            operation: "ListAccountRoles"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_restJson1_1.se_ListAccountRolesCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_restJson1_1.de_ListAccountRolesCommand)(output, context);
      }
    };
    exports2.ListAccountRolesCommand = ListAccountRolesCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sso/dist-cjs/commands/ListAccountsCommand.js
var require_ListAccountsCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sso/dist-cjs/commands/ListAccountsCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ListAccountsCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var models_0_1 = require_models_02();
    var Aws_restJson1_1 = require_Aws_restJson1();
    var ListAccountsCommand = class _ListAccountsCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _ListAccountsCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SSOClient";
        const commandName = "ListAccountsCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: models_0_1.ListAccountsRequestFilterSensitiveLog,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "SWBPortalService",
            operation: "ListAccounts"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_restJson1_1.se_ListAccountsCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_restJson1_1.de_ListAccountsCommand)(output, context);
      }
    };
    exports2.ListAccountsCommand = ListAccountsCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sso/dist-cjs/commands/LogoutCommand.js
var require_LogoutCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sso/dist-cjs/commands/LogoutCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.LogoutCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var models_0_1 = require_models_02();
    var Aws_restJson1_1 = require_Aws_restJson1();
    var LogoutCommand = class _LogoutCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _LogoutCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SSOClient";
        const commandName = "LogoutCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: models_0_1.LogoutRequestFilterSensitiveLog,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "SWBPortalService",
            operation: "Logout"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_restJson1_1.se_LogoutCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_restJson1_1.de_LogoutCommand)(output, context);
      }
    };
    exports2.LogoutCommand = LogoutCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sso/dist-cjs/SSO.js
var require_SSO = __commonJS({
  "../../../node_modules/@aws-sdk/client-sso/dist-cjs/SSO.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SSO = void 0;
    var smithy_client_1 = require_dist_cjs34();
    var GetRoleCredentialsCommand_1 = require_GetRoleCredentialsCommand();
    var ListAccountRolesCommand_1 = require_ListAccountRolesCommand();
    var ListAccountsCommand_1 = require_ListAccountsCommand();
    var LogoutCommand_1 = require_LogoutCommand();
    var SSOClient_1 = require_SSOClient();
    var commands = {
      GetRoleCredentialsCommand: GetRoleCredentialsCommand_1.GetRoleCredentialsCommand,
      ListAccountRolesCommand: ListAccountRolesCommand_1.ListAccountRolesCommand,
      ListAccountsCommand: ListAccountsCommand_1.ListAccountsCommand,
      LogoutCommand: LogoutCommand_1.LogoutCommand
    };
    var SSO = class extends SSOClient_1.SSOClient {
    };
    exports2.SSO = SSO;
    (0, smithy_client_1.createAggregatedClient)(commands, SSO);
  }
});

// ../../../node_modules/@aws-sdk/client-sso/dist-cjs/commands/index.js
var require_commands = __commonJS({
  "../../../node_modules/@aws-sdk/client-sso/dist-cjs/commands/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_GetRoleCredentialsCommand(), exports2);
    tslib_1.__exportStar(require_ListAccountRolesCommand(), exports2);
    tslib_1.__exportStar(require_ListAccountsCommand(), exports2);
    tslib_1.__exportStar(require_LogoutCommand(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/client-sso/dist-cjs/pagination/Interfaces.js
var require_Interfaces = __commonJS({
  "../../../node_modules/@aws-sdk/client-sso/dist-cjs/pagination/Interfaces.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/client-sso/dist-cjs/pagination/ListAccountRolesPaginator.js
var require_ListAccountRolesPaginator = __commonJS({
  "../../../node_modules/@aws-sdk/client-sso/dist-cjs/pagination/ListAccountRolesPaginator.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.paginateListAccountRoles = void 0;
    var ListAccountRolesCommand_1 = require_ListAccountRolesCommand();
    var SSOClient_1 = require_SSOClient();
    var makePagedClientRequest = async (client, input, ...args) => {
      return await client.send(new ListAccountRolesCommand_1.ListAccountRolesCommand(input), ...args);
    };
    async function* paginateListAccountRoles(config, input, ...additionalArguments) {
      let token = config.startingToken || void 0;
      let hasNext = true;
      let page;
      while (hasNext) {
        input.nextToken = token;
        input["maxResults"] = config.pageSize;
        if (config.client instanceof SSOClient_1.SSOClient) {
          page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        } else {
          throw new Error("Invalid client, expected SSO | SSOClient");
        }
        yield page;
        const prevToken = token;
        token = page.nextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
      }
      return void 0;
    }
    exports2.paginateListAccountRoles = paginateListAccountRoles;
  }
});

// ../../../node_modules/@aws-sdk/client-sso/dist-cjs/pagination/ListAccountsPaginator.js
var require_ListAccountsPaginator = __commonJS({
  "../../../node_modules/@aws-sdk/client-sso/dist-cjs/pagination/ListAccountsPaginator.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.paginateListAccounts = void 0;
    var ListAccountsCommand_1 = require_ListAccountsCommand();
    var SSOClient_1 = require_SSOClient();
    var makePagedClientRequest = async (client, input, ...args) => {
      return await client.send(new ListAccountsCommand_1.ListAccountsCommand(input), ...args);
    };
    async function* paginateListAccounts(config, input, ...additionalArguments) {
      let token = config.startingToken || void 0;
      let hasNext = true;
      let page;
      while (hasNext) {
        input.nextToken = token;
        input["maxResults"] = config.pageSize;
        if (config.client instanceof SSOClient_1.SSOClient) {
          page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        } else {
          throw new Error("Invalid client, expected SSO | SSOClient");
        }
        yield page;
        const prevToken = token;
        token = page.nextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
      }
      return void 0;
    }
    exports2.paginateListAccounts = paginateListAccounts;
  }
});

// ../../../node_modules/@aws-sdk/client-sso/dist-cjs/pagination/index.js
var require_pagination2 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sso/dist-cjs/pagination/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_Interfaces(), exports2);
    tslib_1.__exportStar(require_ListAccountRolesPaginator(), exports2);
    tslib_1.__exportStar(require_ListAccountsPaginator(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/client-sso/dist-cjs/models/index.js
var require_models = __commonJS({
  "../../../node_modules/@aws-sdk/client-sso/dist-cjs/models/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_models_02(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/client-sso/dist-cjs/index.js
var require_dist_cjs45 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sso/dist-cjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SSOServiceException = void 0;
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_SSOClient(), exports2);
    tslib_1.__exportStar(require_SSO(), exports2);
    tslib_1.__exportStar(require_commands(), exports2);
    tslib_1.__exportStar(require_pagination2(), exports2);
    tslib_1.__exportStar(require_models(), exports2);
    var SSOServiceException_1 = require_SSOServiceException();
    Object.defineProperty(exports2, "SSOServiceException", { enumerable: true, get: function() {
      return SSOServiceException_1.SSOServiceException;
    } });
  }
});

// ../../../node_modules/@aws-sdk/token-providers/dist-cjs/bundle/client-sso-oidc-node.js
var require_client_sso_oidc_node = __commonJS({
  "../../../node_modules/@aws-sdk/token-providers/dist-cjs/bundle/client-sso-oidc-node.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.UnsupportedGrantTypeException = exports2.UnauthorizedClientException = exports2.SlowDownException = exports2.SSOOIDCClient = exports2.InvalidScopeException = exports2.InvalidRequestException = exports2.InvalidClientException = exports2.InternalServerException = exports2.ExpiredTokenException = exports2.CreateTokenCommand = exports2.AuthorizationPendingException = exports2.AccessDeniedException = void 0;
    var middleware_host_header_1 = require_dist_cjs3();
    var middleware_logger_1 = require_dist_cjs4();
    var middleware_recursion_detection_1 = require_dist_cjs5();
    var middleware_user_agent_1 = require_dist_cjs17();
    var config_resolver_1 = require_dist_cjs19();
    var middleware_content_length_1 = require_dist_cjs20();
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_retry_1 = require_dist_cjs35();
    var smithy_client_1 = require_dist_cjs34();
    var resolveClientEndpointParameters = (options) => {
      var _a, _b;
      return {
        ...options,
        useDualstackEndpoint: (_a = options.useDualstackEndpoint) !== null && _a !== void 0 ? _a : false,
        useFipsEndpoint: (_b = options.useFipsEndpoint) !== null && _b !== void 0 ? _b : false,
        defaultSigningName: "awsssooidc"
      };
    };
    var package_default = { version: "3.387.0" };
    var util_user_agent_node_1 = require_dist_cjs40();
    var config_resolver_2 = require_dist_cjs19();
    var hash_node_1 = require_dist_cjs41();
    var middleware_retry_2 = require_dist_cjs35();
    var node_config_provider_1 = require_dist_cjs22();
    var node_http_handler_1 = require_dist_cjs32();
    var util_body_length_node_1 = require_dist_cjs42();
    var util_retry_1 = require_dist_cjs28();
    var smithy_client_2 = require_dist_cjs34();
    var url_parser_1 = require_dist_cjs24();
    var util_base64_1 = require_dist_cjs30();
    var util_utf8_1 = require_dist_cjs10();
    var util_endpoints_1 = require_dist_cjs16();
    var p = "required";
    var q = "fn";
    var r = "argv";
    var s = "ref";
    var a = "PartitionResult";
    var b = "tree";
    var c = "error";
    var d = "endpoint";
    var e = { [p]: false, "type": "String" };
    var f = { [p]: true, "default": false, "type": "Boolean" };
    var g = { [s]: "Endpoint" };
    var h = { [q]: "booleanEquals", [r]: [{ [s]: "UseFIPS" }, true] };
    var i = { [q]: "booleanEquals", [r]: [{ [s]: "UseDualStack" }, true] };
    var j = {};
    var k = { [q]: "booleanEquals", [r]: [true, { [q]: "getAttr", [r]: [{ [s]: a }, "supportsFIPS"] }] };
    var l = { [q]: "booleanEquals", [r]: [true, { [q]: "getAttr", [r]: [{ [s]: a }, "supportsDualStack"] }] };
    var m = [g];
    var n = [h];
    var o = [i];
    var _data = { version: "1.0", parameters: { Region: e, UseDualStack: f, UseFIPS: f, Endpoint: e }, rules: [{ conditions: [{ [q]: "aws.partition", [r]: [{ [s]: "Region" }], assign: a }], type: b, rules: [{ conditions: [{ [q]: "isSet", [r]: m }, { [q]: "parseURL", [r]: m, assign: "url" }], type: b, rules: [{ conditions: n, error: "Invalid Configuration: FIPS and custom endpoint are not supported", type: c }, { type: b, rules: [{ conditions: o, error: "Invalid Configuration: Dualstack and custom endpoint are not supported", type: c }, { endpoint: { url: g, properties: j, headers: j }, type: d }] }] }, { conditions: [h, i], type: b, rules: [{ conditions: [k, l], type: b, rules: [{ endpoint: { url: "https://oidc-fips.{Region}.{PartitionResult#dualStackDnsSuffix}", properties: j, headers: j }, type: d }] }, { error: "FIPS and DualStack are enabled, but this partition does not support one or both", type: c }] }, { conditions: n, type: b, rules: [{ conditions: [k], type: b, rules: [{ type: b, rules: [{ endpoint: { url: "https://oidc-fips.{Region}.{PartitionResult#dnsSuffix}", properties: j, headers: j }, type: d }] }] }, { error: "FIPS is enabled but this partition does not support FIPS", type: c }] }, { conditions: o, type: b, rules: [{ conditions: [l], type: b, rules: [{ endpoint: { url: "https://oidc.{Region}.{PartitionResult#dualStackDnsSuffix}", properties: j, headers: j }, type: d }] }, { error: "DualStack is enabled but this partition does not support DualStack", type: c }] }, { endpoint: { url: "https://oidc.{Region}.{PartitionResult#dnsSuffix}", properties: j, headers: j }, type: d }] }] };
    var ruleSet = _data;
    var defaultEndpointResolver = (endpointParams, context = {}) => {
      return (0, util_endpoints_1.resolveEndpoint)(ruleSet, {
        endpointParams,
        logger: context.logger
      });
    };
    var getRuntimeConfig = (config) => {
      var _a, _b, _c, _d, _e, _f, _g, _h, _j;
      return {
        apiVersion: "2019-06-10",
        base64Decoder: (_a = config === null || config === void 0 ? void 0 : config.base64Decoder) !== null && _a !== void 0 ? _a : util_base64_1.fromBase64,
        base64Encoder: (_b = config === null || config === void 0 ? void 0 : config.base64Encoder) !== null && _b !== void 0 ? _b : util_base64_1.toBase64,
        disableHostPrefix: (_c = config === null || config === void 0 ? void 0 : config.disableHostPrefix) !== null && _c !== void 0 ? _c : false,
        endpointProvider: (_d = config === null || config === void 0 ? void 0 : config.endpointProvider) !== null && _d !== void 0 ? _d : defaultEndpointResolver,
        logger: (_e = config === null || config === void 0 ? void 0 : config.logger) !== null && _e !== void 0 ? _e : new smithy_client_2.NoOpLogger(),
        serviceId: (_f = config === null || config === void 0 ? void 0 : config.serviceId) !== null && _f !== void 0 ? _f : "SSO OIDC",
        urlParser: (_g = config === null || config === void 0 ? void 0 : config.urlParser) !== null && _g !== void 0 ? _g : url_parser_1.parseUrl,
        utf8Decoder: (_h = config === null || config === void 0 ? void 0 : config.utf8Decoder) !== null && _h !== void 0 ? _h : util_utf8_1.fromUtf8,
        utf8Encoder: (_j = config === null || config === void 0 ? void 0 : config.utf8Encoder) !== null && _j !== void 0 ? _j : util_utf8_1.toUtf8
      };
    };
    var smithy_client_3 = require_dist_cjs34();
    var util_defaults_mode_node_1 = require_dist_cjs43();
    var smithy_client_4 = require_dist_cjs34();
    var getRuntimeConfig2 = (config) => {
      var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
      (0, smithy_client_4.emitWarningIfUnsupportedVersion)(process.version);
      const defaultsMode = (0, util_defaults_mode_node_1.resolveDefaultsModeConfig)(config);
      const defaultConfigProvider = () => defaultsMode().then(smithy_client_3.loadConfigsForDefaultMode);
      const clientSharedValues = getRuntimeConfig(config);
      return {
        ...clientSharedValues,
        ...config,
        runtime: "node",
        defaultsMode,
        bodyLengthChecker: (_a = config === null || config === void 0 ? void 0 : config.bodyLengthChecker) !== null && _a !== void 0 ? _a : util_body_length_node_1.calculateBodyLength,
        defaultUserAgentProvider: (_b = config === null || config === void 0 ? void 0 : config.defaultUserAgentProvider) !== null && _b !== void 0 ? _b : (0, util_user_agent_node_1.defaultUserAgent)({ serviceId: clientSharedValues.serviceId, clientVersion: package_default.version }),
        maxAttempts: (_c = config === null || config === void 0 ? void 0 : config.maxAttempts) !== null && _c !== void 0 ? _c : (0, node_config_provider_1.loadConfig)(middleware_retry_2.NODE_MAX_ATTEMPT_CONFIG_OPTIONS),
        region: (_d = config === null || config === void 0 ? void 0 : config.region) !== null && _d !== void 0 ? _d : (0, node_config_provider_1.loadConfig)(config_resolver_2.NODE_REGION_CONFIG_OPTIONS, config_resolver_2.NODE_REGION_CONFIG_FILE_OPTIONS),
        requestHandler: (_e = config === null || config === void 0 ? void 0 : config.requestHandler) !== null && _e !== void 0 ? _e : new node_http_handler_1.NodeHttpHandler(defaultConfigProvider),
        retryMode: (_f = config === null || config === void 0 ? void 0 : config.retryMode) !== null && _f !== void 0 ? _f : (0, node_config_provider_1.loadConfig)({
          ...middleware_retry_2.NODE_RETRY_MODE_CONFIG_OPTIONS,
          default: async () => (await defaultConfigProvider()).retryMode || util_retry_1.DEFAULT_RETRY_MODE
        }),
        sha256: (_g = config === null || config === void 0 ? void 0 : config.sha256) !== null && _g !== void 0 ? _g : hash_node_1.Hash.bind(null, "sha256"),
        streamCollector: (_h = config === null || config === void 0 ? void 0 : config.streamCollector) !== null && _h !== void 0 ? _h : node_http_handler_1.streamCollector,
        useDualstackEndpoint: (_j = config === null || config === void 0 ? void 0 : config.useDualstackEndpoint) !== null && _j !== void 0 ? _j : (0, node_config_provider_1.loadConfig)(config_resolver_2.NODE_USE_DUALSTACK_ENDPOINT_CONFIG_OPTIONS),
        useFipsEndpoint: (_k = config === null || config === void 0 ? void 0 : config.useFipsEndpoint) !== null && _k !== void 0 ? _k : (0, node_config_provider_1.loadConfig)(config_resolver_2.NODE_USE_FIPS_ENDPOINT_CONFIG_OPTIONS)
      };
    };
    var SSOOIDCClient = class extends smithy_client_1.Client {
      constructor(...[configuration]) {
        const _config_0 = getRuntimeConfig2(configuration || {});
        const _config_1 = resolveClientEndpointParameters(_config_0);
        const _config_2 = (0, config_resolver_1.resolveRegionConfig)(_config_1);
        const _config_3 = (0, middleware_endpoint_1.resolveEndpointConfig)(_config_2);
        const _config_4 = (0, middleware_retry_1.resolveRetryConfig)(_config_3);
        const _config_5 = (0, middleware_host_header_1.resolveHostHeaderConfig)(_config_4);
        const _config_6 = (0, middleware_user_agent_1.resolveUserAgentConfig)(_config_5);
        super(_config_6);
        this.config = _config_6;
        this.middlewareStack.use((0, middleware_retry_1.getRetryPlugin)(this.config));
        this.middlewareStack.use((0, middleware_content_length_1.getContentLengthPlugin)(this.config));
        this.middlewareStack.use((0, middleware_host_header_1.getHostHeaderPlugin)(this.config));
        this.middlewareStack.use((0, middleware_logger_1.getLoggerPlugin)(this.config));
        this.middlewareStack.use((0, middleware_recursion_detection_1.getRecursionDetectionPlugin)(this.config));
        this.middlewareStack.use((0, middleware_user_agent_1.getUserAgentPlugin)(this.config));
      }
      destroy() {
        super.destroy();
      }
    };
    exports2.SSOOIDCClient = SSOOIDCClient;
    var smithy_client_5 = require_dist_cjs34();
    var middleware_endpoint_2 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_6 = require_dist_cjs34();
    var protocol_http_1 = require_dist_cjs2();
    var smithy_client_7 = require_dist_cjs34();
    var smithy_client_8 = require_dist_cjs34();
    var SSOOIDCServiceException = class _SSOOIDCServiceException extends smithy_client_8.ServiceException {
      constructor(options) {
        super(options);
        Object.setPrototypeOf(this, _SSOOIDCServiceException.prototype);
      }
    };
    var AccessDeniedException = class _AccessDeniedException extends SSOOIDCServiceException {
      constructor(opts) {
        super({
          name: "AccessDeniedException",
          $fault: "client",
          ...opts
        });
        this.name = "AccessDeniedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _AccessDeniedException.prototype);
        this.error = opts.error;
        this.error_description = opts.error_description;
      }
    };
    exports2.AccessDeniedException = AccessDeniedException;
    var AuthorizationPendingException = class _AuthorizationPendingException extends SSOOIDCServiceException {
      constructor(opts) {
        super({
          name: "AuthorizationPendingException",
          $fault: "client",
          ...opts
        });
        this.name = "AuthorizationPendingException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _AuthorizationPendingException.prototype);
        this.error = opts.error;
        this.error_description = opts.error_description;
      }
    };
    exports2.AuthorizationPendingException = AuthorizationPendingException;
    var ExpiredTokenException = class _ExpiredTokenException extends SSOOIDCServiceException {
      constructor(opts) {
        super({
          name: "ExpiredTokenException",
          $fault: "client",
          ...opts
        });
        this.name = "ExpiredTokenException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _ExpiredTokenException.prototype);
        this.error = opts.error;
        this.error_description = opts.error_description;
      }
    };
    exports2.ExpiredTokenException = ExpiredTokenException;
    var InternalServerException = class _InternalServerException extends SSOOIDCServiceException {
      constructor(opts) {
        super({
          name: "InternalServerException",
          $fault: "server",
          ...opts
        });
        this.name = "InternalServerException";
        this.$fault = "server";
        Object.setPrototypeOf(this, _InternalServerException.prototype);
        this.error = opts.error;
        this.error_description = opts.error_description;
      }
    };
    exports2.InternalServerException = InternalServerException;
    var InvalidClientException = class _InvalidClientException extends SSOOIDCServiceException {
      constructor(opts) {
        super({
          name: "InvalidClientException",
          $fault: "client",
          ...opts
        });
        this.name = "InvalidClientException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _InvalidClientException.prototype);
        this.error = opts.error;
        this.error_description = opts.error_description;
      }
    };
    exports2.InvalidClientException = InvalidClientException;
    var InvalidGrantException = class _InvalidGrantException extends SSOOIDCServiceException {
      constructor(opts) {
        super({
          name: "InvalidGrantException",
          $fault: "client",
          ...opts
        });
        this.name = "InvalidGrantException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _InvalidGrantException.prototype);
        this.error = opts.error;
        this.error_description = opts.error_description;
      }
    };
    var InvalidRequestException = class _InvalidRequestException extends SSOOIDCServiceException {
      constructor(opts) {
        super({
          name: "InvalidRequestException",
          $fault: "client",
          ...opts
        });
        this.name = "InvalidRequestException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _InvalidRequestException.prototype);
        this.error = opts.error;
        this.error_description = opts.error_description;
      }
    };
    exports2.InvalidRequestException = InvalidRequestException;
    var InvalidScopeException = class _InvalidScopeException extends SSOOIDCServiceException {
      constructor(opts) {
        super({
          name: "InvalidScopeException",
          $fault: "client",
          ...opts
        });
        this.name = "InvalidScopeException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _InvalidScopeException.prototype);
        this.error = opts.error;
        this.error_description = opts.error_description;
      }
    };
    exports2.InvalidScopeException = InvalidScopeException;
    var SlowDownException = class _SlowDownException extends SSOOIDCServiceException {
      constructor(opts) {
        super({
          name: "SlowDownException",
          $fault: "client",
          ...opts
        });
        this.name = "SlowDownException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _SlowDownException.prototype);
        this.error = opts.error;
        this.error_description = opts.error_description;
      }
    };
    exports2.SlowDownException = SlowDownException;
    var UnauthorizedClientException = class _UnauthorizedClientException extends SSOOIDCServiceException {
      constructor(opts) {
        super({
          name: "UnauthorizedClientException",
          $fault: "client",
          ...opts
        });
        this.name = "UnauthorizedClientException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _UnauthorizedClientException.prototype);
        this.error = opts.error;
        this.error_description = opts.error_description;
      }
    };
    exports2.UnauthorizedClientException = UnauthorizedClientException;
    var UnsupportedGrantTypeException = class _UnsupportedGrantTypeException extends SSOOIDCServiceException {
      constructor(opts) {
        super({
          name: "UnsupportedGrantTypeException",
          $fault: "client",
          ...opts
        });
        this.name = "UnsupportedGrantTypeException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _UnsupportedGrantTypeException.prototype);
        this.error = opts.error;
        this.error_description = opts.error_description;
      }
    };
    exports2.UnsupportedGrantTypeException = UnsupportedGrantTypeException;
    var InvalidClientMetadataException = class _InvalidClientMetadataException extends SSOOIDCServiceException {
      constructor(opts) {
        super({
          name: "InvalidClientMetadataException",
          $fault: "client",
          ...opts
        });
        this.name = "InvalidClientMetadataException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _InvalidClientMetadataException.prototype);
        this.error = opts.error;
        this.error_description = opts.error_description;
      }
    };
    var se_CreateTokenCommand = async (input, context) => {
      const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
      const headers = {
        "content-type": "application/json"
      };
      const resolvedPath = `${(basePath === null || basePath === void 0 ? void 0 : basePath.endsWith("/")) ? basePath.slice(0, -1) : basePath || ""}/token`;
      let body;
      body = JSON.stringify((0, smithy_client_7.take)(input, {
        clientId: [],
        clientSecret: [],
        code: [],
        deviceCode: [],
        grantType: [],
        redirectUri: [],
        refreshToken: [],
        scope: (_) => (0, smithy_client_7._json)(_)
      }));
      return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body
      });
    };
    var se_RegisterClientCommand = async (input, context) => {
      const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
      const headers = {
        "content-type": "application/json"
      };
      const resolvedPath = `${(basePath === null || basePath === void 0 ? void 0 : basePath.endsWith("/")) ? basePath.slice(0, -1) : basePath || ""}/client/register`;
      let body;
      body = JSON.stringify((0, smithy_client_7.take)(input, {
        clientName: [],
        clientType: [],
        scopes: (_) => (0, smithy_client_7._json)(_)
      }));
      return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body
      });
    };
    var se_StartDeviceAuthorizationCommand = async (input, context) => {
      const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
      const headers = {
        "content-type": "application/json"
      };
      const resolvedPath = `${(basePath === null || basePath === void 0 ? void 0 : basePath.endsWith("/")) ? basePath.slice(0, -1) : basePath || ""}/device_authorization`;
      let body;
      body = JSON.stringify((0, smithy_client_7.take)(input, {
        clientId: [],
        clientSecret: [],
        startUrl: []
      }));
      return new protocol_http_1.HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body
      });
    };
    var de_CreateTokenCommand = async (output, context) => {
      if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CreateTokenCommandError(output, context);
      }
      const contents = (0, smithy_client_7.map)({
        $metadata: deserializeMetadata(output)
      });
      const data = (0, smithy_client_7.expectNonNull)((0, smithy_client_7.expectObject)(await parseBody(output.body, context)), "body");
      const doc = (0, smithy_client_7.take)(data, {
        accessToken: smithy_client_7.expectString,
        expiresIn: smithy_client_7.expectInt32,
        idToken: smithy_client_7.expectString,
        refreshToken: smithy_client_7.expectString,
        tokenType: smithy_client_7.expectString
      });
      Object.assign(contents, doc);
      return contents;
    };
    var de_CreateTokenCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "AccessDeniedException":
        case "com.amazonaws.ssooidc#AccessDeniedException":
          throw await de_AccessDeniedExceptionRes(parsedOutput, context);
        case "AuthorizationPendingException":
        case "com.amazonaws.ssooidc#AuthorizationPendingException":
          throw await de_AuthorizationPendingExceptionRes(parsedOutput, context);
        case "ExpiredTokenException":
        case "com.amazonaws.ssooidc#ExpiredTokenException":
          throw await de_ExpiredTokenExceptionRes(parsedOutput, context);
        case "InternalServerException":
        case "com.amazonaws.ssooidc#InternalServerException":
          throw await de_InternalServerExceptionRes(parsedOutput, context);
        case "InvalidClientException":
        case "com.amazonaws.ssooidc#InvalidClientException":
          throw await de_InvalidClientExceptionRes(parsedOutput, context);
        case "InvalidGrantException":
        case "com.amazonaws.ssooidc#InvalidGrantException":
          throw await de_InvalidGrantExceptionRes(parsedOutput, context);
        case "InvalidRequestException":
        case "com.amazonaws.ssooidc#InvalidRequestException":
          throw await de_InvalidRequestExceptionRes(parsedOutput, context);
        case "InvalidScopeException":
        case "com.amazonaws.ssooidc#InvalidScopeException":
          throw await de_InvalidScopeExceptionRes(parsedOutput, context);
        case "SlowDownException":
        case "com.amazonaws.ssooidc#SlowDownException":
          throw await de_SlowDownExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.ssooidc#UnauthorizedClientException":
          throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        case "UnsupportedGrantTypeException":
        case "com.amazonaws.ssooidc#UnsupportedGrantTypeException":
          throw await de_UnsupportedGrantTypeExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_RegisterClientCommand = async (output, context) => {
      if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_RegisterClientCommandError(output, context);
      }
      const contents = (0, smithy_client_7.map)({
        $metadata: deserializeMetadata(output)
      });
      const data = (0, smithy_client_7.expectNonNull)((0, smithy_client_7.expectObject)(await parseBody(output.body, context)), "body");
      const doc = (0, smithy_client_7.take)(data, {
        authorizationEndpoint: smithy_client_7.expectString,
        clientId: smithy_client_7.expectString,
        clientIdIssuedAt: smithy_client_7.expectLong,
        clientSecret: smithy_client_7.expectString,
        clientSecretExpiresAt: smithy_client_7.expectLong,
        tokenEndpoint: smithy_client_7.expectString
      });
      Object.assign(contents, doc);
      return contents;
    };
    var de_RegisterClientCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "InternalServerException":
        case "com.amazonaws.ssooidc#InternalServerException":
          throw await de_InternalServerExceptionRes(parsedOutput, context);
        case "InvalidClientMetadataException":
        case "com.amazonaws.ssooidc#InvalidClientMetadataException":
          throw await de_InvalidClientMetadataExceptionRes(parsedOutput, context);
        case "InvalidRequestException":
        case "com.amazonaws.ssooidc#InvalidRequestException":
          throw await de_InvalidRequestExceptionRes(parsedOutput, context);
        case "InvalidScopeException":
        case "com.amazonaws.ssooidc#InvalidScopeException":
          throw await de_InvalidScopeExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_StartDeviceAuthorizationCommand = async (output, context) => {
      if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_StartDeviceAuthorizationCommandError(output, context);
      }
      const contents = (0, smithy_client_7.map)({
        $metadata: deserializeMetadata(output)
      });
      const data = (0, smithy_client_7.expectNonNull)((0, smithy_client_7.expectObject)(await parseBody(output.body, context)), "body");
      const doc = (0, smithy_client_7.take)(data, {
        deviceCode: smithy_client_7.expectString,
        expiresIn: smithy_client_7.expectInt32,
        interval: smithy_client_7.expectInt32,
        userCode: smithy_client_7.expectString,
        verificationUri: smithy_client_7.expectString,
        verificationUriComplete: smithy_client_7.expectString
      });
      Object.assign(contents, doc);
      return contents;
    };
    var de_StartDeviceAuthorizationCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "InternalServerException":
        case "com.amazonaws.ssooidc#InternalServerException":
          throw await de_InternalServerExceptionRes(parsedOutput, context);
        case "InvalidClientException":
        case "com.amazonaws.ssooidc#InvalidClientException":
          throw await de_InvalidClientExceptionRes(parsedOutput, context);
        case "InvalidRequestException":
        case "com.amazonaws.ssooidc#InvalidRequestException":
          throw await de_InvalidRequestExceptionRes(parsedOutput, context);
        case "SlowDownException":
        case "com.amazonaws.ssooidc#SlowDownException":
          throw await de_SlowDownExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.ssooidc#UnauthorizedClientException":
          throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var throwDefaultError = (0, smithy_client_7.withBaseException)(SSOOIDCServiceException);
    var de_AccessDeniedExceptionRes = async (parsedOutput, context) => {
      const contents = (0, smithy_client_7.map)({});
      const data = parsedOutput.body;
      const doc = (0, smithy_client_7.take)(data, {
        error: smithy_client_7.expectString,
        error_description: smithy_client_7.expectString
      });
      Object.assign(contents, doc);
      const exception = new AccessDeniedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents
      });
      return (0, smithy_client_7.decorateServiceException)(exception, parsedOutput.body);
    };
    var de_AuthorizationPendingExceptionRes = async (parsedOutput, context) => {
      const contents = (0, smithy_client_7.map)({});
      const data = parsedOutput.body;
      const doc = (0, smithy_client_7.take)(data, {
        error: smithy_client_7.expectString,
        error_description: smithy_client_7.expectString
      });
      Object.assign(contents, doc);
      const exception = new AuthorizationPendingException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents
      });
      return (0, smithy_client_7.decorateServiceException)(exception, parsedOutput.body);
    };
    var de_ExpiredTokenExceptionRes = async (parsedOutput, context) => {
      const contents = (0, smithy_client_7.map)({});
      const data = parsedOutput.body;
      const doc = (0, smithy_client_7.take)(data, {
        error: smithy_client_7.expectString,
        error_description: smithy_client_7.expectString
      });
      Object.assign(contents, doc);
      const exception = new ExpiredTokenException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents
      });
      return (0, smithy_client_7.decorateServiceException)(exception, parsedOutput.body);
    };
    var de_InternalServerExceptionRes = async (parsedOutput, context) => {
      const contents = (0, smithy_client_7.map)({});
      const data = parsedOutput.body;
      const doc = (0, smithy_client_7.take)(data, {
        error: smithy_client_7.expectString,
        error_description: smithy_client_7.expectString
      });
      Object.assign(contents, doc);
      const exception = new InternalServerException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents
      });
      return (0, smithy_client_7.decorateServiceException)(exception, parsedOutput.body);
    };
    var de_InvalidClientExceptionRes = async (parsedOutput, context) => {
      const contents = (0, smithy_client_7.map)({});
      const data = parsedOutput.body;
      const doc = (0, smithy_client_7.take)(data, {
        error: smithy_client_7.expectString,
        error_description: smithy_client_7.expectString
      });
      Object.assign(contents, doc);
      const exception = new InvalidClientException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents
      });
      return (0, smithy_client_7.decorateServiceException)(exception, parsedOutput.body);
    };
    var de_InvalidClientMetadataExceptionRes = async (parsedOutput, context) => {
      const contents = (0, smithy_client_7.map)({});
      const data = parsedOutput.body;
      const doc = (0, smithy_client_7.take)(data, {
        error: smithy_client_7.expectString,
        error_description: smithy_client_7.expectString
      });
      Object.assign(contents, doc);
      const exception = new InvalidClientMetadataException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents
      });
      return (0, smithy_client_7.decorateServiceException)(exception, parsedOutput.body);
    };
    var de_InvalidGrantExceptionRes = async (parsedOutput, context) => {
      const contents = (0, smithy_client_7.map)({});
      const data = parsedOutput.body;
      const doc = (0, smithy_client_7.take)(data, {
        error: smithy_client_7.expectString,
        error_description: smithy_client_7.expectString
      });
      Object.assign(contents, doc);
      const exception = new InvalidGrantException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents
      });
      return (0, smithy_client_7.decorateServiceException)(exception, parsedOutput.body);
    };
    var de_InvalidRequestExceptionRes = async (parsedOutput, context) => {
      const contents = (0, smithy_client_7.map)({});
      const data = parsedOutput.body;
      const doc = (0, smithy_client_7.take)(data, {
        error: smithy_client_7.expectString,
        error_description: smithy_client_7.expectString
      });
      Object.assign(contents, doc);
      const exception = new InvalidRequestException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents
      });
      return (0, smithy_client_7.decorateServiceException)(exception, parsedOutput.body);
    };
    var de_InvalidScopeExceptionRes = async (parsedOutput, context) => {
      const contents = (0, smithy_client_7.map)({});
      const data = parsedOutput.body;
      const doc = (0, smithy_client_7.take)(data, {
        error: smithy_client_7.expectString,
        error_description: smithy_client_7.expectString
      });
      Object.assign(contents, doc);
      const exception = new InvalidScopeException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents
      });
      return (0, smithy_client_7.decorateServiceException)(exception, parsedOutput.body);
    };
    var de_SlowDownExceptionRes = async (parsedOutput, context) => {
      const contents = (0, smithy_client_7.map)({});
      const data = parsedOutput.body;
      const doc = (0, smithy_client_7.take)(data, {
        error: smithy_client_7.expectString,
        error_description: smithy_client_7.expectString
      });
      Object.assign(contents, doc);
      const exception = new SlowDownException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents
      });
      return (0, smithy_client_7.decorateServiceException)(exception, parsedOutput.body);
    };
    var de_UnauthorizedClientExceptionRes = async (parsedOutput, context) => {
      const contents = (0, smithy_client_7.map)({});
      const data = parsedOutput.body;
      const doc = (0, smithy_client_7.take)(data, {
        error: smithy_client_7.expectString,
        error_description: smithy_client_7.expectString
      });
      Object.assign(contents, doc);
      const exception = new UnauthorizedClientException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents
      });
      return (0, smithy_client_7.decorateServiceException)(exception, parsedOutput.body);
    };
    var de_UnsupportedGrantTypeExceptionRes = async (parsedOutput, context) => {
      const contents = (0, smithy_client_7.map)({});
      const data = parsedOutput.body;
      const doc = (0, smithy_client_7.take)(data, {
        error: smithy_client_7.expectString,
        error_description: smithy_client_7.expectString
      });
      Object.assign(contents, doc);
      const exception = new UnsupportedGrantTypeException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents
      });
      return (0, smithy_client_7.decorateServiceException)(exception, parsedOutput.body);
    };
    var deserializeMetadata = (output) => {
      var _a, _b;
      return {
        httpStatusCode: output.statusCode,
        requestId: (_b = (_a = output.headers["x-amzn-requestid"]) !== null && _a !== void 0 ? _a : output.headers["x-amzn-request-id"]) !== null && _b !== void 0 ? _b : output.headers["x-amz-request-id"],
        extendedRequestId: output.headers["x-amz-id-2"],
        cfId: output.headers["x-amz-cf-id"]
      };
    };
    var collectBodyString = (streamBody, context) => (0, smithy_client_7.collectBody)(streamBody, context).then((body) => context.utf8Encoder(body));
    var parseBody = (streamBody, context) => collectBodyString(streamBody, context).then((encoded) => {
      if (encoded.length) {
        return JSON.parse(encoded);
      }
      return {};
    });
    var parseErrorBody = async (errorBody, context) => {
      var _a;
      const value = await parseBody(errorBody, context);
      value.message = (_a = value.message) !== null && _a !== void 0 ? _a : value.Message;
      return value;
    };
    var loadRestJsonErrorCode = (output, data) => {
      const findKey = (object, key) => Object.keys(object).find((k2) => k2.toLowerCase() === key.toLowerCase());
      const sanitizeErrorCode = (rawValue) => {
        let cleanValue = rawValue;
        if (typeof cleanValue === "number") {
          cleanValue = cleanValue.toString();
        }
        if (cleanValue.indexOf(",") >= 0) {
          cleanValue = cleanValue.split(",")[0];
        }
        if (cleanValue.indexOf(":") >= 0) {
          cleanValue = cleanValue.split(":")[0];
        }
        if (cleanValue.indexOf("#") >= 0) {
          cleanValue = cleanValue.split("#")[1];
        }
        return cleanValue;
      };
      const headerKey = findKey(output.headers, "x-amzn-errortype");
      if (headerKey !== void 0) {
        return sanitizeErrorCode(output.headers[headerKey]);
      }
      if (data.code !== void 0) {
        return sanitizeErrorCode(data.code);
      }
      if (data["__type"] !== void 0) {
        return sanitizeErrorCode(data["__type"]);
      }
    };
    var CreateTokenCommand = class _CreateTokenCommand extends smithy_client_6.Command {
      constructor(input) {
        super();
        this.input = input;
      }
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_2.getEndpointPlugin)(configuration, _CreateTokenCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SSOOIDCClient";
        const commandName = "CreateTokenCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: (_) => _
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return se_CreateTokenCommand(input, context);
      }
      deserialize(output, context) {
        return de_CreateTokenCommand(output, context);
      }
    };
    exports2.CreateTokenCommand = CreateTokenCommand;
    var middleware_endpoint_3 = require_dist_cjs26();
    var middleware_serde_2 = require_dist_cjs25();
    var smithy_client_9 = require_dist_cjs34();
    var RegisterClientCommand = class _RegisterClientCommand extends smithy_client_9.Command {
      constructor(input) {
        super();
        this.input = input;
      }
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_2.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_3.getEndpointPlugin)(configuration, _RegisterClientCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SSOOIDCClient";
        const commandName = "RegisterClientCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: (_) => _
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return se_RegisterClientCommand(input, context);
      }
      deserialize(output, context) {
        return de_RegisterClientCommand(output, context);
      }
    };
    var middleware_endpoint_4 = require_dist_cjs26();
    var middleware_serde_3 = require_dist_cjs25();
    var smithy_client_10 = require_dist_cjs34();
    var StartDeviceAuthorizationCommand = class _StartDeviceAuthorizationCommand extends smithy_client_10.Command {
      constructor(input) {
        super();
        this.input = input;
      }
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_3.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_4.getEndpointPlugin)(configuration, _StartDeviceAuthorizationCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SSOOIDCClient";
        const commandName = "StartDeviceAuthorizationCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: (_) => _
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return se_StartDeviceAuthorizationCommand(input, context);
      }
      deserialize(output, context) {
        return de_StartDeviceAuthorizationCommand(output, context);
      }
    };
    var commands = {
      CreateTokenCommand,
      RegisterClientCommand,
      StartDeviceAuthorizationCommand
    };
    var SSOOIDC = class extends SSOOIDCClient {
    };
    (0, smithy_client_5.createAggregatedClient)(commands, SSOOIDC);
  }
});

// ../../../node_modules/@aws-sdk/token-providers/dist-cjs/constants.js
var require_constants2 = __commonJS({
  "../../../node_modules/@aws-sdk/token-providers/dist-cjs/constants.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.REFRESH_MESSAGE = exports2.EXPIRE_WINDOW_MS = void 0;
    exports2.EXPIRE_WINDOW_MS = 5 * 60 * 1e3;
    exports2.REFRESH_MESSAGE = `To refresh this SSO session run 'aws sso login' with the corresponding profile.`;
  }
});

// ../../../node_modules/@aws-sdk/token-providers/dist-cjs/getSsoOidcClient.js
var require_getSsoOidcClient = __commonJS({
  "../../../node_modules/@aws-sdk/token-providers/dist-cjs/getSsoOidcClient.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getSsoOidcClient = void 0;
    var client_sso_oidc_node_1 = require_client_sso_oidc_node();
    var ssoOidcClientsHash = {};
    var getSsoOidcClient = (ssoRegion) => {
      if (ssoOidcClientsHash[ssoRegion]) {
        return ssoOidcClientsHash[ssoRegion];
      }
      const ssoOidcClient = new client_sso_oidc_node_1.SSOOIDCClient({ region: ssoRegion });
      ssoOidcClientsHash[ssoRegion] = ssoOidcClient;
      return ssoOidcClient;
    };
    exports2.getSsoOidcClient = getSsoOidcClient;
  }
});

// ../../../node_modules/@aws-sdk/token-providers/dist-cjs/getNewSsoOidcToken.js
var require_getNewSsoOidcToken = __commonJS({
  "../../../node_modules/@aws-sdk/token-providers/dist-cjs/getNewSsoOidcToken.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getNewSsoOidcToken = void 0;
    var client_sso_oidc_node_1 = require_client_sso_oidc_node();
    var getSsoOidcClient_1 = require_getSsoOidcClient();
    var getNewSsoOidcToken = (ssoToken, ssoRegion) => {
      const ssoOidcClient = (0, getSsoOidcClient_1.getSsoOidcClient)(ssoRegion);
      return ssoOidcClient.send(new client_sso_oidc_node_1.CreateTokenCommand({
        clientId: ssoToken.clientId,
        clientSecret: ssoToken.clientSecret,
        refreshToken: ssoToken.refreshToken,
        grantType: "refresh_token"
      }));
    };
    exports2.getNewSsoOidcToken = getNewSsoOidcToken;
  }
});

// ../../../node_modules/@aws-sdk/token-providers/dist-cjs/validateTokenExpiry.js
var require_validateTokenExpiry = __commonJS({
  "../../../node_modules/@aws-sdk/token-providers/dist-cjs/validateTokenExpiry.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.validateTokenExpiry = void 0;
    var property_provider_1 = require_dist_cjs6();
    var constants_1 = require_constants2();
    var validateTokenExpiry = (token) => {
      if (token.expiration && token.expiration.getTime() < Date.now()) {
        throw new property_provider_1.TokenProviderError(`Token is expired. ${constants_1.REFRESH_MESSAGE}`, false);
      }
    };
    exports2.validateTokenExpiry = validateTokenExpiry;
  }
});

// ../../../node_modules/@aws-sdk/token-providers/dist-cjs/validateTokenKey.js
var require_validateTokenKey = __commonJS({
  "../../../node_modules/@aws-sdk/token-providers/dist-cjs/validateTokenKey.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.validateTokenKey = void 0;
    var property_provider_1 = require_dist_cjs6();
    var constants_1 = require_constants2();
    var validateTokenKey = (key, value, forRefresh = false) => {
      if (typeof value === "undefined") {
        throw new property_provider_1.TokenProviderError(`Value not present for '${key}' in SSO Token${forRefresh ? ". Cannot refresh" : ""}. ${constants_1.REFRESH_MESSAGE}`, false);
      }
    };
    exports2.validateTokenKey = validateTokenKey;
  }
});

// ../../../node_modules/@aws-sdk/token-providers/dist-cjs/writeSSOTokenToFile.js
var require_writeSSOTokenToFile = __commonJS({
  "../../../node_modules/@aws-sdk/token-providers/dist-cjs/writeSSOTokenToFile.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.writeSSOTokenToFile = void 0;
    var shared_ini_file_loader_1 = require_dist_cjs21();
    var fs_1 = require("fs");
    var { writeFile } = fs_1.promises;
    var writeSSOTokenToFile = (id, ssoToken) => {
      const tokenFilepath = (0, shared_ini_file_loader_1.getSSOTokenFilepath)(id);
      const tokenString = JSON.stringify(ssoToken, null, 2);
      return writeFile(tokenFilepath, tokenString);
    };
    exports2.writeSSOTokenToFile = writeSSOTokenToFile;
  }
});

// ../../../node_modules/@aws-sdk/token-providers/dist-cjs/fromSso.js
var require_fromSso = __commonJS({
  "../../../node_modules/@aws-sdk/token-providers/dist-cjs/fromSso.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.fromSso = void 0;
    var property_provider_1 = require_dist_cjs6();
    var shared_ini_file_loader_1 = require_dist_cjs21();
    var constants_1 = require_constants2();
    var getNewSsoOidcToken_1 = require_getNewSsoOidcToken();
    var validateTokenExpiry_1 = require_validateTokenExpiry();
    var validateTokenKey_1 = require_validateTokenKey();
    var writeSSOTokenToFile_1 = require_writeSSOTokenToFile();
    var lastRefreshAttemptTime = /* @__PURE__ */ new Date(0);
    var fromSso = (init = {}) => async () => {
      const profiles = await (0, shared_ini_file_loader_1.parseKnownFiles)(init);
      const profileName = (0, shared_ini_file_loader_1.getProfileName)(init);
      const profile = profiles[profileName];
      if (!profile) {
        throw new property_provider_1.TokenProviderError(`Profile '${profileName}' could not be found in shared credentials file.`, false);
      } else if (!profile["sso_session"]) {
        throw new property_provider_1.TokenProviderError(`Profile '${profileName}' is missing required property 'sso_session'.`);
      }
      const ssoSessionName = profile["sso_session"];
      const ssoSessions = await (0, shared_ini_file_loader_1.loadSsoSessionData)(init);
      const ssoSession = ssoSessions[ssoSessionName];
      if (!ssoSession) {
        throw new property_provider_1.TokenProviderError(`Sso session '${ssoSessionName}' could not be found in shared credentials file.`, false);
      }
      for (const ssoSessionRequiredKey of ["sso_start_url", "sso_region"]) {
        if (!ssoSession[ssoSessionRequiredKey]) {
          throw new property_provider_1.TokenProviderError(`Sso session '${ssoSessionName}' is missing required property '${ssoSessionRequiredKey}'.`, false);
        }
      }
      const ssoStartUrl = ssoSession["sso_start_url"];
      const ssoRegion = ssoSession["sso_region"];
      let ssoToken;
      try {
        ssoToken = await (0, shared_ini_file_loader_1.getSSOTokenFromFile)(ssoSessionName);
      } catch (e) {
        throw new property_provider_1.TokenProviderError(`The SSO session token associated with profile=${profileName} was not found or is invalid. ${constants_1.REFRESH_MESSAGE}`, false);
      }
      (0, validateTokenKey_1.validateTokenKey)("accessToken", ssoToken.accessToken);
      (0, validateTokenKey_1.validateTokenKey)("expiresAt", ssoToken.expiresAt);
      const { accessToken, expiresAt } = ssoToken;
      const existingToken = { token: accessToken, expiration: new Date(expiresAt) };
      if (existingToken.expiration.getTime() - Date.now() > constants_1.EXPIRE_WINDOW_MS) {
        return existingToken;
      }
      if (Date.now() - lastRefreshAttemptTime.getTime() < 30 * 1e3) {
        (0, validateTokenExpiry_1.validateTokenExpiry)(existingToken);
        return existingToken;
      }
      (0, validateTokenKey_1.validateTokenKey)("clientId", ssoToken.clientId, true);
      (0, validateTokenKey_1.validateTokenKey)("clientSecret", ssoToken.clientSecret, true);
      (0, validateTokenKey_1.validateTokenKey)("refreshToken", ssoToken.refreshToken, true);
      try {
        lastRefreshAttemptTime.setTime(Date.now());
        const newSsoOidcToken = await (0, getNewSsoOidcToken_1.getNewSsoOidcToken)(ssoToken, ssoRegion);
        (0, validateTokenKey_1.validateTokenKey)("accessToken", newSsoOidcToken.accessToken);
        (0, validateTokenKey_1.validateTokenKey)("expiresIn", newSsoOidcToken.expiresIn);
        const newTokenExpiration = new Date(Date.now() + newSsoOidcToken.expiresIn * 1e3);
        try {
          await (0, writeSSOTokenToFile_1.writeSSOTokenToFile)(ssoSessionName, {
            ...ssoToken,
            accessToken: newSsoOidcToken.accessToken,
            expiresAt: newTokenExpiration.toISOString(),
            refreshToken: newSsoOidcToken.refreshToken
          });
        } catch (error) {
        }
        return {
          token: newSsoOidcToken.accessToken,
          expiration: newTokenExpiration
        };
      } catch (error) {
        (0, validateTokenExpiry_1.validateTokenExpiry)(existingToken);
        return existingToken;
      }
    };
    exports2.fromSso = fromSso;
  }
});

// ../../../node_modules/@aws-sdk/token-providers/dist-cjs/fromStatic.js
var require_fromStatic = __commonJS({
  "../../../node_modules/@aws-sdk/token-providers/dist-cjs/fromStatic.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.fromStatic = void 0;
    var property_provider_1 = require_dist_cjs6();
    var fromStatic = ({ token }) => async () => {
      if (!token || !token.token) {
        throw new property_provider_1.TokenProviderError(`Please pass a valid token to fromStatic`, false);
      }
      return token;
    };
    exports2.fromStatic = fromStatic;
  }
});

// ../../../node_modules/@aws-sdk/token-providers/dist-cjs/nodeProvider.js
var require_nodeProvider = __commonJS({
  "../../../node_modules/@aws-sdk/token-providers/dist-cjs/nodeProvider.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.nodeProvider = void 0;
    var property_provider_1 = require_dist_cjs6();
    var fromSso_1 = require_fromSso();
    var nodeProvider = (init = {}) => (0, property_provider_1.memoize)((0, property_provider_1.chain)((0, fromSso_1.fromSso)(init), async () => {
      throw new property_provider_1.TokenProviderError("Could not load token from any providers", false);
    }), (token) => token.expiration !== void 0 && token.expiration.getTime() - Date.now() < 3e5, (token) => token.expiration !== void 0);
    exports2.nodeProvider = nodeProvider;
  }
});

// ../../../node_modules/@aws-sdk/token-providers/dist-cjs/index.js
var require_dist_cjs46 = __commonJS({
  "../../../node_modules/@aws-sdk/token-providers/dist-cjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_client_sso_oidc_node(), exports2);
    tslib_1.__exportStar(require_fromSso(), exports2);
    tslib_1.__exportStar(require_fromStatic(), exports2);
    tslib_1.__exportStar(require_nodeProvider(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-sso/dist-cjs/resolveSSOCredentials.js
var require_resolveSSOCredentials = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-sso/dist-cjs/resolveSSOCredentials.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveSSOCredentials = void 0;
    var client_sso_1 = require_dist_cjs45();
    var token_providers_1 = require_dist_cjs46();
    var property_provider_1 = require_dist_cjs6();
    var shared_ini_file_loader_1 = require_dist_cjs21();
    var SHOULD_FAIL_CREDENTIAL_CHAIN = false;
    var resolveSSOCredentials = async ({ ssoStartUrl, ssoSession, ssoAccountId, ssoRegion, ssoRoleName, ssoClient, profile }) => {
      let token;
      const refreshMessage = `To refresh this SSO session run aws sso login with the corresponding profile.`;
      if (ssoSession) {
        try {
          const _token = await (0, token_providers_1.fromSso)({ profile })();
          token = {
            accessToken: _token.token,
            expiresAt: new Date(_token.expiration).toISOString()
          };
        } catch (e) {
          throw new property_provider_1.CredentialsProviderError(e.message, SHOULD_FAIL_CREDENTIAL_CHAIN);
        }
      } else {
        try {
          token = await (0, shared_ini_file_loader_1.getSSOTokenFromFile)(ssoStartUrl);
        } catch (e) {
          throw new property_provider_1.CredentialsProviderError(`The SSO session associated with this profile is invalid. ${refreshMessage}`, SHOULD_FAIL_CREDENTIAL_CHAIN);
        }
      }
      if (new Date(token.expiresAt).getTime() - Date.now() <= 0) {
        throw new property_provider_1.CredentialsProviderError(`The SSO session associated with this profile has expired. ${refreshMessage}`, SHOULD_FAIL_CREDENTIAL_CHAIN);
      }
      const { accessToken } = token;
      const sso = ssoClient || new client_sso_1.SSOClient({ region: ssoRegion });
      let ssoResp;
      try {
        ssoResp = await sso.send(new client_sso_1.GetRoleCredentialsCommand({
          accountId: ssoAccountId,
          roleName: ssoRoleName,
          accessToken
        }));
      } catch (e) {
        throw property_provider_1.CredentialsProviderError.from(e, SHOULD_FAIL_CREDENTIAL_CHAIN);
      }
      const { roleCredentials: { accessKeyId, secretAccessKey, sessionToken, expiration } = {} } = ssoResp;
      if (!accessKeyId || !secretAccessKey || !sessionToken || !expiration) {
        throw new property_provider_1.CredentialsProviderError("SSO returns an invalid temporary credential.", SHOULD_FAIL_CREDENTIAL_CHAIN);
      }
      return { accessKeyId, secretAccessKey, sessionToken, expiration: new Date(expiration) };
    };
    exports2.resolveSSOCredentials = resolveSSOCredentials;
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-sso/dist-cjs/validateSsoProfile.js
var require_validateSsoProfile = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-sso/dist-cjs/validateSsoProfile.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.validateSsoProfile = void 0;
    var property_provider_1 = require_dist_cjs6();
    var validateSsoProfile = (profile) => {
      const { sso_start_url, sso_account_id, sso_region, sso_role_name } = profile;
      if (!sso_start_url || !sso_account_id || !sso_region || !sso_role_name) {
        throw new property_provider_1.CredentialsProviderError(`Profile is configured with invalid SSO credentials. Required parameters "sso_account_id", "sso_region", "sso_role_name", "sso_start_url". Got ${Object.keys(profile).join(", ")}
Reference: https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-sso.html`, false);
      }
      return profile;
    };
    exports2.validateSsoProfile = validateSsoProfile;
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-sso/dist-cjs/fromSSO.js
var require_fromSSO = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-sso/dist-cjs/fromSSO.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.fromSSO = void 0;
    var property_provider_1 = require_dist_cjs6();
    var shared_ini_file_loader_1 = require_dist_cjs21();
    var isSsoProfile_1 = require_isSsoProfile();
    var resolveSSOCredentials_1 = require_resolveSSOCredentials();
    var validateSsoProfile_1 = require_validateSsoProfile();
    var fromSSO = (init = {}) => async () => {
      const { ssoStartUrl, ssoAccountId, ssoRegion, ssoRoleName, ssoClient, ssoSession } = init;
      const profileName = (0, shared_ini_file_loader_1.getProfileName)(init);
      if (!ssoStartUrl && !ssoAccountId && !ssoRegion && !ssoRoleName && !ssoSession) {
        const profiles = await (0, shared_ini_file_loader_1.parseKnownFiles)(init);
        const profile = profiles[profileName];
        if (!profile) {
          throw new property_provider_1.CredentialsProviderError(`Profile ${profileName} was not found.`);
        }
        if (!(0, isSsoProfile_1.isSsoProfile)(profile)) {
          throw new property_provider_1.CredentialsProviderError(`Profile ${profileName} is not configured with SSO credentials.`);
        }
        if (profile === null || profile === void 0 ? void 0 : profile.sso_session) {
          const ssoSessions = await (0, shared_ini_file_loader_1.loadSsoSessionData)(init);
          const session = ssoSessions[profile.sso_session];
          const conflictMsg = ` configurations in profile ${profileName} and sso-session ${profile.sso_session}`;
          if (ssoRegion && ssoRegion !== session.sso_region) {
            throw new property_provider_1.CredentialsProviderError(`Conflicting SSO region` + conflictMsg, false);
          }
          if (ssoStartUrl && ssoStartUrl !== session.sso_start_url) {
            throw new property_provider_1.CredentialsProviderError(`Conflicting SSO start_url` + conflictMsg, false);
          }
          profile.sso_region = session.sso_region;
          profile.sso_start_url = session.sso_start_url;
        }
        const { sso_start_url, sso_account_id, sso_region, sso_role_name, sso_session } = (0, validateSsoProfile_1.validateSsoProfile)(profile);
        return (0, resolveSSOCredentials_1.resolveSSOCredentials)({
          ssoStartUrl: sso_start_url,
          ssoSession: sso_session,
          ssoAccountId: sso_account_id,
          ssoRegion: sso_region,
          ssoRoleName: sso_role_name,
          ssoClient,
          profile: profileName
        });
      } else if (!ssoStartUrl || !ssoAccountId || !ssoRegion || !ssoRoleName) {
        throw new property_provider_1.CredentialsProviderError('Incomplete configuration. The fromSSO() argument hash must include "ssoStartUrl", "ssoAccountId", "ssoRegion", "ssoRoleName"');
      } else {
        return (0, resolveSSOCredentials_1.resolveSSOCredentials)({
          ssoStartUrl,
          ssoSession,
          ssoAccountId,
          ssoRegion,
          ssoRoleName,
          ssoClient,
          profile: profileName
        });
      }
    };
    exports2.fromSSO = fromSSO;
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-sso/dist-cjs/types.js
var require_types2 = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-sso/dist-cjs/types.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-sso/dist-cjs/index.js
var require_dist_cjs47 = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-sso/dist-cjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_fromSSO(), exports2);
    tslib_1.__exportStar(require_isSsoProfile(), exports2);
    tslib_1.__exportStar(require_types2(), exports2);
    tslib_1.__exportStar(require_validateSsoProfile(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-ini/dist-cjs/resolveSsoCredentials.js
var require_resolveSsoCredentials = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-ini/dist-cjs/resolveSsoCredentials.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveSsoCredentials = exports2.isSsoProfile = void 0;
    var credential_provider_sso_1 = require_dist_cjs47();
    var credential_provider_sso_2 = require_dist_cjs47();
    Object.defineProperty(exports2, "isSsoProfile", { enumerable: true, get: function() {
      return credential_provider_sso_2.isSsoProfile;
    } });
    var resolveSsoCredentials = (data) => {
      const { sso_start_url, sso_account_id, sso_session, sso_region, sso_role_name } = (0, credential_provider_sso_1.validateSsoProfile)(data);
      return (0, credential_provider_sso_1.fromSSO)({
        ssoStartUrl: sso_start_url,
        ssoAccountId: sso_account_id,
        ssoSession: sso_session,
        ssoRegion: sso_region,
        ssoRoleName: sso_role_name
      })();
    };
    exports2.resolveSsoCredentials = resolveSsoCredentials;
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-ini/dist-cjs/resolveStaticCredentials.js
var require_resolveStaticCredentials = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-ini/dist-cjs/resolveStaticCredentials.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveStaticCredentials = exports2.isStaticCredsProfile = void 0;
    var isStaticCredsProfile = (arg) => Boolean(arg) && typeof arg === "object" && typeof arg.aws_access_key_id === "string" && typeof arg.aws_secret_access_key === "string" && ["undefined", "string"].indexOf(typeof arg.aws_session_token) > -1;
    exports2.isStaticCredsProfile = isStaticCredsProfile;
    var resolveStaticCredentials = (profile) => Promise.resolve({
      accessKeyId: profile.aws_access_key_id,
      secretAccessKey: profile.aws_secret_access_key,
      sessionToken: profile.aws_session_token
    });
    exports2.resolveStaticCredentials = resolveStaticCredentials;
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-web-identity/dist-cjs/fromWebToken.js
var require_fromWebToken = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-web-identity/dist-cjs/fromWebToken.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.fromWebToken = void 0;
    var property_provider_1 = require_dist_cjs6();
    var fromWebToken = (init) => () => {
      const { roleArn, roleSessionName, webIdentityToken, providerId, policyArns, policy, durationSeconds, roleAssumerWithWebIdentity } = init;
      if (!roleAssumerWithWebIdentity) {
        throw new property_provider_1.CredentialsProviderError(`Role Arn '${roleArn}' needs to be assumed with web identity, but no role assumption callback was provided.`, false);
      }
      return roleAssumerWithWebIdentity({
        RoleArn: roleArn,
        RoleSessionName: roleSessionName !== null && roleSessionName !== void 0 ? roleSessionName : `aws-sdk-js-session-${Date.now()}`,
        WebIdentityToken: webIdentityToken,
        ProviderId: providerId,
        PolicyArns: policyArns,
        Policy: policy,
        DurationSeconds: durationSeconds
      });
    };
    exports2.fromWebToken = fromWebToken;
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-web-identity/dist-cjs/fromTokenFile.js
var require_fromTokenFile = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-web-identity/dist-cjs/fromTokenFile.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.fromTokenFile = void 0;
    var property_provider_1 = require_dist_cjs6();
    var fs_1 = require("fs");
    var fromWebToken_1 = require_fromWebToken();
    var ENV_TOKEN_FILE = "AWS_WEB_IDENTITY_TOKEN_FILE";
    var ENV_ROLE_ARN = "AWS_ROLE_ARN";
    var ENV_ROLE_SESSION_NAME = "AWS_ROLE_SESSION_NAME";
    var fromTokenFile = (init = {}) => async () => {
      var _a, _b, _c;
      const webIdentityTokenFile = (_a = init === null || init === void 0 ? void 0 : init.webIdentityTokenFile) !== null && _a !== void 0 ? _a : process.env[ENV_TOKEN_FILE];
      const roleArn = (_b = init === null || init === void 0 ? void 0 : init.roleArn) !== null && _b !== void 0 ? _b : process.env[ENV_ROLE_ARN];
      const roleSessionName = (_c = init === null || init === void 0 ? void 0 : init.roleSessionName) !== null && _c !== void 0 ? _c : process.env[ENV_ROLE_SESSION_NAME];
      if (!webIdentityTokenFile || !roleArn) {
        throw new property_provider_1.CredentialsProviderError("Web identity configuration not specified");
      }
      return (0, fromWebToken_1.fromWebToken)({
        ...init,
        webIdentityToken: (0, fs_1.readFileSync)(webIdentityTokenFile, { encoding: "ascii" }),
        roleArn,
        roleSessionName
      })();
    };
    exports2.fromTokenFile = fromTokenFile;
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-web-identity/dist-cjs/index.js
var require_dist_cjs48 = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-web-identity/dist-cjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_fromTokenFile(), exports2);
    tslib_1.__exportStar(require_fromWebToken(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-ini/dist-cjs/resolveWebIdentityCredentials.js
var require_resolveWebIdentityCredentials = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-ini/dist-cjs/resolveWebIdentityCredentials.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveWebIdentityCredentials = exports2.isWebIdentityProfile = void 0;
    var credential_provider_web_identity_1 = require_dist_cjs48();
    var isWebIdentityProfile = (arg) => Boolean(arg) && typeof arg === "object" && typeof arg.web_identity_token_file === "string" && typeof arg.role_arn === "string" && ["undefined", "string"].indexOf(typeof arg.role_session_name) > -1;
    exports2.isWebIdentityProfile = isWebIdentityProfile;
    var resolveWebIdentityCredentials = async (profile, options) => (0, credential_provider_web_identity_1.fromTokenFile)({
      webIdentityTokenFile: profile.web_identity_token_file,
      roleArn: profile.role_arn,
      roleSessionName: profile.role_session_name,
      roleAssumerWithWebIdentity: options.roleAssumerWithWebIdentity
    })();
    exports2.resolveWebIdentityCredentials = resolveWebIdentityCredentials;
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-ini/dist-cjs/resolveProfileData.js
var require_resolveProfileData = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-ini/dist-cjs/resolveProfileData.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveProfileData = void 0;
    var property_provider_1 = require_dist_cjs6();
    var resolveAssumeRoleCredentials_1 = require_resolveAssumeRoleCredentials();
    var resolveProcessCredentials_1 = require_resolveProcessCredentials2();
    var resolveSsoCredentials_1 = require_resolveSsoCredentials();
    var resolveStaticCredentials_1 = require_resolveStaticCredentials();
    var resolveWebIdentityCredentials_1 = require_resolveWebIdentityCredentials();
    var resolveProfileData = async (profileName, profiles, options, visitedProfiles = {}) => {
      const data = profiles[profileName];
      if (Object.keys(visitedProfiles).length > 0 && (0, resolveStaticCredentials_1.isStaticCredsProfile)(data)) {
        return (0, resolveStaticCredentials_1.resolveStaticCredentials)(data);
      }
      if ((0, resolveAssumeRoleCredentials_1.isAssumeRoleProfile)(data)) {
        return (0, resolveAssumeRoleCredentials_1.resolveAssumeRoleCredentials)(profileName, profiles, options, visitedProfiles);
      }
      if ((0, resolveStaticCredentials_1.isStaticCredsProfile)(data)) {
        return (0, resolveStaticCredentials_1.resolveStaticCredentials)(data);
      }
      if ((0, resolveWebIdentityCredentials_1.isWebIdentityProfile)(data)) {
        return (0, resolveWebIdentityCredentials_1.resolveWebIdentityCredentials)(data, options);
      }
      if ((0, resolveProcessCredentials_1.isProcessProfile)(data)) {
        return (0, resolveProcessCredentials_1.resolveProcessCredentials)(options, profileName);
      }
      if ((0, resolveSsoCredentials_1.isSsoProfile)(data)) {
        return (0, resolveSsoCredentials_1.resolveSsoCredentials)(data);
      }
      throw new property_provider_1.CredentialsProviderError(`Profile ${profileName} could not be found or parsed in shared credentials file.`);
    };
    exports2.resolveProfileData = resolveProfileData;
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-ini/dist-cjs/fromIni.js
var require_fromIni = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-ini/dist-cjs/fromIni.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.fromIni = void 0;
    var shared_ini_file_loader_1 = require_dist_cjs21();
    var resolveProfileData_1 = require_resolveProfileData();
    var fromIni = (init = {}) => async () => {
      const profiles = await (0, shared_ini_file_loader_1.parseKnownFiles)(init);
      return (0, resolveProfileData_1.resolveProfileData)((0, shared_ini_file_loader_1.getProfileName)(init), profiles, init);
    };
    exports2.fromIni = fromIni;
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-ini/dist-cjs/index.js
var require_dist_cjs49 = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-ini/dist-cjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_fromIni(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-node/dist-cjs/remoteProvider.js
var require_remoteProvider = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-node/dist-cjs/remoteProvider.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.remoteProvider = exports2.ENV_IMDS_DISABLED = void 0;
    var credential_provider_imds_1 = require_dist_cjs38();
    var property_provider_1 = require_dist_cjs6();
    exports2.ENV_IMDS_DISABLED = "AWS_EC2_METADATA_DISABLED";
    var remoteProvider = (init) => {
      if (process.env[credential_provider_imds_1.ENV_CMDS_RELATIVE_URI] || process.env[credential_provider_imds_1.ENV_CMDS_FULL_URI]) {
        return (0, credential_provider_imds_1.fromContainerMetadata)(init);
      }
      if (process.env[exports2.ENV_IMDS_DISABLED]) {
        return async () => {
          throw new property_provider_1.CredentialsProviderError("EC2 Instance Metadata Service access disabled");
        };
      }
      return (0, credential_provider_imds_1.fromInstanceMetadata)(init);
    };
    exports2.remoteProvider = remoteProvider;
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-node/dist-cjs/defaultProvider.js
var require_defaultProvider = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-node/dist-cjs/defaultProvider.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.defaultProvider = void 0;
    var credential_provider_env_1 = require_dist_cjs37();
    var credential_provider_ini_1 = require_dist_cjs49();
    var credential_provider_process_1 = require_dist_cjs39();
    var credential_provider_sso_1 = require_dist_cjs47();
    var credential_provider_web_identity_1 = require_dist_cjs48();
    var property_provider_1 = require_dist_cjs6();
    var shared_ini_file_loader_1 = require_dist_cjs21();
    var remoteProvider_1 = require_remoteProvider();
    var defaultProvider = (init = {}) => (0, property_provider_1.memoize)((0, property_provider_1.chain)(...init.profile || process.env[shared_ini_file_loader_1.ENV_PROFILE] ? [] : [(0, credential_provider_env_1.fromEnv)()], (0, credential_provider_sso_1.fromSSO)(init), (0, credential_provider_ini_1.fromIni)(init), (0, credential_provider_process_1.fromProcess)(init), (0, credential_provider_web_identity_1.fromTokenFile)(init), (0, remoteProvider_1.remoteProvider)(init), async () => {
      throw new property_provider_1.CredentialsProviderError("Could not load credentials from any providers", false);
    }), (credentials) => credentials.expiration !== void 0 && credentials.expiration.getTime() - Date.now() < 3e5, (credentials) => credentials.expiration !== void 0);
    exports2.defaultProvider = defaultProvider;
  }
});

// ../../../node_modules/@aws-sdk/credential-provider-node/dist-cjs/index.js
var require_dist_cjs50 = __commonJS({
  "../../../node_modules/@aws-sdk/credential-provider-node/dist-cjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_defaultProvider(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/client-sts/dist-cjs/endpoint/ruleset.js
var require_ruleset2 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sts/dist-cjs/endpoint/ruleset.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ruleSet = void 0;
    var F = "required";
    var G = "type";
    var H = "fn";
    var I = "argv";
    var J = "ref";
    var a = false;
    var b = true;
    var c = "booleanEquals";
    var d = "tree";
    var e = "stringEquals";
    var f = "sigv4";
    var g = "sts";
    var h = "us-east-1";
    var i = "endpoint";
    var j = "https://sts.{Region}.{PartitionResult#dnsSuffix}";
    var k = "error";
    var l = "getAttr";
    var m = { [F]: false, [G]: "String" };
    var n = { [F]: true, "default": false, [G]: "Boolean" };
    var o = { [J]: "Endpoint" };
    var p = { [H]: "isSet", [I]: [{ [J]: "Region" }] };
    var q = { [J]: "Region" };
    var r = { [H]: "aws.partition", [I]: [q], "assign": "PartitionResult" };
    var s = { [J]: "UseFIPS" };
    var t = { [J]: "UseDualStack" };
    var u = { "url": "https://sts.amazonaws.com", "properties": { "authSchemes": [{ "name": f, "signingName": g, "signingRegion": h }] }, "headers": {} };
    var v = {};
    var w = { "conditions": [{ [H]: e, [I]: [q, "aws-global"] }], [i]: u, [G]: i };
    var x = { [H]: c, [I]: [s, true] };
    var y = { [H]: c, [I]: [t, true] };
    var z = { [H]: c, [I]: [true, { [H]: l, [I]: [{ [J]: "PartitionResult" }, "supportsFIPS"] }] };
    var A = { [J]: "PartitionResult" };
    var B = { [H]: c, [I]: [true, { [H]: l, [I]: [A, "supportsDualStack"] }] };
    var C = [{ [H]: "isSet", [I]: [o] }];
    var D = [x];
    var E = [y];
    var _data = { version: "1.0", parameters: { Region: m, UseDualStack: n, UseFIPS: n, Endpoint: m, UseGlobalEndpoint: n }, rules: [{ conditions: [{ [H]: c, [I]: [{ [J]: "UseGlobalEndpoint" }, b] }, { [H]: "not", [I]: C }, p, r, { [H]: c, [I]: [s, a] }, { [H]: c, [I]: [t, a] }], [G]: d, rules: [{ conditions: [{ [H]: e, [I]: [q, "ap-northeast-1"] }], endpoint: u, [G]: i }, { conditions: [{ [H]: e, [I]: [q, "ap-south-1"] }], endpoint: u, [G]: i }, { conditions: [{ [H]: e, [I]: [q, "ap-southeast-1"] }], endpoint: u, [G]: i }, { conditions: [{ [H]: e, [I]: [q, "ap-southeast-2"] }], endpoint: u, [G]: i }, w, { conditions: [{ [H]: e, [I]: [q, "ca-central-1"] }], endpoint: u, [G]: i }, { conditions: [{ [H]: e, [I]: [q, "eu-central-1"] }], endpoint: u, [G]: i }, { conditions: [{ [H]: e, [I]: [q, "eu-north-1"] }], endpoint: u, [G]: i }, { conditions: [{ [H]: e, [I]: [q, "eu-west-1"] }], endpoint: u, [G]: i }, { conditions: [{ [H]: e, [I]: [q, "eu-west-2"] }], endpoint: u, [G]: i }, { conditions: [{ [H]: e, [I]: [q, "eu-west-3"] }], endpoint: u, [G]: i }, { conditions: [{ [H]: e, [I]: [q, "sa-east-1"] }], endpoint: u, [G]: i }, { conditions: [{ [H]: e, [I]: [q, h] }], endpoint: u, [G]: i }, { conditions: [{ [H]: e, [I]: [q, "us-east-2"] }], endpoint: u, [G]: i }, { conditions: [{ [H]: e, [I]: [q, "us-west-1"] }], endpoint: u, [G]: i }, { conditions: [{ [H]: e, [I]: [q, "us-west-2"] }], endpoint: u, [G]: i }, { endpoint: { url: j, properties: { authSchemes: [{ name: f, signingName: g, signingRegion: "{Region}" }] }, headers: v }, [G]: i }] }, { conditions: C, [G]: d, rules: [{ conditions: D, error: "Invalid Configuration: FIPS and custom endpoint are not supported", [G]: k }, { conditions: E, error: "Invalid Configuration: Dualstack and custom endpoint are not supported", [G]: k }, { endpoint: { url: o, properties: v, headers: v }, [G]: i }] }, { conditions: [p], [G]: d, rules: [{ conditions: [r], [G]: d, rules: [{ conditions: [x, y], [G]: d, rules: [{ conditions: [z, B], [G]: d, rules: [{ endpoint: { url: "https://sts-fips.{Region}.{PartitionResult#dualStackDnsSuffix}", properties: v, headers: v }, [G]: i }] }, { error: "FIPS and DualStack are enabled, but this partition does not support one or both", [G]: k }] }, { conditions: D, [G]: d, rules: [{ conditions: [z], [G]: d, rules: [{ conditions: [{ [H]: e, [I]: ["aws-us-gov", { [H]: l, [I]: [A, "name"] }] }], endpoint: { url: "https://sts.{Region}.amazonaws.com", properties: v, headers: v }, [G]: i }, { endpoint: { url: "https://sts-fips.{Region}.{PartitionResult#dnsSuffix}", properties: v, headers: v }, [G]: i }] }, { error: "FIPS is enabled but this partition does not support FIPS", [G]: k }] }, { conditions: E, [G]: d, rules: [{ conditions: [B], [G]: d, rules: [{ endpoint: { url: "https://sts.{Region}.{PartitionResult#dualStackDnsSuffix}", properties: v, headers: v }, [G]: i }] }, { error: "DualStack is enabled but this partition does not support DualStack", [G]: k }] }, w, { endpoint: { url: j, properties: v, headers: v }, [G]: i }] }] }, { error: "Invalid Configuration: Missing Region", [G]: k }] };
    exports2.ruleSet = _data;
  }
});

// ../../../node_modules/@aws-sdk/client-sts/dist-cjs/endpoint/endpointResolver.js
var require_endpointResolver2 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sts/dist-cjs/endpoint/endpointResolver.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.defaultEndpointResolver = void 0;
    var util_endpoints_1 = require_dist_cjs16();
    var ruleset_1 = require_ruleset2();
    var defaultEndpointResolver = (endpointParams, context = {}) => {
      return (0, util_endpoints_1.resolveEndpoint)(ruleset_1.ruleSet, {
        endpointParams,
        logger: context.logger
      });
    };
    exports2.defaultEndpointResolver = defaultEndpointResolver;
  }
});

// ../../../node_modules/@aws-sdk/client-sts/dist-cjs/runtimeConfig.shared.js
var require_runtimeConfig_shared2 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sts/dist-cjs/runtimeConfig.shared.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getRuntimeConfig = void 0;
    var smithy_client_1 = require_dist_cjs34();
    var url_parser_1 = require_dist_cjs24();
    var util_base64_1 = require_dist_cjs30();
    var util_utf8_1 = require_dist_cjs10();
    var endpointResolver_1 = require_endpointResolver2();
    var getRuntimeConfig = (config) => ({
      apiVersion: "2011-06-15",
      base64Decoder: config?.base64Decoder ?? util_base64_1.fromBase64,
      base64Encoder: config?.base64Encoder ?? util_base64_1.toBase64,
      disableHostPrefix: config?.disableHostPrefix ?? false,
      endpointProvider: config?.endpointProvider ?? endpointResolver_1.defaultEndpointResolver,
      extensions: config?.extensions ?? [],
      logger: config?.logger ?? new smithy_client_1.NoOpLogger(),
      serviceId: config?.serviceId ?? "STS",
      urlParser: config?.urlParser ?? url_parser_1.parseUrl,
      utf8Decoder: config?.utf8Decoder ?? util_utf8_1.fromUtf8,
      utf8Encoder: config?.utf8Encoder ?? util_utf8_1.toUtf8
    });
    exports2.getRuntimeConfig = getRuntimeConfig;
  }
});

// ../../../node_modules/@aws-sdk/client-sts/dist-cjs/runtimeConfig.js
var require_runtimeConfig2 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sts/dist-cjs/runtimeConfig.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getRuntimeConfig = void 0;
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    var package_json_1 = tslib_1.__importDefault(require_package2());
    var defaultStsRoleAssumers_1 = require_defaultStsRoleAssumers();
    var credential_provider_node_1 = require_dist_cjs50();
    var util_user_agent_node_1 = require_dist_cjs40();
    var config_resolver_1 = require_dist_cjs19();
    var hash_node_1 = require_dist_cjs41();
    var middleware_retry_1 = require_dist_cjs35();
    var node_config_provider_1 = require_dist_cjs22();
    var node_http_handler_1 = require_dist_cjs32();
    var util_body_length_node_1 = require_dist_cjs42();
    var util_retry_1 = require_dist_cjs28();
    var runtimeConfig_shared_1 = require_runtimeConfig_shared2();
    var smithy_client_1 = require_dist_cjs34();
    var util_defaults_mode_node_1 = require_dist_cjs43();
    var smithy_client_2 = require_dist_cjs34();
    var getRuntimeConfig = (config) => {
      (0, smithy_client_2.emitWarningIfUnsupportedVersion)(process.version);
      const defaultsMode = (0, util_defaults_mode_node_1.resolveDefaultsModeConfig)(config);
      const defaultConfigProvider = () => defaultsMode().then(smithy_client_1.loadConfigsForDefaultMode);
      const clientSharedValues = (0, runtimeConfig_shared_1.getRuntimeConfig)(config);
      return {
        ...clientSharedValues,
        ...config,
        runtime: "node",
        defaultsMode,
        bodyLengthChecker: config?.bodyLengthChecker ?? util_body_length_node_1.calculateBodyLength,
        credentialDefaultProvider: config?.credentialDefaultProvider ?? (0, defaultStsRoleAssumers_1.decorateDefaultCredentialProvider)(credential_provider_node_1.defaultProvider),
        defaultUserAgentProvider: config?.defaultUserAgentProvider ?? (0, util_user_agent_node_1.defaultUserAgent)({ serviceId: clientSharedValues.serviceId, clientVersion: package_json_1.default.version }),
        maxAttempts: config?.maxAttempts ?? (0, node_config_provider_1.loadConfig)(middleware_retry_1.NODE_MAX_ATTEMPT_CONFIG_OPTIONS),
        region: config?.region ?? (0, node_config_provider_1.loadConfig)(config_resolver_1.NODE_REGION_CONFIG_OPTIONS, config_resolver_1.NODE_REGION_CONFIG_FILE_OPTIONS),
        requestHandler: config?.requestHandler ?? new node_http_handler_1.NodeHttpHandler(defaultConfigProvider),
        retryMode: config?.retryMode ?? (0, node_config_provider_1.loadConfig)({
          ...middleware_retry_1.NODE_RETRY_MODE_CONFIG_OPTIONS,
          default: async () => (await defaultConfigProvider()).retryMode || util_retry_1.DEFAULT_RETRY_MODE
        }),
        sha256: config?.sha256 ?? hash_node_1.Hash.bind(null, "sha256"),
        streamCollector: config?.streamCollector ?? node_http_handler_1.streamCollector,
        useDualstackEndpoint: config?.useDualstackEndpoint ?? (0, node_config_provider_1.loadConfig)(config_resolver_1.NODE_USE_DUALSTACK_ENDPOINT_CONFIG_OPTIONS),
        useFipsEndpoint: config?.useFipsEndpoint ?? (0, node_config_provider_1.loadConfig)(config_resolver_1.NODE_USE_FIPS_ENDPOINT_CONFIG_OPTIONS)
      };
    };
    exports2.getRuntimeConfig = getRuntimeConfig;
  }
});

// ../../../node_modules/@aws-sdk/client-sts/dist-cjs/runtimeExtensions.js
var require_runtimeExtensions2 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sts/dist-cjs/runtimeExtensions.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveRuntimeExtensions = void 0;
    var region_config_resolver_1 = require_dist_cjs44();
    var protocol_http_1 = require_dist_cjs2();
    var smithy_client_1 = require_dist_cjs34();
    var asPartial = (t) => t;
    var resolveRuntimeExtensions = (runtimeConfig, extensions) => {
      const extensionConfiguration = {
        ...asPartial((0, region_config_resolver_1.getAwsRegionExtensionConfiguration)(runtimeConfig)),
        ...asPartial((0, smithy_client_1.getDefaultExtensionConfiguration)(runtimeConfig)),
        ...asPartial((0, protocol_http_1.getHttpHandlerExtensionConfiguration)(runtimeConfig))
      };
      extensions.forEach((extension) => extension.configure(extensionConfiguration));
      return {
        ...runtimeConfig,
        ...(0, region_config_resolver_1.resolveAwsRegionExtensionConfiguration)(extensionConfiguration),
        ...(0, smithy_client_1.resolveDefaultRuntimeConfig)(extensionConfiguration),
        ...(0, protocol_http_1.resolveHttpHandlerRuntimeConfig)(extensionConfiguration)
      };
    };
    exports2.resolveRuntimeExtensions = resolveRuntimeExtensions;
  }
});

// ../../../node_modules/@aws-sdk/client-sts/dist-cjs/STSClient.js
var require_STSClient = __commonJS({
  "../../../node_modules/@aws-sdk/client-sts/dist-cjs/STSClient.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.STSClient = exports2.__Client = void 0;
    var middleware_host_header_1 = require_dist_cjs3();
    var middleware_logger_1 = require_dist_cjs4();
    var middleware_recursion_detection_1 = require_dist_cjs5();
    var middleware_sdk_sts_1 = require_dist_cjs36();
    var middleware_user_agent_1 = require_dist_cjs17();
    var config_resolver_1 = require_dist_cjs19();
    var middleware_content_length_1 = require_dist_cjs20();
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_retry_1 = require_dist_cjs35();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "__Client", { enumerable: true, get: function() {
      return smithy_client_1.Client;
    } });
    var EndpointParameters_1 = require_EndpointParameters2();
    var runtimeConfig_1 = require_runtimeConfig2();
    var runtimeExtensions_1 = require_runtimeExtensions2();
    var STSClient = class _STSClient extends smithy_client_1.Client {
      constructor(...[configuration]) {
        const _config_0 = (0, runtimeConfig_1.getRuntimeConfig)(configuration || {});
        const _config_1 = (0, EndpointParameters_1.resolveClientEndpointParameters)(_config_0);
        const _config_2 = (0, config_resolver_1.resolveRegionConfig)(_config_1);
        const _config_3 = (0, middleware_endpoint_1.resolveEndpointConfig)(_config_2);
        const _config_4 = (0, middleware_retry_1.resolveRetryConfig)(_config_3);
        const _config_5 = (0, middleware_host_header_1.resolveHostHeaderConfig)(_config_4);
        const _config_6 = (0, middleware_sdk_sts_1.resolveStsAuthConfig)(_config_5, { stsClientCtor: _STSClient });
        const _config_7 = (0, middleware_user_agent_1.resolveUserAgentConfig)(_config_6);
        const _config_8 = (0, runtimeExtensions_1.resolveRuntimeExtensions)(_config_7, configuration?.extensions || []);
        super(_config_8);
        this.config = _config_8;
        this.middlewareStack.use((0, middleware_retry_1.getRetryPlugin)(this.config));
        this.middlewareStack.use((0, middleware_content_length_1.getContentLengthPlugin)(this.config));
        this.middlewareStack.use((0, middleware_host_header_1.getHostHeaderPlugin)(this.config));
        this.middlewareStack.use((0, middleware_logger_1.getLoggerPlugin)(this.config));
        this.middlewareStack.use((0, middleware_recursion_detection_1.getRecursionDetectionPlugin)(this.config));
        this.middlewareStack.use((0, middleware_user_agent_1.getUserAgentPlugin)(this.config));
      }
      destroy() {
        super.destroy();
      }
    };
    exports2.STSClient = STSClient;
  }
});

// ../../../node_modules/@aws-sdk/client-sts/dist-cjs/commands/AssumeRoleWithSAMLCommand.js
var require_AssumeRoleWithSAMLCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sts/dist-cjs/commands/AssumeRoleWithSAMLCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.AssumeRoleWithSAMLCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var models_0_1 = require_models_0();
    var Aws_query_1 = require_Aws_query();
    var AssumeRoleWithSAMLCommand = class _AssumeRoleWithSAMLCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseGlobalEndpoint: { type: "builtInParams", name: "useGlobalEndpoint" },
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _AssumeRoleWithSAMLCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "STSClient";
        const commandName = "AssumeRoleWithSAMLCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: models_0_1.AssumeRoleWithSAMLRequestFilterSensitiveLog,
          outputFilterSensitiveLog: models_0_1.AssumeRoleWithSAMLResponseFilterSensitiveLog,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSSecurityTokenServiceV20110615",
            operation: "AssumeRoleWithSAML"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_query_1.se_AssumeRoleWithSAMLCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_query_1.de_AssumeRoleWithSAMLCommand)(output, context);
      }
    };
    exports2.AssumeRoleWithSAMLCommand = AssumeRoleWithSAMLCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sts/dist-cjs/commands/DecodeAuthorizationMessageCommand.js
var require_DecodeAuthorizationMessageCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sts/dist-cjs/commands/DecodeAuthorizationMessageCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DecodeAuthorizationMessageCommand = exports2.$Command = void 0;
    var middleware_signing_1 = require_dist_cjs14();
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var Aws_query_1 = require_Aws_query();
    var DecodeAuthorizationMessageCommand = class _DecodeAuthorizationMessageCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseGlobalEndpoint: { type: "builtInParams", name: "useGlobalEndpoint" },
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _DecodeAuthorizationMessageCommand.getEndpointParameterInstructions()));
        this.middlewareStack.use((0, middleware_signing_1.getAwsAuthPlugin)(configuration));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "STSClient";
        const commandName = "DecodeAuthorizationMessageCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSSecurityTokenServiceV20110615",
            operation: "DecodeAuthorizationMessage"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_query_1.se_DecodeAuthorizationMessageCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_query_1.de_DecodeAuthorizationMessageCommand)(output, context);
      }
    };
    exports2.DecodeAuthorizationMessageCommand = DecodeAuthorizationMessageCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sts/dist-cjs/commands/GetAccessKeyInfoCommand.js
var require_GetAccessKeyInfoCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sts/dist-cjs/commands/GetAccessKeyInfoCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.GetAccessKeyInfoCommand = exports2.$Command = void 0;
    var middleware_signing_1 = require_dist_cjs14();
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var Aws_query_1 = require_Aws_query();
    var GetAccessKeyInfoCommand = class _GetAccessKeyInfoCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseGlobalEndpoint: { type: "builtInParams", name: "useGlobalEndpoint" },
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _GetAccessKeyInfoCommand.getEndpointParameterInstructions()));
        this.middlewareStack.use((0, middleware_signing_1.getAwsAuthPlugin)(configuration));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "STSClient";
        const commandName = "GetAccessKeyInfoCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSSecurityTokenServiceV20110615",
            operation: "GetAccessKeyInfo"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_query_1.se_GetAccessKeyInfoCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_query_1.de_GetAccessKeyInfoCommand)(output, context);
      }
    };
    exports2.GetAccessKeyInfoCommand = GetAccessKeyInfoCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sts/dist-cjs/commands/GetCallerIdentityCommand.js
var require_GetCallerIdentityCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sts/dist-cjs/commands/GetCallerIdentityCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.GetCallerIdentityCommand = exports2.$Command = void 0;
    var middleware_signing_1 = require_dist_cjs14();
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var Aws_query_1 = require_Aws_query();
    var GetCallerIdentityCommand = class _GetCallerIdentityCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseGlobalEndpoint: { type: "builtInParams", name: "useGlobalEndpoint" },
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _GetCallerIdentityCommand.getEndpointParameterInstructions()));
        this.middlewareStack.use((0, middleware_signing_1.getAwsAuthPlugin)(configuration));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "STSClient";
        const commandName = "GetCallerIdentityCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSSecurityTokenServiceV20110615",
            operation: "GetCallerIdentity"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_query_1.se_GetCallerIdentityCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_query_1.de_GetCallerIdentityCommand)(output, context);
      }
    };
    exports2.GetCallerIdentityCommand = GetCallerIdentityCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sts/dist-cjs/commands/GetFederationTokenCommand.js
var require_GetFederationTokenCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sts/dist-cjs/commands/GetFederationTokenCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.GetFederationTokenCommand = exports2.$Command = void 0;
    var middleware_signing_1 = require_dist_cjs14();
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var models_0_1 = require_models_0();
    var Aws_query_1 = require_Aws_query();
    var GetFederationTokenCommand = class _GetFederationTokenCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseGlobalEndpoint: { type: "builtInParams", name: "useGlobalEndpoint" },
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _GetFederationTokenCommand.getEndpointParameterInstructions()));
        this.middlewareStack.use((0, middleware_signing_1.getAwsAuthPlugin)(configuration));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "STSClient";
        const commandName = "GetFederationTokenCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: models_0_1.GetFederationTokenResponseFilterSensitiveLog,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSSecurityTokenServiceV20110615",
            operation: "GetFederationToken"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_query_1.se_GetFederationTokenCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_query_1.de_GetFederationTokenCommand)(output, context);
      }
    };
    exports2.GetFederationTokenCommand = GetFederationTokenCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sts/dist-cjs/commands/GetSessionTokenCommand.js
var require_GetSessionTokenCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sts/dist-cjs/commands/GetSessionTokenCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.GetSessionTokenCommand = exports2.$Command = void 0;
    var middleware_signing_1 = require_dist_cjs14();
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var models_0_1 = require_models_0();
    var Aws_query_1 = require_Aws_query();
    var GetSessionTokenCommand = class _GetSessionTokenCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseGlobalEndpoint: { type: "builtInParams", name: "useGlobalEndpoint" },
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _GetSessionTokenCommand.getEndpointParameterInstructions()));
        this.middlewareStack.use((0, middleware_signing_1.getAwsAuthPlugin)(configuration));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "STSClient";
        const commandName = "GetSessionTokenCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: models_0_1.GetSessionTokenResponseFilterSensitiveLog,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSSecurityTokenServiceV20110615",
            operation: "GetSessionToken"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_query_1.se_GetSessionTokenCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_query_1.de_GetSessionTokenCommand)(output, context);
      }
    };
    exports2.GetSessionTokenCommand = GetSessionTokenCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sts/dist-cjs/STS.js
var require_STS = __commonJS({
  "../../../node_modules/@aws-sdk/client-sts/dist-cjs/STS.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.STS = void 0;
    var smithy_client_1 = require_dist_cjs34();
    var AssumeRoleCommand_1 = require_AssumeRoleCommand();
    var AssumeRoleWithSAMLCommand_1 = require_AssumeRoleWithSAMLCommand();
    var AssumeRoleWithWebIdentityCommand_1 = require_AssumeRoleWithWebIdentityCommand();
    var DecodeAuthorizationMessageCommand_1 = require_DecodeAuthorizationMessageCommand();
    var GetAccessKeyInfoCommand_1 = require_GetAccessKeyInfoCommand();
    var GetCallerIdentityCommand_1 = require_GetCallerIdentityCommand();
    var GetFederationTokenCommand_1 = require_GetFederationTokenCommand();
    var GetSessionTokenCommand_1 = require_GetSessionTokenCommand();
    var STSClient_1 = require_STSClient();
    var commands = {
      AssumeRoleCommand: AssumeRoleCommand_1.AssumeRoleCommand,
      AssumeRoleWithSAMLCommand: AssumeRoleWithSAMLCommand_1.AssumeRoleWithSAMLCommand,
      AssumeRoleWithWebIdentityCommand: AssumeRoleWithWebIdentityCommand_1.AssumeRoleWithWebIdentityCommand,
      DecodeAuthorizationMessageCommand: DecodeAuthorizationMessageCommand_1.DecodeAuthorizationMessageCommand,
      GetAccessKeyInfoCommand: GetAccessKeyInfoCommand_1.GetAccessKeyInfoCommand,
      GetCallerIdentityCommand: GetCallerIdentityCommand_1.GetCallerIdentityCommand,
      GetFederationTokenCommand: GetFederationTokenCommand_1.GetFederationTokenCommand,
      GetSessionTokenCommand: GetSessionTokenCommand_1.GetSessionTokenCommand
    };
    var STS = class extends STSClient_1.STSClient {
    };
    exports2.STS = STS;
    (0, smithy_client_1.createAggregatedClient)(commands, STS);
  }
});

// ../../../node_modules/@aws-sdk/client-sts/dist-cjs/commands/index.js
var require_commands2 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sts/dist-cjs/commands/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_AssumeRoleCommand(), exports2);
    tslib_1.__exportStar(require_AssumeRoleWithSAMLCommand(), exports2);
    tslib_1.__exportStar(require_AssumeRoleWithWebIdentityCommand(), exports2);
    tslib_1.__exportStar(require_DecodeAuthorizationMessageCommand(), exports2);
    tslib_1.__exportStar(require_GetAccessKeyInfoCommand(), exports2);
    tslib_1.__exportStar(require_GetCallerIdentityCommand(), exports2);
    tslib_1.__exportStar(require_GetFederationTokenCommand(), exports2);
    tslib_1.__exportStar(require_GetSessionTokenCommand(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/client-sts/dist-cjs/models/index.js
var require_models2 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sts/dist-cjs/models/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_models_0(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/client-sts/dist-cjs/defaultRoleAssumers.js
var require_defaultRoleAssumers = __commonJS({
  "../../../node_modules/@aws-sdk/client-sts/dist-cjs/defaultRoleAssumers.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.decorateDefaultCredentialProvider = exports2.getDefaultRoleAssumerWithWebIdentity = exports2.getDefaultRoleAssumer = void 0;
    var defaultStsRoleAssumers_1 = require_defaultStsRoleAssumers();
    var STSClient_1 = require_STSClient();
    var getCustomizableStsClientCtor = (baseCtor, customizations) => {
      if (!customizations)
        return baseCtor;
      else
        return class CustomizableSTSClient extends baseCtor {
          constructor(config) {
            super(config);
            for (const customization of customizations) {
              this.middlewareStack.use(customization);
            }
          }
        };
    };
    var getDefaultRoleAssumer = (stsOptions = {}, stsPlugins) => (0, defaultStsRoleAssumers_1.getDefaultRoleAssumer)(stsOptions, getCustomizableStsClientCtor(STSClient_1.STSClient, stsPlugins));
    exports2.getDefaultRoleAssumer = getDefaultRoleAssumer;
    var getDefaultRoleAssumerWithWebIdentity = (stsOptions = {}, stsPlugins) => (0, defaultStsRoleAssumers_1.getDefaultRoleAssumerWithWebIdentity)(stsOptions, getCustomizableStsClientCtor(STSClient_1.STSClient, stsPlugins));
    exports2.getDefaultRoleAssumerWithWebIdentity = getDefaultRoleAssumerWithWebIdentity;
    var decorateDefaultCredentialProvider = (provider) => (input) => provider({
      roleAssumer: (0, exports2.getDefaultRoleAssumer)(input),
      roleAssumerWithWebIdentity: (0, exports2.getDefaultRoleAssumerWithWebIdentity)(input),
      ...input
    });
    exports2.decorateDefaultCredentialProvider = decorateDefaultCredentialProvider;
  }
});

// ../../../node_modules/@aws-sdk/client-sts/dist-cjs/index.js
var require_dist_cjs51 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sts/dist-cjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.STSServiceException = void 0;
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_STSClient(), exports2);
    tslib_1.__exportStar(require_STS(), exports2);
    tslib_1.__exportStar(require_commands2(), exports2);
    tslib_1.__exportStar(require_models2(), exports2);
    tslib_1.__exportStar(require_defaultRoleAssumers(), exports2);
    var STSServiceException_1 = require_STSServiceException();
    Object.defineProperty(exports2, "STSServiceException", { enumerable: true, get: function() {
      return STSServiceException_1.STSServiceException;
    } });
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/endpoint/ruleset.js
var require_ruleset3 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/endpoint/ruleset.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ruleSet = void 0;
    var r = "required";
    var s = "fn";
    var t = "argv";
    var u = "ref";
    var a = "isSet";
    var b = "tree";
    var c = "error";
    var d = "endpoint";
    var e = "PartitionResult";
    var f = { [r]: false, "type": "String" };
    var g = { [r]: true, "default": false, "type": "Boolean" };
    var h = { [u]: "Endpoint" };
    var i = { [s]: "booleanEquals", [t]: [{ [u]: "UseFIPS" }, true] };
    var j = { [s]: "booleanEquals", [t]: [{ [u]: "UseDualStack" }, true] };
    var k = {};
    var l = { [u]: "Region" };
    var m = { [s]: "booleanEquals", [t]: [true, { [s]: "getAttr", [t]: [{ [u]: e }, "supportsFIPS"] }] };
    var n = { [s]: "booleanEquals", [t]: [true, { [s]: "getAttr", [t]: [{ [u]: e }, "supportsDualStack"] }] };
    var o = [i];
    var p = [j];
    var q = [l];
    var _data = { version: "1.0", parameters: { Region: f, UseDualStack: g, UseFIPS: g, Endpoint: f }, rules: [{ conditions: [{ [s]: a, [t]: [h] }], type: b, rules: [{ conditions: o, error: "Invalid Configuration: FIPS and custom endpoint are not supported", type: c }, { conditions: p, error: "Invalid Configuration: Dualstack and custom endpoint are not supported", type: c }, { endpoint: { url: h, properties: k, headers: k }, type: d }] }, { conditions: [{ [s]: a, [t]: q }], type: b, rules: [{ conditions: [{ [s]: "aws.partition", [t]: q, assign: e }], type: b, rules: [{ conditions: [i, j], type: b, rules: [{ conditions: [m, n], type: b, rules: [{ endpoint: { url: "https://states-fips.{Region}.{PartitionResult#dualStackDnsSuffix}", properties: k, headers: k }, type: d }] }, { error: "FIPS and DualStack are enabled, but this partition does not support one or both", type: c }] }, { conditions: o, type: b, rules: [{ conditions: [m], type: b, rules: [{ conditions: [{ [s]: "stringEquals", [t]: [l, "us-gov-west-1"] }], endpoint: { url: "https://states.us-gov-west-1.amazonaws.com", properties: k, headers: k }, type: d }, { endpoint: { url: "https://states-fips.{Region}.{PartitionResult#dnsSuffix}", properties: k, headers: k }, type: d }] }, { error: "FIPS is enabled but this partition does not support FIPS", type: c }] }, { conditions: p, type: b, rules: [{ conditions: [n], type: b, rules: [{ endpoint: { url: "https://states.{Region}.{PartitionResult#dualStackDnsSuffix}", properties: k, headers: k }, type: d }] }, { error: "DualStack is enabled but this partition does not support DualStack", type: c }] }, { endpoint: { url: "https://states.{Region}.{PartitionResult#dnsSuffix}", properties: k, headers: k }, type: d }] }] }, { error: "Invalid Configuration: Missing Region", type: c }] };
    exports2.ruleSet = _data;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/endpoint/endpointResolver.js
var require_endpointResolver3 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/endpoint/endpointResolver.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.defaultEndpointResolver = void 0;
    var util_endpoints_1 = require_dist_cjs16();
    var ruleset_1 = require_ruleset3();
    var defaultEndpointResolver = (endpointParams, context = {}) => {
      return (0, util_endpoints_1.resolveEndpoint)(ruleset_1.ruleSet, {
        endpointParams,
        logger: context.logger
      });
    };
    exports2.defaultEndpointResolver = defaultEndpointResolver;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/runtimeConfig.shared.js
var require_runtimeConfig_shared3 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/runtimeConfig.shared.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getRuntimeConfig = void 0;
    var smithy_client_1 = require_dist_cjs34();
    var url_parser_1 = require_dist_cjs24();
    var util_base64_1 = require_dist_cjs30();
    var util_utf8_1 = require_dist_cjs10();
    var endpointResolver_1 = require_endpointResolver3();
    var getRuntimeConfig = (config) => ({
      apiVersion: "2016-11-23",
      base64Decoder: config?.base64Decoder ?? util_base64_1.fromBase64,
      base64Encoder: config?.base64Encoder ?? util_base64_1.toBase64,
      disableHostPrefix: config?.disableHostPrefix ?? false,
      endpointProvider: config?.endpointProvider ?? endpointResolver_1.defaultEndpointResolver,
      extensions: config?.extensions ?? [],
      logger: config?.logger ?? new smithy_client_1.NoOpLogger(),
      serviceId: config?.serviceId ?? "SFN",
      urlParser: config?.urlParser ?? url_parser_1.parseUrl,
      utf8Decoder: config?.utf8Decoder ?? util_utf8_1.fromUtf8,
      utf8Encoder: config?.utf8Encoder ?? util_utf8_1.toUtf8
    });
    exports2.getRuntimeConfig = getRuntimeConfig;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/runtimeConfig.js
var require_runtimeConfig3 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/runtimeConfig.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getRuntimeConfig = void 0;
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    var package_json_1 = tslib_1.__importDefault(require_package());
    var client_sts_1 = require_dist_cjs51();
    var credential_provider_node_1 = require_dist_cjs50();
    var util_user_agent_node_1 = require_dist_cjs40();
    var config_resolver_1 = require_dist_cjs19();
    var hash_node_1 = require_dist_cjs41();
    var middleware_retry_1 = require_dist_cjs35();
    var node_config_provider_1 = require_dist_cjs22();
    var node_http_handler_1 = require_dist_cjs32();
    var util_body_length_node_1 = require_dist_cjs42();
    var util_retry_1 = require_dist_cjs28();
    var runtimeConfig_shared_1 = require_runtimeConfig_shared3();
    var smithy_client_1 = require_dist_cjs34();
    var util_defaults_mode_node_1 = require_dist_cjs43();
    var smithy_client_2 = require_dist_cjs34();
    var getRuntimeConfig = (config) => {
      (0, smithy_client_2.emitWarningIfUnsupportedVersion)(process.version);
      const defaultsMode = (0, util_defaults_mode_node_1.resolveDefaultsModeConfig)(config);
      const defaultConfigProvider = () => defaultsMode().then(smithy_client_1.loadConfigsForDefaultMode);
      const clientSharedValues = (0, runtimeConfig_shared_1.getRuntimeConfig)(config);
      return {
        ...clientSharedValues,
        ...config,
        runtime: "node",
        defaultsMode,
        bodyLengthChecker: config?.bodyLengthChecker ?? util_body_length_node_1.calculateBodyLength,
        credentialDefaultProvider: config?.credentialDefaultProvider ?? (0, client_sts_1.decorateDefaultCredentialProvider)(credential_provider_node_1.defaultProvider),
        defaultUserAgentProvider: config?.defaultUserAgentProvider ?? (0, util_user_agent_node_1.defaultUserAgent)({ serviceId: clientSharedValues.serviceId, clientVersion: package_json_1.default.version }),
        maxAttempts: config?.maxAttempts ?? (0, node_config_provider_1.loadConfig)(middleware_retry_1.NODE_MAX_ATTEMPT_CONFIG_OPTIONS),
        region: config?.region ?? (0, node_config_provider_1.loadConfig)(config_resolver_1.NODE_REGION_CONFIG_OPTIONS, config_resolver_1.NODE_REGION_CONFIG_FILE_OPTIONS),
        requestHandler: config?.requestHandler ?? new node_http_handler_1.NodeHttpHandler(defaultConfigProvider),
        retryMode: config?.retryMode ?? (0, node_config_provider_1.loadConfig)({
          ...middleware_retry_1.NODE_RETRY_MODE_CONFIG_OPTIONS,
          default: async () => (await defaultConfigProvider()).retryMode || util_retry_1.DEFAULT_RETRY_MODE
        }),
        sha256: config?.sha256 ?? hash_node_1.Hash.bind(null, "sha256"),
        streamCollector: config?.streamCollector ?? node_http_handler_1.streamCollector,
        useDualstackEndpoint: config?.useDualstackEndpoint ?? (0, node_config_provider_1.loadConfig)(config_resolver_1.NODE_USE_DUALSTACK_ENDPOINT_CONFIG_OPTIONS),
        useFipsEndpoint: config?.useFipsEndpoint ?? (0, node_config_provider_1.loadConfig)(config_resolver_1.NODE_USE_FIPS_ENDPOINT_CONFIG_OPTIONS)
      };
    };
    exports2.getRuntimeConfig = getRuntimeConfig;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/runtimeExtensions.js
var require_runtimeExtensions3 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/runtimeExtensions.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveRuntimeExtensions = void 0;
    var region_config_resolver_1 = require_dist_cjs44();
    var protocol_http_1 = require_dist_cjs2();
    var smithy_client_1 = require_dist_cjs34();
    var asPartial = (t) => t;
    var resolveRuntimeExtensions = (runtimeConfig, extensions) => {
      const extensionConfiguration = {
        ...asPartial((0, region_config_resolver_1.getAwsRegionExtensionConfiguration)(runtimeConfig)),
        ...asPartial((0, smithy_client_1.getDefaultExtensionConfiguration)(runtimeConfig)),
        ...asPartial((0, protocol_http_1.getHttpHandlerExtensionConfiguration)(runtimeConfig))
      };
      extensions.forEach((extension) => extension.configure(extensionConfiguration));
      return {
        ...runtimeConfig,
        ...(0, region_config_resolver_1.resolveAwsRegionExtensionConfiguration)(extensionConfiguration),
        ...(0, smithy_client_1.resolveDefaultRuntimeConfig)(extensionConfiguration),
        ...(0, protocol_http_1.resolveHttpHandlerRuntimeConfig)(extensionConfiguration)
      };
    };
    exports2.resolveRuntimeExtensions = resolveRuntimeExtensions;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/SFNClient.js
var require_SFNClient = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/SFNClient.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SFNClient = exports2.__Client = void 0;
    var middleware_host_header_1 = require_dist_cjs3();
    var middleware_logger_1 = require_dist_cjs4();
    var middleware_recursion_detection_1 = require_dist_cjs5();
    var middleware_signing_1 = require_dist_cjs14();
    var middleware_user_agent_1 = require_dist_cjs17();
    var config_resolver_1 = require_dist_cjs19();
    var middleware_content_length_1 = require_dist_cjs20();
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_retry_1 = require_dist_cjs35();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "__Client", { enumerable: true, get: function() {
      return smithy_client_1.Client;
    } });
    var EndpointParameters_1 = require_EndpointParameters();
    var runtimeConfig_1 = require_runtimeConfig3();
    var runtimeExtensions_1 = require_runtimeExtensions3();
    var SFNClient = class extends smithy_client_1.Client {
      constructor(...[configuration]) {
        const _config_0 = (0, runtimeConfig_1.getRuntimeConfig)(configuration || {});
        const _config_1 = (0, EndpointParameters_1.resolveClientEndpointParameters)(_config_0);
        const _config_2 = (0, config_resolver_1.resolveRegionConfig)(_config_1);
        const _config_3 = (0, middleware_endpoint_1.resolveEndpointConfig)(_config_2);
        const _config_4 = (0, middleware_retry_1.resolveRetryConfig)(_config_3);
        const _config_5 = (0, middleware_host_header_1.resolveHostHeaderConfig)(_config_4);
        const _config_6 = (0, middleware_signing_1.resolveAwsAuthConfig)(_config_5);
        const _config_7 = (0, middleware_user_agent_1.resolveUserAgentConfig)(_config_6);
        const _config_8 = (0, runtimeExtensions_1.resolveRuntimeExtensions)(_config_7, configuration?.extensions || []);
        super(_config_8);
        this.config = _config_8;
        this.middlewareStack.use((0, middleware_retry_1.getRetryPlugin)(this.config));
        this.middlewareStack.use((0, middleware_content_length_1.getContentLengthPlugin)(this.config));
        this.middlewareStack.use((0, middleware_host_header_1.getHostHeaderPlugin)(this.config));
        this.middlewareStack.use((0, middleware_logger_1.getLoggerPlugin)(this.config));
        this.middlewareStack.use((0, middleware_recursion_detection_1.getRecursionDetectionPlugin)(this.config));
        this.middlewareStack.use((0, middleware_signing_1.getAwsAuthPlugin)(this.config));
        this.middlewareStack.use((0, middleware_user_agent_1.getUserAgentPlugin)(this.config));
      }
      destroy() {
        super.destroy();
      }
    };
    exports2.SFNClient = SFNClient;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/models/SFNServiceException.js
var require_SFNServiceException = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/models/SFNServiceException.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SFNServiceException = exports2.__ServiceException = void 0;
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "__ServiceException", { enumerable: true, get: function() {
      return smithy_client_1.ServiceException;
    } });
    var SFNServiceException = class _SFNServiceException extends smithy_client_1.ServiceException {
      constructor(options) {
        super(options);
        Object.setPrototypeOf(this, _SFNServiceException.prototype);
      }
    };
    exports2.SFNServiceException = SFNServiceException;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/models/models_0.js
var require_models_03 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/models/models_0.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ExecutionStartedEventDetailsFilterSensitiveLog = exports2.ExecutionFailedEventDetailsFilterSensitiveLog = exports2.ExecutionAbortedEventDetailsFilterSensitiveLog = exports2.GetActivityTaskOutputFilterSensitiveLog = exports2.DescribeStateMachineForExecutionOutputFilterSensitiveLog = exports2.DescribeStateMachineAliasOutputFilterSensitiveLog = exports2.DescribeStateMachineOutputFilterSensitiveLog = exports2.DescribeExecutionOutputFilterSensitiveLog = exports2.CreateStateMachineAliasInputFilterSensitiveLog = exports2.CreateStateMachineInputFilterSensitiveLog = exports2.ActivityTimedOutEventDetailsFilterSensitiveLog = exports2.ActivitySucceededEventDetailsFilterSensitiveLog = exports2.ActivityScheduleFailedEventDetailsFilterSensitiveLog = exports2.ActivityScheduledEventDetailsFilterSensitiveLog = exports2.ActivityFailedEventDetailsFilterSensitiveLog = exports2.MissingRequiredParameter = exports2.SyncExecutionStatus = exports2.InvalidExecutionInput = exports2.ExecutionLimitExceeded = exports2.ExecutionAlreadyExists = exports2.InvalidOutput = exports2.TaskTimedOut = exports2.TaskDoesNotExist = exports2.InvalidToken = exports2.HistoryEventType = exports2.StateMachineDoesNotExist = exports2.StateMachineStatus = exports2.MapRunStatus = exports2.ExecutionDoesNotExist = exports2.ExecutionStatus = exports2.ServiceQuotaExceededException = exports2.ResourceNotFound = exports2.ValidationException = exports2.ValidationExceptionReason = exports2.StateMachineTypeNotSupported = exports2.StateMachineLimitExceeded = exports2.StateMachineDeleting = exports2.StateMachineAlreadyExists = exports2.InvalidTracingConfiguration = exports2.InvalidLoggingConfiguration = exports2.InvalidDefinition = exports2.InvalidArn = exports2.StateMachineType = exports2.LogLevel = exports2.ConflictException = exports2.TooManyTags = exports2.InvalidName = exports2.ActivityWorkerLimitExceeded = exports2.ActivityLimitExceeded = exports2.ActivityDoesNotExist = void 0;
    exports2.UpdateStateMachineAliasInputFilterSensitiveLog = exports2.UpdateStateMachineInputFilterSensitiveLog = exports2.StopExecutionInputFilterSensitiveLog = exports2.StartSyncExecutionOutputFilterSensitiveLog = exports2.StartSyncExecutionInputFilterSensitiveLog = exports2.StartExecutionInputFilterSensitiveLog = exports2.SendTaskSuccessInputFilterSensitiveLog = exports2.SendTaskFailureInputFilterSensitiveLog = exports2.PublishStateMachineVersionInputFilterSensitiveLog = exports2.GetExecutionHistoryOutputFilterSensitiveLog = exports2.HistoryEventFilterSensitiveLog = exports2.TaskTimedOutEventDetailsFilterSensitiveLog = exports2.TaskSucceededEventDetailsFilterSensitiveLog = exports2.TaskSubmittedEventDetailsFilterSensitiveLog = exports2.TaskSubmitFailedEventDetailsFilterSensitiveLog = exports2.TaskStartFailedEventDetailsFilterSensitiveLog = exports2.TaskScheduledEventDetailsFilterSensitiveLog = exports2.TaskFailedEventDetailsFilterSensitiveLog = exports2.StateExitedEventDetailsFilterSensitiveLog = exports2.StateEnteredEventDetailsFilterSensitiveLog = exports2.MapRunFailedEventDetailsFilterSensitiveLog = exports2.LambdaFunctionTimedOutEventDetailsFilterSensitiveLog = exports2.LambdaFunctionSucceededEventDetailsFilterSensitiveLog = exports2.LambdaFunctionStartFailedEventDetailsFilterSensitiveLog = exports2.LambdaFunctionScheduleFailedEventDetailsFilterSensitiveLog = exports2.LambdaFunctionScheduledEventDetailsFilterSensitiveLog = exports2.LambdaFunctionFailedEventDetailsFilterSensitiveLog = exports2.ExecutionTimedOutEventDetailsFilterSensitiveLog = exports2.ExecutionSucceededEventDetailsFilterSensitiveLog = void 0;
    var smithy_client_1 = require_dist_cjs34();
    var SFNServiceException_1 = require_SFNServiceException();
    var ActivityDoesNotExist = class _ActivityDoesNotExist extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "ActivityDoesNotExist",
          $fault: "client",
          ...opts
        });
        this.name = "ActivityDoesNotExist";
        this.$fault = "client";
        Object.setPrototypeOf(this, _ActivityDoesNotExist.prototype);
      }
    };
    exports2.ActivityDoesNotExist = ActivityDoesNotExist;
    var ActivityLimitExceeded = class _ActivityLimitExceeded extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "ActivityLimitExceeded",
          $fault: "client",
          ...opts
        });
        this.name = "ActivityLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, _ActivityLimitExceeded.prototype);
      }
    };
    exports2.ActivityLimitExceeded = ActivityLimitExceeded;
    var ActivityWorkerLimitExceeded = class _ActivityWorkerLimitExceeded extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "ActivityWorkerLimitExceeded",
          $fault: "client",
          ...opts
        });
        this.name = "ActivityWorkerLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, _ActivityWorkerLimitExceeded.prototype);
      }
    };
    exports2.ActivityWorkerLimitExceeded = ActivityWorkerLimitExceeded;
    var InvalidName = class _InvalidName extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "InvalidName",
          $fault: "client",
          ...opts
        });
        this.name = "InvalidName";
        this.$fault = "client";
        Object.setPrototypeOf(this, _InvalidName.prototype);
      }
    };
    exports2.InvalidName = InvalidName;
    var TooManyTags = class _TooManyTags extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "TooManyTags",
          $fault: "client",
          ...opts
        });
        this.name = "TooManyTags";
        this.$fault = "client";
        Object.setPrototypeOf(this, _TooManyTags.prototype);
        this.resourceName = opts.resourceName;
      }
    };
    exports2.TooManyTags = TooManyTags;
    var ConflictException = class _ConflictException extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "ConflictException",
          $fault: "client",
          ...opts
        });
        this.name = "ConflictException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _ConflictException.prototype);
      }
    };
    exports2.ConflictException = ConflictException;
    exports2.LogLevel = {
      ALL: "ALL",
      ERROR: "ERROR",
      FATAL: "FATAL",
      OFF: "OFF"
    };
    exports2.StateMachineType = {
      EXPRESS: "EXPRESS",
      STANDARD: "STANDARD"
    };
    var InvalidArn = class _InvalidArn extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "InvalidArn",
          $fault: "client",
          ...opts
        });
        this.name = "InvalidArn";
        this.$fault = "client";
        Object.setPrototypeOf(this, _InvalidArn.prototype);
      }
    };
    exports2.InvalidArn = InvalidArn;
    var InvalidDefinition = class _InvalidDefinition extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "InvalidDefinition",
          $fault: "client",
          ...opts
        });
        this.name = "InvalidDefinition";
        this.$fault = "client";
        Object.setPrototypeOf(this, _InvalidDefinition.prototype);
      }
    };
    exports2.InvalidDefinition = InvalidDefinition;
    var InvalidLoggingConfiguration = class _InvalidLoggingConfiguration extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "InvalidLoggingConfiguration",
          $fault: "client",
          ...opts
        });
        this.name = "InvalidLoggingConfiguration";
        this.$fault = "client";
        Object.setPrototypeOf(this, _InvalidLoggingConfiguration.prototype);
      }
    };
    exports2.InvalidLoggingConfiguration = InvalidLoggingConfiguration;
    var InvalidTracingConfiguration = class _InvalidTracingConfiguration extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "InvalidTracingConfiguration",
          $fault: "client",
          ...opts
        });
        this.name = "InvalidTracingConfiguration";
        this.$fault = "client";
        Object.setPrototypeOf(this, _InvalidTracingConfiguration.prototype);
      }
    };
    exports2.InvalidTracingConfiguration = InvalidTracingConfiguration;
    var StateMachineAlreadyExists = class _StateMachineAlreadyExists extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "StateMachineAlreadyExists",
          $fault: "client",
          ...opts
        });
        this.name = "StateMachineAlreadyExists";
        this.$fault = "client";
        Object.setPrototypeOf(this, _StateMachineAlreadyExists.prototype);
      }
    };
    exports2.StateMachineAlreadyExists = StateMachineAlreadyExists;
    var StateMachineDeleting = class _StateMachineDeleting extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "StateMachineDeleting",
          $fault: "client",
          ...opts
        });
        this.name = "StateMachineDeleting";
        this.$fault = "client";
        Object.setPrototypeOf(this, _StateMachineDeleting.prototype);
      }
    };
    exports2.StateMachineDeleting = StateMachineDeleting;
    var StateMachineLimitExceeded = class _StateMachineLimitExceeded extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "StateMachineLimitExceeded",
          $fault: "client",
          ...opts
        });
        this.name = "StateMachineLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, _StateMachineLimitExceeded.prototype);
      }
    };
    exports2.StateMachineLimitExceeded = StateMachineLimitExceeded;
    var StateMachineTypeNotSupported = class _StateMachineTypeNotSupported extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "StateMachineTypeNotSupported",
          $fault: "client",
          ...opts
        });
        this.name = "StateMachineTypeNotSupported";
        this.$fault = "client";
        Object.setPrototypeOf(this, _StateMachineTypeNotSupported.prototype);
      }
    };
    exports2.StateMachineTypeNotSupported = StateMachineTypeNotSupported;
    exports2.ValidationExceptionReason = {
      API_DOES_NOT_SUPPORT_LABELED_ARNS: "API_DOES_NOT_SUPPORT_LABELED_ARNS",
      CANNOT_UPDATE_COMPLETED_MAP_RUN: "CANNOT_UPDATE_COMPLETED_MAP_RUN",
      INVALID_ROUTING_CONFIGURATION: "INVALID_ROUTING_CONFIGURATION",
      MISSING_REQUIRED_PARAMETER: "MISSING_REQUIRED_PARAMETER"
    };
    var ValidationException = class _ValidationException extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "ValidationException",
          $fault: "client",
          ...opts
        });
        this.name = "ValidationException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _ValidationException.prototype);
        this.reason = opts.reason;
      }
    };
    exports2.ValidationException = ValidationException;
    var ResourceNotFound = class _ResourceNotFound extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "ResourceNotFound",
          $fault: "client",
          ...opts
        });
        this.name = "ResourceNotFound";
        this.$fault = "client";
        Object.setPrototypeOf(this, _ResourceNotFound.prototype);
        this.resourceName = opts.resourceName;
      }
    };
    exports2.ResourceNotFound = ResourceNotFound;
    var ServiceQuotaExceededException = class _ServiceQuotaExceededException extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "ServiceQuotaExceededException",
          $fault: "client",
          ...opts
        });
        this.name = "ServiceQuotaExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, _ServiceQuotaExceededException.prototype);
      }
    };
    exports2.ServiceQuotaExceededException = ServiceQuotaExceededException;
    exports2.ExecutionStatus = {
      ABORTED: "ABORTED",
      FAILED: "FAILED",
      RUNNING: "RUNNING",
      SUCCEEDED: "SUCCEEDED",
      TIMED_OUT: "TIMED_OUT"
    };
    var ExecutionDoesNotExist = class _ExecutionDoesNotExist extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "ExecutionDoesNotExist",
          $fault: "client",
          ...opts
        });
        this.name = "ExecutionDoesNotExist";
        this.$fault = "client";
        Object.setPrototypeOf(this, _ExecutionDoesNotExist.prototype);
      }
    };
    exports2.ExecutionDoesNotExist = ExecutionDoesNotExist;
    exports2.MapRunStatus = {
      ABORTED: "ABORTED",
      FAILED: "FAILED",
      RUNNING: "RUNNING",
      SUCCEEDED: "SUCCEEDED"
    };
    exports2.StateMachineStatus = {
      ACTIVE: "ACTIVE",
      DELETING: "DELETING"
    };
    var StateMachineDoesNotExist = class _StateMachineDoesNotExist extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "StateMachineDoesNotExist",
          $fault: "client",
          ...opts
        });
        this.name = "StateMachineDoesNotExist";
        this.$fault = "client";
        Object.setPrototypeOf(this, _StateMachineDoesNotExist.prototype);
      }
    };
    exports2.StateMachineDoesNotExist = StateMachineDoesNotExist;
    exports2.HistoryEventType = {
      ActivityFailed: "ActivityFailed",
      ActivityScheduleFailed: "ActivityScheduleFailed",
      ActivityScheduled: "ActivityScheduled",
      ActivityStarted: "ActivityStarted",
      ActivitySucceeded: "ActivitySucceeded",
      ActivityTimedOut: "ActivityTimedOut",
      ChoiceStateEntered: "ChoiceStateEntered",
      ChoiceStateExited: "ChoiceStateExited",
      ExecutionAborted: "ExecutionAborted",
      ExecutionFailed: "ExecutionFailed",
      ExecutionStarted: "ExecutionStarted",
      ExecutionSucceeded: "ExecutionSucceeded",
      ExecutionTimedOut: "ExecutionTimedOut",
      FailStateEntered: "FailStateEntered",
      LambdaFunctionFailed: "LambdaFunctionFailed",
      LambdaFunctionScheduleFailed: "LambdaFunctionScheduleFailed",
      LambdaFunctionScheduled: "LambdaFunctionScheduled",
      LambdaFunctionStartFailed: "LambdaFunctionStartFailed",
      LambdaFunctionStarted: "LambdaFunctionStarted",
      LambdaFunctionSucceeded: "LambdaFunctionSucceeded",
      LambdaFunctionTimedOut: "LambdaFunctionTimedOut",
      MapIterationAborted: "MapIterationAborted",
      MapIterationFailed: "MapIterationFailed",
      MapIterationStarted: "MapIterationStarted",
      MapIterationSucceeded: "MapIterationSucceeded",
      MapRunAborted: "MapRunAborted",
      MapRunFailed: "MapRunFailed",
      MapRunStarted: "MapRunStarted",
      MapRunSucceeded: "MapRunSucceeded",
      MapStateAborted: "MapStateAborted",
      MapStateEntered: "MapStateEntered",
      MapStateExited: "MapStateExited",
      MapStateFailed: "MapStateFailed",
      MapStateStarted: "MapStateStarted",
      MapStateSucceeded: "MapStateSucceeded",
      ParallelStateAborted: "ParallelStateAborted",
      ParallelStateEntered: "ParallelStateEntered",
      ParallelStateExited: "ParallelStateExited",
      ParallelStateFailed: "ParallelStateFailed",
      ParallelStateStarted: "ParallelStateStarted",
      ParallelStateSucceeded: "ParallelStateSucceeded",
      PassStateEntered: "PassStateEntered",
      PassStateExited: "PassStateExited",
      SucceedStateEntered: "SucceedStateEntered",
      SucceedStateExited: "SucceedStateExited",
      TaskFailed: "TaskFailed",
      TaskScheduled: "TaskScheduled",
      TaskStartFailed: "TaskStartFailed",
      TaskStarted: "TaskStarted",
      TaskStateAborted: "TaskStateAborted",
      TaskStateEntered: "TaskStateEntered",
      TaskStateExited: "TaskStateExited",
      TaskSubmitFailed: "TaskSubmitFailed",
      TaskSubmitted: "TaskSubmitted",
      TaskSucceeded: "TaskSucceeded",
      TaskTimedOut: "TaskTimedOut",
      WaitStateAborted: "WaitStateAborted",
      WaitStateEntered: "WaitStateEntered",
      WaitStateExited: "WaitStateExited"
    };
    var InvalidToken = class _InvalidToken extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "InvalidToken",
          $fault: "client",
          ...opts
        });
        this.name = "InvalidToken";
        this.$fault = "client";
        Object.setPrototypeOf(this, _InvalidToken.prototype);
      }
    };
    exports2.InvalidToken = InvalidToken;
    var TaskDoesNotExist = class _TaskDoesNotExist extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "TaskDoesNotExist",
          $fault: "client",
          ...opts
        });
        this.name = "TaskDoesNotExist";
        this.$fault = "client";
        Object.setPrototypeOf(this, _TaskDoesNotExist.prototype);
      }
    };
    exports2.TaskDoesNotExist = TaskDoesNotExist;
    var TaskTimedOut = class _TaskTimedOut extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "TaskTimedOut",
          $fault: "client",
          ...opts
        });
        this.name = "TaskTimedOut";
        this.$fault = "client";
        Object.setPrototypeOf(this, _TaskTimedOut.prototype);
      }
    };
    exports2.TaskTimedOut = TaskTimedOut;
    var InvalidOutput = class _InvalidOutput extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "InvalidOutput",
          $fault: "client",
          ...opts
        });
        this.name = "InvalidOutput";
        this.$fault = "client";
        Object.setPrototypeOf(this, _InvalidOutput.prototype);
      }
    };
    exports2.InvalidOutput = InvalidOutput;
    var ExecutionAlreadyExists = class _ExecutionAlreadyExists extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "ExecutionAlreadyExists",
          $fault: "client",
          ...opts
        });
        this.name = "ExecutionAlreadyExists";
        this.$fault = "client";
        Object.setPrototypeOf(this, _ExecutionAlreadyExists.prototype);
      }
    };
    exports2.ExecutionAlreadyExists = ExecutionAlreadyExists;
    var ExecutionLimitExceeded = class _ExecutionLimitExceeded extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "ExecutionLimitExceeded",
          $fault: "client",
          ...opts
        });
        this.name = "ExecutionLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, _ExecutionLimitExceeded.prototype);
      }
    };
    exports2.ExecutionLimitExceeded = ExecutionLimitExceeded;
    var InvalidExecutionInput = class _InvalidExecutionInput extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "InvalidExecutionInput",
          $fault: "client",
          ...opts
        });
        this.name = "InvalidExecutionInput";
        this.$fault = "client";
        Object.setPrototypeOf(this, _InvalidExecutionInput.prototype);
      }
    };
    exports2.InvalidExecutionInput = InvalidExecutionInput;
    exports2.SyncExecutionStatus = {
      FAILED: "FAILED",
      SUCCEEDED: "SUCCEEDED",
      TIMED_OUT: "TIMED_OUT"
    };
    var MissingRequiredParameter = class _MissingRequiredParameter extends SFNServiceException_1.SFNServiceException {
      constructor(opts) {
        super({
          name: "MissingRequiredParameter",
          $fault: "client",
          ...opts
        });
        this.name = "MissingRequiredParameter";
        this.$fault = "client";
        Object.setPrototypeOf(this, _MissingRequiredParameter.prototype);
      }
    };
    exports2.MissingRequiredParameter = MissingRequiredParameter;
    var ActivityFailedEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.error && { error: smithy_client_1.SENSITIVE_STRING },
      ...obj.cause && { cause: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.ActivityFailedEventDetailsFilterSensitiveLog = ActivityFailedEventDetailsFilterSensitiveLog;
    var ActivityScheduledEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.input && { input: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.ActivityScheduledEventDetailsFilterSensitiveLog = ActivityScheduledEventDetailsFilterSensitiveLog;
    var ActivityScheduleFailedEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.error && { error: smithy_client_1.SENSITIVE_STRING },
      ...obj.cause && { cause: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.ActivityScheduleFailedEventDetailsFilterSensitiveLog = ActivityScheduleFailedEventDetailsFilterSensitiveLog;
    var ActivitySucceededEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.output && { output: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.ActivitySucceededEventDetailsFilterSensitiveLog = ActivitySucceededEventDetailsFilterSensitiveLog;
    var ActivityTimedOutEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.error && { error: smithy_client_1.SENSITIVE_STRING },
      ...obj.cause && { cause: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.ActivityTimedOutEventDetailsFilterSensitiveLog = ActivityTimedOutEventDetailsFilterSensitiveLog;
    var CreateStateMachineInputFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.definition && { definition: smithy_client_1.SENSITIVE_STRING },
      ...obj.versionDescription && { versionDescription: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.CreateStateMachineInputFilterSensitiveLog = CreateStateMachineInputFilterSensitiveLog;
    var CreateStateMachineAliasInputFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.description && { description: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.CreateStateMachineAliasInputFilterSensitiveLog = CreateStateMachineAliasInputFilterSensitiveLog;
    var DescribeExecutionOutputFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.input && { input: smithy_client_1.SENSITIVE_STRING },
      ...obj.output && { output: smithy_client_1.SENSITIVE_STRING },
      ...obj.error && { error: smithy_client_1.SENSITIVE_STRING },
      ...obj.cause && { cause: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.DescribeExecutionOutputFilterSensitiveLog = DescribeExecutionOutputFilterSensitiveLog;
    var DescribeStateMachineOutputFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.definition && { definition: smithy_client_1.SENSITIVE_STRING },
      ...obj.description && { description: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.DescribeStateMachineOutputFilterSensitiveLog = DescribeStateMachineOutputFilterSensitiveLog;
    var DescribeStateMachineAliasOutputFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.description && { description: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.DescribeStateMachineAliasOutputFilterSensitiveLog = DescribeStateMachineAliasOutputFilterSensitiveLog;
    var DescribeStateMachineForExecutionOutputFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.definition && { definition: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.DescribeStateMachineForExecutionOutputFilterSensitiveLog = DescribeStateMachineForExecutionOutputFilterSensitiveLog;
    var GetActivityTaskOutputFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.input && { input: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.GetActivityTaskOutputFilterSensitiveLog = GetActivityTaskOutputFilterSensitiveLog;
    var ExecutionAbortedEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.error && { error: smithy_client_1.SENSITIVE_STRING },
      ...obj.cause && { cause: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.ExecutionAbortedEventDetailsFilterSensitiveLog = ExecutionAbortedEventDetailsFilterSensitiveLog;
    var ExecutionFailedEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.error && { error: smithy_client_1.SENSITIVE_STRING },
      ...obj.cause && { cause: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.ExecutionFailedEventDetailsFilterSensitiveLog = ExecutionFailedEventDetailsFilterSensitiveLog;
    var ExecutionStartedEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.input && { input: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.ExecutionStartedEventDetailsFilterSensitiveLog = ExecutionStartedEventDetailsFilterSensitiveLog;
    var ExecutionSucceededEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.output && { output: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.ExecutionSucceededEventDetailsFilterSensitiveLog = ExecutionSucceededEventDetailsFilterSensitiveLog;
    var ExecutionTimedOutEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.error && { error: smithy_client_1.SENSITIVE_STRING },
      ...obj.cause && { cause: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.ExecutionTimedOutEventDetailsFilterSensitiveLog = ExecutionTimedOutEventDetailsFilterSensitiveLog;
    var LambdaFunctionFailedEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.error && { error: smithy_client_1.SENSITIVE_STRING },
      ...obj.cause && { cause: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.LambdaFunctionFailedEventDetailsFilterSensitiveLog = LambdaFunctionFailedEventDetailsFilterSensitiveLog;
    var LambdaFunctionScheduledEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.input && { input: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.LambdaFunctionScheduledEventDetailsFilterSensitiveLog = LambdaFunctionScheduledEventDetailsFilterSensitiveLog;
    var LambdaFunctionScheduleFailedEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.error && { error: smithy_client_1.SENSITIVE_STRING },
      ...obj.cause && { cause: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.LambdaFunctionScheduleFailedEventDetailsFilterSensitiveLog = LambdaFunctionScheduleFailedEventDetailsFilterSensitiveLog;
    var LambdaFunctionStartFailedEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.error && { error: smithy_client_1.SENSITIVE_STRING },
      ...obj.cause && { cause: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.LambdaFunctionStartFailedEventDetailsFilterSensitiveLog = LambdaFunctionStartFailedEventDetailsFilterSensitiveLog;
    var LambdaFunctionSucceededEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.output && { output: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.LambdaFunctionSucceededEventDetailsFilterSensitiveLog = LambdaFunctionSucceededEventDetailsFilterSensitiveLog;
    var LambdaFunctionTimedOutEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.error && { error: smithy_client_1.SENSITIVE_STRING },
      ...obj.cause && { cause: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.LambdaFunctionTimedOutEventDetailsFilterSensitiveLog = LambdaFunctionTimedOutEventDetailsFilterSensitiveLog;
    var MapRunFailedEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.error && { error: smithy_client_1.SENSITIVE_STRING },
      ...obj.cause && { cause: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.MapRunFailedEventDetailsFilterSensitiveLog = MapRunFailedEventDetailsFilterSensitiveLog;
    var StateEnteredEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.input && { input: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.StateEnteredEventDetailsFilterSensitiveLog = StateEnteredEventDetailsFilterSensitiveLog;
    var StateExitedEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.output && { output: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.StateExitedEventDetailsFilterSensitiveLog = StateExitedEventDetailsFilterSensitiveLog;
    var TaskFailedEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.error && { error: smithy_client_1.SENSITIVE_STRING },
      ...obj.cause && { cause: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.TaskFailedEventDetailsFilterSensitiveLog = TaskFailedEventDetailsFilterSensitiveLog;
    var TaskScheduledEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.parameters && { parameters: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.TaskScheduledEventDetailsFilterSensitiveLog = TaskScheduledEventDetailsFilterSensitiveLog;
    var TaskStartFailedEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.error && { error: smithy_client_1.SENSITIVE_STRING },
      ...obj.cause && { cause: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.TaskStartFailedEventDetailsFilterSensitiveLog = TaskStartFailedEventDetailsFilterSensitiveLog;
    var TaskSubmitFailedEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.error && { error: smithy_client_1.SENSITIVE_STRING },
      ...obj.cause && { cause: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.TaskSubmitFailedEventDetailsFilterSensitiveLog = TaskSubmitFailedEventDetailsFilterSensitiveLog;
    var TaskSubmittedEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.output && { output: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.TaskSubmittedEventDetailsFilterSensitiveLog = TaskSubmittedEventDetailsFilterSensitiveLog;
    var TaskSucceededEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.output && { output: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.TaskSucceededEventDetailsFilterSensitiveLog = TaskSucceededEventDetailsFilterSensitiveLog;
    var TaskTimedOutEventDetailsFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.error && { error: smithy_client_1.SENSITIVE_STRING },
      ...obj.cause && { cause: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.TaskTimedOutEventDetailsFilterSensitiveLog = TaskTimedOutEventDetailsFilterSensitiveLog;
    var HistoryEventFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.activityFailedEventDetails && {
        activityFailedEventDetails: (0, exports2.ActivityFailedEventDetailsFilterSensitiveLog)(obj.activityFailedEventDetails)
      },
      ...obj.activityScheduleFailedEventDetails && {
        activityScheduleFailedEventDetails: (0, exports2.ActivityScheduleFailedEventDetailsFilterSensitiveLog)(obj.activityScheduleFailedEventDetails)
      },
      ...obj.activityScheduledEventDetails && {
        activityScheduledEventDetails: (0, exports2.ActivityScheduledEventDetailsFilterSensitiveLog)(obj.activityScheduledEventDetails)
      },
      ...obj.activitySucceededEventDetails && {
        activitySucceededEventDetails: (0, exports2.ActivitySucceededEventDetailsFilterSensitiveLog)(obj.activitySucceededEventDetails)
      },
      ...obj.activityTimedOutEventDetails && {
        activityTimedOutEventDetails: (0, exports2.ActivityTimedOutEventDetailsFilterSensitiveLog)(obj.activityTimedOutEventDetails)
      },
      ...obj.taskFailedEventDetails && {
        taskFailedEventDetails: (0, exports2.TaskFailedEventDetailsFilterSensitiveLog)(obj.taskFailedEventDetails)
      },
      ...obj.taskScheduledEventDetails && {
        taskScheduledEventDetails: (0, exports2.TaskScheduledEventDetailsFilterSensitiveLog)(obj.taskScheduledEventDetails)
      },
      ...obj.taskStartFailedEventDetails && {
        taskStartFailedEventDetails: (0, exports2.TaskStartFailedEventDetailsFilterSensitiveLog)(obj.taskStartFailedEventDetails)
      },
      ...obj.taskSubmitFailedEventDetails && {
        taskSubmitFailedEventDetails: (0, exports2.TaskSubmitFailedEventDetailsFilterSensitiveLog)(obj.taskSubmitFailedEventDetails)
      },
      ...obj.taskSubmittedEventDetails && {
        taskSubmittedEventDetails: (0, exports2.TaskSubmittedEventDetailsFilterSensitiveLog)(obj.taskSubmittedEventDetails)
      },
      ...obj.taskSucceededEventDetails && {
        taskSucceededEventDetails: (0, exports2.TaskSucceededEventDetailsFilterSensitiveLog)(obj.taskSucceededEventDetails)
      },
      ...obj.taskTimedOutEventDetails && {
        taskTimedOutEventDetails: (0, exports2.TaskTimedOutEventDetailsFilterSensitiveLog)(obj.taskTimedOutEventDetails)
      },
      ...obj.executionFailedEventDetails && {
        executionFailedEventDetails: (0, exports2.ExecutionFailedEventDetailsFilterSensitiveLog)(obj.executionFailedEventDetails)
      },
      ...obj.executionStartedEventDetails && {
        executionStartedEventDetails: (0, exports2.ExecutionStartedEventDetailsFilterSensitiveLog)(obj.executionStartedEventDetails)
      },
      ...obj.executionSucceededEventDetails && {
        executionSucceededEventDetails: (0, exports2.ExecutionSucceededEventDetailsFilterSensitiveLog)(obj.executionSucceededEventDetails)
      },
      ...obj.executionAbortedEventDetails && {
        executionAbortedEventDetails: (0, exports2.ExecutionAbortedEventDetailsFilterSensitiveLog)(obj.executionAbortedEventDetails)
      },
      ...obj.executionTimedOutEventDetails && {
        executionTimedOutEventDetails: (0, exports2.ExecutionTimedOutEventDetailsFilterSensitiveLog)(obj.executionTimedOutEventDetails)
      },
      ...obj.lambdaFunctionFailedEventDetails && {
        lambdaFunctionFailedEventDetails: (0, exports2.LambdaFunctionFailedEventDetailsFilterSensitiveLog)(obj.lambdaFunctionFailedEventDetails)
      },
      ...obj.lambdaFunctionScheduleFailedEventDetails && {
        lambdaFunctionScheduleFailedEventDetails: (0, exports2.LambdaFunctionScheduleFailedEventDetailsFilterSensitiveLog)(obj.lambdaFunctionScheduleFailedEventDetails)
      },
      ...obj.lambdaFunctionScheduledEventDetails && {
        lambdaFunctionScheduledEventDetails: (0, exports2.LambdaFunctionScheduledEventDetailsFilterSensitiveLog)(obj.lambdaFunctionScheduledEventDetails)
      },
      ...obj.lambdaFunctionStartFailedEventDetails && {
        lambdaFunctionStartFailedEventDetails: (0, exports2.LambdaFunctionStartFailedEventDetailsFilterSensitiveLog)(obj.lambdaFunctionStartFailedEventDetails)
      },
      ...obj.lambdaFunctionSucceededEventDetails && {
        lambdaFunctionSucceededEventDetails: (0, exports2.LambdaFunctionSucceededEventDetailsFilterSensitiveLog)(obj.lambdaFunctionSucceededEventDetails)
      },
      ...obj.lambdaFunctionTimedOutEventDetails && {
        lambdaFunctionTimedOutEventDetails: (0, exports2.LambdaFunctionTimedOutEventDetailsFilterSensitiveLog)(obj.lambdaFunctionTimedOutEventDetails)
      },
      ...obj.stateEnteredEventDetails && {
        stateEnteredEventDetails: (0, exports2.StateEnteredEventDetailsFilterSensitiveLog)(obj.stateEnteredEventDetails)
      },
      ...obj.stateExitedEventDetails && {
        stateExitedEventDetails: (0, exports2.StateExitedEventDetailsFilterSensitiveLog)(obj.stateExitedEventDetails)
      },
      ...obj.mapRunFailedEventDetails && {
        mapRunFailedEventDetails: (0, exports2.MapRunFailedEventDetailsFilterSensitiveLog)(obj.mapRunFailedEventDetails)
      }
    });
    exports2.HistoryEventFilterSensitiveLog = HistoryEventFilterSensitiveLog;
    var GetExecutionHistoryOutputFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.events && { events: obj.events.map((item) => (0, exports2.HistoryEventFilterSensitiveLog)(item)) }
    });
    exports2.GetExecutionHistoryOutputFilterSensitiveLog = GetExecutionHistoryOutputFilterSensitiveLog;
    var PublishStateMachineVersionInputFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.description && { description: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.PublishStateMachineVersionInputFilterSensitiveLog = PublishStateMachineVersionInputFilterSensitiveLog;
    var SendTaskFailureInputFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.error && { error: smithy_client_1.SENSITIVE_STRING },
      ...obj.cause && { cause: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.SendTaskFailureInputFilterSensitiveLog = SendTaskFailureInputFilterSensitiveLog;
    var SendTaskSuccessInputFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.output && { output: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.SendTaskSuccessInputFilterSensitiveLog = SendTaskSuccessInputFilterSensitiveLog;
    var StartExecutionInputFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.input && { input: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.StartExecutionInputFilterSensitiveLog = StartExecutionInputFilterSensitiveLog;
    var StartSyncExecutionInputFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.input && { input: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.StartSyncExecutionInputFilterSensitiveLog = StartSyncExecutionInputFilterSensitiveLog;
    var StartSyncExecutionOutputFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.error && { error: smithy_client_1.SENSITIVE_STRING },
      ...obj.cause && { cause: smithy_client_1.SENSITIVE_STRING },
      ...obj.input && { input: smithy_client_1.SENSITIVE_STRING },
      ...obj.output && { output: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.StartSyncExecutionOutputFilterSensitiveLog = StartSyncExecutionOutputFilterSensitiveLog;
    var StopExecutionInputFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.error && { error: smithy_client_1.SENSITIVE_STRING },
      ...obj.cause && { cause: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.StopExecutionInputFilterSensitiveLog = StopExecutionInputFilterSensitiveLog;
    var UpdateStateMachineInputFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.definition && { definition: smithy_client_1.SENSITIVE_STRING },
      ...obj.versionDescription && { versionDescription: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.UpdateStateMachineInputFilterSensitiveLog = UpdateStateMachineInputFilterSensitiveLog;
    var UpdateStateMachineAliasInputFilterSensitiveLog = (obj) => ({
      ...obj,
      ...obj.description && { description: smithy_client_1.SENSITIVE_STRING }
    });
    exports2.UpdateStateMachineAliasInputFilterSensitiveLog = UpdateStateMachineAliasInputFilterSensitiveLog;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/protocols/Aws_json1_0.js
var require_Aws_json1_0 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/protocols/Aws_json1_0.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.de_ListActivitiesCommand = exports2.de_GetExecutionHistoryCommand = exports2.de_GetActivityTaskCommand = exports2.de_DescribeStateMachineForExecutionCommand = exports2.de_DescribeStateMachineAliasCommand = exports2.de_DescribeStateMachineCommand = exports2.de_DescribeMapRunCommand = exports2.de_DescribeExecutionCommand = exports2.de_DescribeActivityCommand = exports2.de_DeleteStateMachineVersionCommand = exports2.de_DeleteStateMachineAliasCommand = exports2.de_DeleteStateMachineCommand = exports2.de_DeleteActivityCommand = exports2.de_CreateStateMachineAliasCommand = exports2.de_CreateStateMachineCommand = exports2.de_CreateActivityCommand = exports2.se_UpdateStateMachineAliasCommand = exports2.se_UpdateStateMachineCommand = exports2.se_UpdateMapRunCommand = exports2.se_UntagResourceCommand = exports2.se_TagResourceCommand = exports2.se_StopExecutionCommand = exports2.se_StartSyncExecutionCommand = exports2.se_StartExecutionCommand = exports2.se_SendTaskSuccessCommand = exports2.se_SendTaskHeartbeatCommand = exports2.se_SendTaskFailureCommand = exports2.se_PublishStateMachineVersionCommand = exports2.se_ListTagsForResourceCommand = exports2.se_ListStateMachineVersionsCommand = exports2.se_ListStateMachinesCommand = exports2.se_ListStateMachineAliasesCommand = exports2.se_ListMapRunsCommand = exports2.se_ListExecutionsCommand = exports2.se_ListActivitiesCommand = exports2.se_GetExecutionHistoryCommand = exports2.se_GetActivityTaskCommand = exports2.se_DescribeStateMachineForExecutionCommand = exports2.se_DescribeStateMachineAliasCommand = exports2.se_DescribeStateMachineCommand = exports2.se_DescribeMapRunCommand = exports2.se_DescribeExecutionCommand = exports2.se_DescribeActivityCommand = exports2.se_DeleteStateMachineVersionCommand = exports2.se_DeleteStateMachineAliasCommand = exports2.se_DeleteStateMachineCommand = exports2.se_DeleteActivityCommand = exports2.se_CreateStateMachineAliasCommand = exports2.se_CreateStateMachineCommand = exports2.se_CreateActivityCommand = void 0;
    exports2.de_UpdateStateMachineAliasCommand = exports2.de_UpdateStateMachineCommand = exports2.de_UpdateMapRunCommand = exports2.de_UntagResourceCommand = exports2.de_TagResourceCommand = exports2.de_StopExecutionCommand = exports2.de_StartSyncExecutionCommand = exports2.de_StartExecutionCommand = exports2.de_SendTaskSuccessCommand = exports2.de_SendTaskHeartbeatCommand = exports2.de_SendTaskFailureCommand = exports2.de_PublishStateMachineVersionCommand = exports2.de_ListTagsForResourceCommand = exports2.de_ListStateMachineVersionsCommand = exports2.de_ListStateMachinesCommand = exports2.de_ListStateMachineAliasesCommand = exports2.de_ListMapRunsCommand = exports2.de_ListExecutionsCommand = void 0;
    var protocol_http_1 = require_dist_cjs2();
    var smithy_client_1 = require_dist_cjs34();
    var models_0_1 = require_models_03();
    var SFNServiceException_1 = require_SFNServiceException();
    var se_CreateActivityCommand = async (input, context) => {
      const headers = sharedHeaders("CreateActivity");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_CreateActivityCommand = se_CreateActivityCommand;
    var se_CreateStateMachineCommand = async (input, context) => {
      const headers = sharedHeaders("CreateStateMachine");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_CreateStateMachineCommand = se_CreateStateMachineCommand;
    var se_CreateStateMachineAliasCommand = async (input, context) => {
      const headers = sharedHeaders("CreateStateMachineAlias");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_CreateStateMachineAliasCommand = se_CreateStateMachineAliasCommand;
    var se_DeleteActivityCommand = async (input, context) => {
      const headers = sharedHeaders("DeleteActivity");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_DeleteActivityCommand = se_DeleteActivityCommand;
    var se_DeleteStateMachineCommand = async (input, context) => {
      const headers = sharedHeaders("DeleteStateMachine");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_DeleteStateMachineCommand = se_DeleteStateMachineCommand;
    var se_DeleteStateMachineAliasCommand = async (input, context) => {
      const headers = sharedHeaders("DeleteStateMachineAlias");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_DeleteStateMachineAliasCommand = se_DeleteStateMachineAliasCommand;
    var se_DeleteStateMachineVersionCommand = async (input, context) => {
      const headers = sharedHeaders("DeleteStateMachineVersion");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_DeleteStateMachineVersionCommand = se_DeleteStateMachineVersionCommand;
    var se_DescribeActivityCommand = async (input, context) => {
      const headers = sharedHeaders("DescribeActivity");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_DescribeActivityCommand = se_DescribeActivityCommand;
    var se_DescribeExecutionCommand = async (input, context) => {
      const headers = sharedHeaders("DescribeExecution");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_DescribeExecutionCommand = se_DescribeExecutionCommand;
    var se_DescribeMapRunCommand = async (input, context) => {
      const headers = sharedHeaders("DescribeMapRun");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_DescribeMapRunCommand = se_DescribeMapRunCommand;
    var se_DescribeStateMachineCommand = async (input, context) => {
      const headers = sharedHeaders("DescribeStateMachine");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_DescribeStateMachineCommand = se_DescribeStateMachineCommand;
    var se_DescribeStateMachineAliasCommand = async (input, context) => {
      const headers = sharedHeaders("DescribeStateMachineAlias");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_DescribeStateMachineAliasCommand = se_DescribeStateMachineAliasCommand;
    var se_DescribeStateMachineForExecutionCommand = async (input, context) => {
      const headers = sharedHeaders("DescribeStateMachineForExecution");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_DescribeStateMachineForExecutionCommand = se_DescribeStateMachineForExecutionCommand;
    var se_GetActivityTaskCommand = async (input, context) => {
      const headers = sharedHeaders("GetActivityTask");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_GetActivityTaskCommand = se_GetActivityTaskCommand;
    var se_GetExecutionHistoryCommand = async (input, context) => {
      const headers = sharedHeaders("GetExecutionHistory");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_GetExecutionHistoryCommand = se_GetExecutionHistoryCommand;
    var se_ListActivitiesCommand = async (input, context) => {
      const headers = sharedHeaders("ListActivities");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_ListActivitiesCommand = se_ListActivitiesCommand;
    var se_ListExecutionsCommand = async (input, context) => {
      const headers = sharedHeaders("ListExecutions");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_ListExecutionsCommand = se_ListExecutionsCommand;
    var se_ListMapRunsCommand = async (input, context) => {
      const headers = sharedHeaders("ListMapRuns");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_ListMapRunsCommand = se_ListMapRunsCommand;
    var se_ListStateMachineAliasesCommand = async (input, context) => {
      const headers = sharedHeaders("ListStateMachineAliases");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_ListStateMachineAliasesCommand = se_ListStateMachineAliasesCommand;
    var se_ListStateMachinesCommand = async (input, context) => {
      const headers = sharedHeaders("ListStateMachines");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_ListStateMachinesCommand = se_ListStateMachinesCommand;
    var se_ListStateMachineVersionsCommand = async (input, context) => {
      const headers = sharedHeaders("ListStateMachineVersions");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_ListStateMachineVersionsCommand = se_ListStateMachineVersionsCommand;
    var se_ListTagsForResourceCommand = async (input, context) => {
      const headers = sharedHeaders("ListTagsForResource");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_ListTagsForResourceCommand = se_ListTagsForResourceCommand;
    var se_PublishStateMachineVersionCommand = async (input, context) => {
      const headers = sharedHeaders("PublishStateMachineVersion");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_PublishStateMachineVersionCommand = se_PublishStateMachineVersionCommand;
    var se_SendTaskFailureCommand = async (input, context) => {
      const headers = sharedHeaders("SendTaskFailure");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_SendTaskFailureCommand = se_SendTaskFailureCommand;
    var se_SendTaskHeartbeatCommand = async (input, context) => {
      const headers = sharedHeaders("SendTaskHeartbeat");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_SendTaskHeartbeatCommand = se_SendTaskHeartbeatCommand;
    var se_SendTaskSuccessCommand = async (input, context) => {
      const headers = sharedHeaders("SendTaskSuccess");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_SendTaskSuccessCommand = se_SendTaskSuccessCommand;
    var se_StartExecutionCommand = async (input, context) => {
      const headers = sharedHeaders("StartExecution");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_StartExecutionCommand = se_StartExecutionCommand;
    var se_StartSyncExecutionCommand = async (input, context) => {
      const headers = sharedHeaders("StartSyncExecution");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      let { hostname: resolvedHostname } = await context.endpoint();
      if (context.disableHostPrefix !== true) {
        resolvedHostname = "sync-" + resolvedHostname;
        if (!(0, protocol_http_1.isValidHostname)(resolvedHostname)) {
          throw new Error("ValidationError: prefixed hostname must be hostname compatible.");
        }
      }
      return buildHttpRpcRequest(context, headers, "/", resolvedHostname, body);
    };
    exports2.se_StartSyncExecutionCommand = se_StartSyncExecutionCommand;
    var se_StopExecutionCommand = async (input, context) => {
      const headers = sharedHeaders("StopExecution");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_StopExecutionCommand = se_StopExecutionCommand;
    var se_TagResourceCommand = async (input, context) => {
      const headers = sharedHeaders("TagResource");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_TagResourceCommand = se_TagResourceCommand;
    var se_UntagResourceCommand = async (input, context) => {
      const headers = sharedHeaders("UntagResource");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_UntagResourceCommand = se_UntagResourceCommand;
    var se_UpdateMapRunCommand = async (input, context) => {
      const headers = sharedHeaders("UpdateMapRun");
      let body;
      body = JSON.stringify(se_UpdateMapRunInput(input, context));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_UpdateMapRunCommand = se_UpdateMapRunCommand;
    var se_UpdateStateMachineCommand = async (input, context) => {
      const headers = sharedHeaders("UpdateStateMachine");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_UpdateStateMachineCommand = se_UpdateStateMachineCommand;
    var se_UpdateStateMachineAliasCommand = async (input, context) => {
      const headers = sharedHeaders("UpdateStateMachineAlias");
      let body;
      body = JSON.stringify((0, smithy_client_1._json)(input));
      return buildHttpRpcRequest(context, headers, "/", void 0, body);
    };
    exports2.se_UpdateStateMachineAliasCommand = se_UpdateStateMachineAliasCommand;
    var de_CreateActivityCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_CreateActivityCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_CreateActivityOutput(data, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_CreateActivityCommand = de_CreateActivityCommand;
    var de_CreateActivityCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "ActivityLimitExceeded":
        case "com.amazonaws.sfn#ActivityLimitExceeded":
          throw await de_ActivityLimitExceededRes(parsedOutput, context);
        case "InvalidName":
        case "com.amazonaws.sfn#InvalidName":
          throw await de_InvalidNameRes(parsedOutput, context);
        case "TooManyTags":
        case "com.amazonaws.sfn#TooManyTags":
          throw await de_TooManyTagsRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_CreateStateMachineCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_CreateStateMachineCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_CreateStateMachineOutput(data, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_CreateStateMachineCommand = de_CreateStateMachineCommand;
    var de_CreateStateMachineCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "ConflictException":
        case "com.amazonaws.sfn#ConflictException":
          throw await de_ConflictExceptionRes(parsedOutput, context);
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        case "InvalidDefinition":
        case "com.amazonaws.sfn#InvalidDefinition":
          throw await de_InvalidDefinitionRes(parsedOutput, context);
        case "InvalidLoggingConfiguration":
        case "com.amazonaws.sfn#InvalidLoggingConfiguration":
          throw await de_InvalidLoggingConfigurationRes(parsedOutput, context);
        case "InvalidName":
        case "com.amazonaws.sfn#InvalidName":
          throw await de_InvalidNameRes(parsedOutput, context);
        case "InvalidTracingConfiguration":
        case "com.amazonaws.sfn#InvalidTracingConfiguration":
          throw await de_InvalidTracingConfigurationRes(parsedOutput, context);
        case "StateMachineAlreadyExists":
        case "com.amazonaws.sfn#StateMachineAlreadyExists":
          throw await de_StateMachineAlreadyExistsRes(parsedOutput, context);
        case "StateMachineDeleting":
        case "com.amazonaws.sfn#StateMachineDeleting":
          throw await de_StateMachineDeletingRes(parsedOutput, context);
        case "StateMachineLimitExceeded":
        case "com.amazonaws.sfn#StateMachineLimitExceeded":
          throw await de_StateMachineLimitExceededRes(parsedOutput, context);
        case "StateMachineTypeNotSupported":
        case "com.amazonaws.sfn#StateMachineTypeNotSupported":
          throw await de_StateMachineTypeNotSupportedRes(parsedOutput, context);
        case "TooManyTags":
        case "com.amazonaws.sfn#TooManyTags":
          throw await de_TooManyTagsRes(parsedOutput, context);
        case "ValidationException":
        case "com.amazonaws.sfn#ValidationException":
          throw await de_ValidationExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_CreateStateMachineAliasCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_CreateStateMachineAliasCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_CreateStateMachineAliasOutput(data, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_CreateStateMachineAliasCommand = de_CreateStateMachineAliasCommand;
    var de_CreateStateMachineAliasCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "ConflictException":
        case "com.amazonaws.sfn#ConflictException":
          throw await de_ConflictExceptionRes(parsedOutput, context);
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        case "InvalidName":
        case "com.amazonaws.sfn#InvalidName":
          throw await de_InvalidNameRes(parsedOutput, context);
        case "ResourceNotFound":
        case "com.amazonaws.sfn#ResourceNotFound":
          throw await de_ResourceNotFoundRes(parsedOutput, context);
        case "ServiceQuotaExceededException":
        case "com.amazonaws.sfn#ServiceQuotaExceededException":
          throw await de_ServiceQuotaExceededExceptionRes(parsedOutput, context);
        case "StateMachineDeleting":
        case "com.amazonaws.sfn#StateMachineDeleting":
          throw await de_StateMachineDeletingRes(parsedOutput, context);
        case "ValidationException":
        case "com.amazonaws.sfn#ValidationException":
          throw await de_ValidationExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_DeleteActivityCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_DeleteActivityCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = (0, smithy_client_1._json)(data);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_DeleteActivityCommand = de_DeleteActivityCommand;
    var de_DeleteActivityCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_DeleteStateMachineCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_DeleteStateMachineCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = (0, smithy_client_1._json)(data);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_DeleteStateMachineCommand = de_DeleteStateMachineCommand;
    var de_DeleteStateMachineCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        case "ValidationException":
        case "com.amazonaws.sfn#ValidationException":
          throw await de_ValidationExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_DeleteStateMachineAliasCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_DeleteStateMachineAliasCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = (0, smithy_client_1._json)(data);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_DeleteStateMachineAliasCommand = de_DeleteStateMachineAliasCommand;
    var de_DeleteStateMachineAliasCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "ConflictException":
        case "com.amazonaws.sfn#ConflictException":
          throw await de_ConflictExceptionRes(parsedOutput, context);
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        case "ResourceNotFound":
        case "com.amazonaws.sfn#ResourceNotFound":
          throw await de_ResourceNotFoundRes(parsedOutput, context);
        case "ValidationException":
        case "com.amazonaws.sfn#ValidationException":
          throw await de_ValidationExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_DeleteStateMachineVersionCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_DeleteStateMachineVersionCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = (0, smithy_client_1._json)(data);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_DeleteStateMachineVersionCommand = de_DeleteStateMachineVersionCommand;
    var de_DeleteStateMachineVersionCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "ConflictException":
        case "com.amazonaws.sfn#ConflictException":
          throw await de_ConflictExceptionRes(parsedOutput, context);
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        case "ValidationException":
        case "com.amazonaws.sfn#ValidationException":
          throw await de_ValidationExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_DescribeActivityCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_DescribeActivityCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_DescribeActivityOutput(data, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_DescribeActivityCommand = de_DescribeActivityCommand;
    var de_DescribeActivityCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "ActivityDoesNotExist":
        case "com.amazonaws.sfn#ActivityDoesNotExist":
          throw await de_ActivityDoesNotExistRes(parsedOutput, context);
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_DescribeExecutionCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_DescribeExecutionCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_DescribeExecutionOutput(data, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_DescribeExecutionCommand = de_DescribeExecutionCommand;
    var de_DescribeExecutionCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "ExecutionDoesNotExist":
        case "com.amazonaws.sfn#ExecutionDoesNotExist":
          throw await de_ExecutionDoesNotExistRes(parsedOutput, context);
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_DescribeMapRunCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_DescribeMapRunCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_DescribeMapRunOutput(data, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_DescribeMapRunCommand = de_DescribeMapRunCommand;
    var de_DescribeMapRunCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        case "ResourceNotFound":
        case "com.amazonaws.sfn#ResourceNotFound":
          throw await de_ResourceNotFoundRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_DescribeStateMachineCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_DescribeStateMachineCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_DescribeStateMachineOutput(data, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_DescribeStateMachineCommand = de_DescribeStateMachineCommand;
    var de_DescribeStateMachineCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        case "StateMachineDoesNotExist":
        case "com.amazonaws.sfn#StateMachineDoesNotExist":
          throw await de_StateMachineDoesNotExistRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_DescribeStateMachineAliasCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_DescribeStateMachineAliasCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_DescribeStateMachineAliasOutput(data, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_DescribeStateMachineAliasCommand = de_DescribeStateMachineAliasCommand;
    var de_DescribeStateMachineAliasCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        case "ResourceNotFound":
        case "com.amazonaws.sfn#ResourceNotFound":
          throw await de_ResourceNotFoundRes(parsedOutput, context);
        case "ValidationException":
        case "com.amazonaws.sfn#ValidationException":
          throw await de_ValidationExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_DescribeStateMachineForExecutionCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_DescribeStateMachineForExecutionCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_DescribeStateMachineForExecutionOutput(data, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_DescribeStateMachineForExecutionCommand = de_DescribeStateMachineForExecutionCommand;
    var de_DescribeStateMachineForExecutionCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "ExecutionDoesNotExist":
        case "com.amazonaws.sfn#ExecutionDoesNotExist":
          throw await de_ExecutionDoesNotExistRes(parsedOutput, context);
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_GetActivityTaskCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_GetActivityTaskCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = (0, smithy_client_1._json)(data);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_GetActivityTaskCommand = de_GetActivityTaskCommand;
    var de_GetActivityTaskCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "ActivityDoesNotExist":
        case "com.amazonaws.sfn#ActivityDoesNotExist":
          throw await de_ActivityDoesNotExistRes(parsedOutput, context);
        case "ActivityWorkerLimitExceeded":
        case "com.amazonaws.sfn#ActivityWorkerLimitExceeded":
          throw await de_ActivityWorkerLimitExceededRes(parsedOutput, context);
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_GetExecutionHistoryCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_GetExecutionHistoryCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_GetExecutionHistoryOutput(data, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_GetExecutionHistoryCommand = de_GetExecutionHistoryCommand;
    var de_GetExecutionHistoryCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "ExecutionDoesNotExist":
        case "com.amazonaws.sfn#ExecutionDoesNotExist":
          throw await de_ExecutionDoesNotExistRes(parsedOutput, context);
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        case "InvalidToken":
        case "com.amazonaws.sfn#InvalidToken":
          throw await de_InvalidTokenRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_ListActivitiesCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_ListActivitiesCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_ListActivitiesOutput(data, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_ListActivitiesCommand = de_ListActivitiesCommand;
    var de_ListActivitiesCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "InvalidToken":
        case "com.amazonaws.sfn#InvalidToken":
          throw await de_InvalidTokenRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_ListExecutionsCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_ListExecutionsCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_ListExecutionsOutput(data, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_ListExecutionsCommand = de_ListExecutionsCommand;
    var de_ListExecutionsCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        case "InvalidToken":
        case "com.amazonaws.sfn#InvalidToken":
          throw await de_InvalidTokenRes(parsedOutput, context);
        case "ResourceNotFound":
        case "com.amazonaws.sfn#ResourceNotFound":
          throw await de_ResourceNotFoundRes(parsedOutput, context);
        case "StateMachineDoesNotExist":
        case "com.amazonaws.sfn#StateMachineDoesNotExist":
          throw await de_StateMachineDoesNotExistRes(parsedOutput, context);
        case "StateMachineTypeNotSupported":
        case "com.amazonaws.sfn#StateMachineTypeNotSupported":
          throw await de_StateMachineTypeNotSupportedRes(parsedOutput, context);
        case "ValidationException":
        case "com.amazonaws.sfn#ValidationException":
          throw await de_ValidationExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_ListMapRunsCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_ListMapRunsCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_ListMapRunsOutput(data, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_ListMapRunsCommand = de_ListMapRunsCommand;
    var de_ListMapRunsCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "ExecutionDoesNotExist":
        case "com.amazonaws.sfn#ExecutionDoesNotExist":
          throw await de_ExecutionDoesNotExistRes(parsedOutput, context);
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        case "InvalidToken":
        case "com.amazonaws.sfn#InvalidToken":
          throw await de_InvalidTokenRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_ListStateMachineAliasesCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_ListStateMachineAliasesCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_ListStateMachineAliasesOutput(data, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_ListStateMachineAliasesCommand = de_ListStateMachineAliasesCommand;
    var de_ListStateMachineAliasesCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        case "InvalidToken":
        case "com.amazonaws.sfn#InvalidToken":
          throw await de_InvalidTokenRes(parsedOutput, context);
        case "ResourceNotFound":
        case "com.amazonaws.sfn#ResourceNotFound":
          throw await de_ResourceNotFoundRes(parsedOutput, context);
        case "StateMachineDeleting":
        case "com.amazonaws.sfn#StateMachineDeleting":
          throw await de_StateMachineDeletingRes(parsedOutput, context);
        case "StateMachineDoesNotExist":
        case "com.amazonaws.sfn#StateMachineDoesNotExist":
          throw await de_StateMachineDoesNotExistRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_ListStateMachinesCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_ListStateMachinesCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_ListStateMachinesOutput(data, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_ListStateMachinesCommand = de_ListStateMachinesCommand;
    var de_ListStateMachinesCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "InvalidToken":
        case "com.amazonaws.sfn#InvalidToken":
          throw await de_InvalidTokenRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_ListStateMachineVersionsCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_ListStateMachineVersionsCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_ListStateMachineVersionsOutput(data, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_ListStateMachineVersionsCommand = de_ListStateMachineVersionsCommand;
    var de_ListStateMachineVersionsCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        case "InvalidToken":
        case "com.amazonaws.sfn#InvalidToken":
          throw await de_InvalidTokenRes(parsedOutput, context);
        case "ValidationException":
        case "com.amazonaws.sfn#ValidationException":
          throw await de_ValidationExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_ListTagsForResourceCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_ListTagsForResourceCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = (0, smithy_client_1._json)(data);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_ListTagsForResourceCommand = de_ListTagsForResourceCommand;
    var de_ListTagsForResourceCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        case "ResourceNotFound":
        case "com.amazonaws.sfn#ResourceNotFound":
          throw await de_ResourceNotFoundRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_PublishStateMachineVersionCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_PublishStateMachineVersionCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_PublishStateMachineVersionOutput(data, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_PublishStateMachineVersionCommand = de_PublishStateMachineVersionCommand;
    var de_PublishStateMachineVersionCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "ConflictException":
        case "com.amazonaws.sfn#ConflictException":
          throw await de_ConflictExceptionRes(parsedOutput, context);
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        case "ServiceQuotaExceededException":
        case "com.amazonaws.sfn#ServiceQuotaExceededException":
          throw await de_ServiceQuotaExceededExceptionRes(parsedOutput, context);
        case "StateMachineDeleting":
        case "com.amazonaws.sfn#StateMachineDeleting":
          throw await de_StateMachineDeletingRes(parsedOutput, context);
        case "StateMachineDoesNotExist":
        case "com.amazonaws.sfn#StateMachineDoesNotExist":
          throw await de_StateMachineDoesNotExistRes(parsedOutput, context);
        case "ValidationException":
        case "com.amazonaws.sfn#ValidationException":
          throw await de_ValidationExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_SendTaskFailureCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_SendTaskFailureCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = (0, smithy_client_1._json)(data);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_SendTaskFailureCommand = de_SendTaskFailureCommand;
    var de_SendTaskFailureCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "InvalidToken":
        case "com.amazonaws.sfn#InvalidToken":
          throw await de_InvalidTokenRes(parsedOutput, context);
        case "TaskDoesNotExist":
        case "com.amazonaws.sfn#TaskDoesNotExist":
          throw await de_TaskDoesNotExistRes(parsedOutput, context);
        case "TaskTimedOut":
        case "com.amazonaws.sfn#TaskTimedOut":
          throw await de_TaskTimedOutRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_SendTaskHeartbeatCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_SendTaskHeartbeatCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = (0, smithy_client_1._json)(data);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_SendTaskHeartbeatCommand = de_SendTaskHeartbeatCommand;
    var de_SendTaskHeartbeatCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "InvalidToken":
        case "com.amazonaws.sfn#InvalidToken":
          throw await de_InvalidTokenRes(parsedOutput, context);
        case "TaskDoesNotExist":
        case "com.amazonaws.sfn#TaskDoesNotExist":
          throw await de_TaskDoesNotExistRes(parsedOutput, context);
        case "TaskTimedOut":
        case "com.amazonaws.sfn#TaskTimedOut":
          throw await de_TaskTimedOutRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_SendTaskSuccessCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_SendTaskSuccessCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = (0, smithy_client_1._json)(data);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_SendTaskSuccessCommand = de_SendTaskSuccessCommand;
    var de_SendTaskSuccessCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "InvalidOutput":
        case "com.amazonaws.sfn#InvalidOutput":
          throw await de_InvalidOutputRes(parsedOutput, context);
        case "InvalidToken":
        case "com.amazonaws.sfn#InvalidToken":
          throw await de_InvalidTokenRes(parsedOutput, context);
        case "TaskDoesNotExist":
        case "com.amazonaws.sfn#TaskDoesNotExist":
          throw await de_TaskDoesNotExistRes(parsedOutput, context);
        case "TaskTimedOut":
        case "com.amazonaws.sfn#TaskTimedOut":
          throw await de_TaskTimedOutRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_StartExecutionCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_StartExecutionCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_StartExecutionOutput(data, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_StartExecutionCommand = de_StartExecutionCommand;
    var de_StartExecutionCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "ExecutionAlreadyExists":
        case "com.amazonaws.sfn#ExecutionAlreadyExists":
          throw await de_ExecutionAlreadyExistsRes(parsedOutput, context);
        case "ExecutionLimitExceeded":
        case "com.amazonaws.sfn#ExecutionLimitExceeded":
          throw await de_ExecutionLimitExceededRes(parsedOutput, context);
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        case "InvalidExecutionInput":
        case "com.amazonaws.sfn#InvalidExecutionInput":
          throw await de_InvalidExecutionInputRes(parsedOutput, context);
        case "InvalidName":
        case "com.amazonaws.sfn#InvalidName":
          throw await de_InvalidNameRes(parsedOutput, context);
        case "StateMachineDeleting":
        case "com.amazonaws.sfn#StateMachineDeleting":
          throw await de_StateMachineDeletingRes(parsedOutput, context);
        case "StateMachineDoesNotExist":
        case "com.amazonaws.sfn#StateMachineDoesNotExist":
          throw await de_StateMachineDoesNotExistRes(parsedOutput, context);
        case "ValidationException":
        case "com.amazonaws.sfn#ValidationException":
          throw await de_ValidationExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_StartSyncExecutionCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_StartSyncExecutionCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_StartSyncExecutionOutput(data, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_StartSyncExecutionCommand = de_StartSyncExecutionCommand;
    var de_StartSyncExecutionCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        case "InvalidExecutionInput":
        case "com.amazonaws.sfn#InvalidExecutionInput":
          throw await de_InvalidExecutionInputRes(parsedOutput, context);
        case "InvalidName":
        case "com.amazonaws.sfn#InvalidName":
          throw await de_InvalidNameRes(parsedOutput, context);
        case "StateMachineDeleting":
        case "com.amazonaws.sfn#StateMachineDeleting":
          throw await de_StateMachineDeletingRes(parsedOutput, context);
        case "StateMachineDoesNotExist":
        case "com.amazonaws.sfn#StateMachineDoesNotExist":
          throw await de_StateMachineDoesNotExistRes(parsedOutput, context);
        case "StateMachineTypeNotSupported":
        case "com.amazonaws.sfn#StateMachineTypeNotSupported":
          throw await de_StateMachineTypeNotSupportedRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_StopExecutionCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_StopExecutionCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_StopExecutionOutput(data, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_StopExecutionCommand = de_StopExecutionCommand;
    var de_StopExecutionCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "ExecutionDoesNotExist":
        case "com.amazonaws.sfn#ExecutionDoesNotExist":
          throw await de_ExecutionDoesNotExistRes(parsedOutput, context);
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        case "ValidationException":
        case "com.amazonaws.sfn#ValidationException":
          throw await de_ValidationExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_TagResourceCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_TagResourceCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = (0, smithy_client_1._json)(data);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_TagResourceCommand = de_TagResourceCommand;
    var de_TagResourceCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        case "ResourceNotFound":
        case "com.amazonaws.sfn#ResourceNotFound":
          throw await de_ResourceNotFoundRes(parsedOutput, context);
        case "TooManyTags":
        case "com.amazonaws.sfn#TooManyTags":
          throw await de_TooManyTagsRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_UntagResourceCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_UntagResourceCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = (0, smithy_client_1._json)(data);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_UntagResourceCommand = de_UntagResourceCommand;
    var de_UntagResourceCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        case "ResourceNotFound":
        case "com.amazonaws.sfn#ResourceNotFound":
          throw await de_ResourceNotFoundRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_UpdateMapRunCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_UpdateMapRunCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = (0, smithy_client_1._json)(data);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_UpdateMapRunCommand = de_UpdateMapRunCommand;
    var de_UpdateMapRunCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        case "ResourceNotFound":
        case "com.amazonaws.sfn#ResourceNotFound":
          throw await de_ResourceNotFoundRes(parsedOutput, context);
        case "ValidationException":
        case "com.amazonaws.sfn#ValidationException":
          throw await de_ValidationExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_UpdateStateMachineCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_UpdateStateMachineCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_UpdateStateMachineOutput(data, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_UpdateStateMachineCommand = de_UpdateStateMachineCommand;
    var de_UpdateStateMachineCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "ConflictException":
        case "com.amazonaws.sfn#ConflictException":
          throw await de_ConflictExceptionRes(parsedOutput, context);
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        case "InvalidDefinition":
        case "com.amazonaws.sfn#InvalidDefinition":
          throw await de_InvalidDefinitionRes(parsedOutput, context);
        case "InvalidLoggingConfiguration":
        case "com.amazonaws.sfn#InvalidLoggingConfiguration":
          throw await de_InvalidLoggingConfigurationRes(parsedOutput, context);
        case "InvalidTracingConfiguration":
        case "com.amazonaws.sfn#InvalidTracingConfiguration":
          throw await de_InvalidTracingConfigurationRes(parsedOutput, context);
        case "MissingRequiredParameter":
        case "com.amazonaws.sfn#MissingRequiredParameter":
          throw await de_MissingRequiredParameterRes(parsedOutput, context);
        case "ServiceQuotaExceededException":
        case "com.amazonaws.sfn#ServiceQuotaExceededException":
          throw await de_ServiceQuotaExceededExceptionRes(parsedOutput, context);
        case "StateMachineDeleting":
        case "com.amazonaws.sfn#StateMachineDeleting":
          throw await de_StateMachineDeletingRes(parsedOutput, context);
        case "StateMachineDoesNotExist":
        case "com.amazonaws.sfn#StateMachineDoesNotExist":
          throw await de_StateMachineDoesNotExistRes(parsedOutput, context);
        case "ValidationException":
        case "com.amazonaws.sfn#ValidationException":
          throw await de_ValidationExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_UpdateStateMachineAliasCommand = async (output, context) => {
      if (output.statusCode >= 300) {
        return de_UpdateStateMachineAliasCommandError(output, context);
      }
      const data = await parseBody(output.body, context);
      let contents = {};
      contents = de_UpdateStateMachineAliasOutput(data, context);
      const response = {
        $metadata: deserializeMetadata(output),
        ...contents
      };
      return response;
    };
    exports2.de_UpdateStateMachineAliasCommand = de_UpdateStateMachineAliasCommand;
    var de_UpdateStateMachineAliasCommandError = async (output, context) => {
      const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context)
      };
      const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
      switch (errorCode) {
        case "ConflictException":
        case "com.amazonaws.sfn#ConflictException":
          throw await de_ConflictExceptionRes(parsedOutput, context);
        case "InvalidArn":
        case "com.amazonaws.sfn#InvalidArn":
          throw await de_InvalidArnRes(parsedOutput, context);
        case "ResourceNotFound":
        case "com.amazonaws.sfn#ResourceNotFound":
          throw await de_ResourceNotFoundRes(parsedOutput, context);
        case "ValidationException":
        case "com.amazonaws.sfn#ValidationException":
          throw await de_ValidationExceptionRes(parsedOutput, context);
        default:
          const parsedBody = parsedOutput.body;
          return throwDefaultError({
            output,
            parsedBody,
            errorCode
          });
      }
    };
    var de_ActivityDoesNotExistRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.ActivityDoesNotExist({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_ActivityLimitExceededRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.ActivityLimitExceeded({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_ActivityWorkerLimitExceededRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.ActivityWorkerLimitExceeded({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_ConflictExceptionRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.ConflictException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_ExecutionAlreadyExistsRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.ExecutionAlreadyExists({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_ExecutionDoesNotExistRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.ExecutionDoesNotExist({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_ExecutionLimitExceededRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.ExecutionLimitExceeded({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_InvalidArnRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.InvalidArn({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_InvalidDefinitionRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.InvalidDefinition({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_InvalidExecutionInputRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.InvalidExecutionInput({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_InvalidLoggingConfigurationRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.InvalidLoggingConfiguration({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_InvalidNameRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.InvalidName({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_InvalidOutputRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.InvalidOutput({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_InvalidTokenRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.InvalidToken({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_InvalidTracingConfigurationRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.InvalidTracingConfiguration({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_MissingRequiredParameterRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.MissingRequiredParameter({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_ResourceNotFoundRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.ResourceNotFound({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_ServiceQuotaExceededExceptionRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.ServiceQuotaExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_StateMachineAlreadyExistsRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.StateMachineAlreadyExists({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_StateMachineDeletingRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.StateMachineDeleting({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_StateMachineDoesNotExistRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.StateMachineDoesNotExist({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_StateMachineLimitExceededRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.StateMachineLimitExceeded({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_StateMachineTypeNotSupportedRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.StateMachineTypeNotSupported({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_TaskDoesNotExistRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.TaskDoesNotExist({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_TaskTimedOutRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.TaskTimedOut({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_TooManyTagsRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.TooManyTags({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var de_ValidationExceptionRes = async (parsedOutput, context) => {
      const body = parsedOutput.body;
      const deserialized = (0, smithy_client_1._json)(body);
      const exception = new models_0_1.ValidationException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized
      });
      return (0, smithy_client_1.decorateServiceException)(exception, body);
    };
    var se_UpdateMapRunInput = (input, context) => {
      return (0, smithy_client_1.take)(input, {
        mapRunArn: [],
        maxConcurrency: [],
        toleratedFailureCount: [],
        toleratedFailurePercentage: smithy_client_1.serializeFloat
      });
    };
    var de_ActivityList = (output, context) => {
      const retVal = (output || []).filter((e) => e != null).map((entry) => {
        return de_ActivityListItem(entry, context);
      });
      return retVal;
    };
    var de_ActivityListItem = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        activityArn: smithy_client_1.expectString,
        creationDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        name: smithy_client_1.expectString
      });
    };
    var de_CreateActivityOutput = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        activityArn: smithy_client_1.expectString,
        creationDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_)))
      });
    };
    var de_CreateStateMachineAliasOutput = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        creationDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        stateMachineAliasArn: smithy_client_1.expectString
      });
    };
    var de_CreateStateMachineOutput = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        creationDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        stateMachineArn: smithy_client_1.expectString,
        stateMachineVersionArn: smithy_client_1.expectString
      });
    };
    var de_DescribeActivityOutput = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        activityArn: smithy_client_1.expectString,
        creationDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        name: smithy_client_1.expectString
      });
    };
    var de_DescribeExecutionOutput = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        cause: smithy_client_1.expectString,
        error: smithy_client_1.expectString,
        executionArn: smithy_client_1.expectString,
        input: smithy_client_1.expectString,
        inputDetails: smithy_client_1._json,
        mapRunArn: smithy_client_1.expectString,
        name: smithy_client_1.expectString,
        output: smithy_client_1.expectString,
        outputDetails: smithy_client_1._json,
        startDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        stateMachineAliasArn: smithy_client_1.expectString,
        stateMachineArn: smithy_client_1.expectString,
        stateMachineVersionArn: smithy_client_1.expectString,
        status: smithy_client_1.expectString,
        stopDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        traceHeader: smithy_client_1.expectString
      });
    };
    var de_DescribeMapRunOutput = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        executionArn: smithy_client_1.expectString,
        executionCounts: smithy_client_1._json,
        itemCounts: smithy_client_1._json,
        mapRunArn: smithy_client_1.expectString,
        maxConcurrency: smithy_client_1.expectInt32,
        startDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        status: smithy_client_1.expectString,
        stopDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        toleratedFailureCount: smithy_client_1.expectLong,
        toleratedFailurePercentage: smithy_client_1.limitedParseFloat32
      });
    };
    var de_DescribeStateMachineAliasOutput = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        creationDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        description: smithy_client_1.expectString,
        name: smithy_client_1.expectString,
        routingConfiguration: smithy_client_1._json,
        stateMachineAliasArn: smithy_client_1.expectString,
        updateDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_)))
      });
    };
    var de_DescribeStateMachineForExecutionOutput = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        definition: smithy_client_1.expectString,
        label: smithy_client_1.expectString,
        loggingConfiguration: smithy_client_1._json,
        mapRunArn: smithy_client_1.expectString,
        name: smithy_client_1.expectString,
        revisionId: smithy_client_1.expectString,
        roleArn: smithy_client_1.expectString,
        stateMachineArn: smithy_client_1.expectString,
        tracingConfiguration: smithy_client_1._json,
        updateDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_)))
      });
    };
    var de_DescribeStateMachineOutput = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        creationDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        definition: smithy_client_1.expectString,
        description: smithy_client_1.expectString,
        label: smithy_client_1.expectString,
        loggingConfiguration: smithy_client_1._json,
        name: smithy_client_1.expectString,
        revisionId: smithy_client_1.expectString,
        roleArn: smithy_client_1.expectString,
        stateMachineArn: smithy_client_1.expectString,
        status: smithy_client_1.expectString,
        tracingConfiguration: smithy_client_1._json,
        type: smithy_client_1.expectString
      });
    };
    var de_ExecutionList = (output, context) => {
      const retVal = (output || []).filter((e) => e != null).map((entry) => {
        return de_ExecutionListItem(entry, context);
      });
      return retVal;
    };
    var de_ExecutionListItem = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        executionArn: smithy_client_1.expectString,
        itemCount: smithy_client_1.expectInt32,
        mapRunArn: smithy_client_1.expectString,
        name: smithy_client_1.expectString,
        startDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        stateMachineAliasArn: smithy_client_1.expectString,
        stateMachineArn: smithy_client_1.expectString,
        stateMachineVersionArn: smithy_client_1.expectString,
        status: smithy_client_1.expectString,
        stopDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_)))
      });
    };
    var de_GetExecutionHistoryOutput = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        events: (_) => de_HistoryEventList(_, context),
        nextToken: smithy_client_1.expectString
      });
    };
    var de_HistoryEvent = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        activityFailedEventDetails: smithy_client_1._json,
        activityScheduleFailedEventDetails: smithy_client_1._json,
        activityScheduledEventDetails: smithy_client_1._json,
        activityStartedEventDetails: smithy_client_1._json,
        activitySucceededEventDetails: smithy_client_1._json,
        activityTimedOutEventDetails: smithy_client_1._json,
        executionAbortedEventDetails: smithy_client_1._json,
        executionFailedEventDetails: smithy_client_1._json,
        executionStartedEventDetails: smithy_client_1._json,
        executionSucceededEventDetails: smithy_client_1._json,
        executionTimedOutEventDetails: smithy_client_1._json,
        id: smithy_client_1.expectLong,
        lambdaFunctionFailedEventDetails: smithy_client_1._json,
        lambdaFunctionScheduleFailedEventDetails: smithy_client_1._json,
        lambdaFunctionScheduledEventDetails: smithy_client_1._json,
        lambdaFunctionStartFailedEventDetails: smithy_client_1._json,
        lambdaFunctionSucceededEventDetails: smithy_client_1._json,
        lambdaFunctionTimedOutEventDetails: smithy_client_1._json,
        mapIterationAbortedEventDetails: smithy_client_1._json,
        mapIterationFailedEventDetails: smithy_client_1._json,
        mapIterationStartedEventDetails: smithy_client_1._json,
        mapIterationSucceededEventDetails: smithy_client_1._json,
        mapRunFailedEventDetails: smithy_client_1._json,
        mapRunStartedEventDetails: smithy_client_1._json,
        mapStateStartedEventDetails: smithy_client_1._json,
        previousEventId: smithy_client_1.expectLong,
        stateEnteredEventDetails: smithy_client_1._json,
        stateExitedEventDetails: smithy_client_1._json,
        taskFailedEventDetails: smithy_client_1._json,
        taskScheduledEventDetails: smithy_client_1._json,
        taskStartFailedEventDetails: smithy_client_1._json,
        taskStartedEventDetails: smithy_client_1._json,
        taskSubmitFailedEventDetails: smithy_client_1._json,
        taskSubmittedEventDetails: smithy_client_1._json,
        taskSucceededEventDetails: smithy_client_1._json,
        taskTimedOutEventDetails: smithy_client_1._json,
        timestamp: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        type: smithy_client_1.expectString
      });
    };
    var de_HistoryEventList = (output, context) => {
      const retVal = (output || []).filter((e) => e != null).map((entry) => {
        return de_HistoryEvent(entry, context);
      });
      return retVal;
    };
    var de_ListActivitiesOutput = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        activities: (_) => de_ActivityList(_, context),
        nextToken: smithy_client_1.expectString
      });
    };
    var de_ListExecutionsOutput = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        executions: (_) => de_ExecutionList(_, context),
        nextToken: smithy_client_1.expectString
      });
    };
    var de_ListMapRunsOutput = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        mapRuns: (_) => de_MapRunList(_, context),
        nextToken: smithy_client_1.expectString
      });
    };
    var de_ListStateMachineAliasesOutput = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        nextToken: smithy_client_1.expectString,
        stateMachineAliases: (_) => de_StateMachineAliasList(_, context)
      });
    };
    var de_ListStateMachinesOutput = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        nextToken: smithy_client_1.expectString,
        stateMachines: (_) => de_StateMachineList(_, context)
      });
    };
    var de_ListStateMachineVersionsOutput = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        nextToken: smithy_client_1.expectString,
        stateMachineVersions: (_) => de_StateMachineVersionList(_, context)
      });
    };
    var de_MapRunList = (output, context) => {
      const retVal = (output || []).filter((e) => e != null).map((entry) => {
        return de_MapRunListItem(entry, context);
      });
      return retVal;
    };
    var de_MapRunListItem = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        executionArn: smithy_client_1.expectString,
        mapRunArn: smithy_client_1.expectString,
        startDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        stateMachineArn: smithy_client_1.expectString,
        stopDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_)))
      });
    };
    var de_PublishStateMachineVersionOutput = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        creationDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        stateMachineVersionArn: smithy_client_1.expectString
      });
    };
    var de_StartExecutionOutput = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        executionArn: smithy_client_1.expectString,
        startDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_)))
      });
    };
    var de_StartSyncExecutionOutput = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        billingDetails: smithy_client_1._json,
        cause: smithy_client_1.expectString,
        error: smithy_client_1.expectString,
        executionArn: smithy_client_1.expectString,
        input: smithy_client_1.expectString,
        inputDetails: smithy_client_1._json,
        name: smithy_client_1.expectString,
        output: smithy_client_1.expectString,
        outputDetails: smithy_client_1._json,
        startDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        stateMachineArn: smithy_client_1.expectString,
        status: smithy_client_1.expectString,
        stopDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        traceHeader: smithy_client_1.expectString
      });
    };
    var de_StateMachineAliasList = (output, context) => {
      const retVal = (output || []).filter((e) => e != null).map((entry) => {
        return de_StateMachineAliasListItem(entry, context);
      });
      return retVal;
    };
    var de_StateMachineAliasListItem = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        creationDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        stateMachineAliasArn: smithy_client_1.expectString
      });
    };
    var de_StateMachineList = (output, context) => {
      const retVal = (output || []).filter((e) => e != null).map((entry) => {
        return de_StateMachineListItem(entry, context);
      });
      return retVal;
    };
    var de_StateMachineListItem = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        creationDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        name: smithy_client_1.expectString,
        stateMachineArn: smithy_client_1.expectString,
        type: smithy_client_1.expectString
      });
    };
    var de_StateMachineVersionList = (output, context) => {
      const retVal = (output || []).filter((e) => e != null).map((entry) => {
        return de_StateMachineVersionListItem(entry, context);
      });
      return retVal;
    };
    var de_StateMachineVersionListItem = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        creationDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_))),
        stateMachineVersionArn: smithy_client_1.expectString
      });
    };
    var de_StopExecutionOutput = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        stopDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_)))
      });
    };
    var de_UpdateStateMachineAliasOutput = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        updateDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_)))
      });
    };
    var de_UpdateStateMachineOutput = (output, context) => {
      return (0, smithy_client_1.take)(output, {
        revisionId: smithy_client_1.expectString,
        stateMachineVersionArn: smithy_client_1.expectString,
        updateDate: (_) => (0, smithy_client_1.expectNonNull)((0, smithy_client_1.parseEpochTimestamp)((0, smithy_client_1.expectNumber)(_)))
      });
    };
    var deserializeMetadata = (output) => ({
      httpStatusCode: output.statusCode,
      requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
      extendedRequestId: output.headers["x-amz-id-2"],
      cfId: output.headers["x-amz-cf-id"]
    });
    var collectBodyString = (streamBody, context) => (0, smithy_client_1.collectBody)(streamBody, context).then((body) => context.utf8Encoder(body));
    var throwDefaultError = (0, smithy_client_1.withBaseException)(SFNServiceException_1.SFNServiceException);
    var buildHttpRpcRequest = async (context, headers, path, resolvedHostname, body) => {
      const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
      const contents = {
        protocol,
        hostname,
        port,
        method: "POST",
        path: basePath.endsWith("/") ? basePath.slice(0, -1) + path : basePath + path,
        headers
      };
      if (resolvedHostname !== void 0) {
        contents.hostname = resolvedHostname;
      }
      if (body !== void 0) {
        contents.body = body;
      }
      return new protocol_http_1.HttpRequest(contents);
    };
    function sharedHeaders(operation) {
      return {
        "content-type": "application/x-amz-json-1.0",
        "x-amz-target": `AWSStepFunctions.${operation}`
      };
    }
    var parseBody = (streamBody, context) => collectBodyString(streamBody, context).then((encoded) => {
      if (encoded.length) {
        return JSON.parse(encoded);
      }
      return {};
    });
    var parseErrorBody = async (errorBody, context) => {
      const value = await parseBody(errorBody, context);
      value.message = value.message ?? value.Message;
      return value;
    };
    var loadRestJsonErrorCode = (output, data) => {
      const findKey = (object, key) => Object.keys(object).find((k) => k.toLowerCase() === key.toLowerCase());
      const sanitizeErrorCode = (rawValue) => {
        let cleanValue = rawValue;
        if (typeof cleanValue === "number") {
          cleanValue = cleanValue.toString();
        }
        if (cleanValue.indexOf(",") >= 0) {
          cleanValue = cleanValue.split(",")[0];
        }
        if (cleanValue.indexOf(":") >= 0) {
          cleanValue = cleanValue.split(":")[0];
        }
        if (cleanValue.indexOf("#") >= 0) {
          cleanValue = cleanValue.split("#")[1];
        }
        return cleanValue;
      };
      const headerKey = findKey(output.headers, "x-amzn-errortype");
      if (headerKey !== void 0) {
        return sanitizeErrorCode(output.headers[headerKey]);
      }
      if (data.code !== void 0) {
        return sanitizeErrorCode(data.code);
      }
      if (data["__type"] !== void 0) {
        return sanitizeErrorCode(data["__type"]);
      }
    };
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/CreateActivityCommand.js
var require_CreateActivityCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/CreateActivityCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CreateActivityCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var CreateActivityCommand = class _CreateActivityCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _CreateActivityCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "CreateActivityCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "CreateActivity"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_CreateActivityCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_CreateActivityCommand)(output, context);
      }
    };
    exports2.CreateActivityCommand = CreateActivityCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/CreateStateMachineAliasCommand.js
var require_CreateStateMachineAliasCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/CreateStateMachineAliasCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CreateStateMachineAliasCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var models_0_1 = require_models_03();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var CreateStateMachineAliasCommand = class _CreateStateMachineAliasCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _CreateStateMachineAliasCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "CreateStateMachineAliasCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: models_0_1.CreateStateMachineAliasInputFilterSensitiveLog,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "CreateStateMachineAlias"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_CreateStateMachineAliasCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_CreateStateMachineAliasCommand)(output, context);
      }
    };
    exports2.CreateStateMachineAliasCommand = CreateStateMachineAliasCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/CreateStateMachineCommand.js
var require_CreateStateMachineCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/CreateStateMachineCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CreateStateMachineCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var models_0_1 = require_models_03();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var CreateStateMachineCommand = class _CreateStateMachineCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _CreateStateMachineCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "CreateStateMachineCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: models_0_1.CreateStateMachineInputFilterSensitiveLog,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "CreateStateMachine"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_CreateStateMachineCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_CreateStateMachineCommand)(output, context);
      }
    };
    exports2.CreateStateMachineCommand = CreateStateMachineCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/DeleteActivityCommand.js
var require_DeleteActivityCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/DeleteActivityCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DeleteActivityCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var DeleteActivityCommand = class _DeleteActivityCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _DeleteActivityCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "DeleteActivityCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "DeleteActivity"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_DeleteActivityCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_DeleteActivityCommand)(output, context);
      }
    };
    exports2.DeleteActivityCommand = DeleteActivityCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/DeleteStateMachineAliasCommand.js
var require_DeleteStateMachineAliasCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/DeleteStateMachineAliasCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DeleteStateMachineAliasCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var DeleteStateMachineAliasCommand = class _DeleteStateMachineAliasCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _DeleteStateMachineAliasCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "DeleteStateMachineAliasCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "DeleteStateMachineAlias"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_DeleteStateMachineAliasCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_DeleteStateMachineAliasCommand)(output, context);
      }
    };
    exports2.DeleteStateMachineAliasCommand = DeleteStateMachineAliasCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/DeleteStateMachineCommand.js
var require_DeleteStateMachineCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/DeleteStateMachineCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DeleteStateMachineCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var DeleteStateMachineCommand = class _DeleteStateMachineCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _DeleteStateMachineCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "DeleteStateMachineCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "DeleteStateMachine"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_DeleteStateMachineCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_DeleteStateMachineCommand)(output, context);
      }
    };
    exports2.DeleteStateMachineCommand = DeleteStateMachineCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/DeleteStateMachineVersionCommand.js
var require_DeleteStateMachineVersionCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/DeleteStateMachineVersionCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DeleteStateMachineVersionCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var DeleteStateMachineVersionCommand = class _DeleteStateMachineVersionCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _DeleteStateMachineVersionCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "DeleteStateMachineVersionCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "DeleteStateMachineVersion"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_DeleteStateMachineVersionCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_DeleteStateMachineVersionCommand)(output, context);
      }
    };
    exports2.DeleteStateMachineVersionCommand = DeleteStateMachineVersionCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/DescribeActivityCommand.js
var require_DescribeActivityCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/DescribeActivityCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DescribeActivityCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var DescribeActivityCommand = class _DescribeActivityCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _DescribeActivityCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "DescribeActivityCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "DescribeActivity"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_DescribeActivityCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_DescribeActivityCommand)(output, context);
      }
    };
    exports2.DescribeActivityCommand = DescribeActivityCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/DescribeExecutionCommand.js
var require_DescribeExecutionCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/DescribeExecutionCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DescribeExecutionCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var models_0_1 = require_models_03();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var DescribeExecutionCommand = class _DescribeExecutionCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _DescribeExecutionCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "DescribeExecutionCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: models_0_1.DescribeExecutionOutputFilterSensitiveLog,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "DescribeExecution"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_DescribeExecutionCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_DescribeExecutionCommand)(output, context);
      }
    };
    exports2.DescribeExecutionCommand = DescribeExecutionCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/DescribeMapRunCommand.js
var require_DescribeMapRunCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/DescribeMapRunCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DescribeMapRunCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var DescribeMapRunCommand = class _DescribeMapRunCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _DescribeMapRunCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "DescribeMapRunCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "DescribeMapRun"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_DescribeMapRunCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_DescribeMapRunCommand)(output, context);
      }
    };
    exports2.DescribeMapRunCommand = DescribeMapRunCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/DescribeStateMachineAliasCommand.js
var require_DescribeStateMachineAliasCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/DescribeStateMachineAliasCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DescribeStateMachineAliasCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var models_0_1 = require_models_03();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var DescribeStateMachineAliasCommand = class _DescribeStateMachineAliasCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _DescribeStateMachineAliasCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "DescribeStateMachineAliasCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: models_0_1.DescribeStateMachineAliasOutputFilterSensitiveLog,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "DescribeStateMachineAlias"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_DescribeStateMachineAliasCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_DescribeStateMachineAliasCommand)(output, context);
      }
    };
    exports2.DescribeStateMachineAliasCommand = DescribeStateMachineAliasCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/DescribeStateMachineCommand.js
var require_DescribeStateMachineCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/DescribeStateMachineCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DescribeStateMachineCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var models_0_1 = require_models_03();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var DescribeStateMachineCommand = class _DescribeStateMachineCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _DescribeStateMachineCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "DescribeStateMachineCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: models_0_1.DescribeStateMachineOutputFilterSensitiveLog,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "DescribeStateMachine"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_DescribeStateMachineCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_DescribeStateMachineCommand)(output, context);
      }
    };
    exports2.DescribeStateMachineCommand = DescribeStateMachineCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/DescribeStateMachineForExecutionCommand.js
var require_DescribeStateMachineForExecutionCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/DescribeStateMachineForExecutionCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DescribeStateMachineForExecutionCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var models_0_1 = require_models_03();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var DescribeStateMachineForExecutionCommand = class _DescribeStateMachineForExecutionCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _DescribeStateMachineForExecutionCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "DescribeStateMachineForExecutionCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: models_0_1.DescribeStateMachineForExecutionOutputFilterSensitiveLog,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "DescribeStateMachineForExecution"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_DescribeStateMachineForExecutionCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_DescribeStateMachineForExecutionCommand)(output, context);
      }
    };
    exports2.DescribeStateMachineForExecutionCommand = DescribeStateMachineForExecutionCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/GetActivityTaskCommand.js
var require_GetActivityTaskCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/GetActivityTaskCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.GetActivityTaskCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var models_0_1 = require_models_03();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var GetActivityTaskCommand = class _GetActivityTaskCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _GetActivityTaskCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "GetActivityTaskCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: models_0_1.GetActivityTaskOutputFilterSensitiveLog,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "GetActivityTask"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_GetActivityTaskCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_GetActivityTaskCommand)(output, context);
      }
    };
    exports2.GetActivityTaskCommand = GetActivityTaskCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/GetExecutionHistoryCommand.js
var require_GetExecutionHistoryCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/GetExecutionHistoryCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.GetExecutionHistoryCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var models_0_1 = require_models_03();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var GetExecutionHistoryCommand = class _GetExecutionHistoryCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _GetExecutionHistoryCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "GetExecutionHistoryCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: models_0_1.GetExecutionHistoryOutputFilterSensitiveLog,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "GetExecutionHistory"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_GetExecutionHistoryCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_GetExecutionHistoryCommand)(output, context);
      }
    };
    exports2.GetExecutionHistoryCommand = GetExecutionHistoryCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/ListActivitiesCommand.js
var require_ListActivitiesCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/ListActivitiesCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ListActivitiesCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var ListActivitiesCommand = class _ListActivitiesCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _ListActivitiesCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "ListActivitiesCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "ListActivities"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_ListActivitiesCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_ListActivitiesCommand)(output, context);
      }
    };
    exports2.ListActivitiesCommand = ListActivitiesCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/ListExecutionsCommand.js
var require_ListExecutionsCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/ListExecutionsCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ListExecutionsCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var ListExecutionsCommand = class _ListExecutionsCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _ListExecutionsCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "ListExecutionsCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "ListExecutions"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_ListExecutionsCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_ListExecutionsCommand)(output, context);
      }
    };
    exports2.ListExecutionsCommand = ListExecutionsCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/ListMapRunsCommand.js
var require_ListMapRunsCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/ListMapRunsCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ListMapRunsCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var ListMapRunsCommand = class _ListMapRunsCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _ListMapRunsCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "ListMapRunsCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "ListMapRuns"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_ListMapRunsCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_ListMapRunsCommand)(output, context);
      }
    };
    exports2.ListMapRunsCommand = ListMapRunsCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/ListStateMachineAliasesCommand.js
var require_ListStateMachineAliasesCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/ListStateMachineAliasesCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ListStateMachineAliasesCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var ListStateMachineAliasesCommand = class _ListStateMachineAliasesCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _ListStateMachineAliasesCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "ListStateMachineAliasesCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "ListStateMachineAliases"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_ListStateMachineAliasesCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_ListStateMachineAliasesCommand)(output, context);
      }
    };
    exports2.ListStateMachineAliasesCommand = ListStateMachineAliasesCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/ListStateMachinesCommand.js
var require_ListStateMachinesCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/ListStateMachinesCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ListStateMachinesCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var ListStateMachinesCommand = class _ListStateMachinesCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _ListStateMachinesCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "ListStateMachinesCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "ListStateMachines"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_ListStateMachinesCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_ListStateMachinesCommand)(output, context);
      }
    };
    exports2.ListStateMachinesCommand = ListStateMachinesCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/ListStateMachineVersionsCommand.js
var require_ListStateMachineVersionsCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/ListStateMachineVersionsCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ListStateMachineVersionsCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var ListStateMachineVersionsCommand = class _ListStateMachineVersionsCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _ListStateMachineVersionsCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "ListStateMachineVersionsCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "ListStateMachineVersions"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_ListStateMachineVersionsCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_ListStateMachineVersionsCommand)(output, context);
      }
    };
    exports2.ListStateMachineVersionsCommand = ListStateMachineVersionsCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/ListTagsForResourceCommand.js
var require_ListTagsForResourceCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/ListTagsForResourceCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ListTagsForResourceCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var ListTagsForResourceCommand = class _ListTagsForResourceCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _ListTagsForResourceCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "ListTagsForResourceCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "ListTagsForResource"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_ListTagsForResourceCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_ListTagsForResourceCommand)(output, context);
      }
    };
    exports2.ListTagsForResourceCommand = ListTagsForResourceCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/PublishStateMachineVersionCommand.js
var require_PublishStateMachineVersionCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/PublishStateMachineVersionCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.PublishStateMachineVersionCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var models_0_1 = require_models_03();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var PublishStateMachineVersionCommand = class _PublishStateMachineVersionCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _PublishStateMachineVersionCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "PublishStateMachineVersionCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: models_0_1.PublishStateMachineVersionInputFilterSensitiveLog,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "PublishStateMachineVersion"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_PublishStateMachineVersionCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_PublishStateMachineVersionCommand)(output, context);
      }
    };
    exports2.PublishStateMachineVersionCommand = PublishStateMachineVersionCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/SendTaskFailureCommand.js
var require_SendTaskFailureCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/SendTaskFailureCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SendTaskFailureCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var models_0_1 = require_models_03();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var SendTaskFailureCommand = class _SendTaskFailureCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _SendTaskFailureCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "SendTaskFailureCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: models_0_1.SendTaskFailureInputFilterSensitiveLog,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "SendTaskFailure"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_SendTaskFailureCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_SendTaskFailureCommand)(output, context);
      }
    };
    exports2.SendTaskFailureCommand = SendTaskFailureCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/SendTaskHeartbeatCommand.js
var require_SendTaskHeartbeatCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/SendTaskHeartbeatCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SendTaskHeartbeatCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var SendTaskHeartbeatCommand = class _SendTaskHeartbeatCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _SendTaskHeartbeatCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "SendTaskHeartbeatCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "SendTaskHeartbeat"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_SendTaskHeartbeatCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_SendTaskHeartbeatCommand)(output, context);
      }
    };
    exports2.SendTaskHeartbeatCommand = SendTaskHeartbeatCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/SendTaskSuccessCommand.js
var require_SendTaskSuccessCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/SendTaskSuccessCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SendTaskSuccessCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var models_0_1 = require_models_03();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var SendTaskSuccessCommand = class _SendTaskSuccessCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _SendTaskSuccessCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "SendTaskSuccessCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: models_0_1.SendTaskSuccessInputFilterSensitiveLog,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "SendTaskSuccess"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_SendTaskSuccessCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_SendTaskSuccessCommand)(output, context);
      }
    };
    exports2.SendTaskSuccessCommand = SendTaskSuccessCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/StartExecutionCommand.js
var require_StartExecutionCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/StartExecutionCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.StartExecutionCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var models_0_1 = require_models_03();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var StartExecutionCommand = class _StartExecutionCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _StartExecutionCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "StartExecutionCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: models_0_1.StartExecutionInputFilterSensitiveLog,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "StartExecution"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_StartExecutionCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_StartExecutionCommand)(output, context);
      }
    };
    exports2.StartExecutionCommand = StartExecutionCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/StartSyncExecutionCommand.js
var require_StartSyncExecutionCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/StartSyncExecutionCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.StartSyncExecutionCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var models_0_1 = require_models_03();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var StartSyncExecutionCommand = class _StartSyncExecutionCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _StartSyncExecutionCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "StartSyncExecutionCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: models_0_1.StartSyncExecutionInputFilterSensitiveLog,
          outputFilterSensitiveLog: models_0_1.StartSyncExecutionOutputFilterSensitiveLog,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "StartSyncExecution"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_StartSyncExecutionCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_StartSyncExecutionCommand)(output, context);
      }
    };
    exports2.StartSyncExecutionCommand = StartSyncExecutionCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/StopExecutionCommand.js
var require_StopExecutionCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/StopExecutionCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.StopExecutionCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var models_0_1 = require_models_03();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var StopExecutionCommand = class _StopExecutionCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _StopExecutionCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "StopExecutionCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: models_0_1.StopExecutionInputFilterSensitiveLog,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "StopExecution"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_StopExecutionCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_StopExecutionCommand)(output, context);
      }
    };
    exports2.StopExecutionCommand = StopExecutionCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/TagResourceCommand.js
var require_TagResourceCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/TagResourceCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.TagResourceCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var TagResourceCommand = class _TagResourceCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _TagResourceCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "TagResourceCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "TagResource"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_TagResourceCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_TagResourceCommand)(output, context);
      }
    };
    exports2.TagResourceCommand = TagResourceCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/UntagResourceCommand.js
var require_UntagResourceCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/UntagResourceCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.UntagResourceCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var UntagResourceCommand = class _UntagResourceCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _UntagResourceCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "UntagResourceCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "UntagResource"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_UntagResourceCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_UntagResourceCommand)(output, context);
      }
    };
    exports2.UntagResourceCommand = UntagResourceCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/UpdateMapRunCommand.js
var require_UpdateMapRunCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/UpdateMapRunCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.UpdateMapRunCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var UpdateMapRunCommand = class _UpdateMapRunCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _UpdateMapRunCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "UpdateMapRunCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: (_) => _,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "UpdateMapRun"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_UpdateMapRunCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_UpdateMapRunCommand)(output, context);
      }
    };
    exports2.UpdateMapRunCommand = UpdateMapRunCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/UpdateStateMachineAliasCommand.js
var require_UpdateStateMachineAliasCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/UpdateStateMachineAliasCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.UpdateStateMachineAliasCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var models_0_1 = require_models_03();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var UpdateStateMachineAliasCommand = class _UpdateStateMachineAliasCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _UpdateStateMachineAliasCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "UpdateStateMachineAliasCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: models_0_1.UpdateStateMachineAliasInputFilterSensitiveLog,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "UpdateStateMachineAlias"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_UpdateStateMachineAliasCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_UpdateStateMachineAliasCommand)(output, context);
      }
    };
    exports2.UpdateStateMachineAliasCommand = UpdateStateMachineAliasCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/UpdateStateMachineCommand.js
var require_UpdateStateMachineCommand = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/UpdateStateMachineCommand.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.UpdateStateMachineCommand = exports2.$Command = void 0;
    var middleware_endpoint_1 = require_dist_cjs26();
    var middleware_serde_1 = require_dist_cjs25();
    var smithy_client_1 = require_dist_cjs34();
    Object.defineProperty(exports2, "$Command", { enumerable: true, get: function() {
      return smithy_client_1.Command;
    } });
    var types_1 = require_dist_cjs();
    var models_0_1 = require_models_03();
    var Aws_json1_0_1 = require_Aws_json1_0();
    var UpdateStateMachineCommand = class _UpdateStateMachineCommand extends smithy_client_1.Command {
      static getEndpointParameterInstructions() {
        return {
          UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
          Endpoint: { type: "builtInParams", name: "endpoint" },
          Region: { type: "builtInParams", name: "region" },
          UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
        };
      }
      constructor(input) {
        super();
        this.input = input;
      }
      resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, _UpdateStateMachineCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SFNClient";
        const commandName = "UpdateStateMachineCommand";
        const handlerExecutionContext = {
          logger,
          clientName,
          commandName,
          inputFilterSensitiveLog: models_0_1.UpdateStateMachineInputFilterSensitiveLog,
          outputFilterSensitiveLog: (_) => _,
          [types_1.SMITHY_CONTEXT_KEY]: {
            service: "AWSStepFunctions",
            operation: "UpdateStateMachine"
          }
        };
        const { requestHandler } = configuration;
        return stack.resolve((request2) => requestHandler.handle(request2.request, options || {}), handlerExecutionContext);
      }
      serialize(input, context) {
        return (0, Aws_json1_0_1.se_UpdateStateMachineCommand)(input, context);
      }
      deserialize(output, context) {
        return (0, Aws_json1_0_1.de_UpdateStateMachineCommand)(output, context);
      }
    };
    exports2.UpdateStateMachineCommand = UpdateStateMachineCommand;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/SFN.js
var require_SFN = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/SFN.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SFN = void 0;
    var smithy_client_1 = require_dist_cjs34();
    var CreateActivityCommand_1 = require_CreateActivityCommand();
    var CreateStateMachineAliasCommand_1 = require_CreateStateMachineAliasCommand();
    var CreateStateMachineCommand_1 = require_CreateStateMachineCommand();
    var DeleteActivityCommand_1 = require_DeleteActivityCommand();
    var DeleteStateMachineAliasCommand_1 = require_DeleteStateMachineAliasCommand();
    var DeleteStateMachineCommand_1 = require_DeleteStateMachineCommand();
    var DeleteStateMachineVersionCommand_1 = require_DeleteStateMachineVersionCommand();
    var DescribeActivityCommand_1 = require_DescribeActivityCommand();
    var DescribeExecutionCommand_1 = require_DescribeExecutionCommand();
    var DescribeMapRunCommand_1 = require_DescribeMapRunCommand();
    var DescribeStateMachineAliasCommand_1 = require_DescribeStateMachineAliasCommand();
    var DescribeStateMachineCommand_1 = require_DescribeStateMachineCommand();
    var DescribeStateMachineForExecutionCommand_1 = require_DescribeStateMachineForExecutionCommand();
    var GetActivityTaskCommand_1 = require_GetActivityTaskCommand();
    var GetExecutionHistoryCommand_1 = require_GetExecutionHistoryCommand();
    var ListActivitiesCommand_1 = require_ListActivitiesCommand();
    var ListExecutionsCommand_1 = require_ListExecutionsCommand();
    var ListMapRunsCommand_1 = require_ListMapRunsCommand();
    var ListStateMachineAliasesCommand_1 = require_ListStateMachineAliasesCommand();
    var ListStateMachinesCommand_1 = require_ListStateMachinesCommand();
    var ListStateMachineVersionsCommand_1 = require_ListStateMachineVersionsCommand();
    var ListTagsForResourceCommand_1 = require_ListTagsForResourceCommand();
    var PublishStateMachineVersionCommand_1 = require_PublishStateMachineVersionCommand();
    var SendTaskFailureCommand_1 = require_SendTaskFailureCommand();
    var SendTaskHeartbeatCommand_1 = require_SendTaskHeartbeatCommand();
    var SendTaskSuccessCommand_1 = require_SendTaskSuccessCommand();
    var StartExecutionCommand_1 = require_StartExecutionCommand();
    var StartSyncExecutionCommand_1 = require_StartSyncExecutionCommand();
    var StopExecutionCommand_1 = require_StopExecutionCommand();
    var TagResourceCommand_1 = require_TagResourceCommand();
    var UntagResourceCommand_1 = require_UntagResourceCommand();
    var UpdateMapRunCommand_1 = require_UpdateMapRunCommand();
    var UpdateStateMachineAliasCommand_1 = require_UpdateStateMachineAliasCommand();
    var UpdateStateMachineCommand_1 = require_UpdateStateMachineCommand();
    var SFNClient_1 = require_SFNClient();
    var commands = {
      CreateActivityCommand: CreateActivityCommand_1.CreateActivityCommand,
      CreateStateMachineCommand: CreateStateMachineCommand_1.CreateStateMachineCommand,
      CreateStateMachineAliasCommand: CreateStateMachineAliasCommand_1.CreateStateMachineAliasCommand,
      DeleteActivityCommand: DeleteActivityCommand_1.DeleteActivityCommand,
      DeleteStateMachineCommand: DeleteStateMachineCommand_1.DeleteStateMachineCommand,
      DeleteStateMachineAliasCommand: DeleteStateMachineAliasCommand_1.DeleteStateMachineAliasCommand,
      DeleteStateMachineVersionCommand: DeleteStateMachineVersionCommand_1.DeleteStateMachineVersionCommand,
      DescribeActivityCommand: DescribeActivityCommand_1.DescribeActivityCommand,
      DescribeExecutionCommand: DescribeExecutionCommand_1.DescribeExecutionCommand,
      DescribeMapRunCommand: DescribeMapRunCommand_1.DescribeMapRunCommand,
      DescribeStateMachineCommand: DescribeStateMachineCommand_1.DescribeStateMachineCommand,
      DescribeStateMachineAliasCommand: DescribeStateMachineAliasCommand_1.DescribeStateMachineAliasCommand,
      DescribeStateMachineForExecutionCommand: DescribeStateMachineForExecutionCommand_1.DescribeStateMachineForExecutionCommand,
      GetActivityTaskCommand: GetActivityTaskCommand_1.GetActivityTaskCommand,
      GetExecutionHistoryCommand: GetExecutionHistoryCommand_1.GetExecutionHistoryCommand,
      ListActivitiesCommand: ListActivitiesCommand_1.ListActivitiesCommand,
      ListExecutionsCommand: ListExecutionsCommand_1.ListExecutionsCommand,
      ListMapRunsCommand: ListMapRunsCommand_1.ListMapRunsCommand,
      ListStateMachineAliasesCommand: ListStateMachineAliasesCommand_1.ListStateMachineAliasesCommand,
      ListStateMachinesCommand: ListStateMachinesCommand_1.ListStateMachinesCommand,
      ListStateMachineVersionsCommand: ListStateMachineVersionsCommand_1.ListStateMachineVersionsCommand,
      ListTagsForResourceCommand: ListTagsForResourceCommand_1.ListTagsForResourceCommand,
      PublishStateMachineVersionCommand: PublishStateMachineVersionCommand_1.PublishStateMachineVersionCommand,
      SendTaskFailureCommand: SendTaskFailureCommand_1.SendTaskFailureCommand,
      SendTaskHeartbeatCommand: SendTaskHeartbeatCommand_1.SendTaskHeartbeatCommand,
      SendTaskSuccessCommand: SendTaskSuccessCommand_1.SendTaskSuccessCommand,
      StartExecutionCommand: StartExecutionCommand_1.StartExecutionCommand,
      StartSyncExecutionCommand: StartSyncExecutionCommand_1.StartSyncExecutionCommand,
      StopExecutionCommand: StopExecutionCommand_1.StopExecutionCommand,
      TagResourceCommand: TagResourceCommand_1.TagResourceCommand,
      UntagResourceCommand: UntagResourceCommand_1.UntagResourceCommand,
      UpdateMapRunCommand: UpdateMapRunCommand_1.UpdateMapRunCommand,
      UpdateStateMachineCommand: UpdateStateMachineCommand_1.UpdateStateMachineCommand,
      UpdateStateMachineAliasCommand: UpdateStateMachineAliasCommand_1.UpdateStateMachineAliasCommand
    };
    var SFN2 = class extends SFNClient_1.SFNClient {
    };
    exports2.SFN = SFN2;
    (0, smithy_client_1.createAggregatedClient)(commands, SFN2);
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/index.js
var require_commands3 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/commands/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_CreateActivityCommand(), exports2);
    tslib_1.__exportStar(require_CreateStateMachineAliasCommand(), exports2);
    tslib_1.__exportStar(require_CreateStateMachineCommand(), exports2);
    tslib_1.__exportStar(require_DeleteActivityCommand(), exports2);
    tslib_1.__exportStar(require_DeleteStateMachineAliasCommand(), exports2);
    tslib_1.__exportStar(require_DeleteStateMachineCommand(), exports2);
    tslib_1.__exportStar(require_DeleteStateMachineVersionCommand(), exports2);
    tslib_1.__exportStar(require_DescribeActivityCommand(), exports2);
    tslib_1.__exportStar(require_DescribeExecutionCommand(), exports2);
    tslib_1.__exportStar(require_DescribeMapRunCommand(), exports2);
    tslib_1.__exportStar(require_DescribeStateMachineAliasCommand(), exports2);
    tslib_1.__exportStar(require_DescribeStateMachineCommand(), exports2);
    tslib_1.__exportStar(require_DescribeStateMachineForExecutionCommand(), exports2);
    tslib_1.__exportStar(require_GetActivityTaskCommand(), exports2);
    tslib_1.__exportStar(require_GetExecutionHistoryCommand(), exports2);
    tslib_1.__exportStar(require_ListActivitiesCommand(), exports2);
    tslib_1.__exportStar(require_ListExecutionsCommand(), exports2);
    tslib_1.__exportStar(require_ListMapRunsCommand(), exports2);
    tslib_1.__exportStar(require_ListStateMachineAliasesCommand(), exports2);
    tslib_1.__exportStar(require_ListStateMachineVersionsCommand(), exports2);
    tslib_1.__exportStar(require_ListStateMachinesCommand(), exports2);
    tslib_1.__exportStar(require_ListTagsForResourceCommand(), exports2);
    tslib_1.__exportStar(require_PublishStateMachineVersionCommand(), exports2);
    tslib_1.__exportStar(require_SendTaskFailureCommand(), exports2);
    tslib_1.__exportStar(require_SendTaskHeartbeatCommand(), exports2);
    tslib_1.__exportStar(require_SendTaskSuccessCommand(), exports2);
    tslib_1.__exportStar(require_StartExecutionCommand(), exports2);
    tslib_1.__exportStar(require_StartSyncExecutionCommand(), exports2);
    tslib_1.__exportStar(require_StopExecutionCommand(), exports2);
    tslib_1.__exportStar(require_TagResourceCommand(), exports2);
    tslib_1.__exportStar(require_UntagResourceCommand(), exports2);
    tslib_1.__exportStar(require_UpdateMapRunCommand(), exports2);
    tslib_1.__exportStar(require_UpdateStateMachineAliasCommand(), exports2);
    tslib_1.__exportStar(require_UpdateStateMachineCommand(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/pagination/GetExecutionHistoryPaginator.js
var require_GetExecutionHistoryPaginator = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/pagination/GetExecutionHistoryPaginator.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.paginateGetExecutionHistory = void 0;
    var GetExecutionHistoryCommand_1 = require_GetExecutionHistoryCommand();
    var SFNClient_1 = require_SFNClient();
    var makePagedClientRequest = async (client, input, ...args) => {
      return await client.send(new GetExecutionHistoryCommand_1.GetExecutionHistoryCommand(input), ...args);
    };
    async function* paginateGetExecutionHistory(config, input, ...additionalArguments) {
      let token = config.startingToken || void 0;
      let hasNext = true;
      let page;
      while (hasNext) {
        input.nextToken = token;
        input["maxResults"] = config.pageSize;
        if (config.client instanceof SFNClient_1.SFNClient) {
          page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        } else {
          throw new Error("Invalid client, expected SFN | SFNClient");
        }
        yield page;
        const prevToken = token;
        token = page.nextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
      }
      return void 0;
    }
    exports2.paginateGetExecutionHistory = paginateGetExecutionHistory;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/pagination/Interfaces.js
var require_Interfaces2 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/pagination/Interfaces.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/pagination/ListActivitiesPaginator.js
var require_ListActivitiesPaginator = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/pagination/ListActivitiesPaginator.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.paginateListActivities = void 0;
    var ListActivitiesCommand_1 = require_ListActivitiesCommand();
    var SFNClient_1 = require_SFNClient();
    var makePagedClientRequest = async (client, input, ...args) => {
      return await client.send(new ListActivitiesCommand_1.ListActivitiesCommand(input), ...args);
    };
    async function* paginateListActivities(config, input, ...additionalArguments) {
      let token = config.startingToken || void 0;
      let hasNext = true;
      let page;
      while (hasNext) {
        input.nextToken = token;
        input["maxResults"] = config.pageSize;
        if (config.client instanceof SFNClient_1.SFNClient) {
          page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        } else {
          throw new Error("Invalid client, expected SFN | SFNClient");
        }
        yield page;
        const prevToken = token;
        token = page.nextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
      }
      return void 0;
    }
    exports2.paginateListActivities = paginateListActivities;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/pagination/ListExecutionsPaginator.js
var require_ListExecutionsPaginator = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/pagination/ListExecutionsPaginator.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.paginateListExecutions = void 0;
    var ListExecutionsCommand_1 = require_ListExecutionsCommand();
    var SFNClient_1 = require_SFNClient();
    var makePagedClientRequest = async (client, input, ...args) => {
      return await client.send(new ListExecutionsCommand_1.ListExecutionsCommand(input), ...args);
    };
    async function* paginateListExecutions(config, input, ...additionalArguments) {
      let token = config.startingToken || void 0;
      let hasNext = true;
      let page;
      while (hasNext) {
        input.nextToken = token;
        input["maxResults"] = config.pageSize;
        if (config.client instanceof SFNClient_1.SFNClient) {
          page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        } else {
          throw new Error("Invalid client, expected SFN | SFNClient");
        }
        yield page;
        const prevToken = token;
        token = page.nextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
      }
      return void 0;
    }
    exports2.paginateListExecutions = paginateListExecutions;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/pagination/ListMapRunsPaginator.js
var require_ListMapRunsPaginator = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/pagination/ListMapRunsPaginator.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.paginateListMapRuns = void 0;
    var ListMapRunsCommand_1 = require_ListMapRunsCommand();
    var SFNClient_1 = require_SFNClient();
    var makePagedClientRequest = async (client, input, ...args) => {
      return await client.send(new ListMapRunsCommand_1.ListMapRunsCommand(input), ...args);
    };
    async function* paginateListMapRuns(config, input, ...additionalArguments) {
      let token = config.startingToken || void 0;
      let hasNext = true;
      let page;
      while (hasNext) {
        input.nextToken = token;
        input["maxResults"] = config.pageSize;
        if (config.client instanceof SFNClient_1.SFNClient) {
          page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        } else {
          throw new Error("Invalid client, expected SFN | SFNClient");
        }
        yield page;
        const prevToken = token;
        token = page.nextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
      }
      return void 0;
    }
    exports2.paginateListMapRuns = paginateListMapRuns;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/pagination/ListStateMachinesPaginator.js
var require_ListStateMachinesPaginator = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/pagination/ListStateMachinesPaginator.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.paginateListStateMachines = void 0;
    var ListStateMachinesCommand_1 = require_ListStateMachinesCommand();
    var SFNClient_1 = require_SFNClient();
    var makePagedClientRequest = async (client, input, ...args) => {
      return await client.send(new ListStateMachinesCommand_1.ListStateMachinesCommand(input), ...args);
    };
    async function* paginateListStateMachines(config, input, ...additionalArguments) {
      let token = config.startingToken || void 0;
      let hasNext = true;
      let page;
      while (hasNext) {
        input.nextToken = token;
        input["maxResults"] = config.pageSize;
        if (config.client instanceof SFNClient_1.SFNClient) {
          page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        } else {
          throw new Error("Invalid client, expected SFN | SFNClient");
        }
        yield page;
        const prevToken = token;
        token = page.nextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
      }
      return void 0;
    }
    exports2.paginateListStateMachines = paginateListStateMachines;
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/pagination/index.js
var require_pagination3 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/pagination/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_GetExecutionHistoryPaginator(), exports2);
    tslib_1.__exportStar(require_Interfaces2(), exports2);
    tslib_1.__exportStar(require_ListActivitiesPaginator(), exports2);
    tslib_1.__exportStar(require_ListExecutionsPaginator(), exports2);
    tslib_1.__exportStar(require_ListMapRunsPaginator(), exports2);
    tslib_1.__exportStar(require_ListStateMachinesPaginator(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/models/index.js
var require_models3 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/models/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_models_03(), exports2);
  }
});

// ../../../node_modules/@aws-sdk/client-sfn/dist-cjs/index.js
var require_dist_cjs52 = __commonJS({
  "../../../node_modules/@aws-sdk/client-sfn/dist-cjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SFNServiceException = void 0;
    var tslib_1 = (init_tslib_es6(), __toCommonJS(tslib_es6_exports));
    tslib_1.__exportStar(require_SFNClient(), exports2);
    tslib_1.__exportStar(require_SFN(), exports2);
    tslib_1.__exportStar(require_commands3(), exports2);
    tslib_1.__exportStar(require_pagination3(), exports2);
    tslib_1.__exportStar(require_models3(), exports2);
    var SFNServiceException_1 = require_SFNServiceException();
    Object.defineProperty(exports2, "SFNServiceException", { enumerable: true, get: function() {
      return SFNServiceException_1.SFNServiceException;
    } });
  }
});

// ../../../node_modules/webidl-conversions/lib/index.js
var require_lib2 = __commonJS({
  "../../../node_modules/webidl-conversions/lib/index.js"(exports2, module2) {
    "use strict";
    var conversions = {};
    module2.exports = conversions;
    function sign(x) {
      return x < 0 ? -1 : 1;
    }
    function evenRound(x) {
      if (x % 1 === 0.5 && (x & 1) === 0) {
        return Math.floor(x);
      } else {
        return Math.round(x);
      }
    }
    function createNumberConversion(bitLength, typeOpts) {
      if (!typeOpts.unsigned) {
        --bitLength;
      }
      const lowerBound = typeOpts.unsigned ? 0 : -Math.pow(2, bitLength);
      const upperBound = Math.pow(2, bitLength) - 1;
      const moduloVal = typeOpts.moduloBitLength ? Math.pow(2, typeOpts.moduloBitLength) : Math.pow(2, bitLength);
      const moduloBound = typeOpts.moduloBitLength ? Math.pow(2, typeOpts.moduloBitLength - 1) : Math.pow(2, bitLength - 1);
      return function(V, opts) {
        if (!opts) opts = {};
        let x = +V;
        if (opts.enforceRange) {
          if (!Number.isFinite(x)) {
            throw new TypeError("Argument is not a finite number");
          }
          x = sign(x) * Math.floor(Math.abs(x));
          if (x < lowerBound || x > upperBound) {
            throw new TypeError("Argument is not in byte range");
          }
          return x;
        }
        if (!isNaN(x) && opts.clamp) {
          x = evenRound(x);
          if (x < lowerBound) x = lowerBound;
          if (x > upperBound) x = upperBound;
          return x;
        }
        if (!Number.isFinite(x) || x === 0) {
          return 0;
        }
        x = sign(x) * Math.floor(Math.abs(x));
        x = x % moduloVal;
        if (!typeOpts.unsigned && x >= moduloBound) {
          return x - moduloVal;
        } else if (typeOpts.unsigned) {
          if (x < 0) {
            x += moduloVal;
          } else if (x === -0) {
            return 0;
          }
        }
        return x;
      };
    }
    conversions["void"] = function() {
      return void 0;
    };
    conversions["boolean"] = function(val2) {
      return !!val2;
    };
    conversions["byte"] = createNumberConversion(8, { unsigned: false });
    conversions["octet"] = createNumberConversion(8, { unsigned: true });
    conversions["short"] = createNumberConversion(16, { unsigned: false });
    conversions["unsigned short"] = createNumberConversion(16, { unsigned: true });
    conversions["long"] = createNumberConversion(32, { unsigned: false });
    conversions["unsigned long"] = createNumberConversion(32, { unsigned: true });
    conversions["long long"] = createNumberConversion(32, { unsigned: false, moduloBitLength: 64 });
    conversions["unsigned long long"] = createNumberConversion(32, { 