"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpApiCall = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const api_call_base_1 = require("./api-call-base");
const providers_1 = require("./providers");
const waiter_state_machine_1 = require("./waiter-state-machine");
/**
 * Construct that creates a custom resource that will perform
 * an HTTP API Call
 */
class HttpApiCall extends api_call_base_1.ApiCallBase {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_HttpCallProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpApiCall);
            }
            throw error;
        }
        let name = '';
        if (!aws_cdk_lib_1.Token.isUnresolved(props.url)) {
            const url = new URL(props.url);
            name = `${url.hostname}${url.pathname}`.replace(/\/|\.|:/g, '');
        }
        this.provider = new providers_1.AssertionsProvider(this, 'HttpProvider');
        this.apiCallResource = new aws_cdk_lib_1.CustomResource(this, 'Default', {
            serviceToken: this.provider.serviceToken,
            properties: {
                parameters: props,
                expected: aws_cdk_lib_1.Lazy.any({ produce: () => this.expectedResult }),
                stateMachineArn: aws_cdk_lib_1.Lazy.string({ produce: () => this.stateMachineArn }),
                salt: Date.now().toString(),
            },
            resourceType: `${providers_1.HTTP_RESOURCE_TYPE}${name}`.substring(0, 60),
        });
        // Needed so that all the policies set up by the provider should be available before the custom resource is provisioned.
        this.apiCallResource.node.addDependency(this.provider);
        aws_cdk_lib_1.Aspects.of(this).add({
            visit(node) {
                if (node instanceof HttpApiCall) {
                    if (node.expectedResult) {
                        const result = node.apiCallResource.getAttString('assertion');
                        new aws_cdk_lib_1.CfnOutput(node, 'AssertionResults', {
                            value: result,
                        }).overrideLogicalId(`AssertionResults${id.replace(/[\W_]+/g, '')}`);
                    }
                }
            },
        });
    }
    assertAtPath(_path, _expected) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_ExpectedResult(_expected);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.assertAtPath);
            }
            throw error;
        }
        return this;
    }
    waitForAssertions(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_WaiterStateMachineOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.waitForAssertions);
            }
            throw error;
        }
        const waiter = new waiter_state_machine_1.WaiterStateMachine(this, 'WaitFor', {
            ...options,
        });
        this.stateMachineArn = waiter.stateMachineArn;
        this.provider.addPolicyStatementFromSdkCall('states', 'StartExecution');
        return this;
    }
    ;
}
exports.HttpApiCall = HttpApiCall;
_a = JSII_RTTI_SYMBOL_1;
HttpApiCall[_a] = { fqn: "@aws-cdk/integ-tests-alpha.HttpApiCall", version: "2.151.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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