import * as kplus from 'cdk8s-plus-22';
import { Construct } from 'constructs';
export interface PostgresOptions {
    readonly databaseName?: string;
    readonly databaseUser?: string;
    readonly databasePassword?: string;
}
export interface IngressOptions {
    readonly hostName?: string;
}
export interface MetaflowServiceProps {
    readonly serviceAccountName?: string;
    readonly serviceName?: string;
    readonly image?: string;
    readonly metadataServicePort?: number;
    readonly upgradesServicePort?: number;
    readonly postgresEnabled?: boolean;
    readonly postgresOptions?: PostgresOptions;
    readonly ingressEnabled?: boolean;
    readonly ingressOptions?: IngressOptions;
}
export declare class MetaflowService extends Construct {
    readonly deployment: kplus.Deployment;
    readonly service: kplus.Service;
    constructor(scope: Construct, id: string, props?: MetaflowServiceProps);
}
