// g2o - General Graph Optimization
// Copyright (C) 2011 R. Kuemmerle, G.Grisetti, W. Burgard
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// * Redistributions of source code must retain the above copyright notice,
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the
//   documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
// IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
// PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
// TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#ifndef G2O_GM2DLIO_H
#define G2O_GM2DLIO_H

#include <string>

#include "g2o_calibration_odom_laser_api.h"

namespace g2o {

class SparseOptimizer;
class DataQueue;

/**
 * \brief read / write gm2dl file into / out of a SparseOptimizer
 */
class G2O_CALIBRATION_ODOM_LASER_API Gm2dlIO {
 public:
  /**
   * the global ID we assign the laser pose vertex
   */
  static const int kIdLaserpose;
  static const int kIdOdomcalib;

  static bool readGm2dl(const std::string& filename, SparseOptimizer& optimizer,
                        bool overrideCovariances = false);

  static bool updateLaserData(SparseOptimizer& optimizer);

  static bool writeGm2dl(const std::string& filename,
                         const SparseOptimizer& optimizer);

  static int readRobotLaser(const std::string& filename, DataQueue& queue);
};

}  // namespace g2o

#endif
