import { Duration, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { ILambdaDeploymentConfig } from './deployment-config';
/**
 * Lambda Deployment config type.
 *
 * @stability stable
 */
export declare enum CustomLambdaDeploymentConfigType {
    /**
     * Canary deployment type.
     *
     * @stability stable
     */
    CANARY = "Canary",
    /**
     * Linear deployment type.
     *
     * @stability stable
     */
    LINEAR = "Linear"
}
/**
 * Properties of a reference to a CodeDeploy Lambda Deployment Configuration.
 *
 * @stability stable
 */
export interface CustomLambdaDeploymentConfigProps {
    /**
     * The type of deployment config, either CANARY or LINEAR.
     *
     * @stability stable
     */
    readonly type: CustomLambdaDeploymentConfigType;
    /**
     * The integer percentage of traffic to shift: - For LINEAR, the percentage to shift every interval - For CANARY, the percentage to shift until the interval passes, before the full deployment.
     *
     * @stability stable
     */
    readonly percentage: number;
    /**
     * The interval, in number of minutes: - For LINEAR, how frequently additional traffic is shifted - For CANARY, how long to shift traffic before the full deployment.
     *
     * @stability stable
     */
    readonly interval: Duration;
    /**
     * The verbatim name of the deployment config.
     *
     * Must be unique per account/region.
     * Other parameters cannot be updated if this name is provided.
     *
     * @default - automatically generated name
     * @stability stable
     */
    readonly deploymentConfigName?: string;
}
/**
 * A custom Deployment Configuration for a Lambda Deployment Group.
 *
 * @stability stable
 * @resource AWS::CodeDeploy::DeploymentGroup
 */
export declare class CustomLambdaDeploymentConfig extends Resource implements ILambdaDeploymentConfig {
    /**
     * The name of the deployment config.
     *
     * @stability stable
     * @attribute true
     */
    readonly deploymentConfigName: string;
    /**
     * The arn of the deployment config.
     *
     * @stability stable
     * @attribute true
     */
    readonly deploymentConfigArn: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: CustomLambdaDeploymentConfigProps);
    private validateParameters;
}
