#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['pandasdmx',
 'pandasdmx.format',
 'pandasdmx.reader',
 'pandasdmx.source',
 'pandasdmx.tests',
 'pandasdmx.tests.data',
 'pandasdmx.writer']

package_data = \
{'': ['*'],
 'pandasdmx.tests': ['data/.cache/*',
                     'data/ECB/*',
                     'data/ECB_EXR/*',
                     'data/ECB_EXR/1/*',
                     'data/ESTAT/*',
                     'data/IMF/*',
                     'data/INSEE/*',
                     'data/ISTAT/*',
                     'data/SGR/*',
                     'data/UNSD/*',
                     'data/expected/*',
                     'format/*',
                     'reader/*',
                     'writer/*']}

install_requires = \
['requests >=2.7', 'lxml >= 3.6', 'pandas >= 1.0', 'pydantic >= 1.5']

extras_require = \
{'cache': ['requests_cache'],
 'doc': ['sphinx >= 2.3', 'IPython'],
 'test': ['pytest >= 5', 'requests-mock >= 1.4']}

setup(name='pandaSDMX',
      version='1.3.0',
      description='Statistical Data and Metadata eXchange (SDMX) for the Python data ecosystem',
      author='dr-leo',
      author_email='fhaxbox66@gmail.com',
      url='https://github.com/dr-leo/pandasdmx',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.7.3,<4',
     )
