import fuzzylite as fl

engine = fl.Engine(
    name="Discrete", description="obstacle avoidance for self-driving cars"
)
engine.input_variables = [
    fl.InputVariable(
        name="obstacle",
        description="location of obstacle relative to vehicle",
        enabled=True,
        minimum=0.000000000,
        maximum=1.000000000,
        lock_range=False,
        terms=[
            fl.Triangle("left", 0.000000000, 0.333000000, 0.666000000),
            fl.Triangle("right", 0.333000000, 0.666000000, 1.000000000),
        ],
    )
]
engine.output_variables = [
    fl.OutputVariable(
        name="steer",
        description="direction to steer the vehicle to",
        enabled=True,
        minimum=0.000000000,
        maximum=1.000000000,
        lock_range=False,
        aggregation=fl.Maximum(),
        defuzzifier=fl.Centroid(100),
        lock_previous=False,
        terms=[
            fl.Discrete(
                "left",
                [
                    0.000000000,
                    0.000000000,
                    0.006660000,
                    0.020000000,
                    0.013320000,
                    0.040000000,
                    0.019980000,
                    0.060000000,
                    0.026640000,
                    0.080000000,
                    0.033300000,
                    0.100000000,
                    0.039960000,
                    0.120000000,
                    0.046620000,
                    0.140000000,
                    0.053280000,
                    0.160000000,
                    0.059940000,
                    0.180000000,
                    0.066600000,
                    0.200000000,
                    0.073260000,
                    0.220000000,
                    0.079920000,
                    0.240000000,
                    0.086580000,
                    0.260000000,
                    0.093240000,
                    0.280000000,
                    0.099900000,
                    0.300000000,
                    0.106560000,
                    0.320000000,
                    0.113220000,
                    0.340000000,
                    0.119880000,
                    0.360000000,
                    0.126540000,
                    0.380000000,
                    0.133200000,
                    0.400000000,
                    0.139860000,
                    0.420000000,
                    0.146520000,
                    0.440000000,
                    0.153180000,
                    0.460000000,
                    0.159840000,
                    0.480000000,
                    0.166500000,
                    0.500000000,
                    0.173160000,
                    0.520000000,
                    0.179820000,
                    0.540000000,
                    0.186480000,
                    0.560000000,
                    0.193140000,
                    0.580000000,
                    0.199800000,
                    0.600000000,
                    0.206460000,
                    0.620000000,
                    0.213120000,
                    0.640000000,
                    0.219780000,
                    0.660000000,
                    0.226440000,
                    0.680000000,
                    0.233100000,
                    0.700000000,
                    0.239760000,
                    0.720000000,
                    0.246420000,
                    0.740000000,
                    0.253080000,
                    0.760000000,
                    0.259740000,
                    0.780000000,
                    0.266400000,
                    0.800000000,
                    0.273060000,
                    0.820000000,
                    0.279720000,
                    0.840000000,
                    0.286380000,
                    0.860000000,
                    0.293040000,
                    0.880000000,
                    0.299700000,
                    0.900000000,
                    0.306360000,
                    0.920000000,
                    0.313020000,
                    0.940000000,
                    0.319680000,
                    0.960000000,
                    0.326340000,
                    0.980000000,
                    0.333000000,
                    1.000000000,
                    0.339660000,
                    0.980000000,
                    0.346320000,
                    0.960000000,
                    0.352980000,
                    0.940000000,
                    0.359640000,
                    0.920000000,
                    0.366300000,
                    0.900000000,
                    0.372960000,
                    0.880000000,
                    0.379620000,
                    0.860000000,
                    0.386280000,
                    0.840000000,
                    0.392940000,
                    0.820000000,
                    0.399600000,
                    0.800000000,
                    0.406260000,
                    0.780000000,
                    0.412920000,
                    0.760000000,
                    0.419580000,
                    0.740000000,
                    0.426240000,
                    0.720000000,
                    0.432900000,
                    0.700000000,
                    0.439560000,
                    0.680000000,
                    0.446220000,
                    0.660000000,
                    0.452880000,
                    0.640000000,
                    0.459540000,
                    0.620000000,
                    0.466200000,
                    0.600000000,
                    0.472860000,
                    0.580000000,
                    0.479520000,
                    0.560000000,
                    0.486180000,
                    0.540000000,
                    0.492840000,
                    0.520000000,
                    0.499500000,
                    0.500000000,
                    0.506160000,
                    0.480000000,
                    0.512820000,
                    0.460000000,
                    0.519480000,
                    0.440000000,
                    0.526140000,
                    0.420000000,
                    0.532800000,
                    0.400000000,
                    0.539460000,
                    0.380000000,
                    0.546120000,
                    0.360000000,
                    0.552780000,
                    0.340000000,
                    0.559440000,
                    0.320000000,
                    0.566100000,
                    0.300000000,
                    0.572760000,
                    0.280000000,
                    0.579420000,
                    0.260000000,
                    0.586080000,
                    0.240000000,
                    0.592740000,
                    0.220000000,
                    0.599400000,
                    0.200000000,
                    0.606060000,
                    0.180000000,
                    0.612720000,
                    0.160000000,
                    0.619380000,
                    0.140000000,
                    0.626040000,
                    0.120000000,
                    0.632700000,
                    0.100000000,
                    0.639360000,
                    0.080000000,
                    0.646020000,
                    0.060000000,
                    0.652680000,
                    0.040000000,
                    0.659340000,
                    0.020000000,
                    0.666000000,
                    0.000000000,
                ],
            ),
            fl.Discrete(
                "right",
                [
                    0.333000000,
                    0.000000000,
                    0.339670000,
                    0.020030030,
                    0.346340000,
                    0.040060060,
                    0.353010000,
                    0.060090090,
                    0.359680000,
                    0.080120120,
                    0.366350000,
                    0.100150150,
                    0.373020000,
                    0.120180180,
                    0.379690000,
                    0.140210210,
                    0.386360000,
                    0.160240240,
                    0.393030000,
                    0.180270270,
                    0.399700000,
                    0.200300300,
                    0.406370000,
                    0.220330330,
                    0.413040000,
                    0.240360360,
                    0.419710000,
                    0.260390390,
                    0.426380000,
                    0.280420420,
                    0.433050000,
                    0.300450450,
                    0.439720000,
                    0.320480480,
                    0.446390000,
                    0.340510511,
                    0.453060000,
                    0.360540541,
                    0.459730000,
                    0.380570571,
                    0.466400000,
                    0.400600601,
                    0.473070000,
                    0.420630631,
                    0.479740000,
                    0.440660661,
                    0.486410000,
                    0.460690691,
                    0.493080000,
                    0.480720721,
                    0.499750000,
                    0.500750751,
                    0.506420000,
                    0.520780781,
                    0.513090000,
                    0.540810811,
                    0.519760000,
                    0.560840841,
                    0.526430000,
                    0.580870871,
                    0.533100000,
                    0.600900901,
                    0.539770000,
                    0.620930931,
                    0.546440000,
                    0.640960961,
                    0.553110000,
                    0.660990991,
                    0.559780000,
                    0.681021021,
                    0.566450000,
                    0.701051051,
                    0.573120000,
                    0.721081081,
                    0.579790000,
                    0.741111111,
                    0.586460000,
                    0.761141141,
                    0.593130000,
                    0.781171171,
                    0.599800000,
                    0.801201201,
                    0.606470000,
                    0.821231231,
                    0.613140000,
                    0.841261261,
                    0.619810000,
                    0.861291291,
                    0.626480000,
                    0.881321321,
                    0.633150000,
                    0.901351351,
                    0.639820000,
                    0.921381381,
                    0.646490000,
                    0.941411411,
                    0.653160000,
                    0.961441441,
                    0.659830000,
                    0.981471471,
                    0.666500000,
                    0.998502994,
                    0.673170000,
                    0.978532934,
                    0.679840000,
                    0.958562874,
                    0.686510000,
                    0.938592814,
                    0.693180000,
                    0.918622754,
                    0.699850000,
                    0.898652695,
                    0.706520000,
                    0.878682635,
                    0.713190000,
                    0.858712575,
                    0.719860000,
                    0.838742515,
                    0.726530000,
                    0.818772455,
                    0.733200000,
                    0.798802395,
                    0.739870000,
                    0.778832335,
                    0.746540000,
                    0.758862275,
                    0.753210000,
                    0.738892216,
                    0.759880000,
                    0.718922156,
                    0.766550000,
                    0.698952096,
                    0.773220000,
                    0.678982036,
                    0.779890000,
                    0.659011976,
                    0.786560000,
                    0.639041916,
                    0.793230000,
                    0.619071856,
                    0.799900000,
                    0.599101796,
                    0.806570000,
                    0.579131737,
                    0.813240000,
                    0.559161677,
                    0.819910000,
                    0.539191617,
                    0.826580000,
                    0.519221557,
                    0.833250000,
                    0.499251497,
                    0.839920000,
                    0.479281437,
                    0.846590000,
                    0.459311377,
                    0.853260000,
                    0.439341317,
                    0.859930000,
                    0.419371257,
                    0.866600000,
                    0.399401198,
                    0.873270000,
                    0.379431138,
                    0.879940000,
                    0.359461078,
                    0.886610000,
                    0.339491018,
                    0.893280000,
                    0.319520958,
                    0.899950000,
                    0.299550898,
                    0.906620000,
                    0.279580838,
                    0.913290000,
                    0.259610778,
                    0.919960000,
                    0.239640719,
                    0.926630000,
                    0.219670659,
                    0.933300000,
                    0.199700599,
                    0.939970000,
                    0.179730539,
                    0.946640000,
                    0.159760479,
                    0.953310000,
                    0.139790419,
                    0.959980000,
                    0.119820359,
                    0.966650000,
                    0.099850299,
                    0.973320000,
                    0.079880240,
                    0.979990000,
                    0.059910180,
                    0.986660000,
                    0.039940120,
                    0.993330000,
                    0.019970060,
                    1.000000000,
                    0.000000000,
                ],
            ),
        ],
    )
]
engine.rule_blocks = [
    fl.RuleBlock(
        name="steer_away",
        description="steer away from obstacles",
        enabled=True,
        conjunction=None,
        disjunction=None,
        implication=fl.Minimum(),
        activation=fl.General(),
        rules=[
            fl.Rule.create("if obstacle is left then steer is right", engine),
            fl.Rule.create("if obstacle is right then steer is left", engine),
        ],
    )
]
