from typing import overload

from ..pointer import NativePointer

class NativeStdString:
    """原生 `std::string`"""

    def __init__(self, init: str | NativePointer) -> None: ...
    @property
    def npos(self) -> int: ...
    def clear(self) -> None: ...
    def size(self) -> int: ...
    def length(self) -> int: ...
    def capacity(self) -> int: ...
    def empty(self) -> bool: ...
    def front(self) -> str: ...
    def back(self) -> str: ...
    def pop_back(self) -> None: ...
    def shrink_to_fit(self) -> None: ...
    def at(self, index: str) -> str: ...
    def append(self, string: str) -> NativeStdString: ...
    def push_back(self, string: str) -> NativeStdString: ...
    def assign(self, string: str) -> NativeStdString: ...
    def insert(self, index: int, string: str) -> NativeStdString: ...
    @overload
    def erase(self, offset: int) -> NativeStdString: ...
    @overload
    def erase(self, offset: int, count: int) -> NativeStdString: ...
    @overload
    def find(self, string: str) -> int: ...
    @overload
    def find(self, string: str, offset: int) -> int: ...
    @overload
    def rfind(self, string: str) -> int: ...
    @overload
    def rfind(self, string: str, offset: int) -> int: ...
    @overload
    def substr(self, offset: int) -> NativeStdString: ...
    @overload
    def substr(self, offset: int, count: int) -> NativeStdString: ...
    def compare(self, string: str) -> int: ...
    def reserve(self, new_cap: int) -> None: ...
    def resize(self, size: int) -> None: ...
    def toString(self) -> str: ...
    def asPointer(self) -> NativePointer: ...
    def clone(self) -> NativeStdString: ...
    def destroy(self) -> None: ...
