import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Schema for Module Fragment of type zmk::IAM::LambdaBasicRole::MODULE
 *
 * @schema CfnLambdaBasicRoleModuleProps
 */
export interface CfnLambdaBasicRoleModuleProps {
    /**
     * @schema CfnLambdaBasicRoleModuleProps#Resources
     */
    readonly resources?: CfnLambdaBasicRoleModulePropsResources;
}
/**
 * Converts an object of type 'CfnLambdaBasicRoleModuleProps' to JSON representation.
 */
export declare function toJson_CfnLambdaBasicRoleModuleProps(obj: CfnLambdaBasicRoleModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLambdaBasicRoleModulePropsResources
 */
export interface CfnLambdaBasicRoleModulePropsResources {
    /**
     * @schema CfnLambdaBasicRoleModulePropsResources#IAMRole
     */
    readonly iamRole?: CfnLambdaBasicRoleModulePropsResourcesIamRole;
}
/**
 * Converts an object of type 'CfnLambdaBasicRoleModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnLambdaBasicRoleModulePropsResources(obj: CfnLambdaBasicRoleModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLambdaBasicRoleModulePropsResourcesIamRole
 */
export interface CfnLambdaBasicRoleModulePropsResourcesIamRole {
    /**
     * @schema CfnLambdaBasicRoleModulePropsResourcesIamRole#Type
     */
    readonly type?: string;
    /**
     * @schema CfnLambdaBasicRoleModulePropsResourcesIamRole#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnLambdaBasicRoleModulePropsResourcesIamRole' to JSON representation.
 */
export declare function toJson_CfnLambdaBasicRoleModulePropsResourcesIamRole(obj: CfnLambdaBasicRoleModulePropsResourcesIamRole | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `zmk::IAM::LambdaBasicRole::MODULE`
 *
 * @cloudformationResource zmk::IAM::LambdaBasicRole::MODULE
 * @stability external
 * @link http://unknown-url
 */
export declare class CfnLambdaBasicRoleModule extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "zmk::IAM::LambdaBasicRole::MODULE";
    /**
     * Resource props.
     */
    readonly props: CfnLambdaBasicRoleModuleProps;
    /**
     * Create a new `zmk::IAM::LambdaBasicRole::MODULE`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnLambdaBasicRoleModuleProps);
}
