# AUTOGENERATED! DO NOT EDIT! File to edit: 00_core.ipynb (unless otherwise specified).

__all__ = ['get_labels_and_preds', 'visualize_cam_on_img', 'rename_in_order', 'init_images_dir',
           'split_images_into_train_valid_test']

# Cell
def get_labels_and_preds(predictions):
  df = pd.DataFrame(predictions[0])
  preds = (df[0] < df[1]).astype(int)
  labels = predictions[1]
  return labels, preds

def visualize_cam_on_img(img_name, model):
  cam_extractor = SmoothGradCAMpp(model)
  img = read_image(str(img_name))
  input_tensor = normalize(resize(img, (224, 224)) / 255., [0.485, 0.456, 0.406], [0.229, 0.224, 0.225]).cuda()
  out = model(input_tensor.unsqueeze(0))
  activation_map = cam_extractor(out.squeeze(0).argmax().item(), out)
  result = overlay_mask(to_pil_image(img), to_pil_image(activation_map, mode='F'), alpha=0.5)
  plt.imshow(result); plt.axis('off'); plt.tight_layout(); plt.show()

def rename_in_order(folder):
    files = list(folder.glob("*"))
    temp_folder = folder / "temp"
    temp_folder.mkdir()
    target_files = []
    for i in range(len(files)):
        source = files[i]
        target = temp_folder / f"{i+1:03}.jpg"
        target_files.append(target)
        shutil.move(source, target)
    for file in target_files:
        shutil.copy2(file, folder)
    shutil.rmtree(temp_folder)

def init_images_dir(images):
  if images.exists():
    shutil.rmtree(images)

  images.mkdir()

  train_folder = images / "train"
  valid_folder = images / "valid"
  test_folder = images / "test"

  train_folder.mkdir()
  valid_folder.mkdir()
  test_folder.mkdir()

def split_images_into_train_valid_test(mycls, images, images_original, train_ratio=0.7, test_ratio=0.1):

    files = list((images_original / mycls).glob("*.jpg"))

    train_length = round(len(files) * train_ratio)
    test_length = round(len(files) * test_ratio)

    train = files[:train_length]
    valid = files[train_length:len(files) - test_length]
    test = files[len(files) - test_length:]

    train_folder = images / "train"
    valid_folder = images / "valid"
    test_folder = images / "test"

    (train_folder / mycls).mkdir()
    (valid_folder / mycls).mkdir()
    (test_folder / mycls).mkdir()

    for file in train:
        shutil.copy(file, train_folder / mycls)

    for file in valid:
        shutil.copy(file, valid_folder / mycls)

    for file in test:
        shutil.copy(file, test_folder / mycls)

    rename_in_order(train_folder / mycls)
    rename_in_order(valid_folder / mycls)
    rename_in_order(test_folder / mycls)