"""track-error-and-task-cancellation

Revision ID: 006
Revises: 005
Create Date: 2025-01-17 21:35:57.061233

"""

from typing import Sequence, Union

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision: str = "006"
down_revision: Union[str, None] = "005"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "document_collections",
        "text_processing_config",
        existing_type=postgresql.JSON(astext_type=sa.Text()),
        comment="Configuration for text processing including: chunk_token_size, min_chunk_size_chars, etc.",
        existing_nullable=False,
    )
    op.add_column("tasks", sa.Column("error", sa.String(), nullable=True))
    op.alter_column(
        "vector_indices",
        "embedding_config",
        existing_type=postgresql.JSON(astext_type=sa.Text()),
        comment="Configuration for embeddings including: model, dimensions, batch_size, etc.",
        existing_nullable=False,
    )

    # Update TaskStatus enum type
    op.execute("ALTER TYPE taskstatus ADD VALUE IF NOT EXISTS 'CANCELED'")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "vector_indices",
        "embedding_config",
        existing_type=postgresql.JSON(astext_type=sa.Text()),
        comment=None,
        existing_comment="Configuration for embeddings including: model, dimensions, batch_size, etc.",
        existing_nullable=False,
    )
    op.drop_column("tasks", "error")
    op.alter_column(
        "document_collections",
        "text_processing_config",
        existing_type=postgresql.JSON(astext_type=sa.Text()),
        comment=None,
        existing_comment="Configuration for text processing including: chunk_token_size, min_chunk_size_chars, etc.",
        existing_nullable=False,
    )
    # ### end Alembic commands ###
