# Generated by Django 3.2.10 on 2021-12-27 23:08

import aleksis.core.managers
import django.contrib.sites.managers
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('core', '0030_user_attributes'),
        ('sites', '0002_alter_domain_unique'),
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='MatrixRoom',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', models.JSONField(default=dict, editable=False)),
                ('room_id', models.CharField(max_length=255, unique=True, verbose_name='Room ID')),
                ('alias', models.CharField(blank=True, max_length=255, unique=True, verbose_name='Alias')),
                ('group', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='matrix_room', to='core.group', verbose_name='Group')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_matrix.matrixroom_set+', to='contenttypes.contenttype')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
            ],
            options={
                'verbose_name': 'Matrix room',
                'verbose_name_plural': 'Matrix rooms',
                'permissions': (('provision_group_in_matrix', 'Can provision group in Matrix'),),
            },
            managers=[
                ('objects', aleksis.core.managers.PolymorphicCurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='MatrixProfile',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', models.JSONField(default=dict, editable=False)),
                ('matrix_id', models.CharField(max_length=255, unique=True, verbose_name='Matrix ID')),
                ('person', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='matrix_profile', to='core.person', verbose_name='Person')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
            ],
            options={
                'verbose_name': 'Matrix profile',
                'verbose_name_plural': 'Matrix profiles',
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='MatrixSpace',
            fields=[
                ('matrixroom_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='matrix.matrixroom')),
                ('children', models.ManyToManyField(blank=True, related_name='parents', to='matrix.MatrixRoom', verbose_name='Child rooms/spaces')),
            ],
            options={
                'verbose_name': 'Matrix space',
                'verbose_name_plural': 'Matrix spaces',
            },
            bases=('matrix.matrixroom',),
            managers=[
                ('objects', aleksis.core.managers.PolymorphicCurrentSiteManager()),
            ],
        ),
    ]
