# Python: Moving Intelligence

Home Assistant Python 3 API wrapper for Moving Intelligence asset and fleet management

## About

This package allows the Home Assistant integration 'moving_intelligence' to get get data from https://movingintelligence.com/en/.

NOTE: You need a login account together with an apikey to be able to use it.

## Installation

```bash
pip3 install pymovingintelligence_ha
```

## Example code

```python
#!/usr/bin/env python3

from pymovingintelligence_ha import MovingIntelligence, InvalidAuthError, InvalidPermissionsError
import logging
import sys
import json
import time

logger = logging.getLogger(__name__)
logging.basicConfig(level=logging.DEBUG)

try:
    ## Init

    # Initialize API client with your login name and apikey
    api = MovingIntelligence(
        username="YOUR USERNAME",
        apikey="YOUR APIKEY",
    )
    try:
        devices = api.get_devices()

        for device in devices:
           print(device.state_attributes)
    except InvalidAuthError:
        logger.debug("Authenticaton error, your username and/or apikey is invalid.")
    except InvalidPermissionsError:
        logger.error("No permission to access this data")
    except requests.exceptions.ConnectionError:
        logger.error("ConnectionError: Could not connect to MovingIntelligence")

```
