from genomoncology import kms
from cytoolz.curried import assoc, compose
from genomoncology.parse.doctypes import DocType, __CHILD__, __TYPE__
from genomoncology.pipeline.transformers import register, name_mapping


NAME_MAPPING = {
    # hgvs
    "chr": "chr",
    "start": "start",
    "ref": "ref",
    "alt": "alt",
    "build": "build",
    # info
    "AC__mint": "info.AC",
    "AF__mfloat": "info.AF",
    "AN__mint": "info.AN",
    "BaseQRankSum__mfloat": "info.BaseQRankSum",
    "ClippingRankSum__mfloat": "info.ClippingRankSum",
    "DB__mstring": "info.DB",
    "DP__mint": "info.DP",
    "FS__mfloat": "info.FS",
    "InbreedingCoeff__mfloat": "info.InbreedingCoeff",
    "MQ__mfloat": "info.MQ",
    "MQRankSum__mfloat": "info.MQRankSum",
    "QD__mfloat": "info.QD",
    "ReadPosRankSum__mfloat": "info.ReadPosRankSum",
    "SOR__mfloat": "info.SOR",
    "VQSR_culprit__mstring": "info.VQSR_culprit",
    "VQSR_NEGATIVE_TRAIN_SITE__mstring": "info.VQSR_NEGATIVE_TRAIN_SITE",
    "VQSR_POSITIVE_TRAIN_SITE__mstring": "info.VQSR_POSITIVE_TRAIN_SITE",
    "GQ_HIST_ALT__mstring": "info.GQ_HIST_ALT",
    "DP_HIST_ALT__mstring": "info.DP_HIST_ALT",
    "AB_HIST_ALT__mstring": "info.AB_HIST_ALT",
    "GQ_HIST_ALL__mstring": "info.GQ_HIST_ALL",
    "DP_HIST_ALL__mstring": "info.DP_HIST_ALL",
    "AB_HIST_ALL__mstring": "info.AB_HIST_ALL",
    "AC_AFR__mint": "info.AC_AFR",
    "AC_AMR__mint": "info.AC_AMR",
    "AC_ASJ__mint": "info.AC_ASJ",
    "AC_EAS__mint": "info.AC_EAS",
    "AC_FIN__mint": "info.AC_FIN",
    "AC_NFE__mint": "info.AC_NFE",
    "AC_OTH__mint": "info.AC_OTH",
    "AC_Male__mint": "info.AC_Male",
    "AC_Female__mint": "info.AC_Female",
    "AN_AFR__mint": "info.AN_AFR",
    "AN_AMR__mint": "info.AN_AMR",
    "AN_ASJ__mint": "info.AN_ASJ",
    "AN_EAS__mint": "info.AN_EAS",
    "AN_FIN__mint": "info.AN_FIN",
    "AN_NFE__mint": "info.AN_NFE",
    "AN_OTH__mint": "info.AN_OTH",
    "AN_Male__mint": "info.AN_Male",
    "AN_Female__mint": "info.AN_Female",
    "AF_AFR__float": "info.AF_AFR",
    "AF_AMR__mfloat": "info.AF_AMR",
    "AF_ASJ__mfloat": "info.AF_ASJ",
    "AF_EAS__mfloat": "info.AF_EAS",
    "AF_FIN__mfloat": "info.AF_FIN",
    "AF_NFE__mfloat": "info.AF_NFE",
    "AF_OTH__mfloat": "info.AF_OTH",
    "AF_Male__mfloat": "info.AF_Male",
    "AF_Female__mfloat": "info.AF_Female",
    "GC_AFR__mint": "info.GC_AFR",
    "GC_AMR__mint": "info.GC_AMR",
    "GC_ASJ__mint": "info.GC_ASJ",
    "GC_EAS__mint": "info.GC_EAS",
    "GC_FIN__mint": "info.GC_FIN",
    "GC_NFE__mint": "info.GC_NFE",
    "GC_OTH__mint": "info.GC_OTH",
    "GC_Male__mint": "info.GC_Male",
    "GC_Female__mint": "info.GC_Female",
    "AC_raw__mint": "info.AC_raw",
    "AN_raw__mint": "info.AN_raw",
    "AF_raw__mfloat": "info.AF_raw",
    "GC_raw__mint": "info.GC_raw",
    "GC__mint": "info.GC",
    "Hom_AFR__mint": "info.Hom_AFR",
    "Hom_AMR__mint": "info.Hom_AMR",
    "Hom_ASJ__mint": "info.Hom_ASJ",
    "Hom_EAS__mint": "info.Hom_EAS",
    "Hom_FIN__mint": "info.Hom_FIN",
    "Hom_NFE__mint": "info.Hom_NFE",
    "Hom_OTH__mint": "info.Hom_OTH",
    "Hom_Male__mint": "info.Hom_Male",
    "Hom_Female__mint": "info.Hom_Female",
    "Hom_raw__mint": "info.Hom_raw",
    "Hom__mint": "info.Hom",
    "STAR_AC__mint": "info.STAR_AC",
    "STAR_AC_raw__mint": "info.STAR_AC_raw",
    "STAR_Hom__mint": "info.STAR_Hom",
    "POPMAX__mstring": "info.POPMAX",
    "AC_POPMAX__mint": "info.AC_POPMAX",
    "AN_POPMAX__mint": "info.AN_POPMAX",
    "AF_POPMAX__mfloat": "info.AF_POPMAX",
    "DP_MEDIAN__mint": "info.DP_MEDIAN",
    "DREF_MEDIAN__mfloat": "info.DREF_MEDIAN",
    "GQ_MEDIAN__mfloat": "info.GQ_MEDIAN",
    "AB_MEDIAN__mfloat": "info.AB_MEDIAN",
    "AS_RF__mfloat": "info.AS_RF",
    "AS_FilterStatus__mstring": "info.AS_FilterStatus",
    "AS_RF_POSITIVE_TRAIN__mint": "info.AS_RF_POSITIVE_TRAIN",
    "AS_RF_NEGATIVE_TRAIN__mint": "info.AS_RF_NEGATIVE_TRAIN",
    "CSQ__mstring": "info.CSQ",
}

register(
    input_type=DocType.CALL,
    output_type=DocType.GNOMAD,
    transformer=compose(
        lambda x: assoc(x, "hgvs_g", kms.annotations.to_csra(x)),
        lambda x: assoc(x, __TYPE__, DocType.GNOMAD.value),
        name_mapping(NAME_MAPPING),
    ),
)

register(
    input_type=DocType.CALL,
    output_type=DocType.GNOMAD,
    transformer=compose(lambda x: assoc(x, __CHILD__, DocType.GNOMAD.value)),
    is_header=True,
)
