#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""The setup script."""

from setuptools import setup, find_packages

with open('README.rst') as readme_file:
    readme = readme_file.read()

with open('HISTORY.rst') as history_file:
    history = history_file.read()

requirements = ['Click>=6.0', ]

setup_requirements = ['pytest-runner', ]

test_requirements = ['pytest', ]

setup(
    author="Jonathan Chukinas",
    author_email='chukinas@gmail.com',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Natural Language :: English',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
    ],
    description="Utility for J&J Cross-Sector Mentoring Program that matches mentors with mentees.",
    entry_points={
        'console_scripts': [
            'mentormatch=src:main',
        ],
    },
    install_requires=requirements,
    license="MIT license",
    long_description=readme + '\n\n' + history,
    # TODO no long_description_content_type as suggested in pypi tut?
    include_package_data=True,
    keywords='mentormatch',
    name='mentormatch',
    packages=find_packages(where='src'),
    setup_requires=setup_requirements,
    test_suite='tests',
    tests_require=test_requirements,
    url='https://github.com/jonathanchukinas/mentormatch',
    version='0.1.5',
    zip_safe=False,
)

# Deployment Workflow:
#   update version (x2)
#   cd to project folder
#   terminal: `python setup.py sdist bdist_wheel`
#       Q: What should I do with the old ones? Delete?
#   terminal: `twine upload dist/*`
