#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# Copyright 2021-2022 NXP
#
# The MIT License (MIT)
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.


import logging
from fc_common.version import get_runtime_version
from fc_server.core.coordinator import Coordinator


def main():
    product_text = r"""
______                                           _    _____                     _ _             _             
|  ___|                                         | |  /  __ \                   | (_)           | |            
| |_ _ __ __ _ _ __ ___   _____      _____  _ __| | _| /  \/ ___   ___  _ __ __| |_ _ __   __ _| |_ ___  _ __ 
|  _| '__/ _` | '_ ` _ \ / _ \ \ /\ / / _ \| '__| |/ / |    / _ \ / _ \| '__/ _` | | '_ \ / _` | __/ _ \| '__|
| | | | | (_| | | | | | |  __/\ V  V / (_) | |  |   <| \__/\ (_) | (_) | | | (_| | | | | | (_| | || (_) | |   
\_| |_|  \__,_|_| |_| |_|\___| \_/\_/ \___/|_|  |_|\_\\____/\___/ \___/|_|  \__,_|_|_| |_|\__,_|\__\___/|_|   
    """
    logging.info(product_text)
    logging.info("VERSION: %s", get_runtime_version("fc-server"))

    Coordinator().start()


if __name__ == "__main__":
    main()
