

SELECT
	DISTINCT
	CE.CLENUM_COMPTE,
	CE.CLENUM_SEQ_COMPTE,
	C.DMF_ID AS CONTRACT_DMF_ID,
	G.CONTRACT_ENTRY_DMF_ID,
	R.RIGHT_GROUP_DMF_ID,
	W.RIGHT_DMF_ID,
	CH.WINDOW_DMF_ID,
	CD.DMF_ID AS COST_DEF_DMF_ID,
	CD.SPLIT_GROUP_DMF_ID,
	C.ARIANE_CONTRACT_CODE,
	CD.ARIANE_PRODUCT_CODE
FROM
	WonV16_CONTRACT C,
	WonV16_CONTRACT_ENTRY_TRANSC CE,
	WonV16_RIGHT_GROUP G,
	WonV16_RIGHT R,
	WonV16_WINDOW W,
	WonV16_R_CHANNEL_GROUPS CH,
	WonV16_COST_DEFINITION CD
WHERE
	C.DMF_ID = CE.SUBCONTRACT_DMF_ID
	AND G.CONTRACT_ENTRY_DMF_ID = CE.DMF_ID
	AND G.DMF_ID = R.RIGHT_GROUP_DMF_ID
	AND W.RIGHT_DMF_ID = R.DMF_ID
	AND CH.WINDOW_DMF_ID = W.DMF_ID
	AND CD.RIGHT_GROUP_DMF_ID = G.DMF_ID

GO