[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![Read the Docs](https://readthedocs.org/projects/notabene-cli/badge/?version=latest)](https://notabene-cli.readthedocs.io/en/latest/?badge=latest)
![Code Quality](https://github.com/JeroenPeterBos/notabene-cli/actions/workflows/code-quality.yaml/badge.svg)
![Platform Tests](https://github.com/JeroenPeterBos/notabene-cli/actions/workflows/platform-tests.yaml/badge.svg)
![Python Versions](https://img.shields.io/pypi/pyversions/notabene-cli)
![PyPI](https://img.shields.io/pypi/v/notabene-cli)

<p align="center">
    <img width="60%" src="https://raw.githubusercontent.com/JeroenPeterBos/notabene-cli/main/docs/_static/images/logo_wide.svg">

</p>

<p align="center">

Bring best practices from software engineering to your jupyter notebooks using [NotaBene](https://github.com/JeroenPeterBos/notabene-cli). 

</p>

Knowledge is best transfered when its presentation is familiar. Notabene enables you to standardize and simplify knowledge transfer on data insights.

* Homepage: https://notabene.cloud/
* Source Code: https://github.com/JeroenPeterBos/notabene-cli
* Documentation: https://notabene-cli.readthedocs.io
* PyPI: https://pypi.org/project/notabene-cli/

## Features

* Notebook Templates
    * Create and use your own library of notebook templates

## Getting Started

The project's documentation contains a section to help you
[get started](https://notabene-cli.readthedocs.io/en/latest/quickstart.html).

### Installation

Install [NotaBene](https://github.com/JeroenPeterBos/notabene-cli) using:

```
pip install notabene-cli
```

### Usage

Ensure you have a `pyproject.toml` file in the root of your project (can be empty).
Run on of the following commands to interact with the templates in your project.

```
notabene template create
notabene template list
notabene template use
```

For more information on how to get started **[visit the documentation](https://notabene-cli.readthedocs.io/en/latest)**.

## Development Prerequisites

If you're going to be working in the code (rather than just using the library), you'll want a few utilities.

* [GNU Make](https://www.gnu.org/software/make/)
* [Conda](https://docs.conda.io/en/latest/miniconda.html)

## Authors

* **Jeroen Peter Bos** - *Initial work* - [github](https://github.com/JeroenPeterBos)

See also the list of [contributors](https://github.com/JeroenPeterBos/notabene/contributors) who participated in this project.

## LicenseCopyright (c) Jeroen Peter Bos

All rights reserved.