# Generated by Django 3.1.2 on 2020-12-24 15:08

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import blueprints.validators


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("eveuniverse", "0004_effect_longer_name"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("eveonline", "0012_index_additions"),
        ("authentication", "0017_remove_fleetup_permission"),
    ]

    operations = [
        migrations.CreateModel(
            name="General",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "permissions": (
                    ("basic_access", "Can access this app"),
                    ("request_blueprints", "Can request blueprints"),
                    ("manage_requests", "Can review and accept blueprint requests"),
                    (
                        "add_personal_blueprint_owner",
                        "Can add personal blueprint owners",
                    ),
                    (
                        "add_corporate_blueprint_owner",
                        "Can add corporate blueprint owners",
                    ),
                    ("view_alliance_blueprints", "Can view alliance's blueprints"),
                    (
                        "view_industry_jobs",
                        "Can view details about running industry jobs",
                    ),
                ),
                "managed": False,
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="Blueprint",
            fields=[
                (
                    "item_id",
                    models.PositiveBigIntegerField(
                        help_text="The EVE Item ID of the blueprint",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "location_flag",
                    models.CharField(
                        choices=[
                            ("AssetSafety", "AssetSafety"),
                            ("AutoFit", "AutoFit"),
                            ("Bonus", "Bonus"),
                            ("Booster", "Booster"),
                            ("BoosterBay", "BoosterBay"),
                            ("Capsule", "Capsule"),
                            ("Cargo", "Cargo"),
                            ("CorpDeliveries", "CorpDeliveries"),
                            ("CorpSAG1", "CorpSAG1"),
                            ("CorpSAG2", "CorpSAG2"),
                            ("CorpSAG3", "CorpSAG3"),
                            ("CorpSAG4", "CorpSAG4"),
                            ("CorpSAG5", "CorpSAG5"),
                            ("CorpSAG6", "CorpSAG6"),
                            ("CorpSAG7", "CorpSAG7"),
                            ("CrateLoot", "CrateLoot"),
                            ("Deliveries", "Deliveries"),
                            ("DroneBay", "DroneBay"),
                            ("DustBattle", "DustBattle"),
                            ("DustDatabank", "DustDatabank"),
                            ("FighterBay", "FighterBay"),
                            ("FighterTube0", "FighterTube0"),
                            ("FighterTube1", "FighterTube1"),
                            ("FighterTube2", "FighterTube2"),
                            ("FighterTube3", "FighterTube3"),
                            ("FighterTube4", "FighterTube4"),
                            ("FleetHangar", "FleetHangar"),
                            ("FrigateEscapeBay", "FrigateEscapeBay"),
                            ("Hangar", "Hangar"),
                            ("HangarAll", "HangarAll"),
                            ("HiSlot0", "HiSlot0"),
                            ("HiSlot1", "HiSlot1"),
                            ("HiSlot2", "HiSlot2"),
                            ("HiSlot3", "HiSlot3"),
                            ("HiSlot4", "HiSlot4"),
                            ("HiSlot5", "HiSlot5"),
                            ("HiSlot6", "HiSlot6"),
                            ("HiSlot7", "HiSlot7"),
                            ("HiddenModifiers", "HiddenModifiers"),
                            ("Implant", "Implant"),
                            ("Impounded", "Impounded"),
                            ("JunkyardReprocessed", "JunkyardReprocessed"),
                            ("JunkyardTrashed", "JunkyardTrashed"),
                            ("LoSlot0", "LoSlot0"),
                            ("LoSlot1", "LoSlot1"),
                            ("LoSlot2", "LoSlot2"),
                            ("LoSlot3", "LoSlot3"),
                            ("LoSlot4", "LoSlot4"),
                            ("LoSlot5", "LoSlot5"),
                            ("LoSlot6", "LoSlot6"),
                            ("LoSlot7", "LoSlot7"),
                            ("Locked", "Locked"),
                            ("MedSlot0", "MedSlot0"),
                            ("MedSlot1", "MedSlot1"),
                            ("MedSlot2", "MedSlot2"),
                            ("MedSlot3", "MedSlot3"),
                            ("MedSlot4", "MedSlot4"),
                            ("MedSlot5", "MedSlot5"),
                            ("MedSlot6", "MedSlot6"),
                            ("MedSlot7", "MedSlot7"),
                            ("OfficeFolder", "OfficeFolder"),
                            ("Pilot", "Pilot"),
                            ("PlanetSurface", "PlanetSurface"),
                            ("QuafeBay", "QuafeBay"),
                            ("QuantumCoreRoom", "QuantumCoreRoom"),
                            ("Reward", "Reward"),
                            ("RigSlot0", "RigSlot0"),
                            ("RigSlot1", "RigSlot1"),
                            ("RigSlot2", "RigSlot2"),
                            ("RigSlot3", "RigSlot3"),
                            ("RigSlot4", "RigSlot4"),
                            ("RigSlot5", "RigSlot5"),
                            ("RigSlot6", "RigSlot6"),
                            ("RigSlot7", "RigSlot7"),
                            ("SecondaryStorage", "SecondaryStorage"),
                            ("ServiceSlot0", "ServiceSlot0"),
                            ("ServiceSlot1", "ServiceSlot1"),
                            ("ServiceSlot2", "ServiceSlot2"),
                            ("ServiceSlot3", "ServiceSlot3"),
                            ("ServiceSlot4", "ServiceSlot4"),
                            ("ServiceSlot5", "ServiceSlot5"),
                            ("ServiceSlot6", "ServiceSlot6"),
                            ("ServiceSlot7", "ServiceSlot7"),
                            ("ShipHangar", "ShipHangar"),
                            ("ShipOffline", "ShipOffline"),
                            ("Skill", "Skill"),
                            ("SkillInTraining", "SkillInTraining"),
                            ("SpecializedAmmoHold", "SpecializedAmmoHold"),
                            (
                                "SpecializedCommandCenterHold",
                                "SpecializedCommandCenterHold",
                            ),
                            ("SpecializedFuelBay", "SpecializedFuelBay"),
                            ("SpecializedGasHold", "SpecializedGasHold"),
                            (
                                "SpecializedIndustrialShipHold",
                                "SpecializedIndustrialShipHold",
                            ),
                            ("SpecializedLargeShipHold", "SpecializedLargeShipHold"),
                            ("SpecializedMaterialBay", "SpecializedMaterialBay"),
                            ("SpecializedMediumShipHold", "SpecializedMediumShipHold"),
                            ("SpecializedMineralHold", "SpecializedMineralHold"),
                            ("SpecializedOreHold", "SpecializedOreHold"),
                            (
                                "SpecializedPlanetaryCommoditiesHold",
                                "SpecializedPlanetaryCommoditiesHold",
                            ),
                            ("SpecializedSalvageHold", "SpecializedSalvageHold"),
                            ("SpecializedShipHold", "SpecializedShipHold"),
                            ("SpecializedSmallShipHold", "SpecializedSmallShipHold"),
                            ("StructureActive", "StructureActive"),
                            ("StructureFuel", "StructureFuel"),
                            ("StructureInactive", "StructureInactive"),
                            ("StructureOffline", "StructureOffline"),
                            ("SubSystemBay", "SubSystemBay"),
                            ("SubSystemSlot0", "SubSystemSlot0"),
                            ("SubSystemSlot1", "SubSystemSlot1"),
                            ("SubSystemSlot2", "SubSystemSlot2"),
                            ("SubSystemSlot3", "SubSystemSlot3"),
                            ("SubSystemSlot4", "SubSystemSlot4"),
                            ("SubSystemSlot5", "SubSystemSlot5"),
                            ("SubSystemSlot6", "SubSystemSlot6"),
                            ("SubSystemSlot7", "SubSystemSlot7"),
                            ("Unlocked", "Unlocked"),
                            ("Wallet", "Wallet"),
                            ("Wardrobe", "Wardrobe"),
                        ],
                        help_text="Additional location information",
                        max_length=36,
                    ),
                ),
                (
                    "quantity",
                    models.PositiveIntegerField(
                        default=1, help_text="Number of blueprints"
                    ),
                ),
                (
                    "runs",
                    models.PositiveIntegerField(
                        blank=True,
                        help_text="Runs remaining or null if the blueprint is an original",
                        null=True,
                    ),
                ),
                (
                    "material_efficiency",
                    models.PositiveIntegerField(
                        help_text="Material efficiency of the blueprint",
                        validators=[blueprints.validators.validate_material_efficiency],
                    ),
                ),
                (
                    "time_efficiency",
                    models.PositiveIntegerField(
                        help_text="Time efficiency of the blueprint",
                        validators=[blueprints.validators.validate_time_efficiency],
                    ),
                ),
                (
                    "eve_type",
                    models.ForeignKey(
                        help_text="Blueprint type",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="eveuniverse.evetype",
                    ),
                ),
            ],
            options={
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="Request",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "runs",
                    models.PositiveIntegerField(
                        blank=True,
                        help_text="Runs requested or blank for maximum allowed",
                        null=True,
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("OP", "Open"),
                            ("IP", "In Progress"),
                            ("FL", "Fulfilled"),
                            ("CL", "Cancelled"),
                        ],
                        help_text="Status of the blueprint request",
                        max_length=2,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                (
                    "closed_at",
                    models.DateTimeField(blank=True, db_index=True, null=True),
                ),
                (
                    "blueprint",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="blueprints.blueprint",
                    ),
                ),
                (
                    "fulfulling_user",
                    models.ForeignKey(
                        blank=True,
                        help_text="The user that fulfilled the request, if it has been fulfilled",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "requesting_user",
                    models.ForeignKey(
                        help_text="The requesting user",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="Owner",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        default=True,
                        help_text="whether this owner is currently included in the sync process",
                    ),
                ),
                (
                    "character",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        help_text="character used for syncing blueprints",
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="+",
                        to="authentication.characterownership",
                    ),
                ),
                (
                    "corporation",
                    models.OneToOneField(
                        blank=True,
                        default=None,
                        help_text="Corporation owning blueprints, if this is a 'corporate' owner",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="eveonline.evecorporationinfo",
                    ),
                ),
            ],
            options={
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="Location",
            fields=[
                (
                    "id",
                    models.PositiveBigIntegerField(
                        help_text="Eve Online location ID, either item ID for stations or structure ID for structures",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="In-game name of this station or structure",
                        max_length=100,
                    ),
                ),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "eve_solar_system",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="+",
                        to="eveuniverse.evesolarsystem",
                    ),
                ),
                (
                    "eve_type",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="+",
                        to="eveuniverse.evetype",
                    ),
                ),
                (
                    "owner",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        help_text="corporation this station or structure belongs to",
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="+",
                        to="eveuniverse.eveentity",
                    ),
                ),
                (
                    "parent",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        help_text="Eve Online location ID of the parent object",
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="+",
                        to="blueprints.location",
                    ),
                ),
            ],
            options={
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="IndustryJob",
            fields=[
                (
                    "id",
                    models.PositiveBigIntegerField(
                        help_text="Eve Online job ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "activity",
                    models.PositiveIntegerField(
                        choices=[
                            (1, "Manufacturing"),
                            (2, "Researching Technology"),
                            (3, "Researching Time Efficiency"),
                            (4, "Researching Material Efficiency"),
                            (5, "Copying"),
                            (6, "Duplicating"),
                            (7, "Reverse Engineering"),
                            (8, "Inventing"),
                            (9, "Reacting"),
                        ]
                    ),
                ),
                ("start_date", models.DateTimeField()),
                ("end_date", models.DateTimeField()),
                ("runs", models.PositiveIntegerField()),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("active", "Active"),
                            ("cancelled", "Cancelled"),
                            ("delivered", "Delivered"),
                            ("paused", "Paused"),
                            ("ready", "Ready"),
                            ("reverted", "Reverted"),
                        ],
                        max_length=10,
                    ),
                ),
                (
                    "blueprint",
                    models.OneToOneField(
                        help_text="Blueprint the job is running",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="blueprints.blueprint",
                    ),
                ),
                (
                    "installer",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="jobs",
                        to="eveonline.evecharacter",
                    ),
                ),
                (
                    "location",
                    models.ForeignKey(
                        help_text="Eve Online location ID of the facility in which the job is running",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="blueprints.location",
                    ),
                ),
                (
                    "owner",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="jobs",
                        to="blueprints.owner",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="blueprint",
            name="location",
            field=models.ForeignKey(
                help_text="Blueprint location",
                on_delete=django.db.models.deletion.CASCADE,
                to="blueprints.location",
            ),
        ),
        migrations.AddField(
            model_name="blueprint",
            name="owner",
            field=models.ForeignKey(
                help_text="Corporation that owns the blueprint",
                on_delete=django.db.models.deletion.CASCADE,
                to="blueprints.owner",
            ),
        ),
    ]
