import logging
from threading import Thread
from time import sleep
from typing import Mapping

from featureguards.feature_toggles import FeatureToggles, init

MAX_RETRIES = 20
MAX_START_SLEEP_SEC = 20


def feature_flags(api_key: str,
                  defaults: Mapping[str, bool] = None,
                  addr='api.featureguards.com') -> FeatureToggles:
    """ Returns an instance of FeatureGuards that can be used for to check feature flags.
        Parameters:
            api_key: str
                The API key generated by featureguards.com.
            defaults: Mapping[str, bool], optional
                Setting different default values for each feature flag.
    """
    fg = init(api_key, addr, defaults)

    def retry() -> None:
        for i in range(MAX_RETRIES):
            try:
                fg._start()
                return
            except Exception:
                wait_sec = min(2 << i, MAX_START_SLEEP_SEC)
                sleep(wait_sec)

    try:
        fg._start()
    except Exception as ex:
        logging.error(ex)

        # Let's do it async
        thread = Thread(target=retry, daemon=True)
        thread.start()

    return fg
