# Tab (and Spaces) Style Checker for flake8

Like tabs? So do I.

This module provides a smart indentation checking module for the awesome
[`flake8`](https://flake8.readthedocs.io/) style checker suite, featuring
[`pycodestyle`](https://pycodestyle.readthedocs.io/),
[`pyflakes`](https://github.com/PyCQA/pyflakes) and
[`mccabe`](https://github.com/pycqa/mccabe)
by default as well as a minimalist plugin architecture.

When enabled *flake8-tabs* will disable *pycodestyle*'s “tabs_or_spaces”, “continued_indentation”,
“tabs_obsolete” and “trailing_whitespace” checkers by default. Replacing them by its own more
flexible checkers, that allow for the “tabs for indentation, spaces for alignment” paradgime to be
applied to your source code – or simply getting a better indentation checker for your spaces based
source code.

Useful Links:

 * [PyPI Module Listing](https://pypi.org/project/flake8-tabs/)
 * [Project Issues](https://gitlab.com/ntninja/flake8-tabs/issues)
 * [License](https://gitlab.com/ntninja/flake8-tabs/blob/master/LICENSE.md) (LGPLv3+)

## Reported Error Codes

All error codes were borrowed from *pycodestyle*. You can detect that they were generated by
*flake8-tabs* by them being followed by the word `(flake8-tabs)` as well as the extra `T` added
after the initial severity letter.


| Error Code | Meaning                                                                                          |
| ---------- | ------------------------------------------------------------------------------------------------ |
| ET101      | Mixed block of tabs and spaces detected where there as a least one tab *following* a space       |
| ET121, ET122, ET123, ET126, ET127, ET128 | Identation did not match what was expected (somewhat configurable) |
| WT291      | Extranous whitespace detected on end of line                                                     |
| WT293      | Whitespace that was not aligned with the next block of source code detected (configurable)       |

Also note that, due to the way we disable the relevant checkers from *pycodestyle* the following
error code **do not have an equivalent** in this plugin: E124, E125, E129, E131, E133.

## Options

Note that in the following *indenting* refers to the practice of adding new levels of indentation
(usually using tab key whether you're using tabs or not) on a separate line, while *aligning*
refers to the practice of adding spacing in front of the elements on the following line to make
them visually match the elements on the previous line. *Indentation* may refer to any of the above.

Defaults tend to reflect recommendations from PEP-8.

### `use-flake8-tabs`

 * Default: *false*
 * Allowed values: *true*, *false*

Enable *flake8-tabs* for indentation checking and, by default, disable the comparable checkers from
*pycodestyle* (see below). Without setting this to *true*, or passing it as `--use-flake8-tabs` on
the command-line, only *flake8-tabs*'s blank line indentation checking will be enabled. While this
flag is disabled it is guaranteed no errors will be reported where *pycodestyle* will not report
one as well. While further checks may be enabled at some point that do not require use of this
flag, they will not ever break this guarantee.

This way you can selectively disable errors from *pycodestyle* and incrementally depend on the
smarter checkers in *flake8-tabs*.

### `use-pycodestyle-indent`

 * Default: *false* if `use-flake8-tabs` is *true* otherwise *true*
 * Allowed values: *true*, *false*

If *false* indentation style checks from *pycodestyle* will be disabled, see the last option for
details.

### `tab-width`

 * Default: *4*
 * Allowed values: Any integer >= 1

The expected size of each tab in spaces. This is not really specific to this plugin, but used to
properly calculate the required additional spaced indentation when indenting within an aligned
section.

### `blank-lines-indent`

 * Default: *"maybe"*
 * Allowed values: *"maybe"*, *"always"*, *"never"*

Whether to allow, properly aligned, indentation in blank lines. The default value will allow both
aligned indentation and no indentation. *"always"* will require blank lines to contain indentation,
*"never"* will prohibit it.

By properly aligned indentation we mean indentation that has the same value as the indentation of
the next block of source code:

```py
# This is OK:
def main():
↹	# … snip …
↹	do_something()
↹	
↹	do_something_else()
↹	# … snip …

# This is not OK:
def main():
↹	while True:
↹	↹	# … snip …
↹	↹	do_something()
↹	
↹	↹	do_something_else()
↹	↹	# … snip …

# This is by default OK as well (unindented):
def main():
↹	while True:
↹	↹	# … snip …
↹	↹	do_something()

↹	↹	do_something_else()
↹	↹	# … snip …
```

### Minimal Tab Sizes when Indenting

(Note that a tab here may also refer to an equivalent number of spaces based on the configured
tab width.)

#### `indent-tabs-call`

 * Default: *1*
 * Allowed values: Any integer >= 1

The number of tabs to add when adding the first level of indentation using indenting within a
function or method call:

```py
# Example with: indent-tabs-call=3
x = long_function_name(
↹	↹	↹	{  # First level gets 3 levels of indenting
↹	↹	↹	↹	"name": "value"  # Next level is indented as usual
↹	↹	↹	},
↹	↹	↹	param2, param3
)
```

Usually you should leave this at *1* (PEP-8) but some teams may prefer a value of *2* to function
calls more easily distinguishable from blocks.

#### `indent-tabs-def`

 * Default: *2*
 * Allowed values: Any integer >= 1

The number of tabs to add when adding the first level of indentation using indenting within a
class of method definition:

```py
# Example with the default of: indent-tabs-def=2
def main(
↹	↹	param1, param2, param3,
↹	↹	param4):
↹	initialize_something()
)
```

Notice in the example above how an indent level of *1* would make the elements of the parameter
list hard to distingish from the first statement. Hence PEP8 recommends either indenting twice
or using alignment instead.

#### `indent-tabs-expr`

 * Default: *1*
 * Allowed values: Any integer >= 1

The number of tabs to add when adding the first level of indentation using indenting within any
other kind of construct (such as a tuple, set, dict, …).


