# -*- coding: utf-8 -*-
# Generated by Django 1.11.15 on 2018-08-15 15:17
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0008_alter_user_username_max_length'),
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='Account',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('active', models.BooleanField(default=True, help_text='Users may only charge to an account if it is active. Deactivate the account to block future billable activity (such as tool usage and consumable check-outs) of all the projects that belong to it.')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='ActivityHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_id', models.PositiveIntegerField()),
                ('action', models.BooleanField(choices=[(True, 'Activated'), (False, 'Deactivated')], default=None, help_text='The target state (activated or deactivated).')),
                ('date', models.DateTimeField(default=django.utils.timezone.now, help_text='The time at which the active state was changed.')),
            ],
            options={
                'verbose_name_plural': 'activity histories',
                'ordering': ['-date'],
            },
        ),
        migrations.CreateModel(
            name='Alert',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(blank=True, max_length=100)),
                ('contents', models.CharField(max_length=500)),
                ('creation_time', models.DateTimeField(default=django.utils.timezone.now)),
                ('debut_time', models.DateTimeField(help_text='The alert will not be displayed to users until the debut time is reached.')),
                ('expiration_time', models.DateTimeField(blank=True, help_text='The alert can be deleted after the expiration time is reached.', null=True)),
                ('dismissible', models.BooleanField(default=False, help_text="Allows the user to delete the alert. This is only valid when the 'user' field is set.")),
            ],
            options={
                'ordering': ['-debut_time'],
            },
        ),
        migrations.CreateModel(
            name='Area',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='What is the name of this area? The name will be displayed on the tablet login and logout pages.', max_length=200)),
                ('welcome_message', models.TextField(help_text='The welcome message will be displayed on the tablet login page. You can use HTML and JavaScript.')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='AreaAccessRecord',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start', models.DateTimeField(default=django.utils.timezone.now)),
                ('end', models.DateTimeField(blank=True, null=True)),
                ('area', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='NEMO.Area')),
            ],
            options={
                'ordering': ['-start'],
            },
        ),
        migrations.CreateModel(
            name='Comment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('creation_date', models.DateTimeField(default=django.utils.timezone.now)),
                ('expiration_date', models.DateTimeField(blank=True, help_text='The comment will only be visible until this date.', null=True)),
                ('visible', models.BooleanField(default=True)),
                ('hide_date', models.DateTimeField(blank=True, help_text='The date when this comment was hidden. If it is still visible or has expired then this date should be empty.', null=True)),
                ('content', models.TextField()),
            ],
            options={
                'ordering': ['-creation_date'],
            },
        ),
        migrations.CreateModel(
            name='Configuration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='The name of this overall configuration. This text is displayed as a label on the tool control page.', max_length=200)),
                ('configurable_item_name', models.CharField(blank=True, help_text='The name of the tool part being configured. This text is displayed as a label on the tool control page. Leave this field blank if there is only one configuration slot.', max_length=200, null=True)),
                ('advance_notice_limit', models.PositiveIntegerField(help_text='Configuration changes must be made this many hours in advance.')),
                ('display_priority', models.PositiveIntegerField(help_text='The order in which this configuration will be displayed beside others when making a reservation and controlling a tool. Can be any positive integer including 0. Lower values are displayed first.')),
                ('prompt', models.TextField(blank=True, help_text='The textual description the user will see when making a configuration choice.', null=True)),
                ('current_settings', models.TextField(blank=True, help_text='The current configuration settings for a tool. Multiple values are separated by commas.', null=True)),
                ('available_settings', models.TextField(blank=True, help_text='The available choices to select for this configuration option. Multiple values are separated by commas.', null=True)),
                ('qualified_users_are_maintainers', models.BooleanField(default=False, help_text='Any user that is qualified to use the tool that this configuration applies to may also change this configuration. Checking this box implicitly adds qualified users to the maintainers list.')),
                ('exclude_from_configuration_agenda', models.BooleanField(default=False, help_text="Reservations containing this configuration will be excluded from the NanoFab technician's Configuration Agenda page.")),
                ('absence_string', models.CharField(blank=True, help_text='The text that appears to indicate absence of a choice.', max_length=100, null=True)),
            ],
            options={
                'ordering': ['tool', 'name'],
            },
        ),
        migrations.CreateModel(
            name='ConfigurationHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('modification_time', models.DateTimeField(default=django.utils.timezone.now)),
                ('slot', models.PositiveIntegerField()),
                ('setting', models.TextField()),
                ('configuration', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='NEMO.Configuration')),
            ],
            options={
                'verbose_name_plural': 'Configuration histories',
                'ordering': ['-modification_time'],
            },
        ),
        migrations.CreateModel(
            name='Consumable',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('quantity', models.IntegerField(help_text='The number of items currently in stock.')),
                ('reminder_threshold', models.IntegerField(help_text='More of this item should be ordered when the quantity falls below this threshold.')),
                ('reminder_email', models.EmailField(help_text='An email will be sent to this address when the quantity of this item falls below the reminder threshold.', max_length=254)),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='ConsumableCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
            ],
            options={
                'verbose_name_plural': 'Consumable categories',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='ConsumableWithdraw',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('quantity', models.PositiveIntegerField()),
                ('date', models.DateTimeField(default=django.utils.timezone.now, help_text='The date and time when the user withdrew the consumable.')),
                ('consumable', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='NEMO.Consumable')),
            ],
            options={
                'ordering': ['-date'],
            },
        ),
        migrations.CreateModel(
            name='ContactInformation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('image', models.ImageField(blank=True, help_text='Portraits are resized to 266 pixels high and 200 pixels wide. Crop portraits to these dimensions before uploading for optimal bandwidth usage', upload_to='')),
                ('email', models.EmailField(blank=True, max_length=254)),
                ('office_phone', models.CharField(blank=True, max_length=40)),
                ('office_location', models.CharField(blank=True, max_length=200)),
                ('mobile_phone', models.CharField(blank=True, max_length=40)),
                ('mobile_phone_is_sms_capable', models.BooleanField(default=True, help_text="Is the mobile phone capable of receiving text messages? If so, a link will be displayed for users to click to send a text message to the recipient when viewing the 'Contact information' page.", verbose_name='Mobile phone is SMS capable')),
            ],
            options={
                'verbose_name_plural': 'Contact information',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='ContactInformationCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('display_order', models.IntegerField(help_text="Contact information categories are sorted according to display order. The lowest value category is displayed first in the 'Contact information' page.")),
            ],
            options={
                'verbose_name_plural': 'Contact information categories',
                'ordering': ['display_order', 'name'],
            },
        ),
        migrations.CreateModel(
            name='Customization',
            fields=[
                ('name', models.CharField(max_length=50, primary_key=True, serialize=False)),
                ('value', models.TextField()),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Door',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('area', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='doors', to='NEMO.Area')),
            ],
        ),
        migrations.CreateModel(
            name='Interlock',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('channel', models.PositiveIntegerField()),
                ('state', models.IntegerField(choices=[(-1, 'Unknown'), (1, 'Unlocked'), (2, 'Locked')], default=-1)),
                ('most_recent_reply', models.TextField(default='None')),
            ],
            options={
                'ordering': ['card__server', 'card__number', 'channel'],
            },
        ),
        migrations.CreateModel(
            name='InterlockCard',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('server', models.CharField(max_length=100)),
                ('port', models.PositiveIntegerField()),
                ('number', models.PositiveIntegerField()),
                ('even_port', models.PositiveIntegerField()),
                ('odd_port', models.PositiveIntegerField()),
            ],
            options={
                'ordering': ['server', 'number'],
            },
        ),
        migrations.CreateModel(
            name='LandingPageChoice',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', models.ImageField(help_text='An image that symbolizes the choice. It is automatically resized to 128x128 pixels when displayed, so set the image to this size before uploading to optimize bandwidth usage and landing page load time', upload_to='')),
                ('name', models.CharField(help_text='The textual name that will be displayed underneath the image', max_length=40)),
                ('url', models.CharField(help_text='The URL that the choice leads to when clicked. Relative paths such as /calendar/ are used when linking within the NEMO site. Use fully qualified URL paths such as https://www.google.com/ to link to external sites.', max_length=200, verbose_name='URL')),
                ('display_priority', models.IntegerField(help_text='The order in which choices are displayed on the landing page, from left to right, top to bottom. Lower values are displayed first.')),
                ('open_in_new_tab', models.BooleanField(default=False, help_text="Open the URL in a new browser tab when it's clicked")),
                ('secure_referral', models.BooleanField(default=True, help_text="Improves security by blocking HTTP referer [sic] information from the targeted page. Enabling this prevents the target page from manipulating the calling page's DOM with JavaScript. This should always be used for external links. It is safe to uncheck this when linking within the NEMO site. Leave this box checked if you don't know what this means")),
                ('hide_from_mobile_devices', models.BooleanField(default=False, help_text='Hides this choice when the landing page is viewed from a mobile device')),
                ('hide_from_desktop_computers', models.BooleanField(default=False, help_text='Hides this choice when the landing page is viewed from a desktop computer')),
            ],
            options={
                'ordering': ['display_priority'],
            },
        ),
        migrations.CreateModel(
            name='MembershipHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('parent_object_id', models.PositiveIntegerField()),
                ('child_object_id', models.PositiveIntegerField()),
                ('date', models.DateTimeField(default=django.utils.timezone.now, help_text='The time at which the membership status was changed.')),
                ('action', models.BooleanField(choices=[(True, 'Added'), (False, 'Removed')], default=None)),
            ],
            options={
                'verbose_name_plural': 'membership histories',
                'ordering': ['-date'],
            },
        ),
        migrations.CreateModel(
            name='PhysicalAccessLevel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('schedule', models.IntegerField(choices=[(0, 'Always'), (1, 'Weekdays, 7am to midnight'), (2, 'Weekends')])),
                ('area', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='NEMO.Area')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='PhysicalAccessLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time', models.DateTimeField()),
                ('result', models.BooleanField(choices=[(False, 'Deny'), (True, 'Allow')], default=None)),
                ('details', models.TextField(blank=True, help_text='Any details that should accompany the log entry. For example, the reason physical access was denied.', null=True)),
                ('door', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='NEMO.Door')),
            ],
            options={
                'ordering': ['-time'],
            },
        ),
        migrations.CreateModel(
            name='Project',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('application_identifier', models.CharField(max_length=100)),
                ('active', models.BooleanField(default=True, help_text='Users may only charge to a project if it is active. Deactivate the project to block billable activity (such as tool usage and consumable check-outs).')),
                ('account', models.ForeignKey(help_text='All charges for this project will be billed to the selected account.', on_delete=django.db.models.deletion.CASCADE, to='NEMO.Account')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Reservation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('creation_time', models.DateTimeField(default=django.utils.timezone.now)),
                ('start', models.DateTimeField(verbose_name='start')),
                ('end', models.DateTimeField(verbose_name='end')),
                ('short_notice', models.BooleanField(default=None, help_text='Indicates that the reservation was made after the configuration deadline for a tool. NanoFab staff may not have enough time to properly configure the tool before the user is scheduled to use it.')),
                ('cancelled', models.BooleanField(default=False, help_text='Indicates that the reservation has been cancelled, moved, or resized.')),
                ('cancellation_time', models.DateTimeField(blank=True, null=True)),
                ('missed', models.BooleanField(default=False, help_text='Indicates that the tool was not enabled by anyone before the tool\'s "missed reservation threshold" passed.')),
                ('shortened', models.BooleanField(default=False, help_text='Indicates that the user finished using the tool and relinquished the remaining time on their reservation. The reservation will no longer be visible on the calendar and a descendant reservation will be created in place of the existing one.')),
                ('additional_information', models.TextField(blank=True, null=True)),
                ('self_configuration', models.BooleanField(default=False, help_text='When checked, indicates that the user will perform their own tool configuration (instead of requesting that the NanoFab staff configure it for them).')),
                ('title', models.TextField(blank=True, default='', help_text="Shows a custom title for this reservation on the calendar. Leave this field blank to display the reservation's user name as the title (which is the default behaviour).", max_length=200)),
            ],
            options={
                'ordering': ['-start'],
            },
        ),
        migrations.CreateModel(
            name='Resource',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('available', models.BooleanField(default=True, help_text='Indicates whether the resource is available to be used.')),
                ('restriction_message', models.TextField(help_text='The message that is displayed to users on the tool control page when this resource is unavailable.')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='ResourceCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
            ],
            options={
                'verbose_name_plural': 'resource categories',
            },
        ),
        migrations.CreateModel(
            name='SafetyIssue',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('location', models.CharField(max_length=200)),
                ('creation_time', models.DateTimeField(auto_now_add=True)),
                ('visible', models.BooleanField(default=True, help_text='Should this safety issue be visible to all users? When unchecked, the issue is only visible to staff.')),
                ('concern', models.TextField()),
                ('progress', models.TextField(blank=True, null=True)),
                ('resolution', models.TextField(blank=True, null=True)),
                ('resolved', models.BooleanField(default=False)),
                ('resolution_time', models.DateTimeField(blank=True, null=True)),
            ],
            options={
                'ordering': ['-creation_time'],
            },
        ),
        migrations.CreateModel(
            name='StaffCharge',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start', models.DateTimeField(default=django.utils.timezone.now)),
                ('end', models.DateTimeField(blank=True, null=True)),
                ('validated', models.BooleanField(default=False)),
            ],
            options={
                'ordering': ['-start'],
            },
        ),
        migrations.CreateModel(
            name='Task',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.IntegerField(choices=[(-1, 'Cancelled'), (0, 'Requires attention'), (1, 'Work in progress'), (2, 'Complete')], default=0)),
                ('urgency', models.IntegerField(choices=[(-1, 'Low'), (0, 'Normal'), (1, 'High')])),
                ('force_shutdown', models.BooleanField(default=None, help_text='Indicates that the tool this task relates to will be shutdown until the task is resolved.')),
                ('safety_hazard', models.BooleanField(default=None, help_text='Indicates that this task represents a safety hazard to the NanoFab.')),
                ('creation_time', models.DateTimeField(default=django.utils.timezone.now, help_text='The date and time when the task was created.')),
                ('problem_description', models.TextField(blank=True, null=True)),
                ('first_response_time', models.DateTimeField(blank=True, help_text='The timestamp of when a staff member initially responds to the task by changing its status.', null=True)),
                ('progress_description', models.TextField(blank=True, null=True)),
                ('last_updated', models.DateTimeField(blank=True, help_text='The last time this task was modified. (Creating the task does not count as modifying it.)', null=True)),
                ('estimated_resolution_time', models.DateTimeField(blank=True, help_text='The estimated date and time that the task will be resolved.', null=True)),
                ('resolution_time', models.DateTimeField(blank=True, help_text='The timestamp of when the task was marked complete or cancelled.', null=True)),
                ('resolution_description', models.TextField(blank=True, null=True)),
            ],
            options={
                'ordering': ['-creation_time'],
            },
        ),
        migrations.CreateModel(
            name='TaskCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('stage', models.IntegerField(choices=[(0, 'Initial assessment'), (1, 'Completion')])),
            ],
            options={
                'verbose_name_plural': 'Task categories',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Tool',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('category', models.CharField(help_text='Create sub-categories using slashes. For example "Category 1/Sub-category 1".', max_length=1000)),
                ('visible', models.BooleanField(default=True, help_text='Specifies whether this tool is visible to users.')),
                ('operational', models.BooleanField(default=False, help_text='Marking the tool non-operational will prevent users from using the tool.')),
                ('location', models.CharField(max_length=100)),
                ('phone_number', models.CharField(max_length=100)),
                ('notification_email_address', models.EmailField(blank=True, help_text='Messages that relate to this tool (such as comments, problems, and shutdowns) will be forwarded to this email address. This can be a normal email address or a mailing list address.', max_length=254, null=True)),
                ('reservation_horizon', models.PositiveIntegerField(blank=True, default=14, help_text='Users may create reservations this many days in advance. Leave this field blank to indicate that no reservation horizon exists for this tool.', null=True)),
                ('minimum_usage_block_time', models.PositiveIntegerField(blank=True, help_text='The minimum amount of time (in minutes) that a user must reserve this tool for a single reservation. Leave this field blank to indicate that no minimum usage block time exists for this tool.', null=True)),
                ('maximum_usage_block_time', models.PositiveIntegerField(blank=True, help_text='The maximum amount of time (in minutes) that a user may reserve this tool for a single reservation. Leave this field blank to indicate that no maximum usage block time exists for this tool.', null=True)),
                ('maximum_reservations_per_day', models.PositiveIntegerField(blank=True, help_text='The maximum number of reservations a user may make per day for this tool.', null=True)),
                ('minimum_time_between_reservations', models.PositiveIntegerField(blank=True, help_text='The minimum amount of time (in minutes) that the same user must have between any two reservations for this tool.', null=True)),
                ('maximum_future_reservation_time', models.PositiveIntegerField(blank=True, help_text='The maximum amount of time (in minutes) that a user may reserve from the current time onwards.', null=True)),
                ('missed_reservation_threshold', models.PositiveIntegerField(blank=True, help_text='The amount of time (in minutes) that a tool reservation may go unused before it is automatically marked as "missed" and hidden from the calendar. Usage can be from any user, regardless of who the reservation was originally created for. The cancellation process is triggered by a timed job on the web server.', null=True)),
                ('allow_delayed_logoff', models.BooleanField(default=False, help_text='Upon logging off users may enter a delay before another user may use the tool. Some tools require "spin-down" or cleaning time after use.')),
                ('interlock', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='NEMO.Interlock')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='TrainingSession',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('duration', models.PositiveIntegerField(help_text='The duration of the training session in minutes.')),
                ('type', models.IntegerField(choices=[(0, 'Individual'), (1, 'Group')])),
                ('date', models.DateTimeField(default=django.utils.timezone.now)),
                ('qualified', models.BooleanField(default=False, help_text='Indicates that after this training session the user was qualified to use the tool.')),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='NEMO.Project')),
                ('tool', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='NEMO.Tool')),
            ],
            options={
                'ordering': ['-date'],
            },
        ),
        migrations.CreateModel(
            name='UsageEvent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start', models.DateTimeField(default=django.utils.timezone.now)),
                ('end', models.DateTimeField(blank=True, null=True)),
                ('validated', models.BooleanField(default=False)),
            ],
            options={
                'ordering': ['-start'],
            },
        ),
        migrations.CreateModel(
            name='UserType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, unique=True)),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('username', models.CharField(max_length=100, unique=True)),
                ('first_name', models.CharField(max_length=100)),
                ('last_name', models.CharField(max_length=100)),
                ('email', models.EmailField(max_length=254, verbose_name='email address')),
                ('domain', models.CharField(blank=True, help_text='The Active Directory domain that the account resides on', max_length=100)),
                ('badge_number', models.PositiveIntegerField(blank=True, help_text='The badge number associated with this user. This number must correctly correspond to a user in order for the tablet-login system (in the NanoFab lobby) to work properly.', null=True, unique=True)),
                ('access_expiration', models.DateField(blank=True, help_text='The user will lose all access rights after this date. Typically this is used to ensure that safety training has been completed by the user every year.', null=True)),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user can log in to NEMO. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_technician', models.BooleanField(default=False, help_text='Specifies how to bill staff time for this user. When checked, customers are billed at technician rates.', verbose_name='technician status')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('training_required', models.BooleanField(default=True, help_text='When selected, the user is blocked from all reservation and tool usage capabilities.')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now)),
                ('last_login', models.DateTimeField(blank=True, null=True)),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of his/her group.', to='auth.Group')),
                ('physical_access_levels', models.ManyToManyField(blank=True, related_name='users', to='NEMO.PhysicalAccessLevel')),
                ('projects', models.ManyToManyField(blank=True, help_text='Select the projects that this user is currently working on.', to='NEMO.Project')),
                ('qualifications', models.ManyToManyField(blank=True, help_text='Select the tools that the user is qualified to use.', to='NEMO.Tool')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='NEMO.UserType')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', to='auth.Permission')),
            ],
            options={
                'ordering': ['first_name'],
                'permissions': (('trigger_timed_services', 'Can trigger timed services'), ('use_billing_api', 'Can use billing API'), ('kiosk', 'Kiosk services')),
            },
        ),
        migrations.AddField(
            model_name='usageevent',
            name='operator',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='usage_event_operator', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='usageevent',
            name='project',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='NEMO.Project'),
        ),
        migrations.AddField(
            model_name='usageevent',
            name='tool',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='NEMO.Tool'),
        ),
        migrations.AddField(
            model_name='usageevent',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='usage_event_user', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='trainingsession',
            name='trainee',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='student_set', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='trainingsession',
            name='trainer',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='teacher_set', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='tool',
            name='primary_owner',
            field=models.ForeignKey(help_text='The staff member who is responsible for administration of this tool.', on_delete=django.db.models.deletion.CASCADE, related_name='primary_tool_owner', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='tool',
            name='requires_area_access',
            field=models.ForeignKey(blank=True, help_text='Indicates that this tool is physically located in a billable area and requires an active area access record in order to be operated.', null=True, on_delete=django.db.models.deletion.CASCADE, to='NEMO.Area'),
        ),
        migrations.AddField(
            model_name='tool',
            name='secondary_owner',
            field=models.ForeignKey(help_text='The alternate staff member who is responsible for administration of this tool.', on_delete=django.db.models.deletion.CASCADE, related_name='secondary_tool_owner', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='task',
            name='creator',
            field=models.ForeignKey(help_text='The user who created the task.', on_delete=django.db.models.deletion.CASCADE, related_name='created_tasks', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='task',
            name='first_responder',
            field=models.ForeignKey(blank=True, help_text='The staff member who initially assessed the task after it was reported.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='task_first_responder', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='task',
            name='last_updated_by',
            field=models.ForeignKey(blank=True, help_text='The last user who modified this task. This should always be a staff member.', null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='task',
            name='problem_category',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='problem_category', to='NEMO.TaskCategory'),
        ),
        migrations.AddField(
            model_name='task',
            name='resolution_category',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='resolution_category', to='NEMO.TaskCategory'),
        ),
        migrations.AddField(
            model_name='task',
            name='resolver',
            field=models.ForeignKey(blank=True, help_text='The staff member who resolved the task.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='task_resolver', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='task',
            name='tool',
            field=models.ForeignKey(help_text='The tool that this task relates to.', on_delete=django.db.models.deletion.CASCADE, to='NEMO.Tool'),
        ),
        migrations.AddField(
            model_name='staffcharge',
            name='customer',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='staff_charge_customer', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='staffcharge',
            name='project',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='NEMO.Project'),
        ),
        migrations.AddField(
            model_name='staffcharge',
            name='staff_member',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='staff_charge_actor', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='safetyissue',
            name='reporter',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='reported_safety_issues', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='safetyissue',
            name='resolver',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='resolved_safety_issues', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='resource',
            name='category',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='NEMO.ResourceCategory'),
        ),
        migrations.AddField(
            model_name='resource',
            name='dependent_areas',
            field=models.ManyToManyField(blank=True, help_text='Users will not be able to login to these areas when the resource is unavailable.', related_name='required_resources', to='NEMO.Area'),
        ),
        migrations.AddField(
            model_name='resource',
            name='fully_dependent_tools',
            field=models.ManyToManyField(blank=True, help_text='These tools will be completely inoperable if the resource is unavailable.', related_name='required_resource_set', to='NEMO.Tool'),
        ),
        migrations.AddField(
            model_name='resource',
            name='partially_dependent_tools',
            field=models.ManyToManyField(blank=True, help_text='These tools depend on this resource but can operated at a reduced capacity if the resource is unavailable.', related_name='nonrequired_resource_set', to='NEMO.Tool'),
        ),
        migrations.AddField(
            model_name='reservation',
            name='cancelled_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='reservation',
            name='creator',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='reservation_creator', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='reservation',
            name='descendant',
            field=models.OneToOneField(blank=True, help_text='Any time a reservation is moved or resized, the old reservation is cancelled and a new reservation with updated information takes its place. This field links the old reservation to the new one, so the history of reservation moves & changes can be easily tracked.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='ancestor', to='NEMO.Reservation'),
        ),
        migrations.AddField(
            model_name='reservation',
            name='project',
            field=models.ForeignKey(blank=True, help_text='Indicates the intended project for this reservation. A missed reservation would be billed to this project.', null=True, on_delete=django.db.models.deletion.CASCADE, to='NEMO.Project'),
        ),
        migrations.AddField(
            model_name='reservation',
            name='tool',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='NEMO.Tool'),
        ),
        migrations.AddField(
            model_name='reservation',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='reservation_user', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='physicalaccesslog',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='membershiphistory',
            name='authorizer',
            field=models.ForeignKey(help_text='The staff member who changed the membership status of the account, project, or user in question.', on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='membershiphistory',
            name='child_content_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='child_content_type', to='contenttypes.ContentType'),
        ),
        migrations.AddField(
            model_name='membershiphistory',
            name='parent_content_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='parent_content_type', to='contenttypes.ContentType'),
        ),
        migrations.AddField(
            model_name='interlock',
            name='card',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='NEMO.InterlockCard'),
        ),
        migrations.AddField(
            model_name='door',
            name='interlock',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='NEMO.Interlock'),
        ),
        migrations.AddField(
            model_name='contactinformation',
            name='category',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='NEMO.ContactInformationCategory'),
        ),
        migrations.AddField(
            model_name='consumablewithdraw',
            name='customer',
            field=models.ForeignKey(help_text='The user who will use the consumable item.', on_delete=django.db.models.deletion.CASCADE, related_name='consumable_user', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='consumablewithdraw',
            name='merchant',
            field=models.ForeignKey(help_text='The staff member that performed the withdraw.', on_delete=django.db.models.deletion.CASCADE, related_name='consumable_merchant', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='consumablewithdraw',
            name='project',
            field=models.ForeignKey(help_text='The withdraw will be billed to this project.', on_delete=django.db.models.deletion.CASCADE, to='NEMO.Project'),
        ),
        migrations.AddField(
            model_name='consumable',
            name='category',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='NEMO.ConsumableCategory'),
        ),
        migrations.AddField(
            model_name='configurationhistory',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='configuration',
            name='maintainers',
            field=models.ManyToManyField(blank=True, help_text='Select the users that are allowed to change this configuration.', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='configuration',
            name='tool',
            field=models.ForeignKey(help_text='The tool that this configuration option applies to.', on_delete=django.db.models.deletion.CASCADE, to='NEMO.Tool'),
        ),
        migrations.AddField(
            model_name='comment',
            name='author',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='comment',
            name='hidden_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='hidden_comments', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='comment',
            name='tool',
            field=models.ForeignKey(help_text='The tool that this comment relates to.', on_delete=django.db.models.deletion.CASCADE, to='NEMO.Tool'),
        ),
        migrations.AddField(
            model_name='areaaccessrecord',
            name='customer',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='areaaccessrecord',
            name='project',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='NEMO.Project'),
        ),
        migrations.AddField(
            model_name='areaaccessrecord',
            name='staff_charge',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='NEMO.StaffCharge'),
        ),
        migrations.AddField(
            model_name='alert',
            name='creator',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='alert',
            name='user',
            field=models.ForeignKey(blank=True, help_text='The alert will be visible for this user. The alert is visible to all users when this is empty.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='alerts', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='activityhistory',
            name='authorizer',
            field=models.ForeignKey(help_text='The staff member who changed the active state of the account, project, or user in question.', on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='activityhistory',
            name='content_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType'),
        ),
        migrations.AlterUniqueTogether(
            name='interlock',
            unique_together=set([('card', 'channel')]),
        ),
    ]
