"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SslServerTest = exports.SslServerTestGrade = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_events_1 = require("aws-cdk-lib/aws-events");
const aws_events_targets_1 = require("aws-cdk-lib/aws-events-targets");
const aws_sns_1 = require("aws-cdk-lib/aws-sns");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
const aws_stepfunctions_tasks_1 = require("aws-cdk-lib/aws-stepfunctions-tasks");
const constructs_1 = require("constructs");
const analyze_function_1 = require("./analyze-function");
const extract_grade_function_1 = require("./extract-grade-function");
/**
 * SSL Server test grade
 */
var SslServerTestGrade;
(function (SslServerTestGrade) {
    SslServerTestGrade["A_PLUS"] = "A+";
    SslServerTestGrade["A"] = "A";
    SslServerTestGrade["A_MINUS"] = "A-";
    SslServerTestGrade["B"] = "B";
    SslServerTestGrade["C"] = "C";
    SslServerTestGrade["D"] = "D";
    SslServerTestGrade["E"] = "E";
    SslServerTestGrade["F"] = "F";
})(SslServerTestGrade = exports.SslServerTestGrade || (exports.SslServerTestGrade = {}));
/**
 * Perform SSL server test for a hostname
 */
class SslServerTest extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.alarmTopic = props.alarmTopic ?? new aws_sns_1.Topic(this, 'AlarmTopic');
        const stateMachine = SslServerTestStateMachine.getOrCreate(this);
        this.alarmTopic.grantPublish(stateMachine);
        const rule = new aws_events_1.Rule(this, 'Rule', {
            schedule: props.schedule ?? aws_events_1.Schedule.rate(aws_cdk_lib_1.Duration.days(1)),
        });
        rule.addTarget(new aws_events_targets_1.SfnStateMachine(stateMachine, {
            input: aws_events_1.RuleTargetInput.fromObject({
                host: props.host,
                minimumGrade: props.minimumGrade ?? SslServerTestGrade.A_PLUS,
                alarmTopicArn: this.alarmTopic.topicArn,
            }),
        }));
    }
}
exports.SslServerTest = SslServerTest;
_a = JSII_RTTI_SYMBOL_1;
SslServerTest[_a] = { fqn: "cloudstructs.SslServerTest", version: "0.6.23" };
class SslServerTestStateMachine extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        const analyzeFunction = new analyze_function_1.AnalyzeFunction(this, 'AnalyzeFunction');
        const startAnalysis = new aws_stepfunctions_tasks_1.LambdaInvoke(this, 'Start Analysis', {
            lambdaFunction: analyzeFunction,
            payload: aws_stepfunctions_1.TaskInput.fromObject({
                host: aws_stepfunctions_1.JsonPath.stringAt('$.host'),
                startNew: 'on',
            }),
            payloadResponseOnly: true,
        });
        const wait = new aws_stepfunctions_1.Wait(this, 'Wait', {
            time: aws_stepfunctions_1.WaitTime.duration(aws_cdk_lib_1.Duration.seconds(10)),
        });
        const pollAnalysis = new aws_stepfunctions_tasks_1.LambdaInvoke(this, 'Poll Analysis', {
            lambdaFunction: analyzeFunction,
            payload: aws_stepfunctions_1.TaskInput.fromObject({
                host: aws_stepfunctions_1.JsonPath.stringAt('$.host'),
            }),
            payloadResponseOnly: true,
        });
        const extractGradeFunction = new extract_grade_function_1.ExtractGradeFunction(this, 'ExtractGradeFunction');
        const extractGrade = new aws_stepfunctions_tasks_1.LambdaInvoke(this, 'Extract Grade', {
            lambdaFunction: extractGradeFunction,
            payloadResponseOnly: true,
            resultPath: '$.grade',
        });
        const notify = new SnsPublishToTopicAtPath(this, 'Notify', {
            path: '$$.Execution.Input.alarmTopicArn',
            message: aws_stepfunctions_1.TaskInput.fromJsonPathAt('States.JsonToString($)'),
            subject: aws_stepfunctions_1.JsonPath.stringAt("States.Format('SSL grade for {} is below minimum grade ({} < {})', $.host, $.grade, $$.Execution.Input.minimumGrade)"),
        });
        const fail = new aws_stepfunctions_1.Fail(this, 'Fail');
        this.stateMachine = new aws_stepfunctions_1.StateMachine(this, 'StateMachine', {
            definition: startAnalysis
                .next(wait)
                .next(pollAnalysis)
                .next(new aws_stepfunctions_1.Choice(this, 'Is Ready ?')
                .when(aws_stepfunctions_1.Condition.stringEquals('$.status', 'READY'), extractGrade.next(new aws_stepfunctions_1.Choice(this, 'Is Grade Below Minimum?')
                .when(aws_stepfunctions_1.Condition.stringLessThanJsonPath('$$.Execution.Input.minimumGrade', '$.grade'), notify)
                .otherwise(new aws_stepfunctions_1.Pass(this, 'Pass'))))
                .when(aws_stepfunctions_1.Condition.stringEquals('$.status', 'ERROR'), fail)
                .otherwise(wait)),
            timeout: aws_cdk_lib_1.Duration.minutes(30),
        });
    }
    static getOrCreate(scope) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const uid = 'cloudstructs/ssl-server-test.StateMachine';
        const construct = stack.node.tryFindChild(uid) ?? new SslServerTestStateMachine(stack, uid);
        return construct.stateMachine;
    }
}
class SnsPublishToTopicAtPath extends aws_stepfunctions_1.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
    }
    _renderTask() {
        return {
            Resource: `arn:${aws_cdk_lib_1.Stack.of(this).partition}:states:::sns:publish`,
            Parameters: aws_stepfunctions_1.FieldUtils.renderObject({
                TopicArn: aws_stepfunctions_1.JsonPath.stringAt(this.props.path),
                Message: this.props.message.value,
                Subject: this.props.subject,
            }),
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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