"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SlackTextract = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const events = require("aws-cdk-lib/aws-events");
const targets = require("aws-cdk-lib/aws-events-targets");
const iam = require("aws-cdk-lib/aws-iam");
const logs = require("aws-cdk-lib/aws-logs");
const constructs_1 = require("constructs");
const detect_function_1 = require("./detect-function");
const slack_events_1 = require("../slack-events");
/**
 * Extract text from images posted to Slack using Amazon Textract
 */
class SlackTextract extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const handler = new detect_function_1.DetectFunction(this, 'handler', {
            timeout: aws_cdk_lib_1.Duration.seconds(30),
            logRetention: logs.RetentionDays.ONE_MONTH,
            environment: {
                SLACK_TOKEN: props.botToken.toString(),
            },
        });
        handler.addToRolePolicy(new iam.PolicyStatement({
            actions: ['textract:DetectDocumentText'],
            resources: ['*'],
        }));
        new slack_events_1.SlackEvents(this, 'SlackEvents', {
            signingSecret: props.signingSecret,
        });
        const fileSharedRule = new events.Rule(this, 'SlackEventsRule', {
            eventPattern: {
                detail: {
                    event: {
                        type: ['file_shared'],
                    },
                },
                resources: [props.appId],
                source: ['slack'],
            },
        });
        fileSharedRule.addTarget(new targets.LambdaFunction(handler, {
            event: events.RuleTargetInput.fromEventPath('$.detail.event'),
        }));
    }
}
exports.SlackTextract = SlackTextract;
_a = JSII_RTTI_SYMBOL_1;
SlackTextract[_a] = { fqn: "cloudstructs.SlackTextract", version: "0.6.23" };
//# sourceMappingURL=data:application/json;base64,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