"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailReceiver = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const destinations = require("aws-cdk-lib/aws-lambda-destinations");
const logs = require("aws-cdk-lib/aws-logs");
const s3 = require("aws-cdk-lib/aws-s3");
const ses = require("aws-cdk-lib/aws-ses");
const actions = require("aws-cdk-lib/aws-ses-actions");
const sns = require("aws-cdk-lib/aws-sns");
const subscriptions = require("aws-cdk-lib/aws-sns-subscriptions");
const constructs_1 = require("constructs");
const s3_function_1 = require("./s3-function");
const whitelist_function_1 = require("./whitelist-function");
/**
 * Receive emails through SES, save them to S3 and invokes a
 * Lambda function
 */
class EmailReceiver extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const receiptRule = new ses.ReceiptRule(this, 'ReceiptRule', {
            ruleSet: props.receiptRuleSet,
            recipients: props.recipients,
            after: props.afterRule,
        });
        const bucket = new s3.Bucket(this, 'Bucket', {
            blockPublicAccess: s3.BlockPublicAccess.BLOCK_ALL,
            encryption: s3.BucketEncryption.S3_MANAGED,
            lifecycleRules: [{ expiration: aws_cdk_lib_1.Duration.days(1) }],
        });
        bucket.grantRead(props.function); // Download email
        const topic = new sns.Topic(this, 'Topic');
        // Actions
        if (props.sourceWhitelist) {
            const whitelistHandler = new whitelist_function_1.WhitelistFunction(this, 'whitelist', {
                environment: {
                    SOURCE_WHITELIST: props.sourceWhitelist,
                },
                logRetention: logs.RetentionDays.ONE_MONTH,
            });
            receiptRule.addAction(new actions.Lambda({
                function: whitelistHandler,
                invocationType: actions.LambdaInvocationType.REQUEST_RESPONSE,
            }));
        }
        receiptRule.addAction(new actions.S3({
            bucket,
            topic,
        }));
        const s3Handler = new s3_function_1.S3Function(this, 's3', {
            logRetention: logs.RetentionDays.ONE_MONTH,
            onSuccess: new destinations.LambdaDestination(props.function, {
                responseOnly: true,
            }),
        });
        topic.addSubscription(new subscriptions.LambdaSubscription(s3Handler)); // Notify
    }
}
exports.EmailReceiver = EmailReceiver;
_a = JSII_RTTI_SYMBOL_1;
EmailReceiver[_a] = { fqn: "cloudstructs.EmailReceiver", version: "0.6.23" };
//# sourceMappingURL=data:application/json;base64,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