# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class UserInfoResponse(Model):
    """UserInfoResponse.

    All required parameters must be populated in order to send to Azure.

    :param user_id: Required. The guid of the user.
    :type user_id: str
    :param email: Required. The email address of the authenticated user.
    :type email: str
    :param email_confirmed: Required. A boolean value indicating whether the
     email address is confirmed.
    :type email_confirmed: bool
    :param subscription_end: Required. The end date of the authenticated
     user's current subscription.
    :type subscription_end: datetime
    :param capabilities: Required. The capabilities that the authenticated
     user owns thanks to his current subscription.
    :type capabilities: list[str]
    :param grace_period: Required. A boolean value indicates whether the
     subscription is in a grace period and should be renewed immediately.
    :type grace_period: bool
    :param last_app_login: The last date when the user authenticated by the
     app.
    :type last_app_login: datetime
    """

    _validation = {
        'user_id': {'required': True},
        'email': {'required': True},
        'email_confirmed': {'required': True},
        'subscription_end': {'required': True},
        'capabilities': {'required': True},
        'grace_period': {'required': True},
    }

    _attribute_map = {
        'user_id': {'key': 'userId', 'type': 'str'},
        'email': {'key': 'email', 'type': 'str'},
        'email_confirmed': {'key': 'emailConfirmed', 'type': 'bool'},
        'subscription_end': {'key': 'subscriptionEnd', 'type': 'iso-8601'},
        'capabilities': {'key': 'capabilities', 'type': '[str]'},
        'grace_period': {'key': 'gracePeriod', 'type': 'bool'},
        'last_app_login': {'key': 'lastAppLogin', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(UserInfoResponse, self).__init__(**kwargs)
        self.user_id = kwargs.get('user_id', None)
        self.email = kwargs.get('email', None)
        self.email_confirmed = kwargs.get('email_confirmed', None)
        self.subscription_end = kwargs.get('subscription_end', None)
        self.capabilities = kwargs.get('capabilities', None)
        self.grace_period = kwargs.get('grace_period', None)
        self.last_app_login = kwargs.get('last_app_login', None)
