"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const ssm = require("../lib");
module.exports = {
    'can reference SSMPS string - specific version'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const ref = ssm.StringParameter.fromStringParameterAttributes(stack, 'Ref', {
            parameterName: '/some/key',
            version: 123
        });
        // THEN
        test.equal(stack.resolve(ref.stringValue), '{{resolve:ssm:/some/key:123}}');
        test.done();
    },
    'can reference SSMPS string - latest version'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const ref = ssm.StringParameter.fromStringParameterAttributes(stack, 'Ref', {
            parameterName: '/some/key',
        });
        // THEN
        assert_1.expect(stack).toMatch({
            Parameters: {
                RefParameter: {
                    Type: "AWS::SSM::Parameter::Value<String>",
                    Default: "/some/key"
                }
            }
        });
        test.deepEqual(stack.resolve(ref.stringValue), { Ref: 'RefParameter' });
        test.done();
    },
    'can reference SSMPS secure string'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const ref = ssm.StringParameter.fromSecureStringParameterAttributes(stack, 'Ref', {
            parameterName: '/some/key',
            version: 123
        }).stringValue;
        // THEN
        test.equal(stack.resolve(ref), '{{resolve:ssm-secure:/some/key:123}}');
        test.done();
    },
    'empty parameterName will throw'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        test.throws(() => {
            ssm.StringParameter.fromStringParameterAttributes(stack, 'Ref', {
                parameterName: '',
            });
        }, /parameterName cannot be an empty string/);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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