"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const ssm = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'SSM-Parameter');
const role = new iam.Role(stack, 'UserRole', {
    assumedBy: new iam.AccountRootPrincipal(),
});
/// !show
// Create a new SSM Parameter holding a String
const param = new ssm.StringParameter(stack, 'StringParameter', {
    // description: 'Some user-friendly description',
    // name: 'ParameterName',
    stringValue: 'Initial parameter value',
});
// Grant read access to some Role
param.grantRead(role);
// Create a new SSM Parameter holding a StringList
const listParameter = new ssm.StringListParameter(stack, 'StringListParameter', {
    // description: 'Some user-friendly description',
    // name: 'ParameterName',
    stringListValue: ['Initial parameter value A', 'Initial parameter value B'],
});
/// !hide
new cdk.CfnOutput(stack, 'StringListOutput', {
    value: cdk.Fn.join('+', listParameter.stringListValue),
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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