"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const cdk = require("@aws-cdk/core");
const ssm = require("../lib");
class CreatingStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        new ssm.StringParameter(this, 'String', {
            parameterName: '/My/Public/Parameter',
            stringValue: 'abcdef'
        });
    }
}
class UsingStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        /// !show
        // Retrieve the latest value of the non-secret parameter
        // with name "/My/String/Parameter".
        const stringValue = ssm.StringParameter.fromStringParameterAttributes(this, 'MyValue', {
            parameterName: '/My/Public/Parameter',
        }).stringValue;
        // Retrieve a specific version of the secret (SecureString) parameter.
        // 'version' is always required.
        const secretValue = ssm.StringParameter.fromSecureStringParameterAttributes(this, 'MySecureValue', {
            parameterName: '/My/Secret/Parameter',
            version: 5
        });
        /// !hide
        new cdk.CfnResource(this, 'Dummy', { type: 'AWS::SNS::Topic' });
        new cdk.CfnOutput(this, 'TheValue', { value: stringValue });
        // Cannot be provisioned so cannot be actually used
        Array.isArray(secretValue);
    }
}
const app = new cdk.App();
const creating = new CreatingStack(app, 'sspms-creating');
const using = new UsingStack(app, 'sspms-using');
using.addDependency(creating);
app.synth();
//# sourceMappingURL=data:application/json;base64,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