# Header
if(True):
  __doc__          = "This module contains unit tests. Passed 0.0.1"
  __version__      = "0.0.1"
  __reverse_path__ = "../"
  
  # Python Standard Imports
  import sys, os
  
  # Python Math Imports
  if(True):
    import math,cmath,random
    from decimal import *
    from numbers import Number
  
  # Logging Functions
  if(True):
    import logging, types
    
    global log
    log = logging.getLogger()
    
    def log_func(func,context,name=None):
      # Simplify Variables
      name = name if(name!=None) else func.__name__
      # Context: Extend for Non-Nested, Replace for Nested
      if(log.name == "root"): context = context  + "." + name
      else:                   context = log.name + "." + name
      context = ".".join([_.strip("_") for _ in context.split(".")])
      # Wrappers to Update Context
      def log_wrapper(*args, **kwargs):
        # Log with Context
        global log
        log = logging.getLogger(context)
        out = func(*args, **kwargs)
        log = logging.getLogger()
        return out 
      # Return Wrapped Function
      return log_wrapper
    def log_class(cls,context):
      # Add Context
      context = context + "." + cls.__name__
      # Iterate over class dict
      for name, obj in vars(cls).items():
        is_function = callable(obj) and not isinstance(obj,type)
        is_class    = callable(obj) and     isinstance(obj,type)
        if(is_function): setattr( cls, name, log_func( obj,context,name=name) )
        if(is_class):    setattr( cls, name, log_class(obj,context) )
      return cls
    def log_this(obj,context=None):
      # Initial Context
      if(context==None):context = __name__
      # Sort
      is_function = callable(obj) and not isinstance(obj,type)
      is_class    = callable(obj) and     isinstance(obj,type)
      # Return
      if(is_function): return log_func( obj,context)
      if(is_class):    return log_class(obj,context)
  
  # Repo-Script for Repo-Imports
  if(True):
    # Define Repo-Library Path.
    _file_dir_     = os.path.dirname(__file__)
    _repo_dir_     = os.path.join(_file_dir_, __reverse_path__)
    _repo_lib_dir_ = os.path.join(_repo_dir_, "src/")
    _repo_lib_dir_ = os.path.normpath(_repo_lib_dir_)
    # Add Repo-Library to Path.
    if(_repo_lib_dir_ not in sys.path): sys.path.insert(0, _repo_lib_dir_)
  
  # Additional Imports
  import pytest
  from unitment import AmbiguousUnitException,IncompatibleUnitException,UnitException,Unit,Measure
  import unitment as measure

class TestUnitInit:
  
  # Measure("2(1) * 3 * 5 * m^2")
  
  def test_examples(self):
    assert Unit("1e6 fish").magnitude == Unit("fish", magnitude=1e6).magnitude == Unit("1000000 fish").magnitude == Unit("10^6 fish").magnitude
    assert Unit("m/s").symbols == Unit("m s^-1").symbols == Unit(numerators=("m",),denominators=("s",)).symbols == Unit(numerators=(("m",1),),denominators=(("s",1),)).symbols == Unit(symbols=(("m",1),("s",-1),)).symbols
  
  # Initialization
  def test_init_empty(self):
    assert Unit() == Unit(None)
    assert Unit() == Unit("")
    assert Unit() == Unit(" ")
    
    assert Unit() == Unit(symbols = [])
    assert Unit() == Unit(symbols = ())
    assert Unit() == Unit(numerators = [])
    assert Unit() == Unit(numerators = ())
    assert Unit() == Unit(denominators = [])
    assert Unit() == Unit(denominators = ())
    
    # None
    assert Unit().magnitude == Decimal(1)
    assert Unit().symbols == ()
    assert Unit().numerators == ()
    
  def test_init(self):
    
    # Implicit Symbols, Implicit Magnitude
    if(True):
      # Symbols
      if(True):
        # Implicit Symbols, No Magnitude
        if(True):
          # Tuple of Strings
          if(True):
            # Numerators Only
            if(True):
              # Single Numerator
              assert Unit(["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(["u"]).denominators == ()
              assert Unit(["u"]).magnitude    == Decimal(1)
              # Multiple Duplicate Numerators
              assert Unit(["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(["u","u"]).denominators == ()
              assert Unit(["u","u"]).magnitude    == Decimal(1)
              # Multiple Different Numerators
              assert Unit(["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(["ua","ub","ub"]).denominators == ()
              assert Unit(["ua","ub","ub"]).magnitude    == Decimal(1)
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(["nu"],["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(["nu"],["du"]).numerators   == (("nu",Decimal(1)),)
              assert Unit(["nu"],["du"]).denominators == (("du",Decimal(1)),)
              assert Unit(["nu"],["du"]).magnitude    == Decimal(1)
              # Multiple Duplicate Numerators and Denominators
              assert Unit(["nu","nu","nu"],["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(["nu","nu","nu"],["du","du"]).numerators   == (("nu",Decimal(3)),)
              assert Unit(["nu","nu","nu"],["du","du"]).denominators == (("du",Decimal(2)),)
              assert Unit(["nu","nu","nu"],["du","du"]).magnitude    == Decimal(1)
              # Multiple Different Numerators and Denominators
              assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
              assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"]).magnitude    == Decimal(1)
            # Canceling
            if(True):
              # Single
              assert Unit(["u"],["u"]).symbols      == ()
              assert Unit(["u"],["u"]).numerators   == ()
              assert Unit(["u"],["u"]).denominators == ()
              assert Unit(["u"],["u"]).magnitude    == Decimal(1)
              # Multiple Duplicate
              assert Unit(["u","u","u"],["u","u","u"]).symbols      == ()
              assert Unit(["u","u","u"],["u","u","u"]).numerators   == ()
              assert Unit(["u","u","u"],["u","u","u"]).denominators == ()
              assert Unit(["u","u","u"],["u","u","u"]).magnitude    == Decimal(1)
              # Multiple Different
              assert Unit(["ua","ub","ub"],["ua","ub","ub"]).symbols      == ()
              assert Unit(["ua","ub","ub"],["ua","ub","ub"]).numerators   == ()
              assert Unit(["ua","ub","ub"],["ua","ub","ub"]).denominators == ()
              assert Unit(["ua","ub","ub"],["ua","ub","ub"]).magnitude    == Decimal(1)
              # Partial Canceling
              assert Unit(["ua","ub","ub"],["ua","ub"]).symbols      == (("ub",Decimal(1)),)
              assert Unit(["ua","ub","ub"],["ua","ub"]).numerators   == (("ub",Decimal(1)),)
              assert Unit(["ua","ub","ub"],["ua","ub"]).denominators == ()
              assert Unit(["ua","ub","ub"],["ua","ub"]).magnitude    == Decimal(1)
          # Tuple of String, Exponent
          if(True):
            # Numerators Only
            if(True):
              # Single Numerator
              assert Unit([("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit([("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit([("u",Decimal(1))]).denominators == ()
              assert Unit([("u",Decimal(1))]).magnitude    == Decimal(1)
              # Single Numerator Higher Exponent
              assert Unit([("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit([("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit([("u",Decimal(2))]).denominators == ()
              assert Unit([("u",Decimal(2))]).magnitude    == Decimal(1)
              # Multiple Duplicate Numerators
              assert Unit([("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit([("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit([("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit([("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal(1)
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit([("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit([("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit([("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit([("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal(1)
              # Multiple Different Numerators
              assert Unit([("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit([("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit([("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit([("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal(1)
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit([("nu",Decimal(1))],[("du",Decimal(1))]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit([("nu",Decimal(1))],[("du",Decimal(1))]).numerators   == (("nu",Decimal(1)),)
              assert Unit([("nu",Decimal(1))],[("du",Decimal(1))]).denominators == (("du",Decimal(1)),)
              assert Unit([("nu",Decimal(1))],[("du",Decimal(1))]).magnitude    == Decimal(1)
              # Single Numerator and Denominator Higher Exponent
              assert Unit([("nu",Decimal(2))],[("du",Decimal(3))]).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
              assert Unit([("nu",Decimal(2))],[("du",Decimal(3))]).numerators   == (("nu",Decimal(2)),)
              assert Unit([("nu",Decimal(2))],[("du",Decimal(3))]).denominators == (("du",Decimal(3)),)
              assert Unit([("nu",Decimal(2))],[("du",Decimal(3))]).magnitude    == Decimal(1)
              # Multiple Duplicate Numerators and Denominators
              assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))]).numerators   == (("nu",Decimal(3)),)
              assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))]).denominators == (("du",Decimal(2)),)
              assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))]).magnitude    == Decimal(1)
              # Multiple Duplicate Numerators and Denominators Higher Exponent
              assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))]).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
              assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))]).numerators   == (("nu",Decimal(4)),)
              assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))]).denominators == (("du",Decimal(4)),)
              assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))]).magnitude    == Decimal(1)
              # Multiple Different Numerators and Denominators
              assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))]).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))]).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))]).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
              assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))]).magnitude    == Decimal(1)
            # Canceling
            if(True):
              # Single
              assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))]).symbols      == ()
              assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))]).numerators   == ()
              assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))]).denominators == ()
              assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))]).magnitude    == Decimal(1)
              # Single Higher Exponent
              assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))]).symbols      == ()
              assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))]).numerators   == ()
              assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))]).denominators == ()
              assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))]).magnitude    == Decimal(1)
              # Multiple Duplicate
              assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal(1)
              # Multiple Duplicate Higher Exponent
              assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal(1)
              # Multiple Different
              assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).symbols      == ()
              assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).numerators   == ()
              assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).denominators == ()
              assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal(1)
              # Partial
              assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
              assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).numerators   == (("nua",Decimal(1)),)
              assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).denominators == (("nub",Decimal(1)),)
              assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal(1)
        # Implicit Symbols, Magnitude Int
        if(True):
          # Tuple of Strings
          if(True):
            # Positive Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],10).symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],10).numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],10).denominators == ()
                assert Unit(["u"],10).magnitude    == Decimal(10)
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],10).symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],10).numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],10).denominators == ()
                assert Unit(["u","u"],10).magnitude    == Decimal(10)
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],10).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],10).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],10).denominators == ()
                assert Unit(["ua","ub","ub"],10).magnitude    == Decimal(10)
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],10).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],10).numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],10).denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],10).magnitude    == Decimal(10)
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],10).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],10).numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],10).denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],10).magnitude    == Decimal(10)
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],10).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],10).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],10).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],10).magnitude    == Decimal(10)
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],10).symbols      == ()
                assert Unit(["u"],["u"],10).numerators   == ()
                assert Unit(["u"],["u"],10).denominators == ()
                assert Unit(["u"],["u"],10).magnitude    == Decimal(10)
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],10).symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],10).numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],10).denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],10).magnitude    == Decimal(10)
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],10).symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],10).numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],10).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],10).magnitude    == Decimal(10)
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],10).symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],10).numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],10).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],10).magnitude    == Decimal(10)
            # Negative Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],-10).symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],-10).numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],-10).denominators == ()
                assert Unit(["u"],-10).magnitude    == Decimal(-10)
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],-10).symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],-10).numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],-10).denominators == ()
                assert Unit(["u","u"],-10).magnitude    == Decimal(-10)
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],-10).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],-10).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],-10).denominators == ()
                assert Unit(["ua","ub","ub"],-10).magnitude    == Decimal(-10)
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],-10).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],-10).numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],-10).denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],-10).magnitude    == Decimal(-10)
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],-10).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],-10).numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],-10).denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],-10).magnitude    == Decimal(-10)
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],-10).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],-10).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],-10).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],-10).magnitude    == Decimal(-10)
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],-10).symbols      == ()
                assert Unit(["u"],["u"],-10).numerators   == ()
                assert Unit(["u"],["u"],-10).denominators == ()
                assert Unit(["u"],["u"],-10).magnitude    == Decimal(-10)
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],-10).symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],-10).numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],-10).denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],-10).magnitude    == Decimal(-10)
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],-10).symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],-10).numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],-10).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],-10).magnitude    == Decimal(-10)
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],-10).symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],-10).numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],-10).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],-10).magnitude    == Decimal(-10)
          # Tuple of String, Exponent
          if(True):
            # Positive Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],10).symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],10).numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],10).denominators == ()
                assert Unit([("u",Decimal(1))],10).magnitude    == Decimal(10)
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],10).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],10).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],10).denominators == ()
                assert Unit([("u",Decimal(2))],10).magnitude    == Decimal(10)
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],10).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],10).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],10).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],10).magnitude    == Decimal(10)
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],10).symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],10).numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],10).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],10).magnitude    == Decimal(10)
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],10).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],10).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],10).denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],10).magnitude    == Decimal(10)
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],10).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],10).numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],10).denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],10).magnitude    == Decimal(10)
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],10).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],10).numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],10).denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],10).magnitude    == Decimal(10)
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],10).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],10).numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],10).denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],10).magnitude    == Decimal(10)
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],10).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],10).numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],10).denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],10).magnitude    == Decimal(10)
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],10).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],10).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],10).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],10).magnitude    == Decimal(10)
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],10).symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],10).numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],10).denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],10).magnitude    == Decimal(10)
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],10).symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],10).numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],10).denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],10).magnitude    == Decimal(10)
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],10).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],10).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],10).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],10).magnitude    == Decimal(10)
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],10).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],10).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],10).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],10).magnitude    == Decimal(10)
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],10).symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],10).numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],10).denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],10).magnitude    == Decimal(10)
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],10).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],10).numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],10).denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],10).magnitude    == Decimal(10)
            # Negative Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],-10).symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],-10).numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],-10).denominators == ()
                assert Unit([("u",Decimal(1))],-10).magnitude    == Decimal(-10)
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],-10).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],-10).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],-10).denominators == ()
                assert Unit([("u",Decimal(2))],-10).magnitude    == Decimal(-10)
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],-10).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],-10).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],-10).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],-10).magnitude    == Decimal(-10)
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],-10).symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],-10).numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],-10).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],-10).magnitude    == Decimal(-10)
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],-10).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],-10).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],-10).denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],-10).magnitude    == Decimal(-10)
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],-10).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],-10).numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],-10).denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],-10).magnitude    == Decimal(-10)
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],-10).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],-10).numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],-10).denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],-10).magnitude    == Decimal(-10)
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],-10).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],-10).numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],-10).denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],-10).magnitude    == Decimal(-10)
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],-10).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],-10).numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],-10).denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],-10).magnitude    == Decimal(-10)
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],-10).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],-10).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],-10).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],-10).magnitude    == Decimal(-10)
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],-10).symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],-10).numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],-10).denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],-10).magnitude    == Decimal(-10)
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],-10).symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],-10).numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],-10).denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],-10).magnitude    == Decimal(-10)
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],-10).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],-10).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],-10).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],-10).magnitude    == Decimal(-10)
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],-10).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],-10).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],-10).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],-10).magnitude    == Decimal(-10)
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],-10).symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],-10).numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],-10).denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],-10).magnitude    == Decimal(-10)
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],-10).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],-10).numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],-10).denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],-10).magnitude    == Decimal(-10)
        # Implicit Symbols, Magnitude float
        if(True):
          # Tuple of Strings
          if(True):
            # Positive Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],10.1).symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],10.1).numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],10.1).denominators == ()
                assert Unit(["u"],10.1).magnitude    == 10.1
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],10.1).symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],10.1).numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],10.1).denominators == ()
                assert Unit(["u","u"],10.1).magnitude    == 10.1
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],10.1).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],10.1).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],10.1).denominators == ()
                assert Unit(["ua","ub","ub"],10.1).magnitude    == 10.1
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],10.1).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],10.1).numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],10.1).denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],10.1).magnitude    == 10.1
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],10.1).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],10.1).numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],10.1).denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],10.1).magnitude    == 10.1
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],10.1).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],10.1).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],10.1).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],10.1).magnitude    == 10.1
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],10.1).symbols      == ()
                assert Unit(["u"],["u"],10.1).numerators   == ()
                assert Unit(["u"],["u"],10.1).denominators == ()
                assert Unit(["u"],["u"],10.1).magnitude    == 10.1
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],10.1).symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],10.1).numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],10.1).denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],10.1).magnitude    == 10.1
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],10.1).symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],10.1).numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],10.1).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],10.1).magnitude    == 10.1
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],10.1).symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],10.1).numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],10.1).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],10.1).magnitude    == 10.1
              
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],10e1).symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],10e1).numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],10e1).denominators == ()
                assert Unit(["u"],10e1).magnitude    == 10e1
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],10e1).symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],10e1).numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],10e1).denominators == ()
                assert Unit(["u","u"],10e1).magnitude    == 10e1
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],10e1).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],10e1).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],10e1).denominators == ()
                assert Unit(["ua","ub","ub"],10e1).magnitude    == 10e1
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],10e1).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],10e1).numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],10e1).denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],10e1).magnitude    == 10e1
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],10e1).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],10e1).numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],10e1).denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],10e1).magnitude    == 10e1
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],10e1).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],10e1).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],10e1).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],10e1).magnitude    == 10e1
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],10e1).symbols      == ()
                assert Unit(["u"],["u"],10e1).numerators   == ()
                assert Unit(["u"],["u"],10e1).denominators == ()
                assert Unit(["u"],["u"],10e1).magnitude    == 10e1
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],10e1).symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],10e1).numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],10e1).denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],10e1).magnitude    == 10e1
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],10e1).symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],10e1).numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],10e1).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],10e1).magnitude    == 10e1
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],10e1).symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],10e1).numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],10e1).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],10e1).magnitude    == 10e1
            # Negative Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],-10.1).symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],-10.1).numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],-10.1).denominators == ()
                assert Unit(["u"],-10.1).magnitude    == -10.1
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],-10.1).symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],-10.1).numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],-10.1).denominators == ()
                assert Unit(["u","u"],-10.1).magnitude    == -10.1
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],-10.1).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],-10.1).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],-10.1).denominators == ()
                assert Unit(["ua","ub","ub"],-10.1).magnitude    == -10.1
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],-10.1).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],-10.1).numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],-10.1).denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],-10.1).magnitude    == -10.1
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],-10.1).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],-10.1).numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],-10.1).denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],-10.1).magnitude    == -10.1
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],-10.1).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],-10.1).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],-10.1).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],-10.1).magnitude    == -10.1
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],-10.1).symbols      == ()
                assert Unit(["u"],["u"],-10.1).numerators   == ()
                assert Unit(["u"],["u"],-10.1).denominators == ()
                assert Unit(["u"],["u"],-10.1).magnitude    == -10.1
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],-10.1).symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],-10.1).numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],-10.1).denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],-10.1).magnitude    == -10.1
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],-10.1).symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],-10.1).numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],-10.1).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],-10.1).magnitude    == -10.1
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],-10.1).symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],-10.1).numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],-10.1).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],-10.1).magnitude    == -10.1
              
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],-10e1).symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],-10e1).numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],-10e1).denominators == ()
                assert Unit(["u"],-10e1).magnitude    == -10e1
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],-10e1).symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],-10e1).numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],-10e1).denominators == ()
                assert Unit(["u","u"],-10e1).magnitude    == -10e1
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],-10e1).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],-10e1).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],-10e1).denominators == ()
                assert Unit(["ua","ub","ub"],-10e1).magnitude    == -10e1
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],-10e1).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],-10e1).numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],-10e1).denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],-10e1).magnitude    == -10e1
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],-10e1).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],-10e1).numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],-10e1).denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],-10e1).magnitude    == -10e1
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],-10e1).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],-10e1).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],-10e1).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],-10e1).magnitude    == -10e1
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],-10e1).symbols      == ()
                assert Unit(["u"],["u"],-10e1).numerators   == ()
                assert Unit(["u"],["u"],-10e1).denominators == ()
                assert Unit(["u"],["u"],-10e1).magnitude    == -10e1
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],-10e1).symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],-10e1).numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],-10e1).denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],-10e1).magnitude    == -10e1
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],-10e1).symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],-10e1).numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],-10e1).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],-10e1).magnitude    == -10e1
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],-10e1).symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],-10e1).numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],-10e1).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],-10e1).magnitude    == -10e1
          # Tuple of String, Exponent
          if(True):
            # Positive Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],10.1).symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],10.1).numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],10.1).denominators == ()
                assert Unit([("u",Decimal(1))],10.1).magnitude    == 10.1
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],10.1).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],10.1).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],10.1).denominators == ()
                assert Unit([("u",Decimal(2))],10.1).magnitude    == 10.1
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],10.1).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],10.1).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],10.1).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],10.1).magnitude    == 10.1
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],10.1).symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],10.1).numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],10.1).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],10.1).magnitude    == 10.1
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],10.1).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],10.1).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],10.1).denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],10.1).magnitude    == 10.1
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],10.1).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],10.1).numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],10.1).denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],10.1).magnitude    == 10.1
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],10.1).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],10.1).numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],10.1).denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],10.1).magnitude    == 10.1
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],10.1).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],10.1).numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],10.1).denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],10.1).magnitude    == 10.1
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],10.1).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],10.1).numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],10.1).denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],10.1).magnitude    == 10.1
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],10.1).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],10.1).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],10.1).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],10.1).magnitude    == 10.1
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],10.1).symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],10.1).numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],10.1).denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],10.1).magnitude    == 10.1
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],10.1).symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],10.1).numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],10.1).denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],10.1).magnitude    == 10.1
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],10.1).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],10.1).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],10.1).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],10.1).magnitude    == 10.1
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],10.1).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],10.1).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],10.1).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],10.1).magnitude    == 10.1
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],10.1).symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],10.1).numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],10.1).denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],10.1).magnitude    == 10.1
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],10.1).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],10.1).numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],10.1).denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],10.1).magnitude    == 10.1
              
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],10e1).symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],10e1).numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],10e1).denominators == ()
                assert Unit([("u",Decimal(1))],10e1).magnitude    == 10e1
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],10e1).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],10e1).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],10e1).denominators == ()
                assert Unit([("u",Decimal(2))],10e1).magnitude    == 10e1
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],10e1).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],10e1).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],10e1).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],10e1).magnitude    == 10e1
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],10e1).symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],10e1).numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],10e1).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],10e1).magnitude    == 10e1
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],10e1).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],10e1).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],10e1).denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],10e1).magnitude    == 10e1
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],10e1).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],10e1).numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],10e1).denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],10e1).magnitude    == 10e1
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],10e1).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],10e1).numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],10e1).denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],10e1).magnitude    == 10e1
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],10e1).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],10e1).numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],10e1).denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],10e1).magnitude    == 10e1
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],10e1).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],10e1).numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],10e1).denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],10e1).magnitude    == 10e1
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],10e1).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],10e1).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],10e1).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],10e1).magnitude    == 10e1
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],10e1).symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],10e1).numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],10e1).denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],10e1).magnitude    == 10e1
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],10e1).symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],10e1).numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],10e1).denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],10e1).magnitude    == 10e1
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],10e1).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],10e1).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],10e1).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],10e1).magnitude    == 10e1
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],10e1).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],10e1).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],10e1).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],10e1).magnitude    == 10e1
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],10e1).symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],10e1).numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],10e1).denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],10e1).magnitude    == 10e1
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],10e1).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],10e1).numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],10e1).denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],10e1).magnitude    == 10e1
              
            # Negative Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],-10.1).symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],-10.1).numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],-10.1).denominators == ()
                assert Unit([("u",Decimal(1))],-10.1).magnitude    == -10.1
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],-10.1).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],-10.1).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],-10.1).denominators == ()
                assert Unit([("u",Decimal(2))],-10.1).magnitude    == -10.1
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],-10.1).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],-10.1).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],-10.1).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],-10.1).magnitude    == -10.1
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],-10.1).symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],-10.1).numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],-10.1).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],-10.1).magnitude    == -10.1
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],-10.1).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],-10.1).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],-10.1).denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],-10.1).magnitude    == -10.1
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],-10.1).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],-10.1).numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],-10.1).denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],-10.1).magnitude    == -10.1
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],-10.1).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],-10.1).numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],-10.1).denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],-10.1).magnitude    == -10.1
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],-10.1).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],-10.1).numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],-10.1).denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],-10.1).magnitude    == -10.1
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],-10.1).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],-10.1).numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],-10.1).denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],-10.1).magnitude    == -10.1
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],-10.1).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],-10.1).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],-10.1).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],-10.1).magnitude    == -10.1
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],-10.1).symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],-10.1).numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],-10.1).denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],-10.1).magnitude    == -10.1
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],-10.1).symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],-10.1).numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],-10.1).denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],-10.1).magnitude    == -10.1
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],-10.1).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],-10.1).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],-10.1).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],-10.1).magnitude    == -10.1
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],-10.1).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],-10.1).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],-10.1).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],-10.1).magnitude    == -10.1
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],-10.1).symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],-10.1).numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],-10.1).denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],-10.1).magnitude    == -10.1
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],-10.1).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],-10.1).numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],-10.1).denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],-10.1).magnitude    == -10.1
              
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],-10e1).symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],-10e1).numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],-10e1).denominators == ()
                assert Unit([("u",Decimal(1))],-10e1).magnitude    == -10e1
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],-10e1).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],-10e1).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],-10e1).denominators == ()
                assert Unit([("u",Decimal(2))],-10e1).magnitude    == -10e1
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],-10e1).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],-10e1).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],-10e1).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],-10e1).magnitude    == -10e1
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],-10e1).symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],-10e1).numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],-10e1).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],-10e1).magnitude    == -10e1
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],-10e1).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],-10e1).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],-10e1).denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],-10e1).magnitude    == -10e1
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],-10e1).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],-10e1).numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],-10e1).denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],-10e1).magnitude    == -10e1
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],-10e1).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],-10e1).numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],-10e1).denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],-10e1).magnitude    == -10e1
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],-10e1).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],-10e1).numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],-10e1).denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],-10e1).magnitude    == -10e1
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],-10e1).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],-10e1).numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],-10e1).denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],-10e1).magnitude    == -10e1
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],-10e1).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],-10e1).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],-10e1).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],-10e1).magnitude    == -10e1
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],-10e1).symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],-10e1).numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],-10e1).denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],-10e1).magnitude    == -10e1
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],-10e1).symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],-10e1).numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],-10e1).denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],-10e1).magnitude    == -10e1
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],-10e1).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],-10e1).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],-10e1).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],-10e1).magnitude    == -10e1
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],-10e1).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],-10e1).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],-10e1).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],-10e1).magnitude    == -10e1
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],-10e1).symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],-10e1).numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],-10e1).denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],-10e1).magnitude    == -10e1
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],-10e1).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],-10e1).numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],-10e1).denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],-10e1).magnitude    == -10e1
        # Implicit Symbols, Magnitude str
        if(True):
          # Tuple of Strings
          if(True):
            # Positive Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],"10.1").symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],"10.1").numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],"10.1").denominators == ()
                assert Unit(["u"],"10.1").magnitude    == Decimal("10.1")
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],"10.1").symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],"10.1").numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],"10.1").denominators == ()
                assert Unit(["u","u"],"10.1").magnitude    == Decimal("10.1")
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],"10.1").symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],"10.1").numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],"10.1").denominators == ()
                assert Unit(["ua","ub","ub"],"10.1").magnitude    == Decimal("10.1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],"10.1").symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],"10.1").numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],"10.1").denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],"10.1").magnitude    == Decimal("10.1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],"10.1").symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],"10.1").numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],"10.1").denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],"10.1").magnitude    == Decimal("10.1")
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],"10.1").symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],"10.1").numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],"10.1").denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],"10.1").magnitude    == Decimal("10.1")
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],"10.1").symbols      == ()
                assert Unit(["u"],["u"],"10.1").numerators   == ()
                assert Unit(["u"],["u"],"10.1").denominators == ()
                assert Unit(["u"],["u"],"10.1").magnitude    == Decimal("10.1")
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],"10.1").symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],"10.1").numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],"10.1").denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],"10.1").magnitude    == Decimal("10.1")
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],"10.1").symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],"10.1").numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],"10.1").denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],"10.1").magnitude    == Decimal("10.1")
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],"10.1").symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],"10.1").numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],"10.1").denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],"10.1").magnitude    == Decimal("10.1")
              
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],"10e1").symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],"10e1").numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],"10e1").denominators == ()
                assert Unit(["u"],"10e1").magnitude    == Decimal("10e1")
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],"10e1").symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],"10e1").numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],"10e1").denominators == ()
                assert Unit(["u","u"],"10e1").magnitude    == Decimal("10e1")
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],"10e1").symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],"10e1").numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],"10e1").denominators == ()
                assert Unit(["ua","ub","ub"],"10e1").magnitude    == Decimal("10e1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],"10e1").symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],"10e1").numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],"10e1").denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],"10e1").magnitude    == Decimal("10e1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],"10e1").symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],"10e1").numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],"10e1").denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],"10e1").magnitude    == Decimal("10e1")
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],"10e1").symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],"10e1").numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],"10e1").denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],"10e1").magnitude    == Decimal("10e1")
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],"10e1").symbols      == ()
                assert Unit(["u"],["u"],"10e1").numerators   == ()
                assert Unit(["u"],["u"],"10e1").denominators == ()
                assert Unit(["u"],["u"],"10e1").magnitude    == Decimal("10e1")
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],"10e1").symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],"10e1").numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],"10e1").denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],"10e1").magnitude    == Decimal("10e1")
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],"10e1").symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],"10e1").numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],"10e1").denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],"10e1").magnitude    == Decimal("10e1")
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],"10e1").symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],"10e1").numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],"10e1").denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],"10e1").magnitude    == Decimal("10e1")
            # Negative Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],"-10.1").symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],"-10.1").numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],"-10.1").denominators == ()
                assert Unit(["u"],"-10.1").magnitude    == Decimal("-10.1")
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],"-10.1").symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],"-10.1").numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],"-10.1").denominators == ()
                assert Unit(["u","u"],"-10.1").magnitude    == Decimal("-10.1")
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],"-10.1").symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],"-10.1").numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],"-10.1").denominators == ()
                assert Unit(["ua","ub","ub"],"-10.1").magnitude    == Decimal("-10.1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],"-10.1").symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],"-10.1").numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],"-10.1").denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],"-10.1").magnitude    == Decimal("-10.1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],"-10.1").symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],"-10.1").numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],"-10.1").denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],"-10.1").magnitude    == Decimal("-10.1")
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],"-10.1").symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],"-10.1").numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],"-10.1").denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],"-10.1").magnitude    == Decimal("-10.1")
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],"-10.1").symbols      == ()
                assert Unit(["u"],["u"],"-10.1").numerators   == ()
                assert Unit(["u"],["u"],"-10.1").denominators == ()
                assert Unit(["u"],["u"],"-10.1").magnitude    == Decimal("-10.1")
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],"-10.1").symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],"-10.1").numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],"-10.1").denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],"-10.1").magnitude    == Decimal("-10.1")
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],"-10.1").symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],"-10.1").numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],"-10.1").denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],"-10.1").magnitude    == Decimal("-10.1")
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],"-10.1").symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],"-10.1").numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],"-10.1").denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],"-10.1").magnitude    == Decimal("-10.1")
              
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],"-10e1").symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],"-10e1").numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],"-10e1").denominators == ()
                assert Unit(["u"],"-10e1").magnitude    == Decimal("-10e1")
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],"-10e1").symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],"-10e1").numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],"-10e1").denominators == ()
                assert Unit(["u","u"],"-10e1").magnitude    == Decimal("-10e1")
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],"-10e1").symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],"-10e1").numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],"-10e1").denominators == ()
                assert Unit(["ua","ub","ub"],"-10e1").magnitude    == Decimal("-10e1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],"-10e1").symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],"-10e1").numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],"-10e1").denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],"-10e1").magnitude    == Decimal("-10e1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],"-10e1").symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],"-10e1").numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],"-10e1").denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],"-10e1").magnitude    == Decimal("-10e1")
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],"-10e1").symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],"-10e1").numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],"-10e1").denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],"-10e1").magnitude    == Decimal("-10e1")
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],"-10e1").symbols      == ()
                assert Unit(["u"],["u"],"-10e1").numerators   == ()
                assert Unit(["u"],["u"],"-10e1").denominators == ()
                assert Unit(["u"],["u"],"-10e1").magnitude    == Decimal("-10e1")
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],"-10e1").symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],"-10e1").numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],"-10e1").denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],"-10e1").magnitude    == Decimal("-10e1")
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],"-10e1").symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],"-10e1").numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],"-10e1").denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],"-10e1").magnitude    == Decimal("-10e1")
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],"-10e1").symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],"-10e1").numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],"-10e1").denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],"-10e1").magnitude    == Decimal("-10e1")
          # Tuple of String, Exponent
          if(True):
            # Positive Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],"10.1").symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],"10.1").numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],"10.1").denominators == ()
                assert Unit([("u",Decimal(1))],"10.1").magnitude    == Decimal("10.1")
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],"10.1").symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],"10.1").numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],"10.1").denominators == ()
                assert Unit([("u",Decimal(2))],"10.1").magnitude    == Decimal("10.1")
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],"10.1").symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],"10.1").numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],"10.1").denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],"10.1").magnitude    == Decimal("10.1")
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],"10.1").symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],"10.1").numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],"10.1").denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],"10.1").magnitude    == Decimal("10.1")
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],"10.1").symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],"10.1").numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],"10.1").denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],"10.1").magnitude    == Decimal("10.1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],"10.1").symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],"10.1").numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],"10.1").denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],"10.1").magnitude    == Decimal("10.1")
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],"10.1").symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],"10.1").numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],"10.1").denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],"10.1").magnitude    == Decimal("10.1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],"10.1").symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],"10.1").numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],"10.1").denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],"10.1").magnitude    == Decimal("10.1")
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],"10.1").symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],"10.1").numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],"10.1").denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],"10.1").magnitude    == Decimal("10.1")
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],"10.1").symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],"10.1").numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],"10.1").denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],"10.1").magnitude    == Decimal("10.1")
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],"10.1").symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],"10.1").numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],"10.1").denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],"10.1").magnitude    == Decimal("10.1")
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],"10.1").symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],"10.1").numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],"10.1").denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],"10.1").magnitude    == Decimal("10.1")
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],"10.1").symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],"10.1").numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],"10.1").denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],"10.1").magnitude    == Decimal("10.1")
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],"10.1").symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],"10.1").numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],"10.1").denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],"10.1").magnitude    == Decimal("10.1")
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],"10.1").symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],"10.1").numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],"10.1").denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],"10.1").magnitude    == Decimal("10.1")
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],"10.1").symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],"10.1").numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],"10.1").denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],"10.1").magnitude    == Decimal("10.1")
              
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],"10e1").symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],"10e1").numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],"10e1").denominators == ()
                assert Unit([("u",Decimal(1))],"10e1").magnitude    == Decimal("10e1")
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],"10e1").symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],"10e1").numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],"10e1").denominators == ()
                assert Unit([("u",Decimal(2))],"10e1").magnitude    == Decimal("10e1")
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],"10e1").symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],"10e1").numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],"10e1").denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],"10e1").magnitude    == Decimal("10e1")
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],"10e1").symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],"10e1").numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],"10e1").denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],"10e1").magnitude    == Decimal("10e1")
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],"10e1").symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],"10e1").numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],"10e1").denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],"10e1").magnitude    == Decimal("10e1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],"10e1").symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],"10e1").numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],"10e1").denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],"10e1").magnitude    == Decimal("10e1")
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],"10e1").symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],"10e1").numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],"10e1").denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],"10e1").magnitude    == Decimal("10e1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],"10e1").symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],"10e1").numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],"10e1").denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],"10e1").magnitude    == Decimal("10e1")
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],"10e1").symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],"10e1").numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],"10e1").denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],"10e1").magnitude    == Decimal("10e1")
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],"10e1").symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],"10e1").numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],"10e1").denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],"10e1").magnitude    == Decimal("10e1")
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],"10e1").symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],"10e1").numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],"10e1").denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],"10e1").magnitude    == Decimal("10e1")
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],"10e1").symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],"10e1").numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],"10e1").denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],"10e1").magnitude    == Decimal("10e1")
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],"10e1").symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],"10e1").numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],"10e1").denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],"10e1").magnitude    == Decimal("10e1")
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],"10e1").symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],"10e1").numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],"10e1").denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],"10e1").magnitude    == Decimal("10e1")
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],"10e1").symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],"10e1").numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],"10e1").denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],"10e1").magnitude    == Decimal("10e1")
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],"10e1").symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],"10e1").numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],"10e1").denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],"10e1").magnitude    == Decimal("10e1")
              
            # Negative Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],"-10.1").symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],"-10.1").numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],"-10.1").denominators == ()
                assert Unit([("u",Decimal(1))],"-10.1").magnitude    == Decimal("-10.1")
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],"-10.1").symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],"-10.1").numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],"-10.1").denominators == ()
                assert Unit([("u",Decimal(2))],"-10.1").magnitude    == Decimal("-10.1")
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],"-10.1").symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],"-10.1").numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],"-10.1").denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],"-10.1").magnitude    == Decimal("-10.1")
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],"-10.1").symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],"-10.1").numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],"-10.1").denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],"-10.1").magnitude    == Decimal("-10.1")
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],"-10.1").symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],"-10.1").numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],"-10.1").denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],"-10.1").magnitude    == Decimal("-10.1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],"-10.1").symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],"-10.1").numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],"-10.1").denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],"-10.1").magnitude    == Decimal("-10.1")
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],"-10.1").symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],"-10.1").numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],"-10.1").denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],"-10.1").magnitude    == Decimal("-10.1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],"-10.1").symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],"-10.1").numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],"-10.1").denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],"-10.1").magnitude    == Decimal("-10.1")
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],"-10.1").symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],"-10.1").numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],"-10.1").denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],"-10.1").magnitude    == Decimal("-10.1")
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],"-10.1").symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],"-10.1").numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],"-10.1").denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],"-10.1").magnitude    == Decimal("-10.1")
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],"-10.1").symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],"-10.1").numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],"-10.1").denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],"-10.1").magnitude    == Decimal("-10.1")
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],"-10.1").symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],"-10.1").numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],"-10.1").denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],"-10.1").magnitude    == Decimal("-10.1")
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],"-10.1").symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],"-10.1").numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],"-10.1").denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],"-10.1").magnitude    == Decimal("-10.1")
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],"-10.1").symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],"-10.1").numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],"-10.1").denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],"-10.1").magnitude    == Decimal("-10.1")
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],"-10.1").symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],"-10.1").numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],"-10.1").denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],"-10.1").magnitude    == Decimal("-10.1")
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],"-10.1").symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],"-10.1").numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],"-10.1").denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],"-10.1").magnitude    == Decimal("-10.1")
              
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],"-10e1").symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],"-10e1").numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],"-10e1").denominators == ()
                assert Unit([("u",Decimal(1))],"-10e1").magnitude    == Decimal("-10e1")
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],"-10e1").symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],"-10e1").numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],"-10e1").denominators == ()
                assert Unit([("u",Decimal(2))],"-10e1").magnitude    == Decimal("-10e1")
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],"-10e1").symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],"-10e1").numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],"-10e1").denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],"-10e1").magnitude    == Decimal("-10e1")
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],"-10e1").symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],"-10e1").numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],"-10e1").denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],"-10e1").magnitude    == Decimal("-10e1")
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],"-10e1").symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],"-10e1").numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],"-10e1").denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],"-10e1").magnitude    == Decimal("-10e1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],"-10e1").symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],"-10e1").numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],"-10e1").denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],"-10e1").magnitude    == Decimal("-10e1")
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],"-10e1").symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],"-10e1").numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],"-10e1").denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],"-10e1").magnitude    == Decimal("-10e1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],"-10e1").symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],"-10e1").numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],"-10e1").denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],"-10e1").magnitude    == Decimal("-10e1")
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],"-10e1").symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],"-10e1").numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],"-10e1").denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],"-10e1").magnitude    == Decimal("-10e1")
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],"-10e1").symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],"-10e1").numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],"-10e1").denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],"-10e1").magnitude    == Decimal("-10e1")
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],"-10e1").symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],"-10e1").numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],"-10e1").denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],"-10e1").magnitude    == Decimal("-10e1")
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],"-10e1").symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],"-10e1").numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],"-10e1").denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],"-10e1").magnitude    == Decimal("-10e1")
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],"-10e1").symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],"-10e1").numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],"-10e1").denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],"-10e1").magnitude    == Decimal("-10e1")
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],"-10e1").symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],"-10e1").numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],"-10e1").denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],"-10e1").magnitude    == Decimal("-10e1")
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],"-10e1").symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],"-10e1").numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],"-10e1").denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],"-10e1").magnitude    == Decimal("-10e1")
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],"-10e1").symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],"-10e1").numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],"-10e1").denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],"-10e1").magnitude    == Decimal("-10e1")
        # Implicit Symbols, Magnitude Decimal
        if(True):
          # Tuple of Strings
          if(True):
            # Positive Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],Decimal("10.1")).symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],Decimal("10.1")).numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],Decimal("10.1")).denominators == ()
                assert Unit(["u"],Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],Decimal("10.1")).symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],Decimal("10.1")).numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],Decimal("10.1")).denominators == ()
                assert Unit(["u","u"],Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],Decimal("10.1")).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],Decimal("10.1")).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],Decimal("10.1")).denominators == ()
                assert Unit(["ua","ub","ub"],Decimal("10.1")).magnitude    == Decimal("10.1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],Decimal("10.1")).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],Decimal("10.1")).numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],Decimal("10.1")).denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],Decimal("10.1")).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],Decimal("10.1")).numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],Decimal("10.1")).denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],Decimal("10.1")).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],Decimal("10.1")).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],Decimal("10.1")).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],Decimal("10.1")).magnitude    == Decimal("10.1")
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],Decimal("10.1")).symbols      == ()
                assert Unit(["u"],["u"],Decimal("10.1")).numerators   == ()
                assert Unit(["u"],["u"],Decimal("10.1")).denominators == ()
                assert Unit(["u"],["u"],Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],Decimal("10.1")).symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],Decimal("10.1")).numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],Decimal("10.1")).denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],Decimal("10.1")).symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],Decimal("10.1")).numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],Decimal("10.1")).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],Decimal("10.1")).magnitude    == Decimal("10.1")
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],Decimal("10.1")).symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],Decimal("10.1")).numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],Decimal("10.1")).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],Decimal("10.1")).magnitude    == Decimal("10.1")
              
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],Decimal("10e1")).symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],Decimal("10e1")).numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],Decimal("10e1")).denominators == ()
                assert Unit(["u"],Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],Decimal("10e1")).symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],Decimal("10e1")).numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],Decimal("10e1")).denominators == ()
                assert Unit(["u","u"],Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],Decimal("10e1")).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],Decimal("10e1")).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],Decimal("10e1")).denominators == ()
                assert Unit(["ua","ub","ub"],Decimal("10e1")).magnitude    == Decimal("10e1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],Decimal("10e1")).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],Decimal("10e1")).numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],Decimal("10e1")).denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],Decimal("10e1")).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],Decimal("10e1")).numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],Decimal("10e1")).denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],Decimal("10e1")).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],Decimal("10e1")).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],Decimal("10e1")).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],Decimal("10e1")).magnitude    == Decimal("10e1")
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],Decimal("10e1")).symbols      == ()
                assert Unit(["u"],["u"],Decimal("10e1")).numerators   == ()
                assert Unit(["u"],["u"],Decimal("10e1")).denominators == ()
                assert Unit(["u"],["u"],Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],Decimal("10e1")).symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],Decimal("10e1")).numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],Decimal("10e1")).denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],Decimal("10e1")).symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],Decimal("10e1")).numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],Decimal("10e1")).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],Decimal("10e1")).magnitude    == Decimal("10e1")
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],Decimal("10e1")).symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],Decimal("10e1")).numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],Decimal("10e1")).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],Decimal("10e1")).magnitude    == Decimal("10e1")
            # Negative Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],Decimal("-10.1")).symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],Decimal("-10.1")).numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],Decimal("-10.1")).denominators == ()
                assert Unit(["u"],Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],Decimal("-10.1")).symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],Decimal("-10.1")).numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],Decimal("-10.1")).denominators == ()
                assert Unit(["u","u"],Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],Decimal("-10.1")).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],Decimal("-10.1")).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],Decimal("-10.1")).denominators == ()
                assert Unit(["ua","ub","ub"],Decimal("-10.1")).magnitude    == Decimal("-10.1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],Decimal("-10.1")).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],Decimal("-10.1")).numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],Decimal("-10.1")).denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],Decimal("-10.1")).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],Decimal("-10.1")).numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],Decimal("-10.1")).denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],Decimal("-10.1")).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],Decimal("-10.1")).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],Decimal("-10.1")).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],Decimal("-10.1")).magnitude    == Decimal("-10.1")
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],Decimal("-10.1")).symbols      == ()
                assert Unit(["u"],["u"],Decimal("-10.1")).numerators   == ()
                assert Unit(["u"],["u"],Decimal("-10.1")).denominators == ()
                assert Unit(["u"],["u"],Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],Decimal("-10.1")).symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],Decimal("-10.1")).numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],Decimal("-10.1")).denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],Decimal("-10.1")).symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],Decimal("-10.1")).numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],Decimal("-10.1")).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],Decimal("-10.1")).symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],Decimal("-10.1")).numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],Decimal("-10.1")).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],Decimal("-10.1")).magnitude    == Decimal("-10.1")
              
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],Decimal("-10e1")).symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],Decimal("-10e1")).numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],Decimal("-10e1")).denominators == ()
                assert Unit(["u"],Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],Decimal("-10e1")).symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],Decimal("-10e1")).numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],Decimal("-10e1")).denominators == ()
                assert Unit(["u","u"],Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],Decimal("-10e1")).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],Decimal("-10e1")).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],Decimal("-10e1")).denominators == ()
                assert Unit(["ua","ub","ub"],Decimal("-10e1")).magnitude    == Decimal("-10e1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],Decimal("-10e1")).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],Decimal("-10e1")).numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],Decimal("-10e1")).denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],Decimal("-10e1")).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],Decimal("-10e1")).numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],Decimal("-10e1")).denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],Decimal("-10e1")).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],Decimal("-10e1")).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],Decimal("-10e1")).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],Decimal("-10e1")).magnitude    == Decimal("-10e1")
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],Decimal("-10e1")).symbols      == ()
                assert Unit(["u"],["u"],Decimal("-10e1")).numerators   == ()
                assert Unit(["u"],["u"],Decimal("-10e1")).denominators == ()
                assert Unit(["u"],["u"],Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],Decimal("-10e1")).symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],Decimal("-10e1")).numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],Decimal("-10e1")).denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],Decimal("-10e1")).symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],Decimal("-10e1")).numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],Decimal("-10e1")).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],Decimal("-10e1")).symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],Decimal("-10e1")).numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],Decimal("-10e1")).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],Decimal("-10e1")).magnitude    == Decimal("-10e1")
          # Tuple of String, Exponent
          if(True):
            # Positive Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],Decimal("10.1")).symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],Decimal("10.1")).numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],Decimal("10.1")).denominators == ()
                assert Unit([("u",Decimal(1))],Decimal("10.1")).magnitude    == Decimal("10.1")
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],Decimal("10.1")).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],Decimal("10.1")).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],Decimal("10.1")).denominators == ()
                assert Unit([("u",Decimal(2))],Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],Decimal("10.1")).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],Decimal("10.1")).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],Decimal("10.1")).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],Decimal("10.1")).symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],Decimal("10.1")).numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],Decimal("10.1")).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],Decimal("10.1")).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],Decimal("10.1")).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],Decimal("10.1")).denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],Decimal("10.1")).magnitude    == Decimal("10.1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],Decimal("10.1")).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],Decimal("10.1")).numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],Decimal("10.1")).denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],Decimal("10.1")).magnitude    == Decimal("10.1")
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],Decimal("10.1")).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],Decimal("10.1")).numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],Decimal("10.1")).denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],Decimal("10.1")).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],Decimal("10.1")).numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],Decimal("10.1")).denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],Decimal("10.1")).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],Decimal("10.1")).numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],Decimal("10.1")).denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],Decimal("10.1")).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],Decimal("10.1")).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],Decimal("10.1")).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],Decimal("10.1")).magnitude    == Decimal("10.1")
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],Decimal("10.1")).symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],Decimal("10.1")).numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],Decimal("10.1")).denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],Decimal("10.1")).magnitude    == Decimal("10.1")
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],Decimal("10.1")).symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],Decimal("10.1")).numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],Decimal("10.1")).denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("10.1")).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("10.1")).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("10.1")).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("10.1")).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("10.1")).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("10.1")).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],Decimal("10.1")).symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],Decimal("10.1")).numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],Decimal("10.1")).denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],Decimal("10.1")).magnitude    == Decimal("10.1")
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],Decimal("10.1")).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],Decimal("10.1")).numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],Decimal("10.1")).denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],Decimal("10.1")).magnitude    == Decimal("10.1")
              
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],Decimal("10e1")).symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],Decimal("10e1")).numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],Decimal("10e1")).denominators == ()
                assert Unit([("u",Decimal(1))],Decimal("10e1")).magnitude    == Decimal("10e1")
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],Decimal("10e1")).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],Decimal("10e1")).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],Decimal("10e1")).denominators == ()
                assert Unit([("u",Decimal(2))],Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],Decimal("10e1")).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],Decimal("10e1")).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],Decimal("10e1")).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],Decimal("10e1")).symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],Decimal("10e1")).numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],Decimal("10e1")).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],Decimal("10e1")).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],Decimal("10e1")).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],Decimal("10e1")).denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],Decimal("10e1")).magnitude    == Decimal("10e1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],Decimal("10e1")).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],Decimal("10e1")).numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],Decimal("10e1")).denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],Decimal("10e1")).magnitude    == Decimal("10e1")
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],Decimal("10e1")).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],Decimal("10e1")).numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],Decimal("10e1")).denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],Decimal("10e1")).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],Decimal("10e1")).numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],Decimal("10e1")).denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],Decimal("10e1")).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],Decimal("10e1")).numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],Decimal("10e1")).denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],Decimal("10e1")).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],Decimal("10e1")).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],Decimal("10e1")).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],Decimal("10e1")).magnitude    == Decimal("10e1")
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],Decimal("10e1")).symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],Decimal("10e1")).numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],Decimal("10e1")).denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],Decimal("10e1")).magnitude    == Decimal("10e1")
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],Decimal("10e1")).symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],Decimal("10e1")).numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],Decimal("10e1")).denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("10e1")).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("10e1")).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("10e1")).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("10e1")).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("10e1")).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("10e1")).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],Decimal("10e1")).symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],Decimal("10e1")).numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],Decimal("10e1")).denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],Decimal("10e1")).magnitude    == Decimal("10e1")
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],Decimal("10e1")).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],Decimal("10e1")).numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],Decimal("10e1")).denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],Decimal("10e1")).magnitude    == Decimal("10e1")
              
            # Negative Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],Decimal("-10.1")).symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],Decimal("-10.1")).numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],Decimal("-10.1")).denominators == ()
                assert Unit([("u",Decimal(1))],Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],Decimal("-10.1")).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],Decimal("-10.1")).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],Decimal("-10.1")).denominators == ()
                assert Unit([("u",Decimal(2))],Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],Decimal("-10.1")).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],Decimal("-10.1")).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],Decimal("-10.1")).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],Decimal("-10.1")).symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],Decimal("-10.1")).numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],Decimal("-10.1")).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],Decimal("-10.1")).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],Decimal("-10.1")).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],Decimal("-10.1")).denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],Decimal("-10.1")).magnitude    == Decimal("-10.1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],Decimal("-10.1")).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],Decimal("-10.1")).numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],Decimal("-10.1")).denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],Decimal("-10.1")).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],Decimal("-10.1")).numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],Decimal("-10.1")).denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],Decimal("-10.1")).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],Decimal("-10.1")).numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],Decimal("-10.1")).denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],Decimal("-10.1")).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],Decimal("-10.1")).numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],Decimal("-10.1")).denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],Decimal("-10.1")).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],Decimal("-10.1")).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],Decimal("-10.1")).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],Decimal("-10.1")).magnitude    == Decimal("-10.1")
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],Decimal("-10.1")).symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],Decimal("-10.1")).numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],Decimal("-10.1")).denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],Decimal("-10.1")).symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],Decimal("-10.1")).numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],Decimal("-10.1")).denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("-10.1")).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("-10.1")).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("-10.1")).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("-10.1")).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("-10.1")).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("-10.1")).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],Decimal("-10.1")).symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],Decimal("-10.1")).numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],Decimal("-10.1")).denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],Decimal("-10.1")).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],Decimal("-10.1")).numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],Decimal("-10.1")).denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],Decimal("-10.1")).magnitude    == Decimal("-10.1")
              
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],Decimal("-10e1")).symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],Decimal("-10e1")).numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],Decimal("-10e1")).denominators == ()
                assert Unit([("u",Decimal(1))],Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],Decimal("-10e1")).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],Decimal("-10e1")).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],Decimal("-10e1")).denominators == ()
                assert Unit([("u",Decimal(2))],Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],Decimal("-10e1")).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],Decimal("-10e1")).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],Decimal("-10e1")).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],Decimal("-10e1")).symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],Decimal("-10e1")).numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],Decimal("-10e1")).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],Decimal("-10e1")).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],Decimal("-10e1")).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],Decimal("-10e1")).denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],Decimal("-10e1")).magnitude    == Decimal("-10e1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],Decimal("-10e1")).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],Decimal("-10e1")).numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],Decimal("-10e1")).denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],Decimal("-10e1")).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],Decimal("-10e1")).numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],Decimal("-10e1")).denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],Decimal("-10e1")).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],Decimal("-10e1")).numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],Decimal("-10e1")).denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],Decimal("-10e1")).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],Decimal("-10e1")).numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],Decimal("-10e1")).denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],Decimal("-10e1")).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],Decimal("-10e1")).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],Decimal("-10e1")).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],Decimal("-10e1")).magnitude    == Decimal("-10e1")
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],Decimal("-10e1")).symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],Decimal("-10e1")).numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],Decimal("-10e1")).denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],Decimal("-10e1")).symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],Decimal("-10e1")).numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],Decimal("-10e1")).denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("-10e1")).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("-10e1")).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("-10e1")).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("-10e1")).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("-10e1")).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("-10e1")).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],Decimal("-10e1")).symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],Decimal("-10e1")).numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],Decimal("-10e1")).denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],Decimal("-10e1")).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],Decimal("-10e1")).numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],Decimal("-10e1")).denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],Decimal("-10e1")).magnitude    == Decimal("-10e1")
      # No Symbols
      if(True):
        # Magnitude Int
        if(True):
          # Positive Magnitude
          if(True):
            assert Unit(10).symbols      == ()
            assert Unit(10).numerators   == ()
            assert Unit(10).denominators == ()
            assert Unit(10).magnitude    == Decimal(10)
          # Negative Magnitude
          if(True):
            assert Unit(-10).symbols      == ()
            assert Unit(-10).numerators   == ()
            assert Unit(-10).denominators == ()
            assert Unit(-10).magnitude    == Decimal(-10)
        # Magnitude float
        if(True):
          # Positive Magnitude
          if(True):
            # Standard Notation
            assert Unit(10.1).symbols      == ()
            assert Unit(10.1).numerators   == ()
            assert Unit(10.1).denominators == ()
            assert Unit(10.1).magnitude    == 10.1
            # Exponent Notation
            assert Unit(10e1).symbols      == ()
            assert Unit(10e1).numerators   == ()
            assert Unit(10e1).denominators == ()
            assert Unit(10e1).magnitude    == 100
          # Negative Magnitude
          if(True):
            # Standard Notation
            assert Unit(-10.1).symbols      == ()
            assert Unit(-10.1).numerators   == ()
            assert Unit(-10.1).denominators == ()
            assert Unit(-10.1).magnitude    == -10.1
            # Exponent Notation
            assert Unit(-10e1).symbols      == ()
            assert Unit(-10e1).numerators   == ()
            assert Unit(-10e1).denominators == ()
            assert Unit(-10e1).magnitude    == -100
        # Magnitude str
        if(True):
          # Positive Magnitude
          if(True):
            # Standard Notation
            assert Unit("10.1").symbols      == ()
            assert Unit("10.1").numerators   == ()
            assert Unit("10.1").denominators == ()
            assert Unit("10.1").magnitude    == Decimal("10.1")
            # Exponent Notation
            assert Unit("10e1").symbols      == ()
            assert Unit("10e1").numerators   == ()
            assert Unit("10e1").denominators == ()
            assert Unit("10e1").magnitude    == Decimal("10e1")
          # Negative Magnitude
          if(True):
            # Standard Notation
            assert Unit("-10.1").symbols      == ()
            assert Unit("-10.1").numerators   == ()
            assert Unit("-10.1").denominators == ()
            assert Unit("-10.1").magnitude    == Decimal("-10.1")
            # Exponent Notation
            assert Unit("-10e1").symbols      == ()
            assert Unit("-10e1").numerators   == ()
            assert Unit("-10e1").denominators == ()
            assert Unit("-10e1").magnitude    == Decimal("-10e1")
        # Magnitude Decimal
        if(True):
          # Positive Magnitude
          if(True):
            # Standard Notation
            assert Unit(Decimal("10.1")).symbols      == ()
            assert Unit(Decimal("10.1")).numerators   == ()
            assert Unit(Decimal("10.1")).denominators == ()
            assert Unit(Decimal("10.1")).magnitude    == Decimal("10.1")
            # Exponent Notation
            assert Unit(Decimal("10e1")).symbols      == ()
            assert Unit(Decimal("10e1")).numerators   == ()
            assert Unit(Decimal("10e1")).denominators == ()
            assert Unit(Decimal("10e1")).magnitude    == Decimal("10e1")
          # Negative Magnitude
          if(True):
            # Standard Notation
            assert Unit(Decimal("-10.1")).symbols      == ()
            assert Unit(Decimal("-10.1")).numerators   == ()
            assert Unit(Decimal("-10.1")).denominators == ()
            assert Unit(Decimal("-10.1")).magnitude    == Decimal("-10.1")
            # Exponent Notation
            assert Unit(Decimal("-10e1")).symbols      == ()
            assert Unit(Decimal("-10e1")).numerators   == ()
            assert Unit(Decimal("-10e1")).denominators == ()
            assert Unit(Decimal("-10e1")).magnitude    == Decimal("-10e1")
    # Implicit Symbols, Explicit Magnitude
    if(True):
      # Symbols
      if(True):
        # Implicit Symbols, Magnitude Int
        if(True):
          # Tuple of Strings
          if(True):
            # Positive Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],magnitude=10).symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude=10).numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude=10).denominators == ()
                assert Unit(["u"],magnitude=10).magnitude    == Decimal(10)
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],magnitude=10).symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude=10).numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude=10).denominators == ()
                assert Unit(["u","u"],magnitude=10).magnitude    == Decimal(10)
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],magnitude=10).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude=10).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude=10).denominators == ()
                assert Unit(["ua","ub","ub"],magnitude=10).magnitude    == Decimal(10)
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],magnitude=10).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],magnitude=10).numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude=10).denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude=10).magnitude    == Decimal(10)
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=10).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=10).numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=10).denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=10).magnitude    == Decimal(10)
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=10).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=10).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=10).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=10).magnitude    == Decimal(10)
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],magnitude=10).symbols      == ()
                assert Unit(["u"],["u"],magnitude=10).numerators   == ()
                assert Unit(["u"],["u"],magnitude=10).denominators == ()
                assert Unit(["u"],["u"],magnitude=10).magnitude    == Decimal(10)
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],magnitude=10).symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=10).numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=10).denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=10).magnitude    == Decimal(10)
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=10).symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=10).numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=10).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=10).magnitude    == Decimal(10)
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=10).symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=10).numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=10).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=10).magnitude    == Decimal(10)
            # Negative Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],magnitude=-10).symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude=-10).numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude=-10).denominators == ()
                assert Unit(["u"],magnitude=-10).magnitude    == Decimal(-10)
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],magnitude=-10).symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude=-10).numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude=-10).denominators == ()
                assert Unit(["u","u"],magnitude=-10).magnitude    == Decimal(-10)
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],magnitude=-10).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude=-10).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude=-10).denominators == ()
                assert Unit(["ua","ub","ub"],magnitude=-10).magnitude    == Decimal(-10)
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],magnitude=-10).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],magnitude=-10).numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude=-10).denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude=-10).magnitude    == Decimal(-10)
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=-10).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=-10).numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=-10).denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=-10).magnitude    == Decimal(-10)
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=-10).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=-10).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=-10).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=-10).magnitude    == Decimal(-10)
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],magnitude=-10).symbols      == ()
                assert Unit(["u"],["u"],magnitude=-10).numerators   == ()
                assert Unit(["u"],["u"],magnitude=-10).denominators == ()
                assert Unit(["u"],["u"],magnitude=-10).magnitude    == Decimal(-10)
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],magnitude=-10).symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=-10).numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=-10).denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=-10).magnitude    == Decimal(-10)
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=-10).symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=-10).numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=-10).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=-10).magnitude    == Decimal(-10)
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=-10).symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=-10).numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=-10).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=-10).magnitude    == Decimal(-10)
          # Tuple of String, Exponent
          if(True):
            # Positive Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],magnitude=10).symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude=10).numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude=10).denominators == ()
                assert Unit([("u",Decimal(1))],magnitude=10).magnitude    == Decimal(10)
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],magnitude=10).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude=10).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude=10).denominators == ()
                assert Unit([("u",Decimal(2))],magnitude=10).magnitude    == Decimal(10)
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=10).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=10).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=10).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=10).magnitude    == Decimal(10)
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=10).symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=10).numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=10).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=10).magnitude    == Decimal(10)
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=10).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=10).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=10).denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=10).magnitude    == Decimal(10)
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=10).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=10).numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=10).denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=10).magnitude    == Decimal(10)
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=10).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=10).numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=10).denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=10).magnitude    == Decimal(10)
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=10).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=10).numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=10).denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=10).magnitude    == Decimal(10)
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=10).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=10).numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=10).denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=10).magnitude    == Decimal(10)
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=10).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=10).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=10).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=10).magnitude    == Decimal(10)
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=10).symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=10).numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=10).denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=10).magnitude    == Decimal(10)
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=10).symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=10).numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=10).denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=10).magnitude    == Decimal(10)
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=10).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=10).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=10).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=10).magnitude    == Decimal(10)
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=10).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=10).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=10).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=10).magnitude    == Decimal(10)
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=10).symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=10).numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=10).denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=10).magnitude    == Decimal(10)
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=10).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=10).numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=10).denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=10).magnitude    == Decimal(10)
            # Negative Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],magnitude=-10).symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude=-10).numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude=-10).denominators == ()
                assert Unit([("u",Decimal(1))],magnitude=-10).magnitude    == Decimal(-10)
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],magnitude=-10).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude=-10).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude=-10).denominators == ()
                assert Unit([("u",Decimal(2))],magnitude=-10).magnitude    == Decimal(-10)
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=-10).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=-10).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=-10).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=-10).magnitude    == Decimal(-10)
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=-10).symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=-10).numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=-10).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=-10).magnitude    == Decimal(-10)
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=-10).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=-10).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=-10).denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=-10).magnitude    == Decimal(-10)
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=-10).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=-10).numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=-10).denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=-10).magnitude    == Decimal(-10)
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=-10).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=-10).numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=-10).denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=-10).magnitude    == Decimal(-10)
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=-10).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=-10).numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=-10).denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=-10).magnitude    == Decimal(-10)
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=-10).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=-10).numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=-10).denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=-10).magnitude    == Decimal(-10)
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=-10).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=-10).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=-10).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=-10).magnitude    == Decimal(-10)
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=-10).symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=-10).numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=-10).denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=-10).magnitude    == Decimal(-10)
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=-10).symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=-10).numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=-10).denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=-10).magnitude    == Decimal(-10)
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=-10).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=-10).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=-10).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=-10).magnitude    == Decimal(-10)
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=-10).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=-10).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=-10).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=-10).magnitude    == Decimal(-10)
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=-10).symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=-10).numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=-10).denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=-10).magnitude    == Decimal(-10)
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=-10).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=-10).numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=-10).denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=-10).magnitude    == Decimal(-10)
        # Implicit Symbols, Magnitude float
        if(True):
          # Tuple of Strings
          if(True):
            # Positive Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],magnitude=10.1).symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude=10.1).numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude=10.1).denominators == ()
                assert Unit(["u"],magnitude=10.1).magnitude    == 10.1
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],magnitude=10.1).symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude=10.1).numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude=10.1).denominators == ()
                assert Unit(["u","u"],magnitude=10.1).magnitude    == 10.1
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],magnitude=10.1).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude=10.1).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude=10.1).denominators == ()
                assert Unit(["ua","ub","ub"],magnitude=10.1).magnitude    == 10.1
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],magnitude=10.1).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],magnitude=10.1).numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude=10.1).denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude=10.1).magnitude    == 10.1
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=10.1).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=10.1).numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=10.1).denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=10.1).magnitude    == 10.1
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=10.1).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=10.1).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=10.1).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=10.1).magnitude    == 10.1
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],magnitude=10.1).symbols      == ()
                assert Unit(["u"],["u"],magnitude=10.1).numerators   == ()
                assert Unit(["u"],["u"],magnitude=10.1).denominators == ()
                assert Unit(["u"],["u"],magnitude=10.1).magnitude    == 10.1
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],magnitude=10.1).symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=10.1).numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=10.1).denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=10.1).magnitude    == 10.1
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=10.1).symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=10.1).numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=10.1).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=10.1).magnitude    == 10.1
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=10.1).symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=10.1).numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=10.1).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=10.1).magnitude    == 10.1
              
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],magnitude=10e1).symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude=10e1).numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude=10e1).denominators == ()
                assert Unit(["u"],magnitude=10e1).magnitude    == 10e1
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],magnitude=10e1).symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude=10e1).numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude=10e1).denominators == ()
                assert Unit(["u","u"],magnitude=10e1).magnitude    == 10e1
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],magnitude=10e1).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude=10e1).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude=10e1).denominators == ()
                assert Unit(["ua","ub","ub"],magnitude=10e1).magnitude    == 10e1
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],magnitude=10e1).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],magnitude=10e1).numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude=10e1).denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude=10e1).magnitude    == 10e1
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=10e1).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=10e1).numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=10e1).denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=10e1).magnitude    == 10e1
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=10e1).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=10e1).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=10e1).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=10e1).magnitude    == 10e1
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],magnitude=10e1).symbols      == ()
                assert Unit(["u"],["u"],magnitude=10e1).numerators   == ()
                assert Unit(["u"],["u"],magnitude=10e1).denominators == ()
                assert Unit(["u"],["u"],magnitude=10e1).magnitude    == 10e1
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],magnitude=10e1).symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=10e1).numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=10e1).denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=10e1).magnitude    == 10e1
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=10e1).symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=10e1).numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=10e1).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=10e1).magnitude    == 10e1
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=10e1).symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=10e1).numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=10e1).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=10e1).magnitude    == 10e1
            # Negative Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],magnitude=-10.1).symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude=-10.1).numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude=-10.1).denominators == ()
                assert Unit(["u"],magnitude=-10.1).magnitude    == -10.1
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],magnitude=-10.1).symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude=-10.1).numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude=-10.1).denominators == ()
                assert Unit(["u","u"],magnitude=-10.1).magnitude    == -10.1
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],magnitude=-10.1).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude=-10.1).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude=-10.1).denominators == ()
                assert Unit(["ua","ub","ub"],magnitude=-10.1).magnitude    == -10.1
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],magnitude=-10.1).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],magnitude=-10.1).numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude=-10.1).denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude=-10.1).magnitude    == -10.1
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=-10.1).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=-10.1).numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=-10.1).denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=-10.1).magnitude    == -10.1
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=-10.1).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=-10.1).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=-10.1).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=-10.1).magnitude    == -10.1
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],magnitude=-10.1).symbols      == ()
                assert Unit(["u"],["u"],magnitude=-10.1).numerators   == ()
                assert Unit(["u"],["u"],magnitude=-10.1).denominators == ()
                assert Unit(["u"],["u"],magnitude=-10.1).magnitude    == -10.1
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],magnitude=-10.1).symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=-10.1).numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=-10.1).denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=-10.1).magnitude    == -10.1
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=-10.1).symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=-10.1).numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=-10.1).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=-10.1).magnitude    == -10.1
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=-10.1).symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=-10.1).numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=-10.1).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=-10.1).magnitude    == -10.1
              
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],magnitude=-10e1).symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude=-10e1).numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude=-10e1).denominators == ()
                assert Unit(["u"],magnitude=-10e1).magnitude    == -10e1
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],magnitude=-10e1).symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude=-10e1).numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude=-10e1).denominators == ()
                assert Unit(["u","u"],magnitude=-10e1).magnitude    == -10e1
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],magnitude=-10e1).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude=-10e1).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude=-10e1).denominators == ()
                assert Unit(["ua","ub","ub"],magnitude=-10e1).magnitude    == -10e1
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],magnitude=-10e1).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],magnitude=-10e1).numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude=-10e1).denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude=-10e1).magnitude    == -10e1
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=-10e1).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=-10e1).numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=-10e1).denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=-10e1).magnitude    == -10e1
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=-10e1).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=-10e1).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=-10e1).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=-10e1).magnitude    == -10e1
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],magnitude=-10e1).symbols      == ()
                assert Unit(["u"],["u"],magnitude=-10e1).numerators   == ()
                assert Unit(["u"],["u"],magnitude=-10e1).denominators == ()
                assert Unit(["u"],["u"],magnitude=-10e1).magnitude    == -10e1
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],magnitude=-10e1).symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=-10e1).numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=-10e1).denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=-10e1).magnitude    == -10e1
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=-10e1).symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=-10e1).numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=-10e1).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=-10e1).magnitude    == -10e1
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=-10e1).symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=-10e1).numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=-10e1).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=-10e1).magnitude    == -10e1
          # Tuple of String, Exponent
          if(True):
            # Positive Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],magnitude=10.1).symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude=10.1).numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude=10.1).denominators == ()
                assert Unit([("u",Decimal(1))],magnitude=10.1).magnitude    == 10.1
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],magnitude=10.1).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude=10.1).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude=10.1).denominators == ()
                assert Unit([("u",Decimal(2))],magnitude=10.1).magnitude    == 10.1
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=10.1).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=10.1).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=10.1).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=10.1).magnitude    == 10.1
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=10.1).symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=10.1).numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=10.1).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=10.1).magnitude    == 10.1
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=10.1).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=10.1).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=10.1).denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=10.1).magnitude    == 10.1
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=10.1).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=10.1).numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=10.1).denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=10.1).magnitude    == 10.1
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=10.1).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=10.1).numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=10.1).denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=10.1).magnitude    == 10.1
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=10.1).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=10.1).numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=10.1).denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=10.1).magnitude    == 10.1
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=10.1).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=10.1).numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=10.1).denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=10.1).magnitude    == 10.1
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=10.1).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=10.1).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=10.1).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=10.1).magnitude    == 10.1
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=10.1).symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=10.1).numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=10.1).denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=10.1).magnitude    == 10.1
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=10.1).symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=10.1).numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=10.1).denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=10.1).magnitude    == 10.1
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=10.1).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=10.1).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=10.1).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=10.1).magnitude    == 10.1
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=10.1).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=10.1).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=10.1).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=10.1).magnitude    == 10.1
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=10.1).symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=10.1).numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=10.1).denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=10.1).magnitude    == 10.1
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=10.1).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=10.1).numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=10.1).denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=10.1).magnitude    == 10.1
              
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],magnitude=10e1).symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude=10e1).numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude=10e1).denominators == ()
                assert Unit([("u",Decimal(1))],magnitude=10e1).magnitude    == 10e1
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],magnitude=10e1).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude=10e1).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude=10e1).denominators == ()
                assert Unit([("u",Decimal(2))],magnitude=10e1).magnitude    == 10e1
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=10e1).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=10e1).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=10e1).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=10e1).magnitude    == 10e1
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=10e1).symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=10e1).numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=10e1).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=10e1).magnitude    == 10e1
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=10e1).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=10e1).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=10e1).denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=10e1).magnitude    == 10e1
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=10e1).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=10e1).numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=10e1).denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=10e1).magnitude    == 10e1
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=10e1).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=10e1).numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=10e1).denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=10e1).magnitude    == 10e1
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=10e1).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=10e1).numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=10e1).denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=10e1).magnitude    == 10e1
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=10e1).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=10e1).numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=10e1).denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=10e1).magnitude    == 10e1
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=10e1).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=10e1).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=10e1).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=10e1).magnitude    == 10e1
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=10e1).symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=10e1).numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=10e1).denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=10e1).magnitude    == 10e1
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=10e1).symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=10e1).numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=10e1).denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=10e1).magnitude    == 10e1
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=10e1).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=10e1).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=10e1).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=10e1).magnitude    == 10e1
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=10e1).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=10e1).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=10e1).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=10e1).magnitude    == 10e1
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=10e1).symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=10e1).numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=10e1).denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=10e1).magnitude    == 10e1
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=10e1).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=10e1).numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=10e1).denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=10e1).magnitude    == 10e1
              
            # Negative Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],magnitude=-10.1).symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude=-10.1).numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude=-10.1).denominators == ()
                assert Unit([("u",Decimal(1))],magnitude=-10.1).magnitude    == -10.1
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],magnitude=-10.1).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude=-10.1).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude=-10.1).denominators == ()
                assert Unit([("u",Decimal(2))],magnitude=-10.1).magnitude    == -10.1
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=-10.1).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=-10.1).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=-10.1).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=-10.1).magnitude    == -10.1
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=-10.1).symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=-10.1).numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=-10.1).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=-10.1).magnitude    == -10.1
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=-10.1).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=-10.1).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=-10.1).denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=-10.1).magnitude    == -10.1
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=-10.1).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=-10.1).numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=-10.1).denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=-10.1).magnitude    == -10.1
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=-10.1).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=-10.1).numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=-10.1).denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=-10.1).magnitude    == -10.1
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=-10.1).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=-10.1).numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=-10.1).denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=-10.1).magnitude    == -10.1
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=-10.1).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=-10.1).numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=-10.1).denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=-10.1).magnitude    == -10.1
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=-10.1).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=-10.1).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=-10.1).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=-10.1).magnitude    == -10.1
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=-10.1).symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=-10.1).numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=-10.1).denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=-10.1).magnitude    == -10.1
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=-10.1).symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=-10.1).numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=-10.1).denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=-10.1).magnitude    == -10.1
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=-10.1).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=-10.1).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=-10.1).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=-10.1).magnitude    == -10.1
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=-10.1).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=-10.1).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=-10.1).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=-10.1).magnitude    == -10.1
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=-10.1).symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=-10.1).numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=-10.1).denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=-10.1).magnitude    == -10.1
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=-10.1).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=-10.1).numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=-10.1).denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=-10.1).magnitude    == -10.1
              
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],magnitude=-10e1).symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude=-10e1).numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude=-10e1).denominators == ()
                assert Unit([("u",Decimal(1))],magnitude=-10e1).magnitude    == -10e1
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],magnitude=-10e1).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude=-10e1).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude=-10e1).denominators == ()
                assert Unit([("u",Decimal(2))],magnitude=-10e1).magnitude    == -10e1
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=-10e1).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=-10e1).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=-10e1).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=-10e1).magnitude    == -10e1
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=-10e1).symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=-10e1).numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=-10e1).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=-10e1).magnitude    == -10e1
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=-10e1).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=-10e1).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=-10e1).denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=-10e1).magnitude    == -10e1
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=-10e1).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=-10e1).numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=-10e1).denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=-10e1).magnitude    == -10e1
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=-10e1).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=-10e1).numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=-10e1).denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=-10e1).magnitude    == -10e1
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=-10e1).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=-10e1).numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=-10e1).denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=-10e1).magnitude    == -10e1
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=-10e1).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=-10e1).numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=-10e1).denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=-10e1).magnitude    == -10e1
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=-10e1).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=-10e1).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=-10e1).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=-10e1).magnitude    == -10e1
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=-10e1).symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=-10e1).numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=-10e1).denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=-10e1).magnitude    == -10e1
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=-10e1).symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=-10e1).numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=-10e1).denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=-10e1).magnitude    == -10e1
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=-10e1).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=-10e1).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=-10e1).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=-10e1).magnitude    == -10e1
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=-10e1).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=-10e1).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=-10e1).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=-10e1).magnitude    == -10e1
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=-10e1).symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=-10e1).numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=-10e1).denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=-10e1).magnitude    == -10e1
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=-10e1).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=-10e1).numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=-10e1).denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=-10e1).magnitude    == -10e1
        # Implicit Symbols, Magnitude str
        if(True):
          # Tuple of Strings
          if(True):
            # Positive Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],magnitude="10.1").symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude="10.1").numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude="10.1").denominators == ()
                assert Unit(["u"],magnitude="10.1").magnitude    == Decimal("10.1")
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],magnitude="10.1").symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude="10.1").numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude="10.1").denominators == ()
                assert Unit(["u","u"],magnitude="10.1").magnitude    == Decimal("10.1")
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],magnitude="10.1").symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude="10.1").numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude="10.1").denominators == ()
                assert Unit(["ua","ub","ub"],magnitude="10.1").magnitude    == Decimal("10.1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],magnitude="10.1").symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],magnitude="10.1").numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude="10.1").denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude="10.1").magnitude    == Decimal("10.1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],magnitude="10.1").symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],magnitude="10.1").numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude="10.1").denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude="10.1").magnitude    == Decimal("10.1")
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude="10.1").symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude="10.1").numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude="10.1").denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude="10.1").magnitude    == Decimal("10.1")
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],magnitude="10.1").symbols      == ()
                assert Unit(["u"],["u"],magnitude="10.1").numerators   == ()
                assert Unit(["u"],["u"],magnitude="10.1").denominators == ()
                assert Unit(["u"],["u"],magnitude="10.1").magnitude    == Decimal("10.1")
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],magnitude="10.1").symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude="10.1").numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude="10.1").denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude="10.1").magnitude    == Decimal("10.1")
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude="10.1").symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude="10.1").numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude="10.1").denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude="10.1").magnitude    == Decimal("10.1")
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude="10.1").symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude="10.1").numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude="10.1").denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude="10.1").magnitude    == Decimal("10.1")
              
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],magnitude="10e1").symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude="10e1").numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude="10e1").denominators == ()
                assert Unit(["u"],magnitude="10e1").magnitude    == Decimal("10e1")
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],magnitude="10e1").symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude="10e1").numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude="10e1").denominators == ()
                assert Unit(["u","u"],magnitude="10e1").magnitude    == Decimal("10e1")
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],magnitude="10e1").symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude="10e1").numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude="10e1").denominators == ()
                assert Unit(["ua","ub","ub"],magnitude="10e1").magnitude    == Decimal("10e1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],magnitude="10e1").symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],magnitude="10e1").numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude="10e1").denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude="10e1").magnitude    == Decimal("10e1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],magnitude="10e1").symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],magnitude="10e1").numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude="10e1").denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude="10e1").magnitude    == Decimal("10e1")
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude="10e1").symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude="10e1").numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude="10e1").denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude="10e1").magnitude    == Decimal("10e1")
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],magnitude="10e1").symbols      == ()
                assert Unit(["u"],["u"],magnitude="10e1").numerators   == ()
                assert Unit(["u"],["u"],magnitude="10e1").denominators == ()
                assert Unit(["u"],["u"],magnitude="10e1").magnitude    == Decimal("10e1")
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],magnitude="10e1").symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude="10e1").numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude="10e1").denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude="10e1").magnitude    == Decimal("10e1")
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude="10e1").symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude="10e1").numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude="10e1").denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude="10e1").magnitude    == Decimal("10e1")
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude="10e1").symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude="10e1").numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude="10e1").denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude="10e1").magnitude    == Decimal("10e1")
            # Negative Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],magnitude="-10.1").symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude="-10.1").numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude="-10.1").denominators == ()
                assert Unit(["u"],magnitude="-10.1").magnitude    == Decimal("-10.1")
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],magnitude="-10.1").symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude="-10.1").numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude="-10.1").denominators == ()
                assert Unit(["u","u"],magnitude="-10.1").magnitude    == Decimal("-10.1")
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],magnitude="-10.1").symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude="-10.1").numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude="-10.1").denominators == ()
                assert Unit(["ua","ub","ub"],magnitude="-10.1").magnitude    == Decimal("-10.1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],magnitude="-10.1").symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],magnitude="-10.1").numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude="-10.1").denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude="-10.1").magnitude    == Decimal("-10.1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],magnitude="-10.1").symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],magnitude="-10.1").numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude="-10.1").denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude="-10.1").magnitude    == Decimal("-10.1")
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude="-10.1").symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude="-10.1").numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude="-10.1").denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude="-10.1").magnitude    == Decimal("-10.1")
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],magnitude="-10.1").symbols      == ()
                assert Unit(["u"],["u"],magnitude="-10.1").numerators   == ()
                assert Unit(["u"],["u"],magnitude="-10.1").denominators == ()
                assert Unit(["u"],["u"],magnitude="-10.1").magnitude    == Decimal("-10.1")
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],magnitude="-10.1").symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude="-10.1").numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude="-10.1").denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude="-10.1").magnitude    == Decimal("-10.1")
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude="-10.1").symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude="-10.1").numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude="-10.1").denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude="-10.1").magnitude    == Decimal("-10.1")
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude="-10.1").symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude="-10.1").numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude="-10.1").denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude="-10.1").magnitude    == Decimal("-10.1")
              
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],magnitude="-10e1").symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude="-10e1").numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude="-10e1").denominators == ()
                assert Unit(["u"],magnitude="-10e1").magnitude    == Decimal("-10e1")
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],magnitude="-10e1").symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude="-10e1").numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude="-10e1").denominators == ()
                assert Unit(["u","u"],magnitude="-10e1").magnitude    == Decimal("-10e1")
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],magnitude="-10e1").symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude="-10e1").numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude="-10e1").denominators == ()
                assert Unit(["ua","ub","ub"],magnitude="-10e1").magnitude    == Decimal("-10e1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],magnitude="-10e1").symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],magnitude="-10e1").numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude="-10e1").denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude="-10e1").magnitude    == Decimal("-10e1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],magnitude="-10e1").symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],magnitude="-10e1").numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude="-10e1").denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude="-10e1").magnitude    == Decimal("-10e1")
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude="-10e1").symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude="-10e1").numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude="-10e1").denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude="-10e1").magnitude    == Decimal("-10e1")
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],magnitude="-10e1").symbols      == ()
                assert Unit(["u"],["u"],magnitude="-10e1").numerators   == ()
                assert Unit(["u"],["u"],magnitude="-10e1").denominators == ()
                assert Unit(["u"],["u"],magnitude="-10e1").magnitude    == Decimal("-10e1")
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],magnitude="-10e1").symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude="-10e1").numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude="-10e1").denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude="-10e1").magnitude    == Decimal("-10e1")
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude="-10e1").symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude="-10e1").numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude="-10e1").denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude="-10e1").magnitude    == Decimal("-10e1")
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude="-10e1").symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude="-10e1").numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude="-10e1").denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude="-10e1").magnitude    == Decimal("-10e1")
          # Tuple of String, Exponent
          if(True):
            # Positive Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],magnitude="10.1").symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude="10.1").numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude="10.1").denominators == ()
                assert Unit([("u",Decimal(1))],magnitude="10.1").magnitude    == Decimal("10.1")
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],magnitude="10.1").symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude="10.1").numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude="10.1").denominators == ()
                assert Unit([("u",Decimal(2))],magnitude="10.1").magnitude    == Decimal("10.1")
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude="10.1").symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude="10.1").numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude="10.1").denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude="10.1").magnitude    == Decimal("10.1")
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude="10.1").symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude="10.1").numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude="10.1").denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude="10.1").magnitude    == Decimal("10.1")
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude="10.1").symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude="10.1").numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude="10.1").denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude="10.1").magnitude    == Decimal("10.1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude="10.1").symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude="10.1").numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude="10.1").denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude="10.1").magnitude    == Decimal("10.1")
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude="10.1").symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude="10.1").numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude="10.1").denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude="10.1").magnitude    == Decimal("10.1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude="10.1").symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude="10.1").numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude="10.1").denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude="10.1").magnitude    == Decimal("10.1")
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude="10.1").symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude="10.1").numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude="10.1").denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude="10.1").magnitude    == Decimal("10.1")
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude="10.1").symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude="10.1").numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude="10.1").denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude="10.1").magnitude    == Decimal("10.1")
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude="10.1").symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude="10.1").numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude="10.1").denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude="10.1").magnitude    == Decimal("10.1")
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude="10.1").symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude="10.1").numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude="10.1").denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude="10.1").magnitude    == Decimal("10.1")
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="10.1").symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="10.1").numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="10.1").denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="10.1").magnitude    == Decimal("10.1")
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="10.1").symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="10.1").numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="10.1").denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="10.1").magnitude    == Decimal("10.1")
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude="10.1").symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude="10.1").numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude="10.1").denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude="10.1").magnitude    == Decimal("10.1")
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude="10.1").symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude="10.1").numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude="10.1").denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude="10.1").magnitude    == Decimal("10.1")
              
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],magnitude="10e1").symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude="10e1").numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude="10e1").denominators == ()
                assert Unit([("u",Decimal(1))],magnitude="10e1").magnitude    == Decimal("10e1")
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],magnitude="10e1").symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude="10e1").numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude="10e1").denominators == ()
                assert Unit([("u",Decimal(2))],magnitude="10e1").magnitude    == Decimal("10e1")
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude="10e1").symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude="10e1").numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude="10e1").denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude="10e1").magnitude    == Decimal("10e1")
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude="10e1").symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude="10e1").numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude="10e1").denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude="10e1").magnitude    == Decimal("10e1")
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude="10e1").symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude="10e1").numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude="10e1").denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude="10e1").magnitude    == Decimal("10e1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude="10e1").symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude="10e1").numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude="10e1").denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude="10e1").magnitude    == Decimal("10e1")
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude="10e1").symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude="10e1").numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude="10e1").denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude="10e1").magnitude    == Decimal("10e1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude="10e1").symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude="10e1").numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude="10e1").denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude="10e1").magnitude    == Decimal("10e1")
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude="10e1").symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude="10e1").numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude="10e1").denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude="10e1").magnitude    == Decimal("10e1")
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude="10e1").symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude="10e1").numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude="10e1").denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude="10e1").magnitude    == Decimal("10e1")
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude="10e1").symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude="10e1").numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude="10e1").denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude="10e1").magnitude    == Decimal("10e1")
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude="10e1").symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude="10e1").numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude="10e1").denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude="10e1").magnitude    == Decimal("10e1")
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="10e1").symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="10e1").numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="10e1").denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="10e1").magnitude    == Decimal("10e1")
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="10e1").symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="10e1").numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="10e1").denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="10e1").magnitude    == Decimal("10e1")
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude="10e1").symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude="10e1").numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude="10e1").denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude="10e1").magnitude    == Decimal("10e1")
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude="10e1").symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude="10e1").numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude="10e1").denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude="10e1").magnitude    == Decimal("10e1")
              
            # Negative Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],magnitude="-10.1").symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude="-10.1").numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude="-10.1").denominators == ()
                assert Unit([("u",Decimal(1))],magnitude="-10.1").magnitude    == Decimal("-10.1")
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],magnitude="-10.1").symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude="-10.1").numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude="-10.1").denominators == ()
                assert Unit([("u",Decimal(2))],magnitude="-10.1").magnitude    == Decimal("-10.1")
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude="-10.1").symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude="-10.1").numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude="-10.1").denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude="-10.1").magnitude    == Decimal("-10.1")
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude="-10.1").symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude="-10.1").numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude="-10.1").denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude="-10.1").magnitude    == Decimal("-10.1")
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude="-10.1").symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude="-10.1").numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude="-10.1").denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude="-10.1").magnitude    == Decimal("-10.1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude="-10.1").symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude="-10.1").numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude="-10.1").denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude="-10.1").magnitude    == Decimal("-10.1")
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude="-10.1").symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude="-10.1").numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude="-10.1").denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude="-10.1").magnitude    == Decimal("-10.1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude="-10.1").symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude="-10.1").numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude="-10.1").denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude="-10.1").magnitude    == Decimal("-10.1")
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude="-10.1").symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude="-10.1").numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude="-10.1").denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude="-10.1").magnitude    == Decimal("-10.1")
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude="-10.1").symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude="-10.1").numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude="-10.1").denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude="-10.1").magnitude    == Decimal("-10.1")
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude="-10.1").symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude="-10.1").numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude="-10.1").denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude="-10.1").magnitude    == Decimal("-10.1")
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude="-10.1").symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude="-10.1").numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude="-10.1").denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude="-10.1").magnitude    == Decimal("-10.1")
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="-10.1").symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="-10.1").numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="-10.1").denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="-10.1").magnitude    == Decimal("-10.1")
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="-10.1").symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="-10.1").numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="-10.1").denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="-10.1").magnitude    == Decimal("-10.1")
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude="-10.1").symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude="-10.1").numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude="-10.1").denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude="-10.1").magnitude    == Decimal("-10.1")
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude="-10.1").symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude="-10.1").numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude="-10.1").denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude="-10.1").magnitude    == Decimal("-10.1")
              
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],magnitude="-10e1").symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude="-10e1").numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude="-10e1").denominators == ()
                assert Unit([("u",Decimal(1))],magnitude="-10e1").magnitude    == Decimal("-10e1")
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],magnitude="-10e1").symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude="-10e1").numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude="-10e1").denominators == ()
                assert Unit([("u",Decimal(2))],magnitude="-10e1").magnitude    == Decimal("-10e1")
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude="-10e1").symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude="-10e1").numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude="-10e1").denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude="-10e1").magnitude    == Decimal("-10e1")
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude="-10e1").symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude="-10e1").numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude="-10e1").denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude="-10e1").magnitude    == Decimal("-10e1")
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude="-10e1").symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude="-10e1").numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude="-10e1").denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude="-10e1").magnitude    == Decimal("-10e1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude="-10e1").symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude="-10e1").numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude="-10e1").denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude="-10e1").magnitude    == Decimal("-10e1")
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude="-10e1").symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude="-10e1").numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude="-10e1").denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude="-10e1").magnitude    == Decimal("-10e1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude="-10e1").symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude="-10e1").numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude="-10e1").denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude="-10e1").magnitude    == Decimal("-10e1")
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude="-10e1").symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude="-10e1").numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude="-10e1").denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude="-10e1").magnitude    == Decimal("-10e1")
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude="-10e1").symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude="-10e1").numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude="-10e1").denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude="-10e1").magnitude    == Decimal("-10e1")
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude="-10e1").symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude="-10e1").numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude="-10e1").denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude="-10e1").magnitude    == Decimal("-10e1")
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude="-10e1").symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude="-10e1").numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude="-10e1").denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude="-10e1").magnitude    == Decimal("-10e1")
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="-10e1").symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="-10e1").numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="-10e1").denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="-10e1").magnitude    == Decimal("-10e1")
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="-10e1").symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="-10e1").numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="-10e1").denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude="-10e1").magnitude    == Decimal("-10e1")
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude="-10e1").symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude="-10e1").numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude="-10e1").denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude="-10e1").magnitude    == Decimal("-10e1")
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude="-10e1").symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude="-10e1").numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude="-10e1").denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude="-10e1").magnitude    == Decimal("-10e1")
        # Implicit Symbols, Magnitude Decimal
        if(True):
          # Tuple of Strings
          if(True):
            # Positive Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],magnitude=Decimal("10.1")).symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude=Decimal("10.1")).numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude=Decimal("10.1")).denominators == ()
                assert Unit(["u"],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],magnitude=Decimal("10.1")).symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude=Decimal("10.1")).numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude=Decimal("10.1")).denominators == ()
                assert Unit(["u","u"],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],magnitude=Decimal("10.1")).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude=Decimal("10.1")).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude=Decimal("10.1")).denominators == ()
                assert Unit(["ua","ub","ub"],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],magnitude=Decimal("10.1")).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],magnitude=Decimal("10.1")).numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude=Decimal("10.1")).denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=Decimal("10.1")).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=Decimal("10.1")).numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=Decimal("10.1")).denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=Decimal("10.1")).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=Decimal("10.1")).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=Decimal("10.1")).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],magnitude=Decimal("10.1")).symbols      == ()
                assert Unit(["u"],["u"],magnitude=Decimal("10.1")).numerators   == ()
                assert Unit(["u"],["u"],magnitude=Decimal("10.1")).denominators == ()
                assert Unit(["u"],["u"],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],magnitude=Decimal("10.1")).symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=Decimal("10.1")).numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=Decimal("10.1")).denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=Decimal("10.1")).symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=Decimal("10.1")).numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=Decimal("10.1")).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=Decimal("10.1")).symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=Decimal("10.1")).numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=Decimal("10.1")).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
              
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],magnitude=Decimal("10e1")).symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude=Decimal("10e1")).numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude=Decimal("10e1")).denominators == ()
                assert Unit(["u"],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],magnitude=Decimal("10e1")).symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude=Decimal("10e1")).numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude=Decimal("10e1")).denominators == ()
                assert Unit(["u","u"],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],magnitude=Decimal("10e1")).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude=Decimal("10e1")).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude=Decimal("10e1")).denominators == ()
                assert Unit(["ua","ub","ub"],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],magnitude=Decimal("10e1")).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],magnitude=Decimal("10e1")).numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude=Decimal("10e1")).denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=Decimal("10e1")).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=Decimal("10e1")).numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=Decimal("10e1")).denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=Decimal("10e1")).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=Decimal("10e1")).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=Decimal("10e1")).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],magnitude=Decimal("10e1")).symbols      == ()
                assert Unit(["u"],["u"],magnitude=Decimal("10e1")).numerators   == ()
                assert Unit(["u"],["u"],magnitude=Decimal("10e1")).denominators == ()
                assert Unit(["u"],["u"],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],magnitude=Decimal("10e1")).symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=Decimal("10e1")).numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=Decimal("10e1")).denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=Decimal("10e1")).symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=Decimal("10e1")).numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=Decimal("10e1")).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=Decimal("10e1")).symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=Decimal("10e1")).numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=Decimal("10e1")).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
            # Negative Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],magnitude=Decimal("-10.1")).symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude=Decimal("-10.1")).numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude=Decimal("-10.1")).denominators == ()
                assert Unit(["u"],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],magnitude=Decimal("-10.1")).symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude=Decimal("-10.1")).numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude=Decimal("-10.1")).denominators == ()
                assert Unit(["u","u"],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],magnitude=Decimal("-10.1")).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude=Decimal("-10.1")).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude=Decimal("-10.1")).denominators == ()
                assert Unit(["ua","ub","ub"],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],magnitude=Decimal("-10.1")).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],magnitude=Decimal("-10.1")).numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude=Decimal("-10.1")).denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=Decimal("-10.1")).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=Decimal("-10.1")).numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=Decimal("-10.1")).denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=Decimal("-10.1")).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=Decimal("-10.1")).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=Decimal("-10.1")).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],magnitude=Decimal("-10.1")).symbols      == ()
                assert Unit(["u"],["u"],magnitude=Decimal("-10.1")).numerators   == ()
                assert Unit(["u"],["u"],magnitude=Decimal("-10.1")).denominators == ()
                assert Unit(["u"],["u"],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],magnitude=Decimal("-10.1")).symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=Decimal("-10.1")).numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=Decimal("-10.1")).denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=Decimal("-10.1")).symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=Decimal("-10.1")).numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=Decimal("-10.1")).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=Decimal("-10.1")).symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=Decimal("-10.1")).numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=Decimal("-10.1")).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
              
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit(["u"],magnitude=Decimal("-10e1")).symbols      == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude=Decimal("-10e1")).numerators   == (("u",Decimal(1)),)
                assert Unit(["u"],magnitude=Decimal("-10e1")).denominators == ()
                assert Unit(["u"],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Duplicate Numerators
                assert Unit(["u","u"],magnitude=Decimal("-10e1")).symbols      == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude=Decimal("-10e1")).numerators   == (("u",Decimal(2)),)
                assert Unit(["u","u"],magnitude=Decimal("-10e1")).denominators == ()
                assert Unit(["u","u"],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Different Numerators
                assert Unit(["ua","ub","ub"],magnitude=Decimal("-10e1")).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude=Decimal("-10e1")).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit(["ua","ub","ub"],magnitude=Decimal("-10e1")).denominators == ()
                assert Unit(["ua","ub","ub"],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit(["nu"],["du"],magnitude=Decimal("-10e1")).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit(["nu"],["du"],magnitude=Decimal("-10e1")).numerators   == (("nu",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude=Decimal("-10e1")).denominators == (("du",Decimal(1)),)
                assert Unit(["nu"],["du"],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=Decimal("-10e1")).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=Decimal("-10e1")).numerators   == (("nu",Decimal(3)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=Decimal("-10e1")).denominators == (("du",Decimal(2)),)
                assert Unit(["nu","nu","nu"],["du","du"],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Different Numerators and Denominators
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=Decimal("-10e1")).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=Decimal("-10e1")).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=Decimal("-10e1")).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
                assert Unit(["nua","nub","nub"],["dua","dub","dub","dub"],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
              # Canceling
              if(True):
                # Single
                assert Unit(["u"],["u"],magnitude=Decimal("-10e1")).symbols      == ()
                assert Unit(["u"],["u"],magnitude=Decimal("-10e1")).numerators   == ()
                assert Unit(["u"],["u"],magnitude=Decimal("-10e1")).denominators == ()
                assert Unit(["u"],["u"],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Duplicate
                assert Unit(["u","u","u"],["u","u","u"],magnitude=Decimal("-10e1")).symbols      == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=Decimal("-10e1")).numerators   == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=Decimal("-10e1")).denominators == ()
                assert Unit(["u","u","u"],["u","u","u"],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Different
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=Decimal("-10e1")).symbols      == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=Decimal("-10e1")).numerators   == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=Decimal("-10e1")).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub","ub"],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Partial Canceling
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=Decimal("-10e1")).symbols      == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=Decimal("-10e1")).numerators   == (("ub",Decimal(1)),)
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=Decimal("-10e1")).denominators == ()
                assert Unit(["ua","ub","ub"],["ua","ub"],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
          # Tuple of String, Exponent
          if(True):
            # Positive Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],magnitude=Decimal("10.1")).symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude=Decimal("10.1")).numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude=Decimal("10.1")).denominators == ()
                assert Unit([("u",Decimal(1))],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],magnitude=Decimal("10.1")).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude=Decimal("10.1")).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude=Decimal("10.1")).denominators == ()
                assert Unit([("u",Decimal(2))],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=Decimal("10.1")).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=Decimal("10.1")).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=Decimal("10.1")).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=Decimal("10.1")).symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=Decimal("10.1")).numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=Decimal("10.1")).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=Decimal("10.1")).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=Decimal("10.1")).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=Decimal("10.1")).denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=Decimal("10.1")).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=Decimal("10.1")).numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=Decimal("10.1")).denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=Decimal("10.1")).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=Decimal("10.1")).numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=Decimal("10.1")).denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=Decimal("10.1")).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=Decimal("10.1")).numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=Decimal("10.1")).denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=Decimal("10.1")).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=Decimal("10.1")).numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=Decimal("10.1")).denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=Decimal("10.1")).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=Decimal("10.1")).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=Decimal("10.1")).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=Decimal("10.1")).symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=Decimal("10.1")).numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=Decimal("10.1")).denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=Decimal("10.1")).symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=Decimal("10.1")).numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=Decimal("10.1")).denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("10.1")).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("10.1")).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("10.1")).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("10.1")).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("10.1")).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("10.1")).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("10.1")).symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("10.1")).numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("10.1")).denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("10.1")).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("10.1")).numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("10.1")).denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
              
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],magnitude=Decimal("10e1")).symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude=Decimal("10e1")).numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude=Decimal("10e1")).denominators == ()
                assert Unit([("u",Decimal(1))],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],magnitude=Decimal("10e1")).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude=Decimal("10e1")).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude=Decimal("10e1")).denominators == ()
                assert Unit([("u",Decimal(2))],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=Decimal("10e1")).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=Decimal("10e1")).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=Decimal("10e1")).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=Decimal("10e1")).symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=Decimal("10e1")).numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=Decimal("10e1")).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=Decimal("10e1")).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=Decimal("10e1")).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=Decimal("10e1")).denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=Decimal("10e1")).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=Decimal("10e1")).numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=Decimal("10e1")).denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=Decimal("10e1")).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=Decimal("10e1")).numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=Decimal("10e1")).denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=Decimal("10e1")).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=Decimal("10e1")).numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=Decimal("10e1")).denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=Decimal("10e1")).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=Decimal("10e1")).numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=Decimal("10e1")).denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=Decimal("10e1")).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=Decimal("10e1")).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=Decimal("10e1")).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=Decimal("10e1")).symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=Decimal("10e1")).numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=Decimal("10e1")).denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=Decimal("10e1")).symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=Decimal("10e1")).numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=Decimal("10e1")).denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("10e1")).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("10e1")).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("10e1")).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("10e1")).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("10e1")).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("10e1")).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("10e1")).symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("10e1")).numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("10e1")).denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("10e1")).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("10e1")).numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("10e1")).denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
              
            # Negative Magnitude
            if(True):
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],magnitude=Decimal("-10.1")).symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude=Decimal("-10.1")).numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude=Decimal("-10.1")).denominators == ()
                assert Unit([("u",Decimal(1))],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],magnitude=Decimal("-10.1")).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude=Decimal("-10.1")).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude=Decimal("-10.1")).denominators == ()
                assert Unit([("u",Decimal(2))],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=Decimal("-10.1")).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=Decimal("-10.1")).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=Decimal("-10.1")).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=Decimal("-10.1")).symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=Decimal("-10.1")).numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=Decimal("-10.1")).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=Decimal("-10.1")).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=Decimal("-10.1")).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=Decimal("-10.1")).denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=Decimal("-10.1")).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=Decimal("-10.1")).numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=Decimal("-10.1")).denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=Decimal("-10.1")).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=Decimal("-10.1")).numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=Decimal("-10.1")).denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=Decimal("-10.1")).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=Decimal("-10.1")).numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=Decimal("-10.1")).denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=Decimal("-10.1")).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=Decimal("-10.1")).numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=Decimal("-10.1")).denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=Decimal("-10.1")).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=Decimal("-10.1")).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=Decimal("-10.1")).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=Decimal("-10.1")).symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=Decimal("-10.1")).numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=Decimal("-10.1")).denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=Decimal("-10.1")).symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=Decimal("-10.1")).numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=Decimal("-10.1")).denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("-10.1")).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("-10.1")).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("-10.1")).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("-10.1")).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("-10.1")).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("-10.1")).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("-10.1")).symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("-10.1")).numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("-10.1")).denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("-10.1")).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("-10.1")).numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("-10.1")).denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
              
              # Numerators Only
              if(True):
                # Single Numerator
                assert Unit([("u",Decimal(1))],magnitude=Decimal("-10e1")).symbols      == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude=Decimal("-10e1")).numerators   == (("u",Decimal(1)),)
                assert Unit([("u",Decimal(1))],magnitude=Decimal("-10e1")).denominators == ()
                assert Unit([("u",Decimal(1))],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Single Numerator Higher Exponent
                assert Unit([("u",Decimal(2))],magnitude=Decimal("-10e1")).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude=Decimal("-10e1")).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(2))],magnitude=Decimal("-10e1")).denominators == ()
                assert Unit([("u",Decimal(2))],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Duplicate Numerators
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=Decimal("-10e1")).symbols      == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=Decimal("-10e1")).numerators   == (("u",Decimal(2)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=Decimal("-10e1")).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(1))],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Duplicate Numerators Higher Exponent
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=Decimal("-10e1")).symbols      == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=Decimal("-10e1")).numerators   == (("u",Decimal(3)),)
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=Decimal("-10e1")).denominators == ()
                assert Unit([("u",Decimal(1)),("u",Decimal(2))],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Different Numerators
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=Decimal("-10e1")).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=Decimal("-10e1")).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=Decimal("-10e1")).denominators == ()
                assert Unit([("ua",Decimal(1)),("ub",Decimal(2))],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
              # Numerators and Denominators
              if(True):
                # Single Numerator and Denominator
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=Decimal("-10e1")).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=Decimal("-10e1")).numerators   == (("nu",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=Decimal("-10e1")).denominators == (("du",Decimal(1)),)
                assert Unit([("nu",Decimal(1))],[("du",Decimal(1))],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Single Numerator and Denominator Higher Exponent
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=Decimal("-10e1")).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=Decimal("-10e1")).numerators   == (("nu",Decimal(2)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=Decimal("-10e1")).denominators == (("du",Decimal(3)),)
                assert Unit([("nu",Decimal(2))],[("du",Decimal(3))],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Duplicate Numerators and Denominators
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=Decimal("-10e1")).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=Decimal("-10e1")).numerators   == (("nu",Decimal(3)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=Decimal("-10e1")).denominators == (("du",Decimal(2)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("du",Decimal(1)),("du",Decimal(1))],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Duplicate Numerators and Denominators Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=Decimal("-10e1")).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=Decimal("-10e1")).numerators   == (("nu",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=Decimal("-10e1")).denominators == (("du",Decimal(4)),)
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("du",Decimal(3)),("du",Decimal(1))],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Different Numerators and Denominators
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=Decimal("-10e1")).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=Decimal("-10e1")).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=Decimal("-10e1")).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("dua",Decimal(3)),("dub",Decimal(1))],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
              # Canceling
              if(True):
                # Single
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=Decimal("-10e1")).symbols      == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=Decimal("-10e1")).numerators   == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=Decimal("-10e1")).denominators == ()
                assert Unit([("nu",Decimal(1))],[("nu",Decimal(1))],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Single Higher Exponent
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=Decimal("-10e1")).symbols      == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=Decimal("-10e1")).numerators   == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=Decimal("-10e1")).denominators == ()
                assert Unit([("nu",Decimal(2))],[("nu",Decimal(2))],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Duplicate
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("-10e1")).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("-10e1")).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("-10e1")).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Duplicate Higher Exponent
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("-10e1")).symbols      == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("-10e1")).numerators   == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("-10e1")).denominators == ()
                assert Unit([("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Multiple Different
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("-10e1")).symbols      == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("-10e1")).numerators   == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("-10e1")).denominators == ()
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
                # Partial
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("-10e1")).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("-10e1")).numerators   == (("nua",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("-10e1")).denominators == (("nub",Decimal(1)),)
                assert Unit([("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))],magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
      # No Symbols
      if(True):
        
        # Magnitude Int
        if(True):
          # Positive Magnitude
          if(True):
            assert Unit(magnitude=10).symbols      == ()
            assert Unit(magnitude=10).numerators   == ()
            assert Unit(magnitude=10).denominators == ()
            assert Unit(magnitude=10).magnitude    == Decimal(10)
          # Negative Magnitude
          if(True):
            assert Unit(magnitude=-10).symbols      == ()
            assert Unit(magnitude=-10).numerators   == ()
            assert Unit(magnitude=-10).denominators == ()
            assert Unit(magnitude=-10).magnitude    == Decimal(-10)
          
        # Magnitude float
        if(True):
          # Positive Magnitude
          if(True):
            # Standard Notation
            assert Unit(magnitude=10.1).symbols      == ()
            assert Unit(magnitude=10.1).numerators   == ()
            assert Unit(magnitude=10.1).denominators == ()
            assert Unit(magnitude=10.1).magnitude    == 10.1
            # Exponent Notation
            assert Unit(magnitude=10e1).symbols      == ()
            assert Unit(magnitude=10e1).numerators   == ()
            assert Unit(magnitude=10e1).denominators == ()
            assert Unit(magnitude=10e1).magnitude    == 100
          # Negative Magnitude
          if(True):
            # Standard Notation
            assert Unit(magnitude=-10.1).symbols      == ()
            assert Unit(magnitude=-10.1).numerators   == ()
            assert Unit(magnitude=-10.1).denominators == ()
            assert Unit(magnitude=-10.1).magnitude    == -10.1
            # Exponent Notation
            assert Unit(magnitude=-10e1).symbols      == ()
            assert Unit(magnitude=-10e1).numerators   == ()
            assert Unit(magnitude=-10e1).denominators == ()
            assert Unit(magnitude=-10e1).magnitude    == -100
          
        # Magnitude str
        if(True):
          # Positive Magnitude
          if(True):
            # Standard Notation
            assert Unit(magnitude="10.1").symbols      == ()
            assert Unit(magnitude="10.1").numerators   == ()
            assert Unit(magnitude="10.1").denominators == ()
            assert Unit(magnitude="10.1").magnitude    == Decimal("10.1")
            # Exponent Notation
            assert Unit(magnitude="10e1").symbols      == ()
            assert Unit(magnitude="10e1").numerators   == ()
            assert Unit(magnitude="10e1").denominators == ()
            assert Unit(magnitude="10e1").magnitude    == Decimal("10e1")
          # Negative Magnitude
          if(True):
            # Standard Notation
            assert Unit(magnitude="-10.1").symbols      == ()
            assert Unit(magnitude="-10.1").numerators   == ()
            assert Unit(magnitude="-10.1").denominators == ()
            assert Unit(magnitude="-10.1").magnitude    == Decimal("-10.1")
            # Exponent Notation
            assert Unit(magnitude="-10e1").symbols      == ()
            assert Unit(magnitude="-10e1").numerators   == ()
            assert Unit(magnitude="-10e1").denominators == ()
            assert Unit(magnitude="-10e1").magnitude    == Decimal("-10e1")
          
        # Magnitude Decimal
        if(True):
          # Positive Magnitude
          if(True):
            # Standard Notation
            assert Unit(magnitude=Decimal("10.1")).symbols      == ()
            assert Unit(magnitude=Decimal("10.1")).numerators   == ()
            assert Unit(magnitude=Decimal("10.1")).denominators == ()
            assert Unit(magnitude=Decimal("10.1")).magnitude    == Decimal("10.1")
            # Exponent Notation
            assert Unit(magnitude=Decimal("10e1")).symbols      == ()
            assert Unit(magnitude=Decimal("10e1")).numerators   == ()
            assert Unit(magnitude=Decimal("10e1")).denominators == ()
            assert Unit(magnitude=Decimal("10e1")).magnitude    == Decimal("10e1")
          # Negative Magnitude
          if(True):
            # Standard Notation
            assert Unit(magnitude=Decimal("-10.1")).symbols      == ()
            assert Unit(magnitude=Decimal("-10.1")).numerators   == ()
            assert Unit(magnitude=Decimal("-10.1")).denominators == ()
            assert Unit(magnitude=Decimal("-10.1")).magnitude    == Decimal("-10.1")
            # Exponent Notation
            assert Unit(magnitude=Decimal("-10e1")).symbols      == ()
            assert Unit(magnitude=Decimal("-10e1")).numerators   == ()
            assert Unit(magnitude=Decimal("-10e1")).denominators == ()
            assert Unit(magnitude=Decimal("-10e1")).magnitude    == Decimal("-10e1")
    # Explicit Symbols, Implicit Magnitude
    if(True):
      # Explicit Symbols, No Magnitude
      if(True):
        # Tuple of Strings
        if(True):
          # Symbols
          if(True):
            # Single Numerator
            assert Unit(symbols=["u"]).symbols      == (("u",Decimal(1)),)
            assert Unit(symbols=["u"]).numerators   == (("u",Decimal(1)),)
            assert Unit(symbols=["u"]).denominators == ()
            assert Unit(symbols=["u"]).magnitude    == Decimal(1)
            # Multiple Duplicate Numerators
            assert Unit(symbols=["u","u"]).symbols      == (("u",Decimal(2)),)
            assert Unit(symbols=["u","u"]).numerators   == (("u",Decimal(2)),)
            assert Unit(symbols=["u","u"]).denominators == ()
            assert Unit(symbols=["u","u"]).magnitude    == Decimal(1)
            # Multiple Different Numerators
            assert Unit(symbols=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
            assert Unit(symbols=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
            assert Unit(symbols=["ua","ub","ub"]).denominators == ()
            assert Unit(symbols=["ua","ub","ub"]).magnitude    == Decimal(1)
          # Numerators
          if(True):
            # Single Numerator
            assert Unit(numerators=["u"]).symbols      == (("u",Decimal(1)),)
            assert Unit(numerators=["u"]).numerators   == (("u",Decimal(1)),)
            assert Unit(numerators=["u"]).denominators == ()
            assert Unit(numerators=["u"]).magnitude    == Decimal(1)
            # Multiple Duplicate Numerators
            assert Unit(numerators=["u","u"]).symbols      == (("u",Decimal(2)),)
            assert Unit(numerators=["u","u"]).numerators   == (("u",Decimal(2)),)
            assert Unit(numerators=["u","u"]).denominators == ()
            assert Unit(numerators=["u","u"]).magnitude    == Decimal(1)
            # Multiple Different Numerators
            assert Unit(numerators=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
            assert Unit(numerators=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
            assert Unit(numerators=["ua","ub","ub"]).denominators == ()
            assert Unit(numerators=["ua","ub","ub"]).magnitude    == Decimal(1)
          # Denominators
          if(True):
            # Single Numerator
            assert Unit(denominators=["u"]).symbols      == (("u",Decimal(-1)),)
            assert Unit(denominators=["u"]).numerators   == ()
            assert Unit(denominators=["u"]).denominators == (("u",Decimal(1)),)
            assert Unit(denominators=["u"]).magnitude    == Decimal(1)
            # Multiple Duplicate Numerators
            assert Unit(denominators=["u","u"]).symbols      == (("u",Decimal(-2)),)
            assert Unit(denominators=["u","u"]).numerators   == ()
            assert Unit(denominators=["u","u"]).denominators == (("u",Decimal(2)),)
            assert Unit(denominators=["u","u"]).magnitude    == Decimal(1)
            # Multiple Different Numerators
            assert Unit(denominators=["ua","ub","ub"]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
            assert Unit(denominators=["ua","ub","ub"]).numerators   == ()
            assert Unit(denominators=["ua","ub","ub"]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
            assert Unit(denominators=["ua","ub","ub"]).magnitude    == Decimal(1)
          # Numerators and Denominators
          if(True):
            # Single Numerator and Denominator
            assert Unit(numerators=["nu"],denominators=["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
            assert Unit(numerators=["nu"],denominators=["du"]).numerators   == (("nu",Decimal(1)),)
            assert Unit(numerators=["nu"],denominators=["du"]).denominators == (("du",Decimal(1)),)
            assert Unit(numerators=["nu"],denominators=["du"]).magnitude    == Decimal(1)
            # Multiple Duplicate Numerators and Denominators
            assert Unit(numerators=["nu","nu","nu"],denominators=["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
            assert Unit(numerators=["nu","nu","nu"],denominators=["du","du"]).numerators   == (("nu",Decimal(3)),)
            assert Unit(numerators=["nu","nu","nu"],denominators=["du","du"]).denominators == (("du",Decimal(2)),)
            assert Unit(numerators=["nu","nu","nu"],denominators=["du","du"]).magnitude    == Decimal(1)
            # Multiple Different Numerators and Denominators
            assert Unit(numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
            assert Unit(numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
            assert Unit(numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
            assert Unit(numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).magnitude    == Decimal(1)
          # Canceling
          if(True):
            # Single
            assert Unit(numerators=["u"],denominators=["u"]).symbols      == ()
            assert Unit(numerators=["u"],denominators=["u"]).numerators   == ()
            assert Unit(numerators=["u"],denominators=["u"]).denominators == ()
            assert Unit(numerators=["u"],denominators=["u"]).magnitude    == Decimal(1)
            # Multiple Duplicate
            assert Unit(numerators=["u","u","u"],denominators=["u","u","u"]).symbols      == ()
            assert Unit(numerators=["u","u","u"],denominators=["u","u","u"]).numerators   == ()
            assert Unit(numerators=["u","u","u"],denominators=["u","u","u"]).denominators == ()
            assert Unit(numerators=["u","u","u"],denominators=["u","u","u"]).magnitude    == Decimal(1)
            # Multiple Different
            assert Unit(numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).symbols      == ()
            assert Unit(numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).numerators   == ()
            assert Unit(numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).denominators == ()
            assert Unit(numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).magnitude    == Decimal(1)
            # Partial Canceling
            assert Unit(numerators=["ua","ub","ub"],denominators=["ua","ub"]).symbols      == (("ub",Decimal(1)),)
            assert Unit(numerators=["ua","ub","ub"],denominators=["ua","ub"]).numerators   == (("ub",Decimal(1)),)
            assert Unit(numerators=["ua","ub","ub"],denominators=["ua","ub"]).denominators == ()
            assert Unit(numerators=["ua","ub","ub"],denominators=["ua","ub"]).magnitude    == Decimal(1)
        # Tuple of String, Exponent
        if(True):
          # Symbols
          if(True):
            # Single Numerator
            assert Unit(symbols=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
            assert Unit(symbols=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
            assert Unit(symbols=[("u",Decimal(1))]).denominators == ()
            assert Unit(symbols=[("u",Decimal(1))]).magnitude    == Decimal(1)
            # Single Numerator Higher Exponent
            assert Unit(symbols=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
            assert Unit(symbols=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
            assert Unit(symbols=[("u",Decimal(2))]).denominators == ()
            assert Unit(symbols=[("u",Decimal(2))]).magnitude    == Decimal(1)
            # Multiple Duplicate Numerators
            assert Unit(symbols=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
            assert Unit(symbols=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
            assert Unit(symbols=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
            assert Unit(symbols=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal(1)
            # Multiple Duplicate Numerators Higher Exponent
            assert Unit(symbols=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
            assert Unit(symbols=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
            assert Unit(symbols=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
            assert Unit(symbols=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal(1)
            # Multiple Different Numerators
            assert Unit(symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
            assert Unit(symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
            assert Unit(symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
            assert Unit(symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal(1)
          # Numerators
          if(True):
            # Single Numerator
            assert Unit(numerators=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
            assert Unit(numerators=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
            assert Unit(numerators=[("u",Decimal(1))]).denominators == ()
            assert Unit(numerators=[("u",Decimal(1))]).magnitude    == Decimal(1)
            # Single Numerator Higher Exponent
            assert Unit(numerators=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
            assert Unit(numerators=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
            assert Unit(numerators=[("u",Decimal(2))]).denominators == ()
            assert Unit(numerators=[("u",Decimal(2))]).magnitude    == Decimal(1)
            # Multiple Duplicate Numerators
            assert Unit(numerators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
            assert Unit(numerators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
            assert Unit(numerators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
            assert Unit(numerators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal(1)
            # Multiple Duplicate Numerators Higher Exponent
            assert Unit(numerators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
            assert Unit(numerators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
            assert Unit(numerators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
            assert Unit(numerators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal(1)
            # Multiple Different Numerators
            assert Unit(numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
            assert Unit(numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
            assert Unit(numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
            assert Unit(numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal(1)
          # Denominators
          if(True):
            # Single Numerator
            assert Unit(denominators=[("u",Decimal(1))]).symbols      == (("u",Decimal(-1)),)
            assert Unit(denominators=[("u",Decimal(1))]).numerators   == ()
            assert Unit(denominators=[("u",Decimal(1))]).denominators == (("u",Decimal(1)),)
            assert Unit(denominators=[("u",Decimal(1))]).magnitude    == Decimal(1)
            # Single Numerator Higher Exponent
            assert Unit(denominators=[("u",Decimal(2))]).symbols      == (("u",Decimal(-2)),)
            assert Unit(denominators=[("u",Decimal(2))]).numerators   == ()
            assert Unit(denominators=[("u",Decimal(2))]).denominators == (("u",Decimal(2)),)
            assert Unit(denominators=[("u",Decimal(2))]).magnitude    == Decimal(1)
            # Multiple Duplicate Numerators
            assert Unit(denominators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(-2)),)
            assert Unit(denominators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == ()
            assert Unit(denominators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == (("u",Decimal(2)),)
            assert Unit(denominators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal(1)
            # Multiple Duplicate Numerators Higher Exponent
            assert Unit(denominators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(-3)),)
            assert Unit(denominators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == ()
            assert Unit(denominators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == (("u",Decimal(3)),)
            assert Unit(denominators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal(1)
            # Multiple Different Numerators
            assert Unit(denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
            assert Unit(denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == ()
            assert Unit(denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
            assert Unit(denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal(1)
          # Numerators and Denominators
          if(True):
            # Single Numerator and Denominator
            assert Unit(numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
            assert Unit(numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).numerators   == (("nu",Decimal(1)),)
            assert Unit(numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).denominators == (("du",Decimal(1)),)
            assert Unit(numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).magnitude    == Decimal(1)
            # Single Numerator and Denominator Higher Exponent
            assert Unit(numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
            assert Unit(numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).numerators   == (("nu",Decimal(2)),)
            assert Unit(numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).denominators == (("du",Decimal(3)),)
            assert Unit(numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).magnitude    == Decimal(1)
            # Multiple Duplicate Numerators and Denominators
            assert Unit(numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
            assert Unit(numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).numerators   == (("nu",Decimal(3)),)
            assert Unit(numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).denominators == (("du",Decimal(2)),)
            assert Unit(numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).magnitude    == Decimal(1)
            # Multiple Duplicate Numerators and Denominators Higher Exponent
            assert Unit(numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
            assert Unit(numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).numerators   == (("nu",Decimal(4)),)
            assert Unit(numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).denominators == (("du",Decimal(4)),)
            assert Unit(numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).magnitude    == Decimal(1)
            # Multiple Different Numerators and Denominators
            assert Unit(numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
            assert Unit(numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
            assert Unit(numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
            assert Unit(numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).magnitude    == Decimal(1)
          # Canceling
          if(True):
            # Single
            assert Unit(numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).symbols      == ()
            assert Unit(numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).numerators   == ()
            assert Unit(numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).denominators == ()
            assert Unit(numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).magnitude    == Decimal(1)
            # Single Higher Exponent
            assert Unit(numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).symbols      == ()
            assert Unit(numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).numerators   == ()
            assert Unit(numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).denominators == ()
            assert Unit(numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).magnitude    == Decimal(1)
            # Multiple Duplicate
            assert Unit(numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
            assert Unit(numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
            assert Unit(numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
            assert Unit(numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal(1)
            # Multiple Duplicate Higher Exponent
            assert Unit(numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
            assert Unit(numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
            assert Unit(numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
            assert Unit(numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal(1)
            # Multiple Different
            assert Unit(numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).symbols      == ()
            assert Unit(numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).numerators   == ()
            assert Unit(numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).denominators == ()
            assert Unit(numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal(1)
            # Partial
            assert Unit(numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
            assert Unit(numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).numerators   == (("nua",Decimal(1)),)
            assert Unit(numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).denominators == (("nub",Decimal(1)),)
            assert Unit(numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal(1)
      # Explicit Symbols, Magnitude Int
      if(True):
        # Tuple of Strings
        if(True):
          # Positive Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(10,symbols=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(10,symbols=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(10,symbols=["u"]).denominators == ()
              assert Unit(10,symbols=["u"]).magnitude    == Decimal(10)
              # Multiple Duplicate Numerators
              assert Unit(10,symbols=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(10,symbols=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(10,symbols=["u","u"]).denominators == ()
              assert Unit(10,symbols=["u","u"]).magnitude    == Decimal(10)
              # Multiple Different Numerators
              assert Unit(10,symbols=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10,symbols=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10,symbols=["ua","ub","ub"]).denominators == ()
              assert Unit(10,symbols=["ua","ub","ub"]).magnitude    == Decimal(10)
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(10,numerators=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(10,numerators=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(10,numerators=["u"]).denominators == ()
              assert Unit(10,numerators=["u"]).magnitude    == Decimal(10)
              # Multiple Duplicate Numerators
              assert Unit(10,numerators=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(10,numerators=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(10,numerators=["u","u"]).denominators == ()
              assert Unit(10,numerators=["u","u"]).magnitude    == Decimal(10)
              # Multiple Different Numerators
              assert Unit(10,numerators=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10,numerators=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10,numerators=["ua","ub","ub"]).denominators == ()
              assert Unit(10,numerators=["ua","ub","ub"]).magnitude    == Decimal(10)
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(10,denominators=["u"]).symbols      == (("u",Decimal(-1)),)
              assert Unit(10,denominators=["u"]).numerators   == ()
              assert Unit(10,denominators=["u"]).denominators == (("u",Decimal(1)),)
              assert Unit(10,denominators=["u"]).magnitude    == Decimal(10)
              # Multiple Duplicate Numerators
              assert Unit(10,denominators=["u","u"]).symbols      == (("u",Decimal(-2)),)
              assert Unit(10,denominators=["u","u"]).numerators   == ()
              assert Unit(10,denominators=["u","u"]).denominators == (("u",Decimal(2)),)
              assert Unit(10,denominators=["u","u"]).magnitude    == Decimal(10)
              # Multiple Different Numerators
              assert Unit(10,denominators=["ua","ub","ub"]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(10,denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(10,denominators=["ua","ub","ub"]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10,denominators=["ua","ub","ub"]).magnitude    == Decimal(10)
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(10,numerators=["nu"],denominators=["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(10,numerators=["nu"],denominators=["du"]).numerators   == (("nu",Decimal(1)),)
              assert Unit(10,numerators=["nu"],denominators=["du"]).denominators == (("du",Decimal(1)),)
              assert Unit(10,numerators=["nu"],denominators=["du"]).magnitude    == Decimal(10)
              # Multiple Duplicate Numerators and Denominators
              assert Unit(10,numerators=["nu","nu","nu"],denominators=["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(10,numerators=["nu","nu","nu"],denominators=["du","du"]).numerators   == (("nu",Decimal(3)),)
              assert Unit(10,numerators=["nu","nu","nu"],denominators=["du","du"]).denominators == (("du",Decimal(2)),)
              assert Unit(10,numerators=["nu","nu","nu"],denominators=["du","du"]).magnitude    == Decimal(10)
              # Multiple Different Numerators and Denominators
              assert Unit(10,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(10,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(10,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
              assert Unit(10,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).magnitude    == Decimal(10)
            # Canceling
            if(True):
              # Single
              assert Unit(10,numerators=["u"],denominators=["u"]).symbols      == ()
              assert Unit(10,numerators=["u"],denominators=["u"]).numerators   == ()
              assert Unit(10,numerators=["u"],denominators=["u"]).denominators == ()
              assert Unit(10,numerators=["u"],denominators=["u"]).magnitude    == Decimal(10)
              # Multiple Duplicate
              assert Unit(10,numerators=["u","u","u"],denominators=["u","u","u"]).symbols      == ()
              assert Unit(10,numerators=["u","u","u"],denominators=["u","u","u"]).numerators   == ()
              assert Unit(10,numerators=["u","u","u"],denominators=["u","u","u"]).denominators == ()
              assert Unit(10,numerators=["u","u","u"],denominators=["u","u","u"]).magnitude    == Decimal(10)
              # Multiple Different
              assert Unit(10,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).symbols      == ()
              assert Unit(10,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(10,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).denominators == ()
              assert Unit(10,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).magnitude    == Decimal(10)
              # Partial Canceling
              assert Unit(10,numerators=["ua","ub","ub"],denominators=["ua","ub"]).symbols      == (("ub",Decimal(1)),)
              assert Unit(10,numerators=["ua","ub","ub"],denominators=["ua","ub"]).numerators   == (("ub",Decimal(1)),)
              assert Unit(10,numerators=["ua","ub","ub"],denominators=["ua","ub"]).denominators == ()
              assert Unit(10,numerators=["ua","ub","ub"],denominators=["ua","ub"]).magnitude    == Decimal(10)
          # Negative Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(-10,symbols=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(-10,symbols=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(-10,symbols=["u"]).denominators == ()
              assert Unit(-10,symbols=["u"]).magnitude    == Decimal(-10)
              # Multiple Duplicate Numerators
              assert Unit(-10,symbols=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(-10,symbols=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(-10,symbols=["u","u"]).denominators == ()
              assert Unit(-10,symbols=["u","u"]).magnitude    == Decimal(-10)
              # Multiple Different Numerators
              assert Unit(-10,symbols=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10,symbols=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10,symbols=["ua","ub","ub"]).denominators == ()
              assert Unit(-10,symbols=["ua","ub","ub"]).magnitude    == Decimal(-10)
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(-10,numerators=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(-10,numerators=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(-10,numerators=["u"]).denominators == ()
              assert Unit(-10,numerators=["u"]).magnitude    == Decimal(-10)
              # Multiple Duplicate Numerators
              assert Unit(-10,numerators=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(-10,numerators=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(-10,numerators=["u","u"]).denominators == ()
              assert Unit(-10,numerators=["u","u"]).magnitude    == Decimal(-10)
              # Multiple Different Numerators
              assert Unit(-10,numerators=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10,numerators=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10,numerators=["ua","ub","ub"]).denominators == ()
              assert Unit(-10,numerators=["ua","ub","ub"]).magnitude    == Decimal(-10)
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(-10,denominators=["u"]).symbols      == (("u",Decimal(-1)),)
              assert Unit(-10,denominators=["u"]).numerators   == ()
              assert Unit(-10,denominators=["u"]).denominators == (("u",Decimal(1)),)
              assert Unit(-10,denominators=["u"]).magnitude    == Decimal(-10)
              # Multiple Duplicate Numerators
              assert Unit(-10,denominators=["u","u"]).symbols      == (("u",Decimal(-2)),)
              assert Unit(-10,denominators=["u","u"]).numerators   == ()
              assert Unit(-10,denominators=["u","u"]).denominators == (("u",Decimal(2)),)
              assert Unit(-10,denominators=["u","u"]).magnitude    == Decimal(-10)
              # Multiple Different Numerators
              assert Unit(-10,denominators=["ua","ub","ub"]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(-10,denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(-10,denominators=["ua","ub","ub"]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10,denominators=["ua","ub","ub"]).magnitude    == Decimal(-10)
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(-10,numerators=["nu"],denominators=["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(-10,numerators=["nu"],denominators=["du"]).numerators   == (("nu",Decimal(1)),)
              assert Unit(-10,numerators=["nu"],denominators=["du"]).denominators == (("du",Decimal(1)),)
              assert Unit(-10,numerators=["nu"],denominators=["du"]).magnitude    == Decimal(-10)
              # Multiple Duplicate Numerators and Denominators
              assert Unit(-10,numerators=["nu","nu","nu"],denominators=["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(-10,numerators=["nu","nu","nu"],denominators=["du","du"]).numerators   == (("nu",Decimal(3)),)
              assert Unit(-10,numerators=["nu","nu","nu"],denominators=["du","du"]).denominators == (("du",Decimal(2)),)
              assert Unit(-10,numerators=["nu","nu","nu"],denominators=["du","du"]).magnitude    == Decimal(-10)
              # Multiple Different Numerators and Denominators
              assert Unit(-10,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(-10,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(-10,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
              assert Unit(-10,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).magnitude    == Decimal(-10)
            # Canceling
            if(True):
              # Single
              assert Unit(-10,numerators=["u"],denominators=["u"]).symbols      == ()
              assert Unit(-10,numerators=["u"],denominators=["u"]).numerators   == ()
              assert Unit(-10,numerators=["u"],denominators=["u"]).denominators == ()
              assert Unit(-10,numerators=["u"],denominators=["u"]).magnitude    == Decimal(-10)
              # Multiple Duplicate
              assert Unit(-10,numerators=["u","u","u"],denominators=["u","u","u"]).symbols      == ()
              assert Unit(-10,numerators=["u","u","u"],denominators=["u","u","u"]).numerators   == ()
              assert Unit(-10,numerators=["u","u","u"],denominators=["u","u","u"]).denominators == ()
              assert Unit(-10,numerators=["u","u","u"],denominators=["u","u","u"]).magnitude    == Decimal(-10)
              # Multiple Different
              assert Unit(-10,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).symbols      == ()
              assert Unit(-10,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(-10,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).denominators == ()
              assert Unit(-10,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).magnitude    == Decimal(-10)
              # Partial Canceling
              assert Unit(-10,numerators=["ua","ub","ub"],denominators=["ua","ub"]).symbols      == (("ub",Decimal(1)),)
              assert Unit(-10,numerators=["ua","ub","ub"],denominators=["ua","ub"]).numerators   == (("ub",Decimal(1)),)
              assert Unit(-10,numerators=["ua","ub","ub"],denominators=["ua","ub"]).denominators == ()
              assert Unit(-10,numerators=["ua","ub","ub"],denominators=["ua","ub"]).magnitude    == Decimal(-10)
        # Tuple of String, Exponent
        if(True):
          # Positive Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(10,symbols=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(10,symbols=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(10,symbols=[("u",Decimal(1))]).denominators == ()
              assert Unit(10,symbols=[("u",Decimal(1))]).magnitude    == Decimal(10)
              # Single Numerator Higher Exponent
              assert Unit(10,symbols=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(10,symbols=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(10,symbols=[("u",Decimal(2))]).denominators == ()
              assert Unit(10,symbols=[("u",Decimal(2))]).magnitude    == Decimal(10)
              # Multiple Duplicate Numerators
              assert Unit(10,symbols=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(10,symbols=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(10,symbols=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(10,symbols=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal(10)
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(10,symbols=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(10,symbols=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(10,symbols=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(10,symbols=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal(10)
              # Multiple Different Numerators
              assert Unit(10,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(10,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal(10)
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(10,numerators=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(10,numerators=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(10,numerators=[("u",Decimal(1))]).denominators == ()
              assert Unit(10,numerators=[("u",Decimal(1))]).magnitude    == Decimal(10)
              # Single Numerator Higher Exponent
              assert Unit(10,numerators=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(10,numerators=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(10,numerators=[("u",Decimal(2))]).denominators == ()
              assert Unit(10,numerators=[("u",Decimal(2))]).magnitude    == Decimal(10)
              # Multiple Duplicate Numerators
              assert Unit(10,numerators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(10,numerators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(10,numerators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(10,numerators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal(10)
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(10,numerators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(10,numerators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(10,numerators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(10,numerators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal(10)
              # Multiple Different Numerators
              assert Unit(10,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(10,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal(10)
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(10,denominators=[("u",Decimal(1))]).symbols      == (("u",Decimal(-1)),)
              assert Unit(10,denominators=[("u",Decimal(1))]).numerators   == ()
              assert Unit(10,denominators=[("u",Decimal(1))]).denominators == (("u",Decimal(1)),)
              assert Unit(10,denominators=[("u",Decimal(1))]).magnitude    == Decimal(10)
              # Single Numerator Higher Exponent
              assert Unit(10,denominators=[("u",Decimal(2))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(10,denominators=[("u",Decimal(2))]).numerators   == ()
              assert Unit(10,denominators=[("u",Decimal(2))]).denominators == (("u",Decimal(2)),)
              assert Unit(10,denominators=[("u",Decimal(2))]).magnitude    == Decimal(10)
              # Multiple Duplicate Numerators
              assert Unit(10,denominators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(10,denominators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == ()
              assert Unit(10,denominators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == (("u",Decimal(2)),)
              assert Unit(10,denominators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal(10)
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(10,denominators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(-3)),)
              assert Unit(10,denominators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == ()
              assert Unit(10,denominators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == (("u",Decimal(3)),)
              assert Unit(10,denominators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal(10)
              # Multiple Different Numerators
              assert Unit(10,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(10,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == ()
              assert Unit(10,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal(10)
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(10,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(10,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).numerators   == (("nu",Decimal(1)),)
              assert Unit(10,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).denominators == (("du",Decimal(1)),)
              assert Unit(10,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).magnitude    == Decimal(10)
              # Single Numerator and Denominator Higher Exponent
              assert Unit(10,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
              assert Unit(10,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).numerators   == (("nu",Decimal(2)),)
              assert Unit(10,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).denominators == (("du",Decimal(3)),)
              assert Unit(10,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).magnitude    == Decimal(10)
              # Multiple Duplicate Numerators and Denominators
              assert Unit(10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).numerators   == (("nu",Decimal(3)),)
              assert Unit(10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).denominators == (("du",Decimal(2)),)
              assert Unit(10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).magnitude    == Decimal(10)
              # Multiple Duplicate Numerators and Denominators Higher Exponent
              assert Unit(10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
              assert Unit(10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).numerators   == (("nu",Decimal(4)),)
              assert Unit(10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).denominators == (("du",Decimal(4)),)
              assert Unit(10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).magnitude    == Decimal(10)
              # Multiple Different Numerators and Denominators
              assert Unit(10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
              assert Unit(10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).magnitude    == Decimal(10)
            # Canceling
            if(True):
              # Single
              assert Unit(10,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).symbols      == ()
              assert Unit(10,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).numerators   == ()
              assert Unit(10,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).denominators == ()
              assert Unit(10,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).magnitude    == Decimal(10)
              # Single Higher Exponent
              assert Unit(10,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).symbols      == ()
              assert Unit(10,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).numerators   == ()
              assert Unit(10,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).denominators == ()
              assert Unit(10,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).magnitude    == Decimal(10)
              # Multiple Duplicate
              assert Unit(10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal(10)
              # Multiple Duplicate Higher Exponent
              assert Unit(10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal(10)
              # Multiple Different
              assert Unit(10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).symbols      == ()
              assert Unit(10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).numerators   == ()
              assert Unit(10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).denominators == ()
              assert Unit(10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal(10)
              # Partial
              assert Unit(10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
              assert Unit(10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).numerators   == (("nua",Decimal(1)),)
              assert Unit(10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).denominators == (("nub",Decimal(1)),)
              assert Unit(10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal(10)
          # Negative Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(-10,symbols=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(-10,symbols=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(-10,symbols=[("u",Decimal(1))]).denominators == ()
              assert Unit(-10,symbols=[("u",Decimal(1))]).magnitude    == Decimal(-10)
              # Single Numerator Higher Exponent
              assert Unit(-10,symbols=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(-10,symbols=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(-10,symbols=[("u",Decimal(2))]).denominators == ()
              assert Unit(-10,symbols=[("u",Decimal(2))]).magnitude    == Decimal(-10)
              # Multiple Duplicate Numerators
              assert Unit(-10,symbols=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(-10,symbols=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(-10,symbols=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(-10,symbols=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal(-10)
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(-10,symbols=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(-10,symbols=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(-10,symbols=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(-10,symbols=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal(-10)
              # Multiple Different Numerators
              assert Unit(-10,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(-10,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal(-10)
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(-10,numerators=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(-10,numerators=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(-10,numerators=[("u",Decimal(1))]).denominators == ()
              assert Unit(-10,numerators=[("u",Decimal(1))]).magnitude    == Decimal(-10)
              # Single Numerator Higher Exponent
              assert Unit(-10,numerators=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(-10,numerators=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(-10,numerators=[("u",Decimal(2))]).denominators == ()
              assert Unit(-10,numerators=[("u",Decimal(2))]).magnitude    == Decimal(-10)
              # Multiple Duplicate Numerators
              assert Unit(-10,numerators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(-10,numerators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(-10,numerators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(-10,numerators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal(-10)
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(-10,numerators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(-10,numerators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(-10,numerators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(-10,numerators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal(-10)
              # Multiple Different Numerators
              assert Unit(-10,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(-10,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal(-10)
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(-10,denominators=[("u",Decimal(1))]).symbols      == (("u",Decimal(-1)),)
              assert Unit(-10,denominators=[("u",Decimal(1))]).numerators   == ()
              assert Unit(-10,denominators=[("u",Decimal(1))]).denominators == (("u",Decimal(1)),)
              assert Unit(-10,denominators=[("u",Decimal(1))]).magnitude    == Decimal(-10)
              # Single Numerator Higher Exponent
              assert Unit(-10,denominators=[("u",Decimal(2))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(-10,denominators=[("u",Decimal(2))]).numerators   == ()
              assert Unit(-10,denominators=[("u",Decimal(2))]).denominators == (("u",Decimal(2)),)
              assert Unit(-10,denominators=[("u",Decimal(2))]).magnitude    == Decimal(-10)
              # Multiple Duplicate Numerators
              assert Unit(-10,denominators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(-10,denominators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == ()
              assert Unit(-10,denominators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == (("u",Decimal(2)),)
              assert Unit(-10,denominators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal(-10)
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(-10,denominators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(-3)),)
              assert Unit(-10,denominators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == ()
              assert Unit(-10,denominators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == (("u",Decimal(3)),)
              assert Unit(-10,denominators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal(-10)
              # Multiple Different Numerators
              assert Unit(-10,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(-10,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == ()
              assert Unit(-10,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal(-10)
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(-10,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(-10,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).numerators   == (("nu",Decimal(1)),)
              assert Unit(-10,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).denominators == (("du",Decimal(1)),)
              assert Unit(-10,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).magnitude    == Decimal(-10)
              # Single Numerator and Denominator Higher Exponent
              assert Unit(-10,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
              assert Unit(-10,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).numerators   == (("nu",Decimal(2)),)
              assert Unit(-10,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).denominators == (("du",Decimal(3)),)
              assert Unit(-10,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).magnitude    == Decimal(-10)
              # Multiple Duplicate Numerators and Denominators
              assert Unit(-10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(-10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).numerators   == (("nu",Decimal(3)),)
              assert Unit(-10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).denominators == (("du",Decimal(2)),)
              assert Unit(-10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).magnitude    == Decimal(-10)
              # Multiple Duplicate Numerators and Denominators Higher Exponent
              assert Unit(-10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
              assert Unit(-10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).numerators   == (("nu",Decimal(4)),)
              assert Unit(-10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).denominators == (("du",Decimal(4)),)
              assert Unit(-10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).magnitude    == Decimal(-10)
              # Multiple Different Numerators and Denominators
              assert Unit(-10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(-10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(-10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
              assert Unit(-10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).magnitude    == Decimal(-10)
            # Canceling
            if(True):
              # Single
              assert Unit(-10,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).symbols      == ()
              assert Unit(-10,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).numerators   == ()
              assert Unit(-10,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).denominators == ()
              assert Unit(-10,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).magnitude    == Decimal(-10)
              # Single Higher Exponent
              assert Unit(-10,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).symbols      == ()
              assert Unit(-10,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).numerators   == ()
              assert Unit(-10,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).denominators == ()
              assert Unit(-10,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).magnitude    == Decimal(-10)
              # Multiple Duplicate
              assert Unit(-10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(-10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(-10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(-10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal(-10)
              # Multiple Duplicate Higher Exponent
              assert Unit(-10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(-10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(-10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(-10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal(-10)
              # Multiple Different
              assert Unit(-10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).symbols      == ()
              assert Unit(-10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).numerators   == ()
              assert Unit(-10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).denominators == ()
              assert Unit(-10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal(-10)
              # Partial
              assert Unit(-10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
              assert Unit(-10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).numerators   == (("nua",Decimal(1)),)
              assert Unit(-10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).denominators == (("nub",Decimal(1)),)
              assert Unit(-10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal(-10)
      # Explicit Symbols, Magnitude float
      if(True):
        # Tuple of Strings
        if(True):
          # Positive Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(10.1,symbols=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(10.1,symbols=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(10.1,symbols=["u"]).denominators == ()
              assert Unit(10.1,symbols=["u"]).magnitude    == 10.1
              # Multiple Duplicate Numerators
              assert Unit(10.1,symbols=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(10.1,symbols=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(10.1,symbols=["u","u"]).denominators == ()
              assert Unit(10.1,symbols=["u","u"]).magnitude    == 10.1
              # Multiple Different Numerators
              assert Unit(10.1,symbols=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10.1,symbols=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10.1,symbols=["ua","ub","ub"]).denominators == ()
              assert Unit(10.1,symbols=["ua","ub","ub"]).magnitude    == 10.1
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(10.1,numerators=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(10.1,numerators=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(10.1,numerators=["u"]).denominators == ()
              assert Unit(10.1,numerators=["u"]).magnitude    == 10.1
              # Multiple Duplicate Numerators
              assert Unit(10.1,numerators=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(10.1,numerators=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(10.1,numerators=["u","u"]).denominators == ()
              assert Unit(10.1,numerators=["u","u"]).magnitude    == 10.1
              # Multiple Different Numerators
              assert Unit(10.1,numerators=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10.1,numerators=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10.1,numerators=["ua","ub","ub"]).denominators == ()
              assert Unit(10.1,numerators=["ua","ub","ub"]).magnitude    == 10.1
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(10.1,denominators=["u"]).symbols      == (("u",Decimal(-1)),)
              assert Unit(10.1,denominators=["u"]).numerators   == ()
              assert Unit(10.1,denominators=["u"]).denominators == (("u",Decimal(1)),)
              assert Unit(10.1,denominators=["u"]).magnitude    == 10.1
              # Multiple Duplicate Numerators
              assert Unit(10.1,denominators=["u","u"]).symbols      == (("u",Decimal(-2)),)
              assert Unit(10.1,denominators=["u","u"]).numerators   == ()
              assert Unit(10.1,denominators=["u","u"]).denominators == (("u",Decimal(2)),)
              assert Unit(10.1,denominators=["u","u"]).magnitude    == 10.1
              # Multiple Different Numerators
              assert Unit(10.1,denominators=["ua","ub","ub"]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(10.1,denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(10.1,denominators=["ua","ub","ub"]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10.1,denominators=["ua","ub","ub"]).magnitude    == 10.1
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(10.1,numerators=["nu"],denominators=["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(10.1,numerators=["nu"],denominators=["du"]).numerators   == (("nu",Decimal(1)),)
              assert Unit(10.1,numerators=["nu"],denominators=["du"]).denominators == (("du",Decimal(1)),)
              assert Unit(10.1,numerators=["nu"],denominators=["du"]).magnitude    == 10.1
              # Multiple Duplicate Numerators and Denominators
              assert Unit(10.1,numerators=["nu","nu","nu"],denominators=["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(10.1,numerators=["nu","nu","nu"],denominators=["du","du"]).numerators   == (("nu",Decimal(3)),)
              assert Unit(10.1,numerators=["nu","nu","nu"],denominators=["du","du"]).denominators == (("du",Decimal(2)),)
              assert Unit(10.1,numerators=["nu","nu","nu"],denominators=["du","du"]).magnitude    == 10.1
              # Multiple Different Numerators and Denominators
              assert Unit(10.1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(10.1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(10.1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
              assert Unit(10.1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).magnitude    == 10.1
            # Canceling
            if(True):
              # Single
              assert Unit(10.1,numerators=["u"],denominators=["u"]).symbols      == ()
              assert Unit(10.1,numerators=["u"],denominators=["u"]).numerators   == ()
              assert Unit(10.1,numerators=["u"],denominators=["u"]).denominators == ()
              assert Unit(10.1,numerators=["u"],denominators=["u"]).magnitude    == 10.1
              # Multiple Duplicate
              assert Unit(10.1,numerators=["u","u","u"],denominators=["u","u","u"]).symbols      == ()
              assert Unit(10.1,numerators=["u","u","u"],denominators=["u","u","u"]).numerators   == ()
              assert Unit(10.1,numerators=["u","u","u"],denominators=["u","u","u"]).denominators == ()
              assert Unit(10.1,numerators=["u","u","u"],denominators=["u","u","u"]).magnitude    == 10.1
              # Multiple Different
              assert Unit(10.1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).symbols      == ()
              assert Unit(10.1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(10.1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).denominators == ()
              assert Unit(10.1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).magnitude    == 10.1
              # Partial Canceling
              assert Unit(10.1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).symbols      == (("ub",Decimal(1)),)
              assert Unit(10.1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).numerators   == (("ub",Decimal(1)),)
              assert Unit(10.1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).denominators == ()
              assert Unit(10.1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).magnitude    == 10.1
          # Negative Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(-10.1,symbols=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(-10.1,symbols=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(-10.1,symbols=["u"]).denominators == ()
              assert Unit(-10.1,symbols=["u"]).magnitude    == -10.1
              # Multiple Duplicate Numerators
              assert Unit(-10.1,symbols=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(-10.1,symbols=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(-10.1,symbols=["u","u"]).denominators == ()
              assert Unit(-10.1,symbols=["u","u"]).magnitude    == -10.1
              # Multiple Different Numerators
              assert Unit(-10.1,symbols=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10.1,symbols=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10.1,symbols=["ua","ub","ub"]).denominators == ()
              assert Unit(-10.1,symbols=["ua","ub","ub"]).magnitude    == -10.1
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(-10.1,numerators=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(-10.1,numerators=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(-10.1,numerators=["u"]).denominators == ()
              assert Unit(-10.1,numerators=["u"]).magnitude    == -10.1
              # Multiple Duplicate Numerators
              assert Unit(-10.1,numerators=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(-10.1,numerators=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(-10.1,numerators=["u","u"]).denominators == ()
              assert Unit(-10.1,numerators=["u","u"]).magnitude    == -10.1
              # Multiple Different Numerators
              assert Unit(-10.1,numerators=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10.1,numerators=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10.1,numerators=["ua","ub","ub"]).denominators == ()
              assert Unit(-10.1,numerators=["ua","ub","ub"]).magnitude    == -10.1
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(-10.1,denominators=["u"]).symbols      == (("u",Decimal(-1)),)
              assert Unit(-10.1,denominators=["u"]).numerators   == ()
              assert Unit(-10.1,denominators=["u"]).denominators == (("u",Decimal(1)),)
              assert Unit(-10.1,denominators=["u"]).magnitude    == -10.1
              # Multiple Duplicate Numerators
              assert Unit(-10.1,denominators=["u","u"]).symbols      == (("u",Decimal(-2)),)
              assert Unit(-10.1,denominators=["u","u"]).numerators   == ()
              assert Unit(-10.1,denominators=["u","u"]).denominators == (("u",Decimal(2)),)
              assert Unit(-10.1,denominators=["u","u"]).magnitude    == -10.1
              # Multiple Different Numerators
              assert Unit(-10.1,denominators=["ua","ub","ub"]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(-10.1,denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(-10.1,denominators=["ua","ub","ub"]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10.1,denominators=["ua","ub","ub"]).magnitude    == -10.1
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(-10.1,numerators=["nu"],denominators=["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(-10.1,numerators=["nu"],denominators=["du"]).numerators   == (("nu",Decimal(1)),)
              assert Unit(-10.1,numerators=["nu"],denominators=["du"]).denominators == (("du",Decimal(1)),)
              assert Unit(-10.1,numerators=["nu"],denominators=["du"]).magnitude    == -10.1
              # Multiple Duplicate Numerators and Denominators
              assert Unit(-10.1,numerators=["nu","nu","nu"],denominators=["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(-10.1,numerators=["nu","nu","nu"],denominators=["du","du"]).numerators   == (("nu",Decimal(3)),)
              assert Unit(-10.1,numerators=["nu","nu","nu"],denominators=["du","du"]).denominators == (("du",Decimal(2)),)
              assert Unit(-10.1,numerators=["nu","nu","nu"],denominators=["du","du"]).magnitude    == -10.1
              # Multiple Different Numerators and Denominators
              assert Unit(-10.1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(-10.1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(-10.1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
              assert Unit(-10.1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).magnitude    == -10.1
            # Canceling
            if(True):
              # Single
              assert Unit(-10.1,numerators=["u"],denominators=["u"]).symbols      == ()
              assert Unit(-10.1,numerators=["u"],denominators=["u"]).numerators   == ()
              assert Unit(-10.1,numerators=["u"],denominators=["u"]).denominators == ()
              assert Unit(-10.1,numerators=["u"],denominators=["u"]).magnitude    == -10.1
              # Multiple Duplicate
              assert Unit(-10.1,numerators=["u","u","u"],denominators=["u","u","u"]).symbols      == ()
              assert Unit(-10.1,numerators=["u","u","u"],denominators=["u","u","u"]).numerators   == ()
              assert Unit(-10.1,numerators=["u","u","u"],denominators=["u","u","u"]).denominators == ()
              assert Unit(-10.1,numerators=["u","u","u"],denominators=["u","u","u"]).magnitude    == -10.1
              # Multiple Different
              assert Unit(-10.1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).symbols      == ()
              assert Unit(-10.1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(-10.1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).denominators == ()
              assert Unit(-10.1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).magnitude    == -10.1
              # Partial Canceling
              assert Unit(-10.1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).symbols      == (("ub",Decimal(1)),)
              assert Unit(-10.1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).numerators   == (("ub",Decimal(1)),)
              assert Unit(-10.1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).denominators == ()
              assert Unit(-10.1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).magnitude    == -10.1
        # Tuple of String, Exponent
        if(True):
          # Positive Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(10.1,symbols=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(10.1,symbols=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(10.1,symbols=[("u",Decimal(1))]).denominators == ()
              assert Unit(10.1,symbols=[("u",Decimal(1))]).magnitude    == 10.1
              # Single Numerator Higher Exponent
              assert Unit(10.1,symbols=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(10.1,symbols=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(10.1,symbols=[("u",Decimal(2))]).denominators == ()
              assert Unit(10.1,symbols=[("u",Decimal(2))]).magnitude    == 10.1
              # Multiple Duplicate Numerators
              assert Unit(10.1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(10.1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(10.1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(10.1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == 10.1
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(10.1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(10.1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(10.1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(10.1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == 10.1
              # Multiple Different Numerators
              assert Unit(10.1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10.1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10.1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(10.1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == 10.1
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(10.1,numerators=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(10.1,numerators=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(10.1,numerators=[("u",Decimal(1))]).denominators == ()
              assert Unit(10.1,numerators=[("u",Decimal(1))]).magnitude    == 10.1
              # Single Numerator Higher Exponent
              assert Unit(10.1,numerators=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(10.1,numerators=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(10.1,numerators=[("u",Decimal(2))]).denominators == ()
              assert Unit(10.1,numerators=[("u",Decimal(2))]).magnitude    == 10.1
              # Multiple Duplicate Numerators
              assert Unit(10.1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(10.1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(10.1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(10.1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == 10.1
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(10.1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(10.1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(10.1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(10.1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == 10.1
              # Multiple Different Numerators
              assert Unit(10.1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10.1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10.1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(10.1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == 10.1
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(10.1,denominators=[("u",Decimal(1))]).symbols      == (("u",Decimal(-1)),)
              assert Unit(10.1,denominators=[("u",Decimal(1))]).numerators   == ()
              assert Unit(10.1,denominators=[("u",Decimal(1))]).denominators == (("u",Decimal(1)),)
              assert Unit(10.1,denominators=[("u",Decimal(1))]).magnitude    == 10.1
              # Single Numerator Higher Exponent
              assert Unit(10.1,denominators=[("u",Decimal(2))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(10.1,denominators=[("u",Decimal(2))]).numerators   == ()
              assert Unit(10.1,denominators=[("u",Decimal(2))]).denominators == (("u",Decimal(2)),)
              assert Unit(10.1,denominators=[("u",Decimal(2))]).magnitude    == 10.1
              # Multiple Duplicate Numerators
              assert Unit(10.1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(10.1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == ()
              assert Unit(10.1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == (("u",Decimal(2)),)
              assert Unit(10.1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == 10.1
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(10.1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(-3)),)
              assert Unit(10.1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == ()
              assert Unit(10.1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == (("u",Decimal(3)),)
              assert Unit(10.1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == 10.1
              # Multiple Different Numerators
              assert Unit(10.1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(10.1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == ()
              assert Unit(10.1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10.1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == 10.1
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(10.1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(10.1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).numerators   == (("nu",Decimal(1)),)
              assert Unit(10.1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).denominators == (("du",Decimal(1)),)
              assert Unit(10.1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).magnitude    == 10.1
              # Single Numerator and Denominator Higher Exponent
              assert Unit(10.1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
              assert Unit(10.1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).numerators   == (("nu",Decimal(2)),)
              assert Unit(10.1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).denominators == (("du",Decimal(3)),)
              assert Unit(10.1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).magnitude    == 10.1
              # Multiple Duplicate Numerators and Denominators
              assert Unit(10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).numerators   == (("nu",Decimal(3)),)
              assert Unit(10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).denominators == (("du",Decimal(2)),)
              assert Unit(10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).magnitude    == 10.1
              # Multiple Duplicate Numerators and Denominators Higher Exponent
              assert Unit(10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
              assert Unit(10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).numerators   == (("nu",Decimal(4)),)
              assert Unit(10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).denominators == (("du",Decimal(4)),)
              assert Unit(10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).magnitude    == 10.1
              # Multiple Different Numerators and Denominators
              assert Unit(10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
              assert Unit(10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).magnitude    == 10.1
            # Canceling
            if(True):
              # Single
              assert Unit(10.1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).symbols      == ()
              assert Unit(10.1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).numerators   == ()
              assert Unit(10.1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).denominators == ()
              assert Unit(10.1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).magnitude    == 10.1
              # Single Higher Exponent
              assert Unit(10.1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).symbols      == ()
              assert Unit(10.1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).numerators   == ()
              assert Unit(10.1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).denominators == ()
              assert Unit(10.1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).magnitude    == 10.1
              # Multiple Duplicate
              assert Unit(10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == 10.1
              # Multiple Duplicate Higher Exponent
              assert Unit(10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == 10.1
              # Multiple Different
              assert Unit(10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).symbols      == ()
              assert Unit(10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).numerators   == ()
              assert Unit(10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).denominators == ()
              assert Unit(10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).magnitude    == 10.1
              # Partial
              assert Unit(10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
              assert Unit(10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).numerators   == (("nua",Decimal(1)),)
              assert Unit(10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).denominators == (("nub",Decimal(1)),)
              assert Unit(10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).magnitude    == 10.1
          # Negative Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(-10.1,symbols=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(-10.1,symbols=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(-10.1,symbols=[("u",Decimal(1))]).denominators == ()
              assert Unit(-10.1,symbols=[("u",Decimal(1))]).magnitude    == -10.1
              # Single Numerator Higher Exponent
              assert Unit(-10.1,symbols=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(-10.1,symbols=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(-10.1,symbols=[("u",Decimal(2))]).denominators == ()
              assert Unit(-10.1,symbols=[("u",Decimal(2))]).magnitude    == -10.1
              # Multiple Duplicate Numerators
              assert Unit(-10.1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(-10.1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(-10.1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(-10.1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == -10.1
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(-10.1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(-10.1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(-10.1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(-10.1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == -10.1
              # Multiple Different Numerators
              assert Unit(-10.1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10.1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10.1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(-10.1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == -10.1
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(-10.1,numerators=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(-10.1,numerators=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(-10.1,numerators=[("u",Decimal(1))]).denominators == ()
              assert Unit(-10.1,numerators=[("u",Decimal(1))]).magnitude    == -10.1
              # Single Numerator Higher Exponent
              assert Unit(-10.1,numerators=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(-10.1,numerators=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(-10.1,numerators=[("u",Decimal(2))]).denominators == ()
              assert Unit(-10.1,numerators=[("u",Decimal(2))]).magnitude    == -10.1
              # Multiple Duplicate Numerators
              assert Unit(-10.1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(-10.1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(-10.1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(-10.1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == -10.1
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(-10.1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(-10.1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(-10.1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(-10.1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == -10.1
              # Multiple Different Numerators
              assert Unit(-10.1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10.1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10.1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(-10.1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == -10.1
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(-10.1,denominators=[("u",Decimal(1))]).symbols      == (("u",Decimal(-1)),)
              assert Unit(-10.1,denominators=[("u",Decimal(1))]).numerators   == ()
              assert Unit(-10.1,denominators=[("u",Decimal(1))]).denominators == (("u",Decimal(1)),)
              assert Unit(-10.1,denominators=[("u",Decimal(1))]).magnitude    == -10.1
              # Single Numerator Higher Exponent
              assert Unit(-10.1,denominators=[("u",Decimal(2))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(-10.1,denominators=[("u",Decimal(2))]).numerators   == ()
              assert Unit(-10.1,denominators=[("u",Decimal(2))]).denominators == (("u",Decimal(2)),)
              assert Unit(-10.1,denominators=[("u",Decimal(2))]).magnitude    == -10.1
              # Multiple Duplicate Numerators
              assert Unit(-10.1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(-10.1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == ()
              assert Unit(-10.1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == (("u",Decimal(2)),)
              assert Unit(-10.1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == -10.1
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(-10.1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(-3)),)
              assert Unit(-10.1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == ()
              assert Unit(-10.1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == (("u",Decimal(3)),)
              assert Unit(-10.1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == -10.1
              # Multiple Different Numerators
              assert Unit(-10.1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(-10.1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == ()
              assert Unit(-10.1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10.1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == -10.1
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(-10.1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(-10.1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).numerators   == (("nu",Decimal(1)),)
              assert Unit(-10.1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).denominators == (("du",Decimal(1)),)
              assert Unit(-10.1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).magnitude    == -10.1
              # Single Numerator and Denominator Higher Exponent
              assert Unit(-10.1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
              assert Unit(-10.1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).numerators   == (("nu",Decimal(2)),)
              assert Unit(-10.1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).denominators == (("du",Decimal(3)),)
              assert Unit(-10.1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).magnitude    == -10.1
              # Multiple Duplicate Numerators and Denominators
              assert Unit(-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).numerators   == (("nu",Decimal(3)),)
              assert Unit(-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).denominators == (("du",Decimal(2)),)
              assert Unit(-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).magnitude    == -10.1
              # Multiple Duplicate Numerators and Denominators Higher Exponent
              assert Unit(-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
              assert Unit(-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).numerators   == (("nu",Decimal(4)),)
              assert Unit(-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).denominators == (("du",Decimal(4)),)
              assert Unit(-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).magnitude    == -10.1
              # Multiple Different Numerators and Denominators
              assert Unit(-10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(-10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(-10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
              assert Unit(-10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).magnitude    == -10.1
            # Canceling
            if(True):
              # Single
              assert Unit(-10.1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).symbols      == ()
              assert Unit(-10.1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).numerators   == ()
              assert Unit(-10.1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).denominators == ()
              assert Unit(-10.1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).magnitude    == -10.1
              # Single Higher Exponent
              assert Unit(-10.1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).symbols      == ()
              assert Unit(-10.1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).numerators   == ()
              assert Unit(-10.1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).denominators == ()
              assert Unit(-10.1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).magnitude    == -10.1
              # Multiple Duplicate
              assert Unit(-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == -10.1
              # Multiple Duplicate Higher Exponent
              assert Unit(-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == -10.1
              # Multiple Different
              assert Unit(-10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).symbols      == ()
              assert Unit(-10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).numerators   == ()
              assert Unit(-10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).denominators == ()
              assert Unit(-10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).magnitude    == -10.1
              # Partial
              assert Unit(-10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
              assert Unit(-10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).numerators   == (("nua",Decimal(1)),)
              assert Unit(-10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).denominators == (("nub",Decimal(1)),)
              assert Unit(-10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).magnitude    == -10.1
        # Tuple of Strings
        if(True):
          # Positive Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(10e1,symbols=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(10e1,symbols=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(10e1,symbols=["u"]).denominators == ()
              assert Unit(10e1,symbols=["u"]).magnitude    == 10e1
              # Multiple Duplicate Numerators
              assert Unit(10e1,symbols=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(10e1,symbols=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(10e1,symbols=["u","u"]).denominators == ()
              assert Unit(10e1,symbols=["u","u"]).magnitude    == 10e1
              # Multiple Different Numerators
              assert Unit(10e1,symbols=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10e1,symbols=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10e1,symbols=["ua","ub","ub"]).denominators == ()
              assert Unit(10e1,symbols=["ua","ub","ub"]).magnitude    == 10e1
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(10e1,numerators=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(10e1,numerators=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(10e1,numerators=["u"]).denominators == ()
              assert Unit(10e1,numerators=["u"]).magnitude    == 10e1
              # Multiple Duplicate Numerators
              assert Unit(10e1,numerators=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(10e1,numerators=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(10e1,numerators=["u","u"]).denominators == ()
              assert Unit(10e1,numerators=["u","u"]).magnitude    == 10e1
              # Multiple Different Numerators
              assert Unit(10e1,numerators=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10e1,numerators=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10e1,numerators=["ua","ub","ub"]).denominators == ()
              assert Unit(10e1,numerators=["ua","ub","ub"]).magnitude    == 10e1
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(10e1,denominators=["u"]).symbols      == (("u",Decimal(-1)),)
              assert Unit(10e1,denominators=["u"]).numerators   == ()
              assert Unit(10e1,denominators=["u"]).denominators == (("u",Decimal(1)),)
              assert Unit(10e1,denominators=["u"]).magnitude    == 10e1
              # Multiple Duplicate Numerators
              assert Unit(10e1,denominators=["u","u"]).symbols      == (("u",Decimal(-2)),)
              assert Unit(10e1,denominators=["u","u"]).numerators   == ()
              assert Unit(10e1,denominators=["u","u"]).denominators == (("u",Decimal(2)),)
              assert Unit(10e1,denominators=["u","u"]).magnitude    == 10e1
              # Multiple Different Numerators
              assert Unit(10e1,denominators=["ua","ub","ub"]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(10e1,denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(10e1,denominators=["ua","ub","ub"]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10e1,denominators=["ua","ub","ub"]).magnitude    == 10e1
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(10e1,numerators=["nu"],denominators=["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(10e1,numerators=["nu"],denominators=["du"]).numerators   == (("nu",Decimal(1)),)
              assert Unit(10e1,numerators=["nu"],denominators=["du"]).denominators == (("du",Decimal(1)),)
              assert Unit(10e1,numerators=["nu"],denominators=["du"]).magnitude    == 10e1
              # Multiple Duplicate Numerators and Denominators
              assert Unit(10e1,numerators=["nu","nu","nu"],denominators=["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(10e1,numerators=["nu","nu","nu"],denominators=["du","du"]).numerators   == (("nu",Decimal(3)),)
              assert Unit(10e1,numerators=["nu","nu","nu"],denominators=["du","du"]).denominators == (("du",Decimal(2)),)
              assert Unit(10e1,numerators=["nu","nu","nu"],denominators=["du","du"]).magnitude    == 10e1
              # Multiple Different Numerators and Denominators
              assert Unit(10e1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(10e1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(10e1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
              assert Unit(10e1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).magnitude    == 10e1
            # Canceling
            if(True):
              # Single
              assert Unit(10e1,numerators=["u"],denominators=["u"]).symbols      == ()
              assert Unit(10e1,numerators=["u"],denominators=["u"]).numerators   == ()
              assert Unit(10e1,numerators=["u"],denominators=["u"]).denominators == ()
              assert Unit(10e1,numerators=["u"],denominators=["u"]).magnitude    == 10e1
              # Multiple Duplicate
              assert Unit(10e1,numerators=["u","u","u"],denominators=["u","u","u"]).symbols      == ()
              assert Unit(10e1,numerators=["u","u","u"],denominators=["u","u","u"]).numerators   == ()
              assert Unit(10e1,numerators=["u","u","u"],denominators=["u","u","u"]).denominators == ()
              assert Unit(10e1,numerators=["u","u","u"],denominators=["u","u","u"]).magnitude    == 10e1
              # Multiple Different
              assert Unit(10e1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).symbols      == ()
              assert Unit(10e1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(10e1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).denominators == ()
              assert Unit(10e1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).magnitude    == 10e1
              # Partial Canceling
              assert Unit(10e1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).symbols      == (("ub",Decimal(1)),)
              assert Unit(10e1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).numerators   == (("ub",Decimal(1)),)
              assert Unit(10e1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).denominators == ()
              assert Unit(10e1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).magnitude    == 10e1
          # Negative Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(-10e1,symbols=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(-10e1,symbols=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(-10e1,symbols=["u"]).denominators == ()
              assert Unit(-10e1,symbols=["u"]).magnitude    == -10e1
              # Multiple Duplicate Numerators
              assert Unit(-10e1,symbols=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(-10e1,symbols=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(-10e1,symbols=["u","u"]).denominators == ()
              assert Unit(-10e1,symbols=["u","u"]).magnitude    == -10e1
              # Multiple Different Numerators
              assert Unit(-10e1,symbols=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10e1,symbols=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10e1,symbols=["ua","ub","ub"]).denominators == ()
              assert Unit(-10e1,symbols=["ua","ub","ub"]).magnitude    == -10e1
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(-10e1,numerators=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(-10e1,numerators=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(-10e1,numerators=["u"]).denominators == ()
              assert Unit(-10e1,numerators=["u"]).magnitude    == -10e1
              # Multiple Duplicate Numerators
              assert Unit(-10e1,numerators=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(-10e1,numerators=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(-10e1,numerators=["u","u"]).denominators == ()
              assert Unit(-10e1,numerators=["u","u"]).magnitude    == -10e1
              # Multiple Different Numerators
              assert Unit(-10e1,numerators=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10e1,numerators=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10e1,numerators=["ua","ub","ub"]).denominators == ()
              assert Unit(-10e1,numerators=["ua","ub","ub"]).magnitude    == -10e1
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(-10e1,denominators=["u"]).symbols      == (("u",Decimal(-1)),)
              assert Unit(-10e1,denominators=["u"]).numerators   == ()
              assert Unit(-10e1,denominators=["u"]).denominators == (("u",Decimal(1)),)
              assert Unit(-10e1,denominators=["u"]).magnitude    == -10e1
              # Multiple Duplicate Numerators
              assert Unit(-10e1,denominators=["u","u"]).symbols      == (("u",Decimal(-2)),)
              assert Unit(-10e1,denominators=["u","u"]).numerators   == ()
              assert Unit(-10e1,denominators=["u","u"]).denominators == (("u",Decimal(2)),)
              assert Unit(-10e1,denominators=["u","u"]).magnitude    == -10e1
              # Multiple Different Numerators
              assert Unit(-10e1,denominators=["ua","ub","ub"]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(-10e1,denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(-10e1,denominators=["ua","ub","ub"]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10e1,denominators=["ua","ub","ub"]).magnitude    == -10e1
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(-10e1,numerators=["nu"],denominators=["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(-10e1,numerators=["nu"],denominators=["du"]).numerators   == (("nu",Decimal(1)),)
              assert Unit(-10e1,numerators=["nu"],denominators=["du"]).denominators == (("du",Decimal(1)),)
              assert Unit(-10e1,numerators=["nu"],denominators=["du"]).magnitude    == -10e1
              # Multiple Duplicate Numerators and Denominators
              assert Unit(-10e1,numerators=["nu","nu","nu"],denominators=["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(-10e1,numerators=["nu","nu","nu"],denominators=["du","du"]).numerators   == (("nu",Decimal(3)),)
              assert Unit(-10e1,numerators=["nu","nu","nu"],denominators=["du","du"]).denominators == (("du",Decimal(2)),)
              assert Unit(-10e1,numerators=["nu","nu","nu"],denominators=["du","du"]).magnitude    == -10e1
              # Multiple Different Numerators and Denominators
              assert Unit(-10e1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(-10e1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(-10e1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
              assert Unit(-10e1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).magnitude    == -10e1
            # Canceling
            if(True):
              # Single
              assert Unit(-10e1,numerators=["u"],denominators=["u"]).symbols      == ()
              assert Unit(-10e1,numerators=["u"],denominators=["u"]).numerators   == ()
              assert Unit(-10e1,numerators=["u"],denominators=["u"]).denominators == ()
              assert Unit(-10e1,numerators=["u"],denominators=["u"]).magnitude    == -10e1
              # Multiple Duplicate
              assert Unit(-10e1,numerators=["u","u","u"],denominators=["u","u","u"]).symbols      == ()
              assert Unit(-10e1,numerators=["u","u","u"],denominators=["u","u","u"]).numerators   == ()
              assert Unit(-10e1,numerators=["u","u","u"],denominators=["u","u","u"]).denominators == ()
              assert Unit(-10e1,numerators=["u","u","u"],denominators=["u","u","u"]).magnitude    == -10e1
              # Multiple Different
              assert Unit(-10e1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).symbols      == ()
              assert Unit(-10e1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(-10e1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).denominators == ()
              assert Unit(-10e1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).magnitude    == -10e1
              # Partial Canceling
              assert Unit(-10e1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).symbols      == (("ub",Decimal(1)),)
              assert Unit(-10e1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).numerators   == (("ub",Decimal(1)),)
              assert Unit(-10e1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).denominators == ()
              assert Unit(-10e1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).magnitude    == -10e1
        # Tuple of String, Exponent
        if(True):
          # Positive Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(10e1,symbols=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(10e1,symbols=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(10e1,symbols=[("u",Decimal(1))]).denominators == ()
              assert Unit(10e1,symbols=[("u",Decimal(1))]).magnitude    == 10e1
              # Single Numerator Higher Exponent
              assert Unit(10e1,symbols=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(10e1,symbols=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(10e1,symbols=[("u",Decimal(2))]).denominators == ()
              assert Unit(10e1,symbols=[("u",Decimal(2))]).magnitude    == 10e1
              # Multiple Duplicate Numerators
              assert Unit(10e1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(10e1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(10e1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(10e1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == 10e1
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(10e1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(10e1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(10e1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(10e1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == 10e1
              # Multiple Different Numerators
              assert Unit(10e1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10e1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10e1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(10e1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == 10e1
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(10e1,numerators=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(10e1,numerators=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(10e1,numerators=[("u",Decimal(1))]).denominators == ()
              assert Unit(10e1,numerators=[("u",Decimal(1))]).magnitude    == 10e1
              # Single Numerator Higher Exponent
              assert Unit(10e1,numerators=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(10e1,numerators=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(10e1,numerators=[("u",Decimal(2))]).denominators == ()
              assert Unit(10e1,numerators=[("u",Decimal(2))]).magnitude    == 10e1
              # Multiple Duplicate Numerators
              assert Unit(10e1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(10e1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(10e1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(10e1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == 10e1
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(10e1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(10e1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(10e1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(10e1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == 10e1
              # Multiple Different Numerators
              assert Unit(10e1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10e1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10e1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(10e1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == 10e1
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(10e1,denominators=[("u",Decimal(1))]).symbols      == (("u",Decimal(-1)),)
              assert Unit(10e1,denominators=[("u",Decimal(1))]).numerators   == ()
              assert Unit(10e1,denominators=[("u",Decimal(1))]).denominators == (("u",Decimal(1)),)
              assert Unit(10e1,denominators=[("u",Decimal(1))]).magnitude    == 10e1
              # Single Numerator Higher Exponent
              assert Unit(10e1,denominators=[("u",Decimal(2))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(10e1,denominators=[("u",Decimal(2))]).numerators   == ()
              assert Unit(10e1,denominators=[("u",Decimal(2))]).denominators == (("u",Decimal(2)),)
              assert Unit(10e1,denominators=[("u",Decimal(2))]).magnitude    == 10e1
              # Multiple Duplicate Numerators
              assert Unit(10e1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(10e1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == ()
              assert Unit(10e1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == (("u",Decimal(2)),)
              assert Unit(10e1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == 10e1
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(10e1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(-3)),)
              assert Unit(10e1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == ()
              assert Unit(10e1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == (("u",Decimal(3)),)
              assert Unit(10e1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == 10e1
              # Multiple Different Numerators
              assert Unit(10e1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(10e1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == ()
              assert Unit(10e1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(10e1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == 10e1
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(10e1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(10e1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).numerators   == (("nu",Decimal(1)),)
              assert Unit(10e1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).denominators == (("du",Decimal(1)),)
              assert Unit(10e1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).magnitude    == 10e1
              # Single Numerator and Denominator Higher Exponent
              assert Unit(10e1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
              assert Unit(10e1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).numerators   == (("nu",Decimal(2)),)
              assert Unit(10e1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).denominators == (("du",Decimal(3)),)
              assert Unit(10e1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).magnitude    == 10e1
              # Multiple Duplicate Numerators and Denominators
              assert Unit(10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).numerators   == (("nu",Decimal(3)),)
              assert Unit(10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).denominators == (("du",Decimal(2)),)
              assert Unit(10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).magnitude    == 10e1
              # Multiple Duplicate Numerators and Denominators Higher Exponent
              assert Unit(10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
              assert Unit(10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).numerators   == (("nu",Decimal(4)),)
              assert Unit(10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).denominators == (("du",Decimal(4)),)
              assert Unit(10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).magnitude    == 10e1
              # Multiple Different Numerators and Denominators
              assert Unit(10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
              assert Unit(10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).magnitude    == 10e1
            # Canceling
            if(True):
              # Single
              assert Unit(10e1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).symbols      == ()
              assert Unit(10e1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).numerators   == ()
              assert Unit(10e1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).denominators == ()
              assert Unit(10e1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).magnitude    == 10e1
              # Single Higher Exponent
              assert Unit(10e1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).symbols      == ()
              assert Unit(10e1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).numerators   == ()
              assert Unit(10e1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).denominators == ()
              assert Unit(10e1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).magnitude    == 10e1
              # Multiple Duplicate
              assert Unit(10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == 10e1
              # Multiple Duplicate Higher Exponent
              assert Unit(10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == 10e1
              # Multiple Different
              assert Unit(10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).symbols      == ()
              assert Unit(10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).numerators   == ()
              assert Unit(10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).denominators == ()
              assert Unit(10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).magnitude    == 10e1
              # Partial
              assert Unit(10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
              assert Unit(10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).numerators   == (("nua",Decimal(1)),)
              assert Unit(10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).denominators == (("nub",Decimal(1)),)
              assert Unit(10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).magnitude    == 10e1
          # Negative Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(-10e1,symbols=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(-10e1,symbols=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(-10e1,symbols=[("u",Decimal(1))]).denominators == ()
              assert Unit(-10e1,symbols=[("u",Decimal(1))]).magnitude    == -10e1
              # Single Numerator Higher Exponent
              assert Unit(-10e1,symbols=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(-10e1,symbols=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(-10e1,symbols=[("u",Decimal(2))]).denominators == ()
              assert Unit(-10e1,symbols=[("u",Decimal(2))]).magnitude    == -10e1
              # Multiple Duplicate Numerators
              assert Unit(-10e1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(-10e1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(-10e1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(-10e1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == -10e1
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(-10e1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(-10e1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(-10e1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(-10e1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == -10e1
              # Multiple Different Numerators
              assert Unit(-10e1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10e1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10e1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(-10e1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == -10e1
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(-10e1,numerators=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(-10e1,numerators=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(-10e1,numerators=[("u",Decimal(1))]).denominators == ()
              assert Unit(-10e1,numerators=[("u",Decimal(1))]).magnitude    == -10e1
              # Single Numerator Higher Exponent
              assert Unit(-10e1,numerators=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(-10e1,numerators=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(-10e1,numerators=[("u",Decimal(2))]).denominators == ()
              assert Unit(-10e1,numerators=[("u",Decimal(2))]).magnitude    == -10e1
              # Multiple Duplicate Numerators
              assert Unit(-10e1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(-10e1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(-10e1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(-10e1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == -10e1
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(-10e1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(-10e1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(-10e1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(-10e1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == -10e1
              # Multiple Different Numerators
              assert Unit(-10e1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10e1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10e1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(-10e1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == -10e1
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(-10e1,denominators=[("u",Decimal(1))]).symbols      == (("u",Decimal(-1)),)
              assert Unit(-10e1,denominators=[("u",Decimal(1))]).numerators   == ()
              assert Unit(-10e1,denominators=[("u",Decimal(1))]).denominators == (("u",Decimal(1)),)
              assert Unit(-10e1,denominators=[("u",Decimal(1))]).magnitude    == -10e1
              # Single Numerator Higher Exponent
              assert Unit(-10e1,denominators=[("u",Decimal(2))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(-10e1,denominators=[("u",Decimal(2))]).numerators   == ()
              assert Unit(-10e1,denominators=[("u",Decimal(2))]).denominators == (("u",Decimal(2)),)
              assert Unit(-10e1,denominators=[("u",Decimal(2))]).magnitude    == -10e1
              # Multiple Duplicate Numerators
              assert Unit(-10e1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(-10e1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == ()
              assert Unit(-10e1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == (("u",Decimal(2)),)
              assert Unit(-10e1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == -10e1
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(-10e1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(-3)),)
              assert Unit(-10e1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == ()
              assert Unit(-10e1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == (("u",Decimal(3)),)
              assert Unit(-10e1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == -10e1
              # Multiple Different Numerators
              assert Unit(-10e1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(-10e1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == ()
              assert Unit(-10e1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(-10e1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == -10e1
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(-10e1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(-10e1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).numerators   == (("nu",Decimal(1)),)
              assert Unit(-10e1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).denominators == (("du",Decimal(1)),)
              assert Unit(-10e1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).magnitude    == -10e1
              # Single Numerator and Denominator Higher Exponent
              assert Unit(-10e1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
              assert Unit(-10e1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).numerators   == (("nu",Decimal(2)),)
              assert Unit(-10e1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).denominators == (("du",Decimal(3)),)
              assert Unit(-10e1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).magnitude    == -10e1
              # Multiple Duplicate Numerators and Denominators
              assert Unit(-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).numerators   == (("nu",Decimal(3)),)
              assert Unit(-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).denominators == (("du",Decimal(2)),)
              assert Unit(-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).magnitude    == -10e1
              # Multiple Duplicate Numerators and Denominators Higher Exponent
              assert Unit(-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
              assert Unit(-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).numerators   == (("nu",Decimal(4)),)
              assert Unit(-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).denominators == (("du",Decimal(4)),)
              assert Unit(-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).magnitude    == -10e1
              # Multiple Different Numerators and Denominators
              assert Unit(-10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(-10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(-10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
              assert Unit(-10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).magnitude    == -10e1
            # Canceling
            if(True):
              # Single
              assert Unit(-10e1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).symbols      == ()
              assert Unit(-10e1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).numerators   == ()
              assert Unit(-10e1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).denominators == ()
              assert Unit(-10e1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).magnitude    == -10e1
              # Single Higher Exponent
              assert Unit(-10e1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).symbols      == ()
              assert Unit(-10e1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).numerators   == ()
              assert Unit(-10e1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).denominators == ()
              assert Unit(-10e1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).magnitude    == -10e1
              # Multiple Duplicate
              assert Unit(-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == -10e1
              # Multiple Duplicate Higher Exponent
              assert Unit(-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == -10e1
              # Multiple Different
              assert Unit(-10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).symbols      == ()
              assert Unit(-10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).numerators   == ()
              assert Unit(-10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).denominators == ()
              assert Unit(-10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).magnitude    == -10e1
              # Partial
              assert Unit(-10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
              assert Unit(-10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).numerators   == (("nua",Decimal(1)),)
              assert Unit(-10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).denominators == (("nub",Decimal(1)),)
              assert Unit(-10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).magnitude    == -10e1
      # Explicit Symbols, Magnitude str
      if(True):
        # Tuple of Strings
        if(True):
          # Positive Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit("10.1",symbols=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit("10.1",symbols=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit("10.1",symbols=["u"]).denominators == ()
              assert Unit("10.1",symbols=["u"]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators
              assert Unit("10.1",symbols=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit("10.1",symbols=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit("10.1",symbols=["u","u"]).denominators == ()
              assert Unit("10.1",symbols=["u","u"]).magnitude    == Decimal("10.1")
              # Multiple Different Numerators
              assert Unit("10.1",symbols=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("10.1",symbols=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("10.1",symbols=["ua","ub","ub"]).denominators == ()
              assert Unit("10.1",symbols=["ua","ub","ub"]).magnitude    == Decimal("10.1")
            # Numerators
            if(True):
              # Single Numerator
              assert Unit("10.1",numerators=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit("10.1",numerators=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit("10.1",numerators=["u"]).denominators == ()
              assert Unit("10.1",numerators=["u"]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators
              assert Unit("10.1",numerators=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit("10.1",numerators=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit("10.1",numerators=["u","u"]).denominators == ()
              assert Unit("10.1",numerators=["u","u"]).magnitude    == Decimal("10.1")
              # Multiple Different Numerators
              assert Unit("10.1",numerators=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("10.1",numerators=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("10.1",numerators=["ua","ub","ub"]).denominators == ()
              assert Unit("10.1",numerators=["ua","ub","ub"]).magnitude    == Decimal("10.1")
            # Denominators
            if(True):
              # Single Numerator
              assert Unit("10.1",denominators=["u"]).symbols      == (("u",Decimal(-1)),)
              assert Unit("10.1",denominators=["u"]).numerators   == ()
              assert Unit("10.1",denominators=["u"]).denominators == (("u",Decimal(1)),)
              assert Unit("10.1",denominators=["u"]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators
              assert Unit("10.1",denominators=["u","u"]).symbols      == (("u",Decimal(-2)),)
              assert Unit("10.1",denominators=["u","u"]).numerators   == ()
              assert Unit("10.1",denominators=["u","u"]).denominators == (("u",Decimal(2)),)
              assert Unit("10.1",denominators=["u","u"]).magnitude    == Decimal("10.1")
              # Multiple Different Numerators
              assert Unit("10.1",denominators=["ua","ub","ub"]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit("10.1",denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit("10.1",denominators=["ua","ub","ub"]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("10.1",denominators=["ua","ub","ub"]).magnitude    == Decimal("10.1")
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit("10.1",numerators=["nu"],denominators=["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit("10.1",numerators=["nu"],denominators=["du"]).numerators   == (("nu",Decimal(1)),)
              assert Unit("10.1",numerators=["nu"],denominators=["du"]).denominators == (("du",Decimal(1)),)
              assert Unit("10.1",numerators=["nu"],denominators=["du"]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators and Denominators
              assert Unit("10.1",numerators=["nu","nu","nu"],denominators=["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit("10.1",numerators=["nu","nu","nu"],denominators=["du","du"]).numerators   == (("nu",Decimal(3)),)
              assert Unit("10.1",numerators=["nu","nu","nu"],denominators=["du","du"]).denominators == (("du",Decimal(2)),)
              assert Unit("10.1",numerators=["nu","nu","nu"],denominators=["du","du"]).magnitude    == Decimal("10.1")
              # Multiple Different Numerators and Denominators
              assert Unit("10.1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit("10.1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit("10.1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
              assert Unit("10.1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).magnitude    == Decimal("10.1")
            # Canceling
            if(True):
              # Single
              assert Unit("10.1",numerators=["u"],denominators=["u"]).symbols      == ()
              assert Unit("10.1",numerators=["u"],denominators=["u"]).numerators   == ()
              assert Unit("10.1",numerators=["u"],denominators=["u"]).denominators == ()
              assert Unit("10.1",numerators=["u"],denominators=["u"]).magnitude    == Decimal("10.1")
              # Multiple Duplicate
              assert Unit("10.1",numerators=["u","u","u"],denominators=["u","u","u"]).symbols      == ()
              assert Unit("10.1",numerators=["u","u","u"],denominators=["u","u","u"]).numerators   == ()
              assert Unit("10.1",numerators=["u","u","u"],denominators=["u","u","u"]).denominators == ()
              assert Unit("10.1",numerators=["u","u","u"],denominators=["u","u","u"]).magnitude    == Decimal("10.1")
              # Multiple Different
              assert Unit("10.1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).symbols      == ()
              assert Unit("10.1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit("10.1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).denominators == ()
              assert Unit("10.1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).magnitude    == Decimal("10.1")
              # Partial Canceling
              assert Unit("10.1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).symbols      == (("ub",Decimal(1)),)
              assert Unit("10.1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).numerators   == (("ub",Decimal(1)),)
              assert Unit("10.1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).denominators == ()
              assert Unit("10.1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).magnitude    == Decimal("10.1")
          # Negative Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit("-10.1",symbols=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit("-10.1",symbols=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit("-10.1",symbols=["u"]).denominators == ()
              assert Unit("-10.1",symbols=["u"]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators
              assert Unit("-10.1",symbols=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit("-10.1",symbols=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit("-10.1",symbols=["u","u"]).denominators == ()
              assert Unit("-10.1",symbols=["u","u"]).magnitude    == Decimal("-10.1")
              # Multiple Different Numerators
              assert Unit("-10.1",symbols=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("-10.1",symbols=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("-10.1",symbols=["ua","ub","ub"]).denominators == ()
              assert Unit("-10.1",symbols=["ua","ub","ub"]).magnitude    == Decimal("-10.1")
            # Numerators
            if(True):
              # Single Numerator
              assert Unit("-10.1",numerators=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit("-10.1",numerators=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit("-10.1",numerators=["u"]).denominators == ()
              assert Unit("-10.1",numerators=["u"]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators
              assert Unit("-10.1",numerators=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit("-10.1",numerators=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit("-10.1",numerators=["u","u"]).denominators == ()
              assert Unit("-10.1",numerators=["u","u"]).magnitude    == Decimal("-10.1")
              # Multiple Different Numerators
              assert Unit("-10.1",numerators=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("-10.1",numerators=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("-10.1",numerators=["ua","ub","ub"]).denominators == ()
              assert Unit("-10.1",numerators=["ua","ub","ub"]).magnitude    == Decimal("-10.1")
            # Denominators
            if(True):
              # Single Numerator
              assert Unit("-10.1",denominators=["u"]).symbols      == (("u",Decimal(-1)),)
              assert Unit("-10.1",denominators=["u"]).numerators   == ()
              assert Unit("-10.1",denominators=["u"]).denominators == (("u",Decimal(1)),)
              assert Unit("-10.1",denominators=["u"]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators
              assert Unit("-10.1",denominators=["u","u"]).symbols      == (("u",Decimal(-2)),)
              assert Unit("-10.1",denominators=["u","u"]).numerators   == ()
              assert Unit("-10.1",denominators=["u","u"]).denominators == (("u",Decimal(2)),)
              assert Unit("-10.1",denominators=["u","u"]).magnitude    == Decimal("-10.1")
              # Multiple Different Numerators
              assert Unit("-10.1",denominators=["ua","ub","ub"]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit("-10.1",denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit("-10.1",denominators=["ua","ub","ub"]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("-10.1",denominators=["ua","ub","ub"]).magnitude    == Decimal("-10.1")
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit("-10.1",numerators=["nu"],denominators=["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit("-10.1",numerators=["nu"],denominators=["du"]).numerators   == (("nu",Decimal(1)),)
              assert Unit("-10.1",numerators=["nu"],denominators=["du"]).denominators == (("du",Decimal(1)),)
              assert Unit("-10.1",numerators=["nu"],denominators=["du"]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators and Denominators
              assert Unit("-10.1",numerators=["nu","nu","nu"],denominators=["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit("-10.1",numerators=["nu","nu","nu"],denominators=["du","du"]).numerators   == (("nu",Decimal(3)),)
              assert Unit("-10.1",numerators=["nu","nu","nu"],denominators=["du","du"]).denominators == (("du",Decimal(2)),)
              assert Unit("-10.1",numerators=["nu","nu","nu"],denominators=["du","du"]).magnitude    == Decimal("-10.1")
              # Multiple Different Numerators and Denominators
              assert Unit("-10.1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit("-10.1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit("-10.1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
              assert Unit("-10.1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).magnitude    == Decimal("-10.1")
            # Canceling
            if(True):
              # Single
              assert Unit("-10.1",numerators=["u"],denominators=["u"]).symbols      == ()
              assert Unit("-10.1",numerators=["u"],denominators=["u"]).numerators   == ()
              assert Unit("-10.1",numerators=["u"],denominators=["u"]).denominators == ()
              assert Unit("-10.1",numerators=["u"],denominators=["u"]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate
              assert Unit("-10.1",numerators=["u","u","u"],denominators=["u","u","u"]).symbols      == ()
              assert Unit("-10.1",numerators=["u","u","u"],denominators=["u","u","u"]).numerators   == ()
              assert Unit("-10.1",numerators=["u","u","u"],denominators=["u","u","u"]).denominators == ()
              assert Unit("-10.1",numerators=["u","u","u"],denominators=["u","u","u"]).magnitude    == Decimal("-10.1")
              # Multiple Different
              assert Unit("-10.1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).symbols      == ()
              assert Unit("-10.1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit("-10.1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).denominators == ()
              assert Unit("-10.1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).magnitude    == Decimal("-10.1")
              # Partial Canceling
              assert Unit("-10.1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).symbols      == (("ub",Decimal(1)),)
              assert Unit("-10.1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).numerators   == (("ub",Decimal(1)),)
              assert Unit("-10.1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).denominators == ()
              assert Unit("-10.1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).magnitude    == Decimal("-10.1")
        # Tuple of String, Exponent
        if(True):
          # Positive Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit("10.1",symbols=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit("10.1",symbols=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit("10.1",symbols=[("u",Decimal(1))]).denominators == ()
              assert Unit("10.1",symbols=[("u",Decimal(1))]).magnitude    == Decimal("10.1")
              # Single Numerator Higher Exponent
              assert Unit("10.1",symbols=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit("10.1",symbols=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit("10.1",symbols=[("u",Decimal(2))]).denominators == ()
              assert Unit("10.1",symbols=[("u",Decimal(2))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators
              assert Unit("10.1",symbols=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit("10.1",symbols=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit("10.1",symbols=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit("10.1",symbols=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit("10.1",symbols=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit("10.1",symbols=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit("10.1",symbols=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit("10.1",symbols=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("10.1")
              # Multiple Different Numerators
              assert Unit("10.1",symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("10.1",symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("10.1",symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit("10.1",symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("10.1")
            # Numerators
            if(True):
              # Single Numerator
              assert Unit("10.1",numerators=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit("10.1",numerators=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit("10.1",numerators=[("u",Decimal(1))]).denominators == ()
              assert Unit("10.1",numerators=[("u",Decimal(1))]).magnitude    == Decimal("10.1")
              # Single Numerator Higher Exponent
              assert Unit("10.1",numerators=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit("10.1",numerators=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit("10.1",numerators=[("u",Decimal(2))]).denominators == ()
              assert Unit("10.1",numerators=[("u",Decimal(2))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators
              assert Unit("10.1",numerators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit("10.1",numerators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit("10.1",numerators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit("10.1",numerators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit("10.1",numerators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit("10.1",numerators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit("10.1",numerators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit("10.1",numerators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("10.1")
              # Multiple Different Numerators
              assert Unit("10.1",numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("10.1",numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("10.1",numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit("10.1",numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("10.1")
            # Denominators
            if(True):
              # Single Numerator
              assert Unit("10.1",denominators=[("u",Decimal(1))]).symbols      == (("u",Decimal(-1)),)
              assert Unit("10.1",denominators=[("u",Decimal(1))]).numerators   == ()
              assert Unit("10.1",denominators=[("u",Decimal(1))]).denominators == (("u",Decimal(1)),)
              assert Unit("10.1",denominators=[("u",Decimal(1))]).magnitude    == Decimal("10.1")
              # Single Numerator Higher Exponent
              assert Unit("10.1",denominators=[("u",Decimal(2))]).symbols      == (("u",Decimal(-2)),)
              assert Unit("10.1",denominators=[("u",Decimal(2))]).numerators   == ()
              assert Unit("10.1",denominators=[("u",Decimal(2))]).denominators == (("u",Decimal(2)),)
              assert Unit("10.1",denominators=[("u",Decimal(2))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators
              assert Unit("10.1",denominators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(-2)),)
              assert Unit("10.1",denominators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == ()
              assert Unit("10.1",denominators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == (("u",Decimal(2)),)
              assert Unit("10.1",denominators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit("10.1",denominators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(-3)),)
              assert Unit("10.1",denominators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == ()
              assert Unit("10.1",denominators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == (("u",Decimal(3)),)
              assert Unit("10.1",denominators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("10.1")
              # Multiple Different Numerators
              assert Unit("10.1",denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit("10.1",denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == ()
              assert Unit("10.1",denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("10.1",denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("10.1")
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit("10.1",numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit("10.1",numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).numerators   == (("nu",Decimal(1)),)
              assert Unit("10.1",numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).denominators == (("du",Decimal(1)),)
              assert Unit("10.1",numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).magnitude    == Decimal("10.1")
              # Single Numerator and Denominator Higher Exponent
              assert Unit("10.1",numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
              assert Unit("10.1",numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).numerators   == (("nu",Decimal(2)),)
              assert Unit("10.1",numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).denominators == (("du",Decimal(3)),)
              assert Unit("10.1",numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators and Denominators
              assert Unit("10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit("10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).numerators   == (("nu",Decimal(3)),)
              assert Unit("10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).denominators == (("du",Decimal(2)),)
              assert Unit("10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators and Denominators Higher Exponent
              assert Unit("10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
              assert Unit("10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).numerators   == (("nu",Decimal(4)),)
              assert Unit("10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).denominators == (("du",Decimal(4)),)
              assert Unit("10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).magnitude    == Decimal("10.1")
              # Multiple Different Numerators and Denominators
              assert Unit("10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit("10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit("10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
              assert Unit("10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).magnitude    == Decimal("10.1")
            # Canceling
            if(True):
              # Single
              assert Unit("10.1",numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).symbols      == ()
              assert Unit("10.1",numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).numerators   == ()
              assert Unit("10.1",numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).denominators == ()
              assert Unit("10.1",numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).magnitude    == Decimal("10.1")
              # Single Higher Exponent
              assert Unit("10.1",numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).symbols      == ()
              assert Unit("10.1",numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).numerators   == ()
              assert Unit("10.1",numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).denominators == ()
              assert Unit("10.1",numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate
              assert Unit("10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit("10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit("10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit("10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Higher Exponent
              assert Unit("10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit("10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit("10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit("10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal("10.1")
              # Multiple Different
              assert Unit("10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).symbols      == ()
              assert Unit("10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).numerators   == ()
              assert Unit("10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).denominators == ()
              assert Unit("10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal("10.1")
              # Partial
              assert Unit("10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
              assert Unit("10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).numerators   == (("nua",Decimal(1)),)
              assert Unit("10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).denominators == (("nub",Decimal(1)),)
              assert Unit("10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal("10.1")
          # Negative Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit("-10.1",symbols=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit("-10.1",symbols=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit("-10.1",symbols=[("u",Decimal(1))]).denominators == ()
              assert Unit("-10.1",symbols=[("u",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Single Numerator Higher Exponent
              assert Unit("-10.1",symbols=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit("-10.1",symbols=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit("-10.1",symbols=[("u",Decimal(2))]).denominators == ()
              assert Unit("-10.1",symbols=[("u",Decimal(2))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators
              assert Unit("-10.1",symbols=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit("-10.1",symbols=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit("-10.1",symbols=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit("-10.1",symbols=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit("-10.1",symbols=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit("-10.1",symbols=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit("-10.1",symbols=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit("-10.1",symbols=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("-10.1")
              # Multiple Different Numerators
              assert Unit("-10.1",symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("-10.1",symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("-10.1",symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit("-10.1",symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("-10.1")
            # Numerators
            if(True):
              # Single Numerator
              assert Unit("-10.1",numerators=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit("-10.1",numerators=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit("-10.1",numerators=[("u",Decimal(1))]).denominators == ()
              assert Unit("-10.1",numerators=[("u",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Single Numerator Higher Exponent
              assert Unit("-10.1",numerators=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit("-10.1",numerators=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit("-10.1",numerators=[("u",Decimal(2))]).denominators == ()
              assert Unit("-10.1",numerators=[("u",Decimal(2))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators
              assert Unit("-10.1",numerators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit("-10.1",numerators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit("-10.1",numerators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit("-10.1",numerators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit("-10.1",numerators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit("-10.1",numerators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit("-10.1",numerators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit("-10.1",numerators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("-10.1")
              # Multiple Different Numerators
              assert Unit("-10.1",numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("-10.1",numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("-10.1",numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit("-10.1",numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("-10.1")
            # Denominators
            if(True):
              # Single Numerator
              assert Unit("-10.1",denominators=[("u",Decimal(1))]).symbols      == (("u",Decimal(-1)),)
              assert Unit("-10.1",denominators=[("u",Decimal(1))]).numerators   == ()
              assert Unit("-10.1",denominators=[("u",Decimal(1))]).denominators == (("u",Decimal(1)),)
              assert Unit("-10.1",denominators=[("u",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Single Numerator Higher Exponent
              assert Unit("-10.1",denominators=[("u",Decimal(2))]).symbols      == (("u",Decimal(-2)),)
              assert Unit("-10.1",denominators=[("u",Decimal(2))]).numerators   == ()
              assert Unit("-10.1",denominators=[("u",Decimal(2))]).denominators == (("u",Decimal(2)),)
              assert Unit("-10.1",denominators=[("u",Decimal(2))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators
              assert Unit("-10.1",denominators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(-2)),)
              assert Unit("-10.1",denominators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == ()
              assert Unit("-10.1",denominators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == (("u",Decimal(2)),)
              assert Unit("-10.1",denominators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit("-10.1",denominators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(-3)),)
              assert Unit("-10.1",denominators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == ()
              assert Unit("-10.1",denominators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == (("u",Decimal(3)),)
              assert Unit("-10.1",denominators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("-10.1")
              # Multiple Different Numerators
              assert Unit("-10.1",denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit("-10.1",denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == ()
              assert Unit("-10.1",denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("-10.1",denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("-10.1")
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit("-10.1",numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit("-10.1",numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).numerators   == (("nu",Decimal(1)),)
              assert Unit("-10.1",numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).denominators == (("du",Decimal(1)),)
              assert Unit("-10.1",numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Single Numerator and Denominator Higher Exponent
              assert Unit("-10.1",numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
              assert Unit("-10.1",numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).numerators   == (("nu",Decimal(2)),)
              assert Unit("-10.1",numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).denominators == (("du",Decimal(3)),)
              assert Unit("-10.1",numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators and Denominators
              assert Unit("-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit("-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).numerators   == (("nu",Decimal(3)),)
              assert Unit("-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).denominators == (("du",Decimal(2)),)
              assert Unit("-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators and Denominators Higher Exponent
              assert Unit("-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
              assert Unit("-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).numerators   == (("nu",Decimal(4)),)
              assert Unit("-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).denominators == (("du",Decimal(4)),)
              assert Unit("-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Multiple Different Numerators and Denominators
              assert Unit("-10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit("-10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit("-10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
              assert Unit("-10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).magnitude    == Decimal("-10.1")
            # Canceling
            if(True):
              # Single
              assert Unit("-10.1",numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).symbols      == ()
              assert Unit("-10.1",numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).numerators   == ()
              assert Unit("-10.1",numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).denominators == ()
              assert Unit("-10.1",numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Single Higher Exponent
              assert Unit("-10.1",numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).symbols      == ()
              assert Unit("-10.1",numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).numerators   == ()
              assert Unit("-10.1",numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).denominators == ()
              assert Unit("-10.1",numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate
              assert Unit("-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit("-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit("-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit("-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Higher Exponent
              assert Unit("-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit("-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit("-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit("-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Multiple Different
              assert Unit("-10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).symbols      == ()
              assert Unit("-10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).numerators   == ()
              assert Unit("-10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).denominators == ()
              assert Unit("-10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Partial
              assert Unit("-10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
              assert Unit("-10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).numerators   == (("nua",Decimal(1)),)
              assert Unit("-10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).denominators == (("nub",Decimal(1)),)
              assert Unit("-10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal("-10.1")
        # Tuple of Strings
        if(True):
          # Positive Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit("10e1",symbols=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit("10e1",symbols=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit("10e1",symbols=["u"]).denominators == ()
              assert Unit("10e1",symbols=["u"]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators
              assert Unit("10e1",symbols=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit("10e1",symbols=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit("10e1",symbols=["u","u"]).denominators == ()
              assert Unit("10e1",symbols=["u","u"]).magnitude    == Decimal("10e1")
              # Multiple Different Numerators
              assert Unit("10e1",symbols=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("10e1",symbols=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("10e1",symbols=["ua","ub","ub"]).denominators == ()
              assert Unit("10e1",symbols=["ua","ub","ub"]).magnitude    == Decimal("10e1")
            # Numerators
            if(True):
              # Single Numerator
              assert Unit("10e1",numerators=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit("10e1",numerators=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit("10e1",numerators=["u"]).denominators == ()
              assert Unit("10e1",numerators=["u"]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators
              assert Unit("10e1",numerators=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit("10e1",numerators=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit("10e1",numerators=["u","u"]).denominators == ()
              assert Unit("10e1",numerators=["u","u"]).magnitude    == Decimal("10e1")
              # Multiple Different Numerators
              assert Unit("10e1",numerators=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("10e1",numerators=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("10e1",numerators=["ua","ub","ub"]).denominators == ()
              assert Unit("10e1",numerators=["ua","ub","ub"]).magnitude    == Decimal("10e1")
            # Denominators
            if(True):
              # Single Numerator
              assert Unit("10e1",denominators=["u"]).symbols      == (("u",Decimal(-1)),)
              assert Unit("10e1",denominators=["u"]).numerators   == ()
              assert Unit("10e1",denominators=["u"]).denominators == (("u",Decimal(1)),)
              assert Unit("10e1",denominators=["u"]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators
              assert Unit("10e1",denominators=["u","u"]).symbols      == (("u",Decimal(-2)),)
              assert Unit("10e1",denominators=["u","u"]).numerators   == ()
              assert Unit("10e1",denominators=["u","u"]).denominators == (("u",Decimal(2)),)
              assert Unit("10e1",denominators=["u","u"]).magnitude    == Decimal("10e1")
              # Multiple Different Numerators
              assert Unit("10e1",denominators=["ua","ub","ub"]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit("10e1",denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit("10e1",denominators=["ua","ub","ub"]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("10e1",denominators=["ua","ub","ub"]).magnitude    == Decimal("10e1")
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit("10e1",numerators=["nu"],denominators=["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit("10e1",numerators=["nu"],denominators=["du"]).numerators   == (("nu",Decimal(1)),)
              assert Unit("10e1",numerators=["nu"],denominators=["du"]).denominators == (("du",Decimal(1)),)
              assert Unit("10e1",numerators=["nu"],denominators=["du"]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators and Denominators
              assert Unit("10e1",numerators=["nu","nu","nu"],denominators=["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit("10e1",numerators=["nu","nu","nu"],denominators=["du","du"]).numerators   == (("nu",Decimal(3)),)
              assert Unit("10e1",numerators=["nu","nu","nu"],denominators=["du","du"]).denominators == (("du",Decimal(2)),)
              assert Unit("10e1",numerators=["nu","nu","nu"],denominators=["du","du"]).magnitude    == Decimal("10e1")
              # Multiple Different Numerators and Denominators
              assert Unit("10e1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit("10e1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit("10e1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
              assert Unit("10e1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).magnitude    == Decimal("10e1")
            # Canceling
            if(True):
              # Single
              assert Unit("10e1",numerators=["u"],denominators=["u"]).symbols      == ()
              assert Unit("10e1",numerators=["u"],denominators=["u"]).numerators   == ()
              assert Unit("10e1",numerators=["u"],denominators=["u"]).denominators == ()
              assert Unit("10e1",numerators=["u"],denominators=["u"]).magnitude    == Decimal("10e1")
              # Multiple Duplicate
              assert Unit("10e1",numerators=["u","u","u"],denominators=["u","u","u"]).symbols      == ()
              assert Unit("10e1",numerators=["u","u","u"],denominators=["u","u","u"]).numerators   == ()
              assert Unit("10e1",numerators=["u","u","u"],denominators=["u","u","u"]).denominators == ()
              assert Unit("10e1",numerators=["u","u","u"],denominators=["u","u","u"]).magnitude    == Decimal("10e1")
              # Multiple Different
              assert Unit("10e1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).symbols      == ()
              assert Unit("10e1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit("10e1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).denominators == ()
              assert Unit("10e1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).magnitude    == Decimal("10e1")
              # Partial Canceling
              assert Unit("10e1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).symbols      == (("ub",Decimal(1)),)
              assert Unit("10e1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).numerators   == (("ub",Decimal(1)),)
              assert Unit("10e1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).denominators == ()
              assert Unit("10e1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).magnitude    == Decimal("10e1")
          # Negative Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit("-10e1",symbols=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit("-10e1",symbols=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit("-10e1",symbols=["u"]).denominators == ()
              assert Unit("-10e1",symbols=["u"]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators
              assert Unit("-10e1",symbols=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit("-10e1",symbols=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit("-10e1",symbols=["u","u"]).denominators == ()
              assert Unit("-10e1",symbols=["u","u"]).magnitude    == Decimal("-10e1")
              # Multiple Different Numerators
              assert Unit("-10e1",symbols=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("-10e1",symbols=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("-10e1",symbols=["ua","ub","ub"]).denominators == ()
              assert Unit("-10e1",symbols=["ua","ub","ub"]).magnitude    == Decimal("-10e1")
            # Numerators
            if(True):
              # Single Numerator
              assert Unit("-10e1",numerators=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit("-10e1",numerators=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit("-10e1",numerators=["u"]).denominators == ()
              assert Unit("-10e1",numerators=["u"]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators
              assert Unit("-10e1",numerators=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit("-10e1",numerators=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit("-10e1",numerators=["u","u"]).denominators == ()
              assert Unit("-10e1",numerators=["u","u"]).magnitude    == Decimal("-10e1")
              # Multiple Different Numerators
              assert Unit("-10e1",numerators=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("-10e1",numerators=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("-10e1",numerators=["ua","ub","ub"]).denominators == ()
              assert Unit("-10e1",numerators=["ua","ub","ub"]).magnitude    == Decimal("-10e1")
            # Denominators
            if(True):
              # Single Numerator
              assert Unit("-10e1",denominators=["u"]).symbols      == (("u",Decimal(-1)),)
              assert Unit("-10e1",denominators=["u"]).numerators   == ()
              assert Unit("-10e1",denominators=["u"]).denominators == (("u",Decimal(1)),)
              assert Unit("-10e1",denominators=["u"]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators
              assert Unit("-10e1",denominators=["u","u"]).symbols      == (("u",Decimal(-2)),)
              assert Unit("-10e1",denominators=["u","u"]).numerators   == ()
              assert Unit("-10e1",denominators=["u","u"]).denominators == (("u",Decimal(2)),)
              assert Unit("-10e1",denominators=["u","u"]).magnitude    == Decimal("-10e1")
              # Multiple Different Numerators
              assert Unit("-10e1",denominators=["ua","ub","ub"]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit("-10e1",denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit("-10e1",denominators=["ua","ub","ub"]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("-10e1",denominators=["ua","ub","ub"]).magnitude    == Decimal("-10e1")
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit("-10e1",numerators=["nu"],denominators=["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit("-10e1",numerators=["nu"],denominators=["du"]).numerators   == (("nu",Decimal(1)),)
              assert Unit("-10e1",numerators=["nu"],denominators=["du"]).denominators == (("du",Decimal(1)),)
              assert Unit("-10e1",numerators=["nu"],denominators=["du"]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators and Denominators
              assert Unit("-10e1",numerators=["nu","nu","nu"],denominators=["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit("-10e1",numerators=["nu","nu","nu"],denominators=["du","du"]).numerators   == (("nu",Decimal(3)),)
              assert Unit("-10e1",numerators=["nu","nu","nu"],denominators=["du","du"]).denominators == (("du",Decimal(2)),)
              assert Unit("-10e1",numerators=["nu","nu","nu"],denominators=["du","du"]).magnitude    == Decimal("-10e1")
              # Multiple Different Numerators and Denominators
              assert Unit("-10e1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit("-10e1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit("-10e1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
              assert Unit("-10e1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).magnitude    == Decimal("-10e1")
            # Canceling
            if(True):
              # Single
              assert Unit("-10e1",numerators=["u"],denominators=["u"]).symbols      == ()
              assert Unit("-10e1",numerators=["u"],denominators=["u"]).numerators   == ()
              assert Unit("-10e1",numerators=["u"],denominators=["u"]).denominators == ()
              assert Unit("-10e1",numerators=["u"],denominators=["u"]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate
              assert Unit("-10e1",numerators=["u","u","u"],denominators=["u","u","u"]).symbols      == ()
              assert Unit("-10e1",numerators=["u","u","u"],denominators=["u","u","u"]).numerators   == ()
              assert Unit("-10e1",numerators=["u","u","u"],denominators=["u","u","u"]).denominators == ()
              assert Unit("-10e1",numerators=["u","u","u"],denominators=["u","u","u"]).magnitude    == Decimal("-10e1")
              # Multiple Different
              assert Unit("-10e1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).symbols      == ()
              assert Unit("-10e1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit("-10e1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).denominators == ()
              assert Unit("-10e1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).magnitude    == Decimal("-10e1")
              # Partial Canceling
              assert Unit("-10e1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).symbols      == (("ub",Decimal(1)),)
              assert Unit("-10e1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).numerators   == (("ub",Decimal(1)),)
              assert Unit("-10e1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).denominators == ()
              assert Unit("-10e1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).magnitude    == Decimal("-10e1")
        # Tuple of String, Exponent
        if(True):
          # Positive Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit("10e1",symbols=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit("10e1",symbols=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit("10e1",symbols=[("u",Decimal(1))]).denominators == ()
              assert Unit("10e1",symbols=[("u",Decimal(1))]).magnitude    == Decimal("10e1")
              # Single Numerator Higher Exponent
              assert Unit("10e1",symbols=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit("10e1",symbols=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit("10e1",symbols=[("u",Decimal(2))]).denominators == ()
              assert Unit("10e1",symbols=[("u",Decimal(2))]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators
              assert Unit("10e1",symbols=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit("10e1",symbols=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit("10e1",symbols=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit("10e1",symbols=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit("10e1",symbols=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit("10e1",symbols=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit("10e1",symbols=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit("10e1",symbols=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("10e1")
              # Multiple Different Numerators
              assert Unit("10e1",symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("10e1",symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("10e1",symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit("10e1",symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("10e1")
            # Numerators
            if(True):
              # Single Numerator
              assert Unit("10e1",numerators=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit("10e1",numerators=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit("10e1",numerators=[("u",Decimal(1))]).denominators == ()
              assert Unit("10e1",numerators=[("u",Decimal(1))]).magnitude    == Decimal("10e1")
              # Single Numerator Higher Exponent
              assert Unit("10e1",numerators=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit("10e1",numerators=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit("10e1",numerators=[("u",Decimal(2))]).denominators == ()
              assert Unit("10e1",numerators=[("u",Decimal(2))]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators
              assert Unit("10e1",numerators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit("10e1",numerators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit("10e1",numerators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit("10e1",numerators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit("10e1",numerators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit("10e1",numerators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit("10e1",numerators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit("10e1",numerators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("10e1")
              # Multiple Different Numerators
              assert Unit("10e1",numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("10e1",numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("10e1",numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit("10e1",numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("10e1")
            # Denominators
            if(True):
              # Single Numerator
              assert Unit("10e1",denominators=[("u",Decimal(1))]).symbols      == (("u",Decimal(-1)),)
              assert Unit("10e1",denominators=[("u",Decimal(1))]).numerators   == ()
              assert Unit("10e1",denominators=[("u",Decimal(1))]).denominators == (("u",Decimal(1)),)
              assert Unit("10e1",denominators=[("u",Decimal(1))]).magnitude    == Decimal("10e1")
              # Single Numerator Higher Exponent
              assert Unit("10e1",denominators=[("u",Decimal(2))]).symbols      == (("u",Decimal(-2)),)
              assert Unit("10e1",denominators=[("u",Decimal(2))]).numerators   == ()
              assert Unit("10e1",denominators=[("u",Decimal(2))]).denominators == (("u",Decimal(2)),)
              assert Unit("10e1",denominators=[("u",Decimal(2))]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators
              assert Unit("10e1",denominators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(-2)),)
              assert Unit("10e1",denominators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == ()
              assert Unit("10e1",denominators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == (("u",Decimal(2)),)
              assert Unit("10e1",denominators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit("10e1",denominators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(-3)),)
              assert Unit("10e1",denominators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == ()
              assert Unit("10e1",denominators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == (("u",Decimal(3)),)
              assert Unit("10e1",denominators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("10e1")
              # Multiple Different Numerators
              assert Unit("10e1",denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit("10e1",denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == ()
              assert Unit("10e1",denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("10e1",denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("10e1")
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit("10e1",numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit("10e1",numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).numerators   == (("nu",Decimal(1)),)
              assert Unit("10e1",numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).denominators == (("du",Decimal(1)),)
              assert Unit("10e1",numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).magnitude    == Decimal("10e1")
              # Single Numerator and Denominator Higher Exponent
              assert Unit("10e1",numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
              assert Unit("10e1",numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).numerators   == (("nu",Decimal(2)),)
              assert Unit("10e1",numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).denominators == (("du",Decimal(3)),)
              assert Unit("10e1",numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators and Denominators
              assert Unit("10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit("10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).numerators   == (("nu",Decimal(3)),)
              assert Unit("10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).denominators == (("du",Decimal(2)),)
              assert Unit("10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators and Denominators Higher Exponent
              assert Unit("10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
              assert Unit("10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).numerators   == (("nu",Decimal(4)),)
              assert Unit("10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).denominators == (("du",Decimal(4)),)
              assert Unit("10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).magnitude    == Decimal("10e1")
              # Multiple Different Numerators and Denominators
              assert Unit("10e1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit("10e1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit("10e1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
              assert Unit("10e1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).magnitude    == Decimal("10e1")
            # Canceling
            if(True):
              # Single
              assert Unit("10e1",numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).symbols      == ()
              assert Unit("10e1",numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).numerators   == ()
              assert Unit("10e1",numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).denominators == ()
              assert Unit("10e1",numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).magnitude    == Decimal("10e1")
              # Single Higher Exponent
              assert Unit("10e1",numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).symbols      == ()
              assert Unit("10e1",numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).numerators   == ()
              assert Unit("10e1",numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).denominators == ()
              assert Unit("10e1",numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).magnitude    == Decimal("10e1")
              # Multiple Duplicate
              assert Unit("10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit("10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit("10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit("10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Higher Exponent
              assert Unit("10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit("10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit("10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit("10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal("10e1")
              # Multiple Different
              assert Unit("10e1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).symbols      == ()
              assert Unit("10e1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).numerators   == ()
              assert Unit("10e1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).denominators == ()
              assert Unit("10e1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal("10e1")
              # Partial
              assert Unit("10e1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
              assert Unit("10e1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).numerators   == (("nua",Decimal(1)),)
              assert Unit("10e1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).denominators == (("nub",Decimal(1)),)
              assert Unit("10e1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal("10e1")
          # Negative Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit("-10e1",symbols=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit("-10e1",symbols=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit("-10e1",symbols=[("u",Decimal(1))]).denominators == ()
              assert Unit("-10e1",symbols=[("u",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Single Numerator Higher Exponent
              assert Unit("-10e1",symbols=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit("-10e1",symbols=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit("-10e1",symbols=[("u",Decimal(2))]).denominators == ()
              assert Unit("-10e1",symbols=[("u",Decimal(2))]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators
              assert Unit("-10e1",symbols=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit("-10e1",symbols=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit("-10e1",symbols=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit("-10e1",symbols=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit("-10e1",symbols=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit("-10e1",symbols=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit("-10e1",symbols=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit("-10e1",symbols=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("-10e1")
              # Multiple Different Numerators
              assert Unit("-10e1",symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("-10e1",symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("-10e1",symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit("-10e1",symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("-10e1")
            # Numerators
            if(True):
              # Single Numerator
              assert Unit("-10e1",numerators=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit("-10e1",numerators=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit("-10e1",numerators=[("u",Decimal(1))]).denominators == ()
              assert Unit("-10e1",numerators=[("u",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Single Numerator Higher Exponent
              assert Unit("-10e1",numerators=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit("-10e1",numerators=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit("-10e1",numerators=[("u",Decimal(2))]).denominators == ()
              assert Unit("-10e1",numerators=[("u",Decimal(2))]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators
              assert Unit("-10e1",numerators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit("-10e1",numerators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit("-10e1",numerators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit("-10e1",numerators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit("-10e1",numerators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit("-10e1",numerators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit("-10e1",numerators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit("-10e1",numerators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("-10e1")
              # Multiple Different Numerators
              assert Unit("-10e1",numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("-10e1",numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("-10e1",numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit("-10e1",numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("-10e1")
            # Denominators
            if(True):
              # Single Numerator
              assert Unit("-10e1",denominators=[("u",Decimal(1))]).symbols      == (("u",Decimal(-1)),)
              assert Unit("-10e1",denominators=[("u",Decimal(1))]).numerators   == ()
              assert Unit("-10e1",denominators=[("u",Decimal(1))]).denominators == (("u",Decimal(1)),)
              assert Unit("-10e1",denominators=[("u",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Single Numerator Higher Exponent
              assert Unit("-10e1",denominators=[("u",Decimal(2))]).symbols      == (("u",Decimal(-2)),)
              assert Unit("-10e1",denominators=[("u",Decimal(2))]).numerators   == ()
              assert Unit("-10e1",denominators=[("u",Decimal(2))]).denominators == (("u",Decimal(2)),)
              assert Unit("-10e1",denominators=[("u",Decimal(2))]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators
              assert Unit("-10e1",denominators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(-2)),)
              assert Unit("-10e1",denominators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == ()
              assert Unit("-10e1",denominators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == (("u",Decimal(2)),)
              assert Unit("-10e1",denominators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit("-10e1",denominators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(-3)),)
              assert Unit("-10e1",denominators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == ()
              assert Unit("-10e1",denominators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == (("u",Decimal(3)),)
              assert Unit("-10e1",denominators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("-10e1")
              # Multiple Different Numerators
              assert Unit("-10e1",denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit("-10e1",denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == ()
              assert Unit("-10e1",denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit("-10e1",denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("-10e1")
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit("-10e1",numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit("-10e1",numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).numerators   == (("nu",Decimal(1)),)
              assert Unit("-10e1",numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).denominators == (("du",Decimal(1)),)
              assert Unit("-10e1",numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Single Numerator and Denominator Higher Exponent
              assert Unit("-10e1",numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
              assert Unit("-10e1",numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).numerators   == (("nu",Decimal(2)),)
              assert Unit("-10e1",numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).denominators == (("du",Decimal(3)),)
              assert Unit("-10e1",numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators and Denominators
              assert Unit("-10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit("-10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).numerators   == (("nu",Decimal(3)),)
              assert Unit("-10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).denominators == (("du",Decimal(2)),)
              assert Unit("-10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators and Denominators Higher Exponent
              assert Unit("-10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
              assert Unit("-10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).numerators   == (("nu",Decimal(4)),)
              assert Unit("-10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).denominators == (("du",Decimal(4)),)
              assert Unit("-10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Multiple Different Numerators and Denominators
              assert Unit("-10e1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit("-10e1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit("-10e1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
              assert Unit("-10e1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).magnitude    == Decimal("-10e1")
            # Canceling
            if(True):
              # Single
              assert Unit("-10e1",numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).symbols      == ()
              assert Unit("-10e1",numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).numerators   == ()
              assert Unit("-10e1",numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).denominators == ()
              assert Unit("-10e1",numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Single Higher Exponent
              assert Unit("-10e1",numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).symbols      == ()
              assert Unit("-10e1",numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).numerators   == ()
              assert Unit("-10e1",numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).denominators == ()
              assert Unit("-10e1",numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate
              assert Unit("-10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit("-10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit("-10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit("-10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Higher Exponent
              assert Unit("-10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit("-10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit("-10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit("-10e1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Multiple Different
              assert Unit("-10e1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).symbols      == ()
              assert Unit("-10e1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).numerators   == ()
              assert Unit("-10e1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).denominators == ()
              assert Unit("-10e1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Partial
              assert Unit("-10e1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
              assert Unit("-10e1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).numerators   == (("nua",Decimal(1)),)
              assert Unit("-10e1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).denominators == (("nub",Decimal(1)),)
              assert Unit("-10e1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal("-10e1")
      # Explicit Symbols, Magnitude Decimal
      if(True):
        # Tuple of Strings
        if(True):
          # Positive Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(Decimal("10.1"),symbols=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(Decimal("10.1"),symbols=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(Decimal("10.1"),symbols=["u"]).denominators == ()
              assert Unit(Decimal("10.1"),symbols=["u"]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators
              assert Unit(Decimal("10.1"),symbols=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(Decimal("10.1"),symbols=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(Decimal("10.1"),symbols=["u","u"]).denominators == ()
              assert Unit(Decimal("10.1"),symbols=["u","u"]).magnitude    == Decimal("10.1")
              # Multiple Different Numerators
              assert Unit(Decimal("10.1"),symbols=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("10.1"),symbols=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("10.1"),symbols=["ua","ub","ub"]).denominators == ()
              assert Unit(Decimal("10.1"),symbols=["ua","ub","ub"]).magnitude    == Decimal("10.1")
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(Decimal("10.1"),numerators=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(Decimal("10.1"),numerators=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(Decimal("10.1"),numerators=["u"]).denominators == ()
              assert Unit(Decimal("10.1"),numerators=["u"]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators
              assert Unit(Decimal("10.1"),numerators=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(Decimal("10.1"),numerators=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(Decimal("10.1"),numerators=["u","u"]).denominators == ()
              assert Unit(Decimal("10.1"),numerators=["u","u"]).magnitude    == Decimal("10.1")
              # Multiple Different Numerators
              assert Unit(Decimal("10.1"),numerators=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("10.1"),numerators=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("10.1"),numerators=["ua","ub","ub"]).denominators == ()
              assert Unit(Decimal("10.1"),numerators=["ua","ub","ub"]).magnitude    == Decimal("10.1")
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(Decimal("10.1"),denominators=["u"]).symbols      == (("u",Decimal(-1)),)
              assert Unit(Decimal("10.1"),denominators=["u"]).numerators   == ()
              assert Unit(Decimal("10.1"),denominators=["u"]).denominators == (("u",Decimal(1)),)
              assert Unit(Decimal("10.1"),denominators=["u"]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators
              assert Unit(Decimal("10.1"),denominators=["u","u"]).symbols      == (("u",Decimal(-2)),)
              assert Unit(Decimal("10.1"),denominators=["u","u"]).numerators   == ()
              assert Unit(Decimal("10.1"),denominators=["u","u"]).denominators == (("u",Decimal(2)),)
              assert Unit(Decimal("10.1"),denominators=["u","u"]).magnitude    == Decimal("10.1")
              # Multiple Different Numerators
              assert Unit(Decimal("10.1"),denominators=["ua","ub","ub"]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(Decimal("10.1"),denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(Decimal("10.1"),denominators=["ua","ub","ub"]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("10.1"),denominators=["ua","ub","ub"]).magnitude    == Decimal("10.1")
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(Decimal("10.1"),numerators=["nu"],denominators=["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(Decimal("10.1"),numerators=["nu"],denominators=["du"]).numerators   == (("nu",Decimal(1)),)
              assert Unit(Decimal("10.1"),numerators=["nu"],denominators=["du"]).denominators == (("du",Decimal(1)),)
              assert Unit(Decimal("10.1"),numerators=["nu"],denominators=["du"]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators and Denominators
              assert Unit(Decimal("10.1"),numerators=["nu","nu","nu"],denominators=["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(Decimal("10.1"),numerators=["nu","nu","nu"],denominators=["du","du"]).numerators   == (("nu",Decimal(3)),)
              assert Unit(Decimal("10.1"),numerators=["nu","nu","nu"],denominators=["du","du"]).denominators == (("du",Decimal(2)),)
              assert Unit(Decimal("10.1"),numerators=["nu","nu","nu"],denominators=["du","du"]).magnitude    == Decimal("10.1")
              # Multiple Different Numerators and Denominators
              assert Unit(Decimal("10.1"),numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(Decimal("10.1"),numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(Decimal("10.1"),numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
              assert Unit(Decimal("10.1"),numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).magnitude    == Decimal("10.1")
            # Canceling
            if(True):
              # Single
              assert Unit(Decimal("10.1"),numerators=["u"],denominators=["u"]).symbols      == ()
              assert Unit(Decimal("10.1"),numerators=["u"],denominators=["u"]).numerators   == ()
              assert Unit(Decimal("10.1"),numerators=["u"],denominators=["u"]).denominators == ()
              assert Unit(Decimal("10.1"),numerators=["u"],denominators=["u"]).magnitude    == Decimal("10.1")
              # Multiple Duplicate
              assert Unit(Decimal("10.1"),numerators=["u","u","u"],denominators=["u","u","u"]).symbols      == ()
              assert Unit(Decimal("10.1"),numerators=["u","u","u"],denominators=["u","u","u"]).numerators   == ()
              assert Unit(Decimal("10.1"),numerators=["u","u","u"],denominators=["u","u","u"]).denominators == ()
              assert Unit(Decimal("10.1"),numerators=["u","u","u"],denominators=["u","u","u"]).magnitude    == Decimal("10.1")
              # Multiple Different
              assert Unit(Decimal("10.1"),numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).symbols      == ()
              assert Unit(Decimal("10.1"),numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(Decimal("10.1"),numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).denominators == ()
              assert Unit(Decimal("10.1"),numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).magnitude    == Decimal("10.1")
              # Partial Canceling
              assert Unit(Decimal("10.1"),numerators=["ua","ub","ub"],denominators=["ua","ub"]).symbols      == (("ub",Decimal(1)),)
              assert Unit(Decimal("10.1"),numerators=["ua","ub","ub"],denominators=["ua","ub"]).numerators   == (("ub",Decimal(1)),)
              assert Unit(Decimal("10.1"),numerators=["ua","ub","ub"],denominators=["ua","ub"]).denominators == ()
              assert Unit(Decimal("10.1"),numerators=["ua","ub","ub"],denominators=["ua","ub"]).magnitude    == Decimal("10.1")
          # Negative Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(Decimal("-10.1"),symbols=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(Decimal("-10.1"),symbols=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(Decimal("-10.1"),symbols=["u"]).denominators == ()
              assert Unit(Decimal("-10.1"),symbols=["u"]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators
              assert Unit(Decimal("-10.1"),symbols=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(Decimal("-10.1"),symbols=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(Decimal("-10.1"),symbols=["u","u"]).denominators == ()
              assert Unit(Decimal("-10.1"),symbols=["u","u"]).magnitude    == Decimal("-10.1")
              # Multiple Different Numerators
              assert Unit(Decimal("-10.1"),symbols=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("-10.1"),symbols=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("-10.1"),symbols=["ua","ub","ub"]).denominators == ()
              assert Unit(Decimal("-10.1"),symbols=["ua","ub","ub"]).magnitude    == Decimal("-10.1")
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(Decimal("-10.1"),numerators=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(Decimal("-10.1"),numerators=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(Decimal("-10.1"),numerators=["u"]).denominators == ()
              assert Unit(Decimal("-10.1"),numerators=["u"]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators
              assert Unit(Decimal("-10.1"),numerators=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(Decimal("-10.1"),numerators=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(Decimal("-10.1"),numerators=["u","u"]).denominators == ()
              assert Unit(Decimal("-10.1"),numerators=["u","u"]).magnitude    == Decimal("-10.1")
              # Multiple Different Numerators
              assert Unit(Decimal("-10.1"),numerators=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("-10.1"),numerators=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("-10.1"),numerators=["ua","ub","ub"]).denominators == ()
              assert Unit(Decimal("-10.1"),numerators=["ua","ub","ub"]).magnitude    == Decimal("-10.1")
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(Decimal("-10.1"),denominators=["u"]).symbols      == (("u",Decimal(-1)),)
              assert Unit(Decimal("-10.1"),denominators=["u"]).numerators   == ()
              assert Unit(Decimal("-10.1"),denominators=["u"]).denominators == (("u",Decimal(1)),)
              assert Unit(Decimal("-10.1"),denominators=["u"]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators
              assert Unit(Decimal("-10.1"),denominators=["u","u"]).symbols      == (("u",Decimal(-2)),)
              assert Unit(Decimal("-10.1"),denominators=["u","u"]).numerators   == ()
              assert Unit(Decimal("-10.1"),denominators=["u","u"]).denominators == (("u",Decimal(2)),)
              assert Unit(Decimal("-10.1"),denominators=["u","u"]).magnitude    == Decimal("-10.1")
              # Multiple Different Numerators
              assert Unit(Decimal("-10.1"),denominators=["ua","ub","ub"]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(Decimal("-10.1"),denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(Decimal("-10.1"),denominators=["ua","ub","ub"]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("-10.1"),denominators=["ua","ub","ub"]).magnitude    == Decimal("-10.1")
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(Decimal("-10.1"),numerators=["nu"],denominators=["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(Decimal("-10.1"),numerators=["nu"],denominators=["du"]).numerators   == (("nu",Decimal(1)),)
              assert Unit(Decimal("-10.1"),numerators=["nu"],denominators=["du"]).denominators == (("du",Decimal(1)),)
              assert Unit(Decimal("-10.1"),numerators=["nu"],denominators=["du"]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators and Denominators
              assert Unit(Decimal("-10.1"),numerators=["nu","nu","nu"],denominators=["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(Decimal("-10.1"),numerators=["nu","nu","nu"],denominators=["du","du"]).numerators   == (("nu",Decimal(3)),)
              assert Unit(Decimal("-10.1"),numerators=["nu","nu","nu"],denominators=["du","du"]).denominators == (("du",Decimal(2)),)
              assert Unit(Decimal("-10.1"),numerators=["nu","nu","nu"],denominators=["du","du"]).magnitude    == Decimal("-10.1")
              # Multiple Different Numerators and Denominators
              assert Unit(Decimal("-10.1"),numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(Decimal("-10.1"),numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(Decimal("-10.1"),numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
              assert Unit(Decimal("-10.1"),numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).magnitude    == Decimal("-10.1")
            # Canceling
            if(True):
              # Single
              assert Unit(Decimal("-10.1"),numerators=["u"],denominators=["u"]).symbols      == ()
              assert Unit(Decimal("-10.1"),numerators=["u"],denominators=["u"]).numerators   == ()
              assert Unit(Decimal("-10.1"),numerators=["u"],denominators=["u"]).denominators == ()
              assert Unit(Decimal("-10.1"),numerators=["u"],denominators=["u"]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate
              assert Unit(Decimal("-10.1"),numerators=["u","u","u"],denominators=["u","u","u"]).symbols      == ()
              assert Unit(Decimal("-10.1"),numerators=["u","u","u"],denominators=["u","u","u"]).numerators   == ()
              assert Unit(Decimal("-10.1"),numerators=["u","u","u"],denominators=["u","u","u"]).denominators == ()
              assert Unit(Decimal("-10.1"),numerators=["u","u","u"],denominators=["u","u","u"]).magnitude    == Decimal("-10.1")
              # Multiple Different
              assert Unit(Decimal("-10.1"),numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).symbols      == ()
              assert Unit(Decimal("-10.1"),numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(Decimal("-10.1"),numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).denominators == ()
              assert Unit(Decimal("-10.1"),numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).magnitude    == Decimal("-10.1")
              # Partial Canceling
              assert Unit(Decimal("-10.1"),numerators=["ua","ub","ub"],denominators=["ua","ub"]).symbols      == (("ub",Decimal(1)),)
              assert Unit(Decimal("-10.1"),numerators=["ua","ub","ub"],denominators=["ua","ub"]).numerators   == (("ub",Decimal(1)),)
              assert Unit(Decimal("-10.1"),numerators=["ua","ub","ub"],denominators=["ua","ub"]).denominators == ()
              assert Unit(Decimal("-10.1"),numerators=["ua","ub","ub"],denominators=["ua","ub"]).magnitude    == Decimal("-10.1")
        # Tuple of String, Exponent
        if(True):
          # Positive Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(Decimal("10.1"),symbols=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(Decimal("10.1"),symbols=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(Decimal("10.1"),symbols=[("u",Decimal(1))]).denominators == ()
              assert Unit(Decimal("10.1"),symbols=[("u",Decimal(1))]).magnitude    == Decimal("10.1")
              # Single Numerator Higher Exponent
              assert Unit(Decimal("10.1"),symbols=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(Decimal("10.1"),symbols=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(Decimal("10.1"),symbols=[("u",Decimal(2))]).denominators == ()
              assert Unit(Decimal("10.1"),symbols=[("u",Decimal(2))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators
              assert Unit(Decimal("10.1"),symbols=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(Decimal("10.1"),symbols=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(Decimal("10.1"),symbols=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(Decimal("10.1"),symbols=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(Decimal("10.1"),symbols=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(Decimal("10.1"),symbols=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(Decimal("10.1"),symbols=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(Decimal("10.1"),symbols=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("10.1")
              # Multiple Different Numerators
              assert Unit(Decimal("10.1"),symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("10.1"),symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("10.1"),symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(Decimal("10.1"),symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("10.1")
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(Decimal("10.1"),numerators=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(Decimal("10.1"),numerators=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(Decimal("10.1"),numerators=[("u",Decimal(1))]).denominators == ()
              assert Unit(Decimal("10.1"),numerators=[("u",Decimal(1))]).magnitude    == Decimal("10.1")
              # Single Numerator Higher Exponent
              assert Unit(Decimal("10.1"),numerators=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(Decimal("10.1"),numerators=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(Decimal("10.1"),numerators=[("u",Decimal(2))]).denominators == ()
              assert Unit(Decimal("10.1"),numerators=[("u",Decimal(2))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators
              assert Unit(Decimal("10.1"),numerators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(Decimal("10.1"),numerators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(Decimal("10.1"),numerators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(Decimal("10.1"),numerators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(Decimal("10.1"),numerators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(Decimal("10.1"),numerators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(Decimal("10.1"),numerators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(Decimal("10.1"),numerators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("10.1")
              # Multiple Different Numerators
              assert Unit(Decimal("10.1"),numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("10.1"),numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("10.1"),numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(Decimal("10.1"),numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("10.1")
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(Decimal("10.1"),denominators=[("u",Decimal(1))]).symbols      == (("u",Decimal(-1)),)
              assert Unit(Decimal("10.1"),denominators=[("u",Decimal(1))]).numerators   == ()
              assert Unit(Decimal("10.1"),denominators=[("u",Decimal(1))]).denominators == (("u",Decimal(1)),)
              assert Unit(Decimal("10.1"),denominators=[("u",Decimal(1))]).magnitude    == Decimal("10.1")
              # Single Numerator Higher Exponent
              assert Unit(Decimal("10.1"),denominators=[("u",Decimal(2))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(Decimal("10.1"),denominators=[("u",Decimal(2))]).numerators   == ()
              assert Unit(Decimal("10.1"),denominators=[("u",Decimal(2))]).denominators == (("u",Decimal(2)),)
              assert Unit(Decimal("10.1"),denominators=[("u",Decimal(2))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators
              assert Unit(Decimal("10.1"),denominators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(Decimal("10.1"),denominators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == ()
              assert Unit(Decimal("10.1"),denominators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == (("u",Decimal(2)),)
              assert Unit(Decimal("10.1"),denominators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(Decimal("10.1"),denominators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(-3)),)
              assert Unit(Decimal("10.1"),denominators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == ()
              assert Unit(Decimal("10.1"),denominators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == (("u",Decimal(3)),)
              assert Unit(Decimal("10.1"),denominators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("10.1")
              # Multiple Different Numerators
              assert Unit(Decimal("10.1"),denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(Decimal("10.1"),denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == ()
              assert Unit(Decimal("10.1"),denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("10.1"),denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("10.1")
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).numerators   == (("nu",Decimal(1)),)
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).denominators == (("du",Decimal(1)),)
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).magnitude    == Decimal("10.1")
              # Single Numerator and Denominator Higher Exponent
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).numerators   == (("nu",Decimal(2)),)
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).denominators == (("du",Decimal(3)),)
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators and Denominators
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).numerators   == (("nu",Decimal(3)),)
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).denominators == (("du",Decimal(2)),)
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators and Denominators Higher Exponent
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).numerators   == (("nu",Decimal(4)),)
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).denominators == (("du",Decimal(4)),)
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).magnitude    == Decimal("10.1")
              # Multiple Different Numerators and Denominators
              assert Unit(Decimal("10.1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(Decimal("10.1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(Decimal("10.1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
              assert Unit(Decimal("10.1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).magnitude    == Decimal("10.1")
            # Canceling
            if(True):
              # Single
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).symbols      == ()
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).numerators   == ()
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).denominators == ()
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).magnitude    == Decimal("10.1")
              # Single Higher Exponent
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).symbols      == ()
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).numerators   == ()
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).denominators == ()
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Higher Exponent
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(Decimal("10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal("10.1")
              # Multiple Different
              assert Unit(Decimal("10.1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).symbols      == ()
              assert Unit(Decimal("10.1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).numerators   == ()
              assert Unit(Decimal("10.1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).denominators == ()
              assert Unit(Decimal("10.1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal("10.1")
              # Partial
              assert Unit(Decimal("10.1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
              assert Unit(Decimal("10.1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).numerators   == (("nua",Decimal(1)),)
              assert Unit(Decimal("10.1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).denominators == (("nub",Decimal(1)),)
              assert Unit(Decimal("10.1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal("10.1")
          # Negative Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(Decimal("-10.1"),symbols=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(Decimal("-10.1"),symbols=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(Decimal("-10.1"),symbols=[("u",Decimal(1))]).denominators == ()
              assert Unit(Decimal("-10.1"),symbols=[("u",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Single Numerator Higher Exponent
              assert Unit(Decimal("-10.1"),symbols=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(Decimal("-10.1"),symbols=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(Decimal("-10.1"),symbols=[("u",Decimal(2))]).denominators == ()
              assert Unit(Decimal("-10.1"),symbols=[("u",Decimal(2))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators
              assert Unit(Decimal("-10.1"),symbols=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(Decimal("-10.1"),symbols=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(Decimal("-10.1"),symbols=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(Decimal("-10.1"),symbols=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(Decimal("-10.1"),symbols=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(Decimal("-10.1"),symbols=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(Decimal("-10.1"),symbols=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(Decimal("-10.1"),symbols=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("-10.1")
              # Multiple Different Numerators
              assert Unit(Decimal("-10.1"),symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("-10.1"),symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("-10.1"),symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(Decimal("-10.1"),symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("-10.1")
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(Decimal("-10.1"),numerators=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(Decimal("-10.1"),numerators=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(Decimal("-10.1"),numerators=[("u",Decimal(1))]).denominators == ()
              assert Unit(Decimal("-10.1"),numerators=[("u",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Single Numerator Higher Exponent
              assert Unit(Decimal("-10.1"),numerators=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(Decimal("-10.1"),numerators=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(Decimal("-10.1"),numerators=[("u",Decimal(2))]).denominators == ()
              assert Unit(Decimal("-10.1"),numerators=[("u",Decimal(2))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators
              assert Unit(Decimal("-10.1"),numerators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(Decimal("-10.1"),numerators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(Decimal("-10.1"),numerators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(Decimal("-10.1"),numerators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(Decimal("-10.1"),numerators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(Decimal("-10.1"),numerators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(Decimal("-10.1"),numerators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(Decimal("-10.1"),numerators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("-10.1")
              # Multiple Different Numerators
              assert Unit(Decimal("-10.1"),numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("-10.1"),numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("-10.1"),numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(Decimal("-10.1"),numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("-10.1")
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(Decimal("-10.1"),denominators=[("u",Decimal(1))]).symbols      == (("u",Decimal(-1)),)
              assert Unit(Decimal("-10.1"),denominators=[("u",Decimal(1))]).numerators   == ()
              assert Unit(Decimal("-10.1"),denominators=[("u",Decimal(1))]).denominators == (("u",Decimal(1)),)
              assert Unit(Decimal("-10.1"),denominators=[("u",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Single Numerator Higher Exponent
              assert Unit(Decimal("-10.1"),denominators=[("u",Decimal(2))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(Decimal("-10.1"),denominators=[("u",Decimal(2))]).numerators   == ()
              assert Unit(Decimal("-10.1"),denominators=[("u",Decimal(2))]).denominators == (("u",Decimal(2)),)
              assert Unit(Decimal("-10.1"),denominators=[("u",Decimal(2))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators
              assert Unit(Decimal("-10.1"),denominators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(Decimal("-10.1"),denominators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == ()
              assert Unit(Decimal("-10.1"),denominators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == (("u",Decimal(2)),)
              assert Unit(Decimal("-10.1"),denominators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(Decimal("-10.1"),denominators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(-3)),)
              assert Unit(Decimal("-10.1"),denominators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == ()
              assert Unit(Decimal("-10.1"),denominators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == (("u",Decimal(3)),)
              assert Unit(Decimal("-10.1"),denominators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("-10.1")
              # Multiple Different Numerators
              assert Unit(Decimal("-10.1"),denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(Decimal("-10.1"),denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == ()
              assert Unit(Decimal("-10.1"),denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("-10.1"),denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("-10.1")
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).numerators   == (("nu",Decimal(1)),)
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).denominators == (("du",Decimal(1)),)
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Single Numerator and Denominator Higher Exponent
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).numerators   == (("nu",Decimal(2)),)
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).denominators == (("du",Decimal(3)),)
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators and Denominators
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).numerators   == (("nu",Decimal(3)),)
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).denominators == (("du",Decimal(2)),)
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators and Denominators Higher Exponent
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).numerators   == (("nu",Decimal(4)),)
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).denominators == (("du",Decimal(4)),)
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Multiple Different Numerators and Denominators
              assert Unit(Decimal("-10.1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(Decimal("-10.1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(Decimal("-10.1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
              assert Unit(Decimal("-10.1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).magnitude    == Decimal("-10.1")
            # Canceling
            if(True):
              # Single
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).symbols      == ()
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).numerators   == ()
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).denominators == ()
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Single Higher Exponent
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).symbols      == ()
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).numerators   == ()
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).denominators == ()
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Higher Exponent
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(Decimal("-10.1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Multiple Different
              assert Unit(Decimal("-10.1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).symbols      == ()
              assert Unit(Decimal("-10.1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).numerators   == ()
              assert Unit(Decimal("-10.1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).denominators == ()
              assert Unit(Decimal("-10.1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Partial
              assert Unit(Decimal("-10.1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
              assert Unit(Decimal("-10.1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).numerators   == (("nua",Decimal(1)),)
              assert Unit(Decimal("-10.1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).denominators == (("nub",Decimal(1)),)
              assert Unit(Decimal("-10.1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal("-10.1")
        # Tuple of Strings
        if(True):
          # Positive Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(Decimal("10e1"),symbols=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(Decimal("10e1"),symbols=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(Decimal("10e1"),symbols=["u"]).denominators == ()
              assert Unit(Decimal("10e1"),symbols=["u"]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators
              assert Unit(Decimal("10e1"),symbols=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(Decimal("10e1"),symbols=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(Decimal("10e1"),symbols=["u","u"]).denominators == ()
              assert Unit(Decimal("10e1"),symbols=["u","u"]).magnitude    == Decimal("10e1")
              # Multiple Different Numerators
              assert Unit(Decimal("10e1"),symbols=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("10e1"),symbols=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("10e1"),symbols=["ua","ub","ub"]).denominators == ()
              assert Unit(Decimal("10e1"),symbols=["ua","ub","ub"]).magnitude    == Decimal("10e1")
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(Decimal("10e1"),numerators=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(Decimal("10e1"),numerators=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(Decimal("10e1"),numerators=["u"]).denominators == ()
              assert Unit(Decimal("10e1"),numerators=["u"]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators
              assert Unit(Decimal("10e1"),numerators=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(Decimal("10e1"),numerators=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(Decimal("10e1"),numerators=["u","u"]).denominators == ()
              assert Unit(Decimal("10e1"),numerators=["u","u"]).magnitude    == Decimal("10e1")
              # Multiple Different Numerators
              assert Unit(Decimal("10e1"),numerators=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("10e1"),numerators=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("10e1"),numerators=["ua","ub","ub"]).denominators == ()
              assert Unit(Decimal("10e1"),numerators=["ua","ub","ub"]).magnitude    == Decimal("10e1")
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(Decimal("10e1"),denominators=["u"]).symbols      == (("u",Decimal(-1)),)
              assert Unit(Decimal("10e1"),denominators=["u"]).numerators   == ()
              assert Unit(Decimal("10e1"),denominators=["u"]).denominators == (("u",Decimal(1)),)
              assert Unit(Decimal("10e1"),denominators=["u"]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators
              assert Unit(Decimal("10e1"),denominators=["u","u"]).symbols      == (("u",Decimal(-2)),)
              assert Unit(Decimal("10e1"),denominators=["u","u"]).numerators   == ()
              assert Unit(Decimal("10e1"),denominators=["u","u"]).denominators == (("u",Decimal(2)),)
              assert Unit(Decimal("10e1"),denominators=["u","u"]).magnitude    == Decimal("10e1")
              # Multiple Different Numerators
              assert Unit(Decimal("10e1"),denominators=["ua","ub","ub"]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(Decimal("10e1"),denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(Decimal("10e1"),denominators=["ua","ub","ub"]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("10e1"),denominators=["ua","ub","ub"]).magnitude    == Decimal("10e1")
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(Decimal("10e1"),numerators=["nu"],denominators=["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(Decimal("10e1"),numerators=["nu"],denominators=["du"]).numerators   == (("nu",Decimal(1)),)
              assert Unit(Decimal("10e1"),numerators=["nu"],denominators=["du"]).denominators == (("du",Decimal(1)),)
              assert Unit(Decimal("10e1"),numerators=["nu"],denominators=["du"]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators and Denominators
              assert Unit(Decimal("10e1"),numerators=["nu","nu","nu"],denominators=["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(Decimal("10e1"),numerators=["nu","nu","nu"],denominators=["du","du"]).numerators   == (("nu",Decimal(3)),)
              assert Unit(Decimal("10e1"),numerators=["nu","nu","nu"],denominators=["du","du"]).denominators == (("du",Decimal(2)),)
              assert Unit(Decimal("10e1"),numerators=["nu","nu","nu"],denominators=["du","du"]).magnitude    == Decimal("10e1")
              # Multiple Different Numerators and Denominators
              assert Unit(Decimal("10e1"),numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(Decimal("10e1"),numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(Decimal("10e1"),numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
              assert Unit(Decimal("10e1"),numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).magnitude    == Decimal("10e1")
            # Canceling
            if(True):
              # Single
              assert Unit(Decimal("10e1"),numerators=["u"],denominators=["u"]).symbols      == ()
              assert Unit(Decimal("10e1"),numerators=["u"],denominators=["u"]).numerators   == ()
              assert Unit(Decimal("10e1"),numerators=["u"],denominators=["u"]).denominators == ()
              assert Unit(Decimal("10e1"),numerators=["u"],denominators=["u"]).magnitude    == Decimal("10e1")
              # Multiple Duplicate
              assert Unit(Decimal("10e1"),numerators=["u","u","u"],denominators=["u","u","u"]).symbols      == ()
              assert Unit(Decimal("10e1"),numerators=["u","u","u"],denominators=["u","u","u"]).numerators   == ()
              assert Unit(Decimal("10e1"),numerators=["u","u","u"],denominators=["u","u","u"]).denominators == ()
              assert Unit(Decimal("10e1"),numerators=["u","u","u"],denominators=["u","u","u"]).magnitude    == Decimal("10e1")
              # Multiple Different
              assert Unit(Decimal("10e1"),numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).symbols      == ()
              assert Unit(Decimal("10e1"),numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(Decimal("10e1"),numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).denominators == ()
              assert Unit(Decimal("10e1"),numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).magnitude    == Decimal("10e1")
              # Partial Canceling
              assert Unit(Decimal("10e1"),numerators=["ua","ub","ub"],denominators=["ua","ub"]).symbols      == (("ub",Decimal(1)),)
              assert Unit(Decimal("10e1"),numerators=["ua","ub","ub"],denominators=["ua","ub"]).numerators   == (("ub",Decimal(1)),)
              assert Unit(Decimal("10e1"),numerators=["ua","ub","ub"],denominators=["ua","ub"]).denominators == ()
              assert Unit(Decimal("10e1"),numerators=["ua","ub","ub"],denominators=["ua","ub"]).magnitude    == Decimal("10e1")
          # Negative Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(Decimal("-10e1"),symbols=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(Decimal("-10e1"),symbols=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(Decimal("-10e1"),symbols=["u"]).denominators == ()
              assert Unit(Decimal("-10e1"),symbols=["u"]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators
              assert Unit(Decimal("-10e1"),symbols=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(Decimal("-10e1"),symbols=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(Decimal("-10e1"),symbols=["u","u"]).denominators == ()
              assert Unit(Decimal("-10e1"),symbols=["u","u"]).magnitude    == Decimal("-10e1")
              # Multiple Different Numerators
              assert Unit(Decimal("-10e1"),symbols=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("-10e1"),symbols=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("-10e1"),symbols=["ua","ub","ub"]).denominators == ()
              assert Unit(Decimal("-10e1"),symbols=["ua","ub","ub"]).magnitude    == Decimal("-10e1")
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(Decimal("-10e1"),numerators=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(Decimal("-10e1"),numerators=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(Decimal("-10e1"),numerators=["u"]).denominators == ()
              assert Unit(Decimal("-10e1"),numerators=["u"]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators
              assert Unit(Decimal("-10e1"),numerators=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(Decimal("-10e1"),numerators=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(Decimal("-10e1"),numerators=["u","u"]).denominators == ()
              assert Unit(Decimal("-10e1"),numerators=["u","u"]).magnitude    == Decimal("-10e1")
              # Multiple Different Numerators
              assert Unit(Decimal("-10e1"),numerators=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("-10e1"),numerators=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("-10e1"),numerators=["ua","ub","ub"]).denominators == ()
              assert Unit(Decimal("-10e1"),numerators=["ua","ub","ub"]).magnitude    == Decimal("-10e1")
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(Decimal("-10e1"),denominators=["u"]).symbols      == (("u",Decimal(-1)),)
              assert Unit(Decimal("-10e1"),denominators=["u"]).numerators   == ()
              assert Unit(Decimal("-10e1"),denominators=["u"]).denominators == (("u",Decimal(1)),)
              assert Unit(Decimal("-10e1"),denominators=["u"]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators
              assert Unit(Decimal("-10e1"),denominators=["u","u"]).symbols      == (("u",Decimal(-2)),)
              assert Unit(Decimal("-10e1"),denominators=["u","u"]).numerators   == ()
              assert Unit(Decimal("-10e1"),denominators=["u","u"]).denominators == (("u",Decimal(2)),)
              assert Unit(Decimal("-10e1"),denominators=["u","u"]).magnitude    == Decimal("-10e1")
              # Multiple Different Numerators
              assert Unit(Decimal("-10e1"),denominators=["ua","ub","ub"]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(Decimal("-10e1"),denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(Decimal("-10e1"),denominators=["ua","ub","ub"]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("-10e1"),denominators=["ua","ub","ub"]).magnitude    == Decimal("-10e1")
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(Decimal("-10e1"),numerators=["nu"],denominators=["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(Decimal("-10e1"),numerators=["nu"],denominators=["du"]).numerators   == (("nu",Decimal(1)),)
              assert Unit(Decimal("-10e1"),numerators=["nu"],denominators=["du"]).denominators == (("du",Decimal(1)),)
              assert Unit(Decimal("-10e1"),numerators=["nu"],denominators=["du"]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators and Denominators
              assert Unit(Decimal("-10e1"),numerators=["nu","nu","nu"],denominators=["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(Decimal("-10e1"),numerators=["nu","nu","nu"],denominators=["du","du"]).numerators   == (("nu",Decimal(3)),)
              assert Unit(Decimal("-10e1"),numerators=["nu","nu","nu"],denominators=["du","du"]).denominators == (("du",Decimal(2)),)
              assert Unit(Decimal("-10e1"),numerators=["nu","nu","nu"],denominators=["du","du"]).magnitude    == Decimal("-10e1")
              # Multiple Different Numerators and Denominators
              assert Unit(Decimal("-10e1"),numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(Decimal("-10e1"),numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(Decimal("-10e1"),numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
              assert Unit(Decimal("-10e1"),numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).magnitude    == Decimal("-10e1")
            # Canceling
            if(True):
              # Single
              assert Unit(Decimal("-10e1"),numerators=["u"],denominators=["u"]).symbols      == ()
              assert Unit(Decimal("-10e1"),numerators=["u"],denominators=["u"]).numerators   == ()
              assert Unit(Decimal("-10e1"),numerators=["u"],denominators=["u"]).denominators == ()
              assert Unit(Decimal("-10e1"),numerators=["u"],denominators=["u"]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate
              assert Unit(Decimal("-10e1"),numerators=["u","u","u"],denominators=["u","u","u"]).symbols      == ()
              assert Unit(Decimal("-10e1"),numerators=["u","u","u"],denominators=["u","u","u"]).numerators   == ()
              assert Unit(Decimal("-10e1"),numerators=["u","u","u"],denominators=["u","u","u"]).denominators == ()
              assert Unit(Decimal("-10e1"),numerators=["u","u","u"],denominators=["u","u","u"]).magnitude    == Decimal("-10e1")
              # Multiple Different
              assert Unit(Decimal("-10e1"),numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).symbols      == ()
              assert Unit(Decimal("-10e1"),numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(Decimal("-10e1"),numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).denominators == ()
              assert Unit(Decimal("-10e1"),numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).magnitude    == Decimal("-10e1")
              # Partial Canceling
              assert Unit(Decimal("-10e1"),numerators=["ua","ub","ub"],denominators=["ua","ub"]).symbols      == (("ub",Decimal(1)),)
              assert Unit(Decimal("-10e1"),numerators=["ua","ub","ub"],denominators=["ua","ub"]).numerators   == (("ub",Decimal(1)),)
              assert Unit(Decimal("-10e1"),numerators=["ua","ub","ub"],denominators=["ua","ub"]).denominators == ()
              assert Unit(Decimal("-10e1"),numerators=["ua","ub","ub"],denominators=["ua","ub"]).magnitude    == Decimal("-10e1")
        # Tuple of String, Exponent
        if(True):
          # Positive Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(Decimal("10e1"),symbols=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(Decimal("10e1"),symbols=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(Decimal("10e1"),symbols=[("u",Decimal(1))]).denominators == ()
              assert Unit(Decimal("10e1"),symbols=[("u",Decimal(1))]).magnitude    == Decimal("10e1")
              # Single Numerator Higher Exponent
              assert Unit(Decimal("10e1"),symbols=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(Decimal("10e1"),symbols=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(Decimal("10e1"),symbols=[("u",Decimal(2))]).denominators == ()
              assert Unit(Decimal("10e1"),symbols=[("u",Decimal(2))]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators
              assert Unit(Decimal("10e1"),symbols=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(Decimal("10e1"),symbols=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(Decimal("10e1"),symbols=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(Decimal("10e1"),symbols=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(Decimal("10e1"),symbols=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(Decimal("10e1"),symbols=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(Decimal("10e1"),symbols=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(Decimal("10e1"),symbols=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("10e1")
              # Multiple Different Numerators
              assert Unit(Decimal("10e1"),symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("10e1"),symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("10e1"),symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(Decimal("10e1"),symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("10e1")
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(Decimal("10e1"),numerators=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(Decimal("10e1"),numerators=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(Decimal("10e1"),numerators=[("u",Decimal(1))]).denominators == ()
              assert Unit(Decimal("10e1"),numerators=[("u",Decimal(1))]).magnitude    == Decimal("10e1")
              # Single Numerator Higher Exponent
              assert Unit(Decimal("10e1"),numerators=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(Decimal("10e1"),numerators=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(Decimal("10e1"),numerators=[("u",Decimal(2))]).denominators == ()
              assert Unit(Decimal("10e1"),numerators=[("u",Decimal(2))]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators
              assert Unit(Decimal("10e1"),numerators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(Decimal("10e1"),numerators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(Decimal("10e1"),numerators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(Decimal("10e1"),numerators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(Decimal("10e1"),numerators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(Decimal("10e1"),numerators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(Decimal("10e1"),numerators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(Decimal("10e1"),numerators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("10e1")
              # Multiple Different Numerators
              assert Unit(Decimal("10e1"),numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("10e1"),numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("10e1"),numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(Decimal("10e1"),numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("10e1")
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(Decimal("10e1"),denominators=[("u",Decimal(1))]).symbols      == (("u",Decimal(-1)),)
              assert Unit(Decimal("10e1"),denominators=[("u",Decimal(1))]).numerators   == ()
              assert Unit(Decimal("10e1"),denominators=[("u",Decimal(1))]).denominators == (("u",Decimal(1)),)
              assert Unit(Decimal("10e1"),denominators=[("u",Decimal(1))]).magnitude    == Decimal("10e1")
              # Single Numerator Higher Exponent
              assert Unit(Decimal("10e1"),denominators=[("u",Decimal(2))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(Decimal("10e1"),denominators=[("u",Decimal(2))]).numerators   == ()
              assert Unit(Decimal("10e1"),denominators=[("u",Decimal(2))]).denominators == (("u",Decimal(2)),)
              assert Unit(Decimal("10e1"),denominators=[("u",Decimal(2))]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators
              assert Unit(Decimal("10e1"),denominators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(Decimal("10e1"),denominators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == ()
              assert Unit(Decimal("10e1"),denominators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == (("u",Decimal(2)),)
              assert Unit(Decimal("10e1"),denominators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(Decimal("10e1"),denominators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(-3)),)
              assert Unit(Decimal("10e1"),denominators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == ()
              assert Unit(Decimal("10e1"),denominators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == (("u",Decimal(3)),)
              assert Unit(Decimal("10e1"),denominators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("10e1")
              # Multiple Different Numerators
              assert Unit(Decimal("10e1"),denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(Decimal("10e1"),denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == ()
              assert Unit(Decimal("10e1"),denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("10e1"),denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("10e1")
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).numerators   == (("nu",Decimal(1)),)
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).denominators == (("du",Decimal(1)),)
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).magnitude    == Decimal("10e1")
              # Single Numerator and Denominator Higher Exponent
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).numerators   == (("nu",Decimal(2)),)
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).denominators == (("du",Decimal(3)),)
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators and Denominators
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).numerators   == (("nu",Decimal(3)),)
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).denominators == (("du",Decimal(2)),)
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators and Denominators Higher Exponent
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).numerators   == (("nu",Decimal(4)),)
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).denominators == (("du",Decimal(4)),)
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).magnitude    == Decimal("10e1")
              # Multiple Different Numerators and Denominators
              assert Unit(Decimal("10e1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(Decimal("10e1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(Decimal("10e1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
              assert Unit(Decimal("10e1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).magnitude    == Decimal("10e1")
            # Canceling
            if(True):
              # Single
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).symbols      == ()
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).numerators   == ()
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).denominators == ()
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).magnitude    == Decimal("10e1")
              # Single Higher Exponent
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).symbols      == ()
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).numerators   == ()
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).denominators == ()
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).magnitude    == Decimal("10e1")
              # Multiple Duplicate
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Higher Exponent
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(Decimal("10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal("10e1")
              # Multiple Different
              assert Unit(Decimal("10e1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).symbols      == ()
              assert Unit(Decimal("10e1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).numerators   == ()
              assert Unit(Decimal("10e1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).denominators == ()
              assert Unit(Decimal("10e1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal("10e1")
              # Partial
              assert Unit(Decimal("10e1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
              assert Unit(Decimal("10e1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).numerators   == (("nua",Decimal(1)),)
              assert Unit(Decimal("10e1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).denominators == (("nub",Decimal(1)),)
              assert Unit(Decimal("10e1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal("10e1")
          # Negative Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(Decimal("-10e1"),symbols=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(Decimal("-10e1"),symbols=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(Decimal("-10e1"),symbols=[("u",Decimal(1))]).denominators == ()
              assert Unit(Decimal("-10e1"),symbols=[("u",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Single Numerator Higher Exponent
              assert Unit(Decimal("-10e1"),symbols=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(Decimal("-10e1"),symbols=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(Decimal("-10e1"),symbols=[("u",Decimal(2))]).denominators == ()
              assert Unit(Decimal("-10e1"),symbols=[("u",Decimal(2))]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators
              assert Unit(Decimal("-10e1"),symbols=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(Decimal("-10e1"),symbols=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(Decimal("-10e1"),symbols=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(Decimal("-10e1"),symbols=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(Decimal("-10e1"),symbols=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(Decimal("-10e1"),symbols=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(Decimal("-10e1"),symbols=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(Decimal("-10e1"),symbols=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("-10e1")
              # Multiple Different Numerators
              assert Unit(Decimal("-10e1"),symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("-10e1"),symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("-10e1"),symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(Decimal("-10e1"),symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("-10e1")
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(Decimal("-10e1"),numerators=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(Decimal("-10e1"),numerators=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(Decimal("-10e1"),numerators=[("u",Decimal(1))]).denominators == ()
              assert Unit(Decimal("-10e1"),numerators=[("u",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Single Numerator Higher Exponent
              assert Unit(Decimal("-10e1"),numerators=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(Decimal("-10e1"),numerators=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(Decimal("-10e1"),numerators=[("u",Decimal(2))]).denominators == ()
              assert Unit(Decimal("-10e1"),numerators=[("u",Decimal(2))]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators
              assert Unit(Decimal("-10e1"),numerators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(Decimal("-10e1"),numerators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(Decimal("-10e1"),numerators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(Decimal("-10e1"),numerators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(Decimal("-10e1"),numerators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(Decimal("-10e1"),numerators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(Decimal("-10e1"),numerators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(Decimal("-10e1"),numerators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("-10e1")
              # Multiple Different Numerators
              assert Unit(Decimal("-10e1"),numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("-10e1"),numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("-10e1"),numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(Decimal("-10e1"),numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("-10e1")
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(Decimal("-10e1"),denominators=[("u",Decimal(1))]).symbols      == (("u",Decimal(-1)),)
              assert Unit(Decimal("-10e1"),denominators=[("u",Decimal(1))]).numerators   == ()
              assert Unit(Decimal("-10e1"),denominators=[("u",Decimal(1))]).denominators == (("u",Decimal(1)),)
              assert Unit(Decimal("-10e1"),denominators=[("u",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Single Numerator Higher Exponent
              assert Unit(Decimal("-10e1"),denominators=[("u",Decimal(2))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(Decimal("-10e1"),denominators=[("u",Decimal(2))]).numerators   == ()
              assert Unit(Decimal("-10e1"),denominators=[("u",Decimal(2))]).denominators == (("u",Decimal(2)),)
              assert Unit(Decimal("-10e1"),denominators=[("u",Decimal(2))]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators
              assert Unit(Decimal("-10e1"),denominators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(Decimal("-10e1"),denominators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == ()
              assert Unit(Decimal("-10e1"),denominators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == (("u",Decimal(2)),)
              assert Unit(Decimal("-10e1"),denominators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(Decimal("-10e1"),denominators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(-3)),)
              assert Unit(Decimal("-10e1"),denominators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == ()
              assert Unit(Decimal("-10e1"),denominators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == (("u",Decimal(3)),)
              assert Unit(Decimal("-10e1"),denominators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("-10e1")
              # Multiple Different Numerators
              assert Unit(Decimal("-10e1"),denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(Decimal("-10e1"),denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == ()
              assert Unit(Decimal("-10e1"),denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(Decimal("-10e1"),denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("-10e1")
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).numerators   == (("nu",Decimal(1)),)
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).denominators == (("du",Decimal(1)),)
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Single Numerator and Denominator Higher Exponent
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).numerators   == (("nu",Decimal(2)),)
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).denominators == (("du",Decimal(3)),)
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators and Denominators
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).numerators   == (("nu",Decimal(3)),)
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).denominators == (("du",Decimal(2)),)
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators and Denominators Higher Exponent
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).numerators   == (("nu",Decimal(4)),)
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).denominators == (("du",Decimal(4)),)
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Multiple Different Numerators and Denominators
              assert Unit(Decimal("-10e1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(Decimal("-10e1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(Decimal("-10e1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
              assert Unit(Decimal("-10e1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).magnitude    == Decimal("-10e1")
            # Canceling
            if(True):
              # Single
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).symbols      == ()
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).numerators   == ()
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).denominators == ()
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Single Higher Exponent
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).symbols      == ()
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).numerators   == ()
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).denominators == ()
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Higher Exponent
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(Decimal("-10e1"),numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Multiple Different
              assert Unit(Decimal("-10e1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).symbols      == ()
              assert Unit(Decimal("-10e1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).numerators   == ()
              assert Unit(Decimal("-10e1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).denominators == ()
              assert Unit(Decimal("-10e1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal("-10e1")
              # Partial
              assert Unit(Decimal("-10e1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
              assert Unit(Decimal("-10e1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).numerators   == (("nua",Decimal(1)),)
              assert Unit(Decimal("-10e1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).denominators == (("nub",Decimal(1)),)
              assert Unit(Decimal("-10e1"),numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal("-10e1")
    # Explicit Symbols, Explicit Magnitude
    if(True):
      # Explicit Symbols, Magnitude Int
      if(True):
        # Tuple of Strings
        if(True):
          # Positive Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(magnitude=10,symbols=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude=10,symbols=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude=10,symbols=["u"]).denominators == ()
              assert Unit(magnitude=10,symbols=["u"]).magnitude    == Decimal(10)
              # Multiple Duplicate Numerators
              assert Unit(magnitude=10,symbols=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=10,symbols=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=10,symbols=["u","u"]).denominators == ()
              assert Unit(magnitude=10,symbols=["u","u"]).magnitude    == Decimal(10)
              # Multiple Different Numerators
              assert Unit(magnitude=10,symbols=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10,symbols=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10,symbols=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude=10,symbols=["ua","ub","ub"]).magnitude    == Decimal(10)
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(magnitude=10,numerators=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude=10,numerators=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude=10,numerators=["u"]).denominators == ()
              assert Unit(magnitude=10,numerators=["u"]).magnitude    == Decimal(10)
              # Multiple Duplicate Numerators
              assert Unit(magnitude=10,numerators=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=10,numerators=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=10,numerators=["u","u"]).denominators == ()
              assert Unit(magnitude=10,numerators=["u","u"]).magnitude    == Decimal(10)
              # Multiple Different Numerators
              assert Unit(magnitude=10,numerators=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10,numerators=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10,numerators=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude=10,numerators=["ua","ub","ub"]).magnitude    == Decimal(10)
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(magnitude=10,denominators=["u"]).symbols      == (("u",Decimal(-1)),)
              assert Unit(magnitude=10,denominators=["u"]).numerators   == ()
              assert Unit(magnitude=10,denominators=["u"]).denominators == (("u",Decimal(1)),)
              assert Unit(magnitude=10,denominators=["u"]).magnitude    == Decimal(10)
              # Multiple Duplicate Numerators
              assert Unit(magnitude=10,denominators=["u","u"]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude=10,denominators=["u","u"]).numerators   == ()
              assert Unit(magnitude=10,denominators=["u","u"]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude=10,denominators=["u","u"]).magnitude    == Decimal(10)
              # Multiple Different Numerators
              assert Unit(magnitude=10,denominators=["ua","ub","ub"]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(magnitude=10,denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(magnitude=10,denominators=["ua","ub","ub"]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10,denominators=["ua","ub","ub"]).magnitude    == Decimal(10)
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(magnitude=10,numerators=["nu"],denominators=["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(magnitude=10,numerators=["nu"],denominators=["du"]).numerators   == (("nu",Decimal(1)),)
              assert Unit(magnitude=10,numerators=["nu"],denominators=["du"]).denominators == (("du",Decimal(1)),)
              assert Unit(magnitude=10,numerators=["nu"],denominators=["du"]).magnitude    == Decimal(10)
              # Multiple Duplicate Numerators and Denominators
              assert Unit(magnitude=10,numerators=["nu","nu","nu"],denominators=["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(magnitude=10,numerators=["nu","nu","nu"],denominators=["du","du"]).numerators   == (("nu",Decimal(3)),)
              assert Unit(magnitude=10,numerators=["nu","nu","nu"],denominators=["du","du"]).denominators == (("du",Decimal(2)),)
              assert Unit(magnitude=10,numerators=["nu","nu","nu"],denominators=["du","du"]).magnitude    == Decimal(10)
              # Multiple Different Numerators and Denominators
              assert Unit(magnitude=10,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(magnitude=10,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(magnitude=10,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
              assert Unit(magnitude=10,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).magnitude    == Decimal(10)
            # Canceling
            if(True):
              # Single
              assert Unit(magnitude=10,numerators=["u"],denominators=["u"]).symbols      == ()
              assert Unit(magnitude=10,numerators=["u"],denominators=["u"]).numerators   == ()
              assert Unit(magnitude=10,numerators=["u"],denominators=["u"]).denominators == ()
              assert Unit(magnitude=10,numerators=["u"],denominators=["u"]).magnitude    == Decimal(10)
              # Multiple Duplicate
              assert Unit(magnitude=10,numerators=["u","u","u"],denominators=["u","u","u"]).symbols      == ()
              assert Unit(magnitude=10,numerators=["u","u","u"],denominators=["u","u","u"]).numerators   == ()
              assert Unit(magnitude=10,numerators=["u","u","u"],denominators=["u","u","u"]).denominators == ()
              assert Unit(magnitude=10,numerators=["u","u","u"],denominators=["u","u","u"]).magnitude    == Decimal(10)
              # Multiple Different
              assert Unit(magnitude=10,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).symbols      == ()
              assert Unit(magnitude=10,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(magnitude=10,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude=10,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).magnitude    == Decimal(10)
              # Partial Canceling
              assert Unit(magnitude=10,numerators=["ua","ub","ub"],denominators=["ua","ub"]).symbols      == (("ub",Decimal(1)),)
              assert Unit(magnitude=10,numerators=["ua","ub","ub"],denominators=["ua","ub"]).numerators   == (("ub",Decimal(1)),)
              assert Unit(magnitude=10,numerators=["ua","ub","ub"],denominators=["ua","ub"]).denominators == ()
              assert Unit(magnitude=10,numerators=["ua","ub","ub"],denominators=["ua","ub"]).magnitude    == Decimal(10)
          # Negative Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(magnitude=-10,symbols=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude=-10,symbols=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude=-10,symbols=["u"]).denominators == ()
              assert Unit(magnitude=-10,symbols=["u"]).magnitude    == Decimal(-10)
              # Multiple Duplicate Numerators
              assert Unit(magnitude=-10,symbols=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=-10,symbols=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=-10,symbols=["u","u"]).denominators == ()
              assert Unit(magnitude=-10,symbols=["u","u"]).magnitude    == Decimal(-10)
              # Multiple Different Numerators
              assert Unit(magnitude=-10,symbols=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10,symbols=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10,symbols=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude=-10,symbols=["ua","ub","ub"]).magnitude    == Decimal(-10)
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(magnitude=-10,numerators=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude=-10,numerators=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude=-10,numerators=["u"]).denominators == ()
              assert Unit(magnitude=-10,numerators=["u"]).magnitude    == Decimal(-10)
              # Multiple Duplicate Numerators
              assert Unit(magnitude=-10,numerators=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=-10,numerators=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=-10,numerators=["u","u"]).denominators == ()
              assert Unit(magnitude=-10,numerators=["u","u"]).magnitude    == Decimal(-10)
              # Multiple Different Numerators
              assert Unit(magnitude=-10,numerators=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10,numerators=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10,numerators=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude=-10,numerators=["ua","ub","ub"]).magnitude    == Decimal(-10)
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(magnitude=-10,denominators=["u"]).symbols      == (("u",Decimal(-1)),)
              assert Unit(magnitude=-10,denominators=["u"]).numerators   == ()
              assert Unit(magnitude=-10,denominators=["u"]).denominators == (("u",Decimal(1)),)
              assert Unit(magnitude=-10,denominators=["u"]).magnitude    == Decimal(-10)
              # Multiple Duplicate Numerators
              assert Unit(magnitude=-10,denominators=["u","u"]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude=-10,denominators=["u","u"]).numerators   == ()
              assert Unit(magnitude=-10,denominators=["u","u"]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude=-10,denominators=["u","u"]).magnitude    == Decimal(-10)
              # Multiple Different Numerators
              assert Unit(magnitude=-10,denominators=["ua","ub","ub"]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(magnitude=-10,denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(magnitude=-10,denominators=["ua","ub","ub"]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10,denominators=["ua","ub","ub"]).magnitude    == Decimal(-10)
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(magnitude=-10,numerators=["nu"],denominators=["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(magnitude=-10,numerators=["nu"],denominators=["du"]).numerators   == (("nu",Decimal(1)),)
              assert Unit(magnitude=-10,numerators=["nu"],denominators=["du"]).denominators == (("du",Decimal(1)),)
              assert Unit(magnitude=-10,numerators=["nu"],denominators=["du"]).magnitude    == Decimal(-10)
              # Multiple Duplicate Numerators and Denominators
              assert Unit(magnitude=-10,numerators=["nu","nu","nu"],denominators=["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(magnitude=-10,numerators=["nu","nu","nu"],denominators=["du","du"]).numerators   == (("nu",Decimal(3)),)
              assert Unit(magnitude=-10,numerators=["nu","nu","nu"],denominators=["du","du"]).denominators == (("du",Decimal(2)),)
              assert Unit(magnitude=-10,numerators=["nu","nu","nu"],denominators=["du","du"]).magnitude    == Decimal(-10)
              # Multiple Different Numerators and Denominators
              assert Unit(magnitude=-10,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(magnitude=-10,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(magnitude=-10,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
              assert Unit(magnitude=-10,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).magnitude    == Decimal(-10)
            # Canceling
            if(True):
              # Single
              assert Unit(magnitude=-10,numerators=["u"],denominators=["u"]).symbols      == ()
              assert Unit(magnitude=-10,numerators=["u"],denominators=["u"]).numerators   == ()
              assert Unit(magnitude=-10,numerators=["u"],denominators=["u"]).denominators == ()
              assert Unit(magnitude=-10,numerators=["u"],denominators=["u"]).magnitude    == Decimal(-10)
              # Multiple Duplicate
              assert Unit(magnitude=-10,numerators=["u","u","u"],denominators=["u","u","u"]).symbols      == ()
              assert Unit(magnitude=-10,numerators=["u","u","u"],denominators=["u","u","u"]).numerators   == ()
              assert Unit(magnitude=-10,numerators=["u","u","u"],denominators=["u","u","u"]).denominators == ()
              assert Unit(magnitude=-10,numerators=["u","u","u"],denominators=["u","u","u"]).magnitude    == Decimal(-10)
              # Multiple Different
              assert Unit(magnitude=-10,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).symbols      == ()
              assert Unit(magnitude=-10,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(magnitude=-10,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude=-10,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).magnitude    == Decimal(-10)
              # Partial Canceling
              assert Unit(magnitude=-10,numerators=["ua","ub","ub"],denominators=["ua","ub"]).symbols      == (("ub",Decimal(1)),)
              assert Unit(magnitude=-10,numerators=["ua","ub","ub"],denominators=["ua","ub"]).numerators   == (("ub",Decimal(1)),)
              assert Unit(magnitude=-10,numerators=["ua","ub","ub"],denominators=["ua","ub"]).denominators == ()
              assert Unit(magnitude=-10,numerators=["ua","ub","ub"],denominators=["ua","ub"]).magnitude    == Decimal(-10)
        # Tuple of String, Exponent
        if(True):
          # Positive Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(magnitude=10,symbols=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude=10,symbols=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude=10,symbols=[("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude=10,symbols=[("u",Decimal(1))]).magnitude    == Decimal(10)
              # Single Numerator Higher Exponent
              assert Unit(magnitude=10,symbols=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=10,symbols=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=10,symbols=[("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude=10,symbols=[("u",Decimal(2))]).magnitude    == Decimal(10)
              # Multiple Duplicate Numerators
              assert Unit(magnitude=10,symbols=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=10,symbols=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=10,symbols=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude=10,symbols=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal(10)
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(magnitude=10,symbols=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(magnitude=10,symbols=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(magnitude=10,symbols=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude=10,symbols=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal(10)
              # Multiple Different Numerators
              assert Unit(magnitude=10,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(magnitude=10,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal(10)
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(magnitude=10,numerators=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude=10,numerators=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude=10,numerators=[("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude=10,numerators=[("u",Decimal(1))]).magnitude    == Decimal(10)
              # Single Numerator Higher Exponent
              assert Unit(magnitude=10,numerators=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=10,numerators=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=10,numerators=[("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude=10,numerators=[("u",Decimal(2))]).magnitude    == Decimal(10)
              # Multiple Duplicate Numerators
              assert Unit(magnitude=10,numerators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=10,numerators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=10,numerators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude=10,numerators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal(10)
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(magnitude=10,numerators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(magnitude=10,numerators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(magnitude=10,numerators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude=10,numerators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal(10)
              # Multiple Different Numerators
              assert Unit(magnitude=10,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(magnitude=10,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal(10)
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(magnitude=10,denominators=[("u",Decimal(1))]).symbols      == (("u",Decimal(-1)),)
              assert Unit(magnitude=10,denominators=[("u",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=10,denominators=[("u",Decimal(1))]).denominators == (("u",Decimal(1)),)
              assert Unit(magnitude=10,denominators=[("u",Decimal(1))]).magnitude    == Decimal(10)
              # Single Numerator Higher Exponent
              assert Unit(magnitude=10,denominators=[("u",Decimal(2))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude=10,denominators=[("u",Decimal(2))]).numerators   == ()
              assert Unit(magnitude=10,denominators=[("u",Decimal(2))]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude=10,denominators=[("u",Decimal(2))]).magnitude    == Decimal(10)
              # Multiple Duplicate Numerators
              assert Unit(magnitude=10,denominators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude=10,denominators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=10,denominators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude=10,denominators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal(10)
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(magnitude=10,denominators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(-3)),)
              assert Unit(magnitude=10,denominators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == ()
              assert Unit(magnitude=10,denominators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == (("u",Decimal(3)),)
              assert Unit(magnitude=10,denominators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal(10)
              # Multiple Different Numerators
              assert Unit(magnitude=10,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(magnitude=10,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == ()
              assert Unit(magnitude=10,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal(10)
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(magnitude=10,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(magnitude=10,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).numerators   == (("nu",Decimal(1)),)
              assert Unit(magnitude=10,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).denominators == (("du",Decimal(1)),)
              assert Unit(magnitude=10,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).magnitude    == Decimal(10)
              # Single Numerator and Denominator Higher Exponent
              assert Unit(magnitude=10,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
              assert Unit(magnitude=10,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).numerators   == (("nu",Decimal(2)),)
              assert Unit(magnitude=10,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).denominators == (("du",Decimal(3)),)
              assert Unit(magnitude=10,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).magnitude    == Decimal(10)
              # Multiple Duplicate Numerators and Denominators
              assert Unit(magnitude=10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(magnitude=10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).numerators   == (("nu",Decimal(3)),)
              assert Unit(magnitude=10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).denominators == (("du",Decimal(2)),)
              assert Unit(magnitude=10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).magnitude    == Decimal(10)
              # Multiple Duplicate Numerators and Denominators Higher Exponent
              assert Unit(magnitude=10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
              assert Unit(magnitude=10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).numerators   == (("nu",Decimal(4)),)
              assert Unit(magnitude=10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).denominators == (("du",Decimal(4)),)
              assert Unit(magnitude=10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).magnitude    == Decimal(10)
              # Multiple Different Numerators and Denominators
              assert Unit(magnitude=10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(magnitude=10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(magnitude=10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
              assert Unit(magnitude=10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).magnitude    == Decimal(10)
            # Canceling
            if(True):
              # Single
              assert Unit(magnitude=10,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).symbols      == ()
              assert Unit(magnitude=10,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=10,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).denominators == ()
              assert Unit(magnitude=10,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).magnitude    == Decimal(10)
              # Single Higher Exponent
              assert Unit(magnitude=10,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).symbols      == ()
              assert Unit(magnitude=10,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).numerators   == ()
              assert Unit(magnitude=10,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).denominators == ()
              assert Unit(magnitude=10,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).magnitude    == Decimal(10)
              # Multiple Duplicate
              assert Unit(magnitude=10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(magnitude=10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(magnitude=10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal(10)
              # Multiple Duplicate Higher Exponent
              assert Unit(magnitude=10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(magnitude=10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(magnitude=10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal(10)
              # Multiple Different
              assert Unit(magnitude=10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).symbols      == ()
              assert Unit(magnitude=10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).denominators == ()
              assert Unit(magnitude=10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal(10)
              # Partial
              assert Unit(magnitude=10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
              assert Unit(magnitude=10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).numerators   == (("nua",Decimal(1)),)
              assert Unit(magnitude=10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).denominators == (("nub",Decimal(1)),)
              assert Unit(magnitude=10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal(10)
          # Negative Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(magnitude=-10,symbols=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude=-10,symbols=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude=-10,symbols=[("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude=-10,symbols=[("u",Decimal(1))]).magnitude    == Decimal(-10)
              # Single Numerator Higher Exponent
              assert Unit(magnitude=-10,symbols=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=-10,symbols=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=-10,symbols=[("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude=-10,symbols=[("u",Decimal(2))]).magnitude    == Decimal(-10)
              # Multiple Duplicate Numerators
              assert Unit(magnitude=-10,symbols=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=-10,symbols=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=-10,symbols=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude=-10,symbols=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal(-10)
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(magnitude=-10,symbols=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(magnitude=-10,symbols=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(magnitude=-10,symbols=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude=-10,symbols=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal(-10)
              # Multiple Different Numerators
              assert Unit(magnitude=-10,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(magnitude=-10,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal(-10)
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(magnitude=-10,numerators=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude=-10,numerators=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude=-10,numerators=[("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude=-10,numerators=[("u",Decimal(1))]).magnitude    == Decimal(-10)
              # Single Numerator Higher Exponent
              assert Unit(magnitude=-10,numerators=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=-10,numerators=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=-10,numerators=[("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude=-10,numerators=[("u",Decimal(2))]).magnitude    == Decimal(-10)
              # Multiple Duplicate Numerators
              assert Unit(magnitude=-10,numerators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=-10,numerators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=-10,numerators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude=-10,numerators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal(-10)
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(magnitude=-10,numerators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(magnitude=-10,numerators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(magnitude=-10,numerators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude=-10,numerators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal(-10)
              # Multiple Different Numerators
              assert Unit(magnitude=-10,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(magnitude=-10,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal(-10)
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(magnitude=-10,denominators=[("u",Decimal(1))]).symbols      == (("u",Decimal(-1)),)
              assert Unit(magnitude=-10,denominators=[("u",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=-10,denominators=[("u",Decimal(1))]).denominators == (("u",Decimal(1)),)
              assert Unit(magnitude=-10,denominators=[("u",Decimal(1))]).magnitude    == Decimal(-10)
              # Single Numerator Higher Exponent
              assert Unit(magnitude=-10,denominators=[("u",Decimal(2))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude=-10,denominators=[("u",Decimal(2))]).numerators   == ()
              assert Unit(magnitude=-10,denominators=[("u",Decimal(2))]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude=-10,denominators=[("u",Decimal(2))]).magnitude    == Decimal(-10)
              # Multiple Duplicate Numerators
              assert Unit(magnitude=-10,denominators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude=-10,denominators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=-10,denominators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude=-10,denominators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal(-10)
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(magnitude=-10,denominators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(-3)),)
              assert Unit(magnitude=-10,denominators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == ()
              assert Unit(magnitude=-10,denominators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == (("u",Decimal(3)),)
              assert Unit(magnitude=-10,denominators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal(-10)
              # Multiple Different Numerators
              assert Unit(magnitude=-10,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(magnitude=-10,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == ()
              assert Unit(magnitude=-10,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal(-10)
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).numerators   == (("nu",Decimal(1)),)
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).denominators == (("du",Decimal(1)),)
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).magnitude    == Decimal(-10)
              # Single Numerator and Denominator Higher Exponent
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).numerators   == (("nu",Decimal(2)),)
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).denominators == (("du",Decimal(3)),)
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).magnitude    == Decimal(-10)
              # Multiple Duplicate Numerators and Denominators
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).numerators   == (("nu",Decimal(3)),)
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).denominators == (("du",Decimal(2)),)
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).magnitude    == Decimal(-10)
              # Multiple Duplicate Numerators and Denominators Higher Exponent
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).numerators   == (("nu",Decimal(4)),)
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).denominators == (("du",Decimal(4)),)
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).magnitude    == Decimal(-10)
              # Multiple Different Numerators and Denominators
              assert Unit(magnitude=-10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(magnitude=-10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(magnitude=-10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
              assert Unit(magnitude=-10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).magnitude    == Decimal(-10)
            # Canceling
            if(True):
              # Single
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).symbols      == ()
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).denominators == ()
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).magnitude    == Decimal(-10)
              # Single Higher Exponent
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).symbols      == ()
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).numerators   == ()
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).denominators == ()
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).magnitude    == Decimal(-10)
              # Multiple Duplicate
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal(-10)
              # Multiple Duplicate Higher Exponent
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(magnitude=-10,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal(-10)
              # Multiple Different
              assert Unit(magnitude=-10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).symbols      == ()
              assert Unit(magnitude=-10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=-10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).denominators == ()
              assert Unit(magnitude=-10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal(-10)
              # Partial
              assert Unit(magnitude=-10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
              assert Unit(magnitude=-10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).numerators   == (("nua",Decimal(1)),)
              assert Unit(magnitude=-10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).denominators == (("nub",Decimal(1)),)
              assert Unit(magnitude=-10,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal(-10)
      # Explicit Symbols, Magnitude float
      if(True):
        # Tuple of Strings
        if(True):
          # Positive Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(magnitude=10.1,symbols=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude=10.1,symbols=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude=10.1,symbols=["u"]).denominators == ()
              assert Unit(magnitude=10.1,symbols=["u"]).magnitude    == 10.1
              # Multiple Duplicate Numerators
              assert Unit(magnitude=10.1,symbols=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=10.1,symbols=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=10.1,symbols=["u","u"]).denominators == ()
              assert Unit(magnitude=10.1,symbols=["u","u"]).magnitude    == 10.1
              # Multiple Different Numerators
              assert Unit(magnitude=10.1,symbols=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10.1,symbols=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10.1,symbols=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude=10.1,symbols=["ua","ub","ub"]).magnitude    == 10.1
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(magnitude=10.1,numerators=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude=10.1,numerators=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude=10.1,numerators=["u"]).denominators == ()
              assert Unit(magnitude=10.1,numerators=["u"]).magnitude    == 10.1
              # Multiple Duplicate Numerators
              assert Unit(magnitude=10.1,numerators=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=10.1,numerators=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=10.1,numerators=["u","u"]).denominators == ()
              assert Unit(magnitude=10.1,numerators=["u","u"]).magnitude    == 10.1
              # Multiple Different Numerators
              assert Unit(magnitude=10.1,numerators=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10.1,numerators=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10.1,numerators=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude=10.1,numerators=["ua","ub","ub"]).magnitude    == 10.1
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(magnitude=10.1,denominators=["u"]).symbols      == (("u",Decimal(-1)),)
              assert Unit(magnitude=10.1,denominators=["u"]).numerators   == ()
              assert Unit(magnitude=10.1,denominators=["u"]).denominators == (("u",Decimal(1)),)
              assert Unit(magnitude=10.1,denominators=["u"]).magnitude    == 10.1
              # Multiple Duplicate Numerators
              assert Unit(magnitude=10.1,denominators=["u","u"]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude=10.1,denominators=["u","u"]).numerators   == ()
              assert Unit(magnitude=10.1,denominators=["u","u"]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude=10.1,denominators=["u","u"]).magnitude    == 10.1
              # Multiple Different Numerators
              assert Unit(magnitude=10.1,denominators=["ua","ub","ub"]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(magnitude=10.1,denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(magnitude=10.1,denominators=["ua","ub","ub"]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10.1,denominators=["ua","ub","ub"]).magnitude    == 10.1
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(magnitude=10.1,numerators=["nu"],denominators=["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(magnitude=10.1,numerators=["nu"],denominators=["du"]).numerators   == (("nu",Decimal(1)),)
              assert Unit(magnitude=10.1,numerators=["nu"],denominators=["du"]).denominators == (("du",Decimal(1)),)
              assert Unit(magnitude=10.1,numerators=["nu"],denominators=["du"]).magnitude    == 10.1
              # Multiple Duplicate Numerators and Denominators
              assert Unit(magnitude=10.1,numerators=["nu","nu","nu"],denominators=["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(magnitude=10.1,numerators=["nu","nu","nu"],denominators=["du","du"]).numerators   == (("nu",Decimal(3)),)
              assert Unit(magnitude=10.1,numerators=["nu","nu","nu"],denominators=["du","du"]).denominators == (("du",Decimal(2)),)
              assert Unit(magnitude=10.1,numerators=["nu","nu","nu"],denominators=["du","du"]).magnitude    == 10.1
              # Multiple Different Numerators and Denominators
              assert Unit(magnitude=10.1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(magnitude=10.1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(magnitude=10.1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
              assert Unit(magnitude=10.1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).magnitude    == 10.1
            # Canceling
            if(True):
              # Single
              assert Unit(magnitude=10.1,numerators=["u"],denominators=["u"]).symbols      == ()
              assert Unit(magnitude=10.1,numerators=["u"],denominators=["u"]).numerators   == ()
              assert Unit(magnitude=10.1,numerators=["u"],denominators=["u"]).denominators == ()
              assert Unit(magnitude=10.1,numerators=["u"],denominators=["u"]).magnitude    == 10.1
              # Multiple Duplicate
              assert Unit(magnitude=10.1,numerators=["u","u","u"],denominators=["u","u","u"]).symbols      == ()
              assert Unit(magnitude=10.1,numerators=["u","u","u"],denominators=["u","u","u"]).numerators   == ()
              assert Unit(magnitude=10.1,numerators=["u","u","u"],denominators=["u","u","u"]).denominators == ()
              assert Unit(magnitude=10.1,numerators=["u","u","u"],denominators=["u","u","u"]).magnitude    == 10.1
              # Multiple Different
              assert Unit(magnitude=10.1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).symbols      == ()
              assert Unit(magnitude=10.1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(magnitude=10.1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude=10.1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).magnitude    == 10.1
              # Partial Canceling
              assert Unit(magnitude=10.1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).symbols      == (("ub",Decimal(1)),)
              assert Unit(magnitude=10.1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).numerators   == (("ub",Decimal(1)),)
              assert Unit(magnitude=10.1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).denominators == ()
              assert Unit(magnitude=10.1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).magnitude    == 10.1
          # Negative Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(magnitude=-10.1,symbols=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude=-10.1,symbols=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude=-10.1,symbols=["u"]).denominators == ()
              assert Unit(magnitude=-10.1,symbols=["u"]).magnitude    == -10.1
              # Multiple Duplicate Numerators
              assert Unit(magnitude=-10.1,symbols=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=-10.1,symbols=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=-10.1,symbols=["u","u"]).denominators == ()
              assert Unit(magnitude=-10.1,symbols=["u","u"]).magnitude    == -10.1
              # Multiple Different Numerators
              assert Unit(magnitude=-10.1,symbols=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10.1,symbols=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10.1,symbols=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude=-10.1,symbols=["ua","ub","ub"]).magnitude    == -10.1
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(magnitude=-10.1,numerators=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude=-10.1,numerators=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude=-10.1,numerators=["u"]).denominators == ()
              assert Unit(magnitude=-10.1,numerators=["u"]).magnitude    == -10.1
              # Multiple Duplicate Numerators
              assert Unit(magnitude=-10.1,numerators=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=-10.1,numerators=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=-10.1,numerators=["u","u"]).denominators == ()
              assert Unit(magnitude=-10.1,numerators=["u","u"]).magnitude    == -10.1
              # Multiple Different Numerators
              assert Unit(magnitude=-10.1,numerators=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10.1,numerators=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10.1,numerators=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude=-10.1,numerators=["ua","ub","ub"]).magnitude    == -10.1
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(magnitude=-10.1,denominators=["u"]).symbols      == (("u",Decimal(-1)),)
              assert Unit(magnitude=-10.1,denominators=["u"]).numerators   == ()
              assert Unit(magnitude=-10.1,denominators=["u"]).denominators == (("u",Decimal(1)),)
              assert Unit(magnitude=-10.1,denominators=["u"]).magnitude    == -10.1
              # Multiple Duplicate Numerators
              assert Unit(magnitude=-10.1,denominators=["u","u"]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude=-10.1,denominators=["u","u"]).numerators   == ()
              assert Unit(magnitude=-10.1,denominators=["u","u"]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude=-10.1,denominators=["u","u"]).magnitude    == -10.1
              # Multiple Different Numerators
              assert Unit(magnitude=-10.1,denominators=["ua","ub","ub"]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(magnitude=-10.1,denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(magnitude=-10.1,denominators=["ua","ub","ub"]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10.1,denominators=["ua","ub","ub"]).magnitude    == -10.1
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(magnitude=-10.1,numerators=["nu"],denominators=["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(magnitude=-10.1,numerators=["nu"],denominators=["du"]).numerators   == (("nu",Decimal(1)),)
              assert Unit(magnitude=-10.1,numerators=["nu"],denominators=["du"]).denominators == (("du",Decimal(1)),)
              assert Unit(magnitude=-10.1,numerators=["nu"],denominators=["du"]).magnitude    == -10.1
              # Multiple Duplicate Numerators and Denominators
              assert Unit(magnitude=-10.1,numerators=["nu","nu","nu"],denominators=["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(magnitude=-10.1,numerators=["nu","nu","nu"],denominators=["du","du"]).numerators   == (("nu",Decimal(3)),)
              assert Unit(magnitude=-10.1,numerators=["nu","nu","nu"],denominators=["du","du"]).denominators == (("du",Decimal(2)),)
              assert Unit(magnitude=-10.1,numerators=["nu","nu","nu"],denominators=["du","du"]).magnitude    == -10.1
              # Multiple Different Numerators and Denominators
              assert Unit(magnitude=-10.1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(magnitude=-10.1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(magnitude=-10.1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
              assert Unit(magnitude=-10.1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).magnitude    == -10.1
            # Canceling
            if(True):
              # Single
              assert Unit(magnitude=-10.1,numerators=["u"],denominators=["u"]).symbols      == ()
              assert Unit(magnitude=-10.1,numerators=["u"],denominators=["u"]).numerators   == ()
              assert Unit(magnitude=-10.1,numerators=["u"],denominators=["u"]).denominators == ()
              assert Unit(magnitude=-10.1,numerators=["u"],denominators=["u"]).magnitude    == -10.1
              # Multiple Duplicate
              assert Unit(magnitude=-10.1,numerators=["u","u","u"],denominators=["u","u","u"]).symbols      == ()
              assert Unit(magnitude=-10.1,numerators=["u","u","u"],denominators=["u","u","u"]).numerators   == ()
              assert Unit(magnitude=-10.1,numerators=["u","u","u"],denominators=["u","u","u"]).denominators == ()
              assert Unit(magnitude=-10.1,numerators=["u","u","u"],denominators=["u","u","u"]).magnitude    == -10.1
              # Multiple Different
              assert Unit(magnitude=-10.1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).symbols      == ()
              assert Unit(magnitude=-10.1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(magnitude=-10.1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude=-10.1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).magnitude    == -10.1
              # Partial Canceling
              assert Unit(magnitude=-10.1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).symbols      == (("ub",Decimal(1)),)
              assert Unit(magnitude=-10.1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).numerators   == (("ub",Decimal(1)),)
              assert Unit(magnitude=-10.1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).denominators == ()
              assert Unit(magnitude=-10.1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).magnitude    == -10.1
        # Tuple of String, Exponent
        if(True):
          # Positive Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(magnitude=10.1,symbols=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude=10.1,symbols=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude=10.1,symbols=[("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude=10.1,symbols=[("u",Decimal(1))]).magnitude    == 10.1
              # Single Numerator Higher Exponent
              assert Unit(magnitude=10.1,symbols=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=10.1,symbols=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=10.1,symbols=[("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude=10.1,symbols=[("u",Decimal(2))]).magnitude    == 10.1
              # Multiple Duplicate Numerators
              assert Unit(magnitude=10.1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=10.1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=10.1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude=10.1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == 10.1
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(magnitude=10.1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(magnitude=10.1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(magnitude=10.1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude=10.1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == 10.1
              # Multiple Different Numerators
              assert Unit(magnitude=10.1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10.1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10.1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(magnitude=10.1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == 10.1
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(magnitude=10.1,numerators=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude=10.1,numerators=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude=10.1,numerators=[("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude=10.1,numerators=[("u",Decimal(1))]).magnitude    == 10.1
              # Single Numerator Higher Exponent
              assert Unit(magnitude=10.1,numerators=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=10.1,numerators=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=10.1,numerators=[("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude=10.1,numerators=[("u",Decimal(2))]).magnitude    == 10.1
              # Multiple Duplicate Numerators
              assert Unit(magnitude=10.1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=10.1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=10.1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude=10.1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == 10.1
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(magnitude=10.1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(magnitude=10.1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(magnitude=10.1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude=10.1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == 10.1
              # Multiple Different Numerators
              assert Unit(magnitude=10.1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10.1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10.1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(magnitude=10.1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == 10.1
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(magnitude=10.1,denominators=[("u",Decimal(1))]).symbols      == (("u",Decimal(-1)),)
              assert Unit(magnitude=10.1,denominators=[("u",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=10.1,denominators=[("u",Decimal(1))]).denominators == (("u",Decimal(1)),)
              assert Unit(magnitude=10.1,denominators=[("u",Decimal(1))]).magnitude    == 10.1
              # Single Numerator Higher Exponent
              assert Unit(magnitude=10.1,denominators=[("u",Decimal(2))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude=10.1,denominators=[("u",Decimal(2))]).numerators   == ()
              assert Unit(magnitude=10.1,denominators=[("u",Decimal(2))]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude=10.1,denominators=[("u",Decimal(2))]).magnitude    == 10.1
              # Multiple Duplicate Numerators
              assert Unit(magnitude=10.1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude=10.1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=10.1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude=10.1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == 10.1
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(magnitude=10.1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(-3)),)
              assert Unit(magnitude=10.1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == ()
              assert Unit(magnitude=10.1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == (("u",Decimal(3)),)
              assert Unit(magnitude=10.1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == 10.1
              # Multiple Different Numerators
              assert Unit(magnitude=10.1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(magnitude=10.1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == ()
              assert Unit(magnitude=10.1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10.1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == 10.1
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).numerators   == (("nu",Decimal(1)),)
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).denominators == (("du",Decimal(1)),)
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).magnitude    == 10.1
              # Single Numerator and Denominator Higher Exponent
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).numerators   == (("nu",Decimal(2)),)
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).denominators == (("du",Decimal(3)),)
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).magnitude    == 10.1
              # Multiple Duplicate Numerators and Denominators
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).numerators   == (("nu",Decimal(3)),)
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).denominators == (("du",Decimal(2)),)
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).magnitude    == 10.1
              # Multiple Duplicate Numerators and Denominators Higher Exponent
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).numerators   == (("nu",Decimal(4)),)
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).denominators == (("du",Decimal(4)),)
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).magnitude    == 10.1
              # Multiple Different Numerators and Denominators
              assert Unit(magnitude=10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(magnitude=10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(magnitude=10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
              assert Unit(magnitude=10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).magnitude    == 10.1
            # Canceling
            if(True):
              # Single
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).symbols      == ()
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).denominators == ()
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).magnitude    == 10.1
              # Single Higher Exponent
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).symbols      == ()
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).numerators   == ()
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).denominators == ()
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).magnitude    == 10.1
              # Multiple Duplicate
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == 10.1
              # Multiple Duplicate Higher Exponent
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(magnitude=10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == 10.1
              # Multiple Different
              assert Unit(magnitude=10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).symbols      == ()
              assert Unit(magnitude=10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).denominators == ()
              assert Unit(magnitude=10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).magnitude    == 10.1
              # Partial
              assert Unit(magnitude=10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
              assert Unit(magnitude=10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).numerators   == (("nua",Decimal(1)),)
              assert Unit(magnitude=10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).denominators == (("nub",Decimal(1)),)
              assert Unit(magnitude=10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).magnitude    == 10.1
          # Negative Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(magnitude=-10.1,symbols=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude=-10.1,symbols=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude=-10.1,symbols=[("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude=-10.1,symbols=[("u",Decimal(1))]).magnitude    == -10.1
              # Single Numerator Higher Exponent
              assert Unit(magnitude=-10.1,symbols=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=-10.1,symbols=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=-10.1,symbols=[("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude=-10.1,symbols=[("u",Decimal(2))]).magnitude    == -10.1
              # Multiple Duplicate Numerators
              assert Unit(magnitude=-10.1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=-10.1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=-10.1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude=-10.1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == -10.1
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(magnitude=-10.1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(magnitude=-10.1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(magnitude=-10.1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude=-10.1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == -10.1
              # Multiple Different Numerators
              assert Unit(magnitude=-10.1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10.1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10.1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(magnitude=-10.1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == -10.1
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(magnitude=-10.1,numerators=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude=-10.1,numerators=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude=-10.1,numerators=[("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude=-10.1,numerators=[("u",Decimal(1))]).magnitude    == -10.1
              # Single Numerator Higher Exponent
              assert Unit(magnitude=-10.1,numerators=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=-10.1,numerators=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=-10.1,numerators=[("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude=-10.1,numerators=[("u",Decimal(2))]).magnitude    == -10.1
              # Multiple Duplicate Numerators
              assert Unit(magnitude=-10.1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=-10.1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=-10.1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude=-10.1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == -10.1
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(magnitude=-10.1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(magnitude=-10.1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(magnitude=-10.1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude=-10.1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == -10.1
              # Multiple Different Numerators
              assert Unit(magnitude=-10.1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10.1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10.1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(magnitude=-10.1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == -10.1
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(magnitude=-10.1,denominators=[("u",Decimal(1))]).symbols      == (("u",Decimal(-1)),)
              assert Unit(magnitude=-10.1,denominators=[("u",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=-10.1,denominators=[("u",Decimal(1))]).denominators == (("u",Decimal(1)),)
              assert Unit(magnitude=-10.1,denominators=[("u",Decimal(1))]).magnitude    == -10.1
              # Single Numerator Higher Exponent
              assert Unit(magnitude=-10.1,denominators=[("u",Decimal(2))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude=-10.1,denominators=[("u",Decimal(2))]).numerators   == ()
              assert Unit(magnitude=-10.1,denominators=[("u",Decimal(2))]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude=-10.1,denominators=[("u",Decimal(2))]).magnitude    == -10.1
              # Multiple Duplicate Numerators
              assert Unit(magnitude=-10.1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude=-10.1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=-10.1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude=-10.1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == -10.1
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(magnitude=-10.1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(-3)),)
              assert Unit(magnitude=-10.1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == ()
              assert Unit(magnitude=-10.1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == (("u",Decimal(3)),)
              assert Unit(magnitude=-10.1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == -10.1
              # Multiple Different Numerators
              assert Unit(magnitude=-10.1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(magnitude=-10.1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == ()
              assert Unit(magnitude=-10.1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10.1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == -10.1
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).numerators   == (("nu",Decimal(1)),)
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).denominators == (("du",Decimal(1)),)
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).magnitude    == -10.1
              # Single Numerator and Denominator Higher Exponent
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).numerators   == (("nu",Decimal(2)),)
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).denominators == (("du",Decimal(3)),)
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).magnitude    == -10.1
              # Multiple Duplicate Numerators and Denominators
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).numerators   == (("nu",Decimal(3)),)
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).denominators == (("du",Decimal(2)),)
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).magnitude    == -10.1
              # Multiple Duplicate Numerators and Denominators Higher Exponent
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).numerators   == (("nu",Decimal(4)),)
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).denominators == (("du",Decimal(4)),)
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).magnitude    == -10.1
              # Multiple Different Numerators and Denominators
              assert Unit(magnitude=-10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(magnitude=-10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(magnitude=-10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
              assert Unit(magnitude=-10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).magnitude    == -10.1
            # Canceling
            if(True):
              # Single
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).symbols      == ()
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).denominators == ()
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).magnitude    == -10.1
              # Single Higher Exponent
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).symbols      == ()
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).numerators   == ()
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).denominators == ()
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).magnitude    == -10.1
              # Multiple Duplicate
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == -10.1
              # Multiple Duplicate Higher Exponent
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(magnitude=-10.1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == -10.1
              # Multiple Different
              assert Unit(magnitude=-10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).symbols      == ()
              assert Unit(magnitude=-10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=-10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).denominators == ()
              assert Unit(magnitude=-10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).magnitude    == -10.1
              # Partial
              assert Unit(magnitude=-10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
              assert Unit(magnitude=-10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).numerators   == (("nua",Decimal(1)),)
              assert Unit(magnitude=-10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).denominators == (("nub",Decimal(1)),)
              assert Unit(magnitude=-10.1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).magnitude    == -10.1
        # Tuple of Strings
        if(True):
          # Positive Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(magnitude=10e1,symbols=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude=10e1,symbols=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude=10e1,symbols=["u"]).denominators == ()
              assert Unit(magnitude=10e1,symbols=["u"]).magnitude    == 10e1
              # Multiple Duplicate Numerators
              assert Unit(magnitude=10e1,symbols=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=10e1,symbols=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=10e1,symbols=["u","u"]).denominators == ()
              assert Unit(magnitude=10e1,symbols=["u","u"]).magnitude    == 10e1
              # Multiple Different Numerators
              assert Unit(magnitude=10e1,symbols=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10e1,symbols=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10e1,symbols=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude=10e1,symbols=["ua","ub","ub"]).magnitude    == 10e1
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(magnitude=10e1,numerators=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude=10e1,numerators=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude=10e1,numerators=["u"]).denominators == ()
              assert Unit(magnitude=10e1,numerators=["u"]).magnitude    == 10e1
              # Multiple Duplicate Numerators
              assert Unit(magnitude=10e1,numerators=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=10e1,numerators=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=10e1,numerators=["u","u"]).denominators == ()
              assert Unit(magnitude=10e1,numerators=["u","u"]).magnitude    == 10e1
              # Multiple Different Numerators
              assert Unit(magnitude=10e1,numerators=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10e1,numerators=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10e1,numerators=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude=10e1,numerators=["ua","ub","ub"]).magnitude    == 10e1
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(magnitude=10e1,denominators=["u"]).symbols      == (("u",Decimal(-1)),)
              assert Unit(magnitude=10e1,denominators=["u"]).numerators   == ()
              assert Unit(magnitude=10e1,denominators=["u"]).denominators == (("u",Decimal(1)),)
              assert Unit(magnitude=10e1,denominators=["u"]).magnitude    == 10e1
              # Multiple Duplicate Numerators
              assert Unit(magnitude=10e1,denominators=["u","u"]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude=10e1,denominators=["u","u"]).numerators   == ()
              assert Unit(magnitude=10e1,denominators=["u","u"]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude=10e1,denominators=["u","u"]).magnitude    == 10e1
              # Multiple Different Numerators
              assert Unit(magnitude=10e1,denominators=["ua","ub","ub"]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(magnitude=10e1,denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(magnitude=10e1,denominators=["ua","ub","ub"]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10e1,denominators=["ua","ub","ub"]).magnitude    == 10e1
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(magnitude=10e1,numerators=["nu"],denominators=["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(magnitude=10e1,numerators=["nu"],denominators=["du"]).numerators   == (("nu",Decimal(1)),)
              assert Unit(magnitude=10e1,numerators=["nu"],denominators=["du"]).denominators == (("du",Decimal(1)),)
              assert Unit(magnitude=10e1,numerators=["nu"],denominators=["du"]).magnitude    == 10e1
              # Multiple Duplicate Numerators and Denominators
              assert Unit(magnitude=10e1,numerators=["nu","nu","nu"],denominators=["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(magnitude=10e1,numerators=["nu","nu","nu"],denominators=["du","du"]).numerators   == (("nu",Decimal(3)),)
              assert Unit(magnitude=10e1,numerators=["nu","nu","nu"],denominators=["du","du"]).denominators == (("du",Decimal(2)),)
              assert Unit(magnitude=10e1,numerators=["nu","nu","nu"],denominators=["du","du"]).magnitude    == 10e1
              # Multiple Different Numerators and Denominators
              assert Unit(magnitude=10e1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(magnitude=10e1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(magnitude=10e1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
              assert Unit(magnitude=10e1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).magnitude    == 10e1
            # Canceling
            if(True):
              # Single
              assert Unit(magnitude=10e1,numerators=["u"],denominators=["u"]).symbols      == ()
              assert Unit(magnitude=10e1,numerators=["u"],denominators=["u"]).numerators   == ()
              assert Unit(magnitude=10e1,numerators=["u"],denominators=["u"]).denominators == ()
              assert Unit(magnitude=10e1,numerators=["u"],denominators=["u"]).magnitude    == 10e1
              # Multiple Duplicate
              assert Unit(magnitude=10e1,numerators=["u","u","u"],denominators=["u","u","u"]).symbols      == ()
              assert Unit(magnitude=10e1,numerators=["u","u","u"],denominators=["u","u","u"]).numerators   == ()
              assert Unit(magnitude=10e1,numerators=["u","u","u"],denominators=["u","u","u"]).denominators == ()
              assert Unit(magnitude=10e1,numerators=["u","u","u"],denominators=["u","u","u"]).magnitude    == 10e1
              # Multiple Different
              assert Unit(magnitude=10e1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).symbols      == ()
              assert Unit(magnitude=10e1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(magnitude=10e1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude=10e1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).magnitude    == 10e1
              # Partial Canceling
              assert Unit(magnitude=10e1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).symbols      == (("ub",Decimal(1)),)
              assert Unit(magnitude=10e1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).numerators   == (("ub",Decimal(1)),)
              assert Unit(magnitude=10e1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).denominators == ()
              assert Unit(magnitude=10e1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).magnitude    == 10e1
          # Negative Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(magnitude=-10e1,symbols=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude=-10e1,symbols=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude=-10e1,symbols=["u"]).denominators == ()
              assert Unit(magnitude=-10e1,symbols=["u"]).magnitude    == -10e1
              # Multiple Duplicate Numerators
              assert Unit(magnitude=-10e1,symbols=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=-10e1,symbols=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=-10e1,symbols=["u","u"]).denominators == ()
              assert Unit(magnitude=-10e1,symbols=["u","u"]).magnitude    == -10e1
              # Multiple Different Numerators
              assert Unit(magnitude=-10e1,symbols=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10e1,symbols=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10e1,symbols=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude=-10e1,symbols=["ua","ub","ub"]).magnitude    == -10e1
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(magnitude=-10e1,numerators=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude=-10e1,numerators=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude=-10e1,numerators=["u"]).denominators == ()
              assert Unit(magnitude=-10e1,numerators=["u"]).magnitude    == -10e1
              # Multiple Duplicate Numerators
              assert Unit(magnitude=-10e1,numerators=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=-10e1,numerators=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=-10e1,numerators=["u","u"]).denominators == ()
              assert Unit(magnitude=-10e1,numerators=["u","u"]).magnitude    == -10e1
              # Multiple Different Numerators
              assert Unit(magnitude=-10e1,numerators=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10e1,numerators=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10e1,numerators=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude=-10e1,numerators=["ua","ub","ub"]).magnitude    == -10e1
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(magnitude=-10e1,denominators=["u"]).symbols      == (("u",Decimal(-1)),)
              assert Unit(magnitude=-10e1,denominators=["u"]).numerators   == ()
              assert Unit(magnitude=-10e1,denominators=["u"]).denominators == (("u",Decimal(1)),)
              assert Unit(magnitude=-10e1,denominators=["u"]).magnitude    == -10e1
              # Multiple Duplicate Numerators
              assert Unit(magnitude=-10e1,denominators=["u","u"]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude=-10e1,denominators=["u","u"]).numerators   == ()
              assert Unit(magnitude=-10e1,denominators=["u","u"]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude=-10e1,denominators=["u","u"]).magnitude    == -10e1
              # Multiple Different Numerators
              assert Unit(magnitude=-10e1,denominators=["ua","ub","ub"]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(magnitude=-10e1,denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(magnitude=-10e1,denominators=["ua","ub","ub"]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10e1,denominators=["ua","ub","ub"]).magnitude    == -10e1
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(magnitude=-10e1,numerators=["nu"],denominators=["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(magnitude=-10e1,numerators=["nu"],denominators=["du"]).numerators   == (("nu",Decimal(1)),)
              assert Unit(magnitude=-10e1,numerators=["nu"],denominators=["du"]).denominators == (("du",Decimal(1)),)
              assert Unit(magnitude=-10e1,numerators=["nu"],denominators=["du"]).magnitude    == -10e1
              # Multiple Duplicate Numerators and Denominators
              assert Unit(magnitude=-10e1,numerators=["nu","nu","nu"],denominators=["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(magnitude=-10e1,numerators=["nu","nu","nu"],denominators=["du","du"]).numerators   == (("nu",Decimal(3)),)
              assert Unit(magnitude=-10e1,numerators=["nu","nu","nu"],denominators=["du","du"]).denominators == (("du",Decimal(2)),)
              assert Unit(magnitude=-10e1,numerators=["nu","nu","nu"],denominators=["du","du"]).magnitude    == -10e1
              # Multiple Different Numerators and Denominators
              assert Unit(magnitude=-10e1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(magnitude=-10e1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(magnitude=-10e1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
              assert Unit(magnitude=-10e1,numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).magnitude    == -10e1
            # Canceling
            if(True):
              # Single
              assert Unit(magnitude=-10e1,numerators=["u"],denominators=["u"]).symbols      == ()
              assert Unit(magnitude=-10e1,numerators=["u"],denominators=["u"]).numerators   == ()
              assert Unit(magnitude=-10e1,numerators=["u"],denominators=["u"]).denominators == ()
              assert Unit(magnitude=-10e1,numerators=["u"],denominators=["u"]).magnitude    == -10e1
              # Multiple Duplicate
              assert Unit(magnitude=-10e1,numerators=["u","u","u"],denominators=["u","u","u"]).symbols      == ()
              assert Unit(magnitude=-10e1,numerators=["u","u","u"],denominators=["u","u","u"]).numerators   == ()
              assert Unit(magnitude=-10e1,numerators=["u","u","u"],denominators=["u","u","u"]).denominators == ()
              assert Unit(magnitude=-10e1,numerators=["u","u","u"],denominators=["u","u","u"]).magnitude    == -10e1
              # Multiple Different
              assert Unit(magnitude=-10e1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).symbols      == ()
              assert Unit(magnitude=-10e1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(magnitude=-10e1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude=-10e1,numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).magnitude    == -10e1
              # Partial Canceling
              assert Unit(magnitude=-10e1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).symbols      == (("ub",Decimal(1)),)
              assert Unit(magnitude=-10e1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).numerators   == (("ub",Decimal(1)),)
              assert Unit(magnitude=-10e1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).denominators == ()
              assert Unit(magnitude=-10e1,numerators=["ua","ub","ub"],denominators=["ua","ub"]).magnitude    == -10e1
        # Tuple of String, Exponent
        if(True):
          # Positive Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(magnitude=10e1,symbols=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude=10e1,symbols=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude=10e1,symbols=[("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude=10e1,symbols=[("u",Decimal(1))]).magnitude    == 10e1
              # Single Numerator Higher Exponent
              assert Unit(magnitude=10e1,symbols=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=10e1,symbols=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=10e1,symbols=[("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude=10e1,symbols=[("u",Decimal(2))]).magnitude    == 10e1
              # Multiple Duplicate Numerators
              assert Unit(magnitude=10e1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=10e1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=10e1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude=10e1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == 10e1
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(magnitude=10e1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(magnitude=10e1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(magnitude=10e1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude=10e1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == 10e1
              # Multiple Different Numerators
              assert Unit(magnitude=10e1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10e1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10e1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(magnitude=10e1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == 10e1
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(magnitude=10e1,numerators=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude=10e1,numerators=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude=10e1,numerators=[("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude=10e1,numerators=[("u",Decimal(1))]).magnitude    == 10e1
              # Single Numerator Higher Exponent
              assert Unit(magnitude=10e1,numerators=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=10e1,numerators=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=10e1,numerators=[("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude=10e1,numerators=[("u",Decimal(2))]).magnitude    == 10e1
              # Multiple Duplicate Numerators
              assert Unit(magnitude=10e1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=10e1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=10e1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude=10e1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == 10e1
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(magnitude=10e1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(magnitude=10e1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(magnitude=10e1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude=10e1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == 10e1
              # Multiple Different Numerators
              assert Unit(magnitude=10e1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10e1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10e1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(magnitude=10e1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == 10e1
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(magnitude=10e1,denominators=[("u",Decimal(1))]).symbols      == (("u",Decimal(-1)),)
              assert Unit(magnitude=10e1,denominators=[("u",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=10e1,denominators=[("u",Decimal(1))]).denominators == (("u",Decimal(1)),)
              assert Unit(magnitude=10e1,denominators=[("u",Decimal(1))]).magnitude    == 10e1
              # Single Numerator Higher Exponent
              assert Unit(magnitude=10e1,denominators=[("u",Decimal(2))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude=10e1,denominators=[("u",Decimal(2))]).numerators   == ()
              assert Unit(magnitude=10e1,denominators=[("u",Decimal(2))]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude=10e1,denominators=[("u",Decimal(2))]).magnitude    == 10e1
              # Multiple Duplicate Numerators
              assert Unit(magnitude=10e1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude=10e1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=10e1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude=10e1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == 10e1
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(magnitude=10e1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(-3)),)
              assert Unit(magnitude=10e1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == ()
              assert Unit(magnitude=10e1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == (("u",Decimal(3)),)
              assert Unit(magnitude=10e1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == 10e1
              # Multiple Different Numerators
              assert Unit(magnitude=10e1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(magnitude=10e1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == ()
              assert Unit(magnitude=10e1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=10e1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == 10e1
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).numerators   == (("nu",Decimal(1)),)
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).denominators == (("du",Decimal(1)),)
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).magnitude    == 10e1
              # Single Numerator and Denominator Higher Exponent
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).numerators   == (("nu",Decimal(2)),)
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).denominators == (("du",Decimal(3)),)
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).magnitude    == 10e1
              # Multiple Duplicate Numerators and Denominators
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).numerators   == (("nu",Decimal(3)),)
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).denominators == (("du",Decimal(2)),)
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).magnitude    == 10e1
              # Multiple Duplicate Numerators and Denominators Higher Exponent
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).numerators   == (("nu",Decimal(4)),)
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).denominators == (("du",Decimal(4)),)
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).magnitude    == 10e1
              # Multiple Different Numerators and Denominators
              assert Unit(magnitude=10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(magnitude=10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(magnitude=10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
              assert Unit(magnitude=10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).magnitude    == 10e1
            # Canceling
            if(True):
              # Single
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).symbols      == ()
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).denominators == ()
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).magnitude    == 10e1
              # Single Higher Exponent
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).symbols      == ()
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).numerators   == ()
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).denominators == ()
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).magnitude    == 10e1
              # Multiple Duplicate
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == 10e1
              # Multiple Duplicate Higher Exponent
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(magnitude=10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == 10e1
              # Multiple Different
              assert Unit(magnitude=10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).symbols      == ()
              assert Unit(magnitude=10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).denominators == ()
              assert Unit(magnitude=10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).magnitude    == 10e1
              # Partial
              assert Unit(magnitude=10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
              assert Unit(magnitude=10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).numerators   == (("nua",Decimal(1)),)
              assert Unit(magnitude=10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).denominators == (("nub",Decimal(1)),)
              assert Unit(magnitude=10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).magnitude    == 10e1
          # Negative Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(magnitude=-10e1,symbols=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude=-10e1,symbols=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude=-10e1,symbols=[("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude=-10e1,symbols=[("u",Decimal(1))]).magnitude    == -10e1
              # Single Numerator Higher Exponent
              assert Unit(magnitude=-10e1,symbols=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=-10e1,symbols=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=-10e1,symbols=[("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude=-10e1,symbols=[("u",Decimal(2))]).magnitude    == -10e1
              # Multiple Duplicate Numerators
              assert Unit(magnitude=-10e1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=-10e1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=-10e1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude=-10e1,symbols=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == -10e1
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(magnitude=-10e1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(magnitude=-10e1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(magnitude=-10e1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude=-10e1,symbols=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == -10e1
              # Multiple Different Numerators
              assert Unit(magnitude=-10e1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10e1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10e1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(magnitude=-10e1,symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == -10e1
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(magnitude=-10e1,numerators=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude=-10e1,numerators=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude=-10e1,numerators=[("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude=-10e1,numerators=[("u",Decimal(1))]).magnitude    == -10e1
              # Single Numerator Higher Exponent
              assert Unit(magnitude=-10e1,numerators=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=-10e1,numerators=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=-10e1,numerators=[("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude=-10e1,numerators=[("u",Decimal(2))]).magnitude    == -10e1
              # Multiple Duplicate Numerators
              assert Unit(magnitude=-10e1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude=-10e1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude=-10e1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude=-10e1,numerators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == -10e1
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(magnitude=-10e1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(magnitude=-10e1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(magnitude=-10e1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude=-10e1,numerators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == -10e1
              # Multiple Different Numerators
              assert Unit(magnitude=-10e1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10e1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10e1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(magnitude=-10e1,numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == -10e1
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(magnitude=-10e1,denominators=[("u",Decimal(1))]).symbols      == (("u",Decimal(-1)),)
              assert Unit(magnitude=-10e1,denominators=[("u",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=-10e1,denominators=[("u",Decimal(1))]).denominators == (("u",Decimal(1)),)
              assert Unit(magnitude=-10e1,denominators=[("u",Decimal(1))]).magnitude    == -10e1
              # Single Numerator Higher Exponent
              assert Unit(magnitude=-10e1,denominators=[("u",Decimal(2))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude=-10e1,denominators=[("u",Decimal(2))]).numerators   == ()
              assert Unit(magnitude=-10e1,denominators=[("u",Decimal(2))]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude=-10e1,denominators=[("u",Decimal(2))]).magnitude    == -10e1
              # Multiple Duplicate Numerators
              assert Unit(magnitude=-10e1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude=-10e1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=-10e1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude=-10e1,denominators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == -10e1
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(magnitude=-10e1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(-3)),)
              assert Unit(magnitude=-10e1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == ()
              assert Unit(magnitude=-10e1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == (("u",Decimal(3)),)
              assert Unit(magnitude=-10e1,denominators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == -10e1
              # Multiple Different Numerators
              assert Unit(magnitude=-10e1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(magnitude=-10e1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == ()
              assert Unit(magnitude=-10e1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude=-10e1,denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == -10e1
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).numerators   == (("nu",Decimal(1)),)
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).denominators == (("du",Decimal(1)),)
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).magnitude    == -10e1
              # Single Numerator and Denominator Higher Exponent
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).numerators   == (("nu",Decimal(2)),)
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).denominators == (("du",Decimal(3)),)
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).magnitude    == -10e1
              # Multiple Duplicate Numerators and Denominators
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).numerators   == (("nu",Decimal(3)),)
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).denominators == (("du",Decimal(2)),)
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).magnitude    == -10e1
              # Multiple Duplicate Numerators and Denominators Higher Exponent
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).numerators   == (("nu",Decimal(4)),)
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).denominators == (("du",Decimal(4)),)
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).magnitude    == -10e1
              # Multiple Different Numerators and Denominators
              assert Unit(magnitude=-10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(magnitude=-10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(magnitude=-10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
              assert Unit(magnitude=-10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).magnitude    == -10e1
            # Canceling
            if(True):
              # Single
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).symbols      == ()
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).denominators == ()
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).magnitude    == -10e1
              # Single Higher Exponent
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).symbols      == ()
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).numerators   == ()
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).denominators == ()
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).magnitude    == -10e1
              # Multiple Duplicate
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == -10e1
              # Multiple Duplicate Higher Exponent
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(magnitude=-10e1,numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == -10e1
              # Multiple Different
              assert Unit(magnitude=-10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).symbols      == ()
              assert Unit(magnitude=-10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).numerators   == ()
              assert Unit(magnitude=-10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).denominators == ()
              assert Unit(magnitude=-10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).magnitude    == -10e1
              # Partial
              assert Unit(magnitude=-10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
              assert Unit(magnitude=-10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).numerators   == (("nua",Decimal(1)),)
              assert Unit(magnitude=-10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).denominators == (("nub",Decimal(1)),)
              assert Unit(magnitude=-10e1,numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).magnitude    == -10e1
      # Explicit Symbols, Magnitude str
      if(True):
        # Tuple of Strings
        if(True):
          # Positive Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(magnitude="10.1",symbols=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude="10.1",symbols=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude="10.1",symbols=["u"]).denominators == ()
              assert Unit(magnitude="10.1",symbols=["u"]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators
              assert Unit(magnitude="10.1",symbols=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude="10.1",symbols=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude="10.1",symbols=["u","u"]).denominators == ()
              assert Unit(magnitude="10.1",symbols=["u","u"]).magnitude    == Decimal("10.1")
              # Multiple Different Numerators
              assert Unit(magnitude="10.1",symbols=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="10.1",symbols=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="10.1",symbols=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude="10.1",symbols=["ua","ub","ub"]).magnitude    == Decimal("10.1")
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(magnitude="10.1",numerators=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude="10.1",numerators=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude="10.1",numerators=["u"]).denominators == ()
              assert Unit(magnitude="10.1",numerators=["u"]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators
              assert Unit(magnitude="10.1",numerators=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude="10.1",numerators=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude="10.1",numerators=["u","u"]).denominators == ()
              assert Unit(magnitude="10.1",numerators=["u","u"]).magnitude    == Decimal("10.1")
              # Multiple Different Numerators
              assert Unit(magnitude="10.1",numerators=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="10.1",numerators=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="10.1",numerators=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude="10.1",numerators=["ua","ub","ub"]).magnitude    == Decimal("10.1")
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(magnitude="10.1",denominators=["u"]).symbols      == (("u",Decimal(-1)),)
              assert Unit(magnitude="10.1",denominators=["u"]).numerators   == ()
              assert Unit(magnitude="10.1",denominators=["u"]).denominators == (("u",Decimal(1)),)
              assert Unit(magnitude="10.1",denominators=["u"]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators
              assert Unit(magnitude="10.1",denominators=["u","u"]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude="10.1",denominators=["u","u"]).numerators   == ()
              assert Unit(magnitude="10.1",denominators=["u","u"]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude="10.1",denominators=["u","u"]).magnitude    == Decimal("10.1")
              # Multiple Different Numerators
              assert Unit(magnitude="10.1",denominators=["ua","ub","ub"]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(magnitude="10.1",denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(magnitude="10.1",denominators=["ua","ub","ub"]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="10.1",denominators=["ua","ub","ub"]).magnitude    == Decimal("10.1")
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(magnitude="10.1",numerators=["nu"],denominators=["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(magnitude="10.1",numerators=["nu"],denominators=["du"]).numerators   == (("nu",Decimal(1)),)
              assert Unit(magnitude="10.1",numerators=["nu"],denominators=["du"]).denominators == (("du",Decimal(1)),)
              assert Unit(magnitude="10.1",numerators=["nu"],denominators=["du"]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators and Denominators
              assert Unit(magnitude="10.1",numerators=["nu","nu","nu"],denominators=["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(magnitude="10.1",numerators=["nu","nu","nu"],denominators=["du","du"]).numerators   == (("nu",Decimal(3)),)
              assert Unit(magnitude="10.1",numerators=["nu","nu","nu"],denominators=["du","du"]).denominators == (("du",Decimal(2)),)
              assert Unit(magnitude="10.1",numerators=["nu","nu","nu"],denominators=["du","du"]).magnitude    == Decimal("10.1")
              # Multiple Different Numerators and Denominators
              assert Unit(magnitude="10.1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(magnitude="10.1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(magnitude="10.1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
              assert Unit(magnitude="10.1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).magnitude    == Decimal("10.1")
            # Canceling
            if(True):
              # Single
              assert Unit(magnitude="10.1",numerators=["u"],denominators=["u"]).symbols      == ()
              assert Unit(magnitude="10.1",numerators=["u"],denominators=["u"]).numerators   == ()
              assert Unit(magnitude="10.1",numerators=["u"],denominators=["u"]).denominators == ()
              assert Unit(magnitude="10.1",numerators=["u"],denominators=["u"]).magnitude    == Decimal("10.1")
              # Multiple Duplicate
              assert Unit(magnitude="10.1",numerators=["u","u","u"],denominators=["u","u","u"]).symbols      == ()
              assert Unit(magnitude="10.1",numerators=["u","u","u"],denominators=["u","u","u"]).numerators   == ()
              assert Unit(magnitude="10.1",numerators=["u","u","u"],denominators=["u","u","u"]).denominators == ()
              assert Unit(magnitude="10.1",numerators=["u","u","u"],denominators=["u","u","u"]).magnitude    == Decimal("10.1")
              # Multiple Different
              assert Unit(magnitude="10.1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).symbols      == ()
              assert Unit(magnitude="10.1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(magnitude="10.1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude="10.1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).magnitude    == Decimal("10.1")
              # Partial Canceling
              assert Unit(magnitude="10.1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).symbols      == (("ub",Decimal(1)),)
              assert Unit(magnitude="10.1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).numerators   == (("ub",Decimal(1)),)
              assert Unit(magnitude="10.1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).denominators == ()
              assert Unit(magnitude="10.1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).magnitude    == Decimal("10.1")
          # Negative Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(magnitude="-10.1",symbols=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude="-10.1",symbols=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude="-10.1",symbols=["u"]).denominators == ()
              assert Unit(magnitude="-10.1",symbols=["u"]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators
              assert Unit(magnitude="-10.1",symbols=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude="-10.1",symbols=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude="-10.1",symbols=["u","u"]).denominators == ()
              assert Unit(magnitude="-10.1",symbols=["u","u"]).magnitude    == Decimal("-10.1")
              # Multiple Different Numerators
              assert Unit(magnitude="-10.1",symbols=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="-10.1",symbols=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="-10.1",symbols=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude="-10.1",symbols=["ua","ub","ub"]).magnitude    == Decimal("-10.1")
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(magnitude="-10.1",numerators=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude="-10.1",numerators=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude="-10.1",numerators=["u"]).denominators == ()
              assert Unit(magnitude="-10.1",numerators=["u"]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators
              assert Unit(magnitude="-10.1",numerators=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude="-10.1",numerators=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude="-10.1",numerators=["u","u"]).denominators == ()
              assert Unit(magnitude="-10.1",numerators=["u","u"]).magnitude    == Decimal("-10.1")
              # Multiple Different Numerators
              assert Unit(magnitude="-10.1",numerators=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="-10.1",numerators=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="-10.1",numerators=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude="-10.1",numerators=["ua","ub","ub"]).magnitude    == Decimal("-10.1")
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(magnitude="-10.1",denominators=["u"]).symbols      == (("u",Decimal(-1)),)
              assert Unit(magnitude="-10.1",denominators=["u"]).numerators   == ()
              assert Unit(magnitude="-10.1",denominators=["u"]).denominators == (("u",Decimal(1)),)
              assert Unit(magnitude="-10.1",denominators=["u"]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators
              assert Unit(magnitude="-10.1",denominators=["u","u"]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude="-10.1",denominators=["u","u"]).numerators   == ()
              assert Unit(magnitude="-10.1",denominators=["u","u"]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude="-10.1",denominators=["u","u"]).magnitude    == Decimal("-10.1")
              # Multiple Different Numerators
              assert Unit(magnitude="-10.1",denominators=["ua","ub","ub"]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(magnitude="-10.1",denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(magnitude="-10.1",denominators=["ua","ub","ub"]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="-10.1",denominators=["ua","ub","ub"]).magnitude    == Decimal("-10.1")
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(magnitude="-10.1",numerators=["nu"],denominators=["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(magnitude="-10.1",numerators=["nu"],denominators=["du"]).numerators   == (("nu",Decimal(1)),)
              assert Unit(magnitude="-10.1",numerators=["nu"],denominators=["du"]).denominators == (("du",Decimal(1)),)
              assert Unit(magnitude="-10.1",numerators=["nu"],denominators=["du"]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators and Denominators
              assert Unit(magnitude="-10.1",numerators=["nu","nu","nu"],denominators=["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(magnitude="-10.1",numerators=["nu","nu","nu"],denominators=["du","du"]).numerators   == (("nu",Decimal(3)),)
              assert Unit(magnitude="-10.1",numerators=["nu","nu","nu"],denominators=["du","du"]).denominators == (("du",Decimal(2)),)
              assert Unit(magnitude="-10.1",numerators=["nu","nu","nu"],denominators=["du","du"]).magnitude    == Decimal("-10.1")
              # Multiple Different Numerators and Denominators
              assert Unit(magnitude="-10.1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(magnitude="-10.1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(magnitude="-10.1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
              assert Unit(magnitude="-10.1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).magnitude    == Decimal("-10.1")
            # Canceling
            if(True):
              # Single
              assert Unit(magnitude="-10.1",numerators=["u"],denominators=["u"]).symbols      == ()
              assert Unit(magnitude="-10.1",numerators=["u"],denominators=["u"]).numerators   == ()
              assert Unit(magnitude="-10.1",numerators=["u"],denominators=["u"]).denominators == ()
              assert Unit(magnitude="-10.1",numerators=["u"],denominators=["u"]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate
              assert Unit(magnitude="-10.1",numerators=["u","u","u"],denominators=["u","u","u"]).symbols      == ()
              assert Unit(magnitude="-10.1",numerators=["u","u","u"],denominators=["u","u","u"]).numerators   == ()
              assert Unit(magnitude="-10.1",numerators=["u","u","u"],denominators=["u","u","u"]).denominators == ()
              assert Unit(magnitude="-10.1",numerators=["u","u","u"],denominators=["u","u","u"]).magnitude    == Decimal("-10.1")
              # Multiple Different
              assert Unit(magnitude="-10.1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).symbols      == ()
              assert Unit(magnitude="-10.1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(magnitude="-10.1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude="-10.1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).magnitude    == Decimal("-10.1")
              # Partial Canceling
              assert Unit(magnitude="-10.1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).symbols      == (("ub",Decimal(1)),)
              assert Unit(magnitude="-10.1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).numerators   == (("ub",Decimal(1)),)
              assert Unit(magnitude="-10.1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).denominators == ()
              assert Unit(magnitude="-10.1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).magnitude    == Decimal("-10.1")
        # Tuple of String, Exponent
        if(True):
          # Positive Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(magnitude="10.1",symbols=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude="10.1",symbols=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude="10.1",symbols=[("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude="10.1",symbols=[("u",Decimal(1))]).magnitude    == Decimal("10.1")
              # Single Numerator Higher Exponent
              assert Unit(magnitude="10.1",symbols=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude="10.1",symbols=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude="10.1",symbols=[("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude="10.1",symbols=[("u",Decimal(2))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators
              assert Unit(magnitude="10.1",symbols=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude="10.1",symbols=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude="10.1",symbols=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude="10.1",symbols=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(magnitude="10.1",symbols=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(magnitude="10.1",symbols=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(magnitude="10.1",symbols=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude="10.1",symbols=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("10.1")
              # Multiple Different Numerators
              assert Unit(magnitude="10.1",symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="10.1",symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="10.1",symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(magnitude="10.1",symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("10.1")
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(magnitude="10.1",numerators=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude="10.1",numerators=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude="10.1",numerators=[("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude="10.1",numerators=[("u",Decimal(1))]).magnitude    == Decimal("10.1")
              # Single Numerator Higher Exponent
              assert Unit(magnitude="10.1",numerators=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude="10.1",numerators=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude="10.1",numerators=[("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude="10.1",numerators=[("u",Decimal(2))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators
              assert Unit(magnitude="10.1",numerators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude="10.1",numerators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude="10.1",numerators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude="10.1",numerators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(magnitude="10.1",numerators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(magnitude="10.1",numerators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(magnitude="10.1",numerators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude="10.1",numerators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("10.1")
              # Multiple Different Numerators
              assert Unit(magnitude="10.1",numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="10.1",numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="10.1",numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(magnitude="10.1",numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("10.1")
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(magnitude="10.1",denominators=[("u",Decimal(1))]).symbols      == (("u",Decimal(-1)),)
              assert Unit(magnitude="10.1",denominators=[("u",Decimal(1))]).numerators   == ()
              assert Unit(magnitude="10.1",denominators=[("u",Decimal(1))]).denominators == (("u",Decimal(1)),)
              assert Unit(magnitude="10.1",denominators=[("u",Decimal(1))]).magnitude    == Decimal("10.1")
              # Single Numerator Higher Exponent
              assert Unit(magnitude="10.1",denominators=[("u",Decimal(2))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude="10.1",denominators=[("u",Decimal(2))]).numerators   == ()
              assert Unit(magnitude="10.1",denominators=[("u",Decimal(2))]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude="10.1",denominators=[("u",Decimal(2))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators
              assert Unit(magnitude="10.1",denominators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude="10.1",denominators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == ()
              assert Unit(magnitude="10.1",denominators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude="10.1",denominators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(magnitude="10.1",denominators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(-3)),)
              assert Unit(magnitude="10.1",denominators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == ()
              assert Unit(magnitude="10.1",denominators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == (("u",Decimal(3)),)
              assert Unit(magnitude="10.1",denominators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("10.1")
              # Multiple Different Numerators
              assert Unit(magnitude="10.1",denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(magnitude="10.1",denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == ()
              assert Unit(magnitude="10.1",denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="10.1",denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("10.1")
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).numerators   == (("nu",Decimal(1)),)
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).denominators == (("du",Decimal(1)),)
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).magnitude    == Decimal("10.1")
              # Single Numerator and Denominator Higher Exponent
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).numerators   == (("nu",Decimal(2)),)
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).denominators == (("du",Decimal(3)),)
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators and Denominators
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).numerators   == (("nu",Decimal(3)),)
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).denominators == (("du",Decimal(2)),)
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Numerators and Denominators Higher Exponent
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).numerators   == (("nu",Decimal(4)),)
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).denominators == (("du",Decimal(4)),)
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).magnitude    == Decimal("10.1")
              # Multiple Different Numerators and Denominators
              assert Unit(magnitude="10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(magnitude="10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(magnitude="10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
              assert Unit(magnitude="10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).magnitude    == Decimal("10.1")
            # Canceling
            if(True):
              # Single
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).symbols      == ()
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).numerators   == ()
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).denominators == ()
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).magnitude    == Decimal("10.1")
              # Single Higher Exponent
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).symbols      == ()
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).numerators   == ()
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).denominators == ()
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal("10.1")
              # Multiple Duplicate Higher Exponent
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(magnitude="10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal("10.1")
              # Multiple Different
              assert Unit(magnitude="10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).symbols      == ()
              assert Unit(magnitude="10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).numerators   == ()
              assert Unit(magnitude="10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).denominators == ()
              assert Unit(magnitude="10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal("10.1")
              # Partial
              assert Unit(magnitude="10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
              assert Unit(magnitude="10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).numerators   == (("nua",Decimal(1)),)
              assert Unit(magnitude="10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).denominators == (("nub",Decimal(1)),)
              assert Unit(magnitude="10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal("10.1")
          # Negative Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(magnitude="-10.1",symbols=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude="-10.1",symbols=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude="-10.1",symbols=[("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude="-10.1",symbols=[("u",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Single Numerator Higher Exponent
              assert Unit(magnitude="-10.1",symbols=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude="-10.1",symbols=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude="-10.1",symbols=[("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude="-10.1",symbols=[("u",Decimal(2))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators
              assert Unit(magnitude="-10.1",symbols=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude="-10.1",symbols=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude="-10.1",symbols=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude="-10.1",symbols=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(magnitude="-10.1",symbols=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(magnitude="-10.1",symbols=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(magnitude="-10.1",symbols=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude="-10.1",symbols=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("-10.1")
              # Multiple Different Numerators
              assert Unit(magnitude="-10.1",symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="-10.1",symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="-10.1",symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(magnitude="-10.1",symbols=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("-10.1")
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(magnitude="-10.1",numerators=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude="-10.1",numerators=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude="-10.1",numerators=[("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude="-10.1",numerators=[("u",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Single Numerator Higher Exponent
              assert Unit(magnitude="-10.1",numerators=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude="-10.1",numerators=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude="-10.1",numerators=[("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude="-10.1",numerators=[("u",Decimal(2))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators
              assert Unit(magnitude="-10.1",numerators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude="-10.1",numerators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude="-10.1",numerators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude="-10.1",numerators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(magnitude="-10.1",numerators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(3)),)
              assert Unit(magnitude="-10.1",numerators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == (("u",Decimal(3)),)
              assert Unit(magnitude="-10.1",numerators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude="-10.1",numerators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("-10.1")
              # Multiple Different Numerators
              assert Unit(magnitude="-10.1",numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="-10.1",numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="-10.1",numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == ()
              assert Unit(magnitude="-10.1",numerators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("-10.1")
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(magnitude="-10.1",denominators=[("u",Decimal(1))]).symbols      == (("u",Decimal(-1)),)
              assert Unit(magnitude="-10.1",denominators=[("u",Decimal(1))]).numerators   == ()
              assert Unit(magnitude="-10.1",denominators=[("u",Decimal(1))]).denominators == (("u",Decimal(1)),)
              assert Unit(magnitude="-10.1",denominators=[("u",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Single Numerator Higher Exponent
              assert Unit(magnitude="-10.1",denominators=[("u",Decimal(2))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude="-10.1",denominators=[("u",Decimal(2))]).numerators   == ()
              assert Unit(magnitude="-10.1",denominators=[("u",Decimal(2))]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude="-10.1",denominators=[("u",Decimal(2))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators
              assert Unit(magnitude="-10.1",denominators=[("u",Decimal(1)),("u",Decimal(1))]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude="-10.1",denominators=[("u",Decimal(1)),("u",Decimal(1))]).numerators   == ()
              assert Unit(magnitude="-10.1",denominators=[("u",Decimal(1)),("u",Decimal(1))]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude="-10.1",denominators=[("u",Decimal(1)),("u",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators Higher Exponent
              assert Unit(magnitude="-10.1",denominators=[("u",Decimal(1)),("u",Decimal(2))]).symbols      == (("u",Decimal(-3)),)
              assert Unit(magnitude="-10.1",denominators=[("u",Decimal(1)),("u",Decimal(2))]).numerators   == ()
              assert Unit(magnitude="-10.1",denominators=[("u",Decimal(1)),("u",Decimal(2))]).denominators == (("u",Decimal(3)),)
              assert Unit(magnitude="-10.1",denominators=[("u",Decimal(1)),("u",Decimal(2))]).magnitude    == Decimal("-10.1")
              # Multiple Different Numerators
              assert Unit(magnitude="-10.1",denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(magnitude="-10.1",denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).numerators   == ()
              assert Unit(magnitude="-10.1",denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="-10.1",denominators=[("ua",Decimal(1)),("ub",Decimal(2))]).magnitude    == Decimal("-10.1")
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).numerators   == (("nu",Decimal(1)),)
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).denominators == (("du",Decimal(1)),)
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(1))],denominators=[("du",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Single Numerator and Denominator Higher Exponent
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).symbols      == (("du",Decimal(-3)),("nu",Decimal(2)))
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).numerators   == (("nu",Decimal(2)),)
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).denominators == (("du",Decimal(3)),)
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(2))],denominators=[("du",Decimal(3))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators and Denominators
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).numerators   == (("nu",Decimal(3)),)
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).denominators == (("du",Decimal(2)),)
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("du",Decimal(1)),("du",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Numerators and Denominators Higher Exponent
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).symbols      == (("du",Decimal(-4)),("nu",Decimal(4)))
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).numerators   == (("nu",Decimal(4)),)
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).denominators == (("du",Decimal(4)),)
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("du",Decimal(3)),("du",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Multiple Different Numerators and Denominators
              assert Unit(magnitude="-10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).symbols      == (("dua",Decimal(-3)),("dub",Decimal(-1)),("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(magnitude="-10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).numerators   == (("nua",Decimal(3)),("nub",Decimal(1)))
              assert Unit(magnitude="-10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).denominators == (("dua",Decimal(3)),("dub",Decimal(1)))
              assert Unit(magnitude="-10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("dua",Decimal(3)),("dub",Decimal(1))]).magnitude    == Decimal("-10.1")
            # Canceling
            if(True):
              # Single
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).symbols      == ()
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).numerators   == ()
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).denominators == ()
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(1))],denominators=[("nu",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Single Higher Exponent
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).symbols      == ()
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).numerators   == ()
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).denominators == ()
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(2))],denominators=[("nu",Decimal(2))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))],denominators=[("nu",Decimal(1)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Multiple Duplicate Higher Exponent
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).symbols      == ()
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).numerators   == ()
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).denominators == ()
              assert Unit(magnitude="-10.1",numerators=[("nu",Decimal(1)),("nu",Decimal(2)),("nu",Decimal(1))],denominators=[("nu",Decimal(2)),("nu",Decimal(1)),("nu",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Multiple Different
              assert Unit(magnitude="-10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).symbols      == ()
              assert Unit(magnitude="-10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).numerators   == ()
              assert Unit(magnitude="-10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).denominators == ()
              assert Unit(magnitude="-10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nua",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal("-10.1")
              # Partial
              assert Unit(magnitude="-10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).symbols      == (("nua",Decimal(1)),("nub",Decimal(-1)))
              assert Unit(magnitude="-10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).numerators   == (("nua",Decimal(1)),)
              assert Unit(magnitude="-10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).denominators == (("nub",Decimal(1)),)
              assert Unit(magnitude="-10.1",numerators=[("nua",Decimal(1)),("nua",Decimal(2)),("nub",Decimal(1))],denominators=[("nua",Decimal(2)),("nub",Decimal(1)),("nub",Decimal(1))]).magnitude    == Decimal("-10.1")
        # Tuple of Strings
        if(True):
          # Positive Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(magnitude="10e1",symbols=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude="10e1",symbols=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude="10e1",symbols=["u"]).denominators == ()
              assert Unit(magnitude="10e1",symbols=["u"]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators
              assert Unit(magnitude="10e1",symbols=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude="10e1",symbols=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude="10e1",symbols=["u","u"]).denominators == ()
              assert Unit(magnitude="10e1",symbols=["u","u"]).magnitude    == Decimal("10e1")
              # Multiple Different Numerators
              assert Unit(magnitude="10e1",symbols=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="10e1",symbols=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="10e1",symbols=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude="10e1",symbols=["ua","ub","ub"]).magnitude    == Decimal("10e1")
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(magnitude="10e1",numerators=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude="10e1",numerators=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude="10e1",numerators=["u"]).denominators == ()
              assert Unit(magnitude="10e1",numerators=["u"]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators
              assert Unit(magnitude="10e1",numerators=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude="10e1",numerators=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude="10e1",numerators=["u","u"]).denominators == ()
              assert Unit(magnitude="10e1",numerators=["u","u"]).magnitude    == Decimal("10e1")
              # Multiple Different Numerators
              assert Unit(magnitude="10e1",numerators=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="10e1",numerators=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="10e1",numerators=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude="10e1",numerators=["ua","ub","ub"]).magnitude    == Decimal("10e1")
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(magnitude="10e1",denominators=["u"]).symbols      == (("u",Decimal(-1)),)
              assert Unit(magnitude="10e1",denominators=["u"]).numerators   == ()
              assert Unit(magnitude="10e1",denominators=["u"]).denominators == (("u",Decimal(1)),)
              assert Unit(magnitude="10e1",denominators=["u"]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators
              assert Unit(magnitude="10e1",denominators=["u","u"]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude="10e1",denominators=["u","u"]).numerators   == ()
              assert Unit(magnitude="10e1",denominators=["u","u"]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude="10e1",denominators=["u","u"]).magnitude    == Decimal("10e1")
              # Multiple Different Numerators
              assert Unit(magnitude="10e1",denominators=["ua","ub","ub"]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(magnitude="10e1",denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(magnitude="10e1",denominators=["ua","ub","ub"]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="10e1",denominators=["ua","ub","ub"]).magnitude    == Decimal("10e1")
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(magnitude="10e1",numerators=["nu"],denominators=["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(magnitude="10e1",numerators=["nu"],denominators=["du"]).numerators   == (("nu",Decimal(1)),)
              assert Unit(magnitude="10e1",numerators=["nu"],denominators=["du"]).denominators == (("du",Decimal(1)),)
              assert Unit(magnitude="10e1",numerators=["nu"],denominators=["du"]).magnitude    == Decimal("10e1")
              # Multiple Duplicate Numerators and Denominators
              assert Unit(magnitude="10e1",numerators=["nu","nu","nu"],denominators=["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(magnitude="10e1",numerators=["nu","nu","nu"],denominators=["du","du"]).numerators   == (("nu",Decimal(3)),)
              assert Unit(magnitude="10e1",numerators=["nu","nu","nu"],denominators=["du","du"]).denominators == (("du",Decimal(2)),)
              assert Unit(magnitude="10e1",numerators=["nu","nu","nu"],denominators=["du","du"]).magnitude    == Decimal("10e1")
              # Multiple Different Numerators and Denominators
              assert Unit(magnitude="10e1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(magnitude="10e1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(magnitude="10e1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
              assert Unit(magnitude="10e1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).magnitude    == Decimal("10e1")
            # Canceling
            if(True):
              # Single
              assert Unit(magnitude="10e1",numerators=["u"],denominators=["u"]).symbols      == ()
              assert Unit(magnitude="10e1",numerators=["u"],denominators=["u"]).numerators   == ()
              assert Unit(magnitude="10e1",numerators=["u"],denominators=["u"]).denominators == ()
              assert Unit(magnitude="10e1",numerators=["u"],denominators=["u"]).magnitude    == Decimal("10e1")
              # Multiple Duplicate
              assert Unit(magnitude="10e1",numerators=["u","u","u"],denominators=["u","u","u"]).symbols      == ()
              assert Unit(magnitude="10e1",numerators=["u","u","u"],denominators=["u","u","u"]).numerators   == ()
              assert Unit(magnitude="10e1",numerators=["u","u","u"],denominators=["u","u","u"]).denominators == ()
              assert Unit(magnitude="10e1",numerators=["u","u","u"],denominators=["u","u","u"]).magnitude    == Decimal("10e1")
              # Multiple Different
              assert Unit(magnitude="10e1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).symbols      == ()
              assert Unit(magnitude="10e1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(magnitude="10e1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude="10e1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).magnitude    == Decimal("10e1")
              # Partial Canceling
              assert Unit(magnitude="10e1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).symbols      == (("ub",Decimal(1)),)
              assert Unit(magnitude="10e1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).numerators   == (("ub",Decimal(1)),)
              assert Unit(magnitude="10e1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).denominators == ()
              assert Unit(magnitude="10e1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).magnitude    == Decimal("10e1")
          # Negative Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(magnitude="-10e1",symbols=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude="-10e1",symbols=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude="-10e1",symbols=["u"]).denominators == ()
              assert Unit(magnitude="-10e1",symbols=["u"]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators
              assert Unit(magnitude="-10e1",symbols=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude="-10e1",symbols=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude="-10e1",symbols=["u","u"]).denominators == ()
              assert Unit(magnitude="-10e1",symbols=["u","u"]).magnitude    == Decimal("-10e1")
              # Multiple Different Numerators
              assert Unit(magnitude="-10e1",symbols=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="-10e1",symbols=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="-10e1",symbols=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude="-10e1",symbols=["ua","ub","ub"]).magnitude    == Decimal("-10e1")
            # Numerators
            if(True):
              # Single Numerator
              assert Unit(magnitude="-10e1",numerators=["u"]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude="-10e1",numerators=["u"]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude="-10e1",numerators=["u"]).denominators == ()
              assert Unit(magnitude="-10e1",numerators=["u"]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators
              assert Unit(magnitude="-10e1",numerators=["u","u"]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude="-10e1",numerators=["u","u"]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude="-10e1",numerators=["u","u"]).denominators == ()
              assert Unit(magnitude="-10e1",numerators=["u","u"]).magnitude    == Decimal("-10e1")
              # Multiple Different Numerators
              assert Unit(magnitude="-10e1",numerators=["ua","ub","ub"]).symbols      == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="-10e1",numerators=["ua","ub","ub"]).numerators   == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="-10e1",numerators=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude="-10e1",numerators=["ua","ub","ub"]).magnitude    == Decimal("-10e1")
            # Denominators
            if(True):
              # Single Numerator
              assert Unit(magnitude="-10e1",denominators=["u"]).symbols      == (("u",Decimal(-1)),)
              assert Unit(magnitude="-10e1",denominators=["u"]).numerators   == ()
              assert Unit(magnitude="-10e1",denominators=["u"]).denominators == (("u",Decimal(1)),)
              assert Unit(magnitude="-10e1",denominators=["u"]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators
              assert Unit(magnitude="-10e1",denominators=["u","u"]).symbols      == (("u",Decimal(-2)),)
              assert Unit(magnitude="-10e1",denominators=["u","u"]).numerators   == ()
              assert Unit(magnitude="-10e1",denominators=["u","u"]).denominators == (("u",Decimal(2)),)
              assert Unit(magnitude="-10e1",denominators=["u","u"]).magnitude    == Decimal("-10e1")
              # Multiple Different Numerators
              assert Unit(magnitude="-10e1",denominators=["ua","ub","ub"]).symbols      == (("ua",Decimal(-1)),("ub",Decimal(-2)))
              assert Unit(magnitude="-10e1",denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(magnitude="-10e1",denominators=["ua","ub","ub"]).denominators == (("ua",Decimal(1)),("ub",Decimal(2)))
              assert Unit(magnitude="-10e1",denominators=["ua","ub","ub"]).magnitude    == Decimal("-10e1")
            # Numerators and Denominators
            if(True):
              # Single Numerator and Denominator
              assert Unit(magnitude="-10e1",numerators=["nu"],denominators=["du"]).symbols      == (("du",Decimal(-1)),("nu",Decimal(1)))
              assert Unit(magnitude="-10e1",numerators=["nu"],denominators=["du"]).numerators   == (("nu",Decimal(1)),)
              assert Unit(magnitude="-10e1",numerators=["nu"],denominators=["du"]).denominators == (("du",Decimal(1)),)
              assert Unit(magnitude="-10e1",numerators=["nu"],denominators=["du"]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate Numerators and Denominators
              assert Unit(magnitude="-10e1",numerators=["nu","nu","nu"],denominators=["du","du"]).symbols      == (("du",Decimal(-2)),("nu",Decimal(3)))
              assert Unit(magnitude="-10e1",numerators=["nu","nu","nu"],denominators=["du","du"]).numerators   == (("nu",Decimal(3)),)
              assert Unit(magnitude="-10e1",numerators=["nu","nu","nu"],denominators=["du","du"]).denominators == (("du",Decimal(2)),)
              assert Unit(magnitude="-10e1",numerators=["nu","nu","nu"],denominators=["du","du"]).magnitude    == Decimal("-10e1")
              # Multiple Different Numerators and Denominators
              assert Unit(magnitude="-10e1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).symbols      == (("dua",Decimal(-1)),("dub",Decimal(-3)),("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(magnitude="-10e1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).numerators   == (("nua",Decimal(1)),("nub",Decimal(2)))
              assert Unit(magnitude="-10e1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).denominators == (("dua",Decimal(1)),("dub",Decimal(3)))
              assert Unit(magnitude="-10e1",numerators=["nua","nub","nub"],denominators=["dua","dub","dub","dub"]).magnitude    == Decimal("-10e1")
            # Canceling
            if(True):
              # Single
              assert Unit(magnitude="-10e1",numerators=["u"],denominators=["u"]).symbols      == ()
              assert Unit(magnitude="-10e1",numerators=["u"],denominators=["u"]).numerators   == ()
              assert Unit(magnitude="-10e1",numerators=["u"],denominators=["u"]).denominators == ()
              assert Unit(magnitude="-10e1",numerators=["u"],denominators=["u"]).magnitude    == Decimal("-10e1")
              # Multiple Duplicate
              assert Unit(magnitude="-10e1",numerators=["u","u","u"],denominators=["u","u","u"]).symbols      == ()
              assert Unit(magnitude="-10e1",numerators=["u","u","u"],denominators=["u","u","u"]).numerators   == ()
              assert Unit(magnitude="-10e1",numerators=["u","u","u"],denominators=["u","u","u"]).denominators == ()
              assert Unit(magnitude="-10e1",numerators=["u","u","u"],denominators=["u","u","u"]).magnitude    == Decimal("-10e1")
              # Multiple Different
              assert Unit(magnitude="-10e1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).symbols      == ()
              assert Unit(magnitude="-10e1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).numerators   == ()
              assert Unit(magnitude="-10e1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).denominators == ()
              assert Unit(magnitude="-10e1",numerators=["ua","ub","ub"],denominators=["ua","ub","ub"]).magnitude    == Decimal("-10e1")
              # Partial Canceling
              assert Unit(magnitude="-10e1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).symbols      == (("ub",Decimal(1)),)
              assert Unit(magnitude="-10e1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).numerators   == (("ub",Decimal(1)),)
              assert Unit(magnitude="-10e1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).denominators == ()
              assert Unit(magnitude="-10e1",numerators=["ua","ub","ub"],denominators=["ua","ub"]).magnitude    == Decimal("-10e1")
        # Tuple of String, Exponent
        if(True):
          # Positive Magnitude
          if(True):
            # Symbols
            if(True):
              # Single Numerator
              assert Unit(magnitude="10e1",symbols=[("u",Decimal(1))]).symbols      == (("u",Decimal(1)),)
              assert Unit(magnitude="10e1",symbols=[("u",Decimal(1))]).numerators   == (("u",Decimal(1)),)
              assert Unit(magnitude="10e1",symbols=[("u",Decimal(1))]).denominators == ()
              assert Unit(magnitude="10e1",symbols=[("u",Decimal(1))]).magnitude    == Decimal("10e1")
              # Single Numerator Higher Exponent
              assert Unit(magnitude="10e1",symbols=[("u",Decimal(2))]).symbols      == (("u",Decimal(2)),)
              assert Unit(magnitude="10e1",symbols=[("u",Decimal(2))]).numerators   == (("u",Decimal(2)),)
              assert Unit(magnitude="10e1",symbols=[("u",Decimal(2))]).denominators == ()
              assert Unit(magnitude="10e1",symbols=[("u",Decimal(2))]).ma